/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.IMediaFilter;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.api.YMFVideoEncodeFrame;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.ByteVector;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TransmitUploadFilter
implements IMediaFilter {
    private IEncoderListener mLiveSession = null;
    private VideoLiveFilterContext mFilterContext = null;
    private ByteVector mBytesVector = null;
    private long mDeltaPtsDts = 0L;
    byte[] externNaluData = new byte[2];
    private int svcTid;
    private int svcSid;
    private YMFVideoEncodeFrame mVideoEncodeFrame = new YMFVideoEncodeFrame();
    private HashMap<Integer, TransmitUploadInfo> mTransmitUploadInfoMap = new HashMap();

    public TransmitUploadFilter(VideoLiveFilterContext filterContext, IEncoderListener liveSession) {
        this.mFilterContext = filterContext;
        this.mLiveSession = liveSession;
        this.mBytesVector = new ByteVector(4096);
        this.mDeltaPtsDts = YYVideoSDK.getInstance().getDeltaYYPtsMillions();
        YMFLog.info(this, "[Encoder ]", "TransmitUploadFilter mDeltaPtsDts:" + this.mDeltaPtsDts);
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        YMFLiveStatisticManager.getInstance().beginTransmitUpload();
        if (!this.mTransmitUploadInfoMap.containsKey(sample.mStreamId)) {
            TransmitUploadInfo value = new TransmitUploadInfo();
            this.mTransmitUploadInfoMap.put(sample.mStreamId, value);
        }
        this.mBytesVector.reserve(sample.mBufferSize);
        byte[] frameData = this.mBytesVector.getBytes();
        if (sample.mEncoderType == VideoEncoderType.HARD_ENCODER_H264) {
            if (sample.mFrameType == 6 || sample.mFrameType == 5) {
                if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_SCREEN_RECORD) {
                    sample.mDataByteBuffer.rewind();
                    sample.mDataByteBuffer.get(frameData, 0, sample.mBufferSize);
                } else {
                    sample.mDataByteBuffer.rewind();
                    sample.mDataByteBuffer.get(frameData, 0, sample.mBufferSize);
                }
            } else {
                int realFrameLength = sample.mBufferSize - 4;
                frameData[0] = (byte)(realFrameLength >>> 24 & 0xFF);
                frameData[1] = (byte)(realFrameLength >>> 16 & 0xFF);
                frameData[2] = (byte)(realFrameLength >>> 8 & 0xFF);
                frameData[3] = (byte)(realFrameLength & 0xFF);
                sample.mDataByteBuffer.position(sample.mBufferOffset + 4);
                sample.mDataByteBuffer.limit(sample.mBufferOffset + sample.mBufferSize);
                sample.mDataByteBuffer.get(frameData, 4, sample.mBufferSize - 4);
            }
        } else if (sample.mEncoderType != VideoEncoderType.HARD_ENCODER_H265 || sample.mFrameType != 255) {
            if (sample.mEncoderType == VideoEncoderType.SOFT_ENCODER_X264) {
                sample.mDataByteBuffer.rewind();
                sample.mDataByteBuffer.get(frameData, 0, sample.mBufferSize);
            } else if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_SCREEN_RECORD) {
                sample.mDataByteBuffer.rewind();
                sample.mDataByteBuffer.get(frameData, 0, sample.mBufferSize);
            } else {
                sample.mDataByteBuffer.rewind();
                sample.mDataByteBuffer.get(frameData, 0, sample.mBufferSize);
            }
        }
        this.svcTid = 255;
        this.svcSid = 255;
        this.mTransmitUploadInfoMap.get(sample.mStreamId).isSvdData = false;
        if (sample.mEncoderType == VideoEncoderType.SOFT_ENCODER_X264 && sample.mBufferSize >= 6) {
            sample.mDataByteBuffer.rewind();
            sample.mDataByteBuffer.position(4);
            sample.mDataByteBuffer.get(this.externNaluData, 0, 2);
            if ((this.externNaluData[0] & 0x1F) == 14) {
                this.svcSid = this.externNaluData[1] >>> 3 & 7;
                this.svcTid = this.externNaluData[1] & 7;
                if (this.svcSid != 255 || this.svcTid != 255) {
                    this.mTransmitUploadInfoMap.get(sample.mStreamId).isSvdData = true;
                }
            }
        }
        if (!sample.isUsePbo) {
            this.mVideoEncodeFrame.pts = sample.mYYPtsMillions + this.mDeltaPtsDts;
            this.mVideoEncodeFrame.dts = sample.mDtsMillions + this.mDeltaPtsDts;
        } else {
            this.mVideoEncodeFrame.pts = sample.mYYPtsMillions + this.mDeltaPtsDts - sample.mFrameDeltaDts;
            this.mVideoEncodeFrame.dts = sample.mDtsMillions + this.mDeltaPtsDts - sample.mFrameDeltaDts;
        }
        this.mVideoEncodeFrame.svcSid = this.svcSid;
        this.mVideoEncodeFrame.svcTid = this.svcTid;
        this.mVideoEncodeFrame.data = frameData;
        this.mVideoEncodeFrame.len = sample.mBufferSize;
        this.mVideoEncodeFrame.width = sample.mWidth;
        this.mVideoEncodeFrame.height = sample.mHeight;
        this.mVideoEncodeFrame.streamId = sample.mStreamId;
        this.mVideoEncodeFrame.frameType = sample.mFrameType;
        this.mVideoEncodeFrame.encodeType = sample.mEncoderType;
        this.mLiveSession.onEncodeFrameData(this.mVideoEncodeFrame);
        this.mBytesVector.clear();
        if (sample.mFrameType != 6 && sample.mFrameType != 5) {
            this.mTransmitUploadInfoMap.get(sample.mStreamId).printfDeltaPts(sample.mYYPtsMillions);
            this.mTransmitUploadInfoMap.get(sample.mStreamId).calcDeltaMaxPtsDts(sample.mStreamId, sample.mYYPtsMillions, sample.mDtsMillions);
        }
        this.mTransmitUploadInfoMap.get(sample.mStreamId).calcEncodeInfo(sample);
        YMFLiveStatisticManager.getInstance().endTransmitUpload();
        return false;
    }

    private class TransmitUploadInfo {
        public int bitRate;
        public int fps;
        public int keyFrames;
        public long lastEncodeRecordTime = 0L;
        public long lastFrameTime = 0L;
        public int count = 0;
        public long mLastPts = 0L;
        public long mLastPrintTime = 0L;
        private long mMaxDeltaEncodeTime = 0L;
        private List<Long> mDeltaPtsList = new ArrayList<Long>();
        private long mMaxDeltaPts = 0L;
        private boolean isSvdData = false;

        private TransmitUploadInfo() {
        }

        private void printfDeltaPts(long pts) {
            long now = System.currentTimeMillis();
            if (this.mLastPts == 0L) {
                this.mLastPrintTime = now;
                this.mLastPts = pts;
            } else {
                this.mDeltaPtsList.add(pts - this.mLastPts);
                this.mMaxDeltaPts = this.mMaxDeltaPts < pts - this.mLastPts ? pts - this.mLastPts : this.mMaxDeltaPts;
                this.mLastPts = pts;
                if (now - this.mLastPrintTime >= 3000L) {
                    String str = " " + pts + " ";
                    for (int i = 0; i < this.mDeltaPtsList.size(); ++i) {
                        str = str + this.mDeltaPtsList.get(i) + ",";
                    }
                    YMFLog.info(this, "[Encoder ]", "TransmitUploadFilter printfDeltaPts [" + str + "]MAX:" + this.mMaxDeltaPts + " in " + this.mDeltaPtsList.size());
                    this.mDeltaPtsList.clear();
                    this.mLastPrintTime = now;
                    this.mMaxDeltaPts = 0L;
                }
            }
        }

        public void calcDeltaMaxPtsDts(int streamId, long pts, long dts) {
            long delta = Math.abs(pts - dts);
            YMFLiveStatisticManager.getInstance().setVideoPtsDtsMaxDiff(streamId, (int)delta);
        }

        public void calcEncodeInfo(YYMediaSample sample) {
            int streamId = sample.mStreamId;
            long now = System.currentTimeMillis();
            if (this.lastEncodeRecordTime == 0L || this.lastFrameTime == 0L) {
                this.lastEncodeRecordTime = now;
                this.lastFrameTime = now;
                return;
            }
            long delta = Math.abs(now - this.lastFrameTime);
            this.lastFrameTime = now;
            YMFLiveStatisticManager.getInstance().setVideoEncodeTimeDiff(sample.mStreamId, (int)delta);
            long l = this.mMaxDeltaEncodeTime = delta >= this.mMaxDeltaEncodeTime ? delta : this.mMaxDeltaEncodeTime;
            if (now - this.lastEncodeRecordTime >= 1000L) {
                if (this.count == 10) {
                    YMFLog.info(this, "[Encoder ]", "mStreamId\uff1a" + sample.mStreamId + ",publishVideoFrameBuffer bitRate:" + this.bitRate * 8 + "bps, fps:" + this.fps + ", 6s keyFrames:" + this.keyFrames + ",isSvc " + this.isSvdData);
                    this.count = 0;
                }
                ++this.count;
                YMFLiveStatisticManager.getInstance().setVideoRealBitrate(sample.mStreamId, this.bitRate * 8 / 1000);
                YMFLiveStatisticManager.getInstance().setVideoRealEncodeFps(sample.mStreamId, this.fps);
                this.fps = 0;
                this.keyFrames = 0;
                this.bitRate = 0;
                this.lastEncodeRecordTime = System.currentTimeMillis();
            }
            ++this.fps;
            this.bitRate += sample.mBufferSize;
        }
    }
}

