/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.opengl.GLES20;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.PreviewFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.utils.GLUtil;

public class ScreenShotFilter
extends AbstractYYMediaFilter {
    private static final String TAG = "ScreenShotFilter";
    private VideoLiveFilterContext mFilterContext;
    private int mOffScreenFrameBuffer = -1;
    private int mOffScreenTextureId = -1;
    private int mTextureWidth = 0;
    private int mTextureHeight = 0;
    private boolean mInited = false;

    public void init(int width, int height) {
        if (!this.mInited) {
            this.initScreenShotGlEnv(width, height);
            this.mInited = true;
        }
    }

    @Override
    public void deInit() {
        this.deInitScreenShotGlEnv();
    }

    private void initScreenShotGlEnv(int width, int height) {
        this.mOffScreenTextureId = GLUtil.genTexture(3553, width, height);
        int[] frameBuffers = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
        this.mOffScreenFrameBuffer = frameBuffers[0];
        GLES20.glBindFramebuffer((int)36160, (int)this.mOffScreenFrameBuffer);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mOffScreenTextureId, (int)0);
    }

    private void deInitScreenShotGlEnv() {
        if (this.mOffScreenTextureId > 0) {
            int[] textures = new int[]{this.mOffScreenTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mOffScreenTextureId = -1;
        }
        if (this.mOffScreenFrameBuffer > 0) {
            int[] framebuffers = new int[]{this.mOffScreenFrameBuffer};
            GLES20.glDeleteFramebuffers((int)1, (int[])framebuffers, (int)0);
            this.mOffScreenFrameBuffer = -1;
        }
    }

    public ScreenShotFilter(VideoLiveFilterContext context) {
        this.mFilterContext = context;
    }

    private void takePreviewShot(YYMediaSample sample, Object upStream) {
        if (this.mOffScreenTextureId == -1 || this.mTextureWidth != sample.mClipWidth || this.mTextureHeight != sample.mClipHeight) {
            this.deInitScreenShotGlEnv();
            this.initScreenShotGlEnv(sample.mClipWidth, sample.mClipHeight);
            this.mTextureWidth = sample.mClipWidth;
            this.mTextureHeight = sample.mClipHeight;
        }
        if (this.mFilterContext.getScreenShot() != null && this.mFilterContext.getScreenShot().getScreenState()) {
            GLES20.glViewport((int)0, (int)0, (int)sample.mClipWidth, (int)sample.mClipHeight);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20.glClear((int)16384);
            GLES20.glBindFramebuffer((int)36160, (int)this.mOffScreenFrameBuffer);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mOffScreenTextureId, (int)0);
            if (upStream != null && upStream instanceof PreviewFilter) {
                ((PreviewFilter)upStream).drawVideo(sample, false);
                this.mFilterContext.getScreenShot().takeScreenShot(sample);
            }
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        sample.addRef();
        this.takePreviewShot(sample, upstream);
        sample.decRef();
        return false;
    }
}

