/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.opengl.GLES20;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.ScreenShotFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.Drawable2d;
import com.yy.mediaframework.gles.EglFactory;
import com.yy.mediaframework.gles.FullFrameRect;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gles.IWindowSurface;
import com.yy.mediaframework.gles.Texture2dProgram;
import com.yy.mediaframework.model.AbstractSurfaceInfo;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.GLUtil;
import com.yy.mediaframework.utils.VideoEntities;
import com.yy.mediaframework.utils.VideoSizeUtils;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.FloatBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class PreviewFilter
extends AbstractYYMediaFilter {
    private VideoLiveFilterContext mFilterContext;
    private AtomicBoolean mInited = new AtomicBoolean(false);
    private static final String TAG = "PreviewFilter";
    private boolean mLastMirrorFlag = true;
    private boolean mFirstFrameRenderd = false;
    private AbstractSurfaceInfo mSurfaceInfo = null;
    private Constant.ScaleMode mScaleMode = Constant.ScaleMode.AspectFill;
    private IWindowSurface mPreviewWindowSurface = null;
    private FullFrameRect mPreviewScreen = null;
    private VideoEntities.VideoSizes mVideoSizes = new VideoEntities.VideoSizes();
    private int mViewPortX = 0;
    private int mViewPortY = 0;
    private int mViewPortW = 0;
    private int mViewPortH = 0;
    private int mClearCount = 0;
    private long feedFrameCounter = 0L;
    private long feedCurrentTime = 0L;
    private long lastRenderTime = 0L;
    private boolean hasCatchException = false;
    private int mInputWidth = 0;
    private int mInputHeight = 0;
    private int mClipWidth = 0;
    private int mClipHeight = 0;
    private YYMediaSample mSample = new YYMediaSample();
    private AtomicBoolean mDrawBlackScreen = new AtomicBoolean(false);
    private boolean mCurrentDrawBlack = true;
    private boolean mVideoPreviewStatusFlag = true;
    private ScreenShotFilter mScreenShotFilter;

    public PreviewFilter(VideoLiveFilterContext fitlerContext) {
        this.mFilterContext = fitlerContext;
        this.mScreenShotFilter = new ScreenShotFilter(fitlerContext);
    }

    public void init(int width, int height) {
        if (this.mInited.get()) {
            YMFLog.info(this, "[Preview ]", "Init previewFilter: intialized state now, so return");
            return;
        }
        YMFLog.info(this, "[Preview ]", "Init PreviewFilter begin.");
        this.mPreviewScreen = new FullFrameRect(new Texture2dProgram(Texture2dProgram.ProgramType.TEXTURE_2D_WITH_EXTRA_TXT_2), Drawable2d.Prefab.FULL_RECTANGLE, GlUtil.createFloatBuffer(Drawable2d.FULL_RECTANGLE_TEX_COORDS), GlUtil.createFloatBuffer(Drawable2d.FULL_RECTANGLE_TEX_COORDS));
        this.setPreviewFlipY();
        this.setOutputSize(width, height);
        this.mInited.set(true);
        YMFLog.info(this, "[Preview ]", "Init PreviewFilter done.");
    }

    @Override
    public void deInit() {
        if (!this.mInited.getAndSet(false)) {
            YMFLog.info(this, "[Preview ]", "DeInit PreviewFilter: no Initialied state now, so return");
            return;
        }
        YMFLog.info(this, "[Preview ]", "DeInit PreviewFilter");
        this.releasePreviewStaffs();
        if (this.mPreviewScreen != null) {
            this.mPreviewScreen.release(true);
            this.mPreviewScreen = null;
            this.mInputWidth = 0;
            this.mInputHeight = 0;
            this.mClipWidth = 0;
            this.mClipHeight = 0;
        }
        if (this.mScreenShotFilter != null) {
            this.mScreenShotFilter.deInit();
        }
    }

    public void reSetPreviewState() {
        this.mFirstFrameRenderd = false;
    }

    private void checkVideoSize() {
        if (this.mImageWidth != this.mVideoSizes.mVideoWidth || this.mImageHeight != this.mVideoSizes.mVideoHeight) {
            this.mVideoSizes.mVideoHeight = this.mImageHeight;
            this.mVideoSizes.mVideoWidth = this.mImageWidth;
            this.updateVideoPosition();
        }
    }

    public void setScaleMode(Constant.ScaleMode scaleMode) {
        this.mScaleMode = scaleMode;
        YMFLog.info(this, "[Preview ]", "PreviewFilter setScaleMode:" + (Object)((Object)scaleMode));
        this.updateVideoPosition();
    }

    public void drawBlackScreen(boolean block) {
        YMFLog.info(this, "[Preview ]", "drawBlackScreen " + block);
        this.mDrawBlackScreen.set(block);
        if (Thread.currentThread().getId() == this.mFilterContext.getGlManager().getThreadId()) {
            this.handleDrawBlackScreen();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    PreviewFilter.this.handleDrawBlackScreen();
                }
            });
        }
    }

    private void handleDrawBlackScreen() {
        if (this.mDrawBlackScreen.get()) {
            this.mFilterContext.mSurfaceDestoryStateLock.lock();
            if (this.mPreviewWindowSurface != null && !this.mFilterContext.mSurfaceDestoryState.get()) {
                try {
                    this.mPreviewWindowSurface.makeCurrent();
                    if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_PERIPHERALS) {
                        GLES20.glViewport((int)this.mVideoSizes.mViewX, (int)this.mVideoSizes.mViewY, (int)this.mVideoSizes.mVideoSurfaceWidth, (int)this.mVideoSizes.mVideoSurfaceHeight);
                    } else {
                        GLES20.glViewport((int)this.mVideoSizes.mViewX, (int)this.mVideoSizes.mViewY, (int)this.mVideoSizes.mViewWidth, (int)this.mVideoSizes.mViewHeight);
                    }
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GLES20.glClear((int)16640);
                    this.mPreviewWindowSurface.swapBuffers();
                    this.mCurrentDrawBlack = true;
                }
                catch (Throwable t) {
                    YMFLog.error((Object)this, "[Preview ]", "handleDrawBlackScreen:" + t.getMessage());
                    this.mFilterContext.mSurfaceDestoryStateLock.unlock();
                    this.releasePreviewStaffs();
                    return;
                }
            }
            this.mFilterContext.mSurfaceDestoryStateLock.unlock();
            this.mVideoPreviewStatusFlag = true;
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (!this.mInited.get()) {
            return false;
        }
        if (sample.mStreamId == 0) {
            YMFLiveStatisticManager.getInstance().beginPreview();
        }
        this.mSample.assigne(sample);
        sample.addRef();
        if (this.checkImageSizeUpdated(sample.mClipWidth, sample.mClipHeight, true)) {
            this.checkVideoSize();
        }
        if (this.mScreenShotFilter != null) {
            this.mScreenShotFilter.init(sample.mClipWidth, sample.mClipHeight);
        }
        if (this.mFilterContext != null) {
            if (this.mCurrentDrawBlack && this.mDrawBlackScreen.get()) {
                sample.decRef();
                sample.decRef();
                return false;
            }
            this.mFilterContext.mSurfaceDestoryStateLock.lock();
            if (this.mPreviewWindowSurface != null && !this.mFilterContext.mSurfaceDestoryState.get()) {
                try {
                    this.mFilterContext.mViewState = 0;
                    this.mPreviewWindowSurface.makeCurrent();
                    this.drawVideo(sample, true);
                    if (!this.mFirstFrameRenderd) {
                        YMFLiveUsrBehaviorStat.getInstance().notifyFirstFrameRendered();
                        this.mFirstFrameRenderd = true;
                    }
                    if (this.mFilterContext.mDeliverCallback != null && this.mVideoPreviewStatusFlag) {
                        this.mFilterContext.mDeliverCallback.onRenderFirstFrame();
                        this.mVideoPreviewStatusFlag = false;
                    }
                    this.mPreviewWindowSurface.swapBuffers();
                    this.mCurrentDrawBlack = false;
                }
                catch (Throwable t) {
                    YMFLog.error((Object)this, "[Preview ]", "processMediaSample exception:" + t.getMessage());
                    this.mFilterContext.mSurfaceDestoryStateLock.unlock();
                    this.hasCatchException = true;
                    this.releasePreviewStaffs();
                    sample.decRef();
                    return false;
                }
                if (!this.hasCatchException) {
                    ++this.feedFrameCounter;
                    this.feedCurrentTime = System.currentTimeMillis();
                    if (this.feedCurrentTime - this.lastRenderTime >= 1000L) {
                        VideoDataStat.getInstance().setPreviewFrameRate(this.feedFrameCounter);
                        this.lastRenderTime = this.feedCurrentTime;
                        this.feedFrameCounter = 0L;
                    }
                }
            } else {
                this.mFilterContext.mViewState = 4;
            }
        }
        this.mFilterContext.mSurfaceDestoryStateLock.unlock();
        this.addDownStream(this.mScreenShotFilter);
        if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_EXTERNAL) {
            sample.decRef();
            return false;
        }
        if (sample.mStreamId == 0) {
            YMFLiveStatisticManager.getInstance().calcPurePreviewLatency();
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        return false;
    }

    public void drawVideo(YYMediaSample sample, boolean bPreview) {
        if (bPreview) {
            if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_PERIPHERALS) {
                GLES20.glViewport((int)this.mVideoSizes.mViewX, (int)this.mVideoSizes.mViewY, (int)this.mVideoSizes.mVideoSurfaceWidth, (int)this.mVideoSizes.mVideoSurfaceHeight);
            } else {
                GLES20.glViewport((int)this.mVideoSizes.mViewX, (int)this.mVideoSizes.mViewY, (int)this.mVideoSizes.mViewWidth, (int)this.mVideoSizes.mViewHeight);
            }
        } else {
            GLES20.glViewport((int)0, (int)0, (int)sample.mClipWidth, (int)sample.mClipHeight);
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        if (this.checkClipRatioChanged(sample.mWidth, sample.mHeight, sample.mClipWidth, sample.mClipHeight)) {
            YMFLog.info(this, "[Preview ]", "VideoSize X:" + this.mVideoSizes.mViewX + " Y:" + this.mVideoSizes.mViewY + " width:" + this.mVideoSizes.mViewWidth + " height:" + this.mVideoSizes.mViewHeight);
            YMFLog.info(this, "[Preview ]", "sample width:" + sample.mWidth + " height:" + sample.mHeight + " clip width:" + sample.mClipWidth + " clip height:" + sample.mClipHeight);
            YMFLog.warn(this, "[Preview ]", "adjustTexture preview..");
            this.mPreviewScreen.adjustTexture(sample.mWidth, sample.mHeight, sample.mClipWidth, sample.mClipHeight);
        }
        this.mPreviewScreen.resetFlip();
        if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_DUALCAMERA) {
            GLUtil.updateVertexBuffer(this.mSlaveVertexBuffer, sample.mPictureInPictureDisplayInfo);
            this.flip(sample, bPreview);
            this.mPreviewScreen.drawFrame(sample.mMasterTextureId, sample.mMainTransformer, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), sample.mSlaveTextureId, sample.mSlaveTransformer, this.mSlaveVertexBuffer, GlUtil.adjustDualCameraSlaveTexture(sample, this.mFilterContext.mCameraPreviewConfig.getWidth(), this.mFilterContext.mCameraPreviewConfig.getHeight()));
        } else if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_PERIPHERALS) {
            this.drawPeripherals(sample);
        } else {
            this.flip(sample, bPreview);
            this.mPreviewScreen.drawFrame(sample.mMasterTextureId, sample.mMainTransformer, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), sample.mSlaveTextureId, null, null, !bPreview);
        }
    }

    private void drawPeripherals(YYMediaSample sample) {
        FloatBuffer peripheralsVertexCoord = this.mFilterContext.mPeripheralsPosition.getPositionBuffer(false);
        FloatBuffer peripheralsTexCoord = GlUtil.setFlipY(this.mFilterContext.mPeripheralsPosition.getDefaultTextureBuffer());
        if (this.mFilterContext.mPeripheralsPosition.fillMode == 1) {
            peripheralsVertexCoord = this.mFilterContext.mPeripheralsPosition.convertPositionBuffer(sample.mEncodeWidth, sample.mEncodeHeight, this.mFilterContext.mPeripheralsPosition.srcWidth, this.mFilterContext.mPeripheralsPosition.srcHeight);
            peripheralsTexCoord = this.mFilterContext.mPeripheralsPosition.getDefaultTextureBuffer();
        }
        this.mPreviewScreen.drawFrame(this.mFilterContext.getBackgroundTextureId(), sample.mMainTransformer, -1, this.mFilterContext.getDynamicTextureID(), sample.mSlaveTextureId, sample.mSlaveTransformer, peripheralsVertexCoord, peripheralsTexCoord);
        FloatBuffer textureBuffer = this.mFilterContext.mCameraPostion.getDefaultTextureBuffer();
        if (this.mFilterContext.mCameraPostion.fillMode == 2) {
            int dstWidth = 1;
            int dstHeight = 1;
            if (this.mFilterContext.mCameraPostion.dstWidth != 0 && this.mFilterContext.mCameraPostion.dstHeight != 0) {
                dstWidth = this.mFilterContext.mCameraPostion.dstWidth;
                dstHeight = this.mFilterContext.mCameraPostion.dstHeight;
            }
            textureBuffer = GlUtil.setFlipY(this.mFilterContext.mCameraPostion.convertTextureBuffer(dstWidth, dstHeight, this.mFilterContext.mCameraPostion.srcWidth, this.mFilterContext.mCameraPostion.srcHeight));
        }
        this.mPreviewScreen.drawFrame(sample.mMasterTextureId, this.mFilterContext.mCameraPostion.getPositionBuffer(false), textureBuffer, sample.mMainTransformer, -1, -1, -1, null, null, null, false);
    }

    public void flip(YYMediaSample sample, boolean bPreview) {
        if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_DUALCAMERA) {
            this.mPreviewScreen.resetFlip();
            if (sample.mCameraFacing == 1) {
                if (sample.mOrientation == 2) {
                    if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                        this.mPreviewScreen.flipXScreen();
                    }
                } else if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                    this.mPreviewScreen.flipYScreen();
                }
            } else if (sample.mOrientation == 2) {
                if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                    this.mPreviewScreen.flipXScreen();
                }
            } else if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                this.mPreviewScreen.flipYScreen();
            }
        } else if (sample.mCameraFacing == 1) {
            if (!sample.mIsPreviewMirrorEnable) {
                this.mPreviewScreen.flipXMasterPicture();
            }
            if (!bPreview) {
                if (!sample.mIsPreviewMirrorEnable) {
                    this.mPreviewScreen.flipXYScreen(false);
                } else {
                    this.mPreviewScreen.flipYScreen(true);
                }
            }
        } else {
            this.mPreviewScreen.resetFlip();
            if (!bPreview) {
                this.mPreviewScreen.flipYScreen(false);
            }
        }
    }

    public void flip(YYMediaSample sample) {
        if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_DUALCAMERA) {
            this.mPreviewScreen.resetFlip();
            if (sample.mCameraFacing == 1) {
                if (sample.mOrientation == 2) {
                    if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                        this.mPreviewScreen.flipXScreen();
                    }
                } else if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                    this.mPreviewScreen.flipYScreen();
                }
            } else if (sample.mOrientation == 2) {
                if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                    this.mPreviewScreen.flipXScreen();
                }
            } else if (sample.mOrginalCameraFacing != sample.mCameraFacing) {
                this.mPreviewScreen.flipYScreen();
            }
        } else if (sample.mCameraFacing == 1) {
            if (!sample.mIsPreviewMirrorEnable) {
                this.mPreviewScreen.flipXMasterPicture();
            }
        } else {
            this.mPreviewScreen.resetFlip();
        }
    }

    private boolean checkClipRatioChanged(int inputWidth, int inputHeight, int clipWidth, int clipHeight) {
        boolean ret = false;
        if (this.mInputWidth != inputWidth || this.mInputHeight != inputHeight || this.mClipWidth != clipWidth || this.mClipHeight != clipHeight) {
            YMFLog.info(this, "[Preview ]", "checkClipRatioChanged inputWidth:" + inputWidth + " inputHeight:" + inputHeight + " clipWidth:" + clipWidth + " clipHeight:" + clipHeight);
            this.mInputWidth = inputWidth;
            this.mInputHeight = inputHeight;
            this.mClipWidth = clipWidth;
            this.mClipHeight = clipHeight;
            ret = true;
        }
        return ret;
    }

    private void setPreviewFlipY() {
        if (this.mPreviewScreen != null) {
            YMFLog.info(TAG, "[Preview ]", "preview setPreviewFlipY");
            this.mPreviewScreen.setTextureFlipY(0);
            this.mPreviewScreen.setTextureFlipY(1);
            this.mPreviewScreen.setTextureFlipY(2);
        }
    }

    private void releasePreviewStaffs() {
        if (this.mFilterContext != null) {
            this.mFilterContext.mSurfaceDestoryStateLock.lock();
            if (this.mPreviewWindowSurface != null) {
                this.mFilterContext.getGlManager().resetContext();
                this.mPreviewWindowSurface.release();
                this.mPreviewWindowSurface = null;
                YMFLog.info(this, "[Preview ]", "release prview window surface!!");
            }
            this.mFilterContext.mSurfaceDestoryStateLock.unlock();
        }
    }

    private void updateVideoPosition() {
        VideoSizeUtils.Size si = VideoSizeUtils.CalcFitSize(this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight, this.mVideoSizes.mVideoSurfaceWidth, this.mVideoSizes.mVideoSurfaceHeight, this.mScaleMode);
        this.mVideoSizes.mViewX = si.x;
        this.mVideoSizes.mViewY = si.y;
        if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_PERIPHERALS) {
            this.mVideoSizes.mViewY = 0;
        }
        this.mVideoSizes.mViewWidth = si.width;
        this.mVideoSizes.mViewHeight = si.height;
        YMFLog.info(this, "[Preview ]", "updateVideoPosition surfaceWidth:" + this.mVideoSizes.mVideoSurfaceWidth + " surfaceHeight:" + this.mVideoSizes.mVideoSurfaceHeight);
        YMFLog.info(this, "[Preview ]", "updateVideoPosition, View.x:" + this.mVideoSizes.mViewX + " View.y:" + this.mVideoSizes.mViewY + " ViewWidth:" + this.mVideoSizes.mViewWidth + " ViewHeight:" + this.mVideoSizes.mViewHeight);
    }

    private void handleSurfaceChanged(AbstractSurfaceInfo sfInfo) {
        try {
            this.releasePreviewStaffs();
            this.mSurfaceInfo = sfInfo;
            this.mPreviewWindowSurface = EglFactory.newWindowSurface(this.mFilterContext.getGlManager().getEglCore(), this.mSurfaceInfo, false);
            this.mVideoSizes.mVideoSurfaceWidth = sfInfo.mWidth;
            this.mVideoSizes.mVideoSurfaceHeight = sfInfo.mHeight;
            YMFLog.info(this, "[Preview ]", "create preview window surface!!");
            this.updateVideoPosition();
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Preview ]", "handleSurfaceChanged exception:" + t.getMessage());
        }
    }

    public void setSurfaceChanged(int w, int h) {
        this.mVideoSizes.mVideoSurfaceWidth = w;
        this.mVideoSizes.mVideoSurfaceHeight = h;
        this.updateVideoPosition();
        if (this.mFilterContext != null) {
            this.mFilterContext.mSurfaceDestoryStateLock.lock();
            for (int i = 0; i < 2; ++i) {
                GLES20.glClear((int)16640);
                if (this.mPreviewWindowSurface == null || this.mFilterContext.mSurfaceDestoryState.get()) continue;
                try {
                    this.mPreviewWindowSurface.makeCurrent();
                    GLES20.glViewport((int)this.mVideoSizes.mViewX, (int)this.mVideoSizes.mViewY, (int)this.mVideoSizes.mVideoSurfaceWidth, (int)this.mVideoSizes.mVideoSurfaceHeight);
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GLES20.glClear((int)16640);
                    if (this.checkClipRatioChanged(this.mSample.mWidth, this.mSample.mHeight, this.mSample.mClipWidth, this.mSample.mClipHeight)) {
                        YMFLog.warn(this, "[Preview ]", "setSurfaceChanged adjustTexture preview..");
                        this.mPreviewScreen.adjustTexture(this.mSample.mWidth, this.mSample.mHeight, this.mSample.mClipWidth, this.mSample.mClipHeight);
                    }
                    YMFLog.info(this, "[Preview ]", "setSurfaceChanged VideoSize X:" + this.mVideoSizes.mViewX + " Y:" + this.mVideoSizes.mViewY + " width:" + this.mVideoSizes.mVideoSurfaceWidth + " height:" + this.mVideoSizes.mVideoSurfaceHeight);
                    YMFLog.info(this, "[Preview ]", "setSurfaceChanged sample width:" + this.mSample.mWidth + " height:" + this.mSample.mHeight + " clip width:" + this.mSample.mClipWidth + " clip height:" + this.mSample.mClipHeight);
                    this.mPreviewScreen.resetFlip();
                    if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_DUALCAMERA) {
                        GLUtil.updateVertexBuffer(this.mSlaveVertexBuffer, this.mSample.mPictureInPictureDisplayInfo);
                        this.flip(this.mSample);
                        this.mPreviewScreen.drawFrame(this.mSample.mMasterTextureId, this.mSample.mMainTransformer, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), this.mSample.mSlaveTextureId, this.mSample.mSlaveTransformer, this.mSlaveVertexBuffer, GlUtil.adjustDualCameraSlaveTexture(this.mSample, this.mFilterContext.mCameraPreviewConfig.getWidth(), this.mFilterContext.mCameraPreviewConfig.getHeight()));
                    } else if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_PERIPHERALS) {
                        this.drawPeripherals(this.mSample);
                    } else {
                        this.mPreviewScreen.drawFrame(this.mSample.mMasterTextureId, this.mSample.mMainTransformer, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), this.mSample.mSlaveTextureId, null, null);
                    }
                    this.mPreviewWindowSurface.swapBuffers();
                    YMFLog.info(this, "[Preview ]", "setSurfaceChanged preview draw frame OK just in arena model");
                    continue;
                }
                catch (Throwable t) {
                    YMFLog.error((Object)this, "[Preview ]", "setSurfaceChanged exception:" + t.toString());
                    this.mFilterContext.mSurfaceDestoryStateLock.unlock();
                    this.releasePreviewStaffs();
                }
            }
            this.mFilterContext.mSurfaceDestoryStateLock.unlock();
        }
    }

    public void onSurfaceChanged(final AbstractSurfaceInfo sfInfo) {
        YMFLog.info(this, "[Preview ]", "onSurfaceChanged change, width:" + sfInfo.mWidth + " height:" + sfInfo.mHeight);
        if (Thread.currentThread().getId() == this.mFilterContext.getGlManager().getThreadId()) {
            this.handleSurfaceChanged(sfInfo);
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    PreviewFilter.this.handleSurfaceChanged(sfInfo);
                }
            });
        }
    }

    private void handleSurfaceDestroy() {
        this.releasePreviewStaffs();
        this.mSurfaceInfo = null;
    }

    public void onSurfaceDestroy() {
        YMFLog.info(this, "[Preview ]", "onSurfaceDestroy...");
        if (Thread.currentThread().getId() == this.mFilterContext.getGlManager().getThreadId()) {
            this.handleSurfaceDestroy();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    PreviewFilter.this.handleSurfaceDestroy();
                }
            });
        }
    }
}

