/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import com.yy.mediaframework.YMFStreamSyncSourceManager;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gpuimage.util.GLShaderProgram;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.model.YYMediaSampleAlloc;
import com.yy.mediaframework.utils.GLUtil;
import com.yy.mediaframework.utils.OESTO2DTool;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class OriginDataEntryFilter
extends AbstractYYMediaFilter
implements SurfaceTexture.OnFrameAvailableListener {
    private static final String TAG = "OriginDataEntryFilter";
    private VideoLiveFilterContext mVideoLiveFilterContext;
    private OESTO2DTool mOESTO2DTool = null;
    private int mTextureId_y = -1;
    private int mTextureId_u = -1;
    private int mTextureId_v = -1;
    private int mTextureId_rgba = -1;
    private int mTextureId_uv = -1;
    private ByteBuffer buffer_y;
    private ByteBuffer buffer_u;
    private ByteBuffer buffer_v;
    private ByteBuffer buffer_uv;
    private ByteBuffer buffer_rgba;
    private int mScaleMode = 1;
    private boolean mReady = false;
    private byte[] mInputOriginData = null;
    public static final int ORIGIN_PIC_FORMAT_RGBA = 0;
    public static final int ORIGIN_PIC_FORMAT_I420 = 1;
    public static final int ORIGIN_PIC_FORMAT_NV21 = 2;
    private AtomicInteger mSrcWidth = new AtomicInteger(0);
    private AtomicInteger mSrcHeight = new AtomicInteger(0);
    private AtomicInteger mRotation = new AtomicInteger(-1);
    private AtomicInteger mFormat = new AtomicInteger(-1);
    private int mDstWidth = 0;
    private int mDstHeight = 0;
    private GLShaderProgram mRGBAShader = null;
    private GLShaderProgram mI420Shader = null;
    private GLShaderProgram mNV21Shader = null;
    private static final float[] FULL_RECTANGLE_COORDS_180 = new float[]{1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
    private static final float[] FULL_RECTANGLE_COORDS = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] FULL_RECTANGLE_COORDS_90 = new float[]{-1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f};
    private static final float[] FULL_RECTANGLE_COORDS_270 = new float[]{1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f};
    private static final float[] FULL_RECTANGLE_TEX_COORDS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private static FloatBuffer FULL_RECTANGLE_VERT_BUF = null;
    private static final FloatBuffer FULL_RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(FULL_RECTANGLE_TEX_COORDS);
    private FloatBuffer mVertexCoordinate = null;
    public static final String i420_fs = "precision highp float;varying vec2 vTextureCoord;uniform sampler2D tex_y;uniform sampler2D tex_u;uniform sampler2D tex_v;void main() {    vec3 yuv;    yuv.x = texture2D(tex_y, vTextureCoord).r;    yuv.y = texture2D(tex_u, vTextureCoord).r - 0.5;    yuv.z = texture2D(tex_v, vTextureCoord).r - 0.5;    yuv.x = 1.1643 * yuv.x - 0.0728;    vec3 rgb = vec3(        yuv.x + 1.5958 * yuv.z,        yuv.x - 0.39173 * yuv.y - 0.8129 * yuv.z,        yuv.x + 2.017 * yuv.y    );    gl_FragColor = vec4(rgb, 1);}";
    public static final String i420_vs = "attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position =  aPosition;\n    vTextureCoord = aTextureCoord.xy;\n}\n";
    public static final String rgba_fs = "precision mediump float;\nvarying vec2 vTexCoord;\nuniform sampler2D uTexture0;\n\nvoid main()\n{\n    vec4 color = texture2D(uTexture0, vTexCoord);\n    gl_FragColor = color; //vec4(color.y, color.y, color.y, 1.0);\n}";
    public static final String rgba_vs = "attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}";
    public static final String nv21_fs = "precision mediump float;   \nprecision mediump int;     \nvarying vec2 vTexCoord;   \nuniform sampler2D u_texY;  \nuniform sampler2D u_texUV; \nconst mat3 op = mat3(1.164, 1.164, 1.164, 0.0, -0.391, 2.018, 1.596, -0.813, 0.0); \nvoid main(void)   \n{                 \n   vec3 rgb, yuv; \n   yuv.x = texture2D(u_texY, vTexCoord).r - 0.0625;            \n   yuv.yz = texture2D(u_texUV, vTexCoord).ar - vec2(0.5, 0.5); \n   rgb = op * yuv;                 \n   rgb.r = clamp(rgb.r, 0.0, 1.0); \n   rgb.g = clamp(rgb.g, 0.0, 1.0); \n   rgb.b = clamp(rgb.b, 0.0, 1.0); \n   gl_FragColor = vec4(rgb, 1.0);  \n}                                  \n";
    public static final String nv21_vs = "attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}";
    private long feedFrameCounter = 0L;
    private long feedCurrentTime = 0L;
    private long lastPrintTime = 0L;
    private List<Long> mCaptureRateList = new ArrayList<Long>();
    private long maxDealTime = 0L;
    private long averageDealTime = 0L;
    private List<Long> mCaptureAverageDealTimeList = new ArrayList<Long>();
    private List<Long> mCaptureMaxDealTimeList = new ArrayList<Long>();
    public float[] mMainTransformer = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private IntBuffer mFBO = null;
    private int mRenderTextureId = -1;
    private int mPositionLoc = -1;
    private int mTexCoordLoc = -1;
    private int mTextureUniform_y = -1;
    private int mTextureUniform_u = -1;
    private int mTextureUniform_v = -1;
    private int mTextureUniform_uv = -1;
    private boolean mUseTexture = false;
    private int mTextureOesTo2dId = -1;
    private int mTextureWidth;
    private int mTextureHeight;

    public OriginDataEntryFilter(VideoLiveFilterContext context) {
        this.mVideoLiveFilterContext = context;
        this.mReady = false;
    }

    @Override
    public void deInit() {
        if (this.mReady) {
            this.deInitTextureSurface();
            if (this.mI420Shader != null) {
                this.mI420Shader.destory();
                this.mI420Shader = null;
            }
            if (this.mRGBAShader != null) {
                this.mRGBAShader.destory();
                this.mRGBAShader = null;
            }
            if (this.mNV21Shader != null) {
                this.mNV21Shader.destory();
                this.mNV21Shader = null;
            }
            if (this.mOESTO2DTool != null) {
                this.mOESTO2DTool.release();
                this.mOESTO2DTool = null;
            }
            this.mReady = false;
            this.mTextureWidth = 0;
            this.mTextureHeight = 0;
        }
    }

    private boolean checkAndWaitGlThreadIdle() {
        final CountDownLatch barrier = new CountDownLatch(1);
        this.mVideoLiveFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[CCapture]", " checkAndWaitGlThreadIdel, error" + e.toString());
            return false;
        }
        return true;
    }

    public void setOriginTextureToEncode(final int inputTexture, final int textureTarget, final float[] transformer, final int width, final int height, final long timestamp, final int rotation, int scaleMode) {
        this.mUseTexture = true;
        this.mScaleMode = scaleMode;
        if (!this.checkAndWaitGlThreadIdle()) {
            return;
        }
        if (textureTarget != 3553) {
            if (this.mOESTO2DTool == null) {
                this.mOESTO2DTool = new OESTO2DTool();
            }
            if (this.mTextureOesTo2dId == -1 || this.mTextureWidth != width || this.mTextureHeight != height) {
                if (this.mTextureOesTo2dId >= 0) {
                    int[] tempTexture = new int[]{this.mTextureOesTo2dId};
                    GLES20.glDeleteTextures((int)1, (int[])tempTexture, (int)0);
                    this.mTextureOesTo2dId = -1;
                }
                this.mTextureOesTo2dId = GLUtil.genTexture(3553, width, height);
                this.mTextureWidth = width;
                this.mTextureHeight = height;
            }
            this.mTextureOesTo2dId = this.mOESTO2DTool.ConvertOES(inputTexture, width, height, this.mTextureOesTo2dId);
        }
        long time_start = System.currentTimeMillis();
        final CountDownLatch barrier = new CountDownLatch(1);
        this.mVideoLiveFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
                sample.mWidth = width;
                sample.mHeight = height;
                sample.mEncodeWidth = OriginDataEntryFilter.this.mVideoLiveFilterContext.getVideoEncoderConfig().getEncodeWidth();
                sample.mEncodeHeight = OriginDataEntryFilter.this.mVideoLiveFilterContext.getVideoEncoderConfig().getEncodeHeight();
                sample.mMasterTextureId = textureTarget != 3553 ? OriginDataEntryFilter.this.mTextureOesTo2dId : inputTexture;
                System.arraycopy(transformer, 0, sample.mMainTransformer, 0, 16);
                sample.mMainTransformer = GLUtil.rotateTextureMatrix(sample.mMainTransformer, rotation);
                sample.mYYPtsMillions = timestamp;
                sample.mTextureTarget = 3553;
                GlUtil.checkGlError("end");
                sample.mOrientation = 0;
                sample.mUsedExternPts = true;
                sample.mUseExternalVideoFrame = true;
                sample.mExternalFrameScaleMode = OriginDataEntryFilter.this.mScaleMode;
                if (YMFStreamSyncSourceManager.getInstance().getAndResetSyncSourceFlag(sample.mYYPtsMillions)) {
                    YMFLog.info(this, "[SSRC]", " ssrc :" + sample.mYYPtsMillions + "," + YMFStreamSyncSourceManager.getInstance().mHighStreamFirstSsrc);
                }
                OriginDataEntryFilter.this.deliverToDownStream(sample);
                sample.decRef();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[CCapture]", " checkAndWaitGlThreadIdel, error" + e.toString());
            return;
        }
        this.printCameraCaptureFrameRate(System.currentTimeMillis() - time_start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOriginFrameToEncode(final byte[] data, final int format, final int width, final int height, final int rotation, final long timestamp, int scaleMode) {
        this.mUseTexture = false;
        this.mScaleMode = scaleMode;
        if (!this.checkAndWaitGlThreadIdle()) {
            return;
        }
        if (this.mSrcWidth.get() != width || this.mSrcHeight.get() != height || this.mRotation.get() != rotation || this.mFormat.get() != format) {
            this.mVideoLiveFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    if (rotation == 270) {
                        FULL_RECTANGLE_VERT_BUF = GlUtil.createFloatBuffer(FULL_RECTANGLE_COORDS_90);
                        OriginDataEntryFilter.this.mDstHeight = width;
                        OriginDataEntryFilter.this.mDstWidth = height;
                    } else if (rotation == 180) {
                        FULL_RECTANGLE_VERT_BUF = GlUtil.createFloatBuffer(FULL_RECTANGLE_COORDS_180);
                        OriginDataEntryFilter.this.mDstHeight = height;
                        OriginDataEntryFilter.this.mDstWidth = width;
                    } else if (rotation == 90) {
                        FULL_RECTANGLE_VERT_BUF = GlUtil.createFloatBuffer(FULL_RECTANGLE_COORDS_270);
                        OriginDataEntryFilter.this.mDstHeight = width;
                        OriginDataEntryFilter.this.mDstWidth = height;
                    } else {
                        FULL_RECTANGLE_VERT_BUF = GlUtil.createFloatBuffer(FULL_RECTANGLE_COORDS);
                        OriginDataEntryFilter.this.mDstHeight = height;
                        OriginDataEntryFilter.this.mDstWidth = width;
                    }
                    OriginDataEntryFilter.this.mSrcWidth.set(width);
                    OriginDataEntryFilter.this.mSrcHeight.set(height);
                    OriginDataEntryFilter.this.mRotation.set(rotation);
                    OriginDataEntryFilter.this.mFormat.set(format);
                    OriginDataEntryFilter.this.initTextureSurface(OriginDataEntryFilter.this.mDstWidth, OriginDataEntryFilter.this.mDstHeight, format);
                    YMFLog.info(this, "[CCapture]", "initTextureSurface width:" + width + " height:" + height + " rotation:" + rotation);
                }
            });
        }
        OriginDataEntryFilter originDataEntryFilter = this;
        synchronized (originDataEntryFilter) {
            if (this.mInputOriginData == null || this.mInputOriginData != null && this.mInputOriginData.length != width * height * 4) {
                this.mInputOriginData = new byte[width * height * 4];
            }
            System.arraycopy(data, 0, this.mInputOriginData, 0, data.length);
        }
        this.mVideoLiveFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                OriginDataEntryFilter.this.converterOriginFrameToTexture(data, timestamp, format);
            }
        });
    }

    private void converterI420ToTexture(ByteBuffer buffer_y, ByteBuffer buffer_u, ByteBuffer buffer_v) {
        GlUtil.checkGlError("converterI420ToTexture begin");
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_y);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)this.mSrcWidth.get(), (int)this.mSrcHeight.get(), (int)0, (int)6409, (int)5121, (Buffer)buffer_y);
        GlUtil.checkGlError("converterI420ToTexture y");
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_u);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(this.mSrcWidth.get() / 2), (int)(this.mSrcHeight.get() / 2), (int)0, (int)6409, (int)5121, (Buffer)buffer_u);
        GlUtil.checkGlError("converterI420ToTexture u");
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_v);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(this.mSrcWidth.get() / 2), (int)(this.mSrcHeight.get() / 2), (int)0, (int)6409, (int)5121, (Buffer)buffer_v);
        GlUtil.checkGlError("converterI420ToTexture u");
        GLES20.glBindFramebuffer((int)36160, (int)this.mFBO.get(0));
        GLES20.glBindTexture((int)3553, (int)this.mRenderTextureId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mRenderTextureId, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)this.mDstWidth, (int)this.mDstHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlUtil.checkGlError("converterI420ToTexture begin");
        this.mI420Shader.useProgram();
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_y);
        GLES20.glUniform1i((int)this.mTextureUniform_y, (int)0);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_u);
        GLES20.glUniform1i((int)this.mTextureUniform_u, (int)1);
        GLES20.glActiveTexture((int)33986);
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_v);
        GLES20.glUniform1i((int)this.mTextureUniform_v, (int)2);
        GlUtil.checkGlError("converterI420ToTexture 1");
        GLES20.glEnableVertexAttribArray((int)this.mPositionLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.mPositionLoc, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)FULL_RECTANGLE_VERT_BUF);
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.mTexCoordLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.mTexCoordLoc, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)FULL_RECTANGLE_TEX_BUF);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.mPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.mTexCoordLoc);
        GLES20.glUseProgram((int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtil.checkGlError("draw");
    }

    private void converterRGBAToTexture(ByteBuffer data) {
        if (this.mRGBAShader == null) {
            YMFLog.error((Object)this, "[CCapture]", "converterRGBAToTexture shader null ");
            return;
        }
        GlUtil.checkGlError("converterRGBAToTexture begin");
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_rgba);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mSrcWidth.get(), (int)this.mSrcHeight.get(), (int)0, (int)6408, (int)5121, (Buffer)data);
        GlUtil.checkGlError("converterRGBAToTexture rgba");
        GLES20.glBindFramebuffer((int)36160, (int)this.mFBO.get(0));
        GLES20.glBindTexture((int)3553, (int)this.mRenderTextureId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mRenderTextureId, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)this.mDstWidth, (int)this.mDstHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlUtil.checkGlError("converterI420ToTexture begin");
        this.mRGBAShader.useProgram();
        this.mRGBAShader.setUniformTexture("uTexture0", 0, this.mTextureId_rgba, 3553);
        GLES20.glEnableVertexAttribArray((int)this.mPositionLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.mPositionLoc, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)FULL_RECTANGLE_VERT_BUF);
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.mTexCoordLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.mTexCoordLoc, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)FULL_RECTANGLE_TEX_BUF);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.mPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.mTexCoordLoc);
        GLES20.glUseProgram((int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtil.checkGlError("draw");
    }

    private void converterNV21ToTexture(ByteBuffer data_y, ByteBuffer data_uv) {
        GlUtil.checkGlError("converterI420ToTexture begin");
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_y);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)this.mSrcWidth.get(), (int)this.mSrcHeight.get(), (int)0, (int)6409, (int)5121, (Buffer)data_y);
        GlUtil.checkGlError("converterI420ToTexture y");
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_uv);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6410, (int)(this.mSrcWidth.get() / 2), (int)(this.mSrcHeight.get() / 2), (int)0, (int)6410, (int)5121, (Buffer)data_uv);
        GlUtil.checkGlError("converterI420ToTexture u");
        GLES20.glBindFramebuffer((int)36160, (int)this.mFBO.get(0));
        GLES20.glBindTexture((int)3553, (int)this.mRenderTextureId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mRenderTextureId, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)this.mDstWidth, (int)this.mDstHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlUtil.checkGlError("converterI420ToTexture begin");
        this.mNV21Shader.useProgram();
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_y);
        GLES20.glUniform1i((int)this.mTextureUniform_y, (int)0);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this.mTextureId_uv);
        GLES20.glUniform1i((int)this.mTextureUniform_uv, (int)1);
        GlUtil.checkGlError("converterI420ToTexture 1");
        GLES20.glEnableVertexAttribArray((int)this.mPositionLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.mPositionLoc, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)FULL_RECTANGLE_VERT_BUF);
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.mTexCoordLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.mTexCoordLoc, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)FULL_RECTANGLE_TEX_BUF);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.mPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.mTexCoordLoc);
        GLES20.glUseProgram((int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtil.checkGlError("draw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void converterOriginFrameToTexture(byte[] data, long timestamp, int format) {
        if (!this.mReady) {
            YMFLog.error((Object)this, "[CCapture]", "converterOriginFrameToTexture no ready or format " + this.mReady);
            return;
        }
        long time_start = System.currentTimeMillis();
        switch (format) {
            case 1: {
                OriginDataEntryFilter originDataEntryFilter = this;
                synchronized (originDataEntryFilter) {
                    System.arraycopy(this.mInputOriginData, 0, this.buffer_y.array(), this.buffer_y.arrayOffset(), this.mSrcWidth.get() * this.mSrcHeight.get());
                    System.arraycopy(this.mInputOriginData, this.mSrcWidth.get() * this.mSrcHeight.get(), this.buffer_u.array(), this.buffer_u.arrayOffset(), this.mSrcWidth.get() * this.mSrcHeight.get() / 4);
                    System.arraycopy(this.mInputOriginData, this.mSrcWidth.get() * this.mSrcHeight.get() + this.mSrcWidth.get() * this.mSrcHeight.get() / 4, this.buffer_v.array(), this.buffer_v.arrayOffset(), this.mSrcWidth.get() * this.mSrcHeight.get() / 4);
                }
                this.converterI420ToTexture(this.buffer_y, this.buffer_u, this.buffer_v);
                break;
            }
            case 2: {
                OriginDataEntryFilter originDataEntryFilter = this;
                synchronized (originDataEntryFilter) {
                    System.arraycopy(this.mInputOriginData, 0, this.buffer_y.array(), this.buffer_y.arrayOffset(), this.mSrcWidth.get() * this.mSrcHeight.get());
                    System.arraycopy(this.mInputOriginData, this.mSrcWidth.get() * this.mSrcHeight.get(), this.buffer_uv.array(), this.buffer_uv.arrayOffset(), this.mSrcWidth.get() * this.mSrcHeight.get() / 2);
                }
                this.converterNV21ToTexture(this.buffer_y, this.buffer_uv);
                break;
            }
            case 0: {
                OriginDataEntryFilter originDataEntryFilter = this;
                synchronized (originDataEntryFilter) {
                    System.arraycopy(this.mInputOriginData, 0, this.buffer_rgba.array(), this.buffer_rgba.arrayOffset(), this.mSrcWidth.get() * this.mSrcHeight.get() * 4);
                }
                this.converterRGBAToTexture(this.buffer_rgba);
                break;
            }
        }
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        sample.mWidth = this.mDstWidth;
        sample.mHeight = this.mDstHeight;
        sample.mEncodeWidth = this.mVideoLiveFilterContext.getVideoEncoderConfig().getEncodeWidth();
        sample.mEncodeHeight = this.mVideoLiveFilterContext.getVideoEncoderConfig().getEncodeHeight();
        sample.mMasterTextureId = this.mRenderTextureId;
        sample.mMainTransformer = this.mMainTransformer;
        sample.mUsedExternPts = true;
        sample.mUseExternalVideoFrame = true;
        sample.mExternalFrameScaleMode = this.mScaleMode;
        this.mVideoLiveFilterContext.mPeripheralsPosition.fillMode = 1;
        sample.mYYPtsMillions = timestamp;
        sample.mTextureTarget = 3553;
        GlUtil.checkGlError("end");
        this.mVideoLiveFilterContext.mPeripheralsOrientation = sample.mOrientation = sample.mWidth >= sample.mHeight ? 2 : 1;
        if (YMFStreamSyncSourceManager.getInstance().getAndResetSyncSourceFlag(sample.mYYPtsMillions)) {
            YMFLog.info(this, "[SSRC]", " ssrc :" + sample.mYYPtsMillions + "," + YMFStreamSyncSourceManager.getInstance().mHighStreamFirstSsrc);
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        this.printCameraCaptureFrameRate(System.currentTimeMillis() - time_start);
    }

    private void deInitTextureSurface() {
        int[] tempTexture;
        if (this.mTextureId_y >= 0) {
            tempTexture = new int[]{this.mTextureId_y};
            GLES20.glDeleteTextures((int)1, (int[])tempTexture, (int)0);
            this.mTextureId_y = -1;
        }
        if (this.mTextureId_u >= 0) {
            tempTexture = new int[]{this.mTextureId_u};
            GLES20.glDeleteTextures((int)1, (int[])tempTexture, (int)0);
            this.mTextureId_u = -1;
        }
        if (this.mTextureId_v >= 0) {
            tempTexture = new int[]{this.mTextureId_v};
            GLES20.glDeleteTextures((int)1, (int[])tempTexture, (int)0);
            this.mTextureId_v = -1;
        }
        if (this.mTextureId_uv >= 0) {
            tempTexture = new int[]{this.mTextureId_uv};
            GLES20.glDeleteTextures((int)1, (int[])tempTexture, (int)0);
            this.mTextureId_uv = -1;
        }
        if (this.mTextureId_rgba >= 0) {
            tempTexture = new int[]{this.mTextureId_rgba};
            GLES20.glDeleteTextures((int)1, (int[])tempTexture, (int)0);
            this.mTextureId_rgba = -1;
        }
        if (this.mTextureOesTo2dId >= 0) {
            tempTexture = new int[]{this.mTextureOesTo2dId};
            GLES20.glDeleteTextures((int)1, (int[])tempTexture, (int)0);
            this.mTextureOesTo2dId = -1;
        }
        if (this.mFBO != null) {
            GLES20.glDeleteFramebuffers((int)1, (IntBuffer)this.mFBO);
            this.mFBO = null;
        }
        if (this.mRenderTextureId >= 0) {
            tempTexture = new int[]{this.mRenderTextureId};
            GLES20.glDeleteTextures((int)1, (int[])tempTexture, (int)0);
        }
    }

    public int createTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        return textures[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTextureSurface(int width, int height, int format) {
        this.deInitTextureSurface();
        this.mFBO = IntBuffer.allocate(1);
        GLES20.glGenFramebuffers((int)1, (IntBuffer)this.mFBO);
        OriginDataEntryFilter originDataEntryFilter = this;
        synchronized (originDataEntryFilter) {
            if (this.mInputOriginData == null || this.mInputOriginData != null && this.mInputOriginData.length != width * height * 4) {
                this.mInputOriginData = new byte[width * height * 4];
            }
        }
        if (this.mTextureId_y == -1 && format == 1) {
            this.mTextureId_y = this.createTexture();
            this.mTextureId_u = this.createTexture();
            this.mTextureId_v = this.createTexture();
            this.buffer_y = ByteBuffer.allocateDirect(width * height);
            this.buffer_v = ByteBuffer.allocateDirect(width * height / 4);
            this.buffer_u = ByteBuffer.allocateDirect(width * height / 4);
            if (this.mI420Shader == null) {
                this.mI420Shader = new GLShaderProgram();
                this.mI420Shader.setProgram(i420_vs, i420_fs);
                this.mPositionLoc = GLES20.glGetAttribLocation((int)this.mI420Shader.programHandle(), (String)"aPosition");
                this.mTexCoordLoc = GLES20.glGetAttribLocation((int)this.mI420Shader.programHandle(), (String)"aTextureCoord");
                this.mTextureUniform_y = GLES20.glGetUniformLocation((int)this.mI420Shader.programHandle(), (String)"tex_y");
                this.mTextureUniform_u = GLES20.glGetUniformLocation((int)this.mI420Shader.programHandle(), (String)"tex_u");
                this.mTextureUniform_v = GLES20.glGetUniformLocation((int)this.mI420Shader.programHandle(), (String)"tex_v");
                if (this.mPositionLoc < 0 || this.mTexCoordLoc < 0 || this.mTextureUniform_y < 0 || this.mTextureUniform_u < 0 || this.mTextureUniform_v < 0) {
                    YMFLog.error((Object)this, "[CCapture]", " I420 glGetAttribLocation error!");
                    return;
                }
            }
        } else if (this.mTextureId_rgba == -1 && format == 0) {
            this.mTextureId_rgba = this.createTexture();
            this.buffer_rgba = ByteBuffer.allocateDirect(width * height * 4);
            if (this.mRGBAShader == null) {
                this.mRGBAShader = new GLShaderProgram();
                this.mRGBAShader.setProgram("attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}", rgba_fs);
                this.mPositionLoc = GLES20.glGetAttribLocation((int)this.mRGBAShader.programHandle(), (String)"aPosition");
                this.mTexCoordLoc = GLES20.glGetAttribLocation((int)this.mRGBAShader.programHandle(), (String)"aTextureCoord");
                if (this.mPositionLoc < 0 || this.mTexCoordLoc < 0) {
                    YMFLog.error((Object)this, "[CCapture]", " RGBA glGetAttribLocation error!");
                    return;
                }
            }
        } else if (this.mTextureId_uv == -1 && format == 2) {
            this.mTextureId_y = this.createTexture();
            this.mTextureId_uv = this.createTexture();
            this.buffer_y = ByteBuffer.allocateDirect(width * height);
            this.buffer_uv = ByteBuffer.allocateDirect(width * height / 2);
            if (this.mNV21Shader == null) {
                this.mNV21Shader = new GLShaderProgram();
                this.mNV21Shader.setProgram("attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}", nv21_fs);
            }
            this.mPositionLoc = GLES20.glGetAttribLocation((int)this.mNV21Shader.programHandle(), (String)"aPosition");
            this.mTexCoordLoc = GLES20.glGetAttribLocation((int)this.mNV21Shader.programHandle(), (String)"aTextureCoord");
            this.mTextureUniform_y = GLES20.glGetUniformLocation((int)this.mNV21Shader.programHandle(), (String)"u_texY");
            this.mTextureUniform_uv = GLES20.glGetUniformLocation((int)this.mNV21Shader.programHandle(), (String)"u_texUV");
            if (this.mPositionLoc < 0 || this.mTexCoordLoc < 0 || this.mTextureUniform_uv < 0 || this.mTextureUniform_y < 0) {
                YMFLog.error((Object)this, "[CCapture]", " NV21 glGetAttribLocation error!");
                return;
            }
        }
        int[] textureHandles = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandles, (int)0);
        this.mRenderTextureId = textureHandles[0];
        GLES20.glBindTexture((int)3553, (int)this.mRenderTextureId);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        this.mReady = true;
        YMFLog.info(this, "[CCapture]", "initTextureSurface:" + width + "x" + height + " format:" + format);
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
    }

    private void printFrameRate(String type, List<Long> list, List<Long> list2, List<Long> list3) {
        if (null == list) {
            return;
        }
        String str = " ";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i) + ":" + list2.get(i) + ":" + list3.get(i) + ", ";
        }
        YMFLog.info(this, "[CCapture]", "handleFrameAvailable feed data frame rate:[" + str + "] type:[" + type + "]");
    }

    private void printCameraCaptureFrameRate(long dealTime) {
        try {
            ++this.feedFrameCounter;
            this.feedCurrentTime = System.currentTimeMillis();
            this.maxDealTime = this.maxDealTime < dealTime ? dealTime : this.maxDealTime;
            this.averageDealTime += dealTime;
            if (this.feedCurrentTime - this.lastPrintTime >= 1000L) {
                this.mCaptureRateList.add(this.feedFrameCounter);
                this.mCaptureAverageDealTimeList.add(this.averageDealTime / this.feedFrameCounter);
                this.mCaptureMaxDealTimeList.add(this.maxDealTime);
                if (this.mCaptureRateList.size() >= 5) {
                    this.printFrameRate("OriginCapture " + this.mUseTexture, this.mCaptureRateList, this.mCaptureAverageDealTimeList, this.mCaptureMaxDealTimeList);
                    this.mCaptureRateList.clear();
                    this.mCaptureMaxDealTimeList.clear();
                    this.mCaptureAverageDealTimeList.clear();
                }
                this.feedFrameCounter = 0L;
                this.lastPrintTime = this.feedCurrentTime;
                this.maxDealTime = 0L;
                this.averageDealTime = 0L;
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[CCapture]", "printCameraCaptureFrameRate exception:" + e.toString());
        }
    }
}

