/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.filters.VideoLiveQualityFilter;
import com.yy.mediaframework.inteligence.common.ResolutionModifyNotFoundException;
import com.yy.mediaframework.inteligence.framerate.CaptureSyncEncodeFrameRateModify;
import com.yy.mediaframework.inteligence.resolution.DefaultResolutionModify;
import com.yy.mediaframework.utils.YMFLog;

public class HardEncodeVideoLiveQualityFilter
extends VideoLiveQualityFilter {
    public HardEncodeVideoLiveQualityFilter(VideoLiveFilterContext filterContext, ILiveSession liveSession) {
        super(filterContext, liveSession);
        YMFLog.info(this, "[Encoder ]", "HardEncodeVideoLiveQualityFilter construct");
    }

    @Override
    public void installAdaptor() {
        if (this.mHasAdaptor) {
            YMFLog.info(this, "[Encoder ]", "installAdaptor, has installed");
            return;
        }
        VideoEncoderConfig encoderConfig = this.mFilterContext.getVideoEncoderConfig();
        if (this.mResolutionModifyConfigs != null && this.mResolutionModifyConfigs.size() > 0) {
            this.mFrameRateModify = new CaptureSyncEncodeFrameRateModify();
            ((CaptureSyncEncodeFrameRateModify)this.mFrameRateModify).init(encoderConfig.mFrameRate, encoderConfig.mBitRate, encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), this.mResolutionModifyConfigs);
            try {
                this.mResolutionModify = new DefaultResolutionModify();
                ((DefaultResolutionModify)this.mResolutionModify).init(encoderConfig.mFrameRate, encoderConfig.mBitRate, encoderConfig.getEncodeWidth(), encoderConfig.getEncodeHeight(), this.mResolutionModifyInterval, this.mResolutionModifyConfigs, this.mResolutionModifyListener);
            }
            catch (ResolutionModifyNotFoundException e) {
                YMFLog.error(this, "[Encoder ]", "init ResolutinModify exception:%s", e.toString());
                this.mResolutionModify = null;
            }
        }
        this.mHasAdaptor = true;
        YMFLog.info(this, "[Encoder ]", "installAdaptor, done");
    }
}

