/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.filters.H264HardwareEncoderFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.ByteVector;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.model.YYMediaSampleAlloc;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;

public class H265HardwareEncoderFilter
extends H264HardwareEncoderFilter {
    public static final int SLICE_IDR = 1;
    public static final int SLICE_I = 2;
    public static final int SLICE_UNKNOW = 255;
    private int m_outReadNum = 0;
    private int m_outputFlagPresentFlag = 0;
    private int m_DepSliceSegEn = 0;
    private int m_numExtraSliceHeader = 0;
    private boolean mFirstFrameEncode = false;
    private long m_lastSyncFrameTime = 0L;
    private final int SyncFrameDurationMs = 3100;
    private ByteVector mBytesVector = new ByteVector(16384);
    public YYMediaSample mSpsSample = new YYMediaSample();

    public H265HardwareEncoderFilter(VideoLiveFilterContext filterContext) {
        super(filterContext);
    }

    @Override
    @TargetApi(value=16)
    public void onEncodedHeaderAvailableSample(ByteBuffer buffer, MediaCodec.BufferInfo buffInfo, long dtsMs, long ptsMs, MediaFormat mediaFormat) {
        byte[] frameData = new byte[buffInfo.size];
        if (!this.mFirstEncoderDataOut.get()) {
            this.onFirstEncodedDataOut();
        }
        buffer.get(frameData);
        this.parsePPS(frameData, buffInfo.size);
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        sample.mYYPtsMillions = 0L;
        sample.mDtsMillions = 0L;
        sample.mMediaFormat = mediaFormat;
        sample.mFrameFlag = buffInfo.flags;
        sample.mWidth = mediaFormat.getInteger("width");
        sample.mHeight = mediaFormat.getInteger("height");
        sample.mDataByteBuffer = ByteBuffer.wrap(frameData);
        sample.mBufferOffset = 0;
        sample.mBufferSize = buffInfo.size;
        sample.mEncoderType = VideoEncoderType.HARD_ENCODER_H265;
        sample.mFrameType = 9;
        this.mSpsSample.assigne(sample);
        this.deliverToDownStream(sample);
        this.m_lastSyncFrameTime = System.currentTimeMillis();
        this.handleEncodedFrameStats(sample.mBufferSize, this.getInputFrameByteSize(), sample.mFrameType);
        sample.decRef();
    }

    @Override
    @TargetApi(value=16)
    public void onEncodedDataAvailableSample(ByteBuffer buffer, MediaCodec.BufferInfo buffInfo, long dtsMs, long ptsMs, MediaFormat mediaFormat) {
        YMFLog.debug((Object)this, "[Encoder ]", "OnEncodeDataAvailableSample get in");
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        sample.mDtsMillions = dtsMs;
        sample.mYYPtsMillions = ptsMs;
        sample.mMediaFormat = mediaFormat;
        sample.mFrameFlag = buffInfo.flags;
        sample.mWidth = mediaFormat.getInteger("width");
        sample.mHeight = mediaFormat.getInteger("height");
        sample.mDataByteBuffer = buffer;
        sample.mBufferOffset = buffInfo.offset;
        sample.mBufferSize = buffInfo.size;
        sample.mEncoderType = VideoEncoderType.HARD_ENCODER_H265;
        if (!this.mFirstFrameEncode) {
            YMFLiveUsrBehaviorStat.getInstance().notifyFirstFrameEncode(sample.mYYPtsMillions);
            this.mFirstFrameEncode = true;
        }
        int endPos = 0;
        while (buffer.get(buffInfo.offset + buffInfo.size - 1 - endPos) == 0) {
            ++endPos;
        }
        if (endPos < sample.mBufferSize) {
            sample.mBufferSize -= endPos;
        }
        buffer.position(buffInfo.offset);
        this.mBytesVector.put(buffer, buffInfo.size);
        buffer.position(buffInfo.offset);
        int type = this.parseSliceType(this.mBytesVector.getBytes(), this.mBytesVector.size());
        if (type == 1 || type == 2) {
            sample.mFrameType = 4;
            if (type == 1) {
                this.m_lastSyncFrameTime = System.currentTimeMillis();
            }
        } else {
            sample.mFrameType = 1;
        }
        if (System.currentTimeMillis() - this.m_lastSyncFrameTime > 3100L) {
            this.requestSyncFrame();
            this.m_lastSyncFrameTime = System.currentTimeMillis();
        }
        this.mBytesVector.clear();
        if (sample.mFrameType == 4 && this.mSpsSample != null) {
            this.deliverToDownStream(this.mSpsSample);
        }
        this.deliverToDownStream(sample);
        this.handleEncodedFrameStats(sample.mBufferSize, this.getInputFrameByteSize(), sample.mFrameType);
        sample.decRef();
    }

    @Override
    public VideoEncoderType getEncoderFilterType() {
        return VideoEncoderType.HARD_ENCODER_H265;
    }

    @Override
    public void onEncoderFomratChanged(MediaFormat mediaFormat) {
        super.onEncoderFomratChanged(mediaFormat);
    }

    @Override
    public void onPreviewTextureAvailable(SurfaceTexture surfaceTexture) {
    }

    @Override
    public void onError(long eid, String exceptionId, String errMsg) {
        this._OnError(eid, exceptionId, errMsg);
    }

    private static int test_bit(byte[] addr, int index) {
        int i = index % 8;
        byte num = addr[index >> 3];
        return num >> 7 - i & 1;
    }

    private static int read_bits(byte[] addr, int start, int length) {
        int result = 0;
        while (length-- > 0) {
            result = (result << 1) + H265HardwareEncoderFilter.test_bit(addr, start++);
        }
        return result;
    }

    private int read_ue(byte[] addr, int start) {
        int leadingZeroBits = -1;
        int b = 0;
        while (b == 0) {
            b = H265HardwareEncoderFilter.test_bit(addr, start + leadingZeroBits + 1);
            ++leadingZeroBits;
        }
        int codeNum = (1 << leadingZeroBits) - 1 + H265HardwareEncoderFilter.read_bits(addr, start + leadingZeroBits + 1, leadingZeroBits);
        this.m_outReadNum = leadingZeroBits * 2 + 1;
        return codeNum;
    }

    public void parsePPS(byte[] frameData, int len) {
        if (frameData == null || len <= 0) {
            return;
        }
        int pos = 0;
        pos = 0;
        while (pos + 5 <= len) {
            int oldPos = pos;
            if (frameData[pos] == 0 && frameData[pos + 1] == 0 && frameData[pos + 2] == 0 && frameData[pos + 3] == 1) {
                pos += 4;
            } else if (frameData[pos] == 0 && frameData[pos + 1] == 0 && frameData[pos + 3] == 1) {
                pos += 3;
            }
            if (oldPos == pos) {
                ++pos;
                continue;
            }
            int type = (frameData[pos] & 0x7E) >> 1;
            if (type != 34) continue;
            break;
        }
        if (pos + 5 >= len) {
            return;
        }
        pos = (pos + 2) * 8;
        int picId = this.read_ue(frameData, pos);
        int seqId = this.read_ue(frameData, pos += this.m_outReadNum);
        pos += this.m_outReadNum;
        this.m_DepSliceSegEn = H265HardwareEncoderFilter.read_bits(frameData, pos++, 1);
        this.m_outputFlagPresentFlag = H265HardwareEncoderFilter.read_bits(frameData, pos++, 1);
        this.m_numExtraSliceHeader = H265HardwareEncoderFilter.read_bits(frameData, pos, 3);
        pos += 3;
        YMFLog.info(this, "[Encoder ]", "H265SurfaceEncoder parsePPS Type, picId:" + picId + ", seqId:" + seqId + ", m_DepSliceSegEn:" + this.m_DepSliceSegEn + ", m_outputFlagPresentFlag:" + this.m_outputFlagPresentFlag + ", m_numExtraSliceHeader:" + this.m_numExtraSliceHeader);
    }

    public int parseSliceType(byte[] frameData, int len) {
        int ntype = H265HardwareEncoderFilter.naltype(frameData, len);
        if (ntype < 0) {
            YMFLog.info(this, "[Encoder ]", "H265SurfaceEncoder parseSliceType, unknown, ntype:" + ntype);
            return 255;
        }
        if (ntype >= 16 && ntype <= 23) {
            YMFLog.info(this, "[Encoder ]", "H265SurfaceEncoder parseSliceType, IDR, ntype:" + ntype);
            return 1;
        }
        if (ntype >= 32 && ntype <= 34) {
            YMFLog.info(this, "[Encoder ]", "H265SurfaceEncoder parseSliceType, PPS/VPS/SPS, ntype:" + ntype);
            return 255;
        }
        int pos = 0;
        if (frameData[0] == 0 && frameData[1] == 0 && frameData[2] == 0 && frameData[3] == 1) {
            pos = 32;
        } else if (frameData[0] == 0 && frameData[1] == 0 && frameData[2] == 1) {
            pos = 24;
        } else {
            YMFLog.info(this, "[Encoder ]", "H265SurfaceEncoder parseSliceType, unknown slice type");
            return 255;
        }
        pos += 16;
        int firstSliceSeg = H265HardwareEncoderFilter.read_bits(frameData, pos++, 1);
        int picId = this.read_ue(frameData, pos);
        pos += this.m_outReadNum;
        int dependentSliceSeg = 0;
        if (firstSliceSeg == 0) {
            if (this.m_DepSliceSegEn != 0) {
                dependentSliceSeg = H265HardwareEncoderFilter.read_bits(frameData, pos++, 1);
            }
            this.read_ue(frameData, pos);
            pos += this.m_outReadNum;
        }
        if (dependentSliceSeg != 0) {
            return 255;
        }
        for (int i = 0; i < this.m_numExtraSliceHeader; ++i) {
            H265HardwareEncoderFilter.read_bits(frameData, pos++, 1);
        }
        int type = this.read_ue(frameData, pos);
        pos += this.m_outReadNum;
        return type == 2 ? 2 : 255;
    }

    public static int naltype(byte[] frameData, int len) {
        int type = -1;
        if (frameData[0] == 0 && frameData[1] == 0 && frameData[2] == 0 && frameData[3] == 1) {
            type = (frameData[4] & 0x7E) >> 1;
        } else if (frameData[0] == 0 && frameData[1] == 0 && frameData[2] == 1) {
            type = (frameData[3] & 0x7E) >> 1;
        }
        return type;
    }
}

