/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.encoder.AbstractTextureMoiveEncoder;
import com.yy.mediaframework.encoder.HardEncodeListner;
import com.yy.mediaframework.encoder.TextureMoiveEncoderSync;
import com.yy.mediaframework.filters.AbstractEncoderFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.model.YYMediaSampleAlloc;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.YMFLiveExceptionStat;
import com.yy.mediaframework.stat.YMFLiveExceptionType;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.StringUtils;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class H264HardwareEncoderFilter
extends AbstractEncoderFilter
implements HardEncodeListner {
    private static final int kMaxRetryCnt = 5;
    private int mSpsSize = 0;
    private int mPpsSize = 0;
    private boolean mFirstFrameEncode = false;
    private AtomicInteger mState = new AtomicInteger(0);
    private AtomicLong mCurrentEID = new AtomicLong(-1L);
    private AbstractTextureMoiveEncoder mEncoder = null;
    private boolean mHasBFrame = false;
    private long mIDRFrameDts = 0L;
    private boolean mFirstPFrameDtsCompensate = false;
    private boolean mPtsLog = true;
    public YYMediaSample mSpsSample = new YYMediaSample();
    public YYMediaSample mPpsSample = new YYMediaSample();
    private byte[] mFilteData;

    public H264HardwareEncoderFilter(VideoLiveFilterContext filterContext) {
        this.mFilterContext = filterContext;
        this.mInputMode = this.mFilterContext.getEncoderInputMode();
        this.mEncoder = new TextureMoiveEncoderSync(this.mFilterContext, this.mFilterContext.getGlManager(), this);
        YMFLog.info(this, "[Encoder ]", "H264HardwareEncoderFilter construct");
    }

    public static boolean isAvaible() {
        return Build.VERSION.SDK_INT >= 18;
    }

    @Override
    public VideoEncoderType getEncoderFilterType() {
        return VideoEncoderType.HARD_ENCODER_H264;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startEncode() {
        H264HardwareEncoderFilter h264HardwareEncoderFilter = this;
        synchronized (h264HardwareEncoderFilter) {
            this.encodedCallBack = null;
        }
        this.mFirstEncoderDataOut.set(false);
        return this.startEncode_private(this.mFilterContext.getVideoEncoderConfig().getEncodeWidth(), this.mFilterContext.getVideoEncoderConfig().getEncodeHeight());
    }

    private boolean startEncode_private(int width, int height) {
        YMFLog.info(this, "[Encoder ]", "encode width:%d, height:%d", width, height);
        if (Constant.EncoderState.isStart(this.mState.get())) {
            YMFLog.info(this, "[Encoder ]", "startEncode already, so return");
            return true;
        }
        YMFLog.info(this, "[Encoder ]", "H264HardwareEncoderFilter startEncode begin");
        this.setEncodeCfg(this.mFilterContext.getVideoEncoderConfig());
        this.mEncoderConfig.setEncodeSize(this.mFilterContext.getVideoEncoderConfig().getEncodeWidth(), this.mFilterContext.getVideoEncoderConfig().getEncodeHeight());
        this.mEncoder.setEncoderInputMode(this.mInputMode);
        long eid = this.mEncoder.startEncode(this.mEncoderConfig);
        if (eid > 0L) {
            this.mCurrentEID.set(eid);
            this.mState.set(1);
            VideoDataStat.getInstance().setVideoEncodingState(true);
            YMFLog.info(this, "[Encoder ]", "H264HardwareEncoderFilter startEncode succeed end");
            this.mEncodeParam = "config:" + this.mEncoderConfig.toString() + ", real:" + this.mEncoder.getMediaFormat();
            this.mFilterContext.getEncodeParamTipsMgr().setEncoderParam(this.mEncodeParam);
            return true;
        }
        this.mbEncodingState = false;
        YMFLiveExceptionStat.getInstance().notifyException(YMFLiveExceptionType.AnchorStatus_ENCODE_ERROR);
        YMFLog.info(this, "[Encoder ]", "H264HardwareEncoderFilter startEncode fail end");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopEncode() {
        YMFLog.info(this, "[Encoder ]", "H264 stopEncode begin");
        if (Constant.EncoderState.isStoped(this.mState.getAndSet(3))) {
            YMFLog.info(this, "[Encoder ]", "H264 stopEncode: no initialized state, so return");
            return;
        }
        this.mFilterContext.getEncodeParamTipsMgr().setNoEncoder();
        this.mState.set(3);
        VideoDataStat.getInstance().setVideoEncodingState(false);
        this.mEncoder.releaseEncoder();
        if (this.getClass().getSimpleName().equals("H264HardwareEncoderFilter")) {
            YMFLiveUsrBehaviorStat.getInstance().notifyVideoEncoderState(VideoEncoderType.HARD_ENCODER_H264, false);
        } else if (this.getClass().getSimpleName().equals("H265HardwareEncoderFilter")) {
            YMFLiveUsrBehaviorStat.getInstance().notifyVideoEncoderState(VideoEncoderType.HARD_ENCODER_H265, false);
        }
        YMFLog.info(this, "[Encoder ]", "H264 stopEncode done");
        H264HardwareEncoderFilter h264HardwareEncoderFilter = this;
        synchronized (h264HardwareEncoderFilter) {
            if (this.encodedCallBack != null) {
                this.encodedCallBack = null;
            }
        }
    }

    @Override
    public void requestSyncFrame() {
        if (this.mEncoder != null) {
            this.mEncoder.requestSyncFrame();
        }
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        int state = this.mState.get();
        if (Constant.EncoderState.blockStream(state)) {
            YMFLog.error((Object)this, "[Encoder ]", "encoder is not started or stoped!!");
            return false;
        }
        if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_NORMAL && this.checkEncoderSwitch()) {
            this.handleEncoderSwitch();
            return true;
        }
        if (this.checkEncodeUpdate(sample.mEncodeWidth, sample.mEncodeHeight, this.mFilterContext.getVideoEncoderConfig().mLowDelay, this.mFilterContext.getVideoEncoderConfig().mFrameRate, this.mFilterContext.getVideoEncoderConfig().mBitRate, this.mFilterContext.getVideoEncoderConfig().mEncodeParameter, sample.mEncoderInputMode)) {
            YMFLog.info(this, "[Encoder ]", "image size changed, so restart the hardware encoder!!");
            this.stopEncode();
            this.startEncode_private(sample.mEncodeWidth, sample.mEncodeHeight);
            YMFLog.info(this, "[Encoder ]", "image size changed, restart hardeware encoder success!!");
        }
        if (state == 4) {
            YMFLog.error((Object)this, "[Encoder ]", "encoder is now in error state");
            return false;
        }
        sample.addRef();
        if (sample.mEncoderInputMode == Constant.EncoderInputMode.SURFACE) {
            this.mEncoder.encodeFrame(sample, this.mFilterContext.getWatermarkTextureID(), this.mFilterContext.getDynamicTextureID(), sample.mSlaveTextureId, this.mSlaveVertexBuffer);
        } else {
            this.mEncoder.encodeFrame(sample);
        }
        sample.decRef();
        return false;
    }

    @Override
    public void onEncodedHeaderAvailable(ByteBuffer buffer, int offset, int size, String mime) {
        YMFLog.info(this, "[Encoder ]", "OnEncodedHeaderAvailable get in");
    }

    @Override
    @TargetApi(value=16)
    public void onEncodedHeaderAvailableSample(ByteBuffer buffer, MediaCodec.BufferInfo buffInfo, long dtsMs, long ptsMs, MediaFormat mediaFormat) {
        YMFLog.info(this, "[Encoder ]", "onEncodeHeadAvailable get in");
        if (buffer == null || buffInfo == null) {
            YMFLog.error((Object)this, "[Encoder ]", "H264SurfaceEndoerFilter onEncodeHeadAvailable error, buffer or bufferInfo is null");
            return;
        }
        if ((buffInfo.flags & 2) != 0) {
            if (this.mSpsSize <= 0 || this.mPpsSize <= 0) {
                YMFLog.error((Object)this, "[Encoder ]", "OnEncodedHeaderAvailableSample error, should set setMediaFormatChanged first!");
                return;
            }
            buffer.position(buffInfo.offset);
            if (buffer.remaining() < this.mSpsSize + this.mPpsSize) {
                YMFLog.error((Object)this, "[Encoder ]", "setVideoCodecConfigBuffer error, buffer length error!");
                return;
            }
            if (!this.mFirstEncoderDataOut.get()) {
                this.onFirstEncodedDataOut();
            }
            boolean isBigEndian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
            int header = isBigEndian ? 1 : 0x1000000;
            int spsHeader = buffer.getInt();
            int spsSize = this.mSpsSize;
            if (spsHeader == header) {
                spsSize -= 4;
            } else {
                buffer.position(buffer.position() - 4);
            }
            byte[] sps = new byte[spsSize];
            buffer.get(sps);
            YYMediaSample spsSample = YYMediaSampleAlloc.instance().alloc();
            spsSample.mDataByteBuffer = ByteBuffer.wrap(sps);
            spsSample.mDataByteBuffer.order(ByteOrder.nativeOrder());
            spsSample.mBufferSize = spsSize;
            spsSample.mBufferOffset = 0;
            spsSample.mEncoderType = VideoEncoderType.HARD_ENCODER_H264;
            spsSample.mFrameType = 5;
            spsSample.mYYPtsMillions = 0L;
            spsSample.mDtsMillions = 0L;
            this.mSpsSample.assigne(spsSample);
            this.deliverToDownStream(spsSample);
            spsSample.decRef();
            YMFLog.info(this, "[Encoder ]", "OnEncodedHeaderAvailableSample sps:" + StringUtils.bytesToHexString(sps) + " sps size:" + this.mSpsSize);
            int ppsSize = this.mPpsSize;
            int ppsHeader = buffer.getInt();
            if (ppsHeader == header) {
                ppsSize -= 4;
            } else {
                buffer.position(buffer.position() - 4);
                int headerLen = 0;
                do {
                    if (++headerLen <= 5) continue;
                    headerLen = 0;
                    break;
                } while ((buffer.get() & 0x1F) != 8);
                buffer.position(buffer.position() - headerLen);
                ppsSize -= headerLen;
            }
            byte[] pps = new byte[ppsSize];
            buffer.get(pps);
            YYMediaSample ppsSample = YYMediaSampleAlloc.instance().alloc();
            ppsSample.mDataByteBuffer = ByteBuffer.wrap(pps);
            ppsSample.mDataByteBuffer.order(ByteOrder.nativeOrder());
            ppsSample.mBufferSize = ppsSize;
            ppsSample.mEncoderType = VideoEncoderType.HARD_ENCODER_H264;
            ppsSample.mFrameType = 6;
            ppsSample.mYYPtsMillions = 0L;
            ppsSample.mDtsMillions = 0L;
            this.mPpsSample.assigne(ppsSample);
            this.deliverToDownStream(ppsSample);
            ppsSample.decRef();
            this.mIDRFrameDts = dtsMs;
            this.mFirstPFrameDtsCompensate = false;
            YMFLog.info(this, "[Encoder ]", "OnEncodedHeaderAvailableSample pps:" + StringUtils.bytesToHexString(pps) + " pps size:" + this.mPpsSize);
            if (buffer.remaining() > 0) {
                YMFLog.info(this, "[Encoder ]", "H264SurfaceEndoerFilter OnEncodeDataAvailableSample");
                YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
                sample.mDtsMillions = dtsMs;
                sample.mYYPtsMillions = ptsMs;
                sample.mMediaFormat = mediaFormat;
                sample.mFrameFlag = buffInfo.flags;
                sample.mWidth = mediaFormat.getInteger("width");
                sample.mHeight = mediaFormat.getInteger("height");
                sample.mDataByteBuffer = buffer;
                sample.mBufferOffset = buffer.position();
                sample.mBufferSize = buffer.remaining();
                sample.mEncoderType = VideoEncoderType.HARD_ENCODER_H264;
                if ((buffInfo.flags & 1) != 0) {
                    sample.mFrameType = 4;
                } else {
                    sample.mDataByteBuffer.position(sample.mBufferOffset);
                    int frameTypeValue = sample.mDataByteBuffer.getInt(4);
                    sample.mDataByteBuffer.position(sample.mBufferOffset);
                    sample.mFrameType = this.fetchFrameType(frameTypeValue);
                }
                if (!this.mFirstFrameEncode) {
                    YMFLiveUsrBehaviorStat.getInstance().notifyFirstFrameEncode(sample.mYYPtsMillions);
                    this.mFirstFrameEncode = true;
                }
                this.deliverToDownStream(sample);
                this.handleEncodedFrameStats(sample.mBufferSize, this.getInputFrameByteSize(), sample.mFrameType);
                sample.decRef();
            } else {
                this.mEncoder.recoverCachedPtsList(dtsMs);
            }
        }
    }

    @TargetApi(value=16)
    private void filteSpsPpsFormIDRFrame(ByteBuffer buffer, MediaCodec.BufferInfo buffInfo, YYMediaSample sample) {
        if (this.mFilteData == null || this.mFilteData.length > buffer.limit()) {
            this.mFilteData = new byte[buffer.limit() > 40 ? 40 : buffer.limit()];
        }
        buffer.position(buffInfo.offset);
        buffer.get(this.mFilteData, 0, this.mFilteData.length);
        int offset = 0;
        for (int i = 2; i < this.mFilteData.length - 5; ++i) {
            if (this.mFilteData[i] != 0 || this.mFilteData[i + 1] != 0 || this.mFilteData[i + 2] != 0 || this.mFilteData[i + 3] != 1 || (this.mFilteData[i + 4] & 0x1F) != 5) continue;
            offset = i;
            break;
        }
        sample.mBufferOffset = buffInfo.offset + offset;
        sample.mBufferSize = buffInfo.size - offset;
    }

    @Override
    @TargetApi(value=16)
    public void onEncodedDataAvailableSample(ByteBuffer buffer, MediaCodec.BufferInfo buffInfo, long dtsMs, long ptsMs, MediaFormat mediaFormat) {
        YMFLog.debug((Object)this, "[Encoder ]", "OnEncodeDataAvailableSample get in");
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        sample.mYYPtsMillions = ptsMs;
        sample.mMediaFormat = mediaFormat;
        sample.mFrameFlag = buffInfo.flags;
        sample.mWidth = mediaFormat.getInteger("width");
        sample.mHeight = mediaFormat.getInteger("height");
        sample.mDataByteBuffer = buffer;
        sample.mBufferOffset = buffInfo.offset;
        sample.mBufferSize = buffInfo.size;
        sample.mEncoderType = VideoEncoderType.HARD_ENCODER_H264;
        if (!this.mFirstFrameEncode) {
            YMFLiveUsrBehaviorStat.getInstance().notifyFirstFrameEncode(sample.mYYPtsMillions);
            this.mFirstFrameEncode = true;
        }
        if ((buffInfo.flags & 1) != 0) {
            sample.mFrameType = 4;
            if ((buffer.get(4) & 0x1F) != 5) {
                this.filteSpsPpsFormIDRFrame(buffer, buffInfo, sample);
            }
            buffer.rewind();
        } else {
            sample.mDataByteBuffer.position(sample.mBufferOffset);
            byte frameTypeValue = sample.mDataByteBuffer.get(4);
            sample.mDataByteBuffer.position(sample.mBufferOffset);
            sample.mFrameType = this.fetchFrameType(frameTypeValue);
        }
        if (sample.mFrameType == 2 && !this.mHasBFrame) {
            YMFLog.info(this, "[Encoder ]", "onEncodedDataAvailableSample hasBframe:" + this.mHasBFrame);
            this.mHasBFrame = true;
        }
        if (ptsMs != dtsMs && !this.mFirstPFrameDtsCompensate) {
            sample.mDtsMillions = this.mIDRFrameDts + (dtsMs - this.mIDRFrameDts) / 2L;
            this.mEncoder.recoverCachedPtsList(dtsMs);
            this.mFirstPFrameDtsCompensate = true;
            YMFLog.info(this, "[Encoder ]", "firstPframe H264 dts:" + sample.mDtsMillions);
        } else {
            sample.mDtsMillions = dtsMs;
        }
        if (sample.mFrameType == 4 && this.mSpsSample != null && this.mPpsSample != null) {
            this.deliverToDownStream(this.mSpsSample);
            this.deliverToDownStream(this.mPpsSample);
        }
        if (this.mPtsLog && sample.mDtsMillions > sample.mYYPtsMillions) {
            YMFLog.error((Object)this, "[Encoder ]", "onEncodedDataAvailableSample  H264 pts:" + sample.mYYPtsMillions + " dts:" + sample.mDtsMillions + " gap:" + (sample.mYYPtsMillions - sample.mDtsMillions) + " frameType:" + sample.mFrameType);
            this.mPtsLog = false;
        }
        this.deliverToDownStream(sample);
        this.handleEncodedFrameStats(sample.mBufferSize, this.getInputFrameByteSize(), sample.mFrameType);
        sample.decRef();
    }

    private int fetchFrameType(int value) {
        int type = value & 0x1F;
        int frametype = 255;
        switch (type) {
            case 1: {
                if (value == 1) {
                    frametype = 2;
                    break;
                }
            }
            case 2: 
            case 3: 
            case 4: {
                frametype = 1;
                break;
            }
            case 5: {
                frametype = 4;
                break;
            }
            case 9: {
                break;
            }
            default: {
                frametype = 4;
            }
        }
        return frametype;
    }

    @Override
    public void onEncodedDataAvailable(ByteBuffer buffer, int offset, int size, long dts, long pts) {
    }

    @Override
    @TargetApi(value=16)
    public void onEncoderFomratChanged(MediaFormat mediaFormat) {
        if (mediaFormat == null) {
            YMFLog.error((Object)this, "[Encoder ]", "setMediaFormatChanged error, format null!");
            return;
        }
        YMFLog.info(this, "[Encoder ]", "setMediaFormatChanged spsSize:" + this.mSpsSize + ", ppsSize:" + this.mPpsSize);
        this.handleEncodeResolution(mediaFormat.getInteger("width"), mediaFormat.getInteger("height"));
        ByteBuffer sps = mediaFormat.getByteBuffer("csd-0");
        ByteBuffer pps = mediaFormat.getByteBuffer("csd-1");
        if (sps == null || pps == null) {
            YMFLog.error((Object)this, "[Encoder ]", "setMediaFormatChanged error, csd-0:" + sps + ", csd-1:" + pps);
            return;
        }
        this.mSpsSize = sps.limit() - sps.position();
        this.mPpsSize = pps.limit() - pps.position();
    }

    public int getInputFrameByteSize() {
        return this.mEncoderConfig.getEncodeHeight() * this.mEncoderConfig.getEncodeWidth() * 4;
    }

    @Override
    public void onPreviewTextureAvailable(SurfaceTexture surfaceTexture) {
    }

    public void _OnError(long eid, String exceptionId, String errMsg) {
        YMFLog.error((Object)this, "[Encoder ]", "_onError get in");
        this.onEncodeError(exceptionId);
        this.mState.set(4);
    }

    @Override
    public void onError(final long eid, final String exceptionId, final String errMsg) {
        YMFLog.error((Object)this, "[Encoder ]", "hardware encoder error:" + (errMsg == null ? "null" : errMsg) + ", retryCnt:" + this.mRetryCnt++);
        if (!("2".equals(exceptionId) || eid != -1L && eid == this.mCurrentEID.get())) {
            YMFLog.info(this, "[Encoder ]", "encoder error, but it is out of date!!");
            return;
        }
        this.mbEncodingState = false;
        YMFLiveExceptionStat.getInstance().notifyException(YMFLiveExceptionType.AnchorStatus_ENCODE_ERROR);
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this._OnError(eid, exceptionId, errMsg);
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    H264HardwareEncoderFilter.this._OnError(eid, exceptionId, errMsg);
                }
            });
        }
    }

    @Override
    public void adjustBitRate(final int bitRateInKbps) {
        YMFLog.info(this, "[Encoder ]", "adjust bitrate:" + bitRateInKbps);
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            if (Constant.EncoderState.isStart(this.mState.get())) {
                this.mEncoder.adjustBitRate(bitRateInKbps);
            }
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    if (Constant.EncoderState.isStart(H264HardwareEncoderFilter.this.mState.get())) {
                        H264HardwareEncoderFilter.this.mEncoder.adjustBitRate(bitRateInKbps);
                    }
                }
            });
        }
    }

    @Override
    public boolean stopEncoderAsync() {
        YMFLog.info(this, "[Encoder ]", "H264 stopEncoderAsyenc begin");
        if (Constant.EncoderState.isStoped(this.mState.getAndSet(3))) {
            YMFLog.info(this, "[Encoder ]", "H264 stopEncoderAsyenc: no initialized state, so return");
            return false;
        }
        this.mState.set(3);
        VideoDataStat.getInstance().setVideoEncodingState(false);
        this.mEncoder.releaseEncoderAsync();
        YMFLog.info(this, "[Encoder ]", "H264 stopEncoderAsyenc done");
        return true;
    }

    @Override
    public void createGlElementEnvOnly() {
        if (this.mEncoder != null) {
            this.mEncoder.createGlElementEnv();
        }
    }

    @Override
    public void destoryGlElementEnvOnly() {
        if (this.mEncoder != null) {
            this.mEncoder.destoryGlElementEnvOnly();
        }
    }

    @Override
    public boolean startEncoderOnly(VideoEncoderConfig newConfig) {
        YMFLog.info(this, "[Encoder ]", "startEncoderOnly, config:" + newConfig.toString());
        if (Constant.EncoderState.isStart(this.mState.get())) {
            YMFLog.info(this, "[Encoder ]", "startEncoderOnly already, so return");
            return true;
        }
        this.setEncodeCfg(newConfig);
        this.mEncoder.setEncoderInputMode(this.mInputMode);
        YMFLog.info(this, "[Encoder ]", "H264HardwareEncoderFilter startEncoderOnly begin mInputMode:" + (Object)((Object)this.mInputMode));
        long eid = this.mEncoder.startEncoerAsync(this.mEncoderConfig);
        if (eid > 0L) {
            this.mCurrentEID.set(eid);
            this.mState.set(1);
            VideoDataStat.getInstance().setVideoEncodingState(true);
            YMFLog.info(this, "[Encoder ]", "H264HardwareEncoderFilter startEncoderOnly succeed end");
            this.mEncodeParam = "config:" + this.mEncoderConfig.toString() + ", real:" + this.mEncoder.getMediaFormat();
            this.mFilterContext.getEncodeParamTipsMgr().setEncoderParam(this.mEncodeParam);
            return true;
        }
        YMFLog.info(this, "[Encoder ]", "H264HardwareEncoderFilter startEncoderOnly fail end");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNoEncodedDataOut() {
        H264HardwareEncoderFilter h264HardwareEncoderFilter = this;
        synchronized (h264HardwareEncoderFilter) {
            if (this.encodedCallBack != null && !this.mFirstEncoderDataOut.get()) {
                this.encodedCallBack.onNoEncodedDataOut();
                YMFLog.info(this, "[Encoder ]", "encodedCallBack onNoEncodedDataOut!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFirstEncodedDataOut() {
        H264HardwareEncoderFilter h264HardwareEncoderFilter = this;
        synchronized (h264HardwareEncoderFilter) {
            if (this.encodedCallBack != null && !this.mFirstEncoderDataOut.get()) {
                this.encodedCallBack.onFirstEncodedDataOut();
                this.mFirstEncoderDataOut.set(true);
                YMFLog.info(this, "[Encoder ]", "onNoEncodedDataOut onFirstEncodedDataOut!");
            }
        }
    }

    protected void onEncodeError(String exceptionId) {
        if (this.mEncodeStateCallBack != null) {
            this.mEncodeStateCallBack.onEncodeError(exceptionId);
            YMFLog.info(this, "[Encoder ]", "onEncodeError exceptionId:" + exceptionId);
        }
    }

    @Override
    public boolean getCacheEncodedData() {
        if (this.mEncoder != null) {
            return ((TextureMoiveEncoderSync)this.mEncoder).getCacheEncodedData();
        }
        YMFLog.error((Object)this, "[Encoder ]", " getCacheEncodedData mEncoder == null");
        return false;
    }
}

