/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.opengl.GLES20;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.ITextureListener;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.ExternalDecoderFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.PeripheralsDecoderFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.EglFactory;
import com.yy.mediaframework.gpuimage.FilterType;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.custom.GPUImageFiltersManager;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.gpuimage.util.Rotation;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.model.YYMediaSampleAlloc;
import com.yy.mediaframework.sensor.RotationVectorSensor;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.utils.YMFLog;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class GPUPreprocessFilter
extends AbstractYYMediaFilter {
    private AtomicBoolean mInited = new AtomicBoolean(false);
    private GPUImageFiltersManager mGPUImageFiltersManager;
    private VideoLiveFilterContext mFilterContext = null;
    private RotationVectorSensor mRotationVectorSensor = null;
    private long mCurrentFrameTimeStampNanos = 0L;
    YYMediaSample mPeripheralsSample = null;
    private boolean onPeripheralsStarted = false;
    private ITextureListener mTextureListener = null;

    public GPUPreprocessFilter(VideoLiveFilterContext filterContext) {
        this.mFilterContext = filterContext;
        this.mRotationVectorSensor = this.mFilterContext.getRotationVectorSensor();
        this.mGPUImageFiltersManager = new GPUImageFiltersManager(this.mFilterContext.getAndroidContext(), this.mRotationVectorSensor, filterContext);
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        if (!this.mInited.get()) {
            return false;
        }
        if (sample.mAndoridPtsNanos <= this.mCurrentFrameTimeStampNanos && this.mCurrentFrameTimeStampNanos != 0L && !(upstream instanceof PeripheralsDecoderFilter) && !(upstream instanceof ExternalDecoderFilter)) {
            YMFLog.info(this, "[Preproce]", "same timeStamp skipping:" + sample.mAndoridPtsNanos + "," + this.mCurrentFrameTimeStampNanos);
            return false;
        }
        if (upstream instanceof PeripheralsDecoderFilter && !((PeripheralsDecoderFilter)upstream).isPeripheraHasEnd()) {
            if (this.mPeripheralsSample == null) {
                this.mPeripheralsSample = new YYMediaSample();
                this.mPeripheralsSample.reset();
            }
            if (sample.mMasterTextureId != -1) {
                this.mPeripheralsSample.assigne(sample);
            }
            this.onPeripheralsStarted = true;
            this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_PERIPHERALS);
            return false;
        }
        this.mCurrentFrameTimeStampNanos = sample.mAndoridPtsNanos;
        sample.addRef();
        long startTime = System.currentTimeMillis();
        int outWidth = sample.mWidth;
        int outHeight = sample.mHeight;
        if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_PERIPHERALS || this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_EXTERNAL) {
            outWidth = sample.mEncodeWidth;
            outHeight = sample.mEncodeHeight;
        }
        if (this.mPeripheralsSample != null && this.mPeripheralsSample.mMasterTextureId != -1) {
            if (sample.mWidth < sample.mHeight) {
                this.mGPUImageFiltersManager.setImageSize(sample.mHeight, sample.mWidth);
            }
            this.mFilterContext.mPeripheralsPosition.srcWidth = this.mPeripheralsSample.mWidth;
            this.mFilterContext.mPeripheralsPosition.srcHeight = this.mPeripheralsSample.mHeight;
            if (sample.mEncodeWidth < sample.mEncodeHeight) {
                outWidth = sample.mEncodeHeight;
                outHeight = sample.mEncodeWidth;
                sample.mEncodeWidth = outWidth;
                sample.mEncodeHeight = outHeight;
                this.mFilterContext.getVideoEncoderConfig().setEncodeSize(sample.mEncodeWidth, sample.mEncodeHeight);
            }
        } else {
            this.mGPUImageFiltersManager.setImageSize(sample.mWidth, sample.mHeight);
        }
        this.mGPUImageFiltersManager.setOutputSize(outWidth, outHeight);
        this.setOutputSize(outWidth, outHeight);
        if (this.mFilterContext.getDynamicTexture() != null) {
            this.mFilterContext.getDynamicTexture().onDoFrame();
        }
        GLES20.glViewport((int)0, (int)0, (int)outWidth, (int)outHeight);
        this.mGPUImageFiltersManager.setTextureType(sample.mTextureTarget);
        this.mGPUImageFiltersManager.onDraw(sample.mMasterTextureId, sample.mMainTransformer, sample.mDataBytes, sample.mIndex);
        if (this.mFilterContext.getLiveMode() == LiveSessionType.LIVE_MODE_PERIPHERALS) {
            this.mFilterContext.mCameraPostion.srcWidth = sample.mWidth;
            this.mFilterContext.mCameraPostion.srcHeight = sample.mHeight;
            sample.mSlaveTextureId = this.mPeripheralsSample.mMasterTextureId;
            sample.mSlaveTransformer = this.mPeripheralsSample.mMainTransformer;
        }
        sample.mMasterTextureId = this.mGPUImageFiltersManager.getLastTextureID();
        sample.mTextureTarget = 3553;
        sample.mWidth = this.mOutputWidth;
        sample.mHeight = this.mOutputHeight;
        if (this.mTextureListener != null) {
            sample.mMasterTextureId = this.mTextureListener.onTextureCallback(sample.mMasterTextureId, sample.mWidth, sample.mHeight);
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        System.arraycopy(Constant.mtxIdentity, 0, sample.mMainTransformer, 0, sample.mMainTransformer.length);
        YMFLiveStatisticManager.getInstance().calcPreProcessLatency(startTime);
        this.deliverToDownStream(sample);
        sample.decRef();
        return false;
    }

    public void init(int width, int height) {
        YMFLog.info(this, "[Preproce]", "GPUPreprocessFilter doInit");
        if (this.mInited.get()) {
            YMFLog.info(this, "[Preproce]", "init: intialized state now, so return");
            return;
        }
        this.setOutputSize(width, height);
        this.mGPUImageFiltersManager.Init(width, height);
        this.mGPUImageFiltersManager.setRotation(Rotation.NORMAL, false, false);
        this.mInited.set(true);
    }

    @Override
    public void deInit() {
        if (!this.mInited.getAndSet(false)) {
            YMFLog.info(this, "[Preproce]", "deInit: no Initialied state now, so return");
            return;
        }
        YMFLog.info(this, "[Preproce]", "GPUPreprocessFilter deInit");
        this.mGPUImageFiltersManager.destroy();
    }

    public void setGPUImageFilter(GPUImageFilter filter) {
        if (this.mGPUImageFiltersManager != null) {
            this.mGPUImageFiltersManager.setGPUImageFilter(filter);
        }
    }

    public void clearGPUImageFilters() {
        if (this.mGPUImageFiltersManager != null) {
            this.mGPUImageFiltersManager.resetGPUImageFilter();
        }
    }

    public void setFilterType(FilterType type) {
        if (type == FilterType.BeautyFace && !EglFactory.android_opengl_egl_support()) {
            YMFLog.info(this, "[Beauty  ]", "STBeautyFilter as to BeautyFace type when android api below 17!!");
            type = FilterType.STBeauty;
        }
        if (this.mGPUImageFiltersManager != null) {
            this.mGPUImageFiltersManager.setFilterType(type);
        }
    }

    public void setFilterInfo(FilterType type, Map<String, String> params) {
        if (type == FilterType.BeautyFace && !EglFactory.android_opengl_egl_support()) {
            YMFLog.info(this, "[Beauty  ]", "STBeautyFilter as to BeautyFace type when android api below 17!!");
            this.setFilterType(FilterType.STBeauty);
        } else {
            this.setFilterType(type);
        }
        this.setFilterParams(params);
    }

    private void setFilterParams(Map<String, String> params) {
        if (this.mGPUImageFiltersManager != null) {
            this.mGPUImageFiltersManager.setFilterParams(params);
        }
    }

    public void onPeripheralsVideoEnd() {
        YMFLog.info(this, "[Decoder ]", "onPeripheralsVideoEnd");
        this.onPeripheralsStarted = false;
        this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_NORMAL);
        if (this.mPeripheralsSample != null) {
            this.mPeripheralsSample.reset();
            YYMediaSampleAlloc.instance().free(this.mPeripheralsSample);
            this.mPeripheralsSample = null;
        }
    }

    public void setGPUImageBeautyFilter(IGPUProcess gpuImageProcess) {
        if (this.mGPUImageFiltersManager != null && this.mGPUImageFiltersManager.getGpuImageBeautyControl() != null) {
            YMFLog.info(this, "[Beauty  ]", "setGPUImageBeautyFilter:" + gpuImageProcess);
            this.mGPUImageFiltersManager.getGpuImageBeautyControl().setGPUImageBeautyFilter(gpuImageProcess);
            if (!this.mFilterContext.getGLManager().checkSameThread()) {
                this.mFilterContext.getGlManager().post(new Runnable(){

                    @Override
                    public void run() {
                        if (GPUPreprocessFilter.this.mGPUImageFiltersManager != null) {
                            GPUPreprocessFilter.this.mGPUImageFiltersManager.checkFilterUpdate(true);
                        }
                    }
                });
            } else if (this.mGPUImageFiltersManager != null) {
                this.mGPUImageFiltersManager.checkFilterUpdate(true);
            }
        }
    }

    public void setTextureListener(ITextureListener textureListener) {
        this.mTextureListener = textureListener;
    }
}

