/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import android.annotation.SuppressLint;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.YMFStreamSyncSourceManager;
import com.yy.mediaframework.facedetection.IYMFPreviewFrameCallback;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gpuimage.custom.YMFVideoFrame;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.model.YYMediaSampleAlloc;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.utils.TimeUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

@SuppressLint(value={"NewApi"})
public class CameraCaptureFilter
extends AbstractYYMediaFilter
implements SurfaceTexture.OnFrameAvailableListener,
IYMFPreviewFrameCallback {
    private static final String TAG = "CameraCaptureFilter";
    public int[] mCaptureTexturesIds;
    public SurfaceTexture[] mCaptureSurfaceTextures;
    public long mTextureCreatedThreadId = -1L;
    AtomicBoolean mInited = new AtomicBoolean(false);
    VideoLiveFilterContext mFilterContext = null;
    private long mCurrentFrameTimeDeltaTickcountNanos = 0L;
    public float[] mSlaveTransformer = new float[16];
    private int mExpectDataLen;
    private long feedFrameCounter = 0L;
    private long feedCurrentTime = 0L;
    private long lastPrintTime = 0L;
    private List<Long> mCaptureRateList = new ArrayList<Long>();
    private long maxDealTime = 0L;
    private long averageDealTime = 0L;
    private long mDropCount = 0L;
    private long mLastTick = 0L;
    private List<Long> mDropCountList = new ArrayList<Long>();
    private List<Long> mCaptureAverageDealTimeList = new ArrayList<Long>();
    private List<Long> mCaptureMaxDealTimeList = new ArrayList<Long>();
    private byte[] mCameraNV21Data = null;
    private long mYuvCaptureYYPtsMillions = 0L;
    private long mIndex = 0L;
    private AtomicBoolean mCameraNV21DataUsed = null;
    private AtomicInteger mCameraFps = new AtomicInteger(0);
    private int mWidth = 0;
    private int mHeight = 0;
    private ReentrantLock mCaptureLock = new ReentrantLock(true);
    private static final int MAX_BUFFER_COUNT = 1;
    private YMFImageBuffer[] mNv21Buffer = new YMFImageBuffer[1];
    private HashMap<Long, YYMediaSample> mSampleMap = new HashMap();
    private long mSampleCaptureIndex = 0L;
    private long mSampleRenderIndex = 0L;

    public CameraCaptureFilter(VideoLiveFilterContext filterContext) {
        this.mFilterContext = filterContext;
        YMFLog.info(this, "[CCapture]", "CameraCaptureFilter construct");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit() {
        YMFLog.info(this, "[CCapture]", "CameraCaptureFilter doInit begin");
        AtomicBoolean atomicBoolean = this.mInited;
        synchronized (atomicBoolean) {
            if (this.mInited.get()) {
                return;
            }
            if (CameraInterface.getInstance().isDualCameraSupported()) {
                this.mCaptureTexturesIds = new int[2];
                this.mCaptureSurfaceTextures = new SurfaceTexture[2];
            } else {
                this.mCaptureTexturesIds = new int[1];
                this.mCaptureSurfaceTextures = new SurfaceTexture[1];
            }
            GLES20.glGenTextures((int)this.mCaptureSurfaceTextures.length, (int[])this.mCaptureTexturesIds, (int)0);
            for (int i = 0; i < this.mCaptureTexturesIds.length; ++i) {
                GLES20.glBindTexture((int)36197, (int)this.mCaptureTexturesIds[i]);
                GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
                GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
                GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
                GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
                this.mCaptureSurfaceTextures[i] = new SurfaceTexture(this.mCaptureTexturesIds[i]);
                this.mCaptureSurfaceTextures[i].setDefaultBufferSize(this.mFilterContext.getCameraPreviewConfig().getWidth(), this.mFilterContext.getCameraPreviewConfig().getHeight());
                YMFLog.info(this, "[CCapture]", "setDefaultBufferSize:" + this.mFilterContext.getCameraPreviewConfig().getWidth() + "*" + this.mFilterContext.getCameraPreviewConfig().getHeight() + " texture:" + this.mCaptureSurfaceTextures[i]);
                this.mCaptureSurfaceTextures[i].setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            }
            this.mTextureCreatedThreadId = Thread.currentThread().getId();
            YMFLiveStatisticManager.getInstance().setGpuDeviceName(GlUtil.getGpuVendor());
            this.mCameraNV21Data = null;
            this.mInited.set(true);
            this.mInited.notifyAll();
            this.mYuvCaptureYYPtsMillions = 0L;
        }
        YMFLog.info(this, "[CCapture]", "CameraCaptureFilter doInit done");
    }

    public void init() {
        YMFLog.info(this, "[CCapture]", "CameraCaptureFilter init begin");
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this.doInit();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    CameraCaptureFilter.this.doInit();
                }
            });
        }
        YMFLog.info(this, "[CCapture]", "CameraCaptureFilter init done");
    }

    @Override
    public void deInit() {
        if (this.mFilterContext.getGlManager().checkSameThread()) {
            this.doDeInit();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    CameraCaptureFilter.this.doDeInit();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeInit() {
        AtomicBoolean atomicBoolean = this.mInited;
        synchronized (atomicBoolean) {
            if (!this.mInited.get()) {
                YMFLog.info(this, "[CCapture]", "doDeInit: no Initalized state, so return");
                return;
            }
            YMFLog.info(this, "[CCapture]", "doDeInit begin");
            CameraInterface.getInstance().reSetPreviewSurfaceTexture(this.mCaptureSurfaceTextures);
            for (SurfaceTexture surfaceTexture : this.mCaptureSurfaceTextures) {
                surfaceTexture.release();
                surfaceTexture = null;
            }
            if (this.mCaptureTexturesIds.length > 0) {
                GLES20.glDeleteTextures((int)this.mCaptureSurfaceTextures.length, (int[])this.mCaptureTexturesIds, (int)0);
            }
            this.mCameraNV21Data = null;
            this.mInited.set(false);
            this.mInited.notifyAll();
            YMFLog.info(this, "[CCapture]", "doDeInit done");
        }
    }

    public SurfaceTexture[] getCaptureSurfaceTextures() {
        return this.mCaptureSurfaceTextures;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sammple, Object upstream) {
        return false;
    }

    private void handleFrameAvailable(SurfaceTexture surfaceTexture) {
        long time_start = System.currentTimeMillis();
        if (!this.mInited.get() || !surfaceTexture.equals(this.mCaptureSurfaceTextures[0]) && !surfaceTexture.equals(this.mCaptureSurfaceTextures[1])) {
            YMFLog.error((Object)this, "[CCapture]", "handleFrameAvailble, not same surfaceTexture or not initialized");
            return;
        }
        surfaceTexture.updateTexImage();
        if (this.mFilterContext.getPictureInPictureFlag() && this.mCaptureSurfaceTextures.length > 1 && this.mCaptureSurfaceTextures[1].equals(surfaceTexture)) {
            surfaceTexture.getTransformMatrix(this.mSlaveTransformer);
            return;
        }
        if (this.mCurrentFrameTimeDeltaTickcountNanos == 0L && surfaceTexture.getTimestamp() != 0L) {
            this.mCurrentFrameTimeDeltaTickcountNanos = surfaceTexture.getTimestamp() - TimeUtil.getTickCountLong() * 1000000L;
            YMFLog.info(this, "[CCapture]", "onFrameAvailable timestamp:" + surfaceTexture.getTimestamp() + " tickcount:" + TimeUtil.getTickCountLong() + " delta:" + this.mCurrentFrameTimeDeltaTickcountNanos);
        }
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        sample.mWidth = this.mFilterContext.getCameraPreviewConfig().getWidth();
        sample.mHeight = this.mFilterContext.getCameraPreviewConfig().getHeight();
        sample.mAndoridPtsNanos = surfaceTexture.getTimestamp();
        sample.mYYPtsMillions = this.mCurrentFrameTimeDeltaTickcountNanos == 0L ? TimeUtil.getTickCountLong() : (sample.mAndoridPtsNanos - this.mCurrentFrameTimeDeltaTickcountNanos) / 1000000L;
        sample.mResMode = this.mFilterContext.getCameraPreviewConfig().getResMode();
        sample.mPictureInPictureDisplayInfo = CameraInterface.getInstance().getPictureInPictureDisplayInfo();
        sample.mImageFormat = 17;
        sample.mCameraFacing = CameraInterface.getInstance().getAndroidCameraFacing();
        if (this.mFilterContext.getCaptureReplaceImageFlag()) {
            sample.mCameraFacing = 0;
        }
        sample.mOrginalCameraFacing = CameraInterface.getInstance().getOrginalCameraFacing();
        sample.mOrientation = this.mFilterContext.mAndroidContext.getResources().getConfiguration().orientation;
        sample.mVideoStabilization = this.mFilterContext.getVideoEncoderConfig().videoStabilization;
        surfaceTexture.getTransformMatrix(sample.mMainTransformer);
        if (this.mFilterContext.getPictureInPictureFlag()) {
            if (sample.mOrginalCameraFacing == sample.mCameraFacing) {
                sample.mMasterTextureId = this.mCaptureTexturesIds[0];
                sample.mSlaveTextureId = this.mCaptureTexturesIds[1];
            } else {
                sample.mMasterTextureId = this.mCaptureTexturesIds[1];
                sample.mSlaveTextureId = this.mCaptureTexturesIds[0];
            }
            this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_DUALCAMERA);
            sample.mSlaveTransformer = this.mSlaveTransformer;
        } else {
            sample.mMasterTextureId = this.mCaptureTexturesIds[0];
            sample.mSlaveTextureId = -1;
            sample.mSlaveTransformer = null;
        }
        sample.mIsMirrorEnable = this.mFilterContext.getMirrorFlag();
        sample.mIsPreviewMirrorEnable = this.mFilterContext.getPreviwMirrorFlag();
        sample.mTextureTarget = 36197;
        sample.mTextureCreatedThreadId = this.mTextureCreatedThreadId;
        sample.mEncodeWidth = this.mFilterContext.getVideoEncoderConfig().getEncodeWidth();
        sample.mEncodeHeight = this.mFilterContext.getVideoEncoderConfig().getEncodeHeight();
        sample.mEncoderType = this.mFilterContext.getVideoEncoderConfig().mEncodeType;
        sample.mScreenCropArea = null;
        sample.mImageFormat = 70;
        sample.mEncoderInputMode = Constant.EncoderInputMode.SURFACE;
        sample.mUseGPUBeauty = this.mFilterContext.mHasBeautyProcess;
        YMFLiveStatisticManager.getInstance().beginGlCaptureTime();
        YMFLiveStatisticManager.getInstance().setCameraCaptureFrameRate();
        YMFLiveStatisticManager.getInstance().beginCapture2Encode(sample.mYYPtsMillions);
        YMFLiveStatisticManager.getInstance().setVideoPtsMaxDiff(sample.mYYPtsMillions);
        if (YMFStreamSyncSourceManager.getInstance().getAndResetSyncSourceFlag(sample.mYYPtsMillions)) {
            YMFLog.info(this, "[SSRC]", " ssrc :" + sample.mYYPtsMillions + "," + YMFStreamSyncSourceManager.getInstance().mHighStreamFirstSsrc);
        }
        this.deliverToDownStream(sample);
        sample.decRef();
        this.calculateCameraCaptureFrameRate(System.currentTimeMillis() - time_start);
    }

    private void handleFrameAvailable(byte[] data, int width, int height, long index) {
        int indexBuf;
        if (!this.mInited.get()) {
            return;
        }
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        sample.mDataBytes = data;
        sample.mIndex = index;
        sample.mIsYUVBuffer = true;
        sample.mMasterTextureId = -1;
        sample.mSlaveTextureId = -1;
        sample.mTextureTarget = -1;
        sample.mScreenCropArea = null;
        sample.mYYPtsMillions = this.mYuvCaptureYYPtsMillions;
        sample.mImageFormat = 0;
        sample.mCameraFacing = CameraInterface.getInstance().getAndroidCameraFacing();
        sample.mDataMirror = false;
        if (sample.mCameraFacing == 0) {
            sample.mIsMirrorEnable = false;
            sample.mIsPreviewMirrorEnable = false;
        }
        CameraInterface cam = CameraInterface.getInstance();
        sample.mWidth = width;
        sample.mHeight = height;
        sample.mCameraRotate = cam.getRotation();
        boolean bl = sample.mSwapWidthHeight = sample.mCameraRotate == 90 || sample.mCameraRotate == 270;
        if (YMFStreamSyncSourceManager.getInstance().getAndResetSyncSourceFlag(sample.mYYPtsMillions)) {
            YMFLog.info(this, "[SSRC]", " ssrc :" + sample.mYYPtsMillions + "," + YMFStreamSyncSourceManager.getInstance().mHighStreamFirstSsrc);
        }
        if (this.mFilterContext.isYuvTextureMode() || this.mFilterContext.isUseYuvCapture()) {
            sample.mCameraNV21DataUsed = this.mCameraNV21DataUsed;
            if (this.mFilterContext.getCaptureReplaceImageFlag()) {
                sample.mCameraFacing = 0;
            }
            sample.mOrginalCameraFacing = CameraInterface.getInstance().getOrginalCameraFacing();
            sample.mPictureInPictureDisplayInfo = CameraInterface.getInstance().getPictureInPictureDisplayInfo();
            if (this.mFilterContext.getPictureInPictureFlag()) {
                if (sample.mOrginalCameraFacing == sample.mCameraFacing) {
                    sample.mMasterTextureId = this.mCaptureTexturesIds[0];
                    sample.mSlaveTextureId = this.mCaptureTexturesIds[1];
                } else {
                    sample.mMasterTextureId = this.mCaptureTexturesIds[1];
                    sample.mSlaveTextureId = this.mCaptureTexturesIds[0];
                }
                this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_DUALCAMERA);
                sample.mSlaveTransformer = this.mSlaveTransformer;
            } else {
                sample.mMasterTextureId = this.mCaptureTexturesIds[0];
                sample.mSlaveTextureId = -1;
                sample.mSlaveTransformer = null;
            }
            sample.mIsMirrorEnable = this.mFilterContext.getMirrorFlag();
            sample.mIsPreviewMirrorEnable = this.mFilterContext.getPreviwMirrorFlag();
        }
        if (this.mNv21Buffer[indexBuf = (int)(this.mIndex % 1L)] == null || this.mNv21Buffer[indexBuf].mWidth != sample.mWidth || this.mNv21Buffer[indexBuf].mHeight != sample.mHeight) {
            this.mNv21Buffer[indexBuf] = new YMFImageBuffer(sample.mWidth, sample.mHeight, 0, true);
        }
        sample.mNv21Buffer = this.mNv21Buffer[indexBuf];
        System.arraycopy(data, 0, this.mNv21Buffer[indexBuf].mData.array(), this.mNv21Buffer[indexBuf].mData.arrayOffset(), sample.mDataBytes.length);
        this.mSampleMap.put(this.mSampleCaptureIndex++, sample);
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                long timeStart = System.currentTimeMillis();
                if (CameraCaptureFilter.this.mSampleMap.containsKey(CameraCaptureFilter.this.mSampleRenderIndex)) {
                    YYMediaSample sample = (YYMediaSample)CameraCaptureFilter.this.mSampleMap.get(CameraCaptureFilter.this.mSampleRenderIndex);
                    sample.mUseGPUBeauty = CameraCaptureFilter.this.mFilterContext.mHasBeautyProcess;
                    sample.mIsMirrorEnable = CameraCaptureFilter.this.mFilterContext.getMirrorFlag();
                    sample.mResMode = CameraCaptureFilter.this.mFilterContext.getCameraPreviewConfig().getResMode();
                    sample.mOrientation = CameraCaptureFilter.this.mFilterContext.mAndroidContext.getResources().getConfiguration().orientation;
                    sample.mEncodeWidth = CameraCaptureFilter.this.mFilterContext.getVideoEncoderConfig().getEncodeWidth();
                    sample.mEncodeHeight = CameraCaptureFilter.this.mFilterContext.getVideoEncoderConfig().getEncodeHeight();
                    sample.mEncoderType = CameraCaptureFilter.this.mFilterContext.getVideoEncoderConfig().mEncodeType;
                    sample.mEncoderInputMode = CameraCaptureFilter.this.mFilterContext.getEncoderInputMode();
                    sample.mIsPreviewMirrorEnable = CameraCaptureFilter.this.mFilterContext.getPreviwMirrorFlag();
                    YMFLiveStatisticManager.getInstance().beginGlCaptureTime();
                    YMFLiveStatisticManager.getInstance().beginCapture2Encode(sample.mYYPtsMillions);
                    YMFLiveStatisticManager.getInstance().setVideoPtsMaxDiff(sample.mYYPtsMillions);
                    YMFLiveStatisticManager.getInstance().setCameraCaptureFrameRate();
                    CameraCaptureFilter.this.deliverToDownStream(sample);
                    if (!CameraCaptureFilter.this.mFilterContext.isYuvTextureMode()) {
                        CameraCaptureFilter.this.mCameraNV21DataUsed.set(true);
                    }
                    sample.decRef();
                    CameraCaptureFilter.this.mSampleMap.remove(CameraCaptureFilter.this.mSampleRenderIndex);
                    CameraCaptureFilter.this.calculateCameraCaptureFrameRate(System.currentTimeMillis() - timeStart);
                    CameraCaptureFilter.this.mSampleRenderIndex++;
                }
            }
        });
    }

    private void handleFrameAvaliable() {
        if (!this.mInited.get() || this.mCameraNV21DataUsed.get()) {
            return;
        }
        long time_start = System.currentTimeMillis();
        YYMediaSample sample = YYMediaSampleAlloc.instance().alloc();
        this.mCaptureLock.lock();
        sample.mDataBytes = this.mCameraNV21Data;
        sample.mIndex = this.mIndex;
        sample.mIsYUVBuffer = true;
        sample.mMasterTextureId = -1;
        sample.mSlaveTextureId = -1;
        sample.mTextureTarget = -1;
        sample.mScreenCropArea = null;
        sample.mUseGPUBeauty = this.mFilterContext.mHasBeautyProcess;
        sample.mIsMirrorEnable = this.mFilterContext.getMirrorFlag();
        sample.mImageFormat = 0;
        sample.mResMode = this.mFilterContext.getCameraPreviewConfig().getResMode();
        sample.mYYPtsMillions = this.mYuvCaptureYYPtsMillions;
        sample.mCameraFacing = CameraInterface.getInstance().getAndroidCameraFacing();
        sample.mOrientation = this.mFilterContext.mAndroidContext.getResources().getConfiguration().orientation;
        sample.mEncodeWidth = this.mFilterContext.getVideoEncoderConfig().getEncodeWidth();
        sample.mEncodeHeight = this.mFilterContext.getVideoEncoderConfig().getEncodeHeight();
        sample.mEncoderType = this.mFilterContext.getVideoEncoderConfig().mEncodeType;
        sample.mEncoderInputMode = this.mFilterContext.getEncoderInputMode();
        sample.mIsPreviewMirrorEnable = this.mFilterContext.getPreviwMirrorFlag();
        sample.mDataMirror = false;
        if (sample.mCameraFacing == 0) {
            sample.mIsMirrorEnable = false;
            sample.mIsPreviewMirrorEnable = false;
        }
        CameraInterface cam = CameraInterface.getInstance();
        sample.mWidth = this.mWidth;
        sample.mHeight = this.mHeight;
        sample.mCameraRotate = cam.getRotation();
        boolean bl = sample.mSwapWidthHeight = sample.mCameraRotate == 90 || sample.mCameraRotate == 270;
        if (YMFStreamSyncSourceManager.getInstance().getAndResetSyncSourceFlag(sample.mYYPtsMillions)) {
            YMFLog.info(this, "[SSRC]", " ssrc :" + sample.mYYPtsMillions + "," + YMFStreamSyncSourceManager.getInstance().mHighStreamFirstSsrc);
        }
        if (this.mFilterContext.isYuvTextureMode() || this.mFilterContext.isUseYuvCapture()) {
            sample.mCameraNV21DataUsed = this.mCameraNV21DataUsed;
            if (this.mFilterContext.getCaptureReplaceImageFlag()) {
                sample.mCameraFacing = 0;
            }
            sample.mOrginalCameraFacing = CameraInterface.getInstance().getOrginalCameraFacing();
            sample.mPictureInPictureDisplayInfo = CameraInterface.getInstance().getPictureInPictureDisplayInfo();
            if (this.mFilterContext.getPictureInPictureFlag()) {
                if (sample.mOrginalCameraFacing == sample.mCameraFacing) {
                    sample.mMasterTextureId = this.mCaptureTexturesIds[0];
                    sample.mSlaveTextureId = this.mCaptureTexturesIds[1];
                } else {
                    sample.mMasterTextureId = this.mCaptureTexturesIds[1];
                    sample.mSlaveTextureId = this.mCaptureTexturesIds[0];
                }
                this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_DUALCAMERA);
                sample.mSlaveTransformer = this.mSlaveTransformer;
            } else {
                sample.mMasterTextureId = this.mCaptureTexturesIds[0];
                sample.mSlaveTextureId = -1;
                sample.mSlaveTransformer = null;
            }
            sample.mIsMirrorEnable = this.mFilterContext.getMirrorFlag();
            sample.mIsPreviewMirrorEnable = this.mFilterContext.getPreviwMirrorFlag();
        }
        YMFLiveStatisticManager.getInstance().beginGlCaptureTime();
        YMFLiveStatisticManager.getInstance().beginCapture2Encode(sample.mYYPtsMillions);
        YMFLiveStatisticManager.getInstance().setVideoPtsMaxDiff(sample.mYYPtsMillions);
        this.mCaptureLock.unlock();
        this.deliverToDownStream(sample);
        sample.decRef();
        if (!this.mFilterContext.isYuvTextureMode()) {
            this.mCameraNV21DataUsed.set(true);
        }
        YMFLiveStatisticManager.getInstance().setCameraCaptureFrameRate();
        this.calculateCameraCaptureFrameRate(System.currentTimeMillis() - time_start);
    }

    private String transform2String(float[] transform) {
        StringBuilder builder = new StringBuilder();
        for (float f : transform) {
            builder.append(String.valueOf(f));
            builder.append("_");
        }
        return builder.toString();
    }

    public void onFrameAvailable(final SurfaceTexture surfaceTexture) {
        if (!this.mFilterContext.isUseYuvCapture() && !this.mFilterContext.isYuvTextureMode()) {
            if (this.mFilterContext.getGlManager().checkSameThread()) {
                this.handleFrameAvailable(surfaceTexture);
            } else {
                this.mFilterContext.getGlManager().post(new Runnable(){

                    @Override
                    public void run() {
                        CameraCaptureFilter.this.handleFrameAvailable(surfaceTexture);
                    }
                });
            }
        } else if (!this.mFilterContext.isYuvTextureMode()) {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    surfaceTexture.updateTexImage();
                }
            });
        }
    }

    private void requireDealCameraFrame() {
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            this.handleFrameAvaliable();
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    CameraCaptureFilter.this.handleFrameAvaliable();
                }
            });
        }
    }

    @Override
    public void onPreviewFrameAvailable(int imageFormat, byte[] data, int previewWidth, int previewHeight, Camera camera) {
        if (this.mFilterContext.isUseYuvCapture() || this.mFilterContext.isYuvTextureMode()) {
            if (this.mCameraNV21DataUsed == null) {
                this.mCameraNV21DataUsed = new AtomicBoolean(true);
            }
            if (this.mCameraNV21DataUsed.get()) {
                this.mCaptureLock.lock();
                if (this.mCameraNV21Data == null || this.mCameraNV21Data.length != data.length) {
                    this.mWidth = previewWidth;
                    this.mHeight = previewHeight;
                    int buffSize = this.mWidth * this.mHeight * ImageFormat.getBitsPerPixel((int)17) / 8;
                    this.mCameraNV21Data = new byte[buffSize];
                }
                this.mYuvCaptureYYPtsMillions = TimeUtil.getTickCountLong();
                System.arraycopy(data, 0, this.mCameraNV21Data, 0, data.length);
                this.mCaptureLock.unlock();
                this.mCameraNV21DataUsed.set(false);
                this.requireDealCameraFrame();
            }
        }
    }

    @Override
    public void onPreviewFrameAvailable(YMFVideoFrame videoFrame) {
        if (videoFrame == null) {
            return;
        }
        if (this.mFilterContext.isUseYuvCapture() || this.mFilterContext.isYuvTextureMode()) {
            this.mCameraNV21DataUsed = videoFrame.mWillBeRendered;
            if (this.mCameraNV21DataUsed.get()) {
                this.mCameraNV21DataUsed.set(false);
                this.mIndex = videoFrame.mIndex;
                this.mYuvCaptureYYPtsMillions = TimeUtil.getTickCountLong();
                this.handleFrameAvailable(videoFrame.mYUVCaptureBuffer, videoFrame.mYuvWidth, videoFrame.mYuvHeight, videoFrame.mIndex);
            }
        }
    }

    private void calculateCameraCaptureFrameRate(long dealTime) {
        try {
            ++this.feedFrameCounter;
            this.feedCurrentTime = System.currentTimeMillis();
            this.maxDealTime = this.maxDealTime < dealTime ? dealTime : this.maxDealTime;
            this.averageDealTime += dealTime;
            if (this.feedCurrentTime - this.lastPrintTime >= 1000L) {
                this.mCameraFps.set((int)this.feedFrameCounter);
                this.mCaptureRateList.add(this.feedFrameCounter);
                this.mCaptureAverageDealTimeList.add(this.averageDealTime / this.feedFrameCounter);
                this.mCaptureMaxDealTimeList.add(this.maxDealTime);
                this.mDropCountList.add(this.mDropCount);
                if (this.mFilterContext.mDeliverCallback != null) {
                    this.mFilterContext.mDeliverCallback.onVideoFrameProcessTime(this.maxDealTime, (float)this.averageDealTime / (float)this.feedFrameCounter);
                }
                VideoDataStat.getInstance().setCameraCaptureFrameRate(this.feedFrameCounter);
                if (this.mCaptureRateList.size() >= 5) {
                    this.printFrameRate("CameraCapture", this.mCaptureRateList, this.mCaptureAverageDealTimeList, this.mCaptureMaxDealTimeList, this.mDropCountList);
                    this.mCaptureRateList.clear();
                    this.mCaptureMaxDealTimeList.clear();
                    this.mCaptureAverageDealTimeList.clear();
                    this.mDropCountList.clear();
                }
                this.feedFrameCounter = 0L;
                this.lastPrintTime = this.feedCurrentTime;
                this.maxDealTime = 0L;
                this.averageDealTime = 0L;
                this.mDropCount = 0L;
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[CCapture]", "printCameraCaptureFrameRate exception:" + e.toString());
        }
    }

    private void printFrameRate(String type, List<Long> list, List<Long> list2, List<Long> list3, List<Long> list4) {
        if (null == list) {
            return;
        }
        String str = " ";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i) + ":" + list2.get(i) + ":" + list3.get(i) + ":" + list4.get(i) + ", ";
        }
        YMFLog.info(this, "[CCapture]", "handleFrameAvailable feed data frame rate::[" + str + "] type:" + type + " yuv:" + this.mFilterContext.isUseYuvCapture() + " beauty:" + this.mFilterContext.mHasBeautyProcess + " " + this.mFilterContext.mViewState);
    }

    public int getCurrentCameraFps() {
        return this.mCameraFps.get();
    }
}

