/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.filters;

import com.yy.mediaframework.IMediaFilter;
import com.yy.mediaframework.model.YYMediaSample;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public abstract class AbstractYYMediaFilter
implements IMediaFilter {
    protected ArrayList<IMediaFilter> mDownStreamList = new ArrayList();
    protected int mImageWidth = 0;
    protected int mImageHeight = 0;
    protected int mOutputWidth = 0;
    protected int mOutputHeight = 0;
    final float[] SLAVE_VEX_RIGHT_BOTTOM = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 1.0f, -1.0f};
    protected FloatBuffer mSlaveVertexBuffer = ByteBuffer.allocateDirect(this.SLAVE_VEX_RIGHT_BOTTOM.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();

    protected AbstractYYMediaFilter() {
        this.mSlaveVertexBuffer.put(this.SLAVE_VEX_RIGHT_BOTTOM).position(0);
    }

    public void setImageSize(int imageWidth, int imageHeight) {
        this.mImageHeight = imageHeight;
        this.mImageWidth = imageWidth;
    }

    public boolean checkImageSizeUpdated(int imageWidth, int imageHeight, boolean update) {
        if (imageWidth != this.mImageWidth || imageHeight != this.mImageHeight) {
            if (update) {
                this.mImageWidth = imageWidth;
                this.mImageHeight = imageHeight;
            }
            return true;
        }
        return false;
    }

    public boolean checkOuptuSizeUpdate(int outputWidth, int outputHeight, boolean update) {
        if (outputWidth != this.mOutputWidth || outputHeight != this.mOutputHeight) {
            if (update) {
                this.mOutputWidth = outputWidth;
                this.mOutputHeight = outputHeight;
            }
            return true;
        }
        return false;
    }

    public void setOutputSize(int width, int height) {
        this.mOutputWidth = width;
        this.mOutputHeight = height;
    }

    @Override
    public boolean processMediaSample(YYMediaSample sample, Object upstream) {
        return false;
    }

    public AbstractYYMediaFilter addDownStream(IMediaFilter downStream) {
        if (this.mDownStreamList.indexOf(downStream) < 0) {
            this.mDownStreamList.add(downStream);
        }
        return this;
    }

    public void removeDownStream(IMediaFilter downStrean) {
        this.mDownStreamList.remove(downStrean);
    }

    public void removeAllDownStream() {
        this.mDownStreamList.clear();
    }

    public boolean deliverToDownStream(YYMediaSample sample) {
        for (IMediaFilter filter : this.mDownStreamList) {
            filter.processMediaSample(sample, this);
        }
        return false;
    }

    public void deInit() {
    }
}

