/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.facedetection;

import android.hardware.Camera;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraUtils;
import com.yy.mediaframework.YYCamera;
import com.yy.mediaframework.facedetection.IYMFPreviewFrameCallback;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.mediaframework.gpuimage.custom.YMFVideoFrame;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class CameraPreviewCallbackHost
implements Camera.PreviewCallback {
    private static final String TAG = "CameraPreviewCallbackHost";
    private ArrayList<PreviewFrameCallback> mCameraPreviewClientList = new ArrayList();
    private IYMFPreviewFrameCallback mYMFPreviewFrameCallback = null;
    private Object syncLock = new Object();
    private int previewWidth;
    private int previewHeight;
    private YMFVideoFrame mYMFVideoFrame = new YMFVideoFrame();
    private long mIndex = 0L;
    private AtomicBoolean mCameraNV21DataUsed = new AtomicBoolean(true);

    public void updatePreviewSize(int width, int height) {
        this.previewHeight = height;
        this.previewWidth = width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setYMFPreviewFrameCallback(IYMFPreviewFrameCallback callback) {
        Object object = this.syncLock;
        synchronized (object) {
            YMFLog.info(this, "[Preview ]", "CameraPreviewCallbackHost setYMFPreviewFrameCallback");
            this.mYMFPreviewFrameCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(PreviewFrameCallback callback) {
        Object object = this.syncLock;
        synchronized (object) {
            if (!this.mCameraPreviewClientList.contains(callback)) {
                this.mCameraPreviewClientList.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(PreviewFrameCallback callback) {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.mCameraPreviewClientList.contains(callback)) {
                this.mCameraPreviewClientList.remove(callback);
            }
        }
    }

    public void setPreviewCallbackWithBuffer() {
        YMFLog.info(this, "[Preview ]", "CameraPreviewCallbackHost setPreviewCallbackWithBuffer");
        YYCamera.getInstance().setPreviewCallbackWithBuffer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        if (data == null || !CameraUtils.queryCameraBufferHashCode(data.hashCode())) {
            YMFLog.warn(this, "[CCapture]", " cameraDataBuffer is old");
            return;
        }
        Object object = this.syncLock;
        synchronized (object) {
            try {
                long mStartTime = System.currentTimeMillis();
                ++this.mIndex;
                this.mYMFVideoFrame.mImageFormat = 17;
                this.mYMFVideoFrame.mYUVCaptureBuffer = data;
                if (this.mYMFVideoFrame.mYuvWidth * this.mYMFVideoFrame.mYuvHeight * 3 / 2 != data.length) {
                    this.mYMFVideoFrame.mYuvWidth = camera.getParameters().getPreviewSize().width;
                    this.mYMFVideoFrame.mYuvHeight = camera.getParameters().getPreviewSize().height;
                }
                this.mYMFVideoFrame.mCamera = camera;
                this.mYMFVideoFrame.mIndex = this.mIndex;
                this.mYMFVideoFrame.mWillBeRendered = this.mCameraNV21DataUsed;
                if (this.mCameraPreviewClientList != null && this.mCameraPreviewClientList.size() > 0) {
                    for (PreviewFrameCallback cameraPreviewFrame : this.mCameraPreviewClientList) {
                        if (cameraPreviewFrame == null) continue;
                        if (cameraPreviewFrame instanceof IYMFPreviewFrameCallback) {
                            ((IYMFPreviewFrameCallback)cameraPreviewFrame).onPreviewFrameAvailable(this.mYMFVideoFrame);
                            continue;
                        }
                        cameraPreviewFrame.onPreviewFrameAvailable(17, data, camera.getParameters().getPreviewSize().width, camera.getParameters().getPreviewSize().height, camera);
                    }
                }
                if (this.mYMFPreviewFrameCallback != null) {
                    this.mYMFPreviewFrameCallback.onPreviewFrameAvailable(this.mYMFVideoFrame);
                }
                YMFLiveStatisticManager.getInstance().calcPureYuvCallbackLatency(mStartTime);
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Preview ]", " ui code error " + e.toString());
            }
        }
        CameraInterface.getInstance().addCallbackBuffer(data);
    }
}

