/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.encoder;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.Surface;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.encoder.HardEncodeListner;
import com.yy.mediaframework.model.YMFImageBuffer;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.stat.UploadStatManager;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.VideoDataStatUtil;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.utils.MediaCodecUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@TargetApi(value=18)
public abstract class HardSurfaceEncoder {
    private static String TAG = "HardSurfaceEncoder";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 2000;
    MediaCodec mEncoder;
    MediaCodec.BufferInfo mBufferInfo;
    private MediaFormat mMediaformat = null;
    private int mColorFormat;
    int mWidth;
    int mHeight;
    int mFps;
    int mBps;
    private static String mCodecName = null;
    private LinkedList<Long> mCachedPtsList = new LinkedList();
    boolean mInitialized = false;
    private Surface mInputSurface;
    HardEncodeListner mListener;
    private AtomicLong mEncodeId = new AtomicLong(-1L);
    private long mEncodedDeltaPts = 0L;
    private boolean mFirstEncodedFrame = true;
    int mLevel;
    int mProfile;
    String mMime = "";
    private String mStrFormat = "";
    private boolean mLowDelay = false;
    private boolean mHasEncodeData = false;
    private byte[] mYuvData = null;
    private boolean mEofFlag = false;

    HardSurfaceEncoder(String tag, String mime, long eid) {
        TAG = tag;
        this.mMime = mime;
        this.mEncodeId.set(eid);
    }

    public static boolean IsAvailable() {
        return Build.VERSION.SDK_INT >= 18;
    }

    public Surface getInputSurface() {
        return this.mInputSurface;
    }

    private void setProfileLevel(MediaFormat mediaFormat, VideoEncoderConfig config) {
        MediaCodecInfo.CodecProfileLevel[] pr = this.mEncoder.getCodecInfo().getCapabilitiesForType((String)this.mMime).profileLevels;
        this.mLevel = 0;
        this.mProfile = 0;
        if (this.mMime.equals("video/hevc")) {
            for (MediaCodecInfo.CodecProfileLevel aPr : pr) {
                if (this.mProfile != aPr.profile || this.mLevel > aPr.level) continue;
                this.mProfile = aPr.profile;
                this.mLevel = aPr.level;
            }
        } else if (!config.mLowDelay && config.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
            for (MediaCodecInfo.CodecProfileLevel aPr : pr) {
                if (aPr.profile > 64) continue;
                if (this.mProfile < aPr.profile) {
                    this.mProfile = aPr.profile;
                    this.mLevel = aPr.level;
                    continue;
                }
                if (this.mProfile != aPr.profile || this.mLevel >= aPr.level) continue;
                this.mProfile = aPr.profile;
                this.mLevel = aPr.level;
            }
            if (this.mProfile > 0) {
                int n = this.mLevel = this.mLevel > 8192 ? 8192 : this.mLevel;
                if (Build.VERSION.SDK_INT >= 21) {
                    mediaFormat.setInteger("profile", this.mProfile);
                }
                mediaFormat.setInteger("level", this.mLevel);
            }
        }
    }

    private boolean setColorFormat(MediaFormat mediaFormat, Constant.EncoderInputMode inputMode) {
        if (inputMode == Constant.EncoderInputMode.BUFFER) {
            int colorFormat = MediaCodecUtil.instance().getColorFormat(this.mMime);
            if (colorFormat < 0) {
                YMFLog.error((Object)this, "[Encoder ]", "hardware encoder do not support YUV420P and YUV420SP as input !");
                return false;
            }
            mediaFormat.setInteger("color-format", colorFormat);
            this.mColorFormat = colorFormat;
        } else {
            mediaFormat.setInteger("color-format", 2130708361);
            this.mColorFormat = 2130708361;
        }
        return true;
    }

    private void setEncodeParamFromServer(MediaFormat mediaFormat, VideoEncoderConfig config) {
        YMFLog.info(this, "[Encoder ]", "MediaCodec params:" + config.mEncodeParameter);
        try {
            if (config.mEncodeParameter != null) {
                String itemDelim = ":";
                String[] tokens = config.mEncodeParameter.split(itemDelim);
                String valueDelim = "=";
                for (int i = 0; i < tokens.length; ++i) {
                    YMFLog.info(this, "[Encoder ]", "MediaCodec parse token:" + tokens[i]);
                    Object[] keyValue = tokens[i].split(valueDelim);
                    if (keyValue.length == 2) {
                        YMFLog.info(TAG, "[Encoder ]", "MediaCodec param item, name:" + (String)keyValue[0] + ", value:" + (String)keyValue[1]);
                        this.setEncoderParams(mediaFormat, (String)keyValue[0], (String)keyValue[1]);
                        continue;
                    }
                    YMFLog.info(TAG, "[Encoder ]", "MediaCodec invalid param item:" + Arrays.toString(keyValue));
                }
            }
        }
        catch (Exception e) {
            YMFLog.info(TAG, "[Encoder ]", "MediaCodec parse exception:" + e);
            UploadStatManager.getInstance().reportException("0", "4", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(VideoEncoderConfig config, HardEncodeListner listener, Constant.EncoderInputMode inputMode) {
        HardSurfaceEncoder hardSurfaceEncoder = this;
        synchronized (hardSurfaceEncoder) {
            try {
                if (!HardSurfaceEncoder.IsAvailable()) {
                    YMFLog.error((Object)this, "[Encoder ]", "hardware encoder is not available");
                    return false;
                }
                this.deInit();
                YMFLog.info(this, "[Encoder ]", "encoder init, configure:" + config.toString());
                this.mWidth = config.getEncodeWidth();
                this.mHeight = config.getEncodeHeight();
                UploadStatManager.getInstance().setDecoderResolution(VideoDataStatUtil.getDPI(this.mWidth, this.mHeight));
                VideoDataStat.getInstance().setDynamicEncodeFrameRate(config.mFrameRate);
                this.mFps = config.mFrameRate;
                this.mBps = config.mBitRate;
                this.mLowDelay = config.mLowDelay;
                this.mEncoder = MediaCodec.createEncoderByType((String)this.mMime);
                mCodecName = this.mEncoder.getName();
                MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)this.mMime, (int)this.mWidth, (int)this.mHeight);
                this.setProfileLevel(mediaFormat, config);
                if (!this.setColorFormat(mediaFormat, inputMode)) {
                    this.deInit();
                    return false;
                }
                mediaFormat.setInteger("bitrate", this.mBps);
                if (Build.VERSION.SDK_INT >= 21) {
                    mediaFormat.setInteger("bitrate-mode", 2);
                }
                mediaFormat.setInteger("frame-rate", this.mFps);
                mediaFormat.setInteger("i-frame-interval", 3);
                this.setEncodeParamFromServer(mediaFormat, config);
                if (this.mLowDelay) {
                    mediaFormat.setInteger("i-frame-interval", 1);
                }
                this.mStrFormat = mediaFormat.toString();
                YMFLog.info(this, "[Encoder ]", "MediaCodec format:" + this.mStrFormat);
                this.mEncoder.configure(mediaFormat, null, null, 1);
                if (inputMode == Constant.EncoderInputMode.SURFACE) {
                    this.mInputSurface = this.mEncoder.createInputSurface();
                }
                this.mBufferInfo = new MediaCodec.BufferInfo();
                this.mEncoder.start();
                this.mInitialized = true;
                this.mFirstEncodedFrame = true;
                this.mEncodedDeltaPts = 0L;
                this.mListener = listener;
                YMFLog.info(this, "[Encoder ]", "codec:" + mCodecName + " start success, level:" + this.mLevel + ", profile:" + this.mProfile + " inputMode:" + (Object)((Object)inputMode) + " colorFormat:" + MediaCodecUtil.colorFormatToName(this.mColorFormat));
                YYVideoCodec.setCurrentEncodeName(mCodecName);
            }
            catch (Throwable t) {
                this.mInitialized = false;
                YMFLog.error((Object)this, "[Encoder ]", "init exception:" + t.toString());
                UploadStatManager.getInstance().reportException("0", "2", t.toString());
            }
            return this.mInitialized;
        }
    }

    public void deInit() {
        this.releaseEncoder();
    }

    public void recoverCachedPtsList(long dts) {
        this.mCachedPtsList.addFirst(dts);
    }

    private YMFImageBuffer selectImageBuffer(YYMediaSample sample) {
        YMFImageBuffer image;
        boolean isSemiPlanar = MediaCodecUtil.isSemiPlanar(this.mColorFormat);
        if (isSemiPlanar && sample.mImageFormat != 1) {
            YMFLog.error((Object)this, "[Encoder ]", "input image format:" + sample.mImageFormat + " not match encoder color format:" + MediaCodecUtil.colorFormatToName(this.mColorFormat));
            return null;
        }
        if (!isSemiPlanar && sample.mImageFormat != 2) {
            YMFLog.error((Object)this, "[Encoder ]", "input image format:" + sample.mImageFormat + " not match encoder color format:" + MediaCodecUtil.colorFormatToName(this.mColorFormat));
            return null;
        }
        switch (sample.mImageFormat) {
            case 1: {
                if (sample.mNV12 == null || sample.mNV12.mData == null) {
                    YMFLog.error((Object)this, "[Encoder ]", "invalid NV12 image buffer for media codec.");
                    return null;
                }
                image = sample.mNV12;
                break;
            }
            case 2: {
                if (sample.mI420 == null || sample.mI420.mData == null) {
                    YMFLog.error((Object)this, "[Encoder ]", "invalid I420 image buffer for media codec.");
                    return null;
                }
                image = sample.mI420;
                break;
            }
            default: {
                YMFLog.error((Object)this, "[Encoder ]", "invalid YUV format for media codec:" + sample.mImageFormat);
                return null;
            }
        }
        return image;
    }

    public void feedEncoder(YYMediaSample sample) {
        int inputBufferId;
        if (!this.mInitialized) {
            YMFLog.info(this, "[Encoder ]", "feedEncoder but encoder not started, just return!");
            return;
        }
        YMFImageBuffer image = this.selectImageBuffer(sample);
        if (image == null) {
            return;
        }
        int TIMEOUT_USEC = 1000;
        ByteBuffer[] inputBuffers = this.mEncoder.getInputBuffers();
        while ((inputBufferId = this.mEncoder.dequeueInputBuffer(1000L)) < 0) {
        }
        ByteBuffer emptyBuffer = inputBuffers[inputBufferId];
        emptyBuffer.clear();
        if (emptyBuffer.capacity() >= image.mBufSize) {
            if (this.mYuvData == null || this.mYuvData.length != image.mBufSize) {
                this.mYuvData = new byte[image.mBufSize];
            }
            image.mData.rewind();
            image.mData.get(this.mYuvData);
            emptyBuffer.put(this.mYuvData);
            this.mEncoder.queueInputBuffer(inputBufferId, 0, image.mBufSize, sample.mYYPtsMillions * 1000L, 0);
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "invalid data buffer size.");
        }
    }

    public void drainEncoder(long pts, boolean endOfStream) {
        block23: {
            try {
                if (!this.mInitialized) {
                    YMFLog.info(this, "[Encoder ]", "drainEncoder but encoder not started, just return!");
                    return;
                }
                int TIMEOUT_USEC = 100;
                int MAX_LOOP = 400;
                if (endOfStream) {
                    this.mCachedPtsList.clear();
                    this.mFirstEncodedFrame = true;
                    if (this.mInputSurface != null) {
                        this.mEncoder.signalEndOfInputStream();
                    } else {
                        int inputBufIndex = this.mEncoder.dequeueInputBuffer(100L);
                        if (inputBufIndex >= 0) {
                            this.mEncoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                        }
                    }
                    return;
                }
                this.mCachedPtsList.add(pts);
                this.mHasEncodeData = false;
                ByteBuffer[] encoderOutputBuffers = this.mEncoder.getOutputBuffers();
                int loopTime = 0;
                while (true) {
                    int encoderStatus;
                    if ((encoderStatus = this.mEncoder.dequeueOutputBuffer(this.mBufferInfo, 100L)) == -1) {
                        if (endOfStream || this.mLowDelay && loopTime++ <= 400) continue;
                        break;
                    }
                    if (encoderStatus == -3) {
                        encoderOutputBuffers = this.mEncoder.getOutputBuffers();
                        continue;
                    }
                    if (encoderStatus == -2) {
                        this.mMediaformat = this.mEncoder.getOutputFormat();
                        if (this.mListener == null) continue;
                        this.mListener.onEncoderFomratChanged(this.mMediaformat);
                        continue;
                    }
                    if (encoderStatus < 0) {
                        return;
                    }
                    ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
                    if (encodedData == null) {
                        throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                    }
                    encodedData.position(this.mBufferInfo.offset);
                    encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
                    long realPts = this.mBufferInfo.presentationTimeUs / 1000L;
                    YMFLiveStatisticManager.getInstance().endEncode(0, realPts);
                    long dts = 0L;
                    if (this.mCachedPtsList.size() > 0) {
                        dts = this.mCachedPtsList.pop();
                    }
                    if (dts == 0L) {
                        dts = realPts;
                    }
                    if ((this.mBufferInfo.flags & 2) != 0) {
                        if (this.mMediaformat == null) {
                            this.mMediaformat = this.mEncoder.getOutputFormat();
                        }
                        this.mListener.onEncodedHeaderAvailableSample(encodedData, this.mBufferInfo, dts, realPts, this.mMediaformat);
                        this.mBufferInfo.size = 0;
                    }
                    if (this.mBufferInfo.size != 0) {
                        if (this.mMediaformat == null) {
                            this.mMediaformat = this.mEncoder.getOutputFormat();
                        }
                        if (this.mFirstEncodedFrame) {
                            this.mFirstEncodedFrame = false;
                            if (realPts != dts) {
                                this.mEncodedDeltaPts = dts - realPts;
                                YMFLog.info(this, "[Encoder ]", " mEncodedDeltaPts " + this.mEncodedDeltaPts);
                            }
                        }
                        this.mListener.onEncodedDataAvailableSample(encodedData, this.mBufferInfo, dts, realPts + this.mEncodedDeltaPts, this.mMediaformat);
                        if (this.mLowDelay) {
                            this.mHasEncodeData = true;
                        }
                    }
                    this.mEncoder.releaseOutputBuffer(encoderStatus, false);
                    if ((this.mBufferInfo.flags & 4) != 0 || this.mLowDelay && this.mHasEncodeData) break;
                }
                if (!this.mHasEncodeData) {
                    this.mListener.onNoEncodedDataOut();
                }
            }
            catch (Exception e) {
                this.deInit();
                UploadStatManager.getInstance().reportException("0", "1", e.toString());
                YMFLog.error((Object)this, "[Encoder ]", "drainEncoder exception:" + e.toString());
                if (this.mListener == null) break block23;
                this.mListener.onError(this.mEncodeId.get(), "1", e.toString());
            }
        }
    }

    public void setEncoderParams(MediaFormat format, String name, String value) {
        block13 : switch (name) {
            case "bitrate-mode": {
                YMFLog.info(this, "[Encoder ]", "MediaCodec set bitrate-mode:" + value);
                if (Build.VERSION.SDK_INT < 21) break;
                format.setInteger("bitrate-mode", Integer.parseInt(value));
                break;
            }
            case "color-range": {
                YMFLog.info(this, "[Encoder ]", "MediaCodec set color-range:" + value);
                format.setInteger("color-range", Integer.parseInt(value));
                break;
            }
            case "color-standard": {
                YMFLog.info(this, "[Encoder ]", "MediaCodec set color-standard:" + value);
                format.setInteger("color-standard", Integer.parseInt(value));
                break;
            }
            case "color-transfer": {
                YMFLog.info(this, "[Encoder ]", "MediaCodec set color-transfer:" + value);
                format.setInteger("color-transfer", Integer.parseInt(value));
                break;
            }
            case "complexity": {
                YMFLog.info(this, "[Encoder ]", "MediaCodec set complexity:" + value);
                if (Build.VERSION.SDK_INT < 21) break;
                format.setInteger("complexity", Integer.parseInt(value));
                break;
            }
            case "gop_duration": {
                YMFLog.info(this, "[Encoder ]", "MediaCodec set i-frame-interval:" + value);
                format.setInteger("i-frame-interval", Integer.parseInt(value));
                break;
            }
            case "intra-refresh-period": {
                YMFLog.info(this, "[Encoder ]", "MediaCodec set i-frame-interval:" + value);
                format.setInteger("intra-refresh-period", Integer.parseInt(value));
                break;
            }
            case "profile": {
                switch (value.toLowerCase()) {
                    case "baseline": {
                        YMFLog.info(this, "[Encoder ]", "MediaCodec set profile:Baseline");
                        if (Build.VERSION.SDK_INT < 21) break block13;
                        format.setInteger("profile", 1);
                        break;
                    }
                    case "main": {
                        YMFLog.info(this, "[Encoder ]", "MediaCodec set profile:Main");
                        if (Build.VERSION.SDK_INT < 21) break block13;
                        format.setInteger("profile", 2);
                        break;
                    }
                    case "extended": {
                        YMFLog.info(this, "[Encoder ]", "MediaCodec set profile:Extended");
                        if (Build.VERSION.SDK_INT < 21) break block13;
                        format.setInteger("profile", 4);
                        break;
                    }
                    case "high": {
                        YMFLog.info(this, "[Encoder ]", "MediaCodec set profile:High");
                        if (Build.VERSION.SDK_INT < 21) break block13;
                        format.setInteger("profile", 8);
                        break;
                    }
                    case "high10": {
                        YMFLog.info(this, "[Encoder ]", "MediaCodec set profile:High10");
                        if (Build.VERSION.SDK_INT < 21) break block13;
                        format.setInteger("profile", 16);
                        break;
                    }
                    case "high422": {
                        YMFLog.info(this, "[Encoder ]", "MediaCodec set profile:High422");
                        if (Build.VERSION.SDK_INT < 21) break block13;
                        format.setInteger("profile", 32);
                        break;
                    }
                    case "high444": {
                        YMFLog.info(this, "[Encoder ]", "MediaCodec set profile:High444");
                        if (Build.VERSION.SDK_INT < 21) break block13;
                        format.setInteger("profile", 64);
                        break;
                    }
                    default: {
                        YMFLog.info(this, "[Encoder ]", "MediaCodec set profile:error keyword");
                        break;
                    }
                }
                break;
            }
            case "level": {
                YMFLog.info(this, "[Encoder ]", "MediaCodec set level:" + value);
                format.setInteger("level", Integer.parseInt(value));
                break;
            }
            case "priority": {
                YMFLog.info(this, "[Encoder ]", "MediaCodec set priority:" + value);
                format.setInteger("priority", Integer.parseInt(value));
                break;
            }
            case "repeat-previous-frame-after": {
                YMFLog.info(this, "[Encoder ]", "MediaCodec set repeat-previous-frame-after:" + value);
                if (Build.VERSION.SDK_INT < 19) break;
                format.setInteger("repeat-previous-frame-after", Integer.parseInt(value));
                break;
            }
            default: {
                YMFLog.info(this, "[Encoder ]", "unsupported params:" + name);
            }
        }
    }

    public void adjustBitRate(int bitRateInKbps) {
        if (this.mEncoder == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                int bitRateInBps = bitRateInKbps * 1000;
                Bundle bundle = new Bundle();
                bundle.putInt("video-bitrate", bitRateInBps);
                this.mEncoder.setParameters(bundle);
                YMFLog.info(this, "[Encoder ]", "succeed to adjustBitRate:" + bitRateInBps);
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[Encoder ]", "adjustBitRate exception:" + t.toString());
            }
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "adjustBitRate is only available on Android API 19+");
        }
    }

    public void requestSyncFrame() {
        if (this.mEncoder == null || !this.mInitialized) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Bundle bundle = new Bundle();
                bundle.putInt("request-sync", 0);
                this.mEncoder.setParameters(bundle);
                YMFLog.info(this, "[Encoder ]", "requestSyncFrame");
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[Encoder ]", "requestSyncFrame exception:" + t.toString());
            }
        } else {
            YMFLog.warn(this, "[Encoder ]", "requestSyncFrame is only available on Android API 19+");
        }
    }

    public String getFormat() {
        return this.mStrFormat;
    }

    public static String getCodecName() {
        return mCodecName;
    }

    public boolean getCacheEncodedData() {
        boolean result;
        block19: {
            result = false;
            try {
                int inputBufIndex;
                if (!this.mInitialized) {
                    YMFLog.info(this, "[Encoder ]", "drainEncoder but encoder not started, just return!");
                    return result;
                }
                int TIMEOUT_USEC = 100;
                int reTryCnt = 3;
                if (!this.mEofFlag && this.mInputSurface != null) {
                    this.mEncoder.signalEndOfInputStream();
                    this.mEofFlag = true;
                } else if (!this.mEofFlag && this.mInputSurface == null && (inputBufIndex = this.mEncoder.dequeueInputBuffer(100L)) >= 0) {
                    this.mEncoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                    this.mEofFlag = true;
                }
                this.mHasEncodeData = false;
                ByteBuffer[] encoderOutputBuffers = this.mEncoder.getOutputBuffers();
                while (true) {
                    int encoderStatus;
                    if ((encoderStatus = this.mEncoder.dequeueOutputBuffer(this.mBufferInfo, 100L)) == -1) {
                        if (reTryCnt-- != 0) {
                            YMFLog.warn(this, "[Encoder ]", "getCacheEncodedData INFO_TRY_AGAIN_LATER!");
                            continue;
                        }
                        break;
                    }
                    if (encoderStatus == -3) {
                        encoderOutputBuffers = this.mEncoder.getOutputBuffers();
                        continue;
                    }
                    if (encoderStatus == -2) {
                        MediaFormat newFormat = this.mEncoder.getOutputFormat();
                        if (this.mListener == null) continue;
                        this.mListener.onEncoderFomratChanged(newFormat);
                        continue;
                    }
                    if (encoderStatus == 4) {
                        YMFLog.error((Object)this, "[Encoder ]", "input frame:BUFFER_FLAG_END_OF_STREAM" + this.mCachedPtsList.size());
                        return result;
                    }
                    if (encoderStatus < 0) {
                        return result;
                    }
                    ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
                    if (encodedData == null) {
                        throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                    }
                    encodedData.position(this.mBufferInfo.offset);
                    encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
                    YMFLiveStatisticManager.getInstance().endEncode(0, this.mBufferInfo.presentationTimeUs / 1000L);
                    long realPts = this.mBufferInfo.presentationTimeUs / 1000L;
                    long dts = 0L;
                    if (this.mCachedPtsList.size() > 0) {
                        dts = this.mCachedPtsList.pop();
                    }
                    if (dts == 0L) {
                        dts = realPts;
                    }
                    if ((this.mBufferInfo.flags & 2) != 0) {
                        this.mListener.onEncodedHeaderAvailableSample(encodedData, this.mBufferInfo, dts, realPts, this.mEncoder.getOutputFormat());
                        this.mBufferInfo.size = 0;
                    }
                    if (this.mBufferInfo.size != 0) {
                        YMFLog.info(this, "[Encoder ]", "getCacheEncodedData pts:" + realPts + "->" + this.mCachedPtsList.size());
                        this.mListener.onEncodedDataAvailableSample(encodedData, this.mBufferInfo, dts, realPts + this.mEncodedDeltaPts, this.mEncoder.getOutputFormat());
                        result = true;
                    }
                    this.mEncoder.releaseOutputBuffer(encoderStatus, false);
                    if ((this.mBufferInfo.flags & 4) != 0) {
                        YMFLog.info(this, "[Encoder ]", "out: BUFFER_FLAG_END_OF_STREAM:" + this.mCachedPtsList.size());
                        result = false;
                        break;
                    }
                    if (this.mLowDelay && this.mHasEncodeData) break;
                }
            }
            catch (Throwable e) {
                this.deInit();
                UploadStatManager.getInstance().reportException("0", "1", e.toString());
                YMFLog.error((Object)this, "[Encoder ]", "getCacheEncodedData exception:" + e.toString());
                if (this.mListener == null) break block19;
                this.mListener.onError(this.mEncodeId.get(), "1", e.toString());
            }
        }
        return result;
    }

    private static boolean awaitUninterruptibly(CountDownLatch barrier, long timeoutMs) {
        long startTimeMs = SystemClock.elapsedRealtime();
        long timeRemainingMs = timeoutMs;
        boolean wasInterrupted = false;
        boolean result = false;
        while (true) {
            try {
                result = barrier.await(timeRemainingMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                long elapsedTimeMs;
                wasInterrupted = true;
                if ((timeRemainingMs = timeoutMs - (elapsedTimeMs = SystemClock.elapsedRealtime() - startTimeMs)) > 0L) continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    private void releaseEncoder() {
        final CountDownLatch releaseDone = new CountDownLatch(1);
        Runnable runMediaCodecRelease = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    YMFLog.info(this, "[Encoder ]", "releaseEncoder begin");
                    try {
                        if (HardSurfaceEncoder.this.mEncoder != null) {
                            HardSurfaceEncoder.this.mInitialized = false;
                            HardSurfaceEncoder.this.mEncoder.stop();
                        }
                    }
                    catch (Throwable e) {
                        YMFLog.error((Object)this, "[Encoder ]", "stop encoder exception:" + e.getMessage());
                    }
                    finally {
                        if (HardSurfaceEncoder.this.mEncoder != null) {
                            HardSurfaceEncoder.this.mEncoder.release();
                        }
                        releaseDone.countDown();
                        YMFLog.info(this, "[Encoder ]", "releaseEncoder done");
                        HardSurfaceEncoder.this.mEncoder = null;
                        HardSurfaceEncoder.this.mMediaformat = null;
                    }
                }
            }
        };
        Thread releaseThread = new Thread(runMediaCodecRelease);
        releaseThread.start();
        YMFLog.error((Object)this, "[Encoder ]", "releaseEncoder thread start!");
        if (!HardSurfaceEncoder.awaitUninterruptibly(releaseDone, 2000L)) {
            YMFLog.error((Object)this, "[Encoder ]", "releaseEncoder Block in :2000ms");
            if (this.mListener != null) {
                this.mListener.onError(this.mEncodeId.get(), "6", "Blocked");
            }
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "releaseEncoder end!");
        }
    }
}

