/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.decoder;

import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.yy.mediaframework.model.DecodeVideoConfig;
import com.yy.mediaframework.model.DecodeVideoSample;

public abstract class BaseDecoder {
    protected String IllegalStateExceptionTAG = this.getClass().getSimpleName();
    protected int mDecodeWidth = -1;
    protected int mDecodeHeight = -1;
    protected String mCodecName;
    protected String mCodecType;
    DecodeVideoConfig mDecodeVideoConfig;

    protected BaseDecoder(@NonNull int width, @NonNull int height, @NonNull String codeName, @NonNull String codecType) {
        this.mDecodeWidth = width;
        this.mDecodeHeight = height;
        this.mCodecName = codeName;
        this.mCodecType = codecType;
    }

    public abstract int initDecoder(DecodeVideoConfig var1);

    public abstract long drainDecoder(@NonNull DecodeVideoSample var1);

    public abstract long drainDecoder(@NonNull byte[] var1, int var2, boolean var3, long var4);

    public abstract void release();

    protected static boolean isCodecAvailable(String codecName) {
        if (Build.VERSION.SDK_INT < 16) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)codecName);
    }
}

