/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.beautystyle;

import com.yy.mediaframework.beautystyle.IBeautyStyle;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractStyle
implements IBeautyStyle {
    protected float[] sMinParams = new float[]{0.6f, 0.6f, 0.6f, 0.0f};
    protected float[] sDefaultParams = new float[]{0.67f, 0.75f, 0.7f, 0.1f, 0.7f};
    protected float[] sMaxParams = new float[]{0.75f, 0.9f, 0.75f, 0.2f};
    protected float[] mParams = this.sDefaultParams;
    protected int mProgress = 50;
    Map<String, String> mParamMap = new HashMap<String, String>(5);

    @Override
    public Map<String, String> getFilterParams() {
        this.mParamMap.put("0", String.valueOf(this.mParams[0]));
        this.mParamMap.put("1", String.valueOf(this.mParams[1]));
        this.mParamMap.put("2", String.valueOf(this.mParams[2]));
        this.mParamMap.put("3", String.valueOf(this.mParams[3]));
        this.mParamMap.put("4", String.valueOf(this.mParams[4]));
        return this.mParamMap;
    }

    @Override
    public void changeParams(int index, float value) {
        if (index > -1 && index < 4) {
            this.mParams[index] = value;
        }
    }

    @Override
    public void updateProgress(int progress) {
        this.mProgress = 100 - progress;
        for (int i = 0; i < 3; ++i) {
            this.mParams[i] = this.calToRange(this.sMaxParams[i], this.sMinParams[i], this.sDefaultParams[i], this.mProgress);
        }
        this.mParams[3] = this.calToRange(this.sMaxParams[3], this.sMinParams[3], this.sDefaultParams[3], progress);
    }

    protected float calToRange(float max, float min, float middle, int progress) {
        if (max < 0.0f) {
            max = 0.0f;
        }
        if (min < 0.0f) {
            min = 0.0f;
        }
        if (middle < 0.0f) {
            middle = 0.0f;
        }
        if (progress < 0) {
            progress = 0;
        }
        if (progress > 50) {
            float diff = max - middle;
            float calValue = diff / 50.0f * (float)Math.abs(progress - 50) + middle;
            calValue = (float)Math.round(calValue * 1000.0f) / 1000.0f;
            return calValue;
        }
        if (progress < 50) {
            float diff = middle - min;
            float calValue = middle - diff / 50.0f * (float)Math.abs(50 - progress);
            calValue = (float)Math.round(calValue * 1000.0f) / 1000.0f;
            return calValue;
        }
        return middle;
    }
}

