/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.base;

import com.yy.mediaframework.UploadStreamStateParams;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.base.YMFLowStreamEncoderConfig;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import java.util.ArrayList;
import java.util.List;

public class VideoPublisheParam {
    public int captureFrameRate;
    public int captureResolutionWidth;
    public int captureResolutionHeight;
    public int encodeFrameRate;
    public int encodeBitrate;
    public int encodeResolutionWidth;
    public int encodeResolutionHeight;
    public VideoEncoderType encodeType;
    public String encoderParam;
    @Deprecated
    public int encodeMaxBitrate;
    @Deprecated
    public int encodeMinBitrate;
    @Deprecated
    public int codecid;
    public List<YMFLowStreamEncoderConfig> lowStreamConfigs = new ArrayList<YMFLowStreamEncoderConfig>();
    public List<ResolutionModifyConfig> weakNetConfigs = new ArrayList<ResolutionModifyConfig>();
    public int weakNetConfigsIntervalSecs;
    public boolean bLowLatency = false;
    public boolean bWebSdkCompatibility = false;
    public boolean bEnableLocalDualStreamMode = false;
    public int screenOrientation = 0;

    public void assign(VideoPublisheParam param) {
        int i;
        this.captureFrameRate = param.captureFrameRate;
        this.captureResolutionWidth = param.captureResolutionWidth;
        this.captureResolutionHeight = param.captureResolutionHeight;
        this.encodeFrameRate = param.encodeFrameRate;
        this.encodeBitrate = param.encodeBitrate;
        this.encodeResolutionWidth = param.encodeResolutionWidth;
        this.encodeResolutionHeight = param.encodeResolutionHeight;
        this.encodeType = !UploadStreamStateParams.mDisableHardEncoder.get() ? param.encodeType : VideoEncoderType.SOFT_ENCODER_X264;
        this.encoderParam = !UploadStreamStateParams.mDisableHardEncoder.get() ? param.encoderParam : "";
        this.encodeMaxBitrate = param.encodeMaxBitrate;
        this.encodeMinBitrate = param.encodeMinBitrate;
        this.codecid = param.codecid;
        this.weakNetConfigsIntervalSecs = param.weakNetConfigsIntervalSecs;
        this.weakNetConfigs.clear();
        if (param.weakNetConfigs != null && param.weakNetConfigs.size() > 0) {
            for (i = 0; i < param.weakNetConfigs.size(); ++i) {
                this.weakNetConfigs.add(new ResolutionModifyConfig(param.weakNetConfigs.get(i)));
                if (!UploadStreamStateParams.mDisableHardEncoder.get()) continue;
                this.weakNetConfigs.get((int)i).videoEncoderType = VideoEncoderType.SOFT_ENCODER_X264;
                this.weakNetConfigs.get((int)i).encoderParams = "";
            }
        } else {
            this.weakNetConfigs = new ArrayList<ResolutionModifyConfig>();
        }
        if (param.lowStreamConfigs != null && param.lowStreamConfigs.size() > 0) {
            this.lowStreamConfigs.clear();
            for (i = 0; i < param.lowStreamConfigs.size(); ++i) {
                this.lowStreamConfigs.add(new YMFLowStreamEncoderConfig(param.lowStreamConfigs.get(i)));
            }
            YMFLiveStatisticManager.getInstance().setDesiredParam(1, param.lowStreamConfigs.get((int)0).mEncodeWidth, param.lowStreamConfigs.get((int)0).mEncodeHeight, param.lowStreamConfigs.get((int)0).mCodeRate / 1000, param.lowStreamConfigs.get((int)0).mFrameRate);
        }
        this.bLowLatency = param.bLowLatency;
        this.bWebSdkCompatibility = param.bWebSdkCompatibility;
        this.bEnableLocalDualStreamMode = param.bEnableLocalDualStreamMode;
        this.screenOrientation = param.screenOrientation;
        YMFLiveStatisticManager.getInstance().setDesiredParam(0, param.encodeResolutionWidth, param.encodeResolutionHeight, param.encodeBitrate / 1000, param.encodeFrameRate);
    }

    public String toString() {
        String str = "previewCfg:" + this.captureResolutionWidth + "x" + this.captureResolutionHeight + "@" + this.captureFrameRate + "fps,encodeCfg:" + this.encodeResolutionWidth + "x" + this.encodeResolutionHeight + "@" + this.encodeFrameRate + "fps:" + this.encodeBitrate + "bps," + (Object)((Object)this.encodeType) + ",param:" + this.encoderParam + ",lowDelatency:" + this.bLowLatency + ",web:" + this.bWebSdkCompatibility + ",orientation:" + this.screenOrientation + ".." + this.bWebSdkCompatibility + ",orientation:" + this.screenOrientation + ",dualStreamMode:" + this.bEnableLocalDualStreamMode + " .. weaknetCfg:";
        if (this.weakNetConfigs == null || this.weakNetConfigs.size() == 0) {
            str = str + "null";
        } else {
            for (ResolutionModifyConfig resolutionModifyConfig : this.weakNetConfigs) {
                str = str + "[" + resolutionModifyConfig.width + "x" + resolutionModifyConfig.height + "@" + resolutionModifyConfig.minFrameRate + "-" + resolutionModifyConfig.maxFrameRate + "\uff1a" + resolutionModifyConfig.minCodeRate + "-" + resolutionModifyConfig.maxCodeRate + "]";
            }
        }
        str = str + "lowStream:";
        if (this.lowStreamConfigs == null || this.lowStreamConfigs.size() == 0) {
            str = str + "null";
        } else {
            for (YMFLowStreamEncoderConfig yMFLowStreamEncoderConfig : this.lowStreamConfigs) {
                str = str + "[" + yMFLowStreamEncoderConfig.toString() + "]";
            }
        }
        return str;
    }
}

