/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.base;

import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.stat.VideoDataStatUtil;

public class VideoEncoderConfig {
    public int mEncodeWidth;
    public int mEncodeHeight;
    public int mFrameRate;
    public int mBitRate;
    public boolean videoStabilization;
    public VideoEncoderType mEncodeType = VideoEncoderType.HARD_ENCODER_H264;
    public String mEncodeParameter = null;
    public boolean mLowDelay = false;
    public int mMaxBitRate;
    public static final int DEFAULT_ENCODE_HIGH_WIDTH = 544;
    public static final int DEFAULT_ENCODE_HIGH_HEIGHT = 960;
    public static final int DEFAULT_ENCODE_HIGH_BITRATE = 1200000;
    public static final int DEFAULT_ENCODE_HIGH_FRAMERATE = 24;
    public static final int DEFAULT_ENCODE_LOW_WIDTH = 368;
    public static final int DEFAULT_ENCODE_LOW_HEIGHT = 640;
    public static final int DEFAULT_ENCODE_LOW_BITRATE = 1200000;
    public static final int DEFAULT_ENCODE_LOW_FRAMERATE = 24;
    public static final int SCREEN_RECORD_ENCODE_ULTRA_HIGH_WIDTH = 720;
    public static final int SCREEN_RECORD_ENCODE_ULTRA_HIGH_HEIGHT = 1280;
    public static final int SCREEN_RECORD_ENCODE_ULTRA_HIGH_BITRATE = 2000000;
    public static final int SCREEN_RECORD_ENCODE_ULTRA_HIGH_FRAMERATE = 30;
    public static final int SCREEN_RECORD_ENCODE_HIGH_WIDTH = 480;
    public static final int SCREEN_RECORD_ENCODE_HIGH_HEIGHT = 864;
    public static final int SCREEN_RECORD_ENCODE_HIGH_BITRATE = 1200000;
    public static final int SCREEN_RECORD_ENCODE_HIGH_FRAMERATE = 30;
    public static final int SCREEN_RECORD_ENCODE_LOW_WIDTH = 368;
    public static final int SCREEN_RECORD_ENCODE_LOW_HEIGHT = 640;
    public static final int SCREEN_RECORD_ENCODE_LOW_BITRATE = 800000;
    public static final int SCREEN_RECORD_ENCODE_LOW_FRAMERATE = 30;
    public static final boolean DEFAULT_ENCODE_STABILIZATION = true;

    public VideoEncoderConfig() {
        this(544, 960, 24, 1200000, VideoEncoderType.HARD_ENCODER_H264, null);
    }

    public VideoEncoderConfig(int encodeWidth, int encodeHeight, int frameRate, int bitRate, VideoEncoderType encoderType, String encodeParam) {
        this.setEncodeSize(encodeWidth, encodeHeight);
        this.mFrameRate = frameRate;
        this.mBitRate = bitRate;
        this.mEncodeType = encoderType;
        this.mEncodeParameter = encodeParam;
        this.videoStabilization = true;
    }

    public VideoEncoderConfig(VideoEncoderConfig config) {
        this.assign(config);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" mEncodeWidth:").append(this.getEncodeWidth());
        sb.append(" mEncodeHeith:").append(this.getEncodeHeight());
        sb.append(" mFrameRate:").append(this.mFrameRate);
        sb.append(" mBitRate:").append(this.mBitRate);
        sb.append(" mEncodeType:").append((Object)this.mEncodeType);
        sb.append(" mLowDelay:").append(this.mLowDelay);
        if (this.mEncodeParameter != null) {
            sb.append(" mEncodeParameter:").append(this.mEncodeParameter);
        }
        return sb.toString();
    }

    public void assign(VideoEncoderConfig config) {
        this.setEncodeSize(config.getEncodeWidth(), config.getEncodeHeight());
        this.mFrameRate = config.mFrameRate;
        this.videoStabilization = config.videoStabilization;
        this.mEncodeType = config.mEncodeType;
        this.mBitRate = config.mBitRate;
        this.mEncodeParameter = config.mEncodeParameter;
        this.mLowDelay = config.mLowDelay;
    }

    public void setEncodeSize(int width, int height) {
        this.mEncodeWidth = width;
        this.mEncodeHeight = height;
    }

    public void setFrameRate(int frameRate) {
        this.mFrameRate = frameRate;
    }

    public void setBitRate(int bitRate) {
        this.mBitRate = bitRate;
    }

    public void setEncodeParam(String encodeParameter) {
        this.mEncodeParameter = encodeParameter;
    }

    public void setEncodeType(VideoEncoderType type) {
        this.mEncodeType = type;
    }

    public int getEncodeWidth() {
        return this.mEncodeWidth;
    }

    public int getEncodeHeight() {
        return this.mEncodeHeight;
    }

    public int getBitRate() {
        return this.mBitRate;
    }

    public int getFrameRate() {
        return this.mFrameRate;
    }

    public String getRealDPI() {
        return VideoDataStatUtil.getDPI(this.mEncodeWidth, this.mEncodeHeight);
    }
}

