/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.background;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.yy.mediaframework.background.Background;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BackgroundTexture {
    private static final String TAG = "BackgroundTexture";
    public int mbackgroundTextureId = -1;
    public int mbackgroundWidth = 0;
    public int mbackgroundHeight = 0;

    public BackgroundTexture(Background background) {
        if (background.bitmap != null) {
            YMFLog.info(this, "[Preview ]", "background texture bitmap not null.");
            this.createbackgroundTexture(background.bitmap, background.width, background.height, background.offsetX, background.offsetY, background.align);
        } else {
            YMFLog.info(this, "[Preview ]", "background texture bitmap is null, use default background instead.");
            this.createbackgroundTexture(this.createColorBitmap(background.width, background.height), background.width, background.height, background.offsetX, background.offsetY, background.align);
        }
        this.mbackgroundWidth = background.width;
        this.mbackgroundHeight = background.height;
    }

    private Bitmap createColorBitmap(int width, int height) {
        YMFLog.info(this, "[Preview ]", "createColorBitmap, width:%d, height:%d", width, height);
        Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bmp);
        canvas.drawColor(-16777216);
        return bmp;
    }

    public void destroy() {
        if (this.mbackgroundTextureId > 0) {
            int[] textures = new int[]{this.mbackgroundTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mbackgroundTextureId = -1;
            this.mbackgroundWidth = 0;
            this.mbackgroundHeight = 0;
        }
    }

    private int genbackgroundTexture(int width, int height) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBlendFunc((int)770, (int)771);
        GLES20.glEnable((int)3042);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        byte[] data = new byte[width * height * 4];
        ByteBuffer pixels = ByteBuffer.wrap(data);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (Buffer)pixels);
        return textures[0];
    }

    private int genbackgroundTexture(Bitmap bitmap) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        return textures[0];
    }

    private void createbackgroundTexture(Bitmap bitmap, int width, int height, int offsetX, int offsetY, Background.Align align) {
        this.mbackgroundTextureId = this.genbackgroundTexture(bitmap);
        boolean srcX = false;
        boolean srcY = false;
    }
}

