/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.view.Surface;
import com.yy.mediaframework.utils.YMFLog;
import java.util.concurrent.atomic.AtomicReference;

public class YYVideoCodec {
    public static final String TAG = "YYVideoCodec";
    public static final int IFRAME_INTERVAL = 3;
    public static final String MIME_H264 = "video/avc";
    public static final String MIME_H265 = "video/hevc";
    private static String mEncoderH264Name = "";
    private static String mEncoderH265Name = "";
    private static Object mLock = new Object();
    private static AtomicReference<Integer> mSupportH264 = new AtomicReference<Integer>(-1);
    private static AtomicReference<Integer> mSupportH265 = new AtomicReference<Integer>(-1);
    private static AtomicReference<String> mCurrentEncodeName = new AtomicReference<String>("noEncoder");
    private static String mEncoderName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    private static boolean testVideoEncoderCrash(String mime) {
        boolean crashed = false;
        MediaCodec encoder = null;
        Surface surface = null;
        try {
            MediaFormat format = MediaFormat.createVideoFormat((String)mime, (int)720, (int)1280);
            format.setInteger("color-format", 2130708361);
            format.setInteger("bitrate", 2000000);
            format.setInteger("frame-rate", 30);
            format.setInteger("i-frame-interval", 3);
            if (Build.VERSION.SDK_INT >= 21) {
                format.setInteger("bitrate-mode", 2);
            }
            YMFLog.info(null, "[Encoder ]", "testVideoEncoder mime:" + mime + ", MediaCodec format:" + format);
            encoder = MediaCodec.createEncoderByType((String)mime);
            String encoderName = encoder.getName();
            if (mime.equals(MIME_H264)) {
                mEncoderH264Name = encoderName;
            } else if (mime.equals(MIME_H265)) {
                mEncoderH265Name = encoderName;
            }
            YMFLog.info(null, "[Encoder ]", "testVideoEncoder mime:" + mime + ", MediaCodec encoder:" + encoderName);
            encoder.configure(format, null, null, 1);
            surface = encoder.createInputSurface();
            encoder.start();
        }
        catch (Throwable throwable) {
            crashed = true;
            YMFLog.error(null, "[Encoder ]", "testVideoEncoderCrash, mime:" + mime + ", reason:" + throwable);
        }
        finally {
            if (encoder != null) {
                try {
                    if (surface != null) {
                        surface.release();
                    }
                    encoder.stop();
                    encoder.release();
                }
                catch (Throwable throwable) {
                    YMFLog.error(null, "[Encoder ]", "release test encoder error! mime:" + mime + ", reason:" + throwable);
                }
            }
        }
        return crashed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testSupportH264Encode() {
        Object object = mLock;
        synchronized (object) {
            boolean isSupportH264 = YYVideoCodec.isH264EncoderSupport();
            boolean h264Crashed = YYVideoCodec.testVideoEncoderCrash(MIME_H264);
            if (isSupportH264 && !h264Crashed) {
                mSupportH264.set(1);
                YMFLog.info(TAG, "[Encoder ]", "testVideoEncoderSupport h264 isSupportH264:" + isSupportH264 + " isSupportH264 " + h264Crashed + " mSupportH264 " + mSupportH264.get());
            } else {
                mSupportH264.set(0);
                YMFLog.info(TAG, "[Encoder ]", "testVideoEncoderSupport h264 isSupportH264:" + isSupportH264 + " h264Crashed " + h264Crashed + " mSupportH264 " + mSupportH264.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testSupportH265Encode() {
        Object object = mLock;
        synchronized (object) {
            boolean isHardEncodeAvailable = Build.VERSION.SDK_INT >= 18;
            boolean isSupportH265 = YYVideoCodec.isH265EncoderSupport();
            boolean h265Crashed = YYVideoCodec.testVideoEncoderCrash(MIME_H265);
            if (isSupportH265 && !h265Crashed && isHardEncodeAvailable) {
                mSupportH265.set(1);
                YMFLog.info(TAG, "[Encoder ]", "testVideoEncoderSupport h265 isSupportH265:" + isSupportH265 + " h265Crashed " + h265Crashed + " mSupportH265 " + mSupportH265.get());
            } else {
                mSupportH265.set(0);
                YMFLog.info(TAG, "[Encoder ]", "testVideoEncoderSupport h265 isSupportH265:" + isSupportH265 + " h265Crashed " + h265Crashed + " mSupportH265 " + mSupportH265.get());
            }
        }
    }

    public static int getSupportH264() {
        return mSupportH264.get();
    }

    public static int getSupportH265() {
        if (mSupportH265.get() == -1) {
            YYVideoCodec.testSupportH265Encode();
        }
        return mSupportH265.get();
    }

    public static int getSupportH265Property() {
        return mSupportH265.get();
    }

    public static String getH264EncodeName() {
        return mEncoderH264Name;
    }

    public static String getH265EncodeName() {
        return mEncoderH265Name;
    }

    public static void setCurrentEncodeName(String encodeName) {
        mCurrentEncodeName.set(encodeName);
    }

    public static String getCurrentEncodeName() {
        return mCurrentEncodeName.get();
    }

    public static void resetCurrentEncodeName() {
        mCurrentEncodeName.set("noEncoder");
    }

    public static boolean isH265EncoderSupport() {
        boolean result = false;
        int count = MediaCodecList.getCodecCount();
        for (int i = 0; i < count; ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            String name = info.getName();
            boolean b = info.isEncoder();
            if (name == null || !b || !name.contains("hevc") || YYVideoCodec.isSWCodec(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isH264EncoderSupport() {
        boolean result = false;
        int count = MediaCodecList.getCodecCount();
        for (int i = 0; i < count; ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            String name = info.getName();
            boolean b = info.isEncoder();
            if (name == null || !b || !name.contains("avc") || YYVideoCodec.isSWCodec(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSWCodec(String codecName) {
        if (codecName.startsWith("OMX.google.")) {
            return true;
        }
        return !codecName.startsWith("OMX.");
    }

    public static class EncodeSupport {
        public static final int DEFAULT = -1;
        public static final int UNSUPPORTED = 0;
        public static final int SUPPORTED = 1;
    }
}

