/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.hardware.Camera;
import android.view.MotionEvent;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraUtils;
import com.yy.mediaframework.PictureInPictureDisplayInfo;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.YMFLog;
import java.util.concurrent.CountDownLatch;

public class YYCamera {
    private static final String TAG = "YYCamera";
    private static volatile YYCamera mInstance;
    private CameraInterface mCameraInterface = CameraInterface.getInstance();
    private static final byte[] SYNC_FLAG;
    private int mCameraState;
    public static final int DISPLAY_ROTATION_PORTRAIT = 0;
    public static final int DISPLAY_ROTATION_LANDSCAPE = 90;
    public static final int DISPLAY_ROTATION_PORTRAIT_UPSIDEDOWN = 180;
    public static final int DISPLAY_ROTATION_LANDSCAPE_UPSIDEDOWN = 270;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YYCamera getInstance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new YYCamera();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private YYCamera() {
    }

    public int startPreview(final int width, final int height, final int fps, final CameraUtils.CameraFacing cameraFacing, final int displayRotation, final CameraInterface.CameraResolutionMode resMode) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Preview ]", "startPreview...");
                YMFLiveUsrBehaviorStat.getInstance().notifyCameraCaptureState(true);
                int displayOrientation = 0;
                switch (displayRotation) {
                    case 0: {
                        displayOrientation = 0;
                        break;
                    }
                    case 1: {
                        displayOrientation = 90;
                        break;
                    }
                    case 2: {
                        displayOrientation = 180;
                        break;
                    }
                    case 3: {
                        displayOrientation = 270;
                        break;
                    }
                }
                YYCamera.this.mCameraState = YYCamera.this.mCameraInterface.openCamera(width, height, fps, cameraFacing, resMode, displayOrientation);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "startpreview barrier.await exception:" + e.toString());
        }
        return this.mCameraState;
    }

    public int startDualCameraLive(final int width, final int height, final int fps, final PictureInPictureDisplayInfo info) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[CCapture]", "startDualCameraLive, width:" + width + " ,height:" + height + " ,fps:" + fps);
                YYCamera.this.mCameraInterface.openDualCamera(width, height, fps, info);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "startDualCameraLive exception:" + e.toString());
        }
        return 0;
    }

    public void changePreviewParameter(final int width, final int height, final int fps, final CameraUtils.CameraFacing currentFacing, final int displayRotation, final CameraInterface.CameraResolutionMode resMode) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Preview ]", "changePreviewParameter...");
                YYCamera.this.mCameraInterface.restart(width, height, fps, currentFacing, displayRotation, resMode);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "changePreviewParameter exception:" + e.toString());
        }
    }

    public void changePreviewParameter(final int width, final int height, final int fps, final CameraUtils.CameraFacing currentFacing, final CameraInterface.CameraResolutionMode resMode) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Preview ]", "changePreviewParameter...");
                YYCamera.this.mCameraInterface.restart(width, height, fps, currentFacing, resMode);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "changePreviewParameter exception:" + e.toString());
        }
    }

    public void setPreviewCallbackWithBuffer(final Camera.PreviewCallback previewCallback) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Preview ]", "setPreviewCallbackWithBuffer...");
                YYCamera.this.mCameraInterface.setPreviewCallbackWithBuffer(previewCallback);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "setPreviewCallbackWithBuffer exception:" + e.toString());
        }
    }

    public void stopPreview() {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Preview ]", "stopPreview...");
                YYCamera.this.mCameraInterface.releaseCamera();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "stopPreview exception:" + e.toString());
        }
    }

    public void switchCamera() {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[CCapture]", "switchCamera...");
                YYCamera.this.mCameraInterface.switchCamera();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "switchCamera exception:" + e.toString());
        }
    }

    public boolean isCameraOpen() {
        boolean ret = this.mCameraInterface.isCameraOpened();
        YMFLog.info(this, "[CCapture]", "isCameraOpen:" + ret);
        return ret;
    }

    public Camera.Size getPreviewSize() {
        final Camera.Size[] ret = new Camera.Size[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.getPreviewSize();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Preview ]", "getPreviewSize exception:" + e.toString());
        }
        return ret[0];
    }

    public void setCameraFlashMode(final boolean enable) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YYCamera.this.mCameraInterface.setCameraFlashMode(enable);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "setCameraFlashMode exception:" + e.toString());
        }
    }

    public void handleFocusMetering(final MotionEvent event) {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[CCapture]", "handleFocusMetering...");
                YYCamera.this.mCameraInterface.handleFocusMetering(event);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "handleFocusMetering exception:" + e.toString());
        }
    }

    public boolean isCameraFront() {
        return this.mCameraInterface.getCameraFacing() == CameraUtils.CameraFacing.FacingFront;
    }

    public float getMaxZoom() {
        final float[] ret = new float[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.getMaxZoom();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "getMaxZoom exception:" + e.toString());
        }
        return ret[0];
    }

    public boolean isZoomSupport() {
        final boolean[] ret = new boolean[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.isZoomSupport();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "isZoomSupport exception:" + e.toString());
        }
        return ret[0];
    }

    public float setZoom(final float zoom) {
        final float[] ret = new float[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.setZoom((int)(zoom * 100.0f));
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "setZoom exception:" + e.toString());
        }
        return ret[0];
    }

    public void releaseCamera() {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[CCapture]", "releaseCamera...");
                YYCamera.this.mCameraInterface.releaseCamera();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "releaseCamera exception:" + e.toString());
        }
    }

    public void closeDualCamera() {
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[CCapture]", "closeDualCamera...");
                YYCamera.this.mCameraInterface.closeDualCamera();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "closeDualCamera exception:" + e.toString());
        }
    }

    public CameraUtils.CameraFacing getCameraFacing() {
        final CameraUtils.CameraFacing[] ret = new CameraUtils.CameraFacing[1];
        final CountDownLatch barrier = new CountDownLatch(1);
        CameraInterface.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ret[0] = YYCamera.this.mCameraInterface.getCameraFacing();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[CCapture]", "getCameraFacing exception:" + e.toString());
        }
        return ret[0];
    }

    public boolean isCameraManualFocusPositionSupported() {
        boolean ret = false;
        try {
            ret = this.mCameraInterface.isCameraManualFocusPositionSupported();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public boolean isCameraManualExposurePositionSupported() {
        boolean ret = false;
        try {
            ret = this.mCameraInterface.isCameraManualExposurePositionSupported();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int setCameraFocusPosition(float posX, float posY) {
        int ret = -1;
        try {
            ret = this.mCameraInterface.setCameraFocusPosition(posX, posY);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int setCameraExposurePosition(float posX, float posY) {
        int ret = -1;
        try {
            ret = this.mCameraInterface.setCameraExposurePosition(posX, posY);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public boolean isTorchSupported() {
        boolean ret = false;
        try {
            ret = this.mCameraInterface.isTorchSupported();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public boolean setCameraTorchOn(boolean isOn) {
        boolean ret = false;
        try {
            ret = this.mCameraInterface.setCameraFlashMode(isOn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public boolean isCameraAutoFocusFaceModeSupported() {
        boolean ret = false;
        try {
            ret = this.mCameraInterface.isCameraAutoFocusFaceModeSupported();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int setCameraAutoFocusFaceModeEnabled(boolean enable) {
        int ret = -1;
        try {
            ret = this.mCameraInterface.setCameraAutoFocusFaceModeEnabled(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int getCameraOrientation() {
        int ret = this.mCameraInterface.getDisplayRotation();
        switch (ret) {
            case 0: {
                ret = 0;
                break;
            }
            case 90: {
                ret = 1;
                break;
            }
            case 180: {
                ret = 2;
                break;
            }
            case 270: {
                ret = 3;
                break;
            }
        }
        return ret;
    }

    public void resumeCameraAutoFocusFace(boolean focused) {
        try {
            this.mCameraInterface.resumeCameraAutoFocusFace(focused);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resumeZoomValue(float zoom) {
        try {
            this.mCameraInterface.changeCurZoomValue(zoom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        SYNC_FLAG = new byte[1];
    }
}

