/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import com.yy.mediaframework.api.YMFVideoEncodeFrame;
import com.yy.mediaframework.utils.YMFLog;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class YMFStreamSyncSourceManager {
    public static final int SSRC_DISCARD = 1;
    public static final String TAG = "YMFStreamSyncSourceManager";
    private static YMFStreamSyncSourceManager mInstance;
    private AtomicBoolean mChangeSyncSourceFlag = new AtomicBoolean(false);
    private AtomicLong mHighStreamChangeSyncSourcePts = new AtomicLong(0L);
    private AtomicLong mLowStreamChangeSyncSourcePts = new AtomicLong(0L);
    public AtomicInteger mHighStreamFirstSsrc = new AtomicInteger(0);
    public AtomicInteger mLowStreamFirstSsrc = new AtomicInteger(0);
    private byte[] mHighStreamExtraData;
    private byte[] mLowStreamExtraData;
    private int mPrintHighStreamSsrc = -1;
    private int mPrintLowStreamSsrc = -1;

    public static YMFStreamSyncSourceManager getInstance() {
        if (mInstance == null) {
            mInstance = new YMFStreamSyncSourceManager();
        }
        return mInstance;
    }

    private static int randomInt(int min, int max) {
        return new Random().nextInt(max) % (max - min + 1) + min;
    }

    public YMFStreamSyncSourceManager() {
        this.mHighStreamFirstSsrc.set(YMFStreamSyncSourceManager.randomInt(10, 100));
        this.mLowStreamFirstSsrc.set(YMFStreamSyncSourceManager.randomInt(10, 100));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeVideoConfig() {
        YMFStreamSyncSourceManager yMFStreamSyncSourceManager = this;
        synchronized (yMFStreamSyncSourceManager) {
            this.mChangeSyncSourceFlag.set(true);
            this.mHighStreamChangeSyncSourcePts.set(-1L);
            this.mLowStreamChangeSyncSourcePts.set(-1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeVideoSource() {
        YMFStreamSyncSourceManager yMFStreamSyncSourceManager = this;
        synchronized (yMFStreamSyncSourceManager) {
            this.mChangeSyncSourceFlag.set(true);
            this.mHighStreamChangeSyncSourcePts.set(-1L);
            this.mLowStreamChangeSyncSourcePts.set(-1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeEncoderConfig() {
        YMFStreamSyncSourceManager yMFStreamSyncSourceManager = this;
        synchronized (yMFStreamSyncSourceManager) {
            this.mChangeSyncSourceFlag.set(true);
            this.mHighStreamChangeSyncSourcePts.set(-1L);
            this.mLowStreamChangeSyncSourcePts.set(-1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reStartCapture() {
        YMFStreamSyncSourceManager yMFStreamSyncSourceManager = this;
        synchronized (yMFStreamSyncSourceManager) {
            this.mChangeSyncSourceFlag.set(true);
            this.mHighStreamChangeSyncSourcePts.set(-1L);
            this.mLowStreamChangeSyncSourcePts.set(-1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAndResetSyncSourceFlag(long pts) {
        YMFStreamSyncSourceManager yMFStreamSyncSourceManager = this;
        synchronized (yMFStreamSyncSourceManager) {
            boolean result = this.mChangeSyncSourceFlag.get();
            this.mChangeSyncSourceFlag.set(false);
            if (result) {
                this.mHighStreamChangeSyncSourcePts.set(pts);
                this.mLowStreamChangeSyncSourcePts.set(pts);
                this.mHighStreamFirstSsrc.getAndIncrement();
                this.mLowStreamFirstSsrc.getAndIncrement();
            }
            return result;
        }
    }

    public void getExtraData(YMFVideoEncodeFrame videoEncodeFrame) {
        if (videoEncodeFrame.streamId == 0) {
            this.getHighStreamExtraData(videoEncodeFrame);
        } else {
            this.getLowStreamExtraData(videoEncodeFrame);
        }
    }

    private void getHighStreamExtraData(YMFVideoEncodeFrame videoEncodeFrame) {
        int ssrc;
        if (this.mHighStreamExtraData == null) {
            this.mHighStreamExtraData = new byte[20];
        }
        String str = "ssrc=";
        if (videoEncodeFrame.pts < this.mHighStreamChangeSyncSourcePts.get() && this.mHighStreamChangeSyncSourcePts.get() > 0L) {
            str = str + "1";
            ssrc = 1;
        } else {
            str = str + "" + this.mHighStreamFirstSsrc.get();
            ssrc = this.mHighStreamFirstSsrc.get();
        }
        str = str + ":";
        System.arraycopy(str.getBytes(), 0, this.mHighStreamExtraData, 0, str.length());
        videoEncodeFrame.extraData = this.mHighStreamExtraData;
        videoEncodeFrame.extraDataLen = str.length();
        if (this.mPrintHighStreamSsrc != ssrc && videoEncodeFrame.pts > 0L && videoEncodeFrame.frameType < 5) {
            YMFLog.error((Object)this, "[SSRC]", "high " + videoEncodeFrame.streamId + "  " + videoEncodeFrame.pts + " ssrc:" + str);
            this.mPrintHighStreamSsrc = ssrc;
        }
    }

    private void getLowStreamExtraData(YMFVideoEncodeFrame videoEncodeFrame) {
        int ssrc;
        if (this.mLowStreamExtraData == null) {
            this.mLowStreamExtraData = new byte[20];
        }
        String str = "ssrc=";
        if (videoEncodeFrame.pts < this.mLowStreamChangeSyncSourcePts.get() && this.mLowStreamChangeSyncSourcePts.get() > 0L) {
            str = str + "1";
            ssrc = 1;
        } else {
            str = str + "" + this.mLowStreamFirstSsrc.get();
            ssrc = this.mLowStreamFirstSsrc.get();
        }
        str = str + ":";
        System.arraycopy(str.getBytes(), 0, this.mLowStreamExtraData, 0, str.length());
        videoEncodeFrame.extraData = this.mLowStreamExtraData;
        videoEncodeFrame.extraDataLen = str.length();
        if (this.mPrintLowStreamSsrc != ssrc && videoEncodeFrame.pts > 0L && videoEncodeFrame.frameType < 5) {
            YMFLog.error((Object)this, "[SSRC]", "low" + videoEncodeFrame.streamId + "  " + videoEncodeFrame.pts + " ssrc:" + str);
            this.mPrintLowStreamSsrc = ssrc;
        }
    }

    public void deInit() {
        this.mLowStreamChangeSyncSourcePts.set(-1L);
        this.mHighStreamChangeSyncSourcePts.set(-1L);
        this.mChangeSyncSourceFlag.set(false);
    }
}

