/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.graphics.Bitmap;
import android.hardware.Camera;
import android.media.projection.MediaProjection;
import android.opengl.EGL14;
import android.os.Build;
import android.view.SurfaceView;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraListener;
import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.CameraUtils;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.IPublishListener;
import com.yy.mediaframework.IYMFDeliverCallback;
import com.yy.mediaframework.UploadStreamStateParams;
import com.yy.mediaframework.VideoLiveSessionYCloud;
import com.yy.mediaframework.YMFExternalFrame;
import com.yy.mediaframework.YMFExternalTextureSessionYCloud;
import com.yy.mediaframework.YMFStreamSyncSourceManager;
import com.yy.mediaframework.YYCamera;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.api.IYMFEncoderStatisticListener;
import com.yy.mediaframework.api.YMFEncoderStatisticInfo;
import com.yy.mediaframework.api.YMFVideoEncodeFrame;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoPublisheParam;
import com.yy.mediaframework.base.YMFLowStreamEncoderConfig;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.mediaframework.gpuimage.FilterType;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.model.Rect;
import com.yy.mediaframework.screenlive.ScreenLiveSessionYCloud;
import com.yy.mediaframework.screenshot.ScreenShotCallback;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.VideoDataStatUtil;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

public class YMFLiveAPI
implements IEncoderListener,
CameraListener,
IYMFDeliverCallback {
    private static final String TAG = "[YMFLiveAPI]";
    private VideoPublisheParam mUploadParams;
    private static YMFLiveAPI mInstance;
    private IPublishListener mIPublishListener;
    private IYMFEncoderStatisticListener mIEncoderStatisticListener;
    private CameraListener mCameraListener;
    private VideoLiveSessionYCloud mVideoLiveSessionYCloud = null;
    private ScreenLiveSessionYCloud mScreenLiveSessionYCloud = null;
    private YMFExternalTextureSessionYCloud mExternalVideoLiveSessionYCloud = null;
    private List<YMFEncoderStatisticInfo> mEncoderStatInfoList = null;
    private int mNotifyResolutioWidth = 0;
    private int mNotifyResolutioHeight = 0;
    private int mNotifyLowStreamResolutioWidth = 0;
    private int mNotifyLowStreamResolutioHeight = 0;
    private VideoEncoderConfig mVideoEncoderConfig;
    private CameraPreviewConfig mCameraPreviewConfig;
    private SurfaceView mCameraSurfaceView = null;
    private boolean mNeedCheckCameraCfgFlag = false;
    private boolean mAnchorStatusPreviewingCallback = true;
    private boolean mCameraOpened = false;
    private boolean mNeedRestartCaptureFlag = false;
    private boolean mNeedCheckEncoderCfgFlag = false;
    private boolean mNeedRestartEncoderFlag = false;
    private boolean mNeedLowDelayChangeFlag = false;
    private long mFrameCount = 0L;
    private Bitmap mLocalBitmap = null;
    private boolean mOnlyRestartCapture = false;
    private Constant.EncodedStream mEncodedStreamFlag = Constant.EncodedStream.NoneStream;
    private boolean mCameraCapturePauseFlag = false;
    private boolean mScreenCaptureFlag = false;
    private boolean mOriginCaptureFlag = false;
    private boolean mUserForceMode = false;
    private Object mDataAsyncLock = new Object();
    private Bitmap mCaptureReplaceBitmap = null;
    private boolean mOriginCaptureInputTexture = false;
    private long mOriginFrameLastTimeStamp = -1L;

    public static YMFLiveAPI getInstance() {
        if (mInstance == null) {
            mInstance = new YMFLiveAPI();
        }
        return mInstance;
    }

    private YMFLiveAPI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPublishListener(IPublishListener listener) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Procedur]", "setPublishListener:" + listener);
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setPublishListener:" + (listener == null ? "0" : "1"));
            this.mIPublishListener = listener;
        }
    }

    public void setEncoderStatisticListener(IYMFEncoderStatisticListener listener) {
        this.mIEncoderStatisticListener = listener;
    }

    public void setCameraListener(CameraListener listener) {
        this.mCameraListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destory() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Encoder ]", "destory");
            this.mAnchorStatusPreviewingCallback = true;
            if (this.mNeedCheckEncoderCfgFlag) {
                if (this.mEncodedStreamFlag == Constant.EncodedStream.ScreenStream) {
                    this.stopEncodeScreen();
                } else if (this.mEncodedStreamFlag == Constant.EncodedStream.OriginStream) {
                    this.stopEncodeOrigin();
                } else if (this.mEncodedStreamFlag == Constant.EncodedStream.CameraStream) {
                    this.stopEncodeVideo();
                }
            }
            if (this.mNeedCheckCameraCfgFlag) {
                if (this.mScreenCaptureFlag) {
                    this.stopScreenCapture();
                }
                if (this.mOriginCaptureFlag) {
                    this.stopOriginCapture();
                }
                if (this.mNeedCheckCameraCfgFlag) {
                    this.mVideoLiveSessionYCloud.setPreviewSurfaceView(null);
                    this.stopVideoCapture();
                }
            }
            if (this.mVideoLiveSessionYCloud != null) {
                this.deInitVideoLiveSession();
            }
            if (this.mScreenLiveSessionYCloud != null) {
                this.deInitScreenSession();
            }
            if (this.mExternalVideoLiveSessionYCloud != null) {
                this.deInitOriginLiveSession();
            }
            this.mCaptureReplaceBitmap = null;
            this.resetUploadStreamParams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePublisherConfig(VideoPublisheParam params) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Encoder ]", "updatePublisherConfig:" + params.toString());
            YMFLiveUsrBehaviorStat.getInstance().notifyUpdatePublisherConfig(params);
            if (this.mUploadParams == null) {
                this.mUploadParams = new VideoPublisheParam();
            }
            this.mUploadParams.assign(params);
            if (UploadStreamStateParams.mCaptureFpsMode == Constant.CaptureFpsMode.AlignEncoder) {
                this.mUploadParams.captureFrameRate = this.mUploadParams.encodeFrameRate + 2;
                YMFLog.info(this, "[Encoder ]", "updatePublisherConfig AlignEncoder mode,change captureFps " + this.mUploadParams.captureFrameRate + "->" + this.mUploadParams.encodeFrameRate);
            }
            this.disassembleUploadParams();
            if (this.mCameraPreviewConfig != null) {
                this.mCameraPreviewConfig.mZoomFactor = 0.0f;
                this.mCameraPreviewConfig.mIsTorchOn = false;
            }
            if (this.mNeedRestartEncoderFlag) {
                YMFLog.info(this, "[Encoder ]", "updatePublisherConfig restart encoder:" + this.mVideoEncoderConfig);
                if (this.mEncodedStreamFlag == Constant.EncodedStream.CameraStream) {
                    this.mVideoLiveSessionYCloud.setEncoderListener(null);
                    this.mVideoLiveSessionYCloud.stopEncoder();
                    if (this.mNeedRestartCaptureFlag) {
                        this.mVideoLiveSessionYCloud.mTmpVideoEncoderConfig = this.mVideoEncoderConfig;
                        YYCamera.getInstance().changePreviewParameter(this.mCameraPreviewConfig.mCaptureResolutionWidth, this.mCameraPreviewConfig.mCaptureResolutionHeight, this.mCameraPreviewConfig.mCaptureFrameRate, this.mCameraPreviewConfig.mCameraPosition == 0 ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack, this.mCameraPreviewConfig.mCaptureOrientation, CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE);
                        this.mVideoLiveSessionYCloud.enablePreviewMirror(UploadStreamStateParams.mPreviewMirror);
                        this.mVideoLiveSessionYCloud.enableMirror(UploadStreamStateParams.mEncoderMirror);
                        this.mNeedRestartCaptureFlag = false;
                    } else {
                        this.mVideoLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
                    }
                    this.mVideoLiveSessionYCloud.setLowStreamEncoderConfigs(this.mUploadParams.lowStreamConfigs, this.mUploadParams.bEnableLocalDualStreamMode);
                    this.mVideoLiveSessionYCloud.setEncoderListener(this);
                    this.mVideoLiveSessionYCloud.startEncoder();
                    if (this.mVideoLiveSessionYCloud != null && UploadStreamStateParams.mWaterMarkBitmap != null) {
                        this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                    }
                    if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
                        this.mVideoLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
                        this.mVideoLiveSessionYCloud.setAbroadNetWorkStrategy(UploadStreamStateParams.mNetWorkStrategy);
                    }
                    this.mVideoLiveSessionYCloud.enableMirror(UploadStreamStateParams.mEncoderMirror);
                } else if (this.mEncodedStreamFlag == Constant.EncodedStream.ScreenStream) {
                    this.mScreenLiveSessionYCloud.setEncoderListener(null);
                    this.mScreenLiveSessionYCloud.stopEncoder();
                    this.mScreenLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
                    this.mScreenLiveSessionYCloud.setLowStreamEncoderConfigs(this.mUploadParams.lowStreamConfigs, this.mUploadParams.bEnableLocalDualStreamMode);
                    this.mScreenLiveSessionYCloud.setCaptureResolution(this.mVideoEncoderConfig.mEncodeWidth, this.mVideoEncoderConfig.mEncodeHeight);
                    this.mScreenLiveSessionYCloud.setEncoderListener(this);
                    this.mScreenLiveSessionYCloud.startEncoder();
                    if (this.mScreenLiveSessionYCloud != null && UploadStreamStateParams.mWaterMarkBitmap != null) {
                        this.mScreenLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                    }
                    if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
                        this.mScreenLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
                        this.mScreenLiveSessionYCloud.setAbroadNetWorkStrategy(UploadStreamStateParams.mNetWorkStrategy);
                    }
                } else if (this.mEncodedStreamFlag == Constant.EncodedStream.OriginStream && this.mExternalVideoLiveSessionYCloud != null) {
                    this.mExternalVideoLiveSessionYCloud.setEncoderListener(null);
                    this.mExternalVideoLiveSessionYCloud.stopEncoder();
                    this.mExternalVideoLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
                    this.mExternalVideoLiveSessionYCloud.setLowStreamEncoderConfigs(this.mUploadParams.lowStreamConfigs, this.mUploadParams.bEnableLocalDualStreamMode);
                    this.mExternalVideoLiveSessionYCloud.setEncoderListener(this);
                    this.mExternalVideoLiveSessionYCloud.startEncoder();
                    if (this.mExternalVideoLiveSessionYCloud != null && UploadStreamStateParams.mWaterMarkBitmap != null) {
                        this.mExternalVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                    }
                    if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
                        this.mExternalVideoLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
                        this.mExternalVideoLiveSessionYCloud.setAbroadNetWorkStrategy(UploadStreamStateParams.mNetWorkStrategy);
                    }
                }
                YMFStreamSyncSourceManager.getInstance().changeVideoConfig();
                this.mNeedRestartEncoderFlag = false;
            }
            if (this.mNeedRestartCaptureFlag) {
                this.mVideoLiveSessionYCloud.mTmpAssignVideoEncoderConfig = this.mVideoEncoderConfig;
                YYCamera.getInstance().changePreviewParameter(this.mCameraPreviewConfig.mCaptureResolutionWidth, this.mCameraPreviewConfig.mCaptureResolutionHeight, this.mCameraPreviewConfig.mCaptureFrameRate, this.mCameraPreviewConfig.mCameraPosition == 0 ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack, this.mCameraPreviewConfig.mCaptureOrientation, CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE);
                this.mVideoLiveSessionYCloud.assignEncoderConfig(this.mVideoEncoderConfig);
                if (UploadStreamStateParams.mWaterMarkBitmap != null) {
                    this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                }
                this.mVideoLiveSessionYCloud.enablePreviewMirror(UploadStreamStateParams.mPreviewMirror);
                this.mVideoLiveSessionYCloud.enableMirror(UploadStreamStateParams.mEncoderMirror);
                this.mNeedRestartCaptureFlag = false;
                if (this.mEncodedStreamFlag == Constant.EncodedStream.CameraStream) {
                    YMFStreamSyncSourceManager.getInstance().changeVideoConfig();
                }
            } else if (this.mEncodedStreamFlag == Constant.EncodedStream.NoneStream && this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.assignEncoderConfig(this.mVideoEncoderConfig);
                if (UploadStreamStateParams.mWaterMarkBitmap != null) {
                    this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                }
            }
            if (this.mNeedLowDelayChangeFlag) {
                if (this.mEncodedStreamFlag == Constant.EncodedStream.CameraStream) {
                    this.mVideoLiveSessionYCloud.setLowStreamEncoderConfigs(this.mUploadParams.lowStreamConfigs, this.mUploadParams.bEnableLocalDualStreamMode);
                    this.mVideoLiveSessionYCloud.setLowDelayMode(this.mVideoEncoderConfig.mLowDelay);
                } else if (this.mEncodedStreamFlag == Constant.EncodedStream.ScreenStream) {
                    this.mScreenLiveSessionYCloud.setLowStreamEncoderConfigs(this.mUploadParams.lowStreamConfigs, this.mUploadParams.bEnableLocalDualStreamMode);
                    this.mScreenLiveSessionYCloud.setLowDelayMode(this.mVideoEncoderConfig.mLowDelay);
                } else if (this.mEncodedStreamFlag == Constant.EncodedStream.OriginStream && this.mExternalVideoLiveSessionYCloud != null) {
                    this.mExternalVideoLiveSessionYCloud.setLowStreamEncoderConfigs(this.mUploadParams.lowStreamConfigs, this.mUploadParams.bEnableLocalDualStreamMode);
                    this.mExternalVideoLiveSessionYCloud.setLowDelayMode(this.mVideoEncoderConfig.mLowDelay);
                }
                this.mNeedLowDelayChangeFlag = false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startVideoCapture() {
        YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(0, true);
        YMFLiveStatisticManager.getInstance().setCaptureType(1);
        if (this.mCameraPreviewConfig == null) {
            YMFLog.error((Object)this, "[CCapture]", "startVideoCapture error: not set UploadParams");
            return -1;
        }
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(0, true);
            VideoDataStatUtil.putCaptureType(0);
            if (this.mCameraPreviewConfig == null) {
                YMFLog.error((Object)this, "[CCapture]", "startVideoCapture error: not set UploadParams");
                return -1;
            }
            if (this.mCameraOpened) {
                YMFLog.error((Object)this, "[CCapture]", "startVideoCapture camera is opened");
                return 0;
            }
            if (this.mVideoLiveSessionYCloud == null) {
                this.initVideoLiveSession();
            }
            int cameraStatue = YYCamera.getInstance().startPreview(this.mCameraPreviewConfig.mCaptureResolutionWidth, this.mCameraPreviewConfig.mCaptureResolutionHeight, this.mCameraPreviewConfig.mCaptureFrameRate, this.mCameraPreviewConfig.mCameraPosition == 0 ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack, this.mCameraPreviewConfig.mCaptureOrientation, CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE);
            if (this.mVideoLiveSessionYCloud != null) {
                if (this.mEncodedStreamFlag == Constant.EncodedStream.CameraStream && this.mOnlyRestartCapture) {
                    YMFStreamSyncSourceManager.getInstance().reStartCapture();
                }
                this.mVideoLiveSessionYCloud.enablePreviewMirror(UploadStreamStateParams.mPreviewMirror);
                this.mVideoLiveSessionYCloud.enableMirror(UploadStreamStateParams.mEncoderMirror);
                this.mVideoLiveSessionYCloud.assignEncoderConfig(this.mVideoEncoderConfig);
                if (UploadStreamStateParams.mWaterMarkBitmap != null && !UploadStreamStateParams.mWaterMarkEffect) {
                    this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                }
                this.mVideoLiveSessionYCloud.setScaleMode(UploadStreamStateParams.mScaleMode);
                this.mVideoLiveSessionYCloud.setPreviewSurfaceView(this.mCameraSurfaceView);
                this.mVideoLiveSessionYCloud.setCaptureReplaceImage(this.mCaptureReplaceBitmap);
            }
            if (cameraStatue == 0) {
                this.mCameraOpened = true;
            }
            this.mNeedCheckCameraCfgFlag = true;
            this.mCameraCapturePauseFlag = false;
            return cameraStatue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pauseVideoCapture(boolean bPauseCapture) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyPauseVideoCapture(bPauseCapture);
            YMFLog.info(this, "[CCapture]", "pauseVideoCapture:" + bPauseCapture + ":" + this.mNeedCheckCameraCfgFlag);
            if (!this.mNeedCheckCameraCfgFlag) {
                return -1;
            }
            YYCamera.getInstance().resumeCameraAutoFocusFace(true);
            this.mCameraCapturePauseFlag = bPauseCapture;
            int cameraStatue = 0;
            if (this.mCameraCapturePauseFlag) {
                CameraInterface.getInstance().releaseCamera();
                this.mCameraOpened = false;
                YMFLiveUsrBehaviorStat.getInstance().notifyCameraCaptureState(false);
            } else {
                if (this.mEncodedStreamFlag == Constant.EncodedStream.CameraStream) {
                    YMFStreamSyncSourceManager.getInstance().reStartCapture();
                }
                cameraStatue = YYCamera.getInstance().startPreview(this.mCameraPreviewConfig.mCaptureResolutionWidth, this.mCameraPreviewConfig.mCaptureResolutionHeight, this.mCameraPreviewConfig.mCaptureFrameRate, this.mCameraPreviewConfig.mCameraPosition == 0 ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack, this.mCameraPreviewConfig.mCaptureOrientation, CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE);
                if (this.mVideoLiveSessionYCloud != null) {
                    this.mVideoLiveSessionYCloud.enablePreviewMirror(UploadStreamStateParams.mPreviewMirror);
                    this.mVideoLiveSessionYCloud.enableMirror(UploadStreamStateParams.mEncoderMirror);
                    if (UploadStreamStateParams.mWaterMarkBitmap != null && !UploadStreamStateParams.mWaterMarkEffect) {
                        this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                    }
                    this.mVideoLiveSessionYCloud.setScaleMode(UploadStreamStateParams.mScaleMode);
                    this.mVideoLiveSessionYCloud.setPreviewSurfaceView(this.mCameraSurfaceView);
                }
                if (cameraStatue == 0) {
                    this.mCameraOpened = true;
                    if (this.mCameraPreviewConfig.mZoomFactor > 0.0f) {
                        YYCamera.getInstance().setZoom(this.mCameraPreviewConfig.mZoomFactor);
                    }
                    if (this.mCameraPreviewConfig.mIsTorchOn) {
                        YYCamera.getInstance().setCameraTorchOn(this.mCameraPreviewConfig.mIsTorchOn);
                    }
                }
            }
            return cameraStatue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopVideoCapture() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mCameraPreviewConfig != null) {
                this.mCameraPreviewConfig.mIsTorchOn = false;
                this.mCameraPreviewConfig.mZoomFactor = 1.0f;
            }
            YYCamera.getInstance().resumeZoomValue(1.0f);
            YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(0, false);
            CameraInterface.getInstance().releaseCamera();
            YMFLiveUsrBehaviorStat.getInstance().notifyCameraCaptureState(false);
            this.mNeedCheckCameraCfgFlag = false;
            this.mCameraOpened = false;
            if (!this.mNeedCheckEncoderCfgFlag && !this.mNeedCheckCameraCfgFlag) {
                this.deInitVideoLiveSession();
            } else if (this.mEncodedStreamFlag == Constant.EncodedStream.CameraStream) {
                this.mOnlyRestartCapture = true;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkCamera() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            Camera camera;
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("checkCamera");
            YMFLog.info(this, "[CCapture]", "startCheckCamera...");
            String res = "";
            if (CameraUtils.isCameraAvailable(1)) {
                res = res + "front camera is supported\n";
                camera = CameraUtils.openCamera(CameraUtils.CameraFacing.FacingFront);
                if (camera != null) {
                    res = res + "front camera can be used\n";
                    camera.release();
                } else {
                    res = res + "front camera cannot be used\n";
                }
            } else {
                res = res + "front camera is not supported\n";
            }
            if (CameraUtils.isCameraAvailable(0)) {
                res = res + "back camera is supported\n";
                camera = CameraUtils.openCamera(CameraUtils.CameraFacing.FacingBack);
                if (camera != null) {
                    res = res + "back camera can be used\n";
                    camera.release();
                } else {
                    res = res + "back camera cannot be used\n";
                }
            } else {
                res = res + "back camera is not supported\n";
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startPreview(SurfaceView view, int renderMode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyPreviewState(true, renderMode);
            YMFLog.info(this, "[Preview ]", "startPreview:" + view + "," + renderMode);
            this.setPreviewRenderMode(renderMode);
            this.mCameraSurfaceView = view;
            if (this.mVideoLiveSessionYCloud == null) {
                this.initVideoLiveSession();
            }
            if (this.mCameraOpened) {
                this.mVideoLiveSessionYCloud.setScaleMode(UploadStreamStateParams.mScaleMode);
                this.mVideoLiveSessionYCloud.setPreviewSurfaceView(view);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopPreview() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyPreviewState(false, -1);
            YMFLog.info(this, "[Preview ]", "stopPreview...");
            if (this.mCameraPreviewConfig != null) {
                this.mCameraPreviewConfig.mIsTorchOn = false;
                this.mCameraPreviewConfig.mZoomFactor = 1.0f;
            }
            YYCamera.getInstance().resumeZoomValue(1.0f);
            this.mCameraSurfaceView = null;
            this.mAnchorStatusPreviewingCallback = true;
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.setPreviewSurfaceView(null);
                this.mVideoLiveSessionYCloud.reSetPreviewState();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startEncodeVideo() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(0, true);
            YMFLog.info(this, "[Encoder ]", "startEncodeVideo...");
            if (this.mVideoEncoderConfig == null) {
                YMFLog.error((Object)this, "[CCapture]", "startVideoCapture error: not set UploadParams");
                return -1;
            }
            if (this.mVideoLiveSessionYCloud == null) {
                this.initVideoLiveSession();
            }
            this.mVideoLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
            this.mVideoLiveSessionYCloud.setEncoderListener(this);
            this.mVideoLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
            this.mVideoLiveSessionYCloud.setLowStreamEncoderConfigs(this.mUploadParams.lowStreamConfigs, this.mUploadParams.bEnableLocalDualStreamMode);
            if (UploadStreamStateParams.mWaterMarkBitmap != null && !UploadStreamStateParams.mWaterMarkEffect) {
                this.mVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                UploadStreamStateParams.mWaterMarkEffect = true;
            }
            this.mVideoLiveSessionYCloud.startEncoder();
            this.mVideoLiveSessionYCloud.enableMirror(UploadStreamStateParams.mEncoderMirror);
            if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
                this.mVideoLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
                this.mVideoLiveSessionYCloud.setAbroadNetWorkStrategy(UploadStreamStateParams.mNetWorkStrategy);
            }
            this.mNeedCheckEncoderCfgFlag = true;
            if (this.mEncodedStreamFlag != Constant.EncodedStream.NoneStream) {
                YMFLog.warn(this, "[Encoder ]", "has anothre stream encoded " + (Object)((Object)this.mEncodedStreamFlag));
            }
            this.mEncodedStreamFlag = Constant.EncodedStream.CameraStream;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopEncodeVideo() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(0, false);
            YMFLog.info(this, "[Encoder ]", "stopEncodeVideo..");
            if (this.mVideoLiveSessionYCloud == null) {
                return -1;
            }
            this.mVideoLiveSessionYCloud.setEncoderListener(null);
            this.mVideoLiveSessionYCloud.stopEncoder();
            this.mNeedCheckEncoderCfgFlag = false;
            UploadStreamStateParams.mWaterMarkEffect = false;
            this.mEncodedStreamFlag = Constant.EncodedStream.NoneStream;
            if (!this.mNeedCheckEncoderCfgFlag && !this.mNeedCheckCameraCfgFlag) {
                this.deInitVideoLiveSession();
            }
            this.mNotifyResolutioWidth = 0;
            this.mNotifyResolutioHeight = 0;
            this.mNotifyLowStreamResolutioWidth = 0;
            this.mNotifyLowStreamResolutioHeight = 0;
            this.mOnlyRestartCapture = false;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setLocalVideoMirrorMode(int mode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifySetVideoMirrorMode(mode);
            if (mode == 0) {
                UploadStreamStateParams.mPreviewMirror = true;
                UploadStreamStateParams.mEncoderMirror = false;
            } else if (mode == 1) {
                UploadStreamStateParams.mPreviewMirror = true;
                UploadStreamStateParams.mEncoderMirror = true;
            } else if (mode == 2) {
                UploadStreamStateParams.mPreviewMirror = false;
                UploadStreamStateParams.mEncoderMirror = false;
            } else if (mode == 3) {
                UploadStreamStateParams.mPreviewMirror = false;
                UploadStreamStateParams.mEncoderMirror = true;
            }
            YMFLog.info(this, "[Api     ]", " setLocalVideoMirrorMode:" + mode + " <" + UploadStreamStateParams.mPreviewMirror + ", " + UploadStreamStateParams.mEncoderMirror + ">");
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.enablePreviewMirror(UploadStreamStateParams.mPreviewMirror);
                this.mVideoLiveSessionYCloud.enableMirror(UploadStreamStateParams.mEncoderMirror);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCameraPosition(int position) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setCameraPosition:" + position);
            YMFLog.info(this, "[CCapture]", "setCameraPosition:" + position);
            UploadStreamStateParams.mCameraPosition = position;
            if (this.mCameraPreviewConfig != null) {
                this.mCameraPreviewConfig.mCameraPosition = UploadStreamStateParams.mCameraPosition;
            }
            if (this.mNeedCheckCameraCfgFlag && !this.mCameraCapturePauseFlag && (YYCamera.getInstance().isCameraFront() && UploadStreamStateParams.mCameraPosition != 0 || !YYCamera.getInstance().isCameraFront() && UploadStreamStateParams.mCameraPosition == 0)) {
                if (this.mCameraPreviewConfig != null) {
                    this.mCameraPreviewConfig.mZoomFactor = 1.0f;
                    this.mCameraPreviewConfig.mIsTorchOn = false;
                }
                YYCamera.getInstance().resumeZoomValue(1.0f);
                YYCamera.getInstance().switchCamera();
                this.requestEncodeIFrame();
                YMFStreamSyncSourceManager.getInstance().changeVideoConfig();
                YMFLiveUsrBehaviorStat.getInstance().notifySwitchCamera(true);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int setLocalVideoCanvas(SurfaceView view, int renderMode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPreviewRenderMode(int renderMode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (renderMode == 0) {
                UploadStreamStateParams.mScaleMode = Constant.ScaleMode.ScacleToFill;
            } else if (renderMode == 1) {
                UploadStreamStateParams.mScaleMode = Constant.ScaleMode.AspectFit;
            } else if (renderMode == 2) {
                UploadStreamStateParams.mScaleMode = Constant.ScaleMode.AspectFill;
            }
            YMFLog.info(this, "[Preview ]", "setPreviewRenderMode " + renderMode + " :" + (Object)((Object)UploadStreamStateParams.mScaleMode));
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.setScaleMode(UploadStreamStateParams.mScaleMode);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeltaYYPtsMillions(long deltaPtsDts) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setDeltaYYPtsMillions:" + deltaPtsDts);
            YMFLog.info(this, "[Api     ]", "setDeltaYYPtsMillions:" + deltaPtsDts);
            UploadStreamStateParams.mDeltaPtsDts = deltaPtsDts;
            if (this.mScreenLiveSessionYCloud != null) {
                this.mScreenLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
            }
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
            }
            if (this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCameraPosition() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("getCameraPosition");
            return YYCamera.getInstance().getCameraFacing().ordinal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setWatermark(Bitmap bitmap, int offsetX, int offsetY) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifySetWaterMark(bitmap == null, offsetX, offsetY);
            YMFLog.info(this, "[Api     ]", "setWatermark " + bitmap + ":" + offsetX + "," + offsetY + ",status" + this.mNeedCheckEncoderCfgFlag);
            UploadStreamStateParams.mWaterMarkBitmap = bitmap;
            UploadStreamStateParams.mOffsetX = offsetX;
            UploadStreamStateParams.mOffsetY = offsetY;
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.setWaterMark(bitmap, offsetX, offsetY);
            }
            if (this.mScreenLiveSessionYCloud != null) {
                this.mScreenLiveSessionYCloud.setWaterMark(bitmap, offsetX, offsetY);
            }
            if (this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.setWaterMark(bitmap, offsetX, offsetY);
            }
            if (this.mNeedCheckEncoderCfgFlag) {
                UploadStreamStateParams.mWaterMarkEffect = true;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestEncodeIFrame() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.requestIFrame();
            }
            if (this.mScreenLiveSessionYCloud != null) {
                this.mScreenLiveSessionYCloud.requestIFrame();
            }
            if (this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.requestIFrame();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkBitrateSuggest(int bitrate) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mNeedCheckEncoderCfgFlag) {
                YMFLog.info(this, "[Encoder ]", "live setNetworkBitrateSuggest outside:" + bitrate + " flag:" + this.mNeedCheckEncoderCfgFlag + "," + this.mCameraCapturePauseFlag + "," + this.mCameraOpened);
                if (this.mEncodedStreamFlag == Constant.EncodedStream.ScreenStream && this.mScreenLiveSessionYCloud != null) {
                    this.mScreenLiveSessionYCloud.setNetworkBitrateSuggest(bitrate);
                } else if (this.mEncodedStreamFlag == Constant.EncodedStream.OriginStream && this.mExternalVideoLiveSessionYCloud != null && this.mOriginCaptureFlag) {
                    this.mExternalVideoLiveSessionYCloud.setNetworkBitrateSuggest(bitrate);
                } else if (this.mEncodedStreamFlag == Constant.EncodedStream.CameraStream && this.mVideoLiveSessionYCloud != null && !this.mCameraCapturePauseFlag && this.mCameraOpened) {
                    this.mVideoLiveSessionYCloud.setNetworkBitrateSuggest(bitrate);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVideoPublishInfo(VideoPublishInfoEnum infoEnum, int typeId) {
        Object object = this.mDataAsyncLock;
        synchronized (object) {
            int videoPublishInfo = -1;
            if (infoEnum.ordinal() == VideoPublishInfoEnum.CAPTUREMODE.ordinal()) {
                videoPublishInfo = this.mVideoLiveSessionYCloud == null ? UploadStreamStateParams.mCaptureMode.ordinal() : (this.mVideoLiveSessionYCloud.getVideoProcessMode() ? Constant.CaptureMode.YuvMode.ordinal() : Constant.CaptureMode.TextureMode.ordinal());
                return videoPublishInfo;
            }
            if (infoEnum.ordinal() == VideoPublishInfoEnum.PRRVIEWTYPE.ordinal()) {
                videoPublishInfo = this.mVideoLiveSessionYCloud == null ? UploadStreamStateParams.mPreviewMode.ordinal() : (this.mVideoLiveSessionYCloud.getVideoPreviewMode() == Constant.PreviewMode.TextureMode.ordinal() ? Constant.PreviewMode.TextureMode.ordinal() : (this.mVideoLiveSessionYCloud.getVideoPreviewMode() == Constant.PreviewMode.CanvasMode.ordinal() ? Constant.PreviewMode.CanvasMode.ordinal() : Constant.PreviewMode.GlSurfaceMode.ordinal()));
                return videoPublishInfo;
            }
            if (infoEnum.ordinal() == VideoPublishInfoEnum.CAPTUREFPS.ordinal()) {
                videoPublishInfo = this.mVideoLiveSessionYCloud == null ? 0 : this.mVideoLiveSessionYCloud.getCurrentCameraFps();
                return videoPublishInfo;
            }
            if (infoEnum.ordinal() == VideoPublishInfoEnum.CAPTUREFPSMODE.ordinal()) {
                videoPublishInfo = UploadStreamStateParams.mCaptureFpsMode.ordinal();
                return videoPublishInfo;
            }
            if (infoEnum.ordinal() == VideoPublishInfoEnum.SETCAPTUREFPS.ordinal()) {
                videoPublishInfo = CameraInterface.mSetCameraFpsParams;
                return videoPublishInfo;
            }
            if (infoEnum.ordinal() == VideoPublishInfoEnum.YUVTEXTUREMODE.ordinal()) {
                videoPublishInfo = UploadStreamStateParams.mYuvTextureMode ? 1 : 0;
                return videoPublishInfo;
            }
            YMFEncoderStatisticInfo encoderStatisticInfo = null;
            if (this.mEncoderStatInfoList == null) {
                return -1;
            }
            for (YMFEncoderStatisticInfo info : this.mEncoderStatInfoList) {
                if (info.mStreamId != typeId) continue;
                encoderStatisticInfo = info;
            }
            if (encoderStatisticInfo == null) {
                return -1;
            }
            if (infoEnum.ordinal() == VideoPublishInfoEnum.FRAME.ordinal()) {
                videoPublishInfo = encoderStatisticInfo.mFrameRate;
            } else if (infoEnum.ordinal() == VideoPublishInfoEnum.BITRATE.ordinal()) {
                videoPublishInfo = encoderStatisticInfo.mBitRate;
            } else if (infoEnum.ordinal() == VideoPublishInfoEnum.RESOLUTION.ordinal()) {
                videoPublishInfo = encoderStatisticInfo.mWidth << 16 | encoderStatisticInfo.mHeight;
            } else if (infoEnum.ordinal() == VideoPublishInfoEnum.DYNAMIC_ENC_FRAME_RATE.ordinal()) {
                videoPublishInfo = encoderStatisticInfo.mStreamId == 0 ? VideoDataStat.getInstance().getDynamicEncodeFrameRate() : encoderStatisticInfo.mFrameRate;
            } else if (infoEnum.ordinal() == VideoPublishInfoEnum.PREVIEW_FRAME_RATE.ordinal()) {
                videoPublishInfo = VideoDataStat.getInstance().getPreviewFrameRate();
            } else if (infoEnum.ordinal() == VideoPublishInfoEnum.ENCODETYPE.ordinal() && encoderStatisticInfo.mEncoderType != null) {
                videoPublishInfo = encoderStatisticInfo.mEncoderType.ordinal();
            }
            return videoPublishInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setHardwareEncoderAvailable(boolean available) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setHardwareEncoderAvailable:" + (available ? "1" : "0"));
            YMFLog.info(this, "[Api     ]", "setHardwareEncoderAvailable:" + available);
            UploadStreamStateParams.mDisableHardEncoder.set(true);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeScreenLiveMode(Boolean usedBitmap, Bitmap bitmap) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("changeScreenLiveMode,usedBitmap:" + (usedBitmap != false ? "1" : "0") + ",bitmap:" + (bitmap == null ? "1" : "0"));
            if (this.mScreenLiveSessionYCloud != null) {
                this.mScreenLiveSessionYCloud.changeScreenLiveMode(usedBitmap, bitmap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGPUImageBeautyFilter(IGPUProcess gpuImageProcess) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifySetGPUImageBeautyFilter(gpuImageProcess != null);
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.setGPUImageBeautyFilter(gpuImageProcess);
            } else {
                YMFLog.error((Object)this, "[Api     ]", "setGPUImageBeautyFilter failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreviewFrameCallback(PreviewFrameCallback callback) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("addPreviewFrameCallback");
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.registerCallback(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreviewFrameCallback(PreviewFrameCallback callback) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("removePreviewFrameCallback");
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.unregisterCallback(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startOriginCapture(boolean useTexture) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            this.mOriginCaptureInputTexture = useTexture;
            YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(2, true);
            YMFLiveStatisticManager.getInstance().setCaptureType(3);
            YMFLog.info(this, "[Api     ]", "startOriginCapture..." + this.mOriginCaptureInputTexture);
            if (!useTexture && this.mExternalVideoLiveSessionYCloud == null) {
                this.initOriginLiveSession(null);
            }
            this.mOriginCaptureFlag = true;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopOriginCapture() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(2, false);
            YMFLog.info(this, "[CCapture]", "stopOriginCapture...");
            this.mFrameCount = 0L;
            this.mOriginCaptureFlag = false;
            if (this.mEncodedStreamFlag != Constant.EncodedStream.OriginStream) {
                this.deInitOriginLiveSession();
            }
            return 0;
        }
    }

    private void realStartEncodeOrigin() {
        YMFLog.info(this, "[Encoder ]", "realStartEncodeOrigin...");
        this.mExternalVideoLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
        this.mExternalVideoLiveSessionYCloud.setEncoderListener(this);
        this.mExternalVideoLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
        this.mExternalVideoLiveSessionYCloud.setLowStreamEncoderConfigs(this.mUploadParams.lowStreamConfigs, this.mUploadParams.bEnableLocalDualStreamMode);
        if (UploadStreamStateParams.mWaterMarkBitmap != null && !UploadStreamStateParams.mWaterMarkEffect) {
            this.mExternalVideoLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
            UploadStreamStateParams.mWaterMarkEffect = true;
        }
        this.mExternalVideoLiveSessionYCloud.startEncoder();
        if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
            this.mExternalVideoLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
            this.mExternalVideoLiveSessionYCloud.setAbroadNetWorkStrategy(UploadStreamStateParams.mNetWorkStrategy);
        }
        this.mExternalVideoLiveSessionYCloud.setEnableUnderflowStrategy(false);
    }

    public int startEncodeOrigin() {
        YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(2, true);
        if (!this.mOriginCaptureInputTexture) {
            if (this.mExternalVideoLiveSessionYCloud == null) {
                this.initOriginLiveSession(null);
            }
            this.realStartEncodeOrigin();
        }
        this.mNeedCheckEncoderCfgFlag = true;
        this.mEncodedStreamFlag = Constant.EncodedStream.OriginStream;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopEncodeOrigin() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(2, false);
            YMFLog.info(this, "[Encoder ]", "stopEncodeOrigin...");
            if (this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.setEncoderListener(null);
                this.mExternalVideoLiveSessionYCloud.stopEncoder();
                UploadStreamStateParams.mWaterMarkEffect = false;
            }
            this.mEncodedStreamFlag = Constant.EncodedStream.NoneStream;
            this.mNeedCheckEncoderCfgFlag = false;
            this.mNotifyResolutioWidth = 0;
            this.mNotifyResolutioHeight = 0;
            this.mNotifyLowStreamResolutioWidth = 0;
            this.mNotifyLowStreamResolutioHeight = 0;
            this.mOriginFrameLastTimeStamp = -1L;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startScreenCapture(MediaProjection mediaProjection) {
        YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(1, true);
        YMFLiveStatisticManager.getInstance().setCaptureType(2);
        YMFLog.info(this, "[SCapture]", "startScreenCapture..." + mediaProjection);
        if (this.mScreenLiveSessionYCloud == null) {
            this.initScreenSession();
        }
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(1, true);
            VideoDataStatUtil.putCaptureType(1);
            YMFLog.info(this, "[SCapture]", "startScreenCapture..." + mediaProjection);
            if (this.mScreenLiveSessionYCloud == null) {
                this.initScreenSession();
            }
            this.mScreenLiveSessionYCloud.setCaptureResolution(this.mVideoEncoderConfig.mEncodeWidth, this.mVideoEncoderConfig.mEncodeHeight);
            this.mScreenLiveSessionYCloud.setCaptureReplaceImage(this.mCaptureReplaceBitmap);
            this.mScreenLiveSessionYCloud.startCapture(mediaProjection);
            this.mScreenCaptureFlag = true;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopScreenCapture() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCaptureState(1, false);
            YMFLog.info(this, "[SCapture]", "stopScreenCapture...");
            if (this.mScreenLiveSessionYCloud != null) {
                this.mScreenLiveSessionYCloud.stopCapture();
            }
            this.mScreenCaptureFlag = false;
            if (this.mEncodedStreamFlag != Constant.EncodedStream.ScreenStream) {
                this.deInitScreenSession();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startEncodeScreen() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(1, true);
            YMFLog.info(this, "[Encoder ]", "startEncodeScreen...");
            if (this.mScreenLiveSessionYCloud == null) {
                this.initScreenSession();
            }
            this.mScreenLiveSessionYCloud.setDeltaYYPtsMillions(UploadStreamStateParams.mDeltaPtsDts);
            this.mScreenLiveSessionYCloud.setEncoderListener(this);
            this.mScreenLiveSessionYCloud.setEncoderConfig(this.mVideoEncoderConfig);
            this.mScreenLiveSessionYCloud.setLowStreamEncoderConfigs(this.mUploadParams.lowStreamConfigs, this.mUploadParams.bEnableLocalDualStreamMode);
            if (UploadStreamStateParams.mWaterMarkBitmap != null && !UploadStreamStateParams.mWaterMarkEffect) {
                this.mScreenLiveSessionYCloud.setWaterMark(UploadStreamStateParams.mWaterMarkBitmap, UploadStreamStateParams.mOffsetX, UploadStreamStateParams.mOffsetY);
                UploadStreamStateParams.mWaterMarkEffect = true;
            }
            this.mScreenLiveSessionYCloud.startEncoder();
            if (this.mUploadParams.weakNetConfigs != null && this.mUploadParams.weakNetConfigs.size() > 0) {
                this.mScreenLiveSessionYCloud.setResolutionModifyConfigs(this.mUploadParams.weakNetConfigs, this.mUploadParams.weakNetConfigsIntervalSecs);
                this.mScreenLiveSessionYCloud.setAbroadNetWorkStrategy(false);
            }
            this.mNeedCheckEncoderCfgFlag = true;
            if (this.mEncodedStreamFlag != Constant.EncodedStream.NoneStream) {
                YMFLog.warn(this, "[Encoder ]", "current has anothre stream encoded " + (Object)((Object)this.mEncodedStreamFlag));
            }
            this.mEncodedStreamFlag = Constant.EncodedStream.ScreenStream;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopEncodeScreen() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyEncodeState(1, false);
            YMFLog.info(this, "[Encoder ]", "stopPublishScreenVideo");
            if (this.mScreenLiveSessionYCloud != null) {
                this.mScreenLiveSessionYCloud.setEncoderListener(null);
                this.mScreenLiveSessionYCloud.stopEncoder();
                UploadStreamStateParams.mWaterMarkEffect = false;
            }
            this.mEncodedStreamFlag = Constant.EncodedStream.NoneStream;
            this.mNotifyResolutioWidth = 0;
            this.mNotifyResolutioHeight = 0;
            this.mNotifyLowStreamResolutioWidth = 0;
            this.mNotifyLowStreamResolutioHeight = 0;
            if (!this.mScreenCaptureFlag) {
                this.deInitScreenSession();
            }
            return 0;
        }
    }

    private int initScreenSession() {
        YMFLog.info(this, "[Procedur]", "initScreenLiveSession...");
        if (this.mScreenLiveSessionYCloud != null) {
            this.deInitScreenSession();
        }
        this.mScreenLiveSessionYCloud = new ScreenLiveSessionYCloud(YYVideoSDK.getInstance().getAppContext(), Constant.VideoStreamType.Screen);
        this.mScreenLiveSessionYCloud.setEncoderListener(this);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deInitScreenSession() {
        YMFLog.info(this, "[Procedur]", "deInitScreenSession....");
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.setEncoderListener(null);
                this.mExternalVideoLiveSessionYCloud.stopAndRelease();
                this.mExternalVideoLiveSessionYCloud = null;
            }
        }
        return 0;
    }

    private int initOriginLiveSession(Object sharedContext) {
        YMFLog.info(this, "[Procedur]", "initOriginLiveSession...");
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.deInitOriginLiveSession();
        }
        this.mExternalVideoLiveSessionYCloud = new YMFExternalTextureSessionYCloud(YYVideoSDK.getInstance().getAppContext(), Constant.VideoStreamType.OriginData, sharedContext);
        this.mExternalVideoLiveSessionYCloud.initOriginDataFilter();
        this.mExternalVideoLiveSessionYCloud.setEncoderListener(this);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deInitOriginLiveSession() {
        YMFLog.info(this, "[Procedur]", "deInitOriginLiveSession....");
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.setEncoderListener(null);
                this.mExternalVideoLiveSessionYCloud.stopAndRelease();
                this.mExternalVideoLiveSessionYCloud = null;
            }
        }
        return 0;
    }

    public void setOriginFrameToEncode(byte[] data, int format, int width, int height, int rotation, long timestamp, int scaleMode) {
        if (this.mFrameCount++ % 300L == 0L) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setOriginFrameToEncode,format:" + format + ",width:" + width + ",height:" + height + ",rotation:" + rotation + ",timeStamp:" + timestamp + " scaleMode " + scaleMode);
        }
        if (!this.mOriginCaptureFlag || this.mOriginCaptureInputTexture || width > 1920 || height > 1920 || width * height <= 0) {
            YMFLog.warn(this, "[Api     ]", "setOriginFrameToEncode not startcapture or params error");
            return;
        }
        if (this.mOriginFrameLastTimeStamp > 0L && timestamp < this.mOriginFrameLastTimeStamp) {
            YMFLog.warn(this, "[Api     ]", "setOriginFrameToEncode pts error " + timestamp + " < " + this.mOriginFrameLastTimeStamp);
        }
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.mExternalVideoLiveSessionYCloud.setOriginFrameToEncode(data, format, width, height, rotation, timestamp, scaleMode);
        }
        this.mOriginFrameLastTimeStamp = timestamp;
    }

    public void setOriginTextureToEncode(int inputTexture, int textureTarget, int width, int height, int rotation, long timestamp, float[] transformer, int scaleMode) {
        if (this.mFrameCount++ % 300L == 0L) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("setOriginTextureToEncode,inputTexture :" + inputTexture + ",transformer:" + transformer + "," + timestamp + "," + rotation + " scaleMode " + scaleMode);
        }
        if (!this.mOriginCaptureFlag || !this.mOriginCaptureInputTexture || inputTexture < 0) {
            YMFLog.warn(this, "[Api     ]", "setOriginTextureToEncode not startcapture or params error");
            return;
        }
        if (this.mExternalVideoLiveSessionYCloud == null) {
            android.opengl.EGLContext eglContext = null;
            if (Build.VERSION.SDK_INT >= 17) {
                try {
                    eglContext = EGL14.eglGetCurrentContext();
                    if (eglContext == null) {
                        EGL10 mEgl = (EGL10)EGLContext.getEGL();
                        if (mEgl == null) {
                            YMFLog.error((Object)this, "[Api     ]", "EGL10 mEgl == null");
                        }
                        eglContext = mEgl.eglGetCurrentContext();
                    }
                }
                catch (Exception e) {
                    YMFLog.error((Object)this, "[Api     ]", "eglGetCurrentContext error " + e.toString());
                }
            } else {
                EGL10 mEgl = (EGL10)EGLContext.getEGL();
                if (mEgl == null) {
                    YMFLog.error((Object)this, "[Api     ]", "EGL10 mEgl == null");
                    return;
                }
                eglContext = mEgl.eglGetCurrentContext();
            }
            if (eglContext == null) {
                YMFLog.error((Object)this, "[Api     ]", "eglContext == null");
                return;
            }
            this.initOriginLiveSession(eglContext);
            if (this.mNeedCheckEncoderCfgFlag && this.mEncodedStreamFlag == Constant.EncodedStream.OriginStream) {
                this.realStartEncodeOrigin();
            }
        }
        if (this.mOriginFrameLastTimeStamp > 0L && timestamp < this.mOriginFrameLastTimeStamp) {
            YMFLog.warn(this, "[Api     ]", "setOriginFrameToEncode pts error " + timestamp + " < " + this.mOriginFrameLastTimeStamp);
        }
        if (this.mExternalVideoLiveSessionYCloud != null) {
            this.mExternalVideoLiveSessionYCloud.setOriginTextureToEncode(inputTexture, textureTarget, transformer, width, height, timestamp, rotation, scaleMode);
        }
        this.mOriginFrameLastTimeStamp = timestamp;
    }

    public void setOriginExternalFrameToEncode(YMFExternalFrame frame) {
        if (frame == null) {
            YMFLog.error((Object)this, "[Api     ]", "frame null");
            return;
        }
        if (frame.data != null && frame.data.length > 0) {
            this.setOriginFrameToEncode(frame.data, frame.format, frame.width, frame.height, frame.rotation, frame.timeStamp, frame.scaleMode);
        } else if (frame.textureID > 0 && frame.textureFormat > 0) {
            this.setOriginTextureToEncode(frame.textureID, frame.textureFormat, frame.width, frame.height, frame.rotation, frame.timeStamp, frame.transform, frame.scaleMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVideoLiveSession() {
        YMFLog.info(this, "[Procedur]", "initLiveSession...");
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mVideoLiveSessionYCloud != null) {
                this.deInitVideoLiveSession();
            }
            this.mVideoLiveSessionYCloud = new VideoLiveSessionYCloud(YYVideoSDK.getInstance().getAppContext(), Constant.VideoStreamType.Camera);
        }
        CameraInterface.getInstance().setCameraListener(this.mVideoLiveSessionYCloud);
        this.mVideoLiveSessionYCloud.setDeliverCallback(this);
        this.mVideoLiveSessionYCloud.setEncoderListener(this);
        this.mVideoLiveSessionYCloud.setCameraListener(this);
        this.mVideoLiveSessionYCloud.setFilterType(FilterType.BeautyFace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deInitVideoLiveSession() {
        YMFLog.info(this, "[Procedur]", "deInitLiveSession...");
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.setCameraListener(null);
                this.mVideoLiveSessionYCloud.setEncoderListener(null);
                this.mVideoLiveSessionYCloud.setPreviewSurfaceView(null);
                this.mVideoLiveSessionYCloud.reSetPreviewState();
                this.mVideoLiveSessionYCloud.stopAndRelease();
                this.mVideoLiveSessionYCloud = null;
            }
        }
    }

    private void updateLowStreamParams(List<YMFLowStreamEncoderConfig> lowStreamConfigs, boolean enable) {
        switch (this.mEncodedStreamFlag) {
            case CameraStream: {
                this.mVideoLiveSessionYCloud.setLowStreamEncoderConfigs(lowStreamConfigs, enable);
                break;
            }
            case ScreenStream: {
                this.mScreenLiveSessionYCloud.setLowStreamEncoderConfigs(lowStreamConfigs, enable);
                break;
            }
            case OriginStream: {
                this.mExternalVideoLiveSessionYCloud.setLowStreamEncoderConfigs(lowStreamConfigs, enable);
                break;
            }
        }
    }

    private void disassembleUploadParams() {
        if (this.mCameraPreviewConfig == null) {
            this.mCameraPreviewConfig = new CameraPreviewConfig();
        }
        if (this.mNeedCheckCameraCfgFlag) {
            this.mNeedRestartCaptureFlag = (this.mCameraPreviewConfig.mCaptureResolutionWidth != this.mUploadParams.captureResolutionWidth || this.mCameraPreviewConfig.mCaptureResolutionHeight != this.mUploadParams.captureResolutionHeight || this.mCameraPreviewConfig.mCaptureFrameRate < this.mUploadParams.encodeFrameRate + 2 || this.mCameraPreviewConfig.mCaptureOrientation != this.mUploadParams.screenOrientation) && !this.mCameraCapturePauseFlag;
        }
        this.mCameraPreviewConfig.mCaptureOrientation = this.mUploadParams.screenOrientation;
        this.mCameraPreviewConfig.mCameraPosition = UploadStreamStateParams.mCameraPosition;
        this.mCameraPreviewConfig.mCaptureResolutionWidth = this.mUploadParams.captureResolutionWidth;
        this.mCameraPreviewConfig.mCaptureResolutionHeight = this.mUploadParams.captureResolutionHeight;
        this.mCameraPreviewConfig.mCaptureFrameRate = this.mUploadParams.captureFrameRate;
        if (this.mVideoEncoderConfig == null) {
            this.mVideoEncoderConfig = new VideoEncoderConfig();
        }
        if (this.mNeedCheckEncoderCfgFlag) {
            this.mNeedRestartEncoderFlag = this.mVideoEncoderConfig.mEncodeWidth != this.mUploadParams.encodeResolutionWidth || this.mVideoEncoderConfig.mEncodeHeight != this.mUploadParams.encodeResolutionHeight || this.mVideoEncoderConfig.mEncodeType != this.mUploadParams.encodeType || this.mVideoEncoderConfig.mFrameRate != this.mUploadParams.encodeFrameRate;
        }
        this.mVideoEncoderConfig.mEncodeWidth = this.mUploadParams.encodeResolutionWidth;
        this.mVideoEncoderConfig.mEncodeHeight = this.mUploadParams.encodeResolutionHeight;
        this.mVideoEncoderConfig.mEncodeType = this.mUploadParams.encodeType;
        this.mVideoEncoderConfig.mEncodeParameter = this.mUploadParams.encoderParam;
        this.mVideoEncoderConfig.mFrameRate = this.mUploadParams.encodeFrameRate;
        this.mVideoEncoderConfig.mBitRate = this.mUploadParams.encodeBitrate;
        boolean newLowDelay = false;
        newLowDelay = this.mUploadParams.bLowLatency || this.mUploadParams.bWebSdkCompatibility || this.mUploadParams.bEnableLocalDualStreamMode;
        if (!this.mNeedRestartEncoderFlag && newLowDelay != this.mVideoEncoderConfig.mLowDelay) {
            YMFLiveUsrBehaviorStat.getInstance().notifyLowDelayFlagChange(this.mVideoEncoderConfig.mLowDelay, newLowDelay);
            this.mNeedLowDelayChangeFlag = true;
        }
        this.mVideoEncoderConfig.mLowDelay = newLowDelay;
    }

    private void resetUploadStreamParams() {
        UploadStreamStateParams.reset();
        YMFStreamSyncSourceManager.getInstance().deInit();
        this.mUploadParams = null;
        this.mVideoEncoderConfig = null;
        this.mCameraPreviewConfig = null;
        this.mCameraSurfaceView = null;
        this.mCameraCapturePauseFlag = false;
        this.mNeedCheckCameraCfgFlag = false;
        this.mNeedCheckEncoderCfgFlag = false;
        this.mNeedLowDelayChangeFlag = false;
        this.mNeedRestartCaptureFlag = false;
        this.mNeedRestartEncoderFlag = false;
        this.mEncodedStreamFlag = Constant.EncodedStream.NoneStream;
        this.mNotifyResolutioWidth = 0;
        this.mNotifyResolutioHeight = 0;
        this.mNotifyLowStreamResolutioWidth = 0;
        this.mNotifyLowStreamResolutioHeight = 0;
        this.mOnlyRestartCapture = false;
        this.mOriginCaptureFlag = false;
        this.mScreenCaptureFlag = false;
        this.mUserForceMode = false;
    }

    private void setEncoderStatistic(YMFEncoderStatisticInfo info) {
        if (this.mEncoderStatInfoList == null) {
            this.mEncoderStatInfoList = new ArrayList<YMFEncoderStatisticInfo>();
            this.mEncoderStatInfoList.add(new YMFEncoderStatisticInfo(0));
            this.mEncoderStatInfoList.add(new YMFEncoderStatisticInfo(1));
        }
        if (info != null && this.mEncoderStatInfoList.size() >= 2) {
            if (info.mStreamId == 0) {
                this.mEncoderStatInfoList.get(0).assign(info);
            } else {
                this.mEncoderStatInfoList.get(1).assign(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncodeStat(YMFEncoderStatisticInfo info) {
        Object object = this.mDataAsyncLock;
        synchronized (object) {
            this.setEncoderStatistic(info);
        }
        if (this.mIEncoderStatisticListener != null) {
            this.mIEncoderStatisticListener.onEncoderStatistics(info);
        }
    }

    @Override
    public void onEncodeResolution(int streamId, int width, int height) {
        if (this.mIPublishListener != null) {
            if (streamId == 0 && (width != this.mNotifyResolutioWidth || height != this.mNotifyResolutioHeight)) {
                this.mIPublishListener.onUpdateVideoSizeChanged(0L, width, height);
                this.mNotifyResolutioWidth = width;
                this.mNotifyResolutioHeight = height;
            } else if (streamId == 1 && (width != this.mNotifyLowStreamResolutioWidth || height != this.mNotifyLowStreamResolutioHeight)) {
                this.mIPublishListener.onUpdateVideoSizeChanged(1L, width, height);
                this.mNotifyLowStreamResolutioWidth = width;
                this.mNotifyLowStreamResolutioHeight = height;
            }
        }
    }

    @Override
    public void onEncodeFirstFrame() {
        if (this.mIPublishListener != null) {
            this.mIPublishListener.onVideoAnchorStatus(Constant.AnchorStatus.AnchorStatus_Encoding);
        }
    }

    @Override
    public void onRenderFirstFrame() {
        if (this.mIPublishListener != null && this.mAnchorStatusPreviewingCallback) {
            this.mAnchorStatusPreviewingCallback = false;
            this.mIPublishListener.onVideoAnchorStatus(Constant.AnchorStatus.AnchorStatus_Previewing);
        }
    }

    @Override
    public void onEncodeFrameData(YMFVideoEncodeFrame videoEncodeFrame) {
        if (this.mIPublishListener != null) {
            YMFStreamSyncSourceManager.getInstance().getExtraData(videoEncodeFrame);
            this.mIPublishListener.onEncodeFrameData(videoEncodeFrame);
        }
    }

    @Override
    public void onEncodeEncParam(String param) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHardEncoderError() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLiveUsrBehaviorStat.getInstance().notifyCallApi("onHardEncoderError");
            YMFLog.warn(this, "[Encoder ]", "onEncoderSwitch change to softEncoder");
            UploadStreamStateParams.mDisableHardEncoder.set(true);
        }
    }

    @Override
    public void onEncoderSwitch() {
    }

    @Override
    public void onWaterMarkSizeChange(int w, int h) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onVideoFrameProcessTime(float maxTime, float avgTime) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mIPublishListener != null) {
                this.mIPublishListener.onVideoFrameProcessTime(maxTime, avgTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAbroadNetWorkStrategy(boolean flag) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            UploadStreamStateParams.mNetWorkStrategy = flag;
            YMFLog.info(this, "[Encoder ]", "setAbroadNetWorkStrategy " + flag);
            if (this.mVideoLiveSessionYCloud != null) {
                this.mVideoLiveSessionYCloud.setAbroadNetWorkStrategy(flag);
            }
            if (this.mExternalVideoLiveSessionYCloud != null) {
                this.mExternalVideoLiveSessionYCloud.setAbroadNetWorkStrategy(flag);
            }
            if (this.mScreenLiveSessionYCloud != null) {
                this.mScreenLiveSessionYCloud.setAbroadNetWorkStrategy(flag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoUpCommonConfig(HashMap<String, String> config) {
        try {
            YMFLiveAPI yMFLiveAPI = this;
            synchronized (yMFLiveAPI) {
                if (!this.mUserForceMode) {
                    String yuvCapture = config.get("yuvCapture") != null ? config.get("yuvCapture") : "0";
                    this.setVideoCaptureMode(Integer.parseInt(yuvCapture));
                    String previewMode = config.get("canvasOrGl") != null ? config.get("canvasOrGl") : "0";
                    this.setVideoPreviewMode(Integer.parseInt(previewMode));
                    String disableBeauty = config.get("disableBeauty") != null ? config.get("disableBeauty") : "0";
                    this.setVideoDisableBeautyMode(Integer.parseInt(disableBeauty));
                    String encoderInput = config.get("encoderInput") != null ? config.get("encoderInput") : "0";
                    this.setVideoEncoderInputMode(Integer.parseInt(encoderInput));
                }
                String captureFpsMode = config.get("captureFpsMode") != null ? config.get("captureFpsMode") : "0";
                this.setCaptureFpsMode(Integer.parseInt(captureFpsMode));
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Api     ]", "setVideoUpCommonConfig:" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setVideoCommonConfigMode(int mode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Api     ]", "setVideoCommonConfigMode mode=" + mode);
            if (this.mVideoLiveSessionYCloud != null) {
                YMFLog.error((Object)this, "[Api     ]", "setVideoCommonConfigMode is invalid,mVideoLiveSessionYCloud is not null ,mode = " + mode);
                return -1;
            }
            switch (mode) {
                default: {
                    this.setYuvTextureMode(false);
                    this.setVideoCaptureMode(Constant.CaptureMode.TextureMode.ordinal());
                    this.setVideoPreviewMode(Constant.PreviewMode.TextureMode.ordinal());
                    this.setVideoDisableBeautyMode(0);
                    this.setVideoEncoderInputMode(Constant.EncoderInputMode.SURFACE.ordinal());
                    break;
                }
                case 1: {
                    this.setYuvTextureMode(false);
                    this.setVideoCaptureMode(Constant.CaptureMode.YuvMode.ordinal());
                    this.setVideoPreviewMode(Constant.PreviewMode.CanvasMode.ordinal());
                    this.setVideoDisableBeautyMode(1);
                    this.setVideoEncoderInputMode(Constant.EncoderInputMode.BUFFER.ordinal());
                    break;
                }
                case 2: {
                    this.setYuvTextureMode(true);
                    this.setVideoCaptureMode(Constant.CaptureMode.TextureMode.ordinal());
                    this.setVideoPreviewMode(Constant.PreviewMode.TextureMode.ordinal());
                    this.setVideoDisableBeautyMode(0);
                    this.setVideoEncoderInputMode(Constant.EncoderInputMode.SURFACE.ordinal());
                }
            }
            this.mUserForceMode = true;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setYuvCanvasMode(boolean flag) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            int ret = 0;
            YMFLiveAPI yMFLiveAPI2 = this;
            synchronized (yMFLiveAPI2) {
                if (this.mVideoLiveSessionYCloud != null) {
                    YMFLog.info(this, "[Api     ]", "mVideoLiveSessionYCloud not null:" + flag);
                    return -1;
                }
                YMFLog.info(this, "[Api     ]", "setYuvCanvasMode:" + flag);
                if (flag) {
                    this.setYuvTextureMode(false);
                    this.setVideoCaptureMode(Constant.CaptureMode.YuvMode.ordinal());
                    this.setVideoPreviewMode(Constant.PreviewMode.CanvasMode.ordinal());
                    this.setVideoDisableBeautyMode(1);
                    this.setVideoEncoderInputMode(Constant.EncoderInputMode.BUFFER.ordinal());
                } else {
                    this.setYuvTextureMode(false);
                    this.setVideoCaptureMode(Constant.CaptureMode.TextureMode.ordinal());
                    this.setVideoPreviewMode(Constant.PreviewMode.TextureMode.ordinal());
                    this.setVideoDisableBeautyMode(0);
                    this.setVideoEncoderInputMode(Constant.EncoderInputMode.SURFACE.ordinal());
                }
                this.mUserForceMode = true;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCaptureFpsMode(int mode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Api     ]", "setCaptureFpsMode:" + mode);
            UploadStreamStateParams.mCaptureFpsMode = mode == Constant.CaptureFpsMode.FullSpeed.ordinal() ? Constant.CaptureFpsMode.FullSpeed : Constant.CaptureFpsMode.AlignEncoder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setYuvTextureMode(boolean isYuvTextureMode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Api     ]", "setYuvTextureMode:" + isYuvTextureMode);
            UploadStreamStateParams.mYuvTextureMode = isYuvTextureMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVideoCaptureMode(int mode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Api     ]", "setVideoCaptureMode:" + mode);
            UploadStreamStateParams.mCaptureMode = mode == Constant.CaptureMode.YuvMode.ordinal() ? Constant.CaptureMode.YuvMode : Constant.CaptureMode.TextureMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVideoPreviewMode(int mode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Api     ]", "setVideoPreviewMode:" + mode);
            UploadStreamStateParams.mPreviewMode = mode == Constant.PreviewMode.GlSurfaceMode.ordinal() ? Constant.PreviewMode.GlSurfaceMode : (mode == Constant.PreviewMode.CanvasMode.ordinal() ? Constant.PreviewMode.CanvasMode : Constant.PreviewMode.TextureMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVideoEncoderInputMode(int mode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Api     ]", "setVideoEncoderInputMode:" + mode);
            UploadStreamStateParams.mEncoderInputMode = mode == Constant.EncoderInputMode.BUFFER.ordinal() ? Constant.EncoderInputMode.BUFFER : Constant.EncoderInputMode.SURFACE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVideoDisableBeautyMode(int mode) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            YMFLog.info(this, "[Api     ]", "setVideoDisableBeautyMode:" + mode);
            UploadStreamStateParams.mDisableBeauty = mode == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constant.PreviewMode getPreViewType() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mVideoLiveSessionYCloud == null) {
                this.initVideoLiveSession();
            }
            if (this.mVideoLiveSessionYCloud.mFilterContext.isUseCanvasSurfaceView()) {
                return Constant.PreviewMode.CanvasMode;
            }
            if (this.mVideoLiveSessionYCloud.mFilterContext.isUseGLSurfaceView()) {
                return Constant.PreviewMode.GlSurfaceMode;
            }
            return Constant.PreviewMode.TextureMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCameraOpen() {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            return YYCamera.getInstance().isCameraOpen();
        }
    }

    public boolean isCameraZoomSupported() {
        return YYCamera.getInstance().isZoomSupport();
    }

    public float getCameraMaxZoomFactor() {
        if (!YYCamera.getInstance().isZoomSupport()) {
            YMFLog.error((Object)TAG, "[CCapture]", "getCameraMaxZoomFactor not support.");
            return 1.0f;
        }
        return YYCamera.getInstance().getMaxZoom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCameraZoomFactor(float zoomFactor) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (!YYCamera.getInstance().isZoomSupport()) {
                YMFLog.error((Object)TAG, "[CCapture]", "setCameraZoomFactor not support.");
                return -1;
            }
            float maxZoom = YYCamera.getInstance().getMaxZoom();
            float targetZoom = zoomFactor;
            if (zoomFactor > maxZoom) {
                targetZoom = maxZoom;
            } else if ((double)zoomFactor < 1.0) {
                targetZoom = 1.0f;
            }
            float zoom = YYCamera.getInstance().setZoom(targetZoom);
            if (this.mCameraPreviewConfig != null) {
                this.mCameraPreviewConfig.mZoomFactor = zoom;
            }
            return (int)zoom;
        }
    }

    public boolean isCameraTorchSupported() {
        return YYCamera.getInstance().isTorchSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCameraTorchOn(boolean isOn) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            if (this.mCameraPreviewConfig != null) {
                this.mCameraPreviewConfig.mIsTorchOn = isOn;
            }
            return YYCamera.getInstance().setCameraTorchOn(isOn);
        }
    }

    public boolean isCameraManualFocusPositionSupported() {
        return YYCamera.getInstance().isCameraManualFocusPositionSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCameraFocusPosition(float posX, float posY) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            return YYCamera.getInstance().setCameraFocusPosition(posX, posY);
        }
    }

    public boolean isCameraManualExposurePositionSupported() {
        return YYCamera.getInstance().isCameraManualExposurePositionSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCameraExposurePosition(float posX, float posY) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            return YYCamera.getInstance().setCameraExposurePosition(posX, posY);
        }
    }

    public boolean isCameraAutoFocusFaceModeSupported() {
        return YYCamera.getInstance().isCameraAutoFocusFaceModeSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCameraAutoFocusFaceModeEnabled(boolean enable) {
        YMFLiveAPI yMFLiveAPI = this;
        synchronized (yMFLiveAPI) {
            return YYCamera.getInstance().setCameraAutoFocusFaceModeEnabled(enable);
        }
    }

    public boolean isFrontCamera() {
        return YYCamera.getInstance().isCameraFront();
    }

    public int getCameraOrientation() {
        return YYCamera.getInstance().getCameraOrientation();
    }

    public int setCaptureReplaceImage(Bitmap bitmap) {
        this.mCaptureReplaceBitmap = bitmap;
        if (this.mExternalVideoLiveSessionYCloud != null) {
            return -4002;
        }
        if (this.mVideoLiveSessionYCloud != null) {
            this.mVideoLiveSessionYCloud.setCaptureReplaceImage(this.mCaptureReplaceBitmap);
        }
        if (this.mScreenLiveSessionYCloud != null) {
            this.mScreenLiveSessionYCloud.setCaptureReplaceImage(this.mCaptureReplaceBitmap);
        }
        return 0;
    }

    public Bitmap captureLocalScreenShot() {
        long startTime = System.currentTimeMillis();
        this.mLocalBitmap = null;
        if (this.mVideoLiveSessionYCloud != null && this.mCameraSurfaceView != null && this.mCameraOpened) {
            final CountDownLatch barrier = new CountDownLatch(1);
            this.mVideoLiveSessionYCloud.takeScreenShot(new ScreenShotCallback(){

                @Override
                public void onTaked(Bitmap bitmap) {
                    YMFLiveAPI.this.mLocalBitmap = bitmap;
                    barrier.countDown();
                }

                @Override
                public void onError(Throwable throwable) {
                    YMFLog.error((Object)this, "[Preview ]", "Screenshot onError!");
                    barrier.countDown();
                }
            });
            try {
                barrier.await(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                YMFLog.error((Object)this, "[Preview ]", "captureLocalScreenShot barrier.await exception:" + e.toString());
            }
        }
        long detalTime = System.currentTimeMillis() - startTime;
        YMFLog.info(TAG, "[Preview ]", "captureLocalScreenShot end,bitmap is null?" + (this.mLocalBitmap == null ? "y" : "n") + " detal time = " + detalTime);
        return this.mLocalBitmap;
    }

    public void notifyChangeVideoSourceState() {
        YMFLog.info(this, "[Api     ]", " notifyChangeVideoSourceState.. ");
        YMFStreamSyncSourceManager.getInstance().changeVideoSource();
    }

    @Override
    public void notifyCameraPreviewParameter(int width, int height, int facing, CameraInterface.CameraResolutionMode resMode) {
    }

    @Override
    public void notifyCameraOpenSuccess() {
    }

    @Override
    public void notifyCameraOpenFail(String reason) {
    }

    @Override
    public void onDualOpen(boolean flag) {
    }

    @Override
    public void onDualPictureSwitch() {
    }

    @Override
    public void reSetEncodingState() {
    }

    @Override
    public void onCameraFocusAreaChanged(Rect rect) {
        if (this.mCameraListener != null) {
            this.mCameraListener.onCameraFocusAreaChanged(rect);
        }
    }

    @Override
    public void onCameraExposureAreaChanged(Rect rect) {
        if (this.mCameraListener != null) {
            this.mCameraListener.onCameraExposureAreaChanged(rect);
        }
    }

    public static int getSupportH265EncodeProperty() {
        return YYVideoCodec.getSupportH265Property();
    }

    public static enum VideoPublishInfoEnum {
        FRAME,
        BITRATE,
        RESOLUTION,
        DYNAMIC_ENC_FRAME_RATE,
        PREVIEW_FRAME_RATE,
        ENCODETYPE,
        CAPTUREMODE,
        PRRVIEWTYPE,
        CAPTUREFPSMODE,
        CAPTUREFPS,
        SETCAPTUREFPS,
        YUVTEXTUREMODE;

    }
}

