/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.ExternalInterface;
import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.IMediaCodecUpload;
import com.yy.mediaframework.VideoRenderPosition;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.api.YMFEncoderStatisticInfo;
import com.yy.mediaframework.api.YMFVideoEncodeFrame;
import com.yy.mediaframework.background.Background;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.base.YMFLowStreamEncoderConfig;
import com.yy.mediaframework.base.YYUserLiveConfig;
import com.yy.mediaframework.filters.ClipFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.OriginDataEntryFilter;
import com.yy.mediaframework.filters.VideoEncoderGroupFilter;
import com.yy.mediaframework.filters.VideoEndPointFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.inteligence.dynamictexture.IDynamicTexture;
import com.yy.mediaframework.model.DecodeVideoConfig;
import com.yy.mediaframework.model.DecodeVideoSample;
import com.yy.mediaframework.model.ExternalDecodeInfo;
import com.yy.mediaframework.model.ExternalYYMediaSample;
import com.yy.mediaframework.screenshot.ScreenShotCallback;
import com.yy.mediaframework.stat.UploadStatManager;
import com.yy.mediaframework.stat.VideoDataStatUtil;
import com.yy.mediaframework.utils.TimeUtil;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class YMFExternalTextureSessionYCloud
implements IEncoderListener,
ILiveSession,
IMediaCodecUpload {
    private static final String TAG = "[VideoLiveSessionYCloud]";
    public ClipFilter mCliperFilter = null;
    public VideoEncoderGroupFilter mEncoderGroupFilter = null;
    public VideoLiveFilterContext mFilterContext = null;
    public VideoEndPointFilter mEndPointFilter = null;
    private WeakReference<IEncoderListener> mEncoderListener = new WeakReference<Object>(null);
    private AtomicBoolean mHardwareEncoderAvailable = new AtomicBoolean(true);
    private VideoEncoderConfig mVideoEncoderConfig = new VideoEncoderConfig();
    private Object mSurfaceSync = new Object();
    private float mWaterMakeW = 0.0f;
    private float mWaterMakeH = 0.0f;
    private float mWaterMakeX = 0.0f;
    private float mWaterMakeY = 0.0f;
    private Bitmap mWaterMarkBitmap;
    private OriginDataEntryFilter mOriginDataFilter = null;
    private AtomicBoolean mOriginInputTexture = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YMFExternalTextureSessionYCloud(Context context, Constant.VideoStreamType type, Object sharedContext) {
        Object object = this.mSurfaceSync;
        synchronized (object) {
            if (sharedContext == null) {
                this.mOriginInputTexture.set(false);
                this.mFilterContext = new VideoLiveFilterContext(context, type);
            } else {
                this.mOriginInputTexture.set(true);
                this.mFilterContext = new VideoLiveFilterContext(context, type, sharedContext);
            }
            this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_NORMAL);
            this.mFilterContext.setAndroidContext(context);
            this.mCliperFilter = new ClipFilter();
            this.mEncoderGroupFilter = new VideoEncoderGroupFilter(this.mFilterContext, this);
            this.mEndPointFilter = new VideoEndPointFilter(this.mFilterContext);
            this.mEncoderGroupFilter.setEncoderListener(this);
        }
        this.mFilterContext.getGlManager().registerFilter(this.mCliperFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEncoderGroupFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEndPointFilter);
        YMFLog.info(this, "[Procedur]", "videoLiveSession #### use " + this.mFilterContext.getVideoFlowInfomation() + " isEmulator:" + YYVideoSDK.getInstance().mIsEmulator);
    }

    @Override
    public void stopAndRelease() {
        YMFLog.info(this, "[Procedur]", "VideoLiveSession stopAndRelease begin");
        UploadStatManager.getInstance().setIGetCurrentCameraStatInfo(null);
        UploadStatManager.getInstance().setIGetImageFilterInfo(null);
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            if (this.mFilterContext.getScreenShot() != null) {
                this.mFilterContext.getScreenShot().deInit();
            }
            if (this.mFilterContext.getDynamicTexture() != null) {
                this.mFilterContext.getDynamicTexture().onRelease();
                this.mFilterContext.setDynamicTexture(null);
            }
            if (this.mFilterContext.getWaterMarkTexture() != null) {
                this.mFilterContext.getWaterMarkTexture().destroy();
                this.mFilterContext.setWaterMarkTexture(null);
            }
            if (this.mFilterContext.getBackgroundTexture() != null) {
                this.mFilterContext.getBackgroundTexture().destroy();
                this.mFilterContext.setBackgroundTexture(null);
            }
            UploadStatManager.getInstance().stopStat();
            this.mFilterContext.getGLManager().quit();
        } else {
            final CountDownLatch barrier = new CountDownLatch(1);
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    if (YMFExternalTextureSessionYCloud.this.mFilterContext.getWaterMarkTexture() != null) {
                        YMFExternalTextureSessionYCloud.this.mFilterContext.getWaterMarkTexture().destroy();
                        YMFExternalTextureSessionYCloud.this.mFilterContext.setWaterMarkTexture(null);
                    }
                    if (YMFExternalTextureSessionYCloud.this.mFilterContext.getBackgroundTexture() != null) {
                        YMFExternalTextureSessionYCloud.this.mFilterContext.getBackgroundTexture().destroy();
                        YMFExternalTextureSessionYCloud.this.mFilterContext.setBackgroundTexture(null);
                    }
                    UploadStatManager.getInstance().stopStat();
                    YMFExternalTextureSessionYCloud.this.mFilterContext.getGLManager().quit();
                    barrier.countDown();
                }
            });
            try {
                barrier.await(1500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                YMFLog.error((Object)this, "[Preview ]", "stopAndRelease timeout exception:" + e.toString());
            }
        }
        YMFLog.info(this, "[Procedur]", "VideoLiveSession stopAndRelease done");
        VideoDataStatUtil.clearPtsTimes(1001L);
    }

    public void setDeltaYYPtsMillions(final long deltaPtsDts) {
        YMFLog.info(this, "[Encoder ]", "setDeltaYYPtsMillions:" + deltaPtsDts);
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            YYVideoSDK.getInstance().setDeltaYYPtsMillions(deltaPtsDts);
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    YYVideoSDK.getInstance().setDeltaYYPtsMillions(deltaPtsDts);
                }
            });
        }
    }

    public boolean getExternalType() {
        return this.mOriginInputTexture.get();
    }

    @Override
    public void setWaterMark(final WaterMark waterMark) {
        YMFLog.info(this, "[Beauty  ]", "setWaterMark, waterMark==null? " + (waterMark == null ? "y" : "n"));
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            this.mFilterContext.setWaterMarkTexture(waterMark);
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFExternalTextureSessionYCloud.this.mFilterContext.setWaterMarkTexture(waterMark);
                }
            });
        }
    }

    @Override
    public void startEncoder() {
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            YYUserLiveConfig userLiveConfig = this.mFilterContext.getUserLiveConfig();
            if (!this.isHardwareEncoderAvailable()) {
                this.mFilterContext.mVideoEncoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
            }
            if (this.mEncoderGroupFilter.isEnable()) {
                YMFLog.info(this, "[Encoder ]", "encoder is started already!!");
            } else {
                try {
                    boolean res = this.mEncoderGroupFilter.startEncode(this.mFilterContext.getVideoEncoderConfig());
                    if (res) {
                        UploadStatManager.getInstance().startStat();
                    }
                }
                catch (Exception e) {
                    YMFLog.error((Object)this, "[Encoder ]", "startEncode exception:" + e);
                }
            }
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YYUserLiveConfig userLiveConfig = YMFExternalTextureSessionYCloud.this.mFilterContext.getUserLiveConfig();
                    if (!YMFExternalTextureSessionYCloud.this.isHardwareEncoderAvailable()) {
                        YMFExternalTextureSessionYCloud.this.mFilterContext.mVideoEncoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
                    }
                    if (YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                        YMFLog.info(this, "[Encoder ]", "encoder is started already!!");
                    } else {
                        try {
                            boolean res = YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.startEncode(YMFExternalTextureSessionYCloud.this.mFilterContext.getVideoEncoderConfig());
                            if (res) {
                                UploadStatManager.getInstance().startStat();
                            }
                        }
                        catch (Exception e) {
                            YMFLog.error((Object)this, "[Encoder ]", "startEncode exception:" + e);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void stopEncoder() {
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            UploadStatManager.getInstance().stopStat();
            if (this.mEncoderGroupFilter.isEnable()) {
                this.mEncoderGroupFilter.stopEncode();
            }
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    UploadStatManager.getInstance().stopStat();
                    if (YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                        YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.stopEncode();
                    }
                }
            });
        }
    }

    @Override
    public void setWaterMark(Bitmap bitmap, int offsetX, int offsetY) {
        if (this.mVideoEncoderConfig == null) {
            return;
        }
        YMFLog.info(this, "[Beauty  ]", "setWaterMark, bitmap==null? " + (bitmap == null ? "y" : "n") + "<" + offsetX + "." + offsetY + ">");
        this.mWaterMarkBitmap = bitmap;
        if (bitmap == null) {
            this.setWaterMark(null);
            return;
        }
        if (bitmap != null && bitmap != null && (bitmap.getWidth() + offsetX > this.mVideoEncoderConfig.mEncodeWidth || bitmap.getHeight() + offsetY > this.mVideoEncoderConfig.mEncodeHeight)) {
            YMFLog.error((Object)this, "[Beauty  ]", "setWaterMark error:" + bitmap.getWidth() + "(bitmapWigth)+" + offsetX + "(offestX)>" + this.mVideoEncoderConfig.mEncodeWidth + "(encodeWidth) OR " + bitmap.getHeight() + "(bitmapHeight)+" + offsetY + "(offsetY)>" + this.mVideoEncoderConfig.mEncodeHeight + "(encodeHeight)");
            this.setWaterMark(null);
            return;
        }
        this.mWaterMakeX = (float)offsetX / (float)this.mVideoEncoderConfig.mEncodeWidth;
        this.mWaterMakeY = (float)offsetY / (float)this.mVideoEncoderConfig.mEncodeHeight;
        this.mWaterMakeW = (float)bitmap.getWidth() / (float)this.mVideoEncoderConfig.mEncodeWidth;
        this.mWaterMakeH = (float)bitmap.getHeight() / (float)this.mVideoEncoderConfig.mEncodeHeight;
        int X = (int)((float)this.mVideoEncoderConfig.mEncodeWidth * this.mWaterMakeX);
        int Y = (int)((float)this.mVideoEncoderConfig.mEncodeHeight * this.mWaterMakeY);
        int W = (int)((float)this.mVideoEncoderConfig.mEncodeWidth * this.mWaterMakeW);
        int H = (int)((float)this.mVideoEncoderConfig.mEncodeHeight * this.mWaterMakeH);
        float scaleWidth = (float)W / (float)this.mWaterMarkBitmap.getWidth();
        float scaleHeight = (float)H / (float)this.mWaterMarkBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBM = Bitmap.createBitmap((Bitmap)this.mWaterMarkBitmap, (int)0, (int)0, (int)this.mWaterMarkBitmap.getWidth(), (int)this.mWaterMarkBitmap.getHeight(), (Matrix)matrix, (boolean)false);
        WaterMark waterMark = new WaterMark(newBM, this.mVideoEncoderConfig.mEncodeWidth, this.mVideoEncoderConfig.mEncodeHeight, X, Y, WaterMark.Align.LeftTop);
        this.setWaterMark(waterMark);
    }

    @Override
    public void setBackground(final Background background) {
        YMFLog.info(this, "[Preview ]", "setBackground, background ==null? " + (background == null ? "y" : "n"));
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            this.mFilterContext.setBackgroundTexture(background);
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFExternalTextureSessionYCloud.this.mFilterContext.setBackgroundTexture(background);
                }
            });
        }
    }

    @Override
    public void setDynamicTexture(final IDynamicTexture dynamicTexture) {
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            YMFLog.info(this, "[Beauty  ]", "setDynamicTexture");
            this.mFilterContext.setDynamicTexture(dynamicTexture);
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFLog.info(this, "[Beauty  ]", "setDynamicTexture");
                    YMFExternalTextureSessionYCloud.this.mFilterContext.setDynamicTexture(dynamicTexture);
                }
            });
        }
    }

    @Override
    public void setNetworkBitrateSuggest(final int bitrate) {
        YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitrate);
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            this.mEncoderGroupFilter.setNetworkBitrateSuggest(bitrate);
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.setNetworkBitrateSuggest(bitrate);
                }
            });
        }
    }

    @Override
    public void setLowStreamEncoderConfigs(final List<YMFLowStreamEncoderConfig> lowStreamConfigs, final boolean enable) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                YMFExternalTextureSessionYCloud.this.mFilterContext.setLowStreamEncoderConfigs(lowStreamConfigs);
                YMFExternalTextureSessionYCloud.this.mFilterContext.enableLowStreamEncoder(enable);
            }
        });
    }

    @Override
    public void setResolutionModifyConfigs(final List<ResolutionModifyConfig> configs, final int intervalSecs) {
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            if (YYVideoSDK.getInstance().mIsEmulator) {
                for (ResolutionModifyConfig config : configs) {
                    config.videoEncoderType = VideoEncoderType.SOFT_ENCODER_X264;
                    config.encoderParams = "";
                }
            }
            this.mEncoderGroupFilter.setResolutionModifyConfigs(configs, intervalSecs);
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    if (YYVideoSDK.getInstance().mIsEmulator) {
                        for (ResolutionModifyConfig config : configs) {
                            config.videoEncoderType = VideoEncoderType.SOFT_ENCODER_X264;
                            config.encoderParams = "";
                        }
                    }
                    YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.setResolutionModifyConfigs(configs, intervalSecs);
                }
            });
        }
    }

    @Override
    public void setEncoderListener(final IEncoderListener listener) {
        if (listener == null) {
            YMFLog.info(this, "[Encoder ]", "setEncoderlistener:" + listener);
            this.mEncoderListener = new WeakReference<IEncoderListener>(listener);
            if (listener != null) {
                listener.onEncodeEncParam(this.mFilterContext.getEncodeParamTipsMgr().getParam());
            }
        } else if (this.mFilterContext.getGLManager().checkSameThread()) {
            YMFLog.info(this, "[Encoder ]", "setEncoderlistener:" + listener);
            this.mEncoderListener = new WeakReference<IEncoderListener>(listener);
            if (listener != null) {
                listener.onEncodeEncParam(this.mFilterContext.getEncodeParamTipsMgr().getParam());
            }
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFLog.info(this, "[Encoder ]", "setEncoderlistener:" + listener);
                    YMFExternalTextureSessionYCloud.this.mEncoderListener = new WeakReference<IEncoderListener>(listener);
                    if (listener != null) {
                        listener.onEncodeEncParam(YMFExternalTextureSessionYCloud.this.mFilterContext.getEncodeParamTipsMgr().getParam());
                    }
                }
            });
        }
    }

    public void assignEncoderConfig(VideoEncoderConfig config) {
        YMFLog.info(this, "[Encoder ]", "setEncoderconfig:" + config.toString());
        this.mVideoEncoderConfig = config;
        if (YYVideoSDK.getInstance().mIsEmulator) {
            this.mVideoEncoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
        }
        if (!this.mFilterContext.getGLManager().checkSameThread()) {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFExternalTextureSessionYCloud.this.mFilterContext.getVideoEncoderConfig().assign(YMFExternalTextureSessionYCloud.this.mVideoEncoderConfig);
                    if (YMFExternalTextureSessionYCloud.this.mFilterContext.mChangeEncoderFlag.get() && YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                        YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.stopEncode();
                        YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.startEncode(YMFExternalTextureSessionYCloud.this.mVideoEncoderConfig);
                    }
                }
            });
        } else {
            this.mFilterContext.getVideoEncoderConfig().assign(this.mVideoEncoderConfig);
            if (this.mFilterContext.mChangeEncoderFlag.get() && this.mEncoderGroupFilter.isEnable()) {
                this.mEncoderGroupFilter.stopEncode();
                this.mEncoderGroupFilter.startEncode(this.mVideoEncoderConfig);
            }
        }
    }

    @Override
    public void setEncoderConfig(final VideoEncoderConfig config) {
        YMFLog.info(this, "[Encoder ]", "setEncoderconfig:" + config.toString());
        this.mVideoEncoderConfig = config;
        if (this.mFilterContext == null) {
            YMFLog.info(this, "[Encoder ]", "setEncoderconfig: only save cfg" + config.toString());
            return;
        }
        if (YYVideoSDK.getInstance().mIsEmulator) {
            this.mVideoEncoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
        }
        if (!this.mFilterContext.getGLManager().checkSameThread()) {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFExternalTextureSessionYCloud.this.mFilterContext.getVideoEncoderConfig().assign(YMFExternalTextureSessionYCloud.this.mVideoEncoderConfig);
                    YMFLog.info(this, "[Encoder ]", "setEncoderConfig:" + YMFExternalTextureSessionYCloud.this.mFilterContext.getVideoEncoderConfig().toString());
                    YMFExternalTextureSessionYCloud.this.mFilterContext.getDefaultVideoEncoderConfig().assign(YMFExternalTextureSessionYCloud.this.mVideoEncoderConfig);
                    YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.init();
                    if (YMFExternalTextureSessionYCloud.this.mFilterContext.mChangeEncoderFlag.get() && YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                        YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.stopEncode();
                        YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.startEncode(YMFExternalTextureSessionYCloud.this.mVideoEncoderConfig);
                    }
                    UploadStatManager.getInstance().putSettingBitRate(config.getBitRate());
                    UploadStatManager.getInstance().putSettingDPI(config.getRealDPI());
                    UploadStatManager.getInstance().putSettingFrameRate(config.getFrameRate());
                }
            });
        } else {
            this.mFilterContext.getVideoEncoderConfig().assign(this.mVideoEncoderConfig);
            YMFLog.info(this, "[Encoder ]", "setEncoderConfig:" + this.mFilterContext.getVideoEncoderConfig().toString());
            this.mFilterContext.getDefaultVideoEncoderConfig().assign(this.mVideoEncoderConfig);
            this.mEncoderGroupFilter.init();
            if (this.mFilterContext.mChangeEncoderFlag.get() && this.mEncoderGroupFilter.isEnable()) {
                this.mEncoderGroupFilter.stopEncode();
                this.mEncoderGroupFilter.startEncode(this.mVideoEncoderConfig);
            }
            UploadStatManager.getInstance().putSettingBitRate(config.getBitRate());
            UploadStatManager.getInstance().putSettingDPI(config.getRealDPI());
            UploadStatManager.getInstance().putSettingFrameRate(config.getFrameRate());
        }
    }

    @Override
    public void setLowDelayMode(final boolean enable) {
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            this.mFilterContext.getVideoEncoderConfig().mLowDelay = enable;
            YMFLog.info(this, "[Encoder ]", "setLowDelayMode:" + enable + " config:" + this.mFilterContext.getVideoEncoderConfig().toString());
            if (this.mFilterContext.mChangeEncoderFlag.get() && this.mEncoderGroupFilter.isEnable()) {
                this.mEncoderGroupFilter.stopEncode();
                this.mEncoderGroupFilter.startEncode(this.mVideoEncoderConfig);
            }
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFExternalTextureSessionYCloud.this.mFilterContext.getVideoEncoderConfig().mLowDelay = enable;
                    YMFLog.info(this, "[Encoder ]", "setLowDelayMode:" + enable + " config:" + YMFExternalTextureSessionYCloud.this.mFilterContext.getVideoEncoderConfig().toString());
                    if (YMFExternalTextureSessionYCloud.this.mFilterContext.mChangeEncoderFlag.get() && YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                        YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.stopEncode();
                        YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.startEncode(YMFExternalTextureSessionYCloud.this.mVideoEncoderConfig);
                    }
                }
            });
        }
    }

    @Override
    public void adjustEncoderBitrate(int bitRate) {
        if (this.mEncoderGroupFilter != null) {
            YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitRate);
            this.mEncoderGroupFilter.adjustBitRate((bitRate + 999) / 1000);
        }
    }

    @Override
    public void onEncodeStat(YMFEncoderStatisticInfo info) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeStat(info);
        }
    }

    @Override
    public void onEncodeResolution(int streamId, int width, int height) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeResolution(streamId, width, height);
        }
    }

    @Override
    public void onEncodeFirstFrame() {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeFirstFrame();
        }
    }

    @Override
    public void onEncodeFrameData(YMFVideoEncodeFrame videoEncodeFrame) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeFrameData(videoEncodeFrame);
        }
    }

    @Override
    public void onEncodeEncParam(String param) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeEncParam(param);
        }
    }

    @Override
    public void onHardEncoderError() {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onHardEncoderError();
        }
    }

    @Override
    public void onEncoderSwitch() {
    }

    @Override
    public void onWaterMarkSizeChange(int w, int h) {
        YMFLog.info(this, "[Beauty  ]", "onWaterMarkSizeChange w:" + w + " h:" + h + "(" + this.mWaterMakeX + "," + this.mWaterMakeY + "," + this.mWaterMakeW + "," + this.mWaterMakeH + ")");
        if ((double)this.mWaterMakeH == 0.0 || (double)this.mWaterMakeW == 0.0 || this.mWaterMarkBitmap == null) {
            return;
        }
        int X = (int)((float)w * this.mWaterMakeX);
        int Y = (int)((float)h * this.mWaterMakeY);
        int W = (int)((float)w * this.mWaterMakeW);
        int H = (int)((float)h * this.mWaterMakeH);
        float scaleWidth = (float)W / (float)this.mWaterMarkBitmap.getWidth();
        float scaleHeight = (float)H / (float)this.mWaterMarkBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBM = Bitmap.createBitmap((Bitmap)this.mWaterMarkBitmap, (int)0, (int)0, (int)this.mWaterMarkBitmap.getWidth(), (int)this.mWaterMarkBitmap.getHeight(), (Matrix)matrix, (boolean)false);
        WaterMark waterMark = new WaterMark(newBM, w, h, X, Y, WaterMark.Align.LeftTop);
        this.setWaterMark(waterMark);
    }

    @Override
    public void requestIFrame() {
        YMFLog.info(this, "[Encoder ]", "requestIFrame");
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            if (this.mEncoderGroupFilter != null) {
                this.mEncoderGroupFilter.requestSyncFrame();
            }
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    if (YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter != null) {
                        YMFExternalTextureSessionYCloud.this.mEncoderGroupFilter.requestSyncFrame();
                    }
                }
            });
        }
    }

    public void enableColorChartLive(final boolean enable) {
        YMFLog.info(this, "[Encoder ]", "enableColorChartLive:" + enable);
        if (this.mFilterContext.getGLManager().checkSameThread()) {
            this.mFilterContext.setColorChartLiveEnable(enable);
        } else {
            this.mFilterContext.getGlManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFExternalTextureSessionYCloud.this.mFilterContext.setColorChartLiveEnable(enable);
                }
            });
        }
    }

    public void enableMirror(boolean enable) {
        YMFLog.info(this, "[Encoder ]", "enableEncodeMirror:" + enable);
        if (this.mFilterContext != null) {
            this.mFilterContext.setMirrorFlag(enable);
        }
    }

    @Override
    public void setHardwareEncoderAvailable(boolean available) {
        YMFLog.info(this, "[Encoder ]", "HardwareEncoderAvailable set status:" + available);
        this.mHardwareEncoderAvailable.set(available);
    }

    @Override
    public boolean isHardwareEncoderAvailable() {
        YMFLog.info(this, "[Encoder ]", "HardwareEncoderAvailable get status:" + this.mHardwareEncoderAvailable.get());
        return this.mHardwareEncoderAvailable.get();
    }

    @Override
    public void setGLManagerRunnable(Runnable runnable) {
        if (this.mFilterContext != null) {
            this.mFilterContext.getGLManager().post(runnable);
        }
    }

    public void initOriginDataFilter() {
        if (this.mOriginDataFilter == null) {
            this.mOriginDataFilter = new OriginDataEntryFilter(this.mFilterContext);
            this.mFilterContext.getGlManager().registerFilter(this.mOriginDataFilter);
            this.mOriginDataFilter.addDownStream(this.mCliperFilter.addDownStream(this.mEncoderGroupFilter)).addDownStream(this.mEndPointFilter);
            YMFLog.error((Object)this, "[Encoder ]", "initOriginDataFilter success!");
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "initOriginDataFilter is not null");
        }
    }

    public void setOriginFrameToEncode(byte[] data, int format, int width, int height, int rotation, long timestamp, int scaleMode) {
        if (this.mOriginDataFilter != null) {
            long stamp = timestamp;
            if (timestamp < 0L) {
                stamp = TimeUtil.getTickCountLong();
            }
            this.mOriginDataFilter.setOriginFrameToEncode(data, format, width, height, rotation, stamp, scaleMode);
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "OriginDataFilter not init!");
        }
    }

    public void setOriginTextureToEncode(int inputTexture, int textureTarget, float[] transformer, int width, int height, long timestamp, int rotation, int scaleMode) {
        if (this.mOriginDataFilter != null) {
            long stamp = timestamp;
            if (timestamp < 0L) {
                stamp = TimeUtil.getTickCountLong();
            }
            this.mOriginDataFilter.setOriginTextureToEncode(inputTexture, textureTarget, transformer, width, height, stamp, rotation, scaleMode);
        } else {
            YMFLog.error((Object)this, "[Encoder ]", "OriginDataFilter not init!");
        }
    }

    public void setAbroadNetWorkStrategy(boolean flag) {
        if (this.mFilterContext != null) {
            this.mFilterContext.setAbroadNetWorkStrategy(flag);
        }
    }

    @Override
    public void onPeripheralsVideoDataReceived(DecodeVideoSample sample) {
    }

    @Override
    public void onPeripheralsVideoConfigReceived(DecodeVideoConfig config) {
    }

    @Override
    public void onPeripheralsVideoEnd() {
    }

    @Override
    public void setVideoRenderPosition(VideoRenderPosition position) {
    }

    @Override
    public void onExternalVideoEnd() {
    }

    @Override
    public void pushExternalVideoDecodeInfo(ExternalDecodeInfo info) {
    }

    @Override
    public void setExternalVideoInterface(ExternalInterface.IExternalCameraData IExternalCameraData2) {
    }

    @Override
    public void setExternalDecodeInterface(ExternalInterface.IExternalDecode IExternalDecode2) {
    }

    @Override
    public void takeScreenShot(ScreenShotCallback callback) {
    }

    @Override
    public void pushEncodeExternalData(ExternalYYMediaSample externalYYMediaSample) {
    }

    public void setEnableUnderflowStrategy(boolean flag) {
        YMFLog.error((Object)this, "[Encoder ]", "setEnableUnderflowStrategy:" + flag);
        if (this.mFilterContext != null) {
            this.mFilterContext.setEnableUnderflowStrategy(flag);
        }
    }
}

