/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.content.Context;
import android.graphics.Bitmap;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.ExternalInterface;
import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.IYYVideoSurfaceInfoListener;
import com.yy.mediaframework.VideoRenderPosition;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.api.YMFEncoderStatisticInfo;
import com.yy.mediaframework.api.YMFVideoEncodeFrame;
import com.yy.mediaframework.background.Background;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.base.YMFLowStreamEncoderConfig;
import com.yy.mediaframework.base.YYUserLiveConfig;
import com.yy.mediaframework.facedetection.CameraPreviewCallbackHost;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.mediaframework.filters.CameraCaptureFilter;
import com.yy.mediaframework.filters.ClipFilter;
import com.yy.mediaframework.filters.ExternalDecoderFilter;
import com.yy.mediaframework.filters.GPUPreprocessFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.PeripheralsDecoderFilter;
import com.yy.mediaframework.filters.PreviewFilter;
import com.yy.mediaframework.filters.VideoEncoderGroupFilter;
import com.yy.mediaframework.filters.VideoEndPointFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gpuimage.FilterType;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.inteligence.dynamictexture.IDynamicTexture;
import com.yy.mediaframework.model.AbstractSurfaceInfo;
import com.yy.mediaframework.model.DecodeVideoConfig;
import com.yy.mediaframework.model.DecodeVideoSample;
import com.yy.mediaframework.model.Rect;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.screenshot.ScreenShot;
import com.yy.mediaframework.screenshot.ScreenShotCallback;
import com.yy.mediaframework.sensor.RotationVectorSensor;
import com.yy.mediaframework.stat.UploadStatManager;
import com.yy.mediaframework.stat.VideoDataStatUtil;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoLiveSession
implements IYYVideoSurfaceInfoListener,
IEncoderListener,
ILiveSession {
    private static final String TAG = "VideoLiveSession";
    public PeripheralsDecoderFilter mPeripheralsDecoderFilter;
    public ExternalDecoderFilter mExternalDecoderFilter;
    public CameraCaptureFilter mCaptureFilter = null;
    public GPUPreprocessFilter mPreprocessFilter = null;
    public ClipFilter mCliperFilter = null;
    public PreviewFilter mPreviewFilter = null;
    public VideoEncoderGroupFilter mEncoderGroupFilter = null;
    public VideoLiveFilterContext mFilterContext = null;
    public VideoEndPointFilter mEndPointFilter = null;
    private ScreenShot mScreenShot;
    private WeakReference<IEncoderListener> mEncoderListener = new WeakReference<Object>(null);
    private AtomicBoolean mHardwareEncoderAvailable = new AtomicBoolean(true);
    private RotationVectorSensor mRotationVectorSensor = null;
    private long mLastCountTime = 0L;
    private CameraPreviewCallbackHost mPreviewCallbackHost = new CameraPreviewCallbackHost();

    public VideoLiveSession(Context context) {
        this.mFilterContext = new VideoLiveFilterContext(context, Constant.VideoStreamType.Camera);
        this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_NORMAL);
        this.mFilterContext.setAndroidContext(context);
        this.mRotationVectorSensor = new RotationVectorSensor(context);
        this.mFilterContext.setRvSensor(this.mRotationVectorSensor);
        this.mPeripheralsDecoderFilter = new PeripheralsDecoderFilter(this.mFilterContext);
        this.mExternalDecoderFilter = new ExternalDecoderFilter(this.mFilterContext);
        this.mCaptureFilter = new CameraCaptureFilter(this.mFilterContext);
        this.mPreprocessFilter = new GPUPreprocessFilter(this.mFilterContext);
        this.mCliperFilter = new ClipFilter();
        this.mScreenShot = new ScreenShot(context, this.mFilterContext);
        this.mFilterContext.setScreenShot(this.mScreenShot);
        this.mPreviewFilter = new PreviewFilter(this.mFilterContext);
        this.mEncoderGroupFilter = new VideoEncoderGroupFilter(this.mFilterContext, this);
        this.mEndPointFilter = new VideoEndPointFilter(this.mFilterContext);
        this.mEncoderGroupFilter.setEncoderListener(this);
        this.mPeripheralsDecoderFilter.addDownStream(this.mPreprocessFilter);
        this.mExternalDecoderFilter.addDownStream(this.mPreprocessFilter);
        this.mCaptureFilter.addDownStream(this.mPreprocessFilter.addDownStream(this.mCliperFilter.addDownStream(this.mEncoderGroupFilter).addDownStream(this.mPreviewFilter)).addDownStream(this.mEndPointFilter));
        this.mFilterContext.getGlManager().registerFilter(this.mPeripheralsDecoderFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mExternalDecoderFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mCaptureFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mPreprocessFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mCliperFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mPreviewFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEncoderGroupFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEndPointFilter);
        YMFLog.info(this, "[Procedur]", "videoLiveSession callbackbuffer screencatpure #### previewFilter clear color buffer");
    }

    public void startPreview(final int previewWidth, final int previewHeight, final int cameraFacing, final CameraInterface.CameraResolutionMode resMode) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mFilterContext.updateCameraPreviewConfig(previewWidth, previewHeight, cameraFacing, resMode);
                YMFLog.info(this, "[Preview ]", "startPreview, previewWidth:" + VideoLiveSession.this.mFilterContext.getCameraPreviewConfig().getWidth() + " previewHeight:" + VideoLiveSession.this.mFilterContext.getCameraPreviewConfig().getHeight());
                VideoLiveSession.this.mCaptureFilter.init();
                VideoLiveSession.this.mPreprocessFilter.init(previewWidth, previewHeight);
                CameraInterface.getInstance().post(new Runnable(){

                    @Override
                    public void run() {
                        CameraInterface.getInstance().startPreviewWithSurfaceTexture(VideoLiveSession.this.mCaptureFilter.getCaptureSurfaceTextures(), VideoLiveSession.this.mCaptureFilter);
                    }
                });
            }
        });
    }

    @Override
    public void stopAndRelease() {
        YMFLog.info(this, "[Procedur]", "VideoLiveSession stopAndRelease begin");
        this.mFilterContext.getGLManager().getHandler().removeCallbacksAndMessages(null);
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSession.this.mFilterContext.getScreenShot() != null) {
                    VideoLiveSession.this.mFilterContext.getScreenShot().deInit();
                }
                if (VideoLiveSession.this.mFilterContext.getDynamicTexture() != null) {
                    VideoLiveSession.this.mFilterContext.getDynamicTexture().onRelease();
                    VideoLiveSession.this.mFilterContext.setDynamicTexture(null);
                }
                if (VideoLiveSession.this.mFilterContext.getWaterMarkTexture() != null) {
                    VideoLiveSession.this.mFilterContext.getWaterMarkTexture().destroy();
                    VideoLiveSession.this.mFilterContext.setWaterMarkTexture(null);
                }
                if (VideoLiveSession.this.mFilterContext.getBackgroundTexture() != null) {
                    VideoLiveSession.this.mFilterContext.getBackgroundTexture().destroy();
                }
                UploadStatManager.getInstance().stopStat();
                VideoLiveSession.this.mFilterContext.getGLManager().quit();
                YMFLog.info(this, "[Procedur]", "VideoLiveSession stopAndRelease quit");
            }
        });
        this.stopRvSensor();
        this.mRotationVectorSensor = null;
        YMFLog.info(this, "[Procedur]", "VideoLiveSession stopAndRelease done");
        VideoDataStatUtil.clearPtsTimes(1001L);
    }

    @Override
    public void startEncoder() {
        YMFLog.info(this, "[Encoder ]", "VideoLiveSession startEncoder ");
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                YYUserLiveConfig userLiveConfig = VideoLiveSession.this.mFilterContext.getUserLiveConfig();
                if (!VideoLiveSession.this.isHardwareEncoderAvailable()) {
                    VideoLiveSession.this.mFilterContext.mVideoEncoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
                }
                if (VideoLiveSession.this.mEncoderGroupFilter.isEnable()) {
                    YMFLog.info(this, "[Encoder ]", "encoder is started already!!");
                } else {
                    try {
                        boolean res = VideoLiveSession.this.mEncoderGroupFilter.startEncode(VideoLiveSession.this.mFilterContext.getVideoEncoderConfig());
                        if (res) {
                            UploadStatManager.getInstance().startStat();
                        }
                    }
                    catch (Exception e) {
                        YMFLog.error((Object)this, "[Encoder ]", "VideoLiveSession startEncode exception:" + e);
                    }
                }
            }
        });
    }

    @Override
    public void stopEncoder() {
        YMFLog.info(this, "[Encoder ]", "VideoLiveSession stopEncoder");
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                UploadStatManager.getInstance().stopStat();
                if (VideoLiveSession.this.mEncoderGroupFilter.isEnable()) {
                    VideoLiveSession.this.mEncoderGroupFilter.stopEncode();
                }
            }
        });
    }

    @Override
    public void onSurfaceInfoEvent(int evtType, final AbstractSurfaceInfo surfaceInfo) {
        if (surfaceInfo != null) {
            YMFLog.info(this, "[Preview ]", "onSurfaceInfoEvent evtType:" + evtType + "width:" + surfaceInfo.mWidth + " height:" + surfaceInfo.mHeight);
        } else {
            YMFLog.info(this, "[Preview ]", "onSurfaceInfoEvent evtType:" + evtType);
        }
        switch (evtType) {
            case 1: 
            case 2: {
                this.mFilterContext.getGLManager().post(new Runnable(){

                    @Override
                    public void run() {
                        if (VideoLiveSession.this.mPreviewFilter != null) {
                            VideoLiveSession.this.mPreviewFilter.onSurfaceChanged(surfaceInfo);
                        }
                    }
                });
                break;
            }
            case 3: {
                this.mFilterContext.getGLManager().post(new Runnable(){

                    @Override
                    public void run() {
                        if (VideoLiveSession.this.mPreviewFilter != null) {
                            VideoLiveSession.this.mPreviewFilter.onSurfaceDestroy();
                        }
                    }
                });
                break;
            }
        }
    }

    public void setScreenShot(ScreenShot screenShot) {
        this.mFilterContext.setScreenShot(screenShot);
    }

    public void setFilterInfo(final FilterType filterType, final Map<String, String> params) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSession.this.mPreprocessFilter != null) {
                    VideoLiveSession.this.mPreprocessFilter.setFilterInfo(filterType, params);
                }
            }
        });
    }

    public void setFilterType(final FilterType filterType) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSession.this.mPreprocessFilter != null) {
                    VideoLiveSession.this.mPreprocessFilter.setFilterType(filterType);
                }
            }
        });
    }

    public void setWaterMark(final WaterMark waterMark) {
        YMFLog.info(this, "[Beauty  ]", "setWaterMark, waterMark==null? " + (waterMark == null ? "y" : "n"));
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mFilterContext.setWaterMarkTexture(waterMark);
            }
        });
    }

    public void setBackground(final Background background) {
        YMFLog.info(this, "[Beauty  ]", "setBackground, background ==null? " + (background == null ? "y" : "n"));
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mFilterContext.setBackgroundTexture(background);
            }
        });
    }

    @Override
    public void setDynamicTexture(final IDynamicTexture dynamicTexture) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                YMFLog.info(this, "[Beauty  ]", "setDynamicTexture:");
                VideoLiveSession.this.mFilterContext.setDynamicTexture(dynamicTexture);
            }
        });
    }

    @Override
    public void takeScreenShot(ScreenShotCallback callback) {
        if (this.mScreenShot != null) {
            this.mScreenShot.setCallback(callback);
        }
    }

    @Override
    public void setNetworkBitrateSuggest(final int bitrate) {
        YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitrate);
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mEncoderGroupFilter.setNetworkBitrateSuggest(bitrate);
            }
        });
    }

    @Override
    public void setResolutionModifyConfigs(final List<ResolutionModifyConfig> configs, final int intervalSecs) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mEncoderGroupFilter.setResolutionModifyConfigs(configs, intervalSecs);
            }
        });
    }

    @Override
    public void setEncoderListener(IEncoderListener listener) {
        this.mEncoderListener = new WeakReference<IEncoderListener>(listener);
        if (listener != null) {
            listener.onEncodeEncParam(this.mFilterContext.getEncodeParamTipsMgr().getParam());
        }
    }

    @Override
    public void setEncoderConfig(final VideoEncoderConfig config) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mFilterContext.getVideoEncoderConfig().assign(config);
                YMFLog.info(this, "[Encoder ]", "setEncoderConfig:" + VideoLiveSession.this.mFilterContext.getVideoEncoderConfig().toString());
                VideoLiveSession.this.mFilterContext.getDefaultVideoEncoderConfig().assign(config);
                VideoLiveSession.this.mPreprocessFilter.init(config.getEncodeWidth(), config.getEncodeHeight());
                VideoLiveSession.this.mEncoderGroupFilter.init();
                VideoLiveSession.this.mPreviewFilter.init(config.getEncodeWidth(), config.getEncodeHeight());
                UploadStatManager.getInstance().putSettingBitRate(config.getBitRate());
                UploadStatManager.getInstance().putSettingDPI(config.getRealDPI());
                UploadStatManager.getInstance().putSettingFrameRate(config.getFrameRate());
            }
        });
    }

    @Override
    public void setLowStreamEncoderConfigs(final List<YMFLowStreamEncoderConfig> lowStreamConfigs, final boolean enable) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mFilterContext.setLowStreamEncoderConfigs(lowStreamConfigs);
                VideoLiveSession.this.mFilterContext.enableLowStreamEncoder(enable);
            }
        });
    }

    @Override
    public void setLowDelayMode(final boolean enable) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mFilterContext.getVideoEncoderConfig().mLowDelay = enable;
                YMFLog.info(this, "[Encoder ]", "setLowDelayMode:" + enable + " config:" + VideoLiveSession.this.mFilterContext.getVideoEncoderConfig().toString());
            }
        });
    }

    @Override
    public void adjustEncoderBitrate(int bitRate) {
        if (this.mEncoderGroupFilter != null) {
            YMFLog.info(this, "[Encoder ]", "adjustEncoderBitrate:" + bitRate);
            this.mEncoderGroupFilter.adjustBitRate((bitRate + 999) / 1000);
        }
    }

    @Override
    public void onEncodeStat(YMFEncoderStatisticInfo info) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeStat(info);
        }
    }

    @Override
    public void onEncodeResolution(int streamId, int width, int height) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeResolution(streamId, width, height);
        }
    }

    @Override
    public void onEncodeFirstFrame() {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeFirstFrame();
        }
    }

    @Override
    public void onHardEncoderError() {
    }

    @Override
    public void onEncodeFrameData(YMFVideoEncodeFrame videoEncodeFrame) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (System.currentTimeMillis() - this.mLastCountTime >= 6000L) {
            this.mLastCountTime = System.currentTimeMillis();
            YMFLog.info(this, "[Encoder ]", "onEncodeFrameData, listener:" + listener);
        }
        if (listener != null) {
            listener.onEncodeFrameData(videoEncodeFrame);
        }
    }

    @Override
    public void onEncodeEncParam(String param) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeEncParam(param);
        }
    }

    @Override
    public void onEncoderSwitch() {
        YMFLog.info(this, "[Encoder ]", "encoder switch in VideoLiveSession");
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.stopEncoder();
                VideoLiveSession.this.startEncoder();
            }
        });
    }

    @Override
    public void onWaterMarkSizeChange(int w, int h) {
    }

    @Override
    public void requestIFrame() {
        YMFLog.info(this, "[Encoder ]", "requestIFrame");
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                if (VideoLiveSession.this.mEncoderGroupFilter != null) {
                    VideoLiveSession.this.mEncoderGroupFilter.requestSyncFrame();
                }
            }
        });
    }

    public void setUserLiveConfig(final YYUserLiveConfig userLiveConfig) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mFilterContext.setUserLiveConfig(userLiveConfig);
            }
        });
    }

    public void enableColorChartLive(final boolean enable) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mFilterContext.setColorChartLiveEnable(enable);
            }
        });
    }

    public void onDualPictureSwitch() {
        this.mFilterContext.setSwitchPicture();
    }

    public void onDualOpen(boolean flag) {
        this.mFilterContext.setPictureInPictureFlag(flag);
    }

    public void onCameraFocusAreaChanged(Rect rect) {
    }

    public void onCameraExposureAreaChanged(Rect rect) {
    }

    public void enableMirror(final boolean enable) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mFilterContext.setMirrorFlag(enable);
            }
        });
    }

    @Override
    public void setHardwareEncoderAvailable(boolean available) {
        YMFLog.info(this, "[Encoder ]", "HardwareEncoderAvailable set status:" + available);
        this.mHardwareEncoderAvailable.set(available);
    }

    @Override
    public boolean isHardwareEncoderAvailable() {
        YMFLog.info(this, "[Encoder ]", "HardwareEncoderAvailable get status:" + this.mHardwareEncoderAvailable.get());
        return this.mHardwareEncoderAvailable.get();
    }

    public void setSurfaceChanged(final int w, final int h) {
        if (this.mPreviewFilter == null) {
            return;
        }
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mPreviewFilter.setSurfaceChanged(w, h);
            }
        });
    }

    public void onPeripheralsVideoDataReceived(DecodeVideoSample sample) {
        this.mPeripheralsDecoderFilter.handlePeripheralsVideoData(sample);
    }

    public void onPeripheralsVideoConfigReceived(DecodeVideoConfig config) {
        this.mPeripheralsDecoderFilter.handlePeripheralsVideoConfig(config, this.mPeripheralsDecoderFilter);
    }

    public void onOutdoorVideoDataReceived(DecodeVideoSample sample) {
        this.mExternalDecoderFilter.handleOutdoorVideoData(sample);
    }

    public void onOutdoorVideoConfigReceived(DecodeVideoConfig config) {
        this.mExternalDecoderFilter.handleOutdoorVideoConfig(config, this.mExternalDecoderFilter);
    }

    public void onPeripheralsVideoEnd() {
        YMFLog.info(this, "[Decoder ]", "onPeripheralsVideoEnd");
        this.mPeripheralsDecoderFilter.handlePerpheralsVideoEnd();
        this.mPeripheralsDecoderFilter.deInit();
        this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_NORMAL);
        this.mPreprocessFilter.onPeripheralsVideoEnd();
    }

    public void onExternalVideoEnd() {
        YMFLog.info(this, "[Decoder ]", "onPeripheralsVideoEnd");
        this.mExternalDecoderFilter.handleExternalVideoEnd();
        this.mExternalDecoderFilter.deInit();
        this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_NORMAL);
        this.mEncoderGroupFilter.onExternalVideoEnd();
    }

    public void setSessionLiveMode(LiveSessionType type) {
        this.mFilterContext.setLiveMode(type);
    }

    public void setVideoRenderPostion(final VideoRenderPosition position) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                VideoLiveSession.this.mFilterContext.setVideoRenderPostion(position);
            }
        });
    }

    public void startRvSensor() {
        YMFLog.info(this, "[Preview ]", "startRvSensor");
        if (this.mRotationVectorSensor != null) {
            this.mRotationVectorSensor.registerSensor();
        }
    }

    public void stopRvSensor() {
        YMFLog.info(this, "[Preview ]", "stopRvSensor");
        if (this.mRotationVectorSensor != null) {
            this.mRotationVectorSensor.unregisterSensor();
        }
    }

    public void setDeltaYYPtsMillions(final long deltaPtsDts) {
        YMFLog.info(this, "[Encoder ]", "setDeltaYYPtsMillions:" + deltaPtsDts);
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                YYVideoSDK.getInstance().setDeltaYYPtsMillions(deltaPtsDts);
            }
        });
    }

    public void registerPreviewCallback(PreviewFrameCallback callback) {
        if (this.mPreviewCallbackHost != null) {
            this.mPreviewCallbackHost.registerCallback(callback);
        }
    }

    public void unregisterPreviewCallback(PreviewFrameCallback callback) {
        if (this.mPreviewCallbackHost != null) {
            this.mPreviewCallbackHost.unregisterCallback(callback);
        }
    }

    public void setExternalCameraDataCallback(ExternalInterface.IExternalCameraData IExternalCameraData2) {
        if (this.mFilterContext != null && IExternalCameraData2 != null) {
            this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_EXTERNAL);
        }
        if (this.mEncoderGroupFilter != null) {
            this.mEncoderGroupFilter.setExternalCameraDataCallback(IExternalCameraData2);
        }
    }

    public void setExternalDecodeInterface(ExternalInterface.IExternalDecode IExternalDecode2) {
        if (this.mFilterContext != null && IExternalDecode2 != null) {
            this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_EXTERNAL);
        }
        if (this.mEncoderGroupFilter != null) {
            this.mEncoderGroupFilter.setExternalDecodeCallback(IExternalDecode2);
        }
    }

    public void startEncodeExternalData(YYMediaSample sample) {
        if (this.mEncoderGroupFilter != null) {
            this.mEncoderGroupFilter.setIsExternalEncode(true);
            this.mEncoderGroupFilter.processMediaSample(sample, null);
        }
    }

    public void setGLManagerRunnable(Runnable runnable) {
        if (this.mFilterContext != null) {
            this.mFilterContext.getGLManager().post(runnable);
        }
    }

    public void setGPUImageBeautyFilter(IGPUProcess gpuImageProcess) {
        if (this.mPreprocessFilter != null) {
            this.mPreprocessFilter.setGPUImageBeautyFilter(gpuImageProcess);
        } else {
            YMFLog.error((Object)this, "[Beauty  ]", "setGPUImageBeautyFilter null");
        }
    }

    @Override
    public void setWaterMark(Bitmap bitmap, int offsetX, int offsetY) {
    }
}

