/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.mediaframework.YMFGlManagerTest;
import com.yy.mediaframework.filters.AbstractYYMediaFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gles.EglFactory;
import com.yy.mediaframework.gles.IEglCore;
import com.yy.mediaframework.gles.IEglSurfaceBase;
import com.yy.mediaframework.stat.UploadStatManager;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.YMFLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressLint(value={"NewApi"})
public class GlManager
implements Runnable {
    private static final String TAG = "GlManager";
    public Thread mLooperThread;
    public GlHandler mGlHandler = null;
    public YMFGlManagerTest mGlManagerTest = null;
    private IEglCore mEglCore;
    private IEglSurfaceBase mEnvSurface;
    private int mType;
    private AtomicBoolean mStartLock = new AtomicBoolean(false);
    private int mDefaultWidth = 10;
    private int mDefaultHeight = 10;
    private ArrayList<AbstractYYMediaFilter> mFilterArray = new ArrayList();
    private AtomicBoolean mIsQuit = new AtomicBoolean(false);
    private VideoLiveFilterContext mVideoLiveFilterContext;
    private boolean mIsInitException;
    private Object mSharedContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlManager(int type, Object sharedContext) {
        this.mType = type;
        this.mSharedContext = sharedContext;
        long beginMs = System.currentTimeMillis();
        this.mLooperThread = new Thread((Runnable)this, "YY_yyvideolib_GlManager_Thread");
        this.mLooperThread.start();
        AtomicBoolean atomicBoolean = this.mStartLock;
        synchronized (atomicBoolean) {
            if (!this.mStartLock.get()) {
                try {
                    this.mStartLock.wait();
                }
                catch (InterruptedException e) {
                    YMFLog.error((Object)this, "[Procedur]", "GlManager construct exeception:" + e.getMessage());
                }
            }
        }
        YMFLog.info(this, "[Procedur]", "GlManager constructor cost:" + (System.currentTimeMillis() - beginMs));
    }

    public void setVideoLiveFilterContext(VideoLiveFilterContext context) {
        this.mVideoLiveFilterContext = context;
    }

    public long getThreadId() {
        return this.mLooperThread.getId();
    }

    public Handler getHandler() {
        return this.mGlHandler;
    }

    public IEglCore getEglCore() {
        return this.mEglCore;
    }

    public void resetContext() {
        this.mEglCore.makeCurrent(this.mEnvSurface);
    }

    private void InitEGL() {
        this.mIsInitException = true;
        this.mEglCore = (Build.MODEL.equalsIgnoreCase("M355") || Build.MODEL.equalsIgnoreCase("M351") || Build.MODEL.equalsIgnoreCase("GT-I9500")) && Build.VERSION.SDK_INT == 19 || Build.MODEL.equalsIgnoreCase("vivo X3t") || Build.MODEL.equalsIgnoreCase("2013023") || Build.MODEL.equalsIgnoreCase("Lenovo K900") ? EglFactory.createEGL(this.mSharedContext, 0) : EglFactory.createEGL(this.mSharedContext, 1);
        this.mEnvSurface = this.mEglCore.createSurfaceBase();
        this.mEnvSurface.createOffscreenSurface(this.mDefaultWidth, this.mDefaultHeight);
        this.mEglCore.makeCurrent(this.mEnvSurface);
        long tid = Thread.currentThread().getId();
        YMFLog.info(this, "[Procedur]", "Texture created thread id:" + tid);
        this.mIsInitException = false;
    }

    private void deInitEGL() {
        if (this.mEnvSurface != null) {
            this.mEglCore.makeNothingCurrent();
            this.mEnvSurface.releaseEglSurface();
            this.mEnvSurface = null;
        }
        if (this.mEglCore != null) {
            this.mEglCore.release();
            this.mEglCore = null;
        }
    }

    public void quit() {
        this.mIsQuit.set(true);
        YMFLog.info(this, "[Procedur]", "quit GlManager thread, quitSafely...");
        this.mGlManagerTest.quit();
        Looper loop = Looper.myLooper();
        if (null != loop) {
            if (Build.VERSION.SDK_INT >= 18) {
                loop.quitSafely();
            } else {
                loop.quit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFilter(AbstractYYMediaFilter filter) {
        YMFLog.info(this, "[Procedur]", "registerFilter");
        ArrayList<AbstractYYMediaFilter> arrayList = this.mFilterArray;
        synchronized (arrayList) {
            this.mFilterArray.add(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseFilters() {
        YMFLog.info(this, "[Procedur]", "releaseFilters");
        ArrayList<AbstractYYMediaFilter> arrayList = this.mFilterArray;
        synchronized (arrayList) {
            for (AbstractYYMediaFilter filter : this.mFilterArray) {
                if (filter == null) continue;
                filter.deInit();
            }
            this.mFilterArray.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        YMFLog.info(this, "[Procedur]", "glManager thread begin!!!!!");
        YMFLiveUsrBehaviorStat.getInstance().notifyVideoGlManagerState(this.mType, true);
        try {
            Looper.prepare();
            this.mGlHandler = new GlHandler(this);
            this.mGlManagerTest = new YMFGlManagerTest(this);
            AtomicBoolean atomicBoolean = this.mStartLock;
            synchronized (atomicBoolean) {
                this.mStartLock.set(true);
                this.mStartLock.notifyAll();
            }
            this.InitEGL();
            Looper.loop();
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (this.mIsInitException) {
                UploadStatManager.getInstance().reportException("2", "101", t.getMessage());
            } else {
                UploadStatManager.getInstance().reportException("2", "102", t.getMessage());
            }
            YMFLog.error((Object)this, "[Procedur]", "glManager run exception:" + t.getMessage());
        }
        finally {
            YMFLog.info(this, "[Procedur]", "glManager releaseFilters");
            if (this != null) {
                this.releaseFilters();
                try {
                    this.deInitEGL();
                }
                catch (Throwable t) {
                    UploadStatManager.getInstance().reportException("2", "103", t.getMessage());
                    YMFLog.error((Object)this, "[Procedur]", "deInitEGL exception:" + t.getMessage());
                }
            }
        }
        YMFLiveUsrBehaviorStat.getInstance().notifyVideoGlManagerState(this.mType, false);
        YMFLog.info(this, "[Procedur]", "glManager thread exit!!!!!");
    }

    public boolean checkSameThread() {
        return Thread.currentThread().getId() == this.getThreadId();
    }

    public boolean post(Runnable task) {
        if (this.mIsQuit.get()) {
            return false;
        }
        boolean ret = false;
        try {
            if (this.mGlHandler.getLooper() != null) {
                ret = this.mGlHandler.post(task);
            }
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Procedur]", "GlManager PostRunnable exeception:" + t.toString());
        }
        return ret;
    }

    public boolean postDelayed(Runnable task, int delayMillis) {
        boolean ret = false;
        try {
            if (this.mGlHandler.getLooper() != null) {
                ret = this.mGlHandler.postDelayed(task, delayMillis);
            }
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Procedur]", "GlManager PostRunnable exeception:" + t.toString());
        }
        return ret;
    }

    private static class GlHandler
    extends Handler {
        private WeakReference<GlManager> mWeakGLManager;

        public GlHandler(GlManager encoder) {
            this.mWeakGLManager = new WeakReference<GlManager>(encoder);
        }

        public void handleMessage(Message inputMessage) {
            int what = inputMessage.what;
            Object obj = inputMessage.obj;
            GlManager encoder = (GlManager)this.mWeakGLManager.get();
            if (encoder == null) {
                YMFLog.warn((Object)this, "[Procedur]", "handleMessage: GlManager is null");
                return;
            }
            switch (what) {
                default: 
            }
        }
    }
}

