/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import android.view.WindowManager;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;
import java.util.List;

public class CameraUtils {
    private static final String TAG = "CameraUtils";
    private static final int DEFAULT_PREVIEW_WIDTH = 1280;
    private static final int DEFAULT_PREVIEW_HEIGHT = 720;
    public static ArrayList<Long> mCameraBufferHashCode = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCameraBufferHashCode(long hashCode) {
        ArrayList<Long> arrayList = mCameraBufferHashCode;
        synchronized (arrayList) {
            if (hashCode == 0L) {
                mCameraBufferHashCode.clear();
            }
            mCameraBufferHashCode.add(hashCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queryCameraBufferHashCode(long hashCode) {
        ArrayList<Long> arrayList = mCameraBufferHashCode;
        synchronized (arrayList) {
            return mCameraBufferHashCode.contains(hashCode);
        }
    }

    public static void setCameraDisplayOrientation(Context context, Camera camera, Camera.CameraInfo cameraInfo) {
        if (context != null && camera != null) {
            int rotation = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation();
            int degrees = 0;
            switch (rotation) {
                case 0: {
                    degrees = 0;
                    break;
                }
                case 1: {
                    degrees = 90;
                    break;
                }
                case 2: {
                    degrees = 180;
                    break;
                }
                case 3: {
                    degrees = 270;
                    break;
                }
                default: {
                    YMFLog.error(null, "[CCapture]", "invalid rotation:" + rotation);
                }
            }
            YMFLog.info(null, "[CCapture]", "setCameraDisplayOrientation degrees:" + degrees);
            CameraUtils.setCameraDisplayOrientation(degrees, camera, cameraInfo);
        }
    }

    public static void setCameraDisplayOrientation(int displayRotation, Camera camera, Camera.CameraInfo cameraInfo) {
        if (camera == null) {
            return;
        }
        int result = 90;
        if (cameraInfo != null) {
            if (cameraInfo.facing == 1) {
                result = (cameraInfo.orientation + displayRotation) % 360;
                result = (360 - result) % 360;
            } else {
                result = (cameraInfo.orientation - displayRotation + 360) % 360;
            }
        } else {
            YMFLog.error(null, "[CCapture]", "setCameraDisplayOrientation cameraInfo null");
        }
        YMFLog.info(null, "[CCapture]", "setCameraDisplayOrientation:" + result + " ,displayRotation:" + displayRotation);
        camera.setDisplayOrientation(result);
        CameraInterface.getInstance().setRotation(result);
    }

    public static Camera.Size selectPreferredSize(Camera.Parameters params, int width, int height) {
        int gap;
        List cameraSizeList = params.getSupportedPreviewSizes();
        int count = cameraSizeList.size();
        for (int i = 0; i < count; ++i) {
            Camera.Size previewSize = (Camera.Size)cameraSizeList.get(i);
            YMFLog.info(null, "[CCapture]", "camera preview size:" + previewSize.width + "x" + previewSize.height);
        }
        Camera.Size result = null;
        for (Camera.Size previewSize : cameraSizeList) {
            if (previewSize.width != width || previewSize.height != height) continue;
            result = previewSize;
            break;
        }
        if (null == result) {
            int minGap = Integer.MAX_VALUE;
            for (Camera.Size previewSize : cameraSizeList) {
                if (previewSize.width < width || previewSize.height < height || (gap = previewSize.width - width + previewSize.height - height) >= minGap) continue;
                minGap = gap;
                result = previewSize;
            }
        }
        if (null == result) {
            int minGap = Integer.MAX_VALUE;
            for (Camera.Size previewSize : cameraSizeList) {
                gap = Math.abs(previewSize.width - width) + Math.abs(previewSize.height - height);
                if (gap >= minGap) continue;
                minGap = gap;
                result = previewSize;
            }
        }
        if (result != null) {
            params.setPreviewSize(result.width, result.height);
        }
        return result;
    }

    public static void choosePreviewSize(Camera.Parameters parms, int width, int height) {
        Camera.Size ppsfv = parms.getPreferredPreviewSizeForVideo();
        if (ppsfv != null) {
            YMFLog.info(null, "[CCapture]", "Camera preferred preview size for video is:" + ppsfv.width + "x" + ppsfv.height);
        }
        int tempWidth = Integer.MAX_VALUE;
        int tempHeight = Integer.MAX_VALUE;
        for (Camera.Size size : parms.getSupportedPreviewSizes()) {
            YMFLog.info(null, "[CCapture]", " supported size:" + size.width + "x" + size.height);
            if (size.width < width || size.height < height || size.width > tempWidth || size.height > tempHeight) continue;
            tempWidth = size.width;
            tempHeight = size.height;
        }
        if (tempWidth != Integer.MAX_VALUE && tempHeight != Integer.MAX_VALUE) {
            YMFLog.info(null, "[CCapture]", "prefer size:" + width + "x" + height + ", choose " + tempWidth + "x" + tempHeight);
            parms.setPreviewSize(tempWidth, tempHeight);
            return;
        }
        if (ppsfv != null) {
            parms.setPreviewSize(ppsfv.width, ppsfv.height);
        }
    }

    public static int chooseFixedPreviewFps(Camera.Parameters parms, int desiredThousandFps) {
        List supported = parms.getSupportedPreviewFpsRange();
        for (int[] entry : supported) {
            YMFLog.info(null, "[CCapture]", "getSupportedPreviewFpsRange entry:" + entry[0] + " - " + entry[1]);
            if (entry[0] != entry[1] || entry[0] != desiredThousandFps) continue;
            parms.setPreviewFpsRange(entry[0], entry[1]);
            return entry[0];
        }
        int[] tmp = new int[2];
        parms.getPreviewFpsRange(tmp);
        int guess = tmp[0] == tmp[1] ? tmp[0] : tmp[1] / 2;
        YMFLog.info(null, "[CCapture]", "Couldn't find match for " + desiredThousandFps + ", using " + guess);
        return guess;
    }

    public static Camera openCamera(CameraFacing cameraFacing) {
        return CameraUtils.openCamera(cameraFacing, null);
    }

    public static Camera openCamera(CameraFacing cameraFacing, Camera.CameraInfo info) {
        if (info == null) {
            info = new Camera.CameraInfo();
        }
        Camera camera = null;
        try {
            int numCameras = Camera.getNumberOfCameras();
            for (int i = 0; i < numCameras; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (cameraFacing == CameraFacing.FacingFront) {
                    if (info.facing != 1) continue;
                    camera = Camera.open((int)i);
                    break;
                }
                if (info.facing != 0) continue;
                camera = Camera.open((int)i);
                break;
            }
            if (camera == null) {
                Log.d((String)TAG, (String)"No front-facing camera found; opening default");
                camera = Camera.open();
            }
        }
        catch (Throwable throwable) {
            YMFLog.error(null, "[CCapture]", "openCamera exception:" + throwable);
        }
        return camera;
    }

    public static PreviewSize getSpecialCameraPreviewSizeWithModel(String model, Camera.Size size, CameraFacing facing) {
        PreviewSize result = null;
        if ("MI 4LTE".equalsIgnoreCase(model)) {
            if (size != null && size.width != 1280 && size.height != 720 && facing == CameraFacing.FacingBack) {
                result = new PreviewSize(1280, 720);
            }
        } else if ("HM NOTE 1W".equalsIgnoreCase(model)) {
            if (size != null && size.width != 1280 && size.height != 720) {
                result = new PreviewSize(1280, 720);
            }
        } else if ("2013023".equalsIgnoreCase(model)) {
            if (size != null && size.width == 960 && size.height == 540) {
                result = new PreviewSize(1280, 720);
            }
        } else if ("vivo X5L".equalsIgnoreCase(model) && size != null && size.width == 960 && size.height == 540) {
            result = new PreviewSize(1280, 720);
        }
        if (result != null) {
            YMFLog.info(null, "[CCapture]", "getSpecialCameraPreviewSizeWithModel size:" + result + ", model:" + model + ", " + (Object)((Object)facing));
        }
        return result;
    }

    public static int toAndroidCameraFacing(CameraFacing facing) {
        if (facing == CameraFacing.FacingFront) {
            return 1;
        }
        return 0;
    }

    public static boolean isCameraAvailable(int facing) {
        int cameraCount = Camera.getNumberOfCameras();
        Camera.CameraInfo info = new Camera.CameraInfo();
        for (int i = 0; i < cameraCount; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (facing != info.facing) continue;
            YMFLog.info(null, "[CCapture]", "isCameraAvailable true:" + facing);
            return true;
        }
        YMFLog.info(null, "[CCapture]", "isCameraAvailable false:" + facing);
        return false;
    }

    public static int[] getMaxFrameRateRange(Camera.Parameters params) {
        List listFpsRange = params.getSupportedPreviewFpsRange();
        int[] maxRange = null;
        int minIndex = 0;
        int maxIndex = 1;
        for (int[] range : listFpsRange) {
            if (null == maxRange) {
                maxRange = range;
                continue;
            }
            if (range[maxIndex] > maxRange[maxIndex]) {
                maxRange = range;
                continue;
            }
            if (range[maxIndex] != maxRange[maxIndex] || range[minIndex] >= maxRange[minIndex]) continue;
            maxRange = range;
        }
        return maxRange;
    }

    @TargetApi(value=14)
    public static boolean isMeteringAreaSupported(Camera.Parameters params) {
        if (Build.VERSION.SDK_INT >= 14) {
            return params.getMaxNumMeteringAreas() > 0;
        }
        return false;
    }

    @TargetApi(value=14)
    public static boolean isFocusAreaSupported(Camera.Parameters params) {
        if (Build.VERSION.SDK_INT >= 14) {
            return params.getMaxNumFocusAreas() > 0 && CameraUtils.isSupported("auto", params.getSupportedFocusModes());
        }
        return false;
    }

    @TargetApi(value=14)
    public static boolean isFaceDetectionSupported(Camera.Parameters params) {
        if (Build.VERSION.SDK_INT >= 14) {
            return params.getMaxNumDetectedFaces() > 0;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTorchSupported(Camera.Parameters params) {
        if (params == null) return false;
        List modes = params.getSupportedFlashModes();
        if (modes == null) return false;
        if (!modes.contains("off")) return false;
        if (!modes.contains("torch")) return false;
        return true;
    }

    public static boolean isSupported(String value, List<String> supported) {
        return supported == null ? false : supported.indexOf(value) >= 0;
    }

    public static int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static void rectFToRect(RectF rectF, Rect rect) {
        rect.left = Math.round(rectF.left);
        rect.top = Math.round(rectF.top);
        rect.right = Math.round(rectF.right);
        rect.bottom = Math.round(rectF.bottom);
    }

    public static void prepareMatrix(Matrix matrix, boolean mirror, int displayOrientation, int viewWidth, int viewHeight) {
        matrix.setScale(mirror ? -1.0f : 1.0f, 1.0f);
        matrix.postRotate((float)displayOrientation);
        matrix.postScale((float)viewWidth / 2000.0f, (float)viewHeight / 2000.0f);
        matrix.postTranslate((float)viewWidth / 2.0f, (float)viewHeight / 2.0f);
    }

    public static class PreviewSize {
        public int width;
        public int height;

        public PreviewSize(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return "" + this.width + "x" + this.height;
        }
    }

    public static enum CameraFacing {
        FacingFront,
        FacingBack;

    }
}

