/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.MotionEvent;
import com.yy.mediaframework.CameraListener;
import com.yy.mediaframework.CameraUtils;
import com.yy.mediaframework.CameraUtils2;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.PictureInPictureDisplayInfo;
import com.yy.mediaframework.UploadStreamStateParams;
import com.yy.mediaframework.model.Rect;
import com.yy.mediaframework.stat.YMFLiveExceptionStat;
import com.yy.mediaframework.stat.YMFLiveExceptionType;
import com.yy.mediaframework.stat.YMFLiveStatisticManager;
import com.yy.mediaframework.stat.YMFLiveUsrBehaviorStat;
import com.yy.mediaframework.utils.VideoSizeUtils;
import com.yy.mediaframework.utils.YMFLog;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class CameraInterface
implements Runnable {
    private static final int MSG_QUIT = 0;
    private Camera mMasterCamera = null;
    private Camera mSlaveCamera = null;
    private Camera.CameraInfo mMasterCameraInfo;
    private Camera.CameraInfo mSlaveCameraInfo;
    private PictureInPictureDisplayInfo mDisplayInfo;
    private static final String TAG = "CameraInterface";
    public static final int DISPLAY_ROTATION_PORTRAIT = 0;
    public static final int DISPLAY_ROTATION_LANDSCAPE = 90;
    public static final int DISPLAY_ROTATION_PORTRAIT_UPSIDEDOWN = 180;
    public static final int DISPLAY_ROTATION_LANDSCAPE_UPSIDEDOWN = 270;
    private static volatile CameraInterface mInstance;
    private CameraInterfaceHandler mHandler;
    private Camera.Size mCameraPreviewSize;
    private VideoSizeUtils.Size mPreviewYuvSize;
    private int[] mCameraFpsRange = new int[2];
    private int mDisplayRotation = 0;
    private boolean mDisplayPortrait = true;
    private int mDesiredWidth;
    private int mDesiredHeight;
    private int mDesiredFps = 0;
    public static int mSetCameraFpsParams;
    private long mLastFaceDetectTime = System.currentTimeMillis();
    private Rect mCurrentFocusArea = null;
    private CameraUtils.CameraFacing mCameraFacing;
    private CameraUtils.CameraFacing mOriginalCameraFacing;
    private boolean isFlashOn = false;
    private WeakReference<SurfaceTexture[]> mCameraPreviewSurfaceTextures;
    private WeakReference<CameraListener> mCameraListener = new WeakReference<Object>(null);
    private WeakReference<Camera.PreviewCallback> mPreviewCallbackRef;
    private Object mCameraLock = new Object();
    private WeakReference<SurfaceTexture.OnFrameAvailableListener> mPreviewFrameAvailableListenerRef;
    private CameraResolutionMode mResolutionMode;
    private WeakReference<byte[]> previewCallbackBuffer;
    private Boolean mAlreadyAttached = false;
    private AtomicBoolean mStartLock = new AtomicBoolean(false);
    private Thread mThread;
    private final int FOCUS_AREA_SIZE = 300;
    private final int FOCUS_AREA_SIZE_VIVO = 300;
    private boolean mFocusAreaSupported = false;
    private boolean mMeteringAreaSupported = false;
    private boolean mFaceDetectSupported = false;
    private boolean mFaceFocusEnable = false;
    private boolean mFaceFocusRestart = false;
    private boolean mMirror = false;
    private float mResumeZoomValue = 1.0f;
    private int mSurfaceViewWidth = 0;
    private int mSurfaceViewHeight = 0;
    private int mRotation = 90;
    private int mPreviewFormat;
    private List<Camera.Area> mFocusArea;
    private List<Camera.Area> mMeteringArea;
    private FocusListener mFocusListener;
    private String mDefaultMasterFocusMode;
    private String mDefaultSlaveFocusMode;
    private Matrix mMatrix;
    private Matrix mMatrixDriveToView;
    private String mDeviceName;
    private String mDeviceBrand;
    private Timer mCameraTimer;
    private TimerTask mMeteringTimerTask;
    private TimerTask mFocusTimerTask;
    private AtomicBoolean mIsMasterCameraOpened = new AtomicBoolean(false);
    private final AutoFocusCallback mAutoFocusCallback = new AutoFocusCallback();
    Camera.ErrorCallback errorCallback = new Camera.ErrorCallback(){

        public void onError(int error, Camera camera) {
            if (CameraInterface.this.mCameraListener != null && CameraInterface.this.mCameraListener.get() != null) {
                ((CameraListener)CameraInterface.this.mCameraListener.get()).reSetEncodingState();
            }
            if (error == 2) {
                YMFLiveExceptionStat.getInstance().notifyException(YMFLiveExceptionType.AnchorStatus_CAPTURE_USED_BY_HIGHER_PRIORITY);
            }
            YMFLiveExceptionStat.getInstance().notifyException(YMFLiveExceptionType.AnchorStatus_CAPTURE_ERROR);
            YMFLiveUsrBehaviorStat.getInstance().notifyLiveException("open_camere_error_" + error);
            if (error == 100) {
                YMFLog.error((Object)this, "[CCapture]", "CAMERA_ERROR_SERVER_DIED received, openCamera again .");
                CameraInterface.this.openCamera(CameraInterface.this.mDesiredWidth, CameraInterface.this.mDesiredHeight, CameraInterface.this.mDesiredFps, CameraInterface.this.mCameraFacing, CameraInterface.this.mResolutionMode, CameraInterface.this.mDisplayRotation);
            } else if (error == 1) {
                YMFLog.error((Object)this, "[CCapture]", "CAMERA_ERROR_UNKNOWN received, openCamera again .");
                CameraInterface.this.openCamera(CameraInterface.this.mDesiredWidth, CameraInterface.this.mDesiredHeight, CameraInterface.this.mDesiredFps, CameraInterface.this.mCameraFacing, CameraInterface.this.mResolutionMode, CameraInterface.this.mDisplayRotation);
            } else {
                YMFLog.error((Object)this, "[CCapture]", "camera error:" + error);
            }
        }
    };
    Camera.FaceDetectionListener mFaceDetectListener = new Camera.FaceDetectionListener(){

        public void onFaceDetection(Camera.Face[] faces, Camera camera) {
            for (Camera.Face face : faces) {
                RectF viewRect = new RectF(face.rect);
                CameraInterface.this.mMatrixDriveToView.mapRect(viewRect);
                if (!CameraInterface.this.mFaceFocusEnable) continue;
                Rect rect = new Rect(viewRect.left, viewRect.top, viewRect.right, viewRect.bottom);
                CameraListener listener = null;
                listener = (CameraListener)CameraInterface.this.mCameraListener.get();
                if (listener == null) break;
                CameraInterface.this.mCurrentFocusArea = rect;
                listener.onCameraFocusAreaChanged(rect);
                break;
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CameraInterface getInstance() {
        if (mInstance != null) return mInstance;
        Class<CameraInterface> clazz = CameraInterface.class;
        synchronized (CameraInterface.class) {
            if (mInstance != null) return mInstance;
            mInstance = new CameraInterface();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public CameraInterface() {
        this.mMasterCameraInfo = new Camera.CameraInfo();
        this.mSlaveCameraInfo = new Camera.CameraInfo();
        this.mMatrix = new Matrix();
        this.mMatrixDriveToView = new Matrix();
        this.mDeviceName = Build.MODEL.toLowerCase();
        this.mDeviceBrand = Build.BRAND.toLowerCase();
        this.mCameraTimer = new Timer();
        this.initThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initThread() {
        YMFLog.info(this, "[CCapture]", "initThread construct start.");
        this.mThread = new Thread((Runnable)this, "YYVideoLib-CameraInterface");
        this.mThread.start();
        AtomicBoolean atomicBoolean = this.mStartLock;
        synchronized (atomicBoolean) {
            if (!this.mStartLock.get()) {
                try {
                    this.mStartLock.wait();
                }
                catch (InterruptedException e) {
                    YMFLog.error((Object)this, "[CCapture]", "GlManager construct exception:" + e.getMessage());
                }
            }
        }
        YMFLog.info(this, "[CCapture]", "initThread done.");
    }

    public void setCameraListener(CameraListener listner) {
        YMFLog.info(this, "[CCapture]", "setCameraListener:" + listner);
        if (listner != null) {
            this.mCameraListener = new WeakReference<CameraListener>(listner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Looper.prepare();
            this.mHandler = new CameraInterfaceHandler(this);
            AtomicBoolean atomicBoolean = this.mStartLock;
            synchronized (atomicBoolean) {
                this.mStartLock.set(true);
                this.mStartLock.notifyAll();
            }
            Looper.loop();
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[CCapture]", "end looper exception:" + t.getMessage() + " " + t.toString());
        }
        finally {
            YMFLog.info(this, "[CCapture]", "end looper!");
        }
    }

    public boolean isHasPermission(Camera camera) {
        try {
            Field fieldPassword = camera.getClass().getDeclaredField("mHasPermission");
            fieldPassword.setAccessible(true);
            return (Boolean)fieldPassword.get(camera);
        }
        catch (Exception e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openCamera(int desiredWidth, int desiredHeight, int desiredFps, CameraUtils.CameraFacing cameraFacing, CameraResolutionMode resMode, int displayRotation) {
        YMFLog.info(this, "[CCapture]", "openCamera desiredWidth:" + desiredWidth + " ,desiredHeight:" + desiredHeight + " cameraFacing:" + (Object)((Object)cameraFacing) + " ,displayRotation:" + displayRotation + " ,resMode:" + (Object)((Object)resMode));
        int result = 0;
        Object object = this.mCameraLock;
        synchronized (object) {
            this.mResolutionMode = resMode;
            this.mDesiredWidth = desiredWidth;
            this.mDesiredHeight = desiredHeight;
            this.mDesiredFps = desiredFps;
            this.mCameraFacing = cameraFacing;
            this.mOriginalCameraFacing = cameraFacing;
            this.mDisplayRotation = displayRotation;
            if (this.mMasterCamera != null) {
                this.releaseCamera(this.mMasterCamera);
            }
            this.mMasterCamera = this.openCamera(desiredWidth, desiredHeight, desiredFps, cameraFacing, this.mResolutionMode, this.mMasterCameraInfo);
            if (this.mMasterCamera == null || !this.isHasPermission(this.mMasterCamera)) {
                if (this.mMasterCamera != null) {
                    this.releaseCamera(this.mMasterCamera);
                }
                this.mIsMasterCameraOpened.set(false);
                return 4;
            }
            this.mIsMasterCameraOpened.set(true);
            Camera.Parameters parameters = this.mMasterCamera.getParameters();
            this.mDefaultMasterFocusMode = parameters.getFocusMode();
            result = 0;
            this.setCameraZoom(this.mMasterCamera, (int)(this.mResumeZoomValue * 100.0f));
            YMFLog.info(this, "[CCapture]", "mDefaultMasterFocusMode:" + this.mDefaultMasterFocusMode);
        }
        if (this.mMasterCamera != null) {
            CameraListener listener = null;
            if (this.mCameraListener != null && (listener = (CameraListener)this.mCameraListener.get()) != null && this.mCameraPreviewSize != null) {
                listener.notifyCameraPreviewParameter(this.mCameraPreviewSize.width, this.mCameraPreviewSize.height, CameraUtils.toAndroidCameraFacing(this.mCameraFacing), this.mResolutionMode);
            }
        }
        return result;
    }

    public void restart(int desiredWidth, int desiredHeight, int desiredFps, CameraUtils.CameraFacing cameraFacing, int displayRotation, CameraResolutionMode resMode) {
        YMFLog.info(this, "[CCapture]", "restart camera... desiredWidth:" + desiredWidth + " ,desiredHeight:" + desiredHeight + " cameraFacing" + (Object)((Object)cameraFacing) + " displayRotation:" + displayRotation);
        boolean isDualCameraOpen = this.mSlaveCamera != null;
        this.releaseCamera();
        this.mCameraFacing = cameraFacing;
        switch (displayRotation) {
            case 0: {
                this.mDisplayRotation = 0;
                break;
            }
            case 1: {
                this.mDisplayRotation = 90;
                break;
            }
            case 2: {
                this.mDisplayRotation = 180;
                break;
            }
            case 3: {
                this.mDisplayRotation = 270;
                break;
            }
        }
        this.openCamera(desiredWidth, desiredHeight, desiredFps, this.mCameraFacing, resMode, this.mDisplayRotation);
        if (isDualCameraOpen) {
            this.openDualCamera(desiredWidth, desiredHeight, desiredFps, this.mDisplayInfo);
        }
    }

    public void restart(int desiredWidth, int desiredHeight, int desiredFps, CameraUtils.CameraFacing cameraFacing, CameraResolutionMode resMode) {
        YMFLog.info(this, "[CCapture]", "restart camera... desiredWidth:" + desiredWidth + " ,desiredHeight:" + desiredHeight + " cameraFacing:" + (Object)((Object)cameraFacing));
        boolean isDualCameraOpen = this.mSlaveCamera != null;
        this.releaseCamera();
        this.openCamera(desiredWidth, desiredHeight, desiredFps, this.mCameraFacing, resMode, this.mDisplayRotation);
        if (isDualCameraOpen) {
            this.openDualCamera(desiredWidth, desiredHeight, desiredFps, this.mDisplayInfo);
        }
    }

    public Camera openCamera(int desiredWidth, int desiredHeight, int desiredFps, CameraUtils.CameraFacing cameraFacing, CameraResolutionMode resMode, Camera.CameraInfo cameraInfo) {
        Camera camera = null;
        YMFLiveStatisticManager.getInstance().reset();
        if (this.mCameraTimer == null) {
            this.mCameraTimer = new Timer();
        }
        try {
            List focusModes;
            if (!CameraUtils.isCameraAvailable(cameraFacing == CameraUtils.CameraFacing.FacingFront ? 1 : 0)) {
                YMFLog.info(this, "[CCapture]", "current facing camera not available, change facing camera.");
                this.mCameraFacing = cameraFacing = cameraFacing == CameraUtils.CameraFacing.FacingFront ? CameraUtils.CameraFacing.FacingBack : CameraUtils.CameraFacing.FacingFront;
            }
            if ((camera = CameraUtils.openCamera(cameraFacing, cameraInfo)) == null) {
                YMFLog.error((Object)this, "[CCapture]", "Unable to open camera");
                return null;
            }
            Camera.Parameters parms = camera.getParameters();
            CameraUtils2.chooseBestAspectPreviewSize(this.mDisplayRotation, desiredWidth, desiredHeight, parms, 0.05, this.mResolutionMode);
            YMFLog.info(this, "[CCapture]", "chooseBestAspectPreviewSize width:" + parms.getPreviewSize().width + ", height:" + parms.getPreviewSize().height);
            CameraUtils.PreviewSize specialSize = CameraUtils.getSpecialCameraPreviewSizeWithModel(Build.MODEL, parms.getPreviewSize(), cameraFacing);
            if (specialSize != null) {
                parms.setPreviewSize(specialSize.width, specialSize.height);
            }
            if ((focusModes = parms.getSupportedFocusModes()).contains("continuous-video")) {
                parms.setFocusMode("continuous-video");
            } else if (focusModes.contains("auto")) {
                parms.setFocusMode("auto");
            }
            if (parms.isAutoWhiteBalanceLockSupported()) {
                parms.setAutoWhiteBalanceLock(false);
            }
            if (parms.isAutoExposureLockSupported()) {
                parms.setAutoExposureLock(false);
            }
            if (Build.VERSION.SDK_INT >= 15 && parms.isVideoStabilizationSupported()) {
                parms.setVideoStabilization(true);
            }
            this.mFocusAreaSupported = CameraUtils.isFocusAreaSupported(parms);
            this.mMeteringAreaSupported = CameraUtils.isMeteringAreaSupported(parms);
            this.mFaceDetectSupported = CameraUtils.isFaceDetectionSupported(parms);
            this.mFaceFocusEnable = false;
            this.mCameraPreviewSize = parms.getPreviewSize();
            this.mPreviewYuvSize = new VideoSizeUtils.Size(this.mCameraPreviewSize.width, this.mCameraPreviewSize.height);
            parms.getPreviewFpsRange(this.mCameraFpsRange);
            YMFLog.info(this, "[CCapture]", "get PreviewFpsRange:" + this.mCameraFpsRange[0] / 1000 + "-" + this.mCameraFpsRange[1] / 1000);
            if (this.mCameraFpsRange[0] <= desiredFps * 1000 && this.mCameraFpsRange[1] >= desiredFps * 1000) {
                try {
                    if (UploadStreamStateParams.mCaptureFpsMode == Constant.CaptureFpsMode.AlignEncoder) {
                        parms.setPreviewFpsRange(this.mCameraFpsRange[0], desiredFps * 1000);
                        YMFLog.info(this, "[CCapture]", "set PreviewFpsRange:" + this.mCameraFpsRange[0] / 1000 + "-" + desiredFps);
                        mSetCameraFpsParams = desiredFps;
                    } else {
                        parms.setPreviewFpsRange(this.mCameraFpsRange[0], this.mCameraFpsRange[1]);
                        mSetCameraFpsParams = this.mCameraFpsRange[1] / 1000;
                        YMFLog.info(this, "[CCapture]", "set PreviewFpsRange:" + this.mCameraFpsRange[0] / 1000 + "-" + this.mCameraFpsRange[1] / 1000);
                    }
                    if (Build.MODEL.equals("SM-G570F")) {
                        parms.setPreviewFpsRange(this.mCameraFpsRange[0], this.mCameraFpsRange[1]);
                    }
                    if (Build.MODEL.equalsIgnoreCase("PBEM00") || Build.MODEL.equalsIgnoreCase("VIVO X21A")) {
                        parms.setPreviewFpsRange(this.mCameraFpsRange[1], this.mCameraFpsRange[1]);
                        YMFLog.info(this, "[CCapture]", "set PreviewFpsRange:" + this.mCameraFpsRange[1] + "-" + this.mCameraFpsRange[1]);
                        mSetCameraFpsParams = this.mCameraFpsRange[1] / 1000;
                    }
                    camera.setParameters(parms);
                }
                catch (Throwable throwable) {
                    YMFLog.info(this, "[CCapture]", "set fps range exception:" + throwable.toString());
                    parms.setPreviewFpsRange(this.mCameraFpsRange[0], this.mCameraFpsRange[1]);
                    mSetCameraFpsParams = -1;
                    YMFLog.info(this, "[CCapture]", "set PreviewFpsRange:" + this.mCameraFpsRange[0] / 1000 + "-" + this.mCameraFpsRange[1] / 1000);
                }
            }
            YMFLog.info(this, "[CCapture]", "getPreviewSize width:" + this.mCameraPreviewSize.width + ", height:" + this.mCameraPreviewSize.height);
            if (this.mDisplayRotation == 0 || this.mDisplayRotation == 180) {
                if (this.mCameraPreviewSize.width > this.mCameraPreviewSize.height) {
                    this.mCameraPreviewSize.height = this.mCameraPreviewSize.width + this.mCameraPreviewSize.height;
                    this.mCameraPreviewSize.width = this.mCameraPreviewSize.height - this.mCameraPreviewSize.width;
                    this.mCameraPreviewSize.height -= this.mCameraPreviewSize.width;
                }
            } else if ((this.mDisplayRotation == 90 || this.mDisplayRotation == 270) && this.mCameraPreviewSize.width < this.mCameraPreviewSize.height) {
                this.mCameraPreviewSize.height = this.mCameraPreviewSize.width + this.mCameraPreviewSize.height;
                this.mCameraPreviewSize.width = this.mCameraPreviewSize.height - this.mCameraPreviewSize.width;
                this.mCameraPreviewSize.height -= this.mCameraPreviewSize.width;
            }
            YMFLog.info(this, "[CCapture]", "openCamera width:" + this.mCameraPreviewSize.width + ", height:" + this.mCameraPreviewSize.height + ", displayRotation:" + this.mDisplayRotation);
            List formats = parms.getSupportedPreviewFormats();
            if (formats.contains(17) && parms.getPreviewFormat() != 17) {
                parms.setPreviewFormat(17);
            }
            this.mPreviewFormat = parms.getPreviewFormat();
            camera.setParameters(parms);
            CameraUtils.setCameraDisplayOrientation(this.mDisplayRotation, camera, cameraInfo);
            this.setMirror(this.mMirror);
            camera.setErrorCallback(this.errorCallback);
            Camera.Parameters parameters = camera.getParameters();
            this.mDefaultMasterFocusMode = parameters.getFocusMode();
        }
        catch (Throwable throwable) {
            YMFLog.error((Object)this, "[CCapture]", "openCamera exception:" + throwable);
            camera = null;
        }
        return camera;
    }

    @Deprecated
    public boolean isDualCameraSupported() {
        return true;
    }

    public int openDualCamera(int desiredWidth, int desiredHeight, int desiredFps, PictureInPictureDisplayInfo info) {
        if (!this.isDualCameraSupported()) {
            YMFLog.error((Object)this, "[CCapture]", "dont support dual camera.");
            return -1;
        }
        YMFLog.info(this, "[CCapture]", "openDualCamera.");
        this.mDisplayInfo = info;
        if (this.mSlaveCamera != null) {
            this.releaseCamera(this.mSlaveCamera);
        }
        int result = 0;
        CameraUtils.CameraFacing facing = this.mCameraFacing == CameraUtils.CameraFacing.FacingFront ? CameraUtils.CameraFacing.FacingBack : CameraUtils.CameraFacing.FacingFront;
        YMFLog.info(this, "[CCapture]", "openDualCamera facing:" + (Object)((Object)facing));
        if (this.getPreviewSize().width > 0 && this.getPreviewSize().height > 0) {
            desiredWidth = this.getPreviewSize().width;
            desiredHeight = this.getPreviewSize().height;
        }
        YMFLog.info(this, "[CCapture]", "openDualCamera desiredWidth:" + desiredWidth + " desiredHeight:" + desiredHeight);
        this.mSlaveCamera = this.openCamera(desiredWidth, desiredHeight, desiredFps, facing, this.mResolutionMode, this.mSlaveCameraInfo);
        if (this.mSlaveCamera != null) {
            Camera.Parameters parameters = this.mSlaveCamera.getParameters();
            this.mDefaultSlaveFocusMode = parameters.getFocusMode();
            YMFLog.info(this, "[CCapture]", "mDefaultSlaveFocusMode:" + this.mDefaultSlaveFocusMode);
        }
        if (this.mSlaveCamera == null) {
            YMFLog.error((Object)this, "[CCapture]", "open rear camera failed.");
            result = -1;
        }
        if (result != -1) {
            CameraListener listener = null;
            if (this.mCameraListener != null && (listener = (CameraListener)this.mCameraListener.get()) != null) {
                listener.onDualOpen(true);
            }
            if (this.mAlreadyAttached.booleanValue() && this.mCameraPreviewSurfaceTextures != null && this.mCameraPreviewSurfaceTextures.get() != null && this.mPreviewFrameAvailableListenerRef != null && this.mPreviewFrameAvailableListenerRef.get() != null) {
                this.setCameraPreviewTexture(this.mSlaveCamera, ((SurfaceTexture[])this.mCameraPreviewSurfaceTextures.get())[1], (SurfaceTexture.OnFrameAvailableListener)this.mPreviewFrameAvailableListenerRef.get());
            }
        }
        if (facing == CameraUtils.CameraFacing.FacingFront) {
            if (this.mMasterCamera != null) {
                this.mMasterCamera.setPreviewCallbackWithBuffer(null);
            }
            this.addCallbackBuffer(this.mSlaveCamera, this.previewCallbackBuffer);
        }
        this.resetPreviewCallBack();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDualCamera() {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.releaseCamera(this.mSlaveCamera);
            this.mSlaveCamera = null;
            this.releaseCamera(this.mMasterCamera);
            this.mMasterCamera = null;
            this.openCamera(this.mDesiredWidth, this.mDesiredHeight, this.mDesiredFps, this.mCameraFacing, this.mResolutionMode, this.mDisplayRotation);
            CameraListener listener = null;
            if (this.mCameraListener != null && (listener = (CameraListener)this.mCameraListener.get()) != null) {
                listener.onDualOpen(false);
            }
        }
    }

    public void switchCamera() {
        this.mFaceFocusEnable = false;
        if (this.isDualCameraSupported() && this.mSlaveCamera != null && this.mMasterCamera != null) {
            CameraListener listener = null;
            if (this.mCameraListener != null && (listener = (CameraListener)this.mCameraListener.get()) != null) {
                listener.onDualPictureSwitch();
            }
            this.mCameraFacing = this.mCameraFacing == CameraUtils.CameraFacing.FacingBack ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack;
        } else {
            if (this.mMasterCamera != null) {
                this.releaseCamera(this.mMasterCamera);
            }
            this.mCameraFacing = this.mCameraFacing == CameraUtils.CameraFacing.FacingBack ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack;
            this.mOriginalCameraFacing = this.mCameraFacing;
            this.mMasterCamera = this.openCamera(this.mDesiredWidth, this.mDesiredHeight, this.mDesiredFps, this.mCameraFacing, this.mResolutionMode, this.mMasterCameraInfo);
            CameraListener listener = null;
            if (this.mCameraListener != null && (listener = (CameraListener)this.mCameraListener.get()) != null && this.mCameraPreviewSize != null) {
                listener.notifyCameraPreviewParameter(this.mCameraPreviewSize.width, this.mCameraPreviewSize.height, CameraUtils.toAndroidCameraFacing(this.mCameraFacing), this.mResolutionMode);
            }
            this.resetPreviewCallBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZoomSupport() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mOriginalCameraFacing == this.mCameraFacing) {
                return this.isZoomSupport(this.mMasterCamera);
            }
            return this.isZoomSupport(this.mSlaveCamera);
        }
    }

    private boolean isZoomSupport(Camera camera) {
        if (camera == null) {
            YMFLog.error((Object)this, "[CCapture]", "camera is null");
            return false;
        }
        try {
            Camera.Parameters param = this.mMasterCamera.getParameters();
            if (param != null && param.isZoomSupported()) {
                List ratios = param.getZoomRatios();
                boolean isZoomSupport = ratios != null && ratios.size() > 0 && ratios.size() == param.getMaxZoom() + 1;
                YMFLog.info(this, "[CCapture]", "isZoomSupport:" + isZoomSupport + ", getZoomRatios:" + ratios);
                return isZoomSupport;
            }
        }
        catch (Throwable throwable) {
            YMFLog.error((Object)this, "[CCapture]", "isZoomSupport exception:" + throwable);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMaxZoom() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mMasterCamera != null) {
                try {
                    Camera.Parameters param = this.mMasterCamera.getParameters();
                    if (param != null) {
                        int maxZoom = param.getMaxZoom();
                        List zoomRatios = param.getZoomRatios();
                        if (zoomRatios != null && zoomRatios.size() > 0 && maxZoom == zoomRatios.size() - 1) {
                            YMFLog.info(this, "[CCapture]", "getMaxZoom:" + maxZoom + "\uff0c maxZoomRatio:" + zoomRatios.get(zoomRatios.size() - 1));
                            float ret = (float)((Integer)zoomRatios.get(maxZoom)).intValue() / 100.0f;
                            if ((this.mDeviceBrand.contains("oppo") || this.mDeviceBrand.contains("vivo")) && ret > 5.0f) {
                                ret = 5.0f;
                            }
                            return ret;
                        }
                    }
                }
                catch (Throwable throwable) {
                    YMFLog.error((Object)this, "[CCapture]", "getMaxZoom exceptiion:" + throwable);
                }
            }
        }
        return 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float setZoom(int zoom) {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.mResumeZoomValue = this.mOriginalCameraFacing == this.mCameraFacing ? this.setCameraZoom(this.mMasterCamera, zoom) : this.setCameraZoom(this.mSlaveCamera, zoom);
            return this.mResumeZoomValue;
        }
    }

    private float setCameraZoom(Camera camera, int zoom) {
        if (camera == null) {
            YMFLog.error((Object)this, "[CCapture]", "camera is null");
            return 5.0f;
        }
        try {
            List zoomRatios;
            Camera.Parameters param = camera.getParameters();
            if (param != null && (zoomRatios = param.getZoomRatios()) != null && zoom >= 0) {
                int z;
                int zoomIdx;
                Iterator iterator = zoomRatios.iterator();
                for (zoomIdx = 0; iterator.hasNext() && (z = ((Integer)iterator.next()).intValue()) < zoom && zoomIdx != zoomRatios.size() - 1; ++zoomIdx) {
                }
                if (zoomIdx != param.getZoom()) {
                    param.setZoom(zoomIdx);
                    camera.setParameters(param);
                }
                float zoomRatio = ((Integer)zoomRatios.get(zoomIdx)).intValue();
                YMFLog.info(this, "[CCapture]", "setZoom:" + zoom + ", zoomidx: " + zoomIdx + ", zoomRatio:" + zoomRatio);
                return zoomRatio / 100.0f;
            }
        }
        catch (Throwable throwable) {
            YMFLog.error((Object)this, "[CCapture]", "setZoom exception:" + throwable.toString());
        }
        return 1.0f;
    }

    public void switchCameraFacing() {
        if (this.mMasterCamera != null) {
            this.mCameraFacing = this.mCameraFacing == CameraUtils.CameraFacing.FacingBack ? CameraUtils.CameraFacing.FacingFront : CameraUtils.CameraFacing.FacingBack;
            YMFLog.info(this, "[CCapture]", "switchCameraFacing:" + (Object)((Object)this.mCameraFacing));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTorchSupported() {
        Object object = this.mCameraLock;
        synchronized (object) {
            Camera.Parameters params = null;
            if (this.mOriginalCameraFacing == CameraUtils.CameraFacing.FacingFront) {
                if (this.mSlaveCamera != null) {
                    params = this.mSlaveCamera.getParameters();
                }
            } else if (this.mMasterCamera != null) {
                params = this.mMasterCamera.getParameters();
            }
            return CameraUtils.isTorchSupported(params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCameraFlashMode(boolean enable) {
        boolean ret = false;
        Object object = this.mCameraLock;
        synchronized (object) {
            YMFLog.info(this, "[CCapture]", "setCameraFlashMode.");
            ret = this.mOriginalCameraFacing == CameraUtils.CameraFacing.FacingFront ? this.setCameraFlashMode(this.mSlaveCamera, enable) : this.setCameraFlashMode(this.mMasterCamera, enable);
        }
        return ret;
    }

    private boolean setCameraFlashMode(Camera camera, boolean enable) {
        boolean ret = false;
        if (camera != null) {
            try {
                Camera.Parameters params = camera.getParameters();
                if (CameraUtils.isTorchSupported(params)) {
                    params.setFlashMode(enable ? "torch" : "off");
                    camera.setParameters(params);
                    this.isFlashOn = enable;
                    ret = true;
                }
            }
            catch (Throwable throwable) {
                YMFLog.error((Object)this, "[CCapture]", "setCameraFlashMode exception:" + throwable);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCamera() {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.releaseCamera(this.mMasterCamera);
            this.mMasterCamera = null;
            this.releaseCamera(this.mSlaveCamera);
            this.mSlaveCamera = null;
            this.mIsMasterCameraOpened.set(false);
        }
        CameraListener listener = null;
        if (this.mCameraListener != null && (listener = (CameraListener)this.mCameraListener.get()) != null) {
            listener.onDualOpen(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int releaseCamera(Camera camera) {
        Object object = this.mCameraLock;
        synchronized (object) {
            boolean exceptionHappened = false;
            if (this.mCameraTimer != null) {
                this.mCameraTimer.cancel();
                this.mCameraTimer = null;
            }
            if (this.mMeteringTimerTask != null) {
                this.mMeteringTimerTask.cancel();
                this.mMeteringTimerTask = null;
            }
            if (this.mFocusTimerTask != null) {
                this.mFocusTimerTask.cancel();
                this.mFocusTimerTask = null;
            }
            if (camera != null) {
                try {
                    camera.stopPreview();
                    camera.setPreviewCallbackWithBuffer(null);
                    CameraUtils.setCameraBufferHashCode(0L);
                    camera.release();
                    camera = null;
                    mSetCameraFpsParams = 0;
                    this.mAlreadyAttached = false;
                    YMFLog.info(this, "[CCapture]", "releaseCamera done " + this.mAlreadyAttached);
                }
                catch (Throwable throwable) {
                    exceptionHappened = true;
                    YMFLog.error((Object)this, "[CCapture]", "releaseCamera exception:" + throwable);
                }
            }
            return exceptionHappened ? -1 : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPreviewWithSurfaceTexture(SurfaceTexture[] surfaces, SurfaceTexture.OnFrameAvailableListener listener) {
        YMFLog.info(this, "[CCapture]", "startPreviewWithSurfaceTexture mCameraFacing:" + (Object)((Object)this.mCameraFacing) + " surfaces[0]:" + surfaces[0]);
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mMasterCamera == null || this.mAlreadyAttached.booleanValue()) {
                YMFLog.error((Object)this, "[CCapture]", "master camera not available, should openCamera first or is preview:" + this.mAlreadyAttached);
                return;
            }
            this.setCameraPreviewTexture(this.mMasterCamera, surfaces[0], listener);
            this.mCameraPreviewSurfaceTextures = new WeakReference<SurfaceTexture[]>(surfaces);
            this.mPreviewFrameAvailableListenerRef = new WeakReference<SurfaceTexture.OnFrameAvailableListener>(listener);
            this.mAlreadyAttached = true;
            if (this.mSlaveCamera == null) {
                YMFLog.info(this, "[CCapture]", "slave camera not available, should openCamera first!");
                return;
            }
            this.setCameraPreviewTexture(this.mSlaveCamera, surfaces[1], listener);
        }
    }

    private void setCameraPreviewTexture(Camera camera, SurfaceTexture surfaces, SurfaceTexture.OnFrameAvailableListener listener) {
        try {
            if (camera == null) {
                YMFLog.error((Object)this, "[CCapture]", "camera not available, should openCamera first!");
                return;
            }
            surfaces.setOnFrameAvailableListener(listener);
            camera.setPreviewTexture(surfaces);
            camera.startPreview();
            if (this.mFaceFocusRestart) {
                this.setCameraAutoFocusFaceModeEnabled(true);
                this.mFaceFocusRestart = false;
            }
        }
        catch (Throwable throwable) {
            YMFLog.error((Object)this, "[CCapture]", "setCameraPreviewTexture exception:" + throwable.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallbackBuffer(byte[] callbackBuffer) {
        if (callbackBuffer == null) {
            YMFLog.error((Object)this, "[CCapture]", "invalid callbackBuffer");
            return;
        }
        this.previewCallbackBuffer = new WeakReference<byte[]>(callbackBuffer);
        Object object = this.mCameraLock;
        synchronized (object) {
            if (callbackBuffer.length == 0 || callbackBuffer.length != this.getCurrentPreviewBufferSize()) {
                YMFLog.error((Object)this, "[CCapture]", "invalid callbackBuffer");
                return;
            }
            if (this.mSlaveCamera != null && this.mOriginalCameraFacing == CameraUtils.CameraFacing.FacingBack) {
                this.mSlaveCamera.addCallbackBuffer(callbackBuffer);
                CameraUtils.setCameraBufferHashCode(callbackBuffer.hashCode());
            } else {
                this.mMasterCamera.addCallbackBuffer(callbackBuffer);
                CameraUtils.setCameraBufferHashCode(callbackBuffer.hashCode());
            }
        }
    }

    private void addCallbackBuffer(Camera camera, WeakReference<byte[]> callbackBuffer) {
        if (camera != null && callbackBuffer != null && callbackBuffer.get() != null && ((byte[])callbackBuffer.get()).length != 0 && ((byte[])callbackBuffer.get()).length == this.getCurrentPreviewBufferSize()) {
            camera.addCallbackBuffer((byte[])callbackBuffer.get());
            CameraUtils.setCameraBufferHashCode(((byte[])callbackBuffer.get()).hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviewCallbackWithBuffer(Camera.PreviewCallback previewCallback) {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mSlaveCamera != null && this.mOriginalCameraFacing == CameraUtils.CameraFacing.FacingBack) {
                if (this.mCameraFacing == CameraUtils.CameraFacing.FacingFront) {
                    this.mMasterCamera.setPreviewCallbackWithBuffer(null);
                    this.setPreviewCallbackWithBuffer(this.mSlaveCamera, previewCallback);
                }
            } else {
                this.setPreviewCallbackWithBuffer(this.mMasterCamera, previewCallback);
            }
        }
    }

    private void setPreviewCallbackWithBuffer(Camera camera, Camera.PreviewCallback previewCallback) {
        if (camera == null) {
            YMFLog.error((Object)this, "[CCapture]", "invalid camera.");
            return;
        }
        int width = this.mCameraPreviewSize.width;
        int height = this.mCameraPreviewSize.height;
        int buffSize = width * height * ImageFormat.getBitsPerPixel((int)17) / 8;
        for (int i = 0; i < 3; ++i) {
            byte[] buffer = new byte[buffSize];
            camera.addCallbackBuffer(buffer);
            CameraUtils.setCameraBufferHashCode(buffer.hashCode());
        }
        camera.setPreviewCallbackWithBuffer(previewCallback);
        this.mPreviewCallbackRef = new WeakReference<Camera.PreviewCallback>(previewCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviewCallback(Camera.PreviewCallback previewCallback) {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mSlaveCamera != null && this.mOriginalCameraFacing == CameraUtils.CameraFacing.FacingBack) {
                this.mSlaveCamera.setPreviewCallback(previewCallback);
                this.mMasterCamera.setPreviewCallback(null);
                this.mPreviewCallbackRef = new WeakReference<Camera.PreviewCallback>(previewCallback);
            } else if (this.mMasterCamera != null) {
                this.mMasterCamera.setPreviewCallback(previewCallback);
                this.mPreviewCallbackRef = new WeakReference<Camera.PreviewCallback>(previewCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reattachPreviewSurfaceTexture() {
        YMFLog.info(this, "[CCapture]", "reattachPreviewSurfaceTexture");
        String errMsg = null;
        CameraInterface cameraInterface = this;
        synchronized (cameraInterface) {
            SurfaceTexture.OnFrameAvailableListener listener;
            SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener = listener = this.mPreviewFrameAvailableListenerRef != null ? (SurfaceTexture.OnFrameAvailableListener)this.mPreviewFrameAvailableListenerRef.get() : null;
            if (listener == null) {
                errMsg = "reattachPreviewSurfaceTexture error! mCameraPreviewSurfaceTextures get null";
            } else {
                SurfaceTexture[] textures;
                SurfaceTexture[] surfaceTextureArray = textures = this.mCameraPreviewSurfaceTextures != null ? (SurfaceTexture[])this.mCameraPreviewSurfaceTextures.get() : null;
                if (textures == null) {
                    errMsg = "reattachPreviewSurfaceTexture error! mCameraPreviewSurfaceTextures get null";
                } else {
                    this.startPreviewWithSurfaceTexture(textures, listener);
                    return;
                }
            }
        }
        YMFLog.error((Object)this, "[CCapture]", "reattachPreviewSurfaceTexture exception:" + (errMsg == null ? "unknown" : errMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reSetPreviewSurfaceTexture(SurfaceTexture[] oldTextures) {
        CameraInterface cameraInterface = this;
        synchronized (cameraInterface) {
            SurfaceTexture[] textures;
            SurfaceTexture[] surfaceTextureArray = textures = this.mCameraPreviewSurfaceTextures != null ? (SurfaceTexture[])this.mCameraPreviewSurfaceTextures.get() : null;
            if (textures != null && textures[0].equals(oldTextures[0])) {
                this.mCameraPreviewSurfaceTextures = null;
                this.mPreviewFrameAvailableListenerRef = null;
                YMFLog.info(this, "[CCapture]", "clean reattachPreviewSurfaceTexture WeakReference:" + oldTextures[0]);
            }
        }
    }

    public void resetPreviewCallBack() {
        YMFLog.info(this, "[CCapture]", "resetPreviewCallBack");
        if (this.mPreviewCallbackRef != null && this.mPreviewCallbackRef.get() != null) {
            this.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this.mPreviewCallbackRef.get());
        } else {
            YMFLog.error((Object)this, "[CCapture]", "resetPreviewCallBack error! mPreviewCallbackRef:" + this.mCameraPreviewSurfaceTextures);
        }
    }

    public Camera.Size getPreviewSize() {
        return this.mCameraPreviewSize;
    }

    public VideoSizeUtils.Size getPreviewYuvSize() {
        return this.mPreviewYuvSize;
    }

    public int getPreviewFormat() {
        return this.mPreviewFormat;
    }

    public CameraUtils.CameraFacing getCameraFacing() {
        return this.mCameraFacing;
    }

    public int getOrginalCameraFacing() {
        if (this.mOriginalCameraFacing == CameraUtils.CameraFacing.FacingFront) {
            return 1;
        }
        return 0;
    }

    public CameraResolutionMode getResolutionMode() {
        return this.mResolutionMode;
    }

    public int getAndroidCameraFacing() {
        if (this.mCameraFacing == CameraUtils.CameraFacing.FacingFront) {
            return 1;
        }
        return 0;
    }

    public boolean isCameraOpened() {
        return this.mIsMasterCameraOpened.get();
    }

    public Camera.CameraInfo getCameraInfo() {
        if (this.mSlaveCamera != null && this.mOriginalCameraFacing == CameraUtils.CameraFacing.FacingBack) {
            return this.mSlaveCameraInfo;
        }
        return this.mMasterCameraInfo;
    }

    public int getDisplayRotation() {
        return this.mDisplayRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentPreviewBufferSize() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mMasterCamera != null && this.mCameraPreviewSize != null) {
                return this.mCameraPreviewSize.width * this.mCameraPreviewSize.height * ImageFormat.getBitsPerPixel((int)17) / 8;
            }
        }
        return 0;
    }

    public PictureInPictureDisplayInfo getPictureInPictureDisplayInfo() {
        return this.mDisplayInfo;
    }

    public void setFocusListen(FocusListener listener) {
        this.mFocusListener = listener;
    }

    private int setFocusMetering(int x, int y) {
        int ret;
        block16: {
            ret = 0;
            this.mMirror = this.mCameraFacing == CameraUtils.CameraFacing.FacingFront;
            this.mCurrentFocusArea = null;
            if (this.mMeteringTimerTask != null) {
                this.mMeteringTimerTask.cancel();
                this.mMeteringTimerTask = null;
            }
            if (this.mFocusTimerTask != null) {
                this.mFocusTimerTask.cancel();
                this.mFocusTimerTask = null;
            }
            final Camera meteringCamera = this.mSlaveCamera == null || this.mCameraFacing == this.mOriginalCameraFacing ? this.mMasterCamera : this.mSlaveCamera;
            this.setCameraAutoFocusFaceModeEnabled(false);
            try {
                if (meteringCamera != null) {
                    List focusModes;
                    final Camera.Parameters params = meteringCamera.getParameters();
                    this.mFocusAreaSupported = CameraUtils.isFocusAreaSupported(params);
                    this.mMeteringAreaSupported = CameraUtils.isMeteringAreaSupported(params);
                    this.setMatrix();
                    if (this.mFocusArea != null || this.mMeteringArea != null) {
                        this.resetFocusMeteringArea(meteringCamera);
                    }
                    meteringCamera.cancelAutoFocus();
                    if (this.mFocusAreaSupported) {
                        this.mFocusArea = new ArrayList<Camera.Area>();
                        this.mFocusArea.add(new Camera.Area(new android.graphics.Rect(), 1000));
                        this.calculateTapArea(x, y, 1.0f, this.mFocusArea.get((int)0).rect);
                        params.setFocusAreas(this.mFocusArea);
                    } else {
                        YMFLog.warn(this, "[CCapture]", "focus areas not supported");
                    }
                    if (this.mMeteringAreaSupported) {
                        if (this.mMeteringArea == null) {
                            this.mMeteringArea = new ArrayList<Camera.Area>();
                            this.mMeteringArea.add(new Camera.Area(new android.graphics.Rect(), 800));
                            this.calculateTapArea(x, y, 1.0f, this.mMeteringArea.get((int)0).rect);
                            params.setMeteringAreas(this.mMeteringArea);
                        }
                    } else {
                        YMFLog.warn(this, "[CCapture]", "metering areas not supported");
                    }
                    if ((focusModes = params.getSupportedFocusModes()).contains("auto")) {
                        params.setFocusMode("auto");
                        YMFLog.info(this, "[CCapture]", "set FOCUS_MODE_AUTO, " + this.mDeviceName);
                    }
                    meteringCamera.setParameters(params);
                    if (this.mFocusAreaSupported && meteringCamera != null && this.mPreviewCallbackRef != null) {
                        try {
                            meteringCamera.autoFocus((Camera.AutoFocusCallback)this.mAutoFocusCallback);
                            ret = 0;
                        }
                        catch (Exception e) {
                            ret = -1;
                            YMFLog.error((Object)this, "[CCapture]", "auto focus error!");
                        }
                    }
                    if ((this.mDeviceName.toLowerCase().contains("oppo") || this.mDeviceName.toLowerCase().contains("vivo")) && this.mCameraTimer != null) {
                        this.mMeteringTimerTask = new TimerTask(){

                            @Override
                            public void run() {
                                YMFLog.info(this, "[CCapture]", "reset metering area to null...");
                                try {
                                    params.setMeteringAreas(null);
                                    meteringCamera.setParameters(params);
                                }
                                catch (RuntimeException e) {
                                    YMFLog.error((Object)this, "[CCapture]", "meteringCamera setParameters not supported:" + params.flatten());
                                    YMFLog.error((Object)this, "[CCapture]", "meteringCamera setParameters exception:" + e.getMessage());
                                }
                            }
                        };
                        this.mCameraTimer.schedule(this.mMeteringTimerTask, 20000L);
                    }
                    break block16;
                }
                ret = -1;
            }
            catch (Exception e) {
                ret = -1;
                YMFLog.warn(this, "[CCapture]", "handleFocusMetering exception: " + e.getMessage());
            }
        }
        return ret;
    }

    public int setCameraFocusPosition(float posX, float posY) {
        int y;
        int x = Math.round(posX);
        int ret = this.setFocusMetering(x, y = Math.round(posY));
        if (ret == 0) {
            CameraListener listener = null;
            if (this.mCameraListener != null && (listener = (CameraListener)this.mCameraListener.get()) != null) {
                try {
                    Iterator<Camera.Area> iterator = this.mFocusArea.iterator();
                    if (iterator.hasNext()) {
                        Camera.Area area = iterator.next();
                        RectF viewRect = new RectF(area.rect);
                        this.mMatrixDriveToView.mapRect(viewRect);
                        Rect rect = new Rect(viewRect.left, viewRect.top, viewRect.right, viewRect.bottom);
                        listener.onCameraFocusAreaChanged(rect);
                    }
                }
                catch (Exception ex) {
                    YMFLog.error((Object)this, "[CCapture]", "setCameraFocusPosition exception:" + ex.toString());
                }
            }
        }
        return ret;
    }

    public int setCameraExposurePosition(float posX, float posY) {
        int y;
        int x = Math.round(posX);
        int ret = this.setFocusMetering(x, y = Math.round(posY));
        if (ret == 0) {
            CameraListener listener = null;
            if (this.mCameraListener != null && (listener = (CameraListener)this.mCameraListener.get()) != null) {
                try {
                    Iterator<Camera.Area> iterator = this.mMeteringArea.iterator();
                    if (iterator.hasNext()) {
                        Camera.Area area = iterator.next();
                        RectF viewRect = new RectF(area.rect);
                        this.mMatrixDriveToView.mapRect(viewRect);
                        Rect rect = new Rect(viewRect.left, viewRect.top, viewRect.right, viewRect.bottom);
                        listener.onCameraExposureAreaChanged(rect);
                    }
                }
                catch (Exception ex) {
                    YMFLog.error((Object)this, "[CCapture]", "setCameraExposurePosition exception:" + ex.toString());
                }
            }
        }
        return ret;
    }

    public void handleFocusMetering(MotionEvent event) {
        int x = Math.round(event.getX());
        int y = Math.round(event.getY());
        this.setFocusMetering(x, y);
    }

    private void resetFocusMeteringArea(Camera camera) {
        this.mFocusArea = null;
        this.mMeteringArea = null;
        if (camera != null) {
            YMFLog.info(this, "[CCapture]", "resetFocusMeteringArea");
            Camera.Parameters params = camera.getParameters();
            if (this.mFocusAreaSupported) {
                params.setFocusAreas(this.mFocusArea);
            }
            if (this.mMeteringAreaSupported) {
                params.setMeteringAreas(this.mMeteringArea);
            }
            camera.setParameters(params);
        }
    }

    private void calculateTapArea(int x, int y, float areaMultiple, android.graphics.Rect rect) {
        int areaHeight;
        int areaWidth;
        if (this.mDeviceName.contains("vivo") || this.mDeviceName.contains("oppo")) {
            areaWidth = (int)(300.0f * areaMultiple);
            areaHeight = (int)(300.0f * areaMultiple);
        } else {
            areaWidth = (int)(300.0f * areaMultiple);
            areaHeight = (int)(300.0f * areaMultiple);
        }
        int left = CameraUtils.clamp(x - areaWidth / 2, 0, this.mSurfaceViewWidth - areaWidth);
        int top = CameraUtils.clamp(y - areaHeight / 2, 0, this.mSurfaceViewHeight - areaHeight);
        RectF rectF = new RectF((float)left, (float)top, (float)(left + areaWidth), (float)(top + areaHeight));
        this.mMatrix.mapRect(rectF);
        CameraUtils.rectFToRect(rectF, rect);
    }

    public void setSurfaceViewSize(int viewWidth, int viewHeight) {
        YMFLog.info(this, "[CCapture]", "setSurfaceViewSize...");
        if (this.mSurfaceViewWidth != viewWidth || this.mSurfaceViewHeight != viewHeight) {
            this.mSurfaceViewWidth = viewWidth;
            this.mSurfaceViewHeight = viewHeight;
            this.setMatrix();
        }
    }

    private void setMirror(boolean mirror) {
        this.mMirror = mirror;
        this.setMatrix();
    }

    private void setMatrix() {
        if (this.mSurfaceViewWidth != 0 && this.mSurfaceViewHeight != 0) {
            Matrix matrix = new Matrix();
            CameraUtils.prepareMatrix(matrix, this.mMirror, this.mRotation, this.mSurfaceViewWidth, this.mSurfaceViewHeight);
            this.mMatrixDriveToView = matrix;
            matrix.invert(this.mMatrix);
        }
    }

    public void setRotation(int result) {
        this.mRotation = result;
    }

    public int getRotation() {
        return this.mRotation;
    }

    public int getDesiredFps() {
        return this.mDesiredFps;
    }

    public String getSettingDPI() {
        return this.mDesiredWidth + "x" + this.mDesiredHeight;
    }

    public int getCameraPreviewDesiredWidth() {
        return this.mDesiredWidth;
    }

    public int getCameraPreviewDesiredHeight() {
        return this.mDesiredHeight;
    }

    public boolean post(Runnable task) {
        boolean ret = false;
        try {
            if (this.mHandler.getLooper() != null) {
                ret = this.mHandler.post(task);
            }
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[CCapture]", "CameraInterfaceHandle PostRunnable exception:" + t.toString());
        }
        return ret;
    }

    public boolean isCameraManualFocusPositionSupported() {
        return this.mFocusAreaSupported;
    }

    public boolean isCameraManualExposurePositionSupported() {
        return this.mMeteringAreaSupported;
    }

    public boolean isCameraAutoFocusFaceModeSupported() {
        return this.mFaceDetectSupported;
    }

    public int setCameraAutoFocusFaceModeEnabled(boolean enable) {
        Camera camera = null;
        camera = this.mSlaveCamera == null || this.mCameraFacing == this.mOriginalCameraFacing ? this.mMasterCamera : this.mSlaveCamera;
        if (camera != null) {
            try {
                if (this.isCameraAutoFocusFaceModeSupported()) {
                    if (!enable) {
                        if (this.mFaceFocusEnable) {
                            camera.setFaceDetectionListener(null);
                            camera.stopFaceDetection();
                            this.mFaceFocusEnable = false;
                        }
                    } else if (!this.mFaceFocusEnable) {
                        this.mMirror = this.mCameraFacing == CameraUtils.CameraFacing.FacingFront;
                        this.setMirror(this.mMirror);
                        this.mCurrentFocusArea = null;
                        camera.setFaceDetectionListener(this.mFaceDetectListener);
                        camera.startFaceDetection();
                        this.mFaceFocusEnable = true;
                    }
                }
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mFaceFocusEnable = false;
                return -1;
            }
        }
        return -1;
    }

    public void resumeCameraAutoFocusFace(boolean focused) {
        YMFLog.info(this, "[CCapture]", "resume focus: " + this.mFaceFocusEnable);
        this.mFaceFocusRestart = focused & this.mFaceFocusEnable;
    }

    public void changeCurZoomValue(float zoom) {
        this.mResumeZoomValue = zoom;
    }

    static {
        mSetCameraFpsParams = 0;
    }

    private static class CameraInterfaceHandler
    extends Handler {
        private WeakReference<CameraInterface> mWeakWay;

        private CameraInterfaceHandler(CameraInterface cameraInterface) {
            this.mWeakWay = new WeakReference<CameraInterface>(cameraInterface);
        }

        public void handleMessage(Message msg) {
            int what = msg.what;
            if (0 == what) {
                Looper loop = Looper.myLooper();
                if (null != loop) {
                    loop.quit();
                    this.removeCallbacksAndMessages(null);
                    YMFLog.info((Object)this, "[CCapture]", "message quit");
                }
                return;
            }
            CameraInterface cameraInterface = (CameraInterface)this.mWeakWay.get();
            if (cameraInterface == null) {
                YMFLog.warn((Object)this, "[CCapture]", "handleMessage: stateManager is null");
                return;
            }
        }
    }

    private final class AutoFocusCallback
    implements Camera.AutoFocusCallback {
        private AutoFocusCallback() {
        }

        public void onAutoFocus(boolean focused, final Camera camera) {
            YMFLog.info(this, "[CCapture]", "onAutoFocus...focused:" + focused);
            if (CameraInterface.this.mFocusListener != null) {
                CameraInterface.this.mFocusListener.focusResult(focused);
            }
            if (CameraInterface.this.mCameraTimer != null) {
                CameraInterface.this.mFocusTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        CameraInterface.getInstance().post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    YMFLog.info(this, "[CCapture]", "reset camera focus mode:" + CameraInterface.this.mDefaultMasterFocusMode);
                                    Camera.Parameters params = camera.getParameters();
                                    params.setFocusMode(CameraInterface.this.mDefaultMasterFocusMode);
                                    camera.setParameters(params);
                                }
                                catch (Exception ex) {
                                    YMFLog.error((Object)this, "[CCapture]", "onAutoFocus exception:" + ex.toString());
                                }
                            }
                        });
                    }
                };
                CameraInterface.this.mCameraTimer.schedule(CameraInterface.this.mFocusTimerTask, 3000L);
            }
        }
    }

    public static interface FocusListener {
        public void focusResult(boolean var1);
    }

    public static enum CameraResolutionMode {
        CAMERA_RESOLUTION_PRECISE_MODE,
        CAMERA_RESOLUTION_RANGE_MODE;

    }
}

