/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework;

import android.content.Context;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.api.YMFEncoderStatisticInfo;
import com.yy.mediaframework.api.YMFVideoEncodeFrame;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.YMFLowStreamEncoderConfig;
import com.yy.mediaframework.base.YYUserLiveConfig;
import com.yy.mediaframework.filters.GPUPreprocessFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.VideoEncoderGroupFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.inteligence.dynamictexture.IDynamicTexture;
import com.yy.mediaframework.stat.UploadStatManager;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractLiveSession
implements IEncoderListener,
ILiveSession {
    public GPUPreprocessFilter mPreprocessFilter = null;
    public VideoEncoderGroupFilter mEncoderGroupFilter = null;
    public VideoLiveFilterContext mFilterContext = null;
    private WeakReference<IEncoderListener> mEncoderListener = new WeakReference<Object>(null);
    private AtomicBoolean mHardwareEncoderAvailable = new AtomicBoolean(true);
    private long mLastCountTime = 0L;

    public AbstractLiveSession(Context context) {
        YMFLog.info(this, "[Procedur]", "AbstractLiveSession construct begin");
        this.mFilterContext = new VideoLiveFilterContext(context, Constant.VideoStreamType.Undef);
        this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_SCREEN_RECORD);
        this.mFilterContext.setAndroidContext(context);
        this.mPreprocessFilter = new GPUPreprocessFilter(this.mFilterContext);
        this.mEncoderGroupFilter = new VideoEncoderGroupFilter(this.mFilterContext, this);
        this.mEncoderGroupFilter.setEncoderListener(this);
        this.mFilterContext.getGlManager().registerFilter(this.mPreprocessFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEncoderGroupFilter);
        YMFLog.info(this, "[Procedur]", "AbstractLiveSession construct done");
    }

    @Override
    public void stopAndRelease() {
        YMFLog.info(this, "[Procedur]", "AbstractLiveSession stopAndRelease begin");
        this.mFilterContext.getGLManager().getHandler().removeCallbacksAndMessages(null);
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                if (AbstractLiveSession.this.mFilterContext.getScreenShot() != null) {
                    AbstractLiveSession.this.mFilterContext.getScreenShot().deInit();
                }
                if (AbstractLiveSession.this.mFilterContext.getDynamicTexture() != null) {
                    AbstractLiveSession.this.mFilterContext.getDynamicTexture().onRelease();
                    AbstractLiveSession.this.mFilterContext.setDynamicTexture(null);
                }
                if (AbstractLiveSession.this.mFilterContext.getWaterMarkTexture() != null) {
                    AbstractLiveSession.this.mFilterContext.getWaterMarkTexture().destroy();
                    AbstractLiveSession.this.mFilterContext.setWaterMarkTexture(null);
                }
                UploadStatManager.getInstance().stopStat();
                AbstractLiveSession.this.mFilterContext.getGLManager().quit();
            }
        });
        YMFLog.info(this, "[Procedur]", "AbstractLiveSession stopAndRelease done");
    }

    @Override
    public void startEncoder() {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                YYUserLiveConfig userLiveConfig = AbstractLiveSession.this.mFilterContext.getUserLiveConfig();
                if (AbstractLiveSession.this.mEncoderGroupFilter.isEnable()) {
                    YMFLog.info(this, "[Encoder ]", "encoder is started already!!");
                } else {
                    boolean res = AbstractLiveSession.this.mEncoderGroupFilter.startEncode(AbstractLiveSession.this.mFilterContext.getVideoEncoderConfig());
                    if (res) {
                        UploadStatManager.getInstance().startStat();
                    }
                }
            }
        });
    }

    @Override
    public void stopEncoder() {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                UploadStatManager.getInstance().stopStat();
                if (AbstractLiveSession.this.mEncoderGroupFilter.isEnable()) {
                    AbstractLiveSession.this.mEncoderGroupFilter.stopEncode();
                }
            }
        });
    }

    public void setWaterMark(final WaterMark waterMark) {
        YMFLog.info(this, "[Beauty  ]", "setWaterMark, waterMark==null? " + (waterMark == null ? "y" : "n"));
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                AbstractLiveSession.this.mFilterContext.setWaterMarkTexture(waterMark);
            }
        });
    }

    @Override
    public void setDynamicTexture(final IDynamicTexture dynamicTexture) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                AbstractLiveSession.this.mFilterContext.setDynamicTexture(dynamicTexture);
            }
        });
    }

    @Override
    public void setNetworkBitrateSuggest(final int bitrate) {
        YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitrate);
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                AbstractLiveSession.this.mEncoderGroupFilter.setNetworkBitrateSuggest(bitrate);
            }
        });
    }

    @Override
    public void setResolutionModifyConfigs(List<ResolutionModifyConfig> configs, int intervalSecs) {
    }

    @Override
    public void setEncoderListener(IEncoderListener listener) {
        YMFLog.info(this, "[Encoder ]", "setEncoderListener:" + listener);
        this.mEncoderListener = new WeakReference<IEncoderListener>(listener);
        if (listener != null) {
            listener.onEncodeEncParam(this.mFilterContext.getEncodeParamTipsMgr().getParam());
        }
    }

    @Override
    public void setEncoderConfig(final VideoEncoderConfig config) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                boolean lowDelay = AbstractLiveSession.this.mFilterContext.getVideoEncoderConfig().mLowDelay;
                AbstractLiveSession.this.mFilterContext.getVideoEncoderConfig().assign(config);
                AbstractLiveSession.this.mFilterContext.getVideoEncoderConfig().mLowDelay = lowDelay;
                YMFLog.info(this, "[Encoder ]", "setEncoderConfig:" + AbstractLiveSession.this.mFilterContext.getVideoEncoderConfig().toString());
                AbstractLiveSession.this.mFilterContext.getDefaultVideoEncoderConfig().assign(config);
                AbstractLiveSession.this.mPreprocessFilter.init(config.getEncodeWidth(), config.getEncodeHeight());
                AbstractLiveSession.this.mEncoderGroupFilter.init();
            }
        });
    }

    @Override
    public void setLowStreamEncoderConfigs(final List<YMFLowStreamEncoderConfig> lowStreamConfigs, final boolean enable) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                AbstractLiveSession.this.mFilterContext.setLowStreamEncoderConfigs(lowStreamConfigs);
                AbstractLiveSession.this.mFilterContext.enableLowStreamEncoder(enable);
            }
        });
    }

    @Override
    public void setLowDelayMode(final boolean enable) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                AbstractLiveSession.this.mFilterContext.getVideoEncoderConfig().mLowDelay = enable;
                YMFLog.info(this, "[Encoder ]", "setLowDelayMode:" + enable + " config:" + AbstractLiveSession.this.mFilterContext.getVideoEncoderConfig().toString());
            }
        });
    }

    @Override
    public void requestIFrame() {
        YMFLog.info(this, "[Encoder ]", "requestIFrame");
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                if (AbstractLiveSession.this.mEncoderGroupFilter != null) {
                    AbstractLiveSession.this.mEncoderGroupFilter.requestSyncFrame();
                }
            }
        });
    }

    @Override
    public void adjustEncoderBitrate(int bitRate) {
        if (this.mEncoderGroupFilter != null) {
            YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitRate);
            this.mEncoderGroupFilter.adjustBitRate((bitRate + 999) / 1000);
        }
    }

    @Override
    public void onEncodeStat(YMFEncoderStatisticInfo info) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeStat(info);
        }
    }

    @Override
    public void onEncodeResolution(int streamId, int width, int height) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeResolution(streamId, width, height);
        }
    }

    @Override
    public void onEncodeFirstFrame() {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeFirstFrame();
        }
    }

    @Override
    public void onEncodeFrameData(YMFVideoEncodeFrame videoEncodeFrame) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (System.currentTimeMillis() - this.mLastCountTime >= 6000L) {
            this.mLastCountTime = System.currentTimeMillis();
            YMFLog.info(this, "[Encoder ]", "onEncodeFrameData, listener:" + listener);
        }
        if (listener != null) {
            listener.onEncodeFrameData(videoEncodeFrame);
        }
    }

    @Override
    public void onEncodeEncParam(String param) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeEncParam(param);
        }
    }

    @Override
    public void onEncoderSwitch() {
        YMFLog.info(this, "[Encoder ]", "encoder switch in AbstractLiveSession");
    }

    @Override
    public void onHardEncoderError() {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onHardEncoderError();
        }
    }

    @Override
    public void onWaterMarkSizeChange(int w, int h) {
    }

    public void setUserLiveConfig(final YYUserLiveConfig userLiveConfig) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                AbstractLiveSession.this.mFilterContext.setUserLiveConfig(userLiveConfig);
            }
        });
    }

    @Override
    public void setHardwareEncoderAvailable(boolean available) {
        YMFLog.info(this, "[Encoder ]", "HardwareEncoderAvailable set status:" + available);
        this.mHardwareEncoderAvailable.set(available);
    }

    @Override
    public boolean isHardwareEncoderAvailable() {
        YMFLog.info(this, "[Encoder ]", "HardwareEncoderAvailable get status:" + this.mHardwareEncoderAvailable.get());
        return this.mHardwareEncoderAvailable.get();
    }
}

