/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.Constant;
import com.yy.audioengine.ISpeechMsgRecorderNotify;

public class SpeechMsgRecorder {
    private long mRecorderCtx;
    private ISpeechMsgRecorderNotify mNotify = null;

    SpeechMsgRecorder(String fileName, int uid, SpeechMsgCodecType codecType, long maxDuration) {
        int codecTypeInt = codecType.ordinal();
        this.mRecorderCtx = this.nativeCreate(this, fileName, uid, codecTypeInt, maxDuration);
    }

    public RECORDER_INIT_STATUS init() {
        long res = this.nativeInit(this.mRecorderCtx);
        return RECORDER_INIT_STATUS.ERROR_NONE;
    }

    public void start(ISpeechMsgRecorderNotify notify) {
        this.mNotify = notify;
        this.nativeStart(this.mRecorderCtx);
    }

    public void stop() {
        this.nativeStop(this.mRecorderCtx);
    }

    public void pause() {
        this.nativePause(this.mRecorderCtx);
    }

    public void resume() {
        this.nativeResume(this.mRecorderCtx);
    }

    public void seek(long seekTime) {
        this.nativeSeek(this.mRecorderCtx, seekTime);
    }

    public void destroy() {
        this.mRecorderCtx = this.nativeDestroy(this.mRecorderCtx);
    }

    public void enableReverbEx(boolean enable) {
        this.nativeEnableReverbEx(this.mRecorderCtx, enable);
    }

    public void setReverbParamEx(float[] parameterArray) {
        this.nativeSetReverbParamEx(this.mRecorderCtx, parameterArray);
    }

    public void enableReverbFv3(boolean enable) {
        this.nativeEnableReverbFv3(this.mRecorderCtx, enable);
    }

    public void setReverbFv3Param(float[] parameterArray) {
        this.nativeSetReverbFv3Param(this.mRecorderCtx, parameterArray);
    }

    public void enableEqualizer(boolean enable) {
        this.nativeEnableEqualizerEx(this.mRecorderCtx, enable);
    }

    public void setEqGains(float[] parameterArray) {
        this.nativeSetEqGains(this.mRecorderCtx, parameterArray);
    }

    public void enableCompressor(boolean enable) {
        this.nativeEnableCompressor(this.mRecorderCtx, enable);
    }

    public void setCompressorParam(int[] parameterArray) {
        this.nativeSetCompressorParam(this.mRecorderCtx, parameterArray);
    }

    public void enableLimiter(boolean enable) {
        this.nativeEnableLimiter(this.mRecorderCtx, enable);
    }

    public void setLimiterParam(float[] parameterArray) {
        this.nativeSetLimiterParam(this.mRecorderCtx, parameterArray);
    }

    public void setVolume(long volume) {
        this.nativeSetVolume(this.mRecorderCtx, volume);
    }

    public void startAudioPreview() {
        this.nativeStartAudioPreview(this.mRecorderCtx);
    }

    public void stopAudioPreview() {
        this.nativeStopAudioPreview(this.mRecorderCtx);
    }

    private void onAudioVolumeVisualEvent(long recordTime, long volume) {
        if (this.mNotify != null) {
            this.mNotify.onAudioVolumeVisual(recordTime, volume);
        }
    }

    private void onAudioRecordErrorEvent(int errorCode) {
        if (this.mNotify != null) {
            Constant.AudioDeviceErrorType error = Constant.AudioDeviceErrorType.values()[errorCode];
            this.mNotify.onAudioRecordError(error);
        }
    }

    private void onGetFirstRecordDataEvent() {
        if (this.mNotify != null) {
            this.mNotify.onGetFirstRecordData();
        }
    }

    private void onStopRecordDataEvent(long recordTime, long maxDuration) {
        if (this.mNotify != null) {
            this.mNotify.onStopRecordData(recordTime, maxDuration);
        }
    }

    private void onReachMaxDurationEvent(long recordTime, long maxDuration) {
        if (this.mNotify != null) {
            this.mNotify.onReachMaxDuration(recordTime, maxDuration);
        }
    }

    private native long nativeCreate(Object var1, String var2, int var3, int var4, long var5);

    private native long nativeDestroy(long var1);

    private native long nativeInit(long var1);

    private native void nativeStart(long var1);

    private native void nativeStop(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeSeek(long var1, long var3);

    private native void nativeEnableReverbEx(long var1, boolean var3);

    private native void nativeEnableReverbFv3(long var1, boolean var3);

    private native void nativeEnableEqualizerEx(long var1, boolean var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetReverbParamEx(long var1, float[] var3);

    private native void nativeSetReverbFv3Param(long var1, float[] var3);

    private native void nativeSetEqGains(long var1, float[] var3);

    private native void nativeSetCompressorParam(long var1, int[] var3);

    private native void nativeSetLimiterParam(long var1, float[] var3);

    private native void nativeSetVolume(long var1, long var3);

    private native void nativeStartAudioPreview(long var1);

    private native void nativeStopAudioPreview(long var1);

    public static enum SpeechMsgCodecType {
        SpeechMsgCodecSilk,
        SpeechMsgCodecSpeex,
        SpeechMsgCodecEaacPlus,
        SpeechMsgCodecLcAAC,
        SpeechMsgCodecWav;

    }

    public static enum RECORDER_INIT_STATUS {
        ERROR_NONE,
        ERROR_UNKNOWN_CODEC,
        ERROR_ENCODER_INIT,
        ERROR_FILE_OPEN_FAIL;

    }
}

