/*
 * Decompiled with CFR 0.152.
 */
package com.yy.android.medialibrary.audiocodec;

public class AudioEncoder {
    private static final String TAG = "AudioEncoder";
    private long mCodecCtx;

    public AudioEncoder(int codecType) {
        this.mCodecCtx = this.nativeCreateAudioEncoder(codecType);
    }

    public void init() {
        this.nativeInit(this.mCodecCtx);
    }

    public void uninit() {
        this.nativeUninit(this.mCodecCtx);
    }

    public void flush() {
        this.nativeFlush(this.mCodecCtx);
    }

    public byte[] encode(byte[] inPcm) {
        return this.nativeEncode(this.mCodecCtx, inPcm);
    }

    public byte[] encodeLoss() {
        return this.nativeEncodeLoss(this.mCodecCtx);
    }

    public void setBitRate(long bitRate) {
        this.nativeSetBitRate(this.mCodecCtx, bitRate);
    }

    public long getEncoderBytes() {
        return this.nativeGetEncoderBytes(this.mCodecCtx);
    }

    public void setComplexity(long complexity) {
        this.nativeSetComplexity(this.mCodecCtx, complexity);
    }

    private native long nativeCreateAudioEncoder(int var1);

    private native void nativeInit(long var1);

    private native void nativeUninit(long var1);

    private native void nativeFlush(long var1);

    private native void nativeSetBitRate(long var1, long var3);

    private native long nativeGetEncoderBytes(long var1);

    private native void nativeSetComplexity(long var1, long var3);

    private native byte[] nativeEncode(long var1, byte[] var3);

    private native byte[] nativeEncodeLoss(long var1);
}

