/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.thunder.livesdk.log.ThunderLog;
import com.yy.mediaframework.Constant;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.view.YMFLayoutParams;

public abstract class VideoPlayerView
extends FrameLayout {
    protected VideoConstant.ViewType mViewType;
    protected View mUniformView = null;
    protected int mViewWidth = 0;
    protected int mViewHeight = 0;
    public boolean mPrepared = false;
    protected VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    protected VideoConstant.MirrorMode mMirrorMode = VideoConstant.MirrorMode.Disabled;

    public VideoPlayerView(Context context) {
        super(context);
    }

    public VideoPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VideoPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public int getViewType() {
        if (this.mViewType == VideoConstant.ViewType.SURFACE_VIDEO_VIEW) {
            return 1;
        }
        return 0;
    }

    public View getView() {
        return this.mUniformView;
    }

    public View getYspVideoView() {
        return this.mUniformView;
    }

    public boolean isPrepared() {
        return this.mPrepared;
    }

    protected VideoConstant.ScaleMode scaleModeConvert(int scaleMode) {
        switch (scaleMode) {
            case 0: {
                return VideoConstant.ScaleMode.FillParent;
            }
            case 1: {
                return VideoConstant.ScaleMode.AspectFit;
            }
            case 2: {
                return VideoConstant.ScaleMode.ClipToBounds;
            }
            case 3: {
                return VideoConstant.ScaleMode.Original;
            }
        }
        ThunderLog.warn("yvideo-Java", "invalid scale mode %d", scaleMode);
        return VideoConstant.ScaleMode.AspectFit;
    }

    protected VideoConstant.MirrorMode mirrorModeConvert(int mirrorMode) {
        switch (mirrorMode) {
            case 0: {
                return VideoConstant.MirrorMode.Disabled;
            }
            case 1: {
                return VideoConstant.MirrorMode.Enabled;
            }
        }
        ThunderLog.warn("yvideo-Java", "invalid mirror mode %d", mirrorMode);
        return VideoConstant.MirrorMode.Disabled;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mViewWidth = w;
        this.mViewHeight = h;
    }

    public abstract void enterMultiVideoViewMode(YMFLayoutParams var1, Constant.MultiLianmaiMode var2);

    public abstract void leaveMultiVideoViewMode();

    public abstract void updateMultiViewLayout(YMFLayoutParams var1);

    public abstract int linkToStream(long var1, int var3);

    public abstract int unLinkFromStream(long var1, int var3);

    public abstract int switchDualVideoView(long var1, long var3, int var5);

    public abstract boolean setScaleMode(int var1, int var2);

    public abstract void setMirrorMode(int var1, int var2);

    public abstract Bitmap getVideoScreenshot(int var1);
}

