/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.hardware.Camera;
import com.thunder.livesdk.ThunderBridgeLib;
import com.thunder.livesdk.video.IVideoCaptureObserver;
import com.thunder.livesdk.video.ThunderVideoCaptureObserver;
import com.thunder.livesdk.video.ThunderVideoFrame;
import com.yy.mediaframework.facedetection.IYMFPreviewFrameCallback;
import com.yy.mediaframework.gpuimage.custom.YMFVideoFrame;

public class VideoFrameYuvCapture
implements IYMFPreviewFrameCallback {
    private IVideoCaptureObserver mVideoCaptureFrameObserver = null;
    private static volatile VideoFrameYuvCapture instance;
    private static Object syncLock;
    ThunderVideoFrame mVideoFrame = new ThunderVideoFrame();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VideoFrameYuvCapture getInstance() {
        if (instance == null) {
            Object object = syncLock;
            synchronized (object) {
                if (instance == null) {
                    instance = new VideoFrameYuvCapture();
                }
            }
        }
        return instance;
    }

    private VideoFrameYuvCapture() {
    }

    public void enableVideoCapture(IVideoCaptureObserver observer) {
        if (observer != null) {
            this.mVideoCaptureFrameObserver = observer;
            ThunderBridgeLib.getInstance().addPreviewFrameCallback(this);
        } else {
            ThunderBridgeLib.getInstance().removePreviewFrameCallback(this);
            this.mVideoCaptureFrameObserver = null;
        }
    }

    @Override
    public void onPreviewFrameAvailable(int imageFormat, byte[] data, int width, int height, Camera camera) {
        if (this.mVideoCaptureFrameObserver == null) {
            return;
        }
        this.mVideoCaptureFrameObserver.onCaptureVideoFrame(width, height, data, data.length, imageFormat);
    }

    @Override
    public void onPreviewFrameAvailable(YMFVideoFrame ymfVideoFrame) {
        if (this.mVideoCaptureFrameObserver == null) {
            return;
        }
        if (this.mVideoCaptureFrameObserver instanceof ThunderVideoCaptureObserver) {
            this.mVideoFrame.setVideoFrame(ymfVideoFrame);
            ((ThunderVideoCaptureObserver)this.mVideoCaptureFrameObserver).onCaptureVideoFrame(this.mVideoFrame);
        } else {
            this.mVideoCaptureFrameObserver.onCaptureVideoFrame(ymfVideoFrame.mYuvWidth, ymfVideoFrame.mYuvHeight, ymfVideoFrame.mYUVCaptureBuffer, ymfVideoFrame.mYUVCaptureBuffer.length, ymfVideoFrame.mImageFormat);
        }
    }

    static {
        syncLock = new Object();
    }
}

