/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.UploadStreamStateParams;
import com.yy.mediaframework.opengles.YMFPreviewCanvasView;
import com.yy.mediaframework.opengles.YMFPreviewView;

public class ThunderPreviewView
extends FrameLayout {
    private SurfaceView mSurfaceView;

    public ThunderPreviewView(Context context) {
        super(context);
        this.initData();
    }

    public ThunderPreviewView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initData();
    }

    public ThunderPreviewView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initData();
    }

    public SurfaceView getSurfaceView() {
        return this.mSurfaceView;
    }

    private void initData() {
        if (this.mSurfaceView == null) {
            this.mSurfaceView = UploadStreamStateParams.mPreviewMode == Constant.PreviewMode.GlSurfaceMode ? new YMFPreviewView(this.getContext().getApplicationContext()) : (UploadStreamStateParams.mPreviewMode == Constant.PreviewMode.CanvasMode ? new YMFPreviewCanvasView(this.getContext().getApplicationContext()) : new SurfaceView(this.getContext().getApplicationContext()));
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.addView((View)this.mSurfaceView);
        }
    }

    public boolean checkViewType(Constant.PreviewMode mode) {
        return mode == Constant.PreviewMode.GlSurfaceMode && !(this.mSurfaceView instanceof YMFPreviewView) || mode == Constant.PreviewMode.CanvasMode && !(this.mSurfaceView instanceof YMFPreviewCanvasView) || mode == Constant.PreviewMode.TextureMode && (this.mSurfaceView instanceof YMFPreviewView || this.mSurfaceView instanceof YMFPreviewCanvasView);
    }

    public void changeViewType() {
        this.removeAllViews();
        this.mSurfaceView = null;
        this.initData();
    }

    public void clearViews() {
        this.removeAllViews();
    }

    public void addViews(SurfaceView newView) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        newView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)newView);
    }
}

