/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.helper;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import com.thunder.livesdk.CustomTranscodingOptions;
import com.thunder.livesdk.IThunderLogCallback;
import com.thunder.livesdk.LiveTranscoding;
import com.thunder.livesdk.ThunderAudioFilePlayer;
import com.thunder.livesdk.ThunderBoltImage;
import com.thunder.livesdk.ThunderDeviceInfo;
import com.thunder.livesdk.ThunderEventHandler;
import com.thunder.livesdk.ThunderMultiVideoViewParam;
import com.thunder.livesdk.ThunderNotification;
import com.thunder.livesdk.ThunderPublishVideoConfig;
import com.thunder.livesdk.ThunderVideoEncodeParam;
import com.thunder.livesdk.ThunderVideoEncoderConfiguration;
import com.thunder.livesdk.TranscodingImage;
import com.thunder.livesdk.TranscodingText;
import com.thunder.livesdk.TranscodingTimestamp;
import com.thunder.livesdk.audio.IAudioEncodedFrameObserver;
import com.thunder.livesdk.audio.IAudioFrameObserver;
import com.thunder.livesdk.helper.HPMarshaller;
import com.thunder.livesdk.helper.Marshallable;
import com.thunder.livesdk.helper.MshBuffer;
import com.thunder.livesdk.helper.NativeByteBufferPool;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.video.CpuTool;
import com.thunder.livesdk.video.IVideoDecodeObserver;
import com.thunder.livesdk.video.ThunderPublishLowStreamVideoConfig;
import com.thunder.livesdk.video.serviceConfig.VideoConfigManager;
import com.thunder.livesdk.video.serviceConfig.VideoLiveConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;

public class ThunderNative {
    private static IThunderLogCallback s_logCallback = null;
    private static NotificationDispatcher s_notificationDispatcher = null;
    private static ReentrantLock s_notificationLock = null;
    private static int s_remoteVideoStatsNotificationCount = 0;
    private static int s_remoteAudioStatsNotificationCount = 0;
    private static final int YYLIVE_SDK_INIT = 1;
    private static final int YYLIVE_SET_SCENE_ID = 2;
    private static final int YYLIVE_LOG_TEXT = 3;
    private static final int YYLIVE_UPDATE_TOKEN = 5;
    private static final int THUNDER_JOIN_ROOM = 6;
    private static final int YYLIVE_LEAVE_ROOM = 7;
    private static final int YYLIVE_SET_AREA_TYPE = 8;
    private static final int YYLIVE_SET_PLAY_VOLUME_INTERVAL = 9;
    private static final int YYLIVE_SET_CAPTURE_VOLUME_INTERVAL = 10;
    private static final int YYLIVE_SET_HTTPS_RESPONSE = 11;
    private static final int YYLIVE_SET_RECORD_AUDIO_PARAMS = 12;
    private static final int YYLIVE_SET_PLAY_AUDIO_PARAMS = 13;
    private static final int YYLIVE_SET_MIX_AUDIO_PARAMS = 14;
    private static final int THUNDER_SET_REMOTE_AUDIO_STREAM_VOLUME = 15;
    private static final int YYLIVE_SET_SPEAKER_VOLUME = 17;
    private static final int YYLIVE_H265_SUPPORT_MODE = 18;
    private static final int YYLIVE_ENABLE_WEBSDK_COMPATIBILITY = 19;
    private static final int YYLIVE_H264_SUPPORT_MODE = 20;
    private static final int THUNDER_VIDEO_FRAME_OBSERVER = 21;
    private static final int YYLIVE_SET_REMOTE_UID_VOICE_POSITION = 22;
    private static final int YYLIVE_INIT_MULTI_VIEW_LAYOUT = 23;
    private static final int THUNDER_SET_REMOTE_PLAY_TYPE = 24;
    private static final int YYLIVE_SET_MIC_VOLUME = 25;
    private static final int YYLIVE_CHANGE_SCREEN_LIVE_MODE = 26;
    private static final int YYLIVE_SET_ORIENTATION = 27;
    private static final int YYLIVE_GET_ORIENTATION = 28;
    private static final int THUNDER_START_VIDEO_CAPTURE = 30;
    private static final int YYLIVE_UPDATE_PUBLISH_ORIGIN_STREAM_URL = 31;
    private static final int THUNDER_SET_THUNDERBOLT_PUBLISH_GROUP = 32;
    private static final int YYLIVE_SET_LOCAL_VIDEO_MIRROR_MODE = 33;
    private static final int YYLIVE_GET_BEAUTIFY_LEVEL = 34;
    private static final int YYLIVE_AUDIO_FILE_OPEN = 35;
    private static final int YYLIVE_AUDIO_FILE_CLOSE = 36;
    private static final int YYLIVE_AUDIO_FILE_PLAY = 37;
    private static final int YYLIVE_AUDIO_FILE_STOP = 38;
    private static final int YYLIVE_AUDIO_FILE_PAUSE = 39;
    private static final int YYLIVE_AUDIO_FILE_RESUME = 40;
    private static final int YYLIVE_AUDIO_FILE_SEEK = 41;
    private static final int YYLIVE_AUDIO_FILE_GET_TOTAL_TIME = 42;
    private static final int YYLIVE_AUDIO_FILE_GET_CURRENT_TIME = 43;
    private static final int YYLIVE_AUDIO_FILE_SET_PLAY_VOLUME = 44;
    private static final int YYLIVE_AUDIO_FILE_SET_SEMITONE = 45;
    private static final int YYLIVE_AUDIO_FILE_ENABLE_PUBLISH = 46;
    private static final int YYLIVE_AUDIO_SET_EXTERNAL_PROCESSOR = 47;
    private static final int YYLIVE_AUDIO_ENABLE_CAPTURE_PCM_DATA_CALLBACK = 48;
    private static final int YYLIVE_AUDIO_ENABLE_AUDIO_DATA_INDICATION = 49;
    private static final int YYLIVE_CREATE_AUDIO_FILE_PLAYER = 50;
    private static final int YYLIVE_DESTROY_AUDIO_FILE_PLAYER = 51;
    private static final int YYLIVE_AUDIO_ENABLE_RENDER_PCM_DATA_CALLBACK = 52;
    private static final int YYLIVE_AUDIO_FILE_ENABLE_VOLUME_CALLBACK = 53;
    private static final int YYLIVE_AUDIO_FILE_SELECT_AUDIOTRACK = 54;
    private static final int YYLIVE_AUDIO_FILE_GET_AUDIOTRACK_COUNT = 55;
    private static final int YYLIVE_AUDIO_FILE_SET_PLAYER_LOCAL_VOLUME = 56;
    private static final int YYLIVE_AUDIO_FILE_SET_PLAYER_PUBLISH_VOLUME = 57;
    private static final int YYLIVE_AUDIO_FILE_GET_PLAYER_LOCAL_VOLUME = 58;
    private static final int YYLIVE_AUDIO_FILE_GET_PLAYER_PUBLISH_VOLUME = 59;
    private static final int YYLIVE_AUDIO_FILE_SET_LOOPING = 60;
    private static final int THUNDER_SEND_AUDIO_FILE_PLAYER_INFO = 61;
    private static final int YYLIVE_SEND_USER_APP_MSG_DATA = 62;
    private static final int THUNDER_SEND_MEDIA_EXTRA_INFO = 63;
    private static final int THUNDER_ENABLE_MIX_VIDEO_EXTRA_INFO = 64;
    private static final int THUNDER_SET_MEDIA_MODE = 65;
    private static final int THUNDER_SET_ROOM_MODE = 66;
    private static final int THUNDER_SET_USER_64BIT_UID = 67;
    private static final int THUNDER_SET_LOG_LEVEL = 68;
    private static final int THUNDER_SET_LOG_FILE_PATH = 69;
    private static final int THUNDER_ENABLE_LOG_CALLBACK = 70;
    private static final int THUNDER_UPDATE_PUBLISH_TRANSCODING_STREAM_URL = 71;
    private static final int THUNDER_SET_LIVE_TRANSCODING_TASK = 72;
    private static final int THUNDER_REMOVE_LIVE_TRANSCODING_TASK = 73;
    private static final int THUNDER_SET_REMOTE_VIDEO_CANVAS = 74;
    private static final int THUNDER_SET_REMOTE_VIDEO_CANVAS_MODE = 75;
    private static final int THUNDER_SET_LOCAL_VIDEO_CANVAS = 76;
    private static final int THUNDER_SET_Local_VIDEO_CANVAS_MODE = 77;
    private static final int THUNDER_SUBSCRIBE_USER = 78;
    private static final int THUNDER_SET_THUNDERBOLT_SUBSCRIBE_GROUP = 79;
    private static final int THUNDER_STOP_ALL_REMOTE_STREAMS = 80;
    private static final int THUNDER_STOP_REMOTE_AUDIO_STREAM = 81;
    private static final int THUNDER_STOP_REMOTE_VIDEO_STREAM = 82;
    private static final int THUNDER_SWITCH_FRONT_CAMERA = 83;
    private static final int THUNDER_START_PUBLISH_AUDIO = 84;
    private static final int THUNDER_START_PUSH_AUDIO_STREAM = 85;
    private static final int THUNDER_SET_AUDIO_CONFIG = 86;
    private static final int THUNDER_SET_AUDIO_PUBLISH_MODE = 87;
    private static final int THUNDER_SET_CUSTOME_AUDIO_SOURCE = 88;
    private static final int THUNDER_SET_PUB_WATERMARK = 89;
    private static final int THUNDER_PUSH_CUSTOME_AUDIO_FRAME = 90;
    private static final int THUNDER_START_VIDEO_ENCODE = 91;
    private static final int THUNDER_START_PUBLISH_VIDEO_STREAM = 92;
    private static final int THUNDER_START_PREVIEW = 93;
    private static final int THUNDER_ATTACH_VIDEO_CAPTURE = 94;
    private static final int THUNDER_SET_VIDEO_ENCODER_CONFIG = 95;
    private static final int THUNDER_NOTIFY_NETWORK_STATE = 96;
    private static final int THUNDER_APP_ENTER_FOREGROUND = 97;
    private static final int THUNDER_APP_ENTER_BACKGROUND = 98;
    private static final int THUNDER_ENABLE_LOUD_SPEAKER = 99;
    private static final int THUNDER_GET_LOUDSPEAKER_ENABLED = 100;
    private static final int THUNDER_ENABLE_IN_EAR_MONITOR = 101;
    private static final int THUNDER_ENABLE_EQUALIZER = 102;
    private static final int THUNDER_SET_EQ_GAINS = 103;
    private static final int THUNDER_ENABLE_COMPRESSOR = 104;
    private static final int THUNDER_SET_COMPRESSOR_PARAM = 105;
    private static final int THUNDER_ENABLE_REVERB = 106;
    private static final int THUNDER_SET_REVERB_PARAM = 107;
    private static final int THUNDER_SET_LIMIT_PARAM = 108;
    private static final int THUNDER_ENABLE_LIMITER = 119;
    private static final int THUNDER_START_AUDIO_SAVER = 110;
    private static final int THUNDER_STOP_AUDIO_SAVER = 111;
    private static final int THUNDER_ENABLE_AUDIO_PLAY_SPECTRUM = 112;
    private static final int THUNDER_SET_AUDIO_PLAY_SPECTRUM_INFO = 113;
    private static final int THUNDER_ENABLE_VOICE_POSITION = 114;
    private static final int THUNDER_SET_SOUND_EFFECT = 115;
    private static final int THUNDER_SET_VOICE_CHANGER = 116;
    private static final int THUNDER_SET_SID_AND_SUBSID = 117;
    private static final int THUNDER_GET_CPU_RATE = 118;
    private static final int THUNDER_MAKE_BEHAVIOR_EVENT = 120;
    private static final int THUNDER_PREFETCH_STREAMS = 121;
    private static final int THUNDER_QUERY_STREAMS = 122;
    private static final int THUNDER_GET_CONNECTION_STATUS = 124;
    private static final int THUNDER_SET_VOICE_CHANGER_PITCH = 125;
    private static final int THUNDER_ENABLE_HOWLING_DETECTOR = 126;
    private static final int THUNDER_CUSTOMIZE_VIDEO_PUBLISH_CFG = 127;
    private static final int THUNDER_ENABLE_LOCAL_DUANL_STREAM_MODE = 128;
    private static final int THUNDER_SET_DEFAULT_REMOTE_VIDEO_STREAM_TYPE = 129;
    private static final int THUNDER_CHANGE_REMOTE_VIDEO_STREAM_TYPE = 130;
    private static final int THUNDER_SET_EAR_MONITORING_VOLUME = 131;
    private static final int THUNDER_ADAPT_TO_SYSTEM_KARAOKE = 132;
    private static final int THUNDER_START_AUDIO_CAPTURE = 133;
    private static final int THUNDER_START_AUDIO_ENCODE = 134;
    private static final int THUNDER_ENABLE_ECHO_DETECTOR = 135;
    private static final int THUNDER_IS_AUDIO_CAPTURE_ENABLED = 136;
    private static final int THUNDER_ENABLE_AUDIO_MIC_DENOISE = 137;
    private static final int THUNDER_IS_AUDIO_MIC_DENOISE_ENABLE = 138;
    private static final int THUNDER_SET_CUSTOM_STREAM_NAME = 140;
    private static final int THUNDER_SET_SUBSCRIBE_GROUP_IN_THUNDER = 141;
    private static final int THUNDER_SET_CUSTOM_PUBLISH_APPID = 142;
    private static final int THUNDER_START_INPUT_DEVICE_TEST = 143;
    private static final int THUNDER_STOP_INPUT_DEVICE_TEST = 144;
    private static final int THUNDER_START_OUTPUT_DEVICE_TEST = 145;
    private static final int THUNDER_STOP_OUTPUT_DEVICE_TEST = 146;
    private static final int THUNDER_ENABLE_AUDIO_AGC = 147;
    private static final int THUNDER_START_AUDIO_RECORD = 148;
    private static final int THUNDER_STOP_AUDIO_RECORD = 149;
    private static final int YYLIVE_AUDIO_FILE_SET_TEMPO = 150;
    private static final int YYLIVE_AUDIO_FILE_SET_POSITION = 151;
    private static final int THUNDER_SWITCH_USER_ROLE = 152;
    private static final int THUNDER_AUDIO_ENABLE_AI_DENOISE = 153;
    private static final int THUNDER_IS_AUDIO_ENCODER_ENABLED = 154;
    private static final int THUNDER_IS_AUDIO_PUBLISHER_ENABLED = 155;
    private static final int YYLIVE_GET_ABROAD_NETWORK_STRATEGY = 180;
    private static final int THUNDER_GET_HARD_DECODE_RENDER_CONFIG = 181;
    private static final int YYLIVE_ENABLE_VIDEO_PUBLISH_BUFFER_PROCESS = 182;
    private static final int YYLIVE_SET_HARDWARE_DECODE_STATUS = 183;
    private static final int THUNDER_SET_CRASH_EVENT = 184;
    private static final int YYLIVE_SET_VIDEO_COMMON_CONFIG_MODE = 185;
    private static final int YYLIVE_CAPTURE_REMOTE_SCREEN_SHOT = 190;
    private static final int YYLIVE_ENABLE_VIDEO_SET_PARAMETERS_PROCESS = 191;
    private static final int THUNDER_SET_CAMERA_TORCH_ON = 200;
    private static final int THUNDER_IS_CAMERA_OPEN = 201;
    private static final int THUNDER_IS_FRONT_CAMERA = 202;
    private static final int THUNDER_IS_CAMERA_MANUAL_FOCUS_POSITION_SUPPORTED = 203;
    private static final int THUNDER_IS_CAMERA_MANUAL_EXPOSURE_POSITION_SUPPORTED = 204;
    private static final int THUNDER_IS_CAMERA_ZOOM_SUPPORTED = 205;
    private static final int THUNDER_GET_CAMERA_MAX_ZOOM_FACTOR = 206;
    private static final int THUNDER_SET_CAMERA_ZOOM_FACTOR = 207;
    private static final int THUNDER_IS_CAMERA_TORCH_SUPPORTED = 208;
    private static final int THUNDER_SET_CAMERA_FOCUS_POSITION = 209;
    private static final int THUNDER_SET_CAMERA_EXPOSURE_POSITION = 210;
    private static final int THUNDER_IS_CAMERA_AUTO_FOCUS_FACE_MODE_SUPPORTED = 211;
    private static final int THUNDER_SET_CAMERA_AUTO_FOCUS_FACE_MODE_ENABLED = 212;
    private static final int THUNDER_SEND_PRIVATE_MEDIA_EXTRA_DATA = 213;
    private static final int THUNDER_START_VIDEO_LOCAL_PREVIEW = 214;
    private static final int THUNDER_SUBSCRIBE_ROOM = 215;
    private static final int THUNDER_GET_USER_ROLE = 216;
    private static Boolean isInit = false;
    private static int s_audioCaptureVolumeNotificationCount = 0;
    private static int s_audioPlayVolumeNotificationCount = 0;
    private static int s_playRuntimeNotificationCount = 0;
    private static int s_publishRuntimeNotificationCount = 0;
    private static int s_audioExtraInfoNotificationCount = 0;

    private static native int YYLiveSdkInit(Context var0, byte[] var1);

    private static native void YYLiveSdkFini();

    private static native long YYLiveSdkProcess(int var0, byte[] var1);

    private static native String YYLiveSdkGetVersion();

    private static native int YYLiveSdkGetVersionInt();

    private static native long YYLiveObjectToPtr(Object var0);

    private static native void YYLiveRegisterAudioObserver(IAudioFrameObserver var0);

    private static native int YYLiveRegisterAudioEncodedObserver(IAudioEncodedFrameObserver var0);

    private static native Object ThunderGetVideoEncoderParamByGear(int var0, int var1);

    private static native Object ThunderCaptureRemoteScreenShot(String var0);

    private static native int ThunderSetCaptureReplaceImage(Object var0);

    private static native Object ThunderCaptureLocalScreenShot();

    private static native String LiveEngineTranscodingCfgByMode(int var0);

    public static void fini() {
        isInit = false;
        s_notificationLock.lock();
        try {
            s_notificationDispatcher = null;
        }
        finally {
            s_notificationLock.unlock();
        }
        ThunderNative.YYLiveSdkFini();
    }

    public static String getVersion() {
        return ThunderNative.YYLiveSdkGetVersion();
    }

    public static void registerAudioFrameObserver(IAudioFrameObserver observer) {
        ThunderNative.YYLiveRegisterAudioObserver(observer);
    }

    public static int registerAudioEncodedFrameObserver(IAudioEncodedFrameObserver observer) {
        return ThunderNative.YYLiveRegisterAudioEncodedObserver(observer);
    }

    private static long YLEProcess(YLEBase e) {
        MshBuffer buffer = new MshBuffer(4096, NativeByteBufferPool.get());
        long ret = ThunderNative.YYLiveSdkProcess(e.event(), e.HPmarshall(buffer));
        buffer.freeBuffer();
        return ret;
    }

    public static int initMultiPlayerViewLayout(ThunderMultiVideoViewParam params, int viewId, Object view) {
        return (int)ThunderNative.YLEProcess(new YLEInitMultiPlayerViewLayout(params, viewId, view));
    }

    public static Bitmap captureRemoteScreenShot(String uid) {
        Object object = ThunderNative.ThunderCaptureRemoteScreenShot(uid);
        if (object instanceof Bitmap) {
            return (Bitmap)object;
        }
        return null;
    }

    public static int setCaptureReplaceImage(Bitmap bitmap) {
        return ThunderNative.ThunderSetCaptureReplaceImage(bitmap);
    }

    public static Bitmap captureLocalScreenShot() {
        Object object = ThunderNative.ThunderCaptureLocalScreenShot();
        if (object instanceof Bitmap) {
            return (Bitmap)object;
        }
        return null;
    }

    public static int setParameters(String options) {
        return (int)ThunderNative.YLEProcess(new YLESetParameters(options));
    }

    public static int setVideoPlayType(int remotePlayType, boolean checkJoined) {
        return (int)ThunderNative.YLEProcess(new YLESetVideoPlayType(remotePlayType, checkJoined));
    }

    public static int onCrashEvent() {
        return (int)ThunderNative.YLEProcess(new YLESetCrashEvent());
    }

    public static int setHardwareDecodeStatus(int mHardwareDecodeStatus) {
        return (int)ThunderNative.YLEProcess(new YLESetHardwareDecodeStatus(mHardwareDecodeStatus));
    }

    public static int enableVideoPublishBufferProcess(boolean bBufferMode) {
        return (int)ThunderNative.YLEProcess(new YLEEnableVideoPublishBufferProcess(bBufferMode));
    }

    public static int setVideoCommonConfigMode(int mode) {
        return (int)ThunderNative.YLEProcess(new YLESetVideoCommonConfigMode(mode));
    }

    public static void logText(int level, int module, String tag, String text) {
        ThunderNative.YLEProcess(new YLELogText(level, module, tag, text));
    }

    public static int leaveRoom() {
        return (int)ThunderNative.YLEProcess(new YLELeaveRoom());
    }

    public static int setPlayVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        return (int)ThunderNative.YLEProcess(new YLESetPlayVolumeInterval(interval, moreThanThd, lessThanThd));
    }

    public static int setCaptureVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        return (int)ThunderNative.YLEProcess(new YLESetCaptureVolumeInterval(interval, moreThanThd, lessThanThd));
    }

    public static int getBeautifyLevel() {
        return (int)ThunderNative.YLEProcess(new YLEGetBeautifyLevel());
    }

    public static int getAbroadNetWorkStrategy() {
        return (int)ThunderNative.YLEProcess(new YLEGetAbroadNetWorkStrategy());
    }

    public static int enableWebSdkCompatibility(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableWebSdkCompatibility(enable));
    }

    public static int setLocalVideoMirrorMode(int mode) {
        return (int)ThunderNative.YLEProcess(new YLESetLocalVideoMirrorMode(mode));
    }

    public static int setRemoteAudioStreamVolume(String uid, int volume) {
        return (int)ThunderNative.YLEProcess(new YLESetRemoteAudioStreamVolume(uid, volume));
    }

    public static int setRemoteUidVoicePosition(String uid, int azimuth, int gain) {
        return (int)ThunderNative.YLEProcess(new YLESetRemoteUidVoicePosition(uid, azimuth, gain));
    }

    public static int setSpeakerVolume(int volume) {
        return (int)ThunderNative.YLEProcess(new YLESetSpeakerVolume(volume));
    }

    public static int getH265SupportMode() {
        return (int)ThunderNative.YLEProcess(new YLEGetH265SupportMode());
    }

    public static int getH264SupportMode() {
        return (int)ThunderNative.YLEProcess(new YLEGetH264SupportMode());
    }

    public static int getHardDecodeDirectRenderConfig() {
        return (int)ThunderNative.YLEProcess(new YLEGetHardDecodeRenderMode());
    }

    public static int getAppCpuSupportMode() {
        return (int)ThunderNative.YLEProcess(new YLEGetAppCpuSupportMode());
    }

    public static int setMicVolume(int volume) {
        return (int)ThunderNative.YLEProcess(new YLESetMicVolume(volume));
    }

    public static int setOrientation(int ori) {
        return (int)ThunderNative.YLEProcess(new YLESetOrientation(ori));
    }

    public static int getOrientation() {
        return (int)ThunderNative.YLEProcess(new YLEGetOrientation());
    }

    public static int setThunderboltPublishGroup(boolean bPublishGroup) {
        return (int)ThunderNative.YLEProcess(new YLESetThunderboltPublishGroup(bPublishGroup));
    }

    public static void changeScreenLiveMode(boolean bPicMode, Object bitmap) {
        ThunderNative.YLEProcess(new YLEChangeScreenLiveMode(bPicMode, bitmap));
    }

    public static long createAudioFilePlayer(Object obj) {
        return ThunderNative.YLEProcess(new YLECreateAudioFilePlayer(obj));
    }

    public static long destroyAudioFilePlayer(long ctx) {
        return ThunderNative.YLEProcess(new YLEAudioFileEventCommon(51, ctx));
    }

    public static long sendAudioFilePlayerInfo(int volume, int currentMs, int totalMs) {
        return ThunderNative.YLEProcess(new YLESendAudioFilePlayerInfo(volume, currentMs, totalMs));
    }

    public static long audioFileOpen(long ctx, String path) {
        return ThunderNative.YLEProcess(new YLEAudioFileOpen(ctx, path));
    }

    public static void audioFileClose(long ctx) {
        ThunderNative.YLEProcess(new YLEAudioFileEventCommon(36, ctx));
    }

    public static void audioFilePlay(long ctx) {
        ThunderNative.YLEProcess(new YLEAudioFileEventCommon(37, ctx));
    }

    public static void audioFileStop(long ctx) {
        ThunderNative.YLEProcess(new YLEAudioFileEventCommon(38, ctx));
    }

    public static void audioFilePause(long ctx) {
        ThunderNative.YLEProcess(new YLEAudioFileEventCommon(39, ctx));
    }

    public static void audioFileResume(long ctx) {
        ThunderNative.YLEProcess(new YLEAudioFileEventCommon(40, ctx));
    }

    public static void audioFileSeek(long ctx, long timeMS) {
        ThunderNative.YLEProcess(new YLEAudioFileSeek(ctx, timeMS));
    }

    public static long audioFileGetTotalTime(long ctx) {
        return ThunderNative.YLEProcess(new YLEAudioFileEventCommon(42, ctx));
    }

    public static long audioFileGetCurrentPlayTime(long ctx) {
        return ThunderNative.YLEProcess(new YLEAudioFileEventCommon(43, ctx));
    }

    public static void audioFileSetPlayVolume(long ctx, int volume) {
        ThunderNative.YLEProcess(new YLEAudioFileSetPlayVolume(ctx, volume));
    }

    public static int audioFileSetPlayerLocalVolume(long ctx, int volume) {
        return (int)ThunderNative.YLEProcess(new YLEAudioFileSetPlayerLocalVolume(ctx, volume));
    }

    public static int audioFileSetPlayerPublishVolume(long ctx, int volume) {
        return (int)ThunderNative.YLEProcess(new YLEAudioFileSetPlayerPublishVolume(ctx, volume));
    }

    public static long audioFileGetPlayerLocalVolume(long ctx) {
        return ThunderNative.YLEProcess(new YLEAudioFileEventCommon(58, ctx));
    }

    public static long audioFileGetPlayerPublishVolume(long ctx) {
        return ThunderNative.YLEProcess(new YLEAudioFileEventCommon(59, ctx));
    }

    public static long audioFileSetLooping(long ctx, int cycle) {
        return ThunderNative.YLEProcess(new YLEAudioFileSetLooping(ctx, cycle));
    }

    public static long audioFileSelectAudioTrack(long ctx, int audioTrack) {
        return ThunderNative.YLEProcess(new YLEAudioFileSelectAudioTrack(ctx, audioTrack));
    }

    public static long audioFileGetAudioTrackCount(long ctx) {
        return ThunderNative.YLEProcess(new YLEAudioFileEventCommon(55, ctx));
    }

    public static void audioFileSetSemitone(long ctx, float val) {
        ThunderNative.YLEProcess(new YLEAudioFileSetSemitone(ctx, val));
    }

    public static void audioFileSetTempo(long ctx, float val) {
        ThunderNative.YLEProcess(new YLEAudioFileSetTempo(ctx, val));
    }

    public static void audioFileSetPosition(long ctx, int azimuth, int elevation) {
        ThunderNative.YLEProcess(new YLEAudioFileSetPosition(ctx, azimuth, elevation));
    }

    public static void audioFileEnablePublish(long ctx, boolean enable) {
        ThunderNative.YLEProcess(new YLEAudioFileEnablePublish(ctx, enable));
    }

    public static void enableAudioFileVolumeCallback(long ctx, boolean enable, int interval) {
        ThunderNative.YLEProcess(new YLEEnableAudioFileVolumeCallback(ctx, enable, interval));
    }

    public static void setExternalAudioProcessor(long eap) {
        ThunderNative.YLEProcess(new YLEAudioSetExternalProcessor(eap));
    }

    public static void enableAudioDataIndication(boolean enable) {
        ThunderNative.YLEProcess(new YLEEnableAudioDataIndication(enable));
    }

    public static int enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        return (int)ThunderNative.YLEProcess(new YLEEnableCapturePcmDataCallBack(enable, sampleRate, channel));
    }

    public static boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        return 0L == ThunderNative.YLEProcess(new YLEEnableRenderPcmDataCallBack(enable, sampleRate, channel));
    }

    public static int sendUserAppMsgData(byte[] msgData) {
        return (int)ThunderNative.YLEProcess(new YLESendUserAppMsgData(msgData));
    }

    public static int sendMediaExtraInfo(byte[] extraInfo) {
        return (int)ThunderNative.YLEProcess(new YLESendMediaExtraInfo(extraInfo));
    }

    public static int sendPrivateMediaExtraData(String extraData) {
        return (int)ThunderNative.YLEProcess(new YLESendPrivateMediaExtraData(extraData));
    }

    public static int enableMixVideoExtraInfo(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableMixVideoExtraInfo(enable));
    }

    public static void setHttpsBinaryResponse(String reqUrl, byte[] response, int statusCode, int errCode, int target) {
        if (isInit.booleanValue()) {
            ThunderNative.YLEProcess(new YLESetHttpsBinaryResponse(reqUrl, response, statusCode, errCode, target));
        }
    }

    public static void setHttpsTextResponse(String reqUrl, String response, int statusCode, int errCode, int target) {
        if (isInit.booleanValue()) {
            ThunderNative.YLEProcess(new YLESetHttpsTextResponse(reqUrl, response, statusCode, errCode, target));
        }
    }

    public static int setPlaybackAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        return (int)ThunderNative.YLEProcess(new YLESetPlaybackAudioFrameParameters(sampleRate, channel, mode, samplesPerCall));
    }

    public static ThunderVideoEncodeParam getVideoEncoderParamByGear(int playType, int publishMode) {
        Object object = ThunderNative.ThunderGetVideoEncoderParamByGear(playType, publishMode);
        if (object instanceof ThunderVideoEncodeParam) {
            return (ThunderVideoEncodeParam)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int init(long appId, long sceneId, int areaType, int serverDomain, Context appContext, ThunderDeviceInfo info, NotificationDispatcher handlers) {
        if (s_notificationLock == null) {
            s_notificationLock = new ReentrantLock();
        }
        s_notificationLock.lock();
        try {
            s_notificationDispatcher = handlers;
        }
        finally {
            s_notificationLock.unlock();
        }
        YLESdkInit yle = new YLESdkInit(appId, sceneId, areaType, serverDomain, info);
        MshBuffer buffer = new MshBuffer(4096, NativeByteBufferPool.get());
        int ret = ThunderNative.YYLiveSdkInit(appContext, yle.HPmarshall(buffer));
        buffer.freeBuffer();
        isInit = true;
        return ret;
    }

    public static int setLogLevel(int level) {
        return (int)ThunderNative.YLEProcess(new YLESetLogLevel(level));
    }

    public static int setLogFilePath(String filePath) {
        return (int)ThunderNative.YLEProcess(new YLESetLogFilePath(filePath));
    }

    public static int setLogCallback(IThunderLogCallback callback) {
        s_logCallback = callback;
        return (int)ThunderNative.YLEProcess(new YLEEnableLogCallback(callback != null));
    }

    public static void setSceneId(long sceneId) {
        ThunderNative.YLEProcess(new YLESetSceneId(sceneId));
    }

    public static int updateToken(byte[] token) {
        return (int)ThunderNative.YLEProcess(new YLEUpdateToken(token));
    }

    public static int setMediaMode(int mediaMode) {
        return (int)ThunderNative.YLEProcess(new YLESetMediaMode(mediaMode));
    }

    public static int setRoomMode(int roomMode) {
        return (int)ThunderNative.YLEProcess(new YLESetRoomMode(roomMode));
    }

    public static int joinRoom(byte[] token, String roomId, String uid) {
        return (int)ThunderNative.YLEProcess(new YLEJoinLiveEngineRoom(token, roomId, uid));
    }

    public static int setRemoteVideoCanvas(Object view, int renderMode, String uid, int seatIndex) {
        return (int)ThunderNative.YLEProcess(new YLESetRemoteVideoCanvas(view, renderMode, uid, seatIndex));
    }

    public static int setRemoteVideoCanvasMode(String uid, int renderMode, int mirrorMode) {
        return (int)ThunderNative.YLEProcess(new YLESetRemoteVideoCanvasMode(uid, renderMode, mirrorMode));
    }

    public static int setLocalVideoCanvas(Object view, int scaleMode) {
        return (int)ThunderNative.YLEProcess(new YLESetLocalVideoCanvas(view, scaleMode));
    }

    public static int setLocalVideoCanvasMode(int mode) {
        return (int)ThunderNative.YLEProcess(new YLESetLocalVideoCanvasMode(mode));
    }

    public static int subscribeUser(boolean bSubscribe, String roomId, String uid) {
        return (int)ThunderNative.YLEProcess(new YLESubscribeUser(bSubscribe, roomId, uid));
    }

    public static int subscribeRoom(boolean bSubscribe, String roomId) {
        return (int)ThunderNative.YLEProcess(new YLESubscribeRoom(bSubscribe, roomId));
    }

    public static int getUserRole() {
        return (int)ThunderNative.YLEProcess(new YLEGetUserRole());
    }

    public static int setThunderboltSubscribeGroup(boolean bSubscribe) {
        return (int)ThunderNative.YLEProcess(new YLESetThunderboltSubscribeGroup(bSubscribe));
    }

    public static int stopAllRemoteStreams(boolean bVideo, boolean bStop) {
        return (int)ThunderNative.YLEProcess(new YLEStopAllRemoteStreams(bVideo, bStop));
    }

    public static int enableLocalDualStreamMode(boolean enabled) {
        return (int)ThunderNative.YLEProcess(new YLEEnableLocalDualStreamMode(enabled));
    }

    public static int setDefaultRemoteVideoStreamType(int type) {
        return (int)ThunderNative.YLEProcess(new YLESetDefaultRemoteVideoStreamType(type));
    }

    public static int changeRemoteVideoStreamType(String uid, int type) {
        return (int)ThunderNative.YLEProcess(new YLEChangeRemoteVideoStreamType(uid, type));
    }

    public static int switchUserRole(int role) {
        return (int)ThunderNative.YLEProcess(new YLESwitchUserRole(role));
    }

    public static int stopRemoteAudioStream(String uid, boolean bStop) {
        return (int)ThunderNative.YLEProcess(new YLEStopRemoteAudioStream(uid, bStop));
    }

    public static int stopRemoteVideoStream(String uid, boolean bStop) {
        return (int)ThunderNative.YLEProcess(new YLEStopRemoteVideoStream(uid, bStop));
    }

    public static int setAreaType(int areaType) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info("ycall-Java", "setAreaType %d", areaType);
        }
        return (int)ThunderNative.YLEProcess(new YLESetAreaType(areaType));
    }

    public static int getConnectionStatus() {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info("ycall-Java", "getConnectionStatus");
        }
        return (int)ThunderNative.YLEProcess(new YLEGetConnectionStatus());
    }

    public static int startVideoCapture(boolean bStart) {
        return (int)ThunderNative.YLEProcess(new YLEStartVideoCapture(bStart));
    }

    public static int startLocalVideoPreview(boolean bStart) {
        return (int)ThunderNative.YLEProcess(new YLEStartLocalVideoPreview(bStart));
    }

    public static int setUse64bitUid(boolean bUseStrUid) {
        return (int)ThunderNative.YLEProcess(new YLESetUse64bitUid(bUseStrUid));
    }

    public static int switchFrontCamera(boolean bFront) {
        return (int)ThunderNative.YLEProcess(new YLESwitchFrontCamera(bFront));
    }

    public static boolean isCameraOpen() {
        return (int)ThunderNative.YLEProcess(new YLEIsCameraOpen()) != 0;
    }

    public static boolean isFrontCamera() {
        return (int)ThunderNative.YLEProcess(new YLEIsFrontCamera()) != 0;
    }

    public static int setCameraTorchOn(boolean isOn) {
        return (int)ThunderNative.YLEProcess(new YLESetCameraTorchOn(isOn));
    }

    public static boolean isCameraManualFocusPositionSupported() {
        return (int)ThunderNative.YLEProcess(new YLEIsCameraManualFocusPositionSupported()) != 0;
    }

    public static boolean isCameraManualExposurePositionSupported() {
        return (int)ThunderNative.YLEProcess(new YLEIsCameraManualExposurePositionSupported()) != 0;
    }

    public static boolean isCameraZoomSupported() {
        return (int)ThunderNative.YLEProcess(new YLEIsCameraZoomSupported()) != 0;
    }

    public static float getCameraMaxZoomFactor() {
        long ret = ThunderNative.YLEProcess(new YLEGetCameraMaxZoomFactor());
        return (float)ret * 1.0f / 1000000.0f;
    }

    public static int setCameraZoomFactor(float zoomFactor) {
        return (int)ThunderNative.YLEProcess(new YLESetCameraZoomFactor(zoomFactor));
    }

    public static boolean isCameraTorchSupported() {
        return (int)ThunderNative.YLEProcess(new YLEIsCameraTorchSupported()) != 0;
    }

    public static int setCameraFocusPosition(float posX, float posY) {
        return (int)ThunderNative.YLEProcess(new YLESetCameraFocusPosition(posX, posY));
    }

    public static int setCameraExposurePosition(float posX, float posY) {
        return (int)ThunderNative.YLEProcess(new YLESetCameraExposurePosition(posX, posY));
    }

    public static boolean isCameraAutoFocusFaceModeSupported() {
        return (int)ThunderNative.YLEProcess(new YLEIsCameraAutoFocusFaceModeSupported()) != 0;
    }

    public static int setCameraAutoFocusFaceModeEnabled(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLESetCameraAutoFocusFaceModeEnabled(enable));
    }

    public static int startPushAudioStream(boolean bStart) {
        return (int)ThunderNative.YLEProcess(new YLEStartPushAudioStream(bStart));
    }

    public static int isAudioCaptureEnabled() {
        return (int)ThunderNative.YLEProcess(new YLEIsAudioCaptureEnabled());
    }

    public static int isAudioEncoderEnabled() {
        return (int)ThunderNative.YLEProcess(new YLEIsAudioEncoderEnabled());
    }

    public static int isAudioPublisherEnabled() {
        return (int)ThunderNative.YLEProcess(new YLEIsAudioPublisherEnabled());
    }

    public static int setAudioConfig(int profile, int commutMode, int scenarioMode) {
        return (int)ThunderNative.YLEProcess(new YLESetAudioConfig(profile, commutMode, scenarioMode));
    }

    public static int startPublishAudio(boolean bStart) {
        return (int)ThunderNative.YLEProcess(new YLEStartPublishAudio(bStart));
    }

    public static int startAudioCapture(boolean bStart) {
        return (int)ThunderNative.YLEProcess(new YLEStartAudioCapture(bStart));
    }

    public static int startAudioEncode(boolean bStart) {
        return (int)ThunderNative.YLEProcess(new YLEStartAudioEncode(bStart));
    }

    public static int setAudioPublishMode(int sourceType) {
        return (int)ThunderNative.YLEProcess(new YLESetAudioPublishMode(sourceType));
    }

    public static int setCustomAudioSource(boolean enabled, int sampleRate, int channel) {
        return (int)ThunderNative.YLEProcess(new YLESetCustomAudioSource(enabled, sampleRate, channel));
    }

    public static int setPubWatermark(ThunderBoltImage watermark) {
        return (int)ThunderNative.YLEProcess(new YLESetPubWatermark(watermark));
    }

    public static int pushCustomAudioFrame(byte[] data, long timeStamp) {
        return (int)ThunderNative.YLEProcess(new YLEPushCustomAudioFrame(data, timeStamp));
    }

    public static int startVideoEncode(boolean bStart) {
        return (int)ThunderNative.YLEProcess(new YLEStartVideoEncode(bStart));
    }

    public static int startPushVideoStream(boolean bStart) {
        return (int)ThunderNative.YLEProcess(new YLEStartPushVideoStream(bStart));
    }

    public static int startPreview(boolean bStart) {
        return (int)ThunderNative.YLEProcess(new YLEStartPreview(bStart));
    }

    public static int attachVideoCapture(Object capture, int captureType) {
        return (int)ThunderNative.YLEProcess(new YLEAttachVideoCapture(capture, captureType));
    }

    public static int setVideoEncoderConfig(ThunderVideoEncoderConfiguration vidCfg) {
        return (int)ThunderNative.YLEProcess(new YLESetVideoEncoderConfig(vidCfg.playType, vidCfg.publishMode));
    }

    public static int setCustomVideoPublishConfig(ThunderPublishVideoConfig publishInfo) {
        return (int)ThunderNative.YLEProcess(new YLESetCustomVideoPublishConfig(publishInfo.playType, publishInfo.mode, publishInfo.encodeResolutionWidth, publishInfo.encodeResolutionHeight, publishInfo.encodeBitrate, publishInfo.encodeFrameRate, publishInfo.lowStreamCfgs));
    }

    public static int setCustomStreamName(int streamType, String streamName) {
        return (int)ThunderNative.YLEProcess(new YLESetCustomStreamName(streamType, streamName));
    }

    public static int setSubscribeGroupInThunder(boolean bSubscribe) {
        return (int)ThunderNative.YLEProcess(new YLESetSubscribeGroupInThunder(bSubscribe));
    }

    public static int setCustomPublishAppid(int pubAppid) {
        return (int)ThunderNative.YLEProcess(new YLESetCustomPublishAppid(pubAppid));
    }

    public static void notifyNetState(int state) {
        ThunderNative.YLEProcess(new YLENotifyNetworkState(state));
    }

    public static void enterBackground() {
        ThunderNative.YLEProcess(new YLEEnterBackground());
    }

    public static void enterForeground() {
        ThunderNative.YLEProcess(new YLEEnterForeground());
    }

    public static int enableLoudSpeaker(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableLoudSpeaker(enable));
    }

    public static boolean getLoudSpeakerEnabled() {
        return (int)ThunderNative.YLEProcess(new YLEGetLoudSpeakerEnabled()) == 0;
    }

    public static int adaptToSystemKaraoke(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEadaptToSystemKaraoke(enable));
    }

    public static int enableInEarMonitor(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEenableInEarMonitor(enable));
    }

    public static int setEarMonitoringVolume(int volume) {
        return (int)ThunderNative.YLEProcess(new YLEsetEarMonitoringVolume(volume));
    }

    public static int enableEqualizer(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableEqualizer(enable));
    }

    public static int setGqGains(int[] gains) {
        return (int)ThunderNative.YLEProcess(new YLESetEqGains(gains));
    }

    public static int enableCompressor(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableCompressor(enable));
    }

    public static int setVoicePitch(float pitch) {
        return (int)ThunderNative.YLEProcess(new YLESetVoicePitch(pitch));
    }

    public static int enableHowlingDetector(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableHowlingDetector(enable));
    }

    public static int enableEchoDetector(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableEchoDetector(enable));
    }

    public static int startInputDeviceTest() {
        return (int)ThunderNative.YLEProcess(new YLEStartInputDeviceTest());
    }

    public static int stopInputDeviceTest() {
        return (int)ThunderNative.YLEProcess(new YLEStopInputDeviceTest());
    }

    public static int startOutputDeviceTest(String filePath) {
        return (int)ThunderNative.YLEProcess(new YLEStartOutputDeviceTest(filePath));
    }

    public static int stopOutputDeviceTest() {
        return (int)ThunderNative.YLEProcess(new YLEStopOutputDeviceTest());
    }

    public static int enableMicDenoise(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableMicDenoise(enable));
    }

    public static int enableAGC(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableAudioAGC(enable));
    }

    public static int enableAIDenoise(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableAIDenoise(enable));
    }

    public static boolean micDenoiseEnabled() {
        return (int)ThunderNative.YLEProcess(new YLEIsMicDenoiseEnable()) != 0;
    }

    public static int setCompressorParam(int threshold, int makeupGain, int ratio, int knee, int releaseTime, int attackTime) {
        return (int)ThunderNative.YLEProcess(new YLESetCompressorParam(threshold, makeupGain, ratio, knee, releaseTime, attackTime));
    }

    public static int enableReverb(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableReverb(enable));
    }

    public static int setReverbExParameter(float RoomSize, float PreDelay, float Reverberance, float HfDamping, float ToneLow, float ToneHigh, float WetGain, float DryGain, float StereoWidth) {
        return (int)ThunderNative.YLEProcess(new YLESetReverbExParameter(RoomSize, PreDelay, Reverberance, HfDamping, ToneLow, ToneHigh, WetGain, DryGain, StereoWidth));
    }

    public static int setLimiterParameter(float fCeiling, float fThreshold, float fPreGain, float fRelease, float fAttack, float fLookahead, float fLookaheadRatio, float fRMS, float fStLink) {
        return (int)ThunderNative.YLEProcess(new YLESetLimiterParameter(fCeiling, fThreshold, fPreGain, fRelease, fAttack, fLookahead, fLookaheadRatio, fRMS, fStLink));
    }

    public static int enableLimiter(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableLimiter(enable));
    }

    public static boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        return ThunderNative.YLEProcess(new YLEStartAudioSaver(fileName, saverMode, fileMode)) == 0L;
    }

    public static boolean stopAudioSaver() {
        return ThunderNative.YLEProcess(new YLEStopAudioSaver()) == 0L;
    }

    public static int startAudioRecord(String fileName, int saverMode, int sampleRate, int quality) {
        return (int)ThunderNative.YLEProcess(new YLEStartAudioRecord(fileName, saverMode, sampleRate, quality));
    }

    public static int stopAudioRecord() {
        return (int)ThunderNative.YLEProcess(new YLEStopAudioRecord());
    }

    public static int enableAudioPlaySpectrum(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableAudioPlaySpectrum(enable));
    }

    public static int setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        return (int)ThunderNative.YLEProcess(new YLESetAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS));
    }

    public static int enableVoicePosition(boolean enable) {
        return (int)ThunderNative.YLEProcess(new YLEEnableVoicePosition(enable));
    }

    public static boolean setSoundEffect(int soundEffectMode) {
        return 0L == ThunderNative.YLEProcess(new YLESetSoundEffect(soundEffectMode));
    }

    public static boolean setVoiceChanger(int mode) {
        return 0L == ThunderNative.YLEProcess(new YLESetVoiceChanger(mode));
    }

    public static int setVideoFrameObserver(String uid, IVideoDecodeObserver observer) {
        return (int)ThunderNative.YLEProcess(new YLEVideoFrameObserverStringUid(uid, observer));
    }

    public static int setRecordingAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        return (int)ThunderNative.YLEProcess(new YLESetRecordingAudioFrameParameters(sampleRate, channel, mode, samplesPerCall));
    }

    public static int setMixedAudioFrameParameters(int sampleRate, int channel, int samplesPerCall) {
        return (int)ThunderNative.YLEProcess(new YLESetMixedAudioFrameParameters(sampleRate, channel, samplesPerCall));
    }

    public static int updatePublishOriginStreamUrl(boolean bAdd, String srcUrl) {
        return (int)ThunderNative.YLEProcess(new YLEUpdatePublishOriginStreamUrl(bAdd, srcUrl));
    }

    public static int updatePublishTranscodingStreamUrl(String taskId, boolean bAdd, String transCodingUrl) {
        return (int)ThunderNative.YLEProcess(new YLEUpdatePublishTranscodingStreamUrl(taskId, bAdd, transCodingUrl));
    }

    public static int setLiveTranscodingTask(String taskId, LiveTranscoding transcoding) {
        return (int)ThunderNative.YLEProcess(new YLESetLiveTranscodingTask(taskId, transcoding));
    }

    public static int removeLiveTranscodingTask(String taskId) {
        return (int)ThunderNative.YLEProcess(new YLERemoveLiveTranscodingTask(taskId));
    }

    public static int setSidAndSubsid(int sid, int subsid) {
        return (int)ThunderNative.YLEProcess(new YLESetSidAndSubsid(sid, subsid));
    }

    public static int makeBehaviorEvent(String name, String val, String oval, int level) {
        return (int)ThunderNative.YLEProcess(new YLEMakeBehaviorEvent(name, val, oval, level));
    }

    public static int prefetchStreams(String uid, LinkedList<String> roomIds) {
        return (int)ThunderNative.YLEProcess(new YLEPrefetchStreams(uid, roomIds));
    }

    public static int queryStreams(LinkedList<String> roomIds) {
        return (int)ThunderNative.YLEProcess(new YLEQueryStreams(roomIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void notificationCallback(int type, byte[] data) {
        s_notificationLock.lock();
        try {
            Object[] handlers;
            YLNBase yln;
            if (s_notificationDispatcher == null) {
                return;
            }
            switch (type) {
                case 0: {
                    yln = new YLNFirstVideoFrameSend();
                    break;
                }
                case 1: {
                    yln = new YLNFirstAudioFrameSend();
                    break;
                }
                case 2: {
                    yln = new YLNJoinRoomSuccess();
                    break;
                }
                case 3: {
                    yln = new YLNLeaveRoom();
                    break;
                }
                case 4: {
                    yln = new YLNRemoteVideoPlay();
                    break;
                }
                case 5: {
                    yln = new YLNBizAuthRes();
                    break;
                }
                case 6: {
                    yln = new YLNSdkAuthRes();
                    break;
                }
                case 7: {
                    yln = new YLNUserBanned();
                    break;
                }
                case 8: {
                    yln = new YLNTokenRequest();
                    break;
                }
                case 9: {
                    yln = new YLNTokenWillExpire();
                    break;
                }
                case 10: {
                    yln = new YLNAudioCaptureVolume();
                    break;
                }
                case 11: {
                    yln = new YLNAudioPlayVolume();
                    break;
                }
                case 12: {
                    yln = new YLNAudioPlayData();
                    break;
                }
                case 13: {
                    yln = new YLNAudioPlaySpectrumData();
                    break;
                }
                case 14: {
                    yln = new YLNAudioCapturePcmData();
                    break;
                }
                case 15: {
                    yln = new YLNUserAppMsgData();
                    break;
                }
                case 16: {
                    yln = new YLNAppMsgDataFailStatus();
                    break;
                }
                case 17: {
                    yln = new YLNAudioRenderPcmData();
                    break;
                }
                case 18: {
                    yln = new YLNHttpsRequest();
                    break;
                }
                case 19: {
                    yln = new YLNRemoteVideoStopped();
                    break;
                }
                case 20: {
                    yln = new YLNRemoteAudioStopped();
                    break;
                }
                case 21: {
                    yln = new YLNVideoSizeChange();
                    break;
                }
                case 53: {
                    yln = new YLNVideoCaptureExposureChanged();
                    break;
                }
                case 52: {
                    yln = new YLNVideoCaptureFocusChanged();
                    break;
                }
                case 22: {
                    yln = new YLNConnectionStatus();
                    break;
                }
                case 23: {
                    yln = new YLNConnectionLost();
                    break;
                }
                case 24: {
                    yln = new YLNRoomStats();
                    break;
                }
                case 25: {
                    yln = new YLNNetworkStateChange();
                    break;
                }
                case 26: {
                    yln = new YLNPublishStreamToCdnStatus();
                    break;
                }
                case 27: {
                    yln = new YLNUserJoined();
                    break;
                }
                case 28: {
                    yln = new YLNUserOffline();
                    break;
                }
                case 29: {
                    yln = new YLNNetworkQuality();
                    break;
                }
                case 30: {
                    yln = new YLNAudioExtraInfo();
                    break;
                }
                case 31: {
                    yln = new YLNAudioExtraFailStatus();
                    break;
                }
                case 32: {
                    yln = new YLNVideoExtraInfo();
                    break;
                }
                case 33: {
                    yln = new YLNMixVideoExtraInfo();
                    break;
                }
                case 34: {
                    yln = new YLNMixAudioExtraInfo();
                    break;
                }
                case 35: {
                    yln = new YLNAudioCaptureStatus();
                    break;
                }
                case 36: {
                    yln = new YLNVideoCaptureStatus();
                    break;
                }
                case 37: {
                    yln = new YLNLocalVideoStats();
                    break;
                }
                case 39: {
                    yln = new YLNLocalAudioStats();
                    break;
                }
                case 38: {
                    yln = new YLNRemoteVideoStats();
                    break;
                }
                case 40: {
                    yln = new YLNRemoteAudioStats();
                    break;
                }
                case 41: {
                    yln = new YLNRemoteAudioStateChanged();
                    break;
                }
                case 43: {
                    yln = new YLNRemoteVideoStateChanged();
                    break;
                }
                case 42: {
                    yln = new YLNRemoteAudioPlay();
                    break;
                }
                case 44: {
                    yln = new YLNLocalAudioStatusChanged();
                    break;
                }
                case 46: {
                    yln = new YLNLocalVideoStatusChanged();
                    break;
                }
                case 54: {
                    yln = new YLNPrivateCallBack();
                    break;
                }
                case 45: {
                    yln = new YLNDeviceStats();
                    break;
                }
                case 56: {
                    yln = new YLNUserRoleChanged();
                    break;
                }
                case 1000: {
                    yln = new YLNOnVideoConfig();
                    break;
                }
                case 1001: {
                    yln = new YLNOnBlackCodecConfig();
                    break;
                }
                case 47: {
                    yln = new YLNAudioRouteChanged();
                    break;
                }
                case 48: {
                    yln = new YLNHowlingDetectResult();
                    break;
                }
                case 49: {
                    yln = new YLNEchoDetectResult();
                    break;
                }
                case 50: {
                    yln = new YLNAudioInputDeviceTestVolume();
                    break;
                }
                case 51: {
                    yln = new YLNAudioOutputDeviceTestVolume();
                    break;
                }
                case 55: {
                    yln = new YLNAudioRecordState();
                    break;
                }
                default: {
                    ThunderLog.warn("ycallback-Java", "unknown notification type %d", type);
                    return;
                }
            }
            yln.unmarshall(data);
            if (type < 1000 && (handlers = s_notificationDispatcher.collectNotificationHandlers()) != null) {
                for (Object handler : handlers) {
                    Message msg = Message.obtain();
                    msg.what = type;
                    msg.obj = yln.get();
                    ((Handler)handler).sendMessage(msg);
                }
            }
            switch (type) {
                case 0: {
                    Object notification = (ThunderNotification.ThunderFirstVideoFrameSend)yln.get();
                    ThunderLog.release("ycallback-Java", "kThunderNotification_FirstVideoFrameSend mElapsedTime= %d", ((ThunderNotification.ThunderFirstVideoFrameSend)notification).getElapsedTime());
                    return;
                }
                case 38: {
                    Object notification = (ThunderNotification.RemoteVideoStats)yln.get();
                    if (s_remoteVideoStatsNotificationCount++ % 10 != 0) return;
                    if (!ThunderLog.isInfoValid()) return;
                    ThunderLog.info("ycallback-Java", "kThunderAPINotification_RemoteVideoStats: uid %s delay %d width %d height %d receivedBitrate %d decoderFrameRate %d renderFrameRate %d packetLossRate %d rxStreamType %d frozenTime %d frozenRate %dcodecType %d decodedType %d", ((ThunderNotification.RemoteVideoStats)notification).getUid(), ((ThunderNotification.RemoteVideoStats)notification).getDelay(), ((ThunderNotification.RemoteVideoStats)notification).getWidth(), ((ThunderNotification.RemoteVideoStats)notification).getHeight(), ((ThunderNotification.RemoteVideoStats)notification).getReceivedBitrate(), ((ThunderNotification.RemoteVideoStats)notification).getDecoderFrameRate(), ((ThunderNotification.RemoteVideoStats)notification).getRenderFrameRate(), ((ThunderNotification.RemoteVideoStats)notification).getPacketLossRate(), ((ThunderNotification.RemoteVideoStats)notification).getRxStreamType(), ((ThunderNotification.RemoteVideoStats)notification).getFrozenTime(), ((ThunderNotification.RemoteVideoStats)notification).getFrozenRate(), ((ThunderNotification.RemoteVideoStats)notification).getCodecType(), ((ThunderNotification.RemoteVideoStats)notification).getDecodedType());
                    return;
                }
                case 40: {
                    Object notification = (ThunderNotification.RemoteAudioStats)yln.get();
                    if (s_remoteAudioStatsNotificationCount++ % 10 != 0) return;
                    if (!ThunderLog.isInfoValid()) return;
                    ThunderLog.info("ycallback-Java", "kThunderAPINotification_RemoteAudioStats: uid %s quality %d networkTransportDelay %d jitterBufferDelay %d totalDelay %d frameLossRate %d numChannels %d receivedSampleRate %d receivedBitrate %d frozenTime %d frozenRate %d", ((ThunderNotification.RemoteAudioStats)notification).getUid(), ((ThunderNotification.RemoteAudioStats)notification).getQuality(), ((ThunderNotification.RemoteAudioStats)notification).getNetworkTransportDelay(), ((ThunderNotification.RemoteAudioStats)notification).getJitterBufferDelay(), ((ThunderNotification.RemoteAudioStats)notification).getTotalDelay(), ((ThunderNotification.RemoteAudioStats)notification).getFrameLossRate(), ((ThunderNotification.RemoteAudioStats)notification).getNumChannels(), ((ThunderNotification.RemoteAudioStats)notification).getReceivedSampleRate(), ((ThunderNotification.RemoteAudioStats)notification).getReceivedBitrate(), ((ThunderNotification.RemoteAudioStats)notification).getFrozenTime(), ((ThunderNotification.RemoteAudioStats)notification).getFrozenRate());
                    return;
                }
            }
            return;
        }
        finally {
            s_notificationLock.unlock();
        }
    }

    public static void logCallback(int level, byte[] tag, byte[] msg) {
        if (tag == null || msg == null || s_logCallback == null) {
            return;
        }
        s_logCallback.onThunderLogWithLevel(level, new String(tag), new String(msg));
    }

    public static void audioFilePlayCallback(Object obj, int event, int errorCode) {
        if (obj instanceof ThunderAudioFilePlayer) {
            ThunderAudioFilePlayer player = (ThunderAudioFilePlayer)obj;
            player.onPlayEvent(event, errorCode);
        }
    }

    public static void audioFilePlayVolumeCallback(Object obj, int volume, int currentMs, int totalMs) {
        if (obj instanceof ThunderAudioFilePlayer) {
            ThunderAudioFilePlayer player = (ThunderAudioFilePlayer)obj;
            player.onAudioFileVolume(volume, currentMs, totalMs);
        }
    }

    public static interface NotificationDispatcher {
        public void registerNotificationHandler(Handler var1);

        public void unregisterNotificationHandler(Handler var1);

        public Object[] collectNotificationHandlers();
    }

    private static class YLNAudioRecordState
    extends YLNBase {
        private YLNAudioRecordState() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int errorCode = this.popInt();
            int duration = this.popInt();
            this.notification = new ThunderNotification.ThunderAudioRecordState(errorCode, duration);
        }
    }

    private static class YLNAudioOutputDeviceTestVolume
    extends YLNBase {
        private YLNAudioOutputDeviceTestVolume() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAudioOutputDeviceTestVolume(this.popInt());
        }
    }

    private static class YLNAudioInputDeviceTestVolume
    extends YLNBase {
        private YLNAudioInputDeviceTestVolume() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAudioInputDeviceTestVolume(this.popInt());
        }
    }

    private static class YLNEchoDetectResult
    extends YLNBase {
        private YLNEchoDetectResult() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderEchoDetectResult(this.popBool());
        }
    }

    private static class YLNHowlingDetectResult
    extends YLNBase {
        private YLNHowlingDetectResult() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderHowlingDetectResult(this.popBool());
        }
    }

    private static class YLNAudioRouteChanged
    extends YLNBase {
        private YLNAudioRouteChanged() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAudioRouteChanged(this.popInt());
        }
    }

    private static class YLNUserRoleChanged
    extends YLNBase {
        private YLNUserRoleChanged() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderUserRoleChanged(this.popInt(), this.popInt());
        }
    }

    private static class YLNDeviceStats
    extends YLNBase {
        private YLNDeviceStats() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int cpuTotal = this.popInt();
            int cpuApp = this.popInt();
            int memTotal = this.popInt();
            int memApp = this.popInt();
            this.notification = CpuTool.OS_VERSION.compareTo("8.0") >= 0 ? new ThunderNotification.ThunderDeviceStats((double)cpuTotal / 100.0, CpuTool.getAppCpuRateAverage(), (double)memTotal / 100.0, (double)memApp / 100.0) : new ThunderNotification.ThunderDeviceStats((double)cpuTotal / 100.0, (double)cpuApp / 100.0, (double)memTotal / 100.0, (double)memApp / 100.0);
        }
    }

    private static class YLNLocalVideoStatusChanged
    extends YLNBase {
        private YLNLocalVideoStatusChanged() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.LocalVideoStatusChanged(this.popInt(), this.popInt());
        }
    }

    private static class YLNLocalAudioStatusChanged
    extends YLNBase {
        private YLNLocalAudioStatusChanged() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.LocalAudioStatusChanged(this.popInt(), this.popInt());
        }
    }

    private static class YLNRemoteAudioPlay
    extends YLNBase {
        private YLNRemoteAudioPlay() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderRemoteAudioPlay(this.popString16(), this.popInt());
        }
    }

    private static class YLNPrivateCallBack
    extends YLNBase {
        private YLNPrivateCallBack() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderPrivateCallBack(this.popInt(), this.popString16());
        }
    }

    private static class YLNRemoteVideoStateChanged
    extends YLNBase {
        private YLNRemoteVideoStateChanged() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderRemoteVideoStateChanged(this.popString16(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNRemoteAudioStateChanged
    extends YLNBase {
        private YLNRemoteAudioStateChanged() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderRemoteAudioStateChanged(this.popString16(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNRemoteAudioStats
    extends YLNBase {
        private YLNRemoteAudioStats() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.RemoteAudioStats(this.popString16(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNRemoteVideoStats
    extends YLNBase {
        private YLNRemoteVideoStats() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.RemoteVideoStats(this.popString16(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNLocalAudioStats
    extends YLNBase {
        private YLNLocalAudioStats() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderLocalAudioStats(this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNLocalVideoStats
    extends YLNBase {
        private YLNLocalVideoStats() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderLocalVideoStats(this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNOnBlackCodecConfig
    extends YLNBase {
        private YLNOnBlackCodecConfig() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            VideoConfigManager.instance().notifyBlackCodecConfig(this.popString16());
        }
    }

    private static class YLNOnVideoConfig
    extends YLNBase {
        private YLNOnVideoConfig() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            HashMap<Integer, VideoLiveConfig> configMap = new HashMap<Integer, VideoLiveConfig>();
            int configSize = this.popInt();
            for (int i = 0; i < configSize; ++i) {
                int key = this.popInt();
                VideoLiveConfig videoConfig = new VideoLiveConfig();
                videoConfig.entEncode = this.popInt();
                videoConfig.bframeswitch = this.popInt();
                videoConfig.intervalSecs = this.popInt();
                int resolutionSize = this.popInt();
                ArrayList<VideoLiveConfig.ResolutionInfo> resolutionList = new ArrayList<VideoLiveConfig.ResolutionInfo>();
                for (int j = 0; j < resolutionSize; ++j) {
                    VideoLiveConfig.ResolutionInfo resolutionInfo2 = new VideoLiveConfig.ResolutionInfo(videoConfig);
                    resolutionInfo2.key = this.popInt();
                    resolutionInfo2.isDefault = this.popInt();
                    resolutionInfo2.width = this.popInt();
                    resolutionInfo2.height = this.popInt();
                    resolutionInfo2.frameRate = this.popInt();
                    resolutionInfo2.bframeNum = this.popInt();
                    resolutionInfo2.encode_id = this.popInt();
                    resolutionInfo2.encode_param = this.popString16();
                    resolutionInfo2.previewWidth = this.popInt();
                    resolutionInfo2.previewHeight = this.popInt();
                    resolutionInfo2.previewFrameRate = this.popInt();
                    resolutionInfo2.codeRate = this.popInt();
                    resolutionInfo2.maxrate = this.popInt();
                    resolutionInfo2.minrate = this.popInt();
                    resolutionInfo2.currate = this.popInt();
                    resolutionInfo2.description = this.popString16();
                    resolutionInfo2.transcoding = this.popInt();
                    int modifySize = this.popInt();
                    ArrayList<VideoLiveConfig.ModifyInfo> modifyList = new ArrayList<VideoLiveConfig.ModifyInfo>();
                    for (int k = 0; k < modifySize; ++k) {
                        VideoLiveConfig.ModifyInfo modifyInfo = new VideoLiveConfig.ModifyInfo(videoConfig);
                        modifyInfo.width = this.popInt();
                        modifyInfo.height = this.popInt();
                        modifyInfo.maxCodeRate = this.popInt();
                        modifyInfo.minCodeRate = this.popInt();
                        modifyInfo.encode_id = this.popInt();
                        modifyInfo.encode_param = this.popString16();
                        modifyInfo.maxFrameRate = this.popInt();
                        modifyInfo.minFrameRate = this.popInt();
                        modifyList.add(modifyInfo);
                    }
                    resolutionInfo2.modifyConfig = modifyList;
                    resolutionList.add(resolutionInfo2);
                }
                videoConfig.resolutions = resolutionList;
                configMap.put(key, videoConfig);
            }
            VideoConfigManager.instance().notifyVideoConfig(configMap);
        }
    }

    private static class YLNVideoCaptureStatus
    extends YLNBase {
        private YLNVideoCaptureStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderVideoCaptureStatus(this.popInt());
        }
    }

    private static class YLNAudioCaptureStatus
    extends YLNBase {
        private YLNAudioCaptureStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAudioCaptureStatus(this.popInt());
        }
    }

    private static class YLNMixAudioExtraInfo
    extends YLNBase {
        private YLNMixAudioExtraInfo() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            String mUid = this.popString16();
            ArrayList<ThunderEventHandler.MixAudioInfo> mixAudioExtraInfos = new ArrayList<ThunderEventHandler.MixAudioInfo>();
            int size = this.popInt();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    ThunderEventHandler.MixAudioInfo audioExtra = new ThunderEventHandler.MixAudioInfo();
                    audioExtra.uid = this.popString16();
                    audioExtra.volume = this.popInt();
                    mixAudioExtraInfos.add(audioExtra);
                }
            }
            this.notification = new ThunderNotification.ThunderMixAudioExtraInfo(mUid, mixAudioExtraInfos);
        }
    }

    private static class YLNMixVideoExtraInfo
    extends YLNBase {
        private YLNMixVideoExtraInfo() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            String mUid = this.popString16();
            ArrayList<ThunderEventHandler.MixVideoInfo> mixVideoExtraInfos = new ArrayList<ThunderEventHandler.MixVideoInfo>();
            int size = this.popInt();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    ThunderEventHandler.MixVideoInfo extraInfo = new ThunderEventHandler.MixVideoInfo();
                    extraInfo.uid = this.popString16();
                    extraInfo.width = this.popInt();
                    extraInfo.height = this.popInt();
                    extraInfo.cropX = this.popInt();
                    extraInfo.cropY = this.popInt();
                    extraInfo.cropW = this.popInt();
                    extraInfo.cropH = this.popInt();
                    extraInfo.layoutX = this.popInt();
                    extraInfo.layoutY = this.popInt();
                    extraInfo.layoutW = this.popInt();
                    extraInfo.layoutH = this.popInt();
                    extraInfo.zOrder = this.popInt();
                    extraInfo.alpha = (float)this.popInt() / 10.0f;
                    mixVideoExtraInfos.add(extraInfo);
                }
            }
            this.notification = new ThunderNotification.ThunderMixVideoExtraInfo(mUid, mixVideoExtraInfos);
        }
    }

    private static class YLNVideoExtraInfo
    extends YLNBase {
        private YLNVideoExtraInfo() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderVideoExtraInfo(this.popString16(), this.popBytes());
        }
    }

    private static class YLNAudioExtraFailStatus
    extends YLNBase {
        private YLNAudioExtraFailStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAudioExtraFailStatus(this.popInt());
        }
    }

    private static class YLNAudioExtraInfo
    extends YLNBase {
        private YLNAudioExtraInfo() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAudioExtraInfo(this.popString16(), this.popBytes());
        }
    }

    private static class YLNNetworkQuality
    extends YLNBase {
        private YLNNetworkQuality() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderNetworkQuality(this.popString16(), this.popInt(), this.popInt());
        }
    }

    private static class YLNUserOffline
    extends YLNBase {
        private YLNUserOffline() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderUserOffline(this.popString16(), this.popInt());
        }
    }

    private static class YLNUserJoined
    extends YLNBase {
        private YLNUserJoined() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderUserJoined(this.popString16(), this.popInt());
        }
    }

    private static class YLNPublishStreamToCdnStatus
    extends YLNBase {
        private YLNPublishStreamToCdnStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderPublishStreamToCdnStatus(this.popString16(), this.popInt());
        }
    }

    private static class YLNNetworkStateChange
    extends YLNBase {
        private YLNNetworkStateChange() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderNetworkStateChange(this.popInt());
        }
    }

    private static class YLNRoomStats
    extends YLNBase {
        private YLNRoomStats() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.RoomStats(this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNConnectionLost
    extends YLNBase {
        private YLNConnectionLost() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderConnectionLost();
        }
    }

    private static class YLNConnectionStatus
    extends YLNBase {
        private YLNConnectionStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderConnectionStatus(this.popInt());
        }
    }

    private static class YLNVideoCaptureFocusChanged
    extends YLNBase {
        private YLNVideoCaptureFocusChanged() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderVideoCaptureFocusChanged(this.popInt(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNVideoCaptureExposureChanged
    extends YLNBase {
        private YLNVideoCaptureExposureChanged() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderVideoCaptureExposureChanged(this.popInt(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNVideoSizeChange
    extends YLNBase {
        private YLNVideoSizeChange() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderVideoSizeChange(this.popString16(), this.popInt(), this.popInt());
        }
    }

    private static class YLNRemoteAudioStopped
    extends YLNBase {
        private YLNRemoteAudioStopped() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderRemoteAudioStopped(this.popString16(), this.popString16(), this.popBool());
        }
    }

    private static class YLNRemoteVideoStopped
    extends YLNBase {
        private YLNRemoteVideoStopped() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderRemoteVideoStopped(this.popString16(), this.popString16(), this.popBool());
        }
    }

    private static class YLNHttpsRequest
    extends YLNBase {
        private YLNHttpsRequest() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderHttpsRequest(this.popString16(), this.popInt());
        }
    }

    private static class YLNAudioRenderPcmData
    extends YLNBase {
        private YLNAudioRenderPcmData() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            byte[] data = this.popBytes32();
            int dataSize = this.popInt();
            int duration = this.popInt();
            int sampleRate = this.popInt();
            int channel = this.popInt();
            this.notification = new ThunderNotification.ThunderAudioRenderPcmData(dataSize, data, duration, sampleRate, channel);
        }
    }

    private static class YLNAppMsgDataFailStatus
    extends YLNBase {
        private YLNAppMsgDataFailStatus() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAppMsgDataFailStatus(this.popInt());
        }
    }

    private static class YLNUserAppMsgData
    extends YLNBase {
        private YLNUserAppMsgData() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderUserAppMsgData(this.popInt(), this.popString16UTF8(), this.popString16());
        }
    }

    private static class YLNAudioCapturePcmData
    extends YLNBase {
        private YLNAudioCapturePcmData() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAudioCapturePcmData(this.popBytes32(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNAudioPlaySpectrumData
    extends YLNBase {
        private YLNAudioPlaySpectrumData() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAudioPlaySpectrumData(this.popBytes32());
        }
    }

    private static class YLNAudioPlayData
    extends YLNBase {
        private YLNAudioPlayData() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAudioPlayData(this.popString16(), this.popInt(), this.popInt(), this.popInt(), this.popInt(), this.popBytes32());
        }
    }

    private static class YLNAudioPlayVolume
    extends YLNBase {
        private YLNAudioPlayVolume() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int size = this.popInt();
            HashSet<ThunderEventHandler.AudioVolumeInfo> playVolumes = new HashSet<ThunderEventHandler.AudioVolumeInfo>();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    ThunderEventHandler.AudioVolumeInfo audioPlayVolume = new ThunderEventHandler.AudioVolumeInfo();
                    audioPlayVolume.uid = this.popString16();
                    audioPlayVolume.originalVolume = this.popInt();
                    audioPlayVolume.volume = this.popInt();
                    audioPlayVolume.pts = this.popInt();
                    playVolumes.add(audioPlayVolume);
                }
            }
            int totalVolume = this.popInt();
            this.notification = new ThunderNotification.ThunderAudioPlayVolume(totalVolume, playVolumes);
        }
    }

    private static class YLNAudioCaptureVolume
    extends YLNBase {
        private YLNAudioCaptureVolume() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderAudioCaptureVolume(this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNTokenWillExpire
    extends YLNBase {
        private YLNTokenWillExpire() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderTokenWillExpire(this.popString16());
        }
    }

    private static class YLNTokenRequest
    extends YLNBase {
        private YLNTokenRequest() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderTokenRequest();
        }
    }

    private static class YLNUserBanned
    extends YLNBase {
        private YLNUserBanned() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderUserBanned(this.popBool());
        }
    }

    private static class YLNSdkAuthRes
    extends YLNBase {
        private YLNSdkAuthRes() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderSdkAuthRes(this.popInt());
        }
    }

    private static class YLNBizAuthRes
    extends YLNBase {
        private YLNBizAuthRes() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderBizAuthStreamRes(this.popBool(), this.popInt(), this.popInt());
        }
    }

    private static class YLNRemoteVideoPlay
    extends YLNBase {
        private YLNRemoteVideoPlay() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderRemoteVideoPlay(this.popString16(), this.popInt(), this.popInt(), this.popInt());
        }
    }

    private static class YLNLeaveRoom
    extends YLNBase {
        private YLNLeaveRoom() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderLeaveRoom();
        }
    }

    private static class YLNJoinRoomSuccess
    extends YLNBase {
        private YLNJoinRoomSuccess() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderJoinRoomSuccess(this.popString16(), this.popString16(), this.popInt());
        }
    }

    private static class YLNFirstAudioFrameSend
    extends YLNBase {
        private YLNFirstAudioFrameSend() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderFirstAudioFrameSend(this.popInt());
        }
    }

    private static class YLNFirstVideoFrameSend
    extends YLNBase {
        private YLNFirstVideoFrameSend() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new ThunderNotification.ThunderFirstVideoFrameSend(this.popInt());
        }
    }

    private static class YLNBase
    extends Marshallable {
        Object notification;

        private YLNBase() {
        }

        public Object get() {
            return this.notification;
        }
    }

    private static class YLESetMixedAudioFrameParameters
    extends YLEBase {
        private int sampleRate;
        private int channel;
        private int samplesPerCall;

        YLESetMixedAudioFrameParameters(int _sampleRate, int _channel, int _samplesPerCall) {
            this.event = 14;
            this.sampleRate = _sampleRate;
            this.channel = _channel;
            this.samplesPerCall = _samplesPerCall;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.sampleRate);
            this.pushInt(this.channel);
            this.pushInt(this.samplesPerCall);
            return super.marshall();
        }
    }

    private static class YLESetRecordingAudioFrameParameters
    extends YLEBase {
        private int sampleRate;
        private int room;
        private int mode;
        private int samplesPerCall;

        YLESetRecordingAudioFrameParameters(int _sampleRate, int _room, int _mode, int _samplesPerCall) {
            this.event = 12;
            this.sampleRate = _sampleRate;
            this.room = _room;
            this.mode = _mode;
            this.samplesPerCall = _samplesPerCall;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.sampleRate);
            this.pushInt(this.room);
            this.pushInt(this.mode);
            this.pushInt(this.samplesPerCall);
            return super.marshall();
        }
    }

    private static class YLEVideoFrameObserverStringUid
    extends YLEBase {
        private Object observer;
        private String uid;

        YLEVideoFrameObserverStringUid(String _uid, Object _observer) {
            this.event = 21;
            this.observer = _observer;
            this.uid = _uid;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.uid);
            this.pushInt64(ThunderNative.YYLiveObjectToPtr(this.observer));
            return super.marshall();
        }
    }

    private static class YLESetVoiceChanger
    extends YLEBase {
        private int voiceChangerMode;

        YLESetVoiceChanger(int mode) {
            this.event = 116;
            this.voiceChangerMode = mode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.voiceChangerMode);
            return super.marshall();
        }
    }

    private static class YLESetSoundEffect
    extends YLEBase {
        private int soundEffectMode;

        YLESetSoundEffect(int _soundEffectMode) {
            this.event = 115;
            this.soundEffectMode = _soundEffectMode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.soundEffectMode);
            return super.marshall();
        }
    }

    private static class YLEEnableVoicePosition
    extends YLEBase {
        private boolean enable;

        YLEEnableVoicePosition(boolean enable) {
            this.event = 114;
            this.enable = enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetAudioPlaySpectrumInfo
    extends YLEBase {
        private int spectrumLen;
        private int notifyIntervalMS;

        YLESetAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
            this.event = 113;
            this.spectrumLen = spectrumLen;
            this.notifyIntervalMS = notifyIntervalMS;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.spectrumLen);
            this.pushInt(this.notifyIntervalMS);
            return super.marshall();
        }
    }

    private static class YLEEnableAudioPlaySpectrum
    extends YLEBase {
        private boolean enable;

        YLEEnableAudioPlaySpectrum(boolean enable) {
            this.event = 112;
            this.enable = enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEStopAudioRecord
    extends YLEBase {
        YLEStopAudioRecord() {
            this.event = 149;
        }
    }

    private static class YLEStartAudioRecord
    extends YLEBase {
        private String fileName;
        private int saverMode;
        private int sampleRate;
        private int quality;

        YLEStartAudioRecord(String _fileName, int _saverMode, int _sampleRate, int _quality) {
            this.event = 148;
            this.fileName = _fileName;
            this.saverMode = _saverMode;
            this.sampleRate = _sampleRate;
            this.quality = _quality;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.fileName);
            this.pushInt(this.saverMode);
            this.pushInt(this.sampleRate);
            this.pushInt(this.quality);
            return super.marshall();
        }
    }

    private static class YLEStopAudioSaver
    extends YLEBase {
        YLEStopAudioSaver() {
            this.event = 111;
        }
    }

    private static class YLEStartAudioSaver
    extends YLEBase {
        private String fileName;
        private int saverMode;
        private int fileMode;

        YLEStartAudioSaver(String _fileName, int _saverMode, int _fileMode) {
            this.event = 110;
            this.fileName = _fileName;
            this.saverMode = _saverMode;
            this.fileMode = _fileMode;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.fileName);
            this.pushInt(this.saverMode);
            this.pushInt(this.fileMode);
            return super.marshall();
        }
    }

    private static class YLEEnableLimiter
    extends YLEBase {
        private boolean enable;

        YLEEnableLimiter(boolean _enable) {
            this.event = 119;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetLimiterParameter
    extends YLEBase {
        private float m_fCeiling;
        private float m_fRelease;
        private float m_fLookaheadRatio;
        private float m_fThreshold;
        private float m_fAttack;
        private float m_fRMS;
        private float m_fPreGain;
        private float m_fLookahead;
        private float m_fStLink;

        YLESetLimiterParameter(float fCeiling, float fThreshold, float fPreGain, float fRelease, float fAttack, float fLookahead, float fLookaheadRatio, float fRMS, float fStLink) {
            this.event = 108;
            this.m_fCeiling = fCeiling;
            this.m_fRelease = fRelease;
            this.m_fLookaheadRatio = fLookaheadRatio;
            this.m_fThreshold = fThreshold;
            this.m_fAttack = fAttack;
            this.m_fRMS = fRMS;
            this.m_fPreGain = fPreGain;
            this.m_fLookahead = fLookahead;
            this.m_fStLink = fStLink;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.m_fCeiling * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fRelease * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fLookaheadRatio * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fThreshold * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fAttack * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fRMS * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fPreGain * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fLookahead * 1000000.0f));
            this.pushString16(String.valueOf(this.m_fStLink * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLESetReverbExParameter
    extends YLEBase {
        private float mRoomSize;
        private float mPreDelay;
        private float mReverberance;
        private float mHfDamping;
        private float mToneLow;
        private float mToneHigh;
        private float mWetGain;
        private float mDryGain;
        private float mStereoWidth;

        YLESetReverbExParameter(float RoomSize, float PreDelay, float Reverberance, float HfDamping, float ToneLow, float ToneHigh, float WetGain, float DryGain, float StereoWidth) {
            this.event = 107;
            this.mRoomSize = RoomSize;
            this.mPreDelay = PreDelay;
            this.mReverberance = Reverberance;
            this.mHfDamping = HfDamping;
            this.mToneLow = ToneLow;
            this.mToneHigh = ToneHigh;
            this.mWetGain = WetGain;
            this.mDryGain = DryGain;
            this.mStereoWidth = StereoWidth;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.mRoomSize * 1000000.0f));
            this.pushString16(String.valueOf(this.mPreDelay * 1000000.0f));
            this.pushString16(String.valueOf(this.mReverberance * 1000000.0f));
            this.pushString16(String.valueOf(this.mHfDamping * 1000000.0f));
            this.pushString16(String.valueOf(this.mToneLow * 1000000.0f));
            this.pushString16(String.valueOf(this.mToneHigh * 1000000.0f));
            this.pushString16(String.valueOf(this.mWetGain * 1000000.0f));
            this.pushString16(String.valueOf(this.mDryGain * 1000000.0f));
            this.pushString16(String.valueOf(this.mStereoWidth * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLEEnableReverb
    extends YLEBase {
        private boolean enable;

        YLEEnableReverb(boolean _enable) {
            this.event = 106;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetCompressorParam
    extends YLEBase {
        private int mthreshold;
        private int mmakeupGain;
        private int mratio;
        private int mknee;
        private int mreleaseTime;
        private int mattackTime;

        YLESetCompressorParam(int threshold, int makeupGain, int ratio, int knee, int releaseTime, int attackTime) {
            this.event = 105;
            this.mthreshold = threshold;
            this.mmakeupGain = makeupGain;
            this.mratio = ratio;
            this.mknee = knee;
            this.mreleaseTime = releaseTime;
            this.mattackTime = attackTime;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.mthreshold);
            this.pushInt(this.mmakeupGain);
            this.pushInt(this.mratio);
            this.pushInt(this.mknee);
            this.pushInt(this.mreleaseTime);
            this.pushInt(this.mattackTime);
            return super.marshall();
        }
    }

    private static class YLEIsMicDenoiseEnable
    extends YLEBase {
        YLEIsMicDenoiseEnable() {
            this.event = 138;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEEnableAIDenoise
    extends YLEBase {
        private boolean enable;

        YLEEnableAIDenoise(boolean _enable) {
            this.event = 153;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableAudioAGC
    extends YLEBase {
        private boolean enable;

        YLEEnableAudioAGC(boolean _enable) {
            this.event = 147;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableMicDenoise
    extends YLEBase {
        private boolean enable;

        YLEEnableMicDenoise(boolean _enable) {
            this.event = 137;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEIsAudioPublisherEnabled
    extends YLEBase {
        YLEIsAudioPublisherEnabled() {
            this.event = 155;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsAudioEncoderEnabled
    extends YLEBase {
        YLEIsAudioEncoderEnabled() {
            this.event = 154;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsAudioCaptureEnabled
    extends YLEBase {
        YLEIsAudioCaptureEnabled() {
            this.event = 136;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEStopOutputDeviceTest
    extends YLEBase {
        YLEStopOutputDeviceTest() {
            this.event = 146;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEStartOutputDeviceTest
    extends YLEBase {
        private String filePath;

        YLEStartOutputDeviceTest(String _filePath) {
            this.event = 145;
            this.filePath = _filePath;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.filePath);
            return super.marshall();
        }
    }

    private static class YLEStopInputDeviceTest
    extends YLEBase {
        YLEStopInputDeviceTest() {
            this.event = 144;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEStartInputDeviceTest
    extends YLEBase {
        YLEStartInputDeviceTest() {
            this.event = 143;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEEnableEchoDetector
    extends YLEBase {
        private boolean enable;

        YLEEnableEchoDetector(boolean _enable) {
            this.event = 135;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableHowlingDetector
    extends YLEBase {
        private boolean enable;

        YLEEnableHowlingDetector(boolean _enable) {
            this.event = 126;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetVoicePitch
    extends YLEBase {
        private float pitch;

        YLESetVoicePitch(float _pitch) {
            this.event = 125;
            this.pitch = _pitch;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.pitch * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLEEnableCompressor
    extends YLEBase {
        private boolean enable;

        YLEEnableCompressor(boolean _enable) {
            this.event = 104;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetEqGains
    extends YLEBase {
        private float mPreamp;
        private float mBand0;
        private float mBand1;
        private float mBand2;
        private float mBand3;
        private float mBand4;
        private float mBand5;
        private float mBand6;
        private float mBand7;
        private float mBand8;
        private float mBand9;

        YLESetEqGains(int[] gains) {
            this.event = 103;
            this.mPreamp = gains[0];
            this.mBand0 = gains[1];
            this.mBand1 = gains[2];
            this.mBand2 = gains[3];
            this.mBand3 = gains[4];
            this.mBand4 = gains[5];
            this.mBand5 = gains[6];
            this.mBand6 = gains[7];
            this.mBand7 = gains[8];
            this.mBand8 = gains[9];
            this.mBand9 = gains[10];
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.mPreamp * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand0 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand1 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand2 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand3 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand4 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand5 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand6 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand7 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand8 * 1000000.0f));
            this.pushString16(String.valueOf(this.mBand9 * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLEEnableEqualizer
    extends YLEBase {
        private boolean enable;

        YLEEnableEqualizer(boolean _enable) {
            this.event = 102;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEsetEarMonitoringVolume
    extends YLEBase {
        private int volume;

        YLEsetEarMonitoringVolume(int _volume) {
            this.event = 131;
            this.volume = _volume;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLEenableInEarMonitor
    extends YLEBase {
        private boolean enable;

        YLEenableInEarMonitor(boolean _enable) {
            this.event = 101;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEadaptToSystemKaraoke
    extends YLEBase {
        private boolean enable;

        YLEadaptToSystemKaraoke(boolean _enable) {
            this.event = 132;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEGetLoudSpeakerEnabled
    extends YLEBase {
        private int reverse;

        YLEGetLoudSpeakerEnabled() {
            this.event = 100;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEEnableLoudSpeaker
    extends YLEBase {
        private boolean bEnable;

        public YLEEnableLoudSpeaker(boolean _bEnable) {
            this.event = 99;
            this.bEnable = _bEnable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bEnable);
            return super.marshall();
        }
    }

    private static class YLEGetConnectionStatus
    extends YLEBase {
        YLEGetConnectionStatus() {
            this.event = 124;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLENotifyNetworkState
    extends YLEBase {
        private int state;

        YLENotifyNetworkState(int _state) {
            this.event = 96;
            this.state = _state;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.state);
            return super.marshall();
        }
    }

    private static class YLESetCustomPublishAppid
    extends YLEBase {
        private int pubAppid;

        public YLESetCustomPublishAppid(int pubAppid) {
            this.event = 142;
            this.pubAppid = pubAppid;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.pubAppid);
            return super.marshall();
        }
    }

    private static class YLESetSubscribeGroupInThunder
    extends YLEBase {
        private boolean bSubscribe;

        public YLESetSubscribeGroupInThunder(boolean bSubscribe) {
            this.event = 141;
            this.bSubscribe = bSubscribe;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bSubscribe);
            return super.marshall();
        }
    }

    private static class YLESetCustomStreamName
    extends YLEBase {
        private int streamType;
        private String streamName;

        public YLESetCustomStreamName(int streamType, String streamName) {
            this.event = 140;
            this.streamType = streamType;
            this.streamName = streamName;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.streamType);
            this.pushString16(this.streamName);
            return super.marshall();
        }
    }

    private static class YLESetCameraZoomConfig
    extends YLEBase {
        private float zoomFactor;

        public YLESetCameraZoomConfig(float _zoomFactor) {
            this.event = 207;
            this.zoomFactor = _zoomFactor;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.zoomFactor * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLESetCustomVideoPublishConfig
    extends YLEBase {
        private int playType;
        private int publishMode;
        private int width;
        private int height;
        private int bitrate;
        private int fps;
        private LinkedList<ThunderPublishLowStreamVideoConfig> lowCfgs;

        public YLESetCustomVideoPublishConfig(int _playType, int _publishMode, int _width, int _height, int _bitrate, int _fps, LinkedList<ThunderPublishLowStreamVideoConfig> _lowCfgs) {
            this.event = 127;
            this.playType = _playType;
            this.publishMode = _publishMode;
            this.width = _width;
            this.height = _height;
            this.bitrate = _bitrate;
            this.fps = _fps;
            this.lowCfgs = _lowCfgs;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.playType);
            this.pushInt(this.publishMode);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.bitrate);
            this.pushInt(this.fps);
            int size = this.lowCfgs.size();
            this.pushInt(size);
            for (ThunderPublishLowStreamVideoConfig cfg : this.lowCfgs) {
                this.pushInt(cfg.type);
                this.pushInt(cfg.encodeResolutionWidth);
                this.pushInt(cfg.encodeResolutionHeight);
                this.pushInt(cfg.encodeBitrate);
                this.pushInt(cfg.encodeFrameRate);
            }
            return super.marshall();
        }
    }

    private static class YLESetVideoEncoderConfig
    extends YLEBase {
        private int playType;
        private int publishMode;

        public YLESetVideoEncoderConfig(int _playType, int _publishMode) {
            this.event = 95;
            this.playType = _playType;
            this.publishMode = _publishMode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.playType);
            this.pushInt(this.publishMode);
            return super.marshall();
        }
    }

    private static class YLEAttachVideoCapture
    extends YLEBase {
        private Object capture;
        private int capType;

        public YLEAttachVideoCapture(Object _capture, int _type) {
            this.event = 94;
            this.capture = _capture;
            this.capType = _type;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(ThunderNative.YYLiveObjectToPtr(this.capture));
            this.pushInt(this.capType);
            return super.marshall();
        }
    }

    private static class YLEStartPreview
    extends YLEBase {
        private boolean bEnable;

        public YLEStartPreview(boolean _bEnable) {
            this.event = 93;
            this.bEnable = _bEnable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bEnable);
            return super.marshall();
        }
    }

    private static class YLEStartPushVideoStream
    extends YLEBase {
        private boolean bEnable;

        public YLEStartPushVideoStream(boolean _bEnable) {
            this.event = 92;
            this.bEnable = _bEnable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bEnable);
            return super.marshall();
        }
    }

    private static class YLEStartVideoEncode
    extends YLEBase {
        private boolean bEnable;

        public YLEStartVideoEncode(boolean _bEnable) {
            this.event = 91;
            this.bEnable = _bEnable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bEnable);
            return super.marshall();
        }
    }

    private static class YLEPushCustomAudioFrame
    extends YLEBase {
        private byte[] data;
        private long timeStamp;

        public YLEPushCustomAudioFrame(byte[] _data, long _timeStamp) {
            this.event = 90;
            this.data = _data;
            this.timeStamp = _timeStamp;
        }

        @Override
        public byte[] marshall() {
            this.pushBytes(this.data);
            this.pushInt64(this.timeStamp);
            return super.marshall();
        }
    }

    private static class YLESetPubWatermark
    extends YLEBase {
        private int x = 0;
        private int y = 0;
        private int width = 0;
        private int height = 0;
        private String imageUrl = null;

        public YLESetPubWatermark(ThunderBoltImage image) {
            this.event = 89;
            if (image != null) {
                this.x = image.x;
                this.y = image.y;
                this.width = image.width;
                this.height = image.height;
                this.imageUrl = image.url;
            }
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.x);
            this.pushInt(this.y);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushString16(this.imageUrl);
            return super.marshall();
        }
    }

    private static class YLESetCustomAudioSource
    extends YLEBase {
        private boolean bEnable;
        private int sampleRate;
        private int channel;

        public YLESetCustomAudioSource(boolean _bEnable, int _sampleRate, int _channel) {
            this.event = 88;
            this.bEnable = _bEnable;
            this.sampleRate = _sampleRate;
            this.channel = _channel;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bEnable);
            this.pushInt(this.sampleRate);
            this.pushInt(this.channel);
            return super.marshall();
        }
    }

    private static class YLESetAudioConfig
    extends YLEBase {
        private int profile;
        private int commutMode;
        private int scenarioMode;

        public YLESetAudioConfig(int _profile, int _commutMode, int _scenarioMode) {
            this.event = 86;
            this.profile = _profile;
            this.commutMode = _commutMode;
            this.scenarioMode = _scenarioMode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.profile);
            this.pushInt(this.commutMode);
            this.pushInt(this.scenarioMode);
            return super.marshall();
        }
    }

    private static class YLESetAudioPublishMode
    extends YLEBase {
        private int sourceType;

        public YLESetAudioPublishMode(int _sourceType) {
            this.event = 87;
            this.sourceType = _sourceType;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.sourceType);
            return super.marshall();
        }
    }

    private static class YLEStartPushAudioStream
    extends YLEBase {
        private boolean bStart;

        public YLEStartPushAudioStream(boolean _bStart) {
            this.event = 85;
            this.bStart = _bStart;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bStart);
            return super.marshall();
        }
    }

    private static class YLEStartAudioEncode
    extends YLEBase {
        private boolean bStart;

        public YLEStartAudioEncode(boolean _bStart) {
            this.event = 134;
            this.bStart = _bStart;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bStart);
            return super.marshall();
        }
    }

    private static class YLEStartAudioCapture
    extends YLEBase {
        private boolean bStart;

        public YLEStartAudioCapture(boolean _bStart) {
            this.event = 133;
            this.bStart = _bStart;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bStart);
            return super.marshall();
        }
    }

    private static class YLEStartPublishAudio
    extends YLEBase {
        private boolean bStart;

        public YLEStartPublishAudio(boolean _bStart) {
            this.event = 84;
            this.bStart = _bStart;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bStart);
            return super.marshall();
        }
    }

    private static class YLESendPrivateMediaExtraData
    extends YLEBase {
        private String extraData;

        YLESendPrivateMediaExtraData(String _extraData) {
            this.event = 213;
            this.extraData = _extraData;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.extraData);
            return super.marshall();
        }
    }

    private static class YLESetCameraAutoFocusFaceModeEnabled
    extends YLEBase {
        private boolean enable;

        public YLESetCameraAutoFocusFaceModeEnabled(boolean _enable) {
            this.event = 212;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEIsCameraAutoFocusFaceModeSupported
    extends YLEBase {
        public YLEIsCameraAutoFocusFaceModeSupported() {
            this.event = 211;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESetCameraExposurePosition
    extends YLEBase {
        private float posX;
        private float posY;

        public YLESetCameraExposurePosition(float _posX, float _posY) {
            this.event = 210;
            this.posX = _posX;
            this.posY = _posY;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.posX * 1000000.0f));
            this.pushString16(String.valueOf(this.posY * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLESetCameraFocusPosition
    extends YLEBase {
        private float posX;
        private float posY;

        public YLESetCameraFocusPosition(float _posX, float _posY) {
            this.event = 209;
            this.posX = _posX;
            this.posY = _posY;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.posX * 1000000.0f));
            this.pushString16(String.valueOf(this.posY * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLESetCameraTorchOn
    extends YLEBase {
        private boolean isOn;

        public YLESetCameraTorchOn(boolean _isOn) {
            this.event = 200;
            this.isOn = _isOn;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.isOn);
            return super.marshall();
        }
    }

    private static class YLESetCameraZoomFactor
    extends YLEBase {
        private float zoomFactor;

        public YLESetCameraZoomFactor(float _zoomFactor) {
            this.event = 207;
            this.zoomFactor = _zoomFactor;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(String.valueOf(this.zoomFactor * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLEGetCameraMaxZoomFactor
    extends YLEBase {
        public YLEGetCameraMaxZoomFactor() {
            this.event = 206;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsCameraTorchSupported
    extends YLEBase {
        public YLEIsCameraTorchSupported() {
            this.event = 208;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsCameraZoomSupported
    extends YLEBase {
        public YLEIsCameraZoomSupported() {
            this.event = 205;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsCameraManualExposurePositionSupported
    extends YLEBase {
        public YLEIsCameraManualExposurePositionSupported() {
            this.event = 204;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsCameraManualFocusPositionSupported
    extends YLEBase {
        public YLEIsCameraManualFocusPositionSupported() {
            this.event = 203;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsFrontCamera
    extends YLEBase {
        public YLEIsFrontCamera() {
            this.event = 202;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEIsCameraOpen
    extends YLEBase {
        public YLEIsCameraOpen() {
            this.event = 201;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESwitchFrontCamera
    extends YLEBase {
        private boolean bFront;

        public YLESwitchFrontCamera(boolean _bFront) {
            this.event = 83;
            this.bFront = _bFront;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bFront);
            return super.marshall();
        }
    }

    private static class YLEStartLocalVideoPreview
    extends YLEBase {
        private boolean bStart;

        public YLEStartLocalVideoPreview(boolean bStart) {
            this.event = 214;
            this.bStart = bStart;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bStart);
            return super.marshall();
        }
    }

    private static class YLEStartVideoCapture
    extends YLEBase {
        private boolean bStart;

        public YLEStartVideoCapture(boolean bStart) {
            this.event = 30;
            this.bStart = bStart;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bStart);
            return super.marshall();
        }
    }

    private static class YLESetUse64bitUid
    extends YLEBase {
        private boolean bUser64bitUid;

        public YLESetUse64bitUid(boolean bUser64bitUid) {
            this.event = 67;
            this.bUser64bitUid = bUser64bitUid;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bUser64bitUid);
            return super.marshall();
        }
    }

    private static class YLESetAreaType
    extends YLEBase {
        private int areaType;

        YLESetAreaType(int _areaType) {
            this.event = 8;
            this.areaType = _areaType;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.areaType);
            return super.marshall();
        }
    }

    private static class YLEStopRemoteVideoStream
    extends YLEBase {
        private String uid;
        private boolean bStop;

        public YLEStopRemoteVideoStream(String uid, boolean bStop) {
            this.event = 82;
            this.uid = uid;
            this.bStop = bStop;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.uid);
            this.pushBool(this.bStop);
            return super.marshall();
        }
    }

    private static class YLEStopRemoteAudioStream
    extends YLEBase {
        private String uid;
        private boolean bStop;

        public YLEStopRemoteAudioStream(String uid, boolean bStop) {
            this.event = 81;
            this.uid = uid;
            this.bStop = bStop;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.uid);
            this.pushBool(this.bStop);
            return super.marshall();
        }
    }

    private static class YLESwitchUserRole
    extends YLEBase {
        private int role;

        public YLESwitchUserRole(int role) {
            this.event = 152;
            this.role = role;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.role);
            return super.marshall();
        }
    }

    private static class YLEChangeRemoteVideoStreamType
    extends YLEBase {
        private int type;
        private String uid;

        public YLEChangeRemoteVideoStreamType(String uid, int type) {
            this.event = 130;
            this.uid = uid;
            this.type = type;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.uid);
            this.pushInt(this.type);
            return super.marshall();
        }
    }

    private static class YLESetDefaultRemoteVideoStreamType
    extends YLEBase {
        private int type;

        public YLESetDefaultRemoteVideoStreamType(int type) {
            this.event = 129;
            this.type = type;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.type);
            return super.marshall();
        }
    }

    private static class YLEEnableLocalDualStreamMode
    extends YLEBase {
        private boolean enbaled;

        public YLEEnableLocalDualStreamMode(boolean enbaled) {
            this.event = 128;
            this.enbaled = enbaled;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enbaled);
            return super.marshall();
        }
    }

    private static class YLEStopAllRemoteStreams
    extends YLEBase {
        private boolean bVideo;
        private boolean bStop;

        public YLEStopAllRemoteStreams(boolean bVideo, boolean bStop) {
            this.event = 80;
            this.bVideo = bVideo;
            this.bStop = bStop;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bVideo);
            this.pushBool(this.bStop);
            return super.marshall();
        }
    }

    private static class YLESetThunderboltSubscribeGroup
    extends YLEBase {
        private boolean bSubscribe;

        public YLESetThunderboltSubscribeGroup(boolean bSubscribe) {
            this.event = 79;
            this.bSubscribe = bSubscribe;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bSubscribe);
            return super.marshall();
        }
    }

    private static class YLEGetUserRole
    extends YLEBase {
        public YLEGetUserRole() {
            this.event = 216;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESubscribeRoom
    extends YLEBase {
        private boolean bSubscribe;
        private String roomId;

        public YLESubscribeRoom(boolean bSubscribe, String roomId) {
            this.event = 215;
            this.bSubscribe = bSubscribe;
            this.roomId = roomId;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bSubscribe);
            this.pushString16(this.roomId);
            return super.marshall();
        }
    }

    private static class YLESubscribeUser
    extends YLEBase {
        private boolean bSubscribe;
        private String roomId;
        private String uid;

        public YLESubscribeUser(boolean bSubscribe, String roomId, String uid) {
            this.event = 78;
            this.bSubscribe = bSubscribe;
            this.roomId = roomId;
            this.uid = uid;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bSubscribe);
            this.pushString16(this.roomId);
            this.pushString16(this.uid);
            return super.marshall();
        }
    }

    private static class YLESetLocalVideoCanvasMode
    extends YLEBase {
        private int mode;

        public YLESetLocalVideoCanvasMode(int mode) {
            this.event = 77;
            this.mode = mode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.mode);
            return super.marshall();
        }
    }

    private static class YLESetLocalVideoCanvas
    extends YLEBase {
        private Object view;
        private int scaleMode;

        public YLESetLocalVideoCanvas(Object view, int scaleMode) {
            this.event = 76;
            this.view = view;
            this.scaleMode = scaleMode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(ThunderNative.YYLiveObjectToPtr(this.view));
            this.pushInt(this.scaleMode);
            return super.marshall();
        }
    }

    private static class YLESetRemoteVideoCanvasMode
    extends YLEBase {
        private String uid;
        private int renderMode;
        private int mirrorMode;

        public YLESetRemoteVideoCanvasMode(String uid, int renderMode, int mirrorMode) {
            this.event = 75;
            this.uid = uid;
            this.renderMode = renderMode;
            this.mirrorMode = mirrorMode;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.uid);
            this.pushInt(this.renderMode);
            this.pushInt(this.mirrorMode);
            return super.marshall();
        }
    }

    private static class YLESetRemoteVideoCanvas
    extends YLEBase {
        private Object view;
        private int renderMode;
        private String uid;
        private int seatIndex;

        public YLESetRemoteVideoCanvas(Object view, int renderMode, String uid, int seatId) {
            this.event = 74;
            this.view = view;
            this.renderMode = renderMode;
            this.uid = uid;
            this.seatIndex = seatId;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(ThunderNative.YYLiveObjectToPtr(this.view));
            this.pushInt(this.renderMode);
            this.pushString16(this.uid);
            this.pushInt(this.seatIndex);
            return super.marshall();
        }
    }

    private static class YLEJoinLiveEngineRoom
    extends YLEBase {
        private byte[] token;
        private String roomId;
        private String uid;

        public YLEJoinLiveEngineRoom(byte[] token, String roomId, String uid) {
            this.event = 6;
            this.token = token;
            this.roomId = roomId;
            this.uid = uid;
        }

        @Override
        public byte[] marshall() {
            this.pushBytes(this.token);
            this.pushString16(this.roomId);
            this.pushString16(this.uid);
            return super.marshall();
        }
    }

    private static class YLESetRoomMode
    extends YLEBase {
        private int roomMode;

        public YLESetRoomMode(int roomMode) {
            this.event = 66;
            this.roomMode = roomMode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.roomMode);
            return super.marshall();
        }
    }

    private static class YLESetMediaMode
    extends YLEBase {
        private int mediaMode;

        public YLESetMediaMode(int mediaMode) {
            this.event = 65;
            this.mediaMode = mediaMode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.mediaMode);
            return super.marshall();
        }
    }

    private static class YLEUpdateToken
    extends YLEBase {
        byte[] token;

        YLEUpdateToken(byte[] _token) {
            this.event = 5;
            this.token = _token;
        }

        @Override
        public byte[] marshall() {
            this.pushBytes(this.token);
            return super.marshall();
        }
    }

    private static class YLESetSceneId
    extends YLEBase {
        private long sceneId;

        YLESetSceneId(long _sceneId) {
            this.event = 2;
            this.sceneId = _sceneId;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.sceneId);
            return super.marshall();
        }
    }

    private static class YLEEnableLogCallback
    extends YLEBase {
        private boolean bCallback;

        public YLEEnableLogCallback(boolean bCallback) {
            this.event = 70;
            this.bCallback = bCallback;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bCallback);
            return super.marshall();
        }
    }

    private static class YLESetLogFilePath
    extends YLEBase {
        private String filePath;

        public YLESetLogFilePath(String filePath) {
            this.event = 69;
            this.filePath = filePath;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.filePath);
            return super.marshall();
        }
    }

    private static class YLESetLogLevel
    extends YLEBase {
        private int logLevel;

        public YLESetLogLevel(int logLevel) {
            this.event = 68;
            this.logLevel = logLevel;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.logLevel);
            return super.marshall();
        }
    }

    private static class YLEMakeBehaviorEvent
    extends YLEBase {
        private String name;
        private String val;
        private String oval;
        private int level;

        YLEMakeBehaviorEvent(String name, String val, String oval, int level) {
            this.event = 120;
            this.name = name;
            this.val = val;
            this.oval = oval;
            this.level = level;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.name);
            this.pushString16(this.val);
            this.pushString16(this.oval);
            this.pushInt(this.level);
            return super.marshall();
        }
    }

    private static class YLEQueryStreams
    extends YLEBase {
        private LinkedList<String> roomIds;

        YLEQueryStreams(LinkedList<String> _roomIds) {
            this.event = 122;
            this.roomIds = _roomIds;
        }

        @Override
        public byte[] marshall() {
            int size = this.roomIds.size();
            this.pushInt(size);
            for (int i = 0; i < size; ++i) {
                this.pushString16(this.roomIds.get(i));
            }
            return super.marshall();
        }
    }

    private static class YLEPrefetchStreams
    extends YLEBase {
        private String uid;
        private LinkedList<String> roomIds;

        YLEPrefetchStreams(String _uid, LinkedList<String> _roomIds) {
            this.event = 121;
            this.uid = _uid;
            this.roomIds = _roomIds;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.uid);
            int size = this.roomIds.size();
            this.pushInt(size);
            for (int i = 0; i < size; ++i) {
                this.pushString16(this.roomIds.get(i));
            }
            return super.marshall();
        }
    }

    private static class YLESetSidAndSubsid
    extends YLEBase {
        private int sid;
        private int subsid;

        public YLESetSidAndSubsid(int sid, int subsid) {
            this.event = 117;
            this.sid = sid;
            this.subsid = subsid;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.sid);
            this.pushInt(this.subsid);
            return super.marshall();
        }
    }

    private static class YLERemoveLiveTranscodingTask
    extends YLEBase {
        private String taskId;

        public YLERemoveLiveTranscodingTask(String taskId) {
            this.event = 73;
            this.taskId = taskId;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.taskId);
            return super.marshall();
        }
    }

    private static class YLESetLiveTranscodingTask
    extends YLEBase {
        private String taskId;
        private LiveTranscoding transcoding;

        public YLESetLiveTranscodingTask(String taskId, LiveTranscoding transcoding) {
            this.event = 72;
            this.taskId = taskId;
            this.transcoding = transcoding;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.taskId);
            this.pushInt(this.transcoding.getTransCodingMode());
            this.pushInt(this.transcoding.getTransCodingVolumeDse());
            this.pushInt(this.transcoding.getTransCodingStreamType());
            CustomTranscodingOptions options = this.transcoding.getCustomTranscodingOptions();
            if (options != null) {
                this.pushInt(this.transcoding.getCustomTranscodingOptions().videoCodecType);
                this.pushInt(this.transcoding.getCustomTranscodingOptions().videoBitrate);
                this.pushInt(this.transcoding.getCustomTranscodingOptions().videoFps);
                this.pushInt(this.transcoding.getCustomTranscodingOptions().videoGop);
                this.pushInt(this.transcoding.getCustomTranscodingOptions().videoWidth);
                this.pushInt(this.transcoding.getCustomTranscodingOptions().videoHeight);
                this.pushInt(this.transcoding.getCustomTranscodingOptions().audioCodecType);
                this.pushInt(this.transcoding.getCustomTranscodingOptions().audioSample);
                this.pushInt(this.transcoding.getCustomTranscodingOptions().audioBitrate);
                this.pushInt(this.transcoding.getCustomTranscodingOptions().audioChannel);
            } else {
                this.pushInt(0);
                this.pushInt(0);
                this.pushInt(0);
                this.pushInt(0);
                this.pushInt(0);
                this.pushInt(0);
                this.pushInt(0);
                this.pushInt(44100);
                this.pushInt(64);
                this.pushInt(2);
            }
            if (this.transcoding.getUsers() == null || this.transcoding.getUsers().isEmpty()) {
                this.pushInt(0);
            } else {
                this.pushInt(this.transcoding.getUserCount());
                for (LiveTranscoding.TranscodingUser user : this.transcoding.getUsers()) {
                    this.pushString16(user.uid);
                    this.pushString16(user.roomId);
                    this.pushBool(user.bStandard);
                    this.pushInt(user.layoutX);
                    this.pushInt(user.layoutY);
                    this.pushInt(user.layoutW);
                    this.pushInt(user.layoutH);
                    this.pushInt(user.zOrder);
                    this.pushBool(user.bCrop);
                    this.pushInt(user.cropX);
                    this.pushInt(user.cropY);
                    this.pushInt(user.cropW);
                    this.pushInt(user.cropH);
                    this.pushInt(user.layoutShape);
                    this.pushString16(String.valueOf(user.alpha * 1000000.0f));
                }
            }
            this.pushString16(this.transcoding.getAudioUrl());
            this.pushString16(this.transcoding.getLyricUrl());
            this.pushString16(this.transcoding.getMediaUrl());
            if (!this.transcoding.getMediaUrl().isEmpty() && this.transcoding.getMediaStreamLayout() != null) {
                LiveTranscoding.MediaStreamLayout layout = this.transcoding.getMediaStreamLayout();
                this.pushInt(layout.layoutX);
                this.pushInt(layout.layoutY);
                this.pushInt(layout.layoutW);
                this.pushInt(layout.layoutH);
                this.pushInt(layout.zOrder);
                this.pushBool(layout.bCrop);
                this.pushInt(layout.cropX);
                this.pushInt(layout.cropY);
                this.pushInt(layout.cropW);
                this.pushInt(layout.cropH);
                this.pushString16(String.valueOf(layout.alpha * 1000000.0f));
            }
            this.pushInt(this.transcoding.getBackgroundColor());
            TranscodingImage backgroundImage = this.transcoding.getBackgroundImage();
            if (backgroundImage != null && backgroundImage.url != null && !backgroundImage.url.isEmpty()) {
                this.pushString16(backgroundImage.url);
                this.pushInt(backgroundImage.scale);
            } else {
                this.pushString16("");
            }
            TranscodingTimestamp timestamp = this.transcoding.getTimestamp();
            if (timestamp != null && timestamp.format != null && !timestamp.format.isEmpty()) {
                this.pushString16(timestamp.format);
                this.pushInt(timestamp.x);
                this.pushInt(timestamp.y);
                this.pushString16(timestamp.font);
                this.pushInt(timestamp.size);
                this.pushInt(timestamp.color);
                this.pushInt(timestamp.backgroundColor);
                this.pushString16(String.valueOf(timestamp.alpha * 1000000.0f));
            } else {
                this.pushString16("");
            }
            ArrayList<TranscodingText> textList = this.transcoding.getTexts();
            if (textList == null || textList.isEmpty()) {
                this.pushInt(0);
            } else {
                this.pushInt(this.transcoding.getTextCount());
                for (TranscodingText text : textList) {
                    this.pushInt(text.x);
                    this.pushInt(text.y);
                    this.pushString16(text.content);
                    this.pushString16(text.font);
                    this.pushInt(text.size);
                    this.pushInt(text.color);
                    this.pushInt(text.backgroundColor);
                    this.pushString16(String.valueOf(text.alpha * 1000000.0f));
                }
            }
            ArrayList<TranscodingImage> imageList = this.transcoding.getImages();
            if (imageList == null || imageList.isEmpty()) {
                this.pushInt(0);
            } else {
                this.pushInt(this.transcoding.getImageCount());
                for (TranscodingImage image : imageList) {
                    this.pushInt(image.x);
                    this.pushInt(image.y);
                    this.pushInt(image.width);
                    this.pushInt(image.height);
                    this.pushString16(image.url);
                    this.pushInt(image.scale);
                    this.pushString16(String.valueOf(image.alpha * 1000000.0f));
                }
            }
            return super.marshall();
        }
    }

    private static class YLEUpdatePublishTranscodingStreamUrl
    extends YLEBase {
        private String taskId;
        private boolean bAdd;
        private String transcodingUrl;

        public YLEUpdatePublishTranscodingStreamUrl(String taskId, boolean bAdd, String transcodingUrl) {
            this.event = 71;
            this.taskId = taskId;
            this.bAdd = bAdd;
            this.transcodingUrl = transcodingUrl;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.taskId);
            this.pushBool(this.bAdd);
            this.pushString16(this.transcodingUrl);
            return super.marshall();
        }
    }

    private static class YLEUpdatePublishOriginStreamUrl
    extends YLEBase {
        private boolean bAdd;
        private String srcUrl;

        public YLEUpdatePublishOriginStreamUrl(boolean bAdd, String srcUrl) {
            this.event = 31;
            this.bAdd = bAdd;
            this.srcUrl = srcUrl;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bAdd);
            this.pushString16(this.srcUrl);
            return super.marshall();
        }
    }

    private static class YLESetPlaybackAudioFrameParameters
    extends YLEBase {
        private int sampleRate;
        private int room;
        private int mode;
        private int samplesPerCall;

        YLESetPlaybackAudioFrameParameters(int _sampleRate, int _room, int _mode, int _samplesPerCall) {
            this.event = 13;
            this.sampleRate = _sampleRate;
            this.room = _room;
            this.mode = _mode;
            this.samplesPerCall = _samplesPerCall;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.sampleRate);
            this.pushInt(this.room);
            this.pushInt(this.mode);
            this.pushInt(this.samplesPerCall);
            return super.marshall();
        }
    }

    private static class YLESetHttpsTextResponse
    extends YLEBase {
        private String reqUrl;
        private String response;
        private int statusCode;
        private int errCode;
        private int target;

        YLESetHttpsTextResponse(String _reqUrl, String _response, int _statusCode, int _errCode, int _target) {
            this.event = 11;
            this.reqUrl = _reqUrl;
            this.response = _response;
            this.statusCode = _statusCode;
            this.errCode = _errCode;
            this.target = _target;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.reqUrl);
            this.pushString16(this.response);
            this.pushInt(this.statusCode);
            this.pushInt(this.errCode);
            this.pushInt(this.target);
            return super.marshall();
        }
    }

    private static class YLESetHttpsBinaryResponse
    extends YLEBase {
        private String reqUrl;
        private byte[] response;
        private int statusCode;
        private int errCode;
        private int target;

        YLESetHttpsBinaryResponse(String _reqUrl, byte[] _response, int _statusCode, int _errCode, int _target) {
            this.event = 11;
            this.reqUrl = _reqUrl;
            this.response = _response;
            this.statusCode = _statusCode;
            this.errCode = _errCode;
            this.target = _target;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.reqUrl);
            this.pushBytes(this.response);
            this.pushInt(this.statusCode);
            this.pushInt(this.errCode);
            this.pushInt(this.target);
            return super.marshall();
        }
    }

    private static class YLEEnableAudioDataIndication
    extends YLEBase {
        private boolean enable;

        YLEEnableAudioDataIndication(boolean enable) {
            this.event = 49;
            this.enable = enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEEnableMixVideoExtraInfo
    extends YLEBase {
        private boolean enable;

        YLEEnableMixVideoExtraInfo(boolean enable) {
            this.event = 64;
            this.enable = enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESendMediaExtraInfo
    extends YLEBase {
        private byte[] extraInfo;

        YLESendMediaExtraInfo(byte[] _extraInfo) {
            this.event = 63;
            this.extraInfo = _extraInfo;
        }

        @Override
        public byte[] marshall() {
            this.pushBytes(this.extraInfo);
            return super.marshall();
        }
    }

    private static class YLESendUserAppMsgData
    extends YLEBase {
        private byte[] msgData;

        YLESendUserAppMsgData(byte[] _msgData) {
            this.event = 62;
            this.msgData = _msgData;
        }

        @Override
        public byte[] marshall() {
            this.pushBytes(this.msgData);
            return super.marshall();
        }
    }

    private static class YLEEnableRenderPcmDataCallBack
    extends YLEBase {
        private boolean enable;
        private int sampleRate;
        private int room;

        YLEEnableRenderPcmDataCallBack(boolean enable, int sampleRate, int room) {
            this.event = 52;
            this.enable = enable;
            this.sampleRate = sampleRate;
            this.room = room;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            this.pushInt(this.sampleRate);
            this.pushInt(this.room);
            return super.marshall();
        }
    }

    private static class YLEEnableCapturePcmDataCallBack
    extends YLEBase {
        private boolean enable;
        private int sampleRate;
        private int room;

        YLEEnableCapturePcmDataCallBack(boolean enable, int sampleRate, int room) {
            this.event = 48;
            this.enable = enable;
            this.sampleRate = sampleRate;
            this.room = room;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            this.pushInt(this.sampleRate);
            this.pushInt(this.room);
            return super.marshall();
        }
    }

    private static class YLEAudioSetExternalProcessor
    extends YLEBase {
        private long eap;

        YLEAudioSetExternalProcessor(long _eap) {
            this.event = 47;
            this.eap = _eap;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.eap);
            return super.marshall();
        }
    }

    private static class YLEEnableAudioFileVolumeCallback
    extends YLEBase {
        private long ctx;
        private boolean enable;
        private int interval;

        YLEEnableAudioFileVolumeCallback(long _ctx, boolean _enable, int _interval) {
            this.event = 53;
            this.ctx = _ctx;
            this.enable = _enable;
            this.interval = _interval;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushBool(this.enable);
            this.pushInt(this.interval);
            return super.marshall();
        }
    }

    private static class YLEAudioFileEnablePublish
    extends YLEBase {
        private long ctx;
        private boolean enable;

        YLEAudioFileEnablePublish(long _ctx, boolean _enable) {
            this.event = 46;
            this.ctx = _ctx;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSetPosition
    extends YLEBase {
        private long ctx;
        private int azimuth;
        private int elevation;

        YLEAudioFileSetPosition(long _ctx, int azim, int elev) {
            this.event = 151;
            this.ctx = _ctx;
            this.azimuth = azim;
            this.elevation = elev;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushInt(this.azimuth);
            this.pushInt(this.elevation);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSetTempo
    extends YLEBase {
        private long ctx;
        private float val;

        YLEAudioFileSetTempo(long _ctx, float _val) {
            this.event = 150;
            this.ctx = _ctx;
            this.val = _val;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            int value = (int)(this.val * 1000000.0f);
            this.pushInt(value);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSetSemitone
    extends YLEBase {
        private long ctx;
        private float val;

        YLEAudioFileSetSemitone(long _ctx, float _val) {
            this.event = 45;
            this.ctx = _ctx;
            this.val = _val;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushString16(String.valueOf(this.val * 1000000.0f));
            return super.marshall();
        }
    }

    private static class YLEAudioFileSetLooping
    extends YLEBase {
        private long ctx;
        private int cycle;

        YLEAudioFileSetLooping(long _ctx, int _cycle) {
            this.ctx = _ctx;
            this.cycle = _cycle;
            this.event = 60;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushInt(this.cycle);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSelectAudioTrack
    extends YLEBase {
        private long ctx;
        private int audioTrack;

        YLEAudioFileSelectAudioTrack(long _ctx, int _audioTrack) {
            this.ctx = _ctx;
            this.audioTrack = _audioTrack;
            this.event = 54;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushInt(this.audioTrack);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSetPlayerPublishVolume
    extends YLEBase {
        private long ctx;
        private int volume;

        YLEAudioFileSetPlayerPublishVolume(long _ctx, int _volume) {
            this.event = 57;
            this.ctx = _ctx;
            this.volume = _volume;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSetPlayerLocalVolume
    extends YLEBase {
        private long ctx;
        private int volume;

        YLEAudioFileSetPlayerLocalVolume(long _ctx, int _volume) {
            this.event = 56;
            this.ctx = _ctx;
            this.volume = _volume;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSetPlayVolume
    extends YLEBase {
        private long ctx;
        private int volume;

        YLEAudioFileSetPlayVolume(long _ctx, int _volume) {
            this.event = 44;
            this.ctx = _ctx;
            this.volume = _volume;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLEAudioFileSeek
    extends YLEBase {
        private long ctx;
        private long timeMS;

        YLEAudioFileSeek(long _ctx, long _timeMS) {
            this.event = 41;
            this.ctx = _ctx;
            this.timeMS = _timeMS;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushInt(this.timeMS);
            return super.marshall();
        }
    }

    private static class YLESendAudioFilePlayerInfo
    extends YLEBase {
        private int volume;
        private int currentMs;
        private int totalMs;

        YLESendAudioFilePlayerInfo(int _volume, int _currentMs, int _totalMs) {
            this.event = 61;
            this.volume = _volume;
            this.currentMs = _currentMs;
            this.totalMs = _totalMs;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.volume);
            this.pushInt(this.currentMs);
            this.pushInt(this.totalMs);
            return super.marshall();
        }
    }

    private static class YLEAudioFileEventCommon
    extends YLEBase {
        private long ctx;

        YLEAudioFileEventCommon(int _event, long _ctx) {
            this.event = _event;
            this.ctx = _ctx;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            return super.marshall();
        }
    }

    private static class YLEAudioFileOpen
    extends YLEBase {
        private long ctx;
        private String path;

        YLEAudioFileOpen(long _ctx, String _path) {
            this.event = 35;
            this.path = _path;
            this.ctx = _ctx;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.ctx);
            this.pushString16(this.path);
            return super.marshall();
        }
    }

    private static class YLECreateAudioFilePlayer
    extends YLEBase {
        private Object obj;

        YLECreateAudioFilePlayer(Object _obj) {
            this.event = 50;
            this.obj = _obj;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(ThunderNative.YYLiveObjectToPtr(this.obj));
            return super.marshall();
        }
    }

    private static class YLEEnterForeground
    extends YLEBase {
        private int reverse;

        YLEEnterForeground() {
            this.event = 97;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLEEnterBackground
    extends YLEBase {
        private int reverse;

        YLEEnterBackground() {
            this.event = 98;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    public static class YLEChangeScreenLiveMode
    extends YLEBase {
        private boolean bPicMode;
        private Object bitmap;

        public YLEChangeScreenLiveMode(boolean _bPicMode, Object _bitmap) {
            this.event = 26;
            this.bPicMode = _bPicMode;
            this.bitmap = _bitmap;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bPicMode);
            this.pushInt64(ThunderNative.YYLiveObjectToPtr(this.bitmap));
            return super.marshall();
        }
    }

    private static class YLESetThunderboltPublishGroup
    extends YLEBase {
        private boolean isPublishGroup;

        YLESetThunderboltPublishGroup(boolean _isPublishGroup) {
            this.event = 32;
            this.isPublishGroup = _isPublishGroup;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.isPublishGroup);
            return super.marshall();
        }
    }

    private static class YLEGetOrientation
    extends YLEBase {
        YLEGetOrientation() {
            this.event = 28;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESetOrientation
    extends YLEBase {
        private int orientation;

        YLESetOrientation(int ori) {
            this.event = 27;
            this.orientation = ori;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.orientation);
            return super.marshall();
        }
    }

    private static class YLESetMicVolume
    extends YLEBase {
        private int volume;

        YLESetMicVolume(int _volume) {
            this.event = 25;
            this.volume = _volume;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLEGetAppCpuSupportMode
    extends YLEBase {
        YLEGetAppCpuSupportMode() {
            this.event = 118;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEGetHardDecodeRenderMode
    extends YLEBase {
        YLEGetHardDecodeRenderMode() {
            this.event = 181;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEGetH264SupportMode
    extends YLEBase {
        YLEGetH264SupportMode() {
            this.event = 20;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEGetH265SupportMode
    extends YLEBase {
        YLEGetH265SupportMode() {
            this.event = 18;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESetSpeakerVolume
    extends YLEBase {
        private int volume;

        YLESetSpeakerVolume(int _volume) {
            this.event = 17;
            this.volume = _volume;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLESetRemoteUidVoicePosition
    extends YLEBase {
        private String uid;
        private int azimuth;
        private int gain;

        public YLESetRemoteUidVoicePosition(String uid, int azimuth, int gain) {
            this.event = 22;
            this.uid = uid;
            this.azimuth = azimuth;
            this.gain = gain;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.uid);
            this.pushInt(this.azimuth);
            this.pushInt(this.gain);
            return super.marshall();
        }
    }

    private static class YLESetRemoteAudioStreamVolume
    extends YLEBase {
        private String uid;
        private int volume;

        public YLESetRemoteAudioStreamVolume(String uid, int volume) {
            this.event = 15;
            this.uid = uid;
            this.volume = volume;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.uid);
            this.pushInt(this.volume);
            return super.marshall();
        }
    }

    private static class YLESetLocalVideoMirrorMode
    extends YLEBase {
        private int mode;

        YLESetLocalVideoMirrorMode(int _mode) {
            this.event = 33;
            this.mode = _mode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.mode);
            return super.marshall();
        }
    }

    private static class YLEEnableWebSdkCompatibility
    extends YLEBase {
        private boolean enable;

        YLEEnableWebSdkCompatibility(boolean _enable) {
            this.event = 19;
            this.enable = _enable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.enable);
            return super.marshall();
        }
    }

    private static class YLESetHardwareDecodeStatus
    extends YLEBase {
        private int mHardwareDecodeStatus;

        YLESetHardwareDecodeStatus(int _mHardwareDecodeStatus) {
            this.event = 183;
            this.mHardwareDecodeStatus = _mHardwareDecodeStatus;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.mHardwareDecodeStatus);
            return super.marshall();
        }
    }

    private static class YLESetVideoCommonConfigMode
    extends YLEBase {
        private int mode;

        YLESetVideoCommonConfigMode(int _mode) {
            this.event = 185;
            this.mode = _mode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.mode);
            return super.marshall();
        }
    }

    private static class YLEEnableVideoPublishBufferProcess
    extends YLEBase {
        private boolean bBufferMode;

        YLEEnableVideoPublishBufferProcess(boolean _bBufferMode) {
            this.event = 182;
            this.bBufferMode = _bBufferMode;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.bBufferMode);
            return super.marshall();
        }
    }

    private static class YLESetParameters
    extends YLEBase {
        private String options;

        YLESetParameters(String options) {
            this.event = 191;
            this.options = options;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.options);
            return super.marshall();
        }
    }

    private static class YLESetCrashEvent
    extends YLEBase {
        YLESetCrashEvent() {
            this.event = 184;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESetVideoPlayType
    extends YLEBase {
        private int remotePlayType;
        private boolean checkJoined;

        YLESetVideoPlayType(int _remotePlayType, boolean _checkJoined) {
            this.event = 24;
            this.remotePlayType = _remotePlayType;
            this.checkJoined = _checkJoined;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.remotePlayType);
            this.pushBool(this.checkJoined);
            return super.marshall();
        }
    }

    private static class YLEInitMultiPlayerViewLayout
    extends YLEBase {
        private Object multiParam;
        private int viewId;
        private Object view;

        YLEInitMultiPlayerViewLayout(Object _multiParam, int _viewId, Object _view) {
            this.event = 23;
            this.multiParam = _multiParam;
            this.viewId = _viewId;
            this.view = _view;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(ThunderNative.YYLiveObjectToPtr(this.multiParam));
            this.pushInt(this.viewId);
            this.pushInt64(ThunderNative.YYLiveObjectToPtr(this.view));
            return super.marshall();
        }
    }

    private static class YLEGetAbroadNetWorkStrategy
    extends YLEBase {
        YLEGetAbroadNetWorkStrategy() {
            this.event = 180;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLEGetBeautifyLevel
    extends YLEBase {
        YLEGetBeautifyLevel() {
            this.event = 34;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESetCaptureVolumeInterval
    extends YLEBase {
        private int interval;
        private int moreThanThd;
        private int lessThanThd;

        YLESetCaptureVolumeInterval(int _interval, int _moreThanThd, int _lessThanThd) {
            this.event = 10;
            this.interval = _interval;
            this.moreThanThd = _moreThanThd;
            this.lessThanThd = _lessThanThd;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.interval);
            this.pushInt(this.moreThanThd);
            this.pushInt(this.lessThanThd);
            return super.marshall();
        }
    }

    private static class YLESetPlayVolumeInterval
    extends YLEBase {
        private int interval;
        private int moreThanThd;
        private int lessThanThd;

        YLESetPlayVolumeInterval(int _interval, int _moreThanThd, int _lessThanThd) {
            this.event = 9;
            this.interval = _interval;
            this.moreThanThd = _moreThanThd;
            this.lessThanThd = _lessThanThd;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.interval);
            this.pushInt(this.moreThanThd);
            this.pushInt(this.lessThanThd);
            return super.marshall();
        }
    }

    private static class YLELeaveRoom
    extends YLEBase {
        private int reverse;

        YLELeaveRoom() {
            this.event = 7;
            this.reverse = 0;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.reverse);
            return super.marshall();
        }
    }

    private static class YLELogText
    extends YLEBase {
        private int level;
        private int module;
        private String tag;
        private String text;

        YLELogText(int _level, int _module, String _tag, String _text) {
            this.event = 3;
            this.level = _level;
            this.module = _module;
            this.tag = _tag;
            this.text = _text;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.level);
            this.pushInt(this.module);
            this.pushString16(this.tag);
            this.pushString32(this.text);
            return super.marshall();
        }
    }

    private static class YLEBase
    extends HPMarshaller {
        int event = 0;

        private YLEBase() {
        }

        int event() {
            return this.event;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }

    private static class YLESdkInit
    extends YLEBase {
        long appId;
        long sceneId;
        int areaType;
        int serverDomain;
        ThunderDeviceInfo info;

        YLESdkInit(long _addId, long _sceneId, int _areaType, int _serverDomain, ThunderDeviceInfo _info) {
            this.event = 1;
            this.appId = _addId;
            this.sceneId = _sceneId;
            this.areaType = _areaType;
            this.serverDomain = _serverDomain;
            this.info = _info;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.appId);
            this.pushInt(this.sceneId);
            this.pushInt(this.areaType);
            this.pushInt(this.serverDomain);
            this.pushString16(this.info.osVersion);
            this.pushString16(this.info.manufacturer);
            this.pushString16(this.info.model);
            this.pushString16(this.info.deviceID);
            this.pushString16(this.info.appInfo);
            this.pushInt64(this.info.imsi);
            return super.marshall();
        }
    }
}

