package com.thunder.livesdk.video;

import java.nio.FloatBuffer;

public abstract class VideoTextureFrameObserver {
    /**
     * GL线程启动，初始化
     * @param textureTarget 纹理类型, (GL_TEXTURE_EXTERNAL_OES/GL_TEXTURE_2D）
     * @param outputWidth 纹理宽
     * @param outputHeight 纹理高
     */
    public void onInit(final int textureTarget, final int outputWidth, final int outputHeight) { }

    /**
     * 每一帧渲染处理
     * @param videoFrame 视频数据 详情参看ThunderVideoFrame
     */
    public void onDraw(final ThunderVideoFrame videoFrame) { }

    /**
     * GL线程结束，销毁特效资源
     */
    public void onDestroy() { }

    /**
     * 通知纹理大小更新
     * @param width
     * @param height
     */
    public void onOutputSizeChanged(final int width, final int height) { }
}
