package com.thunder.livesdk.video;

import android.hardware.Camera;

import com.thunder.livesdk.log.ThunderLog;
import com.yy.mediaframework.facedetection.IYMFPreviewFrameCallback;
import com.thunder.livesdk.ThunderBridgeLib;
import com.yy.mediaframework.gpuimage.custom.YMFVideoFrame;

/*
 * camera yuv（NV21）数据回调给业务
 */

public class VideoFrameYuvCapture implements IYMFPreviewFrameCallback {

    private IVideoCaptureObserver mVideoCaptureFrameObserver = null;
    private static volatile VideoFrameYuvCapture instance;
    private static Object syncLock = new Object();
    ThunderVideoFrame mVideoFrame = new ThunderVideoFrame();

    public static VideoFrameYuvCapture getInstance() {
        if (instance == null) {
            synchronized (syncLock) {
                if (instance == null) {
                    instance = new VideoFrameYuvCapture();
                }
            }
        }
        return instance;
    }

    private VideoFrameYuvCapture() {
    }


    public void enableVideoCapture(IVideoCaptureObserver observer) {
        if (observer != null) {
            mVideoCaptureFrameObserver = observer;
            ThunderBridgeLib.getInstance().addPreviewFrameCallback(this);
        } else {
            ThunderBridgeLib.getInstance().removePreviewFrameCallback(this);
            mVideoCaptureFrameObserver = null;
        }
    }


    @Override
    public void onPreviewFrameAvailable(int imageFormat, byte[] data, int width, int height, Camera camera) {
        if (mVideoCaptureFrameObserver == null) {
            return;
        }
        mVideoCaptureFrameObserver.onCaptureVideoFrame(width, height, data, data.length, imageFormat);
    }

    @Override
    public void onPreviewFrameAvailable(YMFVideoFrame ymfVideoFrame) {
        if (mVideoCaptureFrameObserver == null) {
            return;
        }
        if(mVideoCaptureFrameObserver instanceof ThunderVideoCaptureObserver) {
            mVideoFrame.setVideoFrame(ymfVideoFrame);
            ((ThunderVideoCaptureObserver) mVideoCaptureFrameObserver).onCaptureVideoFrame(mVideoFrame);
        } else {
            mVideoCaptureFrameObserver.onCaptureVideoFrame(ymfVideoFrame.mYuvWidth, ymfVideoFrame.mYuvHeight, ymfVideoFrame.mYUVCaptureBuffer,
                    ymfVideoFrame.mYUVCaptureBuffer.length, ymfVideoFrame.mImageFormat);
        }
    }
}
