package com.thunder.livesdk.video;
import com.thunder.livesdk.ThunderBridgeLib;
import com.yy.mediaframework.gpuimage.custom.IYMFGpuProcess;
import com.yy.mediaframework.gpuimage.custom.YMFVideoFrame;

import java.nio.FloatBuffer;

public class VideoFrameTextrue implements IYMFGpuProcess {
    private VideoTextureFrameObserver mVideoTextureFrameObserver = null;
    private VideoTextureFrameObserver mNewVideoTextureFrameObserver = null;
    private static volatile VideoFrameTextrue instance;
    private static Object syncLock = new Object();
    ThunderVideoFrame mVideoFrame = new ThunderVideoFrame();

    public static VideoFrameTextrue getInstance() {
        if (instance == null) {
            synchronized (syncLock) {
                if (instance == null) {
                    instance = new VideoFrameTextrue();
                }
            }
        }
        return instance;
    }

    private VideoFrameTextrue() {
    }


    public void enableVideoTextrue (VideoTextureFrameObserver observer) {
        synchronized (syncLock) {
            if (observer != null) {
                mNewVideoTextureFrameObserver = observer;
                ThunderBridgeLib.getInstance().setGPUImageProcessFilter(this);
            }
        }
    }
    @Override
    public void onInit(int textureTarget, int outputWidth, int outputHeight) {
        synchronized (syncLock) {
            mVideoTextureFrameObserver = mNewVideoTextureFrameObserver;
            if (mVideoTextureFrameObserver == null) {
                return;
            }
            mVideoTextureFrameObserver.onInit(textureTarget, outputWidth, outputHeight);
        }
    }


    @Override
    public void onDraw(final int textureId, final FloatBuffer textureBuffer) { }

    @Override
    public void onDraw(final YMFVideoFrame ymfVideoFrame) {
        synchronized (syncLock) {
            if (mVideoTextureFrameObserver == null) {
                return;
            }
            mVideoFrame.setVideoFrame(ymfVideoFrame);
            mVideoTextureFrameObserver.onDraw(mVideoFrame);
        }
    }


    @Override
    public void onDestroy() {
        synchronized (syncLock) {
            if (mVideoTextureFrameObserver == null) {
                return;
            }
            mVideoTextureFrameObserver.onDestroy();
        }
    }


    @Override
    public void onOutputSizeChanged(final int width, final int height) {
        synchronized (syncLock) {
            if (mVideoTextureFrameObserver == null) {
                return;
            }
            mVideoTextureFrameObserver.onOutputSizeChanged(width, height);
        }
    }
}
