package com.thunder.livesdk.video;

import android.graphics.ImageFormat;
import android.hardware.Camera;

import com.yy.mediaframework.gpuimage.custom.YMFVideoFrame;

import java.nio.FloatBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThunderVideoFrame{
    public long mIndex = 0;         //序号，用于异步时，纹理与yuv数据对应
    public AtomicBoolean mWillBeRendered = null;  //index对应的纹理是否会被渲染
    public int mTextureTarget = 0;  // 纹理类型, (GL_TEXTURE_EXTERNAL_OES/GL_TEXTURE_2D）
    public int mTextureId = 0;      //纹理ID
    public int mTextureWidth = 0;          //纹理宽
    public int mTextureHeight = 0;         //纹理高
    public FloatBuffer mTextureCoord = null;  //纹理坐标
    public byte[] mYUVCaptureBuffer = null;   //yvu采集数据
    public int mImageFormat = ImageFormat.NV21;  //采集格式
    public int mYuvWidth = 0;          //yuv宽
    public int mYuvHeight = 0;         //yuv高
    public Camera mCamera = null;

    public void setVideoFrame(YMFVideoFrame ymfVideoFrame){
        if(ymfVideoFrame != null) {
            mIndex = ymfVideoFrame.mIndex;
            mWillBeRendered = ymfVideoFrame.mWillBeRendered;
            mTextureTarget = ymfVideoFrame.mTextureTarget;
            mTextureId = ymfVideoFrame.mTextureId;
            mTextureWidth = ymfVideoFrame.mTextureWidth;
            mTextureHeight = ymfVideoFrame.mTextureHeight;
            mTextureCoord = ymfVideoFrame.mTextureCoord;
            mYUVCaptureBuffer = ymfVideoFrame.mYUVCaptureBuffer;
            mImageFormat = ymfVideoFrame.mImageFormat;
            mYuvWidth = ymfVideoFrame.mYuvWidth;
            mYuvHeight = ymfVideoFrame.mYuvHeight;
            mCamera = ymfVideoFrame.mCamera;
        } else {
            mIndex = 0;
            mWillBeRendered = null;
            mTextureTarget = 0;
            mTextureId = 0;
            mTextureWidth = 0;
            mTextureHeight = 0;
            mTextureCoord = null;
            mYUVCaptureBuffer = null;
            mImageFormat = ImageFormat.NV21;
            mYuvWidth = 0;
            mYuvHeight = 0;
            mCamera = null;
        }
    }
}
