package com.thunder.livesdk.video;

/**
 * Created by xiaojun on 2017/12/29.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;

import com.thunder.livesdk.BuildConfig;
import com.thunder.livesdk.ThunderRtcConstant;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.videoplayer.YMFPlayerAPI;
import com.yy.videoplayer.view.YMFLayoutParams;
import com.yy.videoplayer.view.YMFVideoPosition;
import com.thunder.livesdk.log.ThunderLog;

import java.util.concurrent.CountDownLatch;

/**
 * 用于播放视频的组件<br/>
 * <p>需要播放视频时，在布局文件中加入这个组件</p>
 */
public class ThunderPlayerTextureView extends VideoPlayerView {
    private final String TAG = "ThunderPlayerView " + Integer.toHexString(this.hashCode());

    private YMFLayoutParams mYMFLayoutParams;
    private long mStreamId = 0;
    private YMFPlayerAPI mYMFPlayerInstance = null;
    private boolean mUseTextureView = false;
    public final int INVALID_STREAM_ID = -1;

    public ThunderPlayerTextureView(Context context) {
        super(context);
        createVideoView();
    }

    public ThunderPlayerTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        createVideoView();
    }

    public ThunderPlayerTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        createVideoView();
    }


    public boolean isViewLinkedToStream() {
        return mStreamId != 0;
    }

    public boolean isViewPrepared() {
        return mPrepared;
    }

    public boolean createVideoView() {

        if (mYMFPlayerInstance == null) {
            mYMFPlayerInstance = YMFPlayerAPI.newInstance();
        }
        mYMFPlayerInstance.setUseTextureView(true);
        mUniformView = mYMFPlayerInstance.createView(this.getContext());
        if (mUniformView != null) {
            this.addView(mUniformView);
            if (mYMFLayoutParams != null) {
                mYMFPlayerInstance.setViewLayout(mUniformView, mYMFLayoutParams);
            }
            mYMFPlayerInstance.setScaleMode(mUniformView, mScaleMode, -1);
            mPrepared = true;
        }
        ThunderLog.release(ThunderLog.kLogTagVideo,
                "createUnityVideoView:" + " size " + this.getWidth() + "x" + this.getHeight());
        return true;
    }



    /**
     * 绑定视频流<br/>
     * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
     *
     * @param streamId 流ID
     */
    public void linkToStream(long streamId) {
        synchronized (this) {
            if (mYMFPlayerInstance != null && mUniformView != null) {
                //有link操作则肯定需要清除黑帧操作
                drawBlackScreen(false);
                mYMFPlayerInstance.linkStream(mUniformView, streamId, -1);
            }
            mStreamId = streamId;
        }
        ThunderLog.release(ThunderLog.kLogTagVideo, TAG + " linkToStream " + streamId);
    }


    /**
     * 绑定视频流到某位置<br/>
     * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
     *
     * @param streamId 流ID
     */
    public int linkToStream(long streamId, int videoIndex) {
        ThunderLog.release(ThunderLog.kLogTagVideo, TAG +
                " linkToStream mUniformView " + mUniformView +
                " linkToStream " + streamId +
                " videoIndex " + videoIndex);
        if (streamId == 0L) {
            return -1;
        }

        if (videoIndex < 0) {
            return -1;
        }

        if (mUniformView == null) {
            return -1;
        }

        if (mYMFPlayerInstance != null) {
            drawBlackScreen(false);
            return mYMFPlayerInstance.linkStream(mUniformView, streamId, videoIndex);
        }
        return 0;
    }

    /**
     * 解绑视频流 <br/>
     * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
     *
     * @param streamId 流ID
     */
    public int unLinkFromStream(long streamId, int videoIndex) {
        ThunderLog.release(ThunderLog.kLogTagVideo, TAG +
                " unLinkFromStream mUniformView " + mUniformView +
                " linkToStream " + streamId +
                " videoIndex " + videoIndex);

        if (streamId == 0L) {
            return -1;
        }

        if (videoIndex < 0) {
            return -1;
        }

        if (mUniformView == null) {
            return -1;
        }

        if (mYMFPlayerInstance != null) {
            return mYMFPlayerInstance.unLinkStream(mUniformView, streamId, videoIndex);
        }
        return 0;
    }

    /**
     * 解绑视频流 <br/>
     * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
     *
     * @param streamId 流ID
     */
    public void unLinkFromStream(long streamId) {
        synchronized (this) {
            if (mYMFPlayerInstance != null && mUniformView != null) {
                mYMFPlayerInstance.unLinkStream(mUniformView, streamId, -1);
            }
            mStreamId = 0;
        }
        ThunderLog.release(ThunderLog.kLogTagVideo, TAG + " unLinkFromStream " + streamId);
    }

    /**
     * 解绑视频流 <br/>
     * <br/><b>注意：</b>sdk库内部逻辑使用，请不要调用<br/>
     */
    public void unLinkFromStream() {

        if (mYMFPlayerInstance != null && mUniformView != null) {
            mYMFPlayerInstance.unLinkStream(mUniformView, mStreamId, -1);
        }
        mStreamId = 0;

        ThunderLog.release(ThunderLog.kLogTagVideo, TAG + " unLinkFromStream() ");
    }

    /**
     * 修改视频缩放模式<br/>
     *
     * @param scaleMode 缩放模式 {@link ThunderRtcConstant.ThunderVideoRenderMode}
     * @return 成功or失败
     */
    public boolean setScaleMode(int scaleMode) {
        boolean result = false;
        mScaleMode = scaleModeConvert(scaleMode);
        if (mYMFPlayerInstance != null) {
            mYMFPlayerInstance.setScaleMode(mUniformView, mScaleMode, -1);
        }
        return result;
    }

    /**
     * 修改视频缩放模式<br/>
     *
     * @param scaleMode 缩放模式 {@link ThunderRtcConstant.ThunderVideoRenderMode}
     * @return 成功or失败
     */
    public boolean setScaleMode(int seatId, int scaleMode) {
        boolean result = false;
        synchronized (this) {
            mScaleMode = scaleModeConvert(scaleMode);
            if (mYMFPlayerInstance != null) {
                mYMFPlayerInstance.setScaleMode(mUniformView, mScaleMode, seatId);
            }
        }
        return result;
    }

    /**
     * 修改视频镜像模式<br/>
     *
     * @param seatId 座位信息
     * @param mirrorMode 镜像模式
     */
    public void setMirrorMode(int seatId, int mirrorMode) {
        mMirrorMode = mirrorModeConvert(mirrorMode);
        if (mYMFPlayerInstance != null) {
            mYMFPlayerInstance.setMirrorMode(mUniformView, mMirrorMode, seatId);
        }
    }

    /**
     * 获取截图
     * @param seatId 座位
     * @return Bitmap
     */
    public Bitmap getVideoScreenshot(int seatId) {
        synchronized (this) {
            if (mYMFPlayerInstance != null) {
                return mYMFPlayerInstance.getVideoScreenshot(mUniformView, seatId);
            }
        }
        return null;
    }


    public void drawBlackScreen(boolean black) {
        if (mYMFPlayerInstance != null) {
            mYMFPlayerInstance.setLastFrameRenderBlack(mUniformView, black);
        }
    }

    public void updateMultiViewLayout(YMFLayoutParams params) {
        if (BuildConfig.__YY_VIDEO_VIEWUNITY_SUPPORT__) {
            mYMFLayoutParams = params;
            drawBlackScreen(false);
            if (mYMFPlayerInstance != null) {
                mYMFPlayerInstance.setViewLayout(mUniformView, params);
            }
        }
    }


    public void enterMultiVideoViewMode(YMFLayoutParams multiVideoViewParams,
                                        Constant.MultiLianmaiMode lianmaiMode) {
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(TAG,
                "enterMultiVideoViewMode multiVideoViewParams = [" + multiVideoViewParams + "], lianmaiMode=" +
                        lianmaiMode);
}
        if (multiVideoViewParams == null) {
            YMFLayoutParams params = new YMFLayoutParams(1);
            YMFVideoPosition videoPosition = new YMFVideoPosition();
            videoPosition.mIndex = 0;
            videoPosition.mX = 0;
            videoPosition.mY = 0;
            videoPosition.mHeight = -2;     //-2是铺满surface的标志
            videoPosition.mWidth = -2;      //-2是铺满surface的标志
            params.mDrawPosition[0] = videoPosition;
            setUseMultiVideoView(params);
            return;
        }
        synchronized (this) {
            YYVideoSDK.getInstance().setMultiVideoLianmaiMode(lianmaiMode);
            setUseMultiVideoView(multiVideoViewParams);
        }
    }

    public void leaveMultiVideoViewMode() {
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(TAG, "leaveMultiVideoViewMode ");
}
        synchronized (this) {
            setUseMultiVideoView(null);
            YYVideoSDK.getInstance().setMultiVideoLianmaiMode(Constant.MultiLianmaiMode.NormalMode);
        }
    }

    private void setUseMultiVideoView(YMFLayoutParams multiVideoViewParams) {
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(TAG, "setUseMultiVideoView");
}
        mYMFLayoutParams = multiVideoViewParams;
        drawBlackScreen(false);
        if (mYMFPlayerInstance!= null) {
            mYMFPlayerInstance.setViewLayout(mUniformView, mYMFLayoutParams);
        }
    }

    public int switchDualVideoView(long oldStreamId, long newStreamId, int seatId){
        if (oldStreamId == 0L || newStreamId == 0L || mUniformView == null) {
            return -1;
        }

        if (mYMFPlayerInstance != null && mUniformView != null) {
            return mYMFPlayerInstance.switchDualVideoView(mUniformView, oldStreamId, newStreamId,
                    seatId);
        }
        return -1;
    }
}

