package com.thunder.livesdk.audio;

import java.nio.ByteBuffer;

public interface IAudioFrameObserver {

    /**
     * Callback of raw audio data captured by the recording device
     *
     * @param samples     Samples in the audio frame
     * @param numOfSamples    The number of samples per channel in the audio frame
     * @param bytesPerSample  The number of bytes per audio sample, which is usually 16-bit (2-byte) for PCM.
     * @param channels   The number of audio channels; 1-Mono, 2-Stereo (the data is interleaved)
     * @param samplesPerSec   Sample rate, SamplesPerCall = (int)(SampleRate × sampleInterval), sample ≥ 0.01, unit: seconds
     * @return
     */
    boolean onRecordAudioFrame(ByteBuffer samples, int numOfSamples, int bytesPerSample, int channels, int samplesPerSec);

    /**
     * Callback of the played raw audio data
     *
     * @param samples        Samples in the audio frame
     * @param numOfSamples   The number of samples per channel in the audio frame
     * @param bytesPerSample   The number of bytes per audio sample, which is usually 16-bit (2-byte) for PCM.
     * @param channels       The number of audio channels; 1-Mono, 2-Stereo (the data is interleaved)
     * @param samplesPerSec  Sample rate, SamplesPerCall = (int)(SampleRate × sampleInterval), sample ≥ 0.01, unit: seconds
     * @return
     */
    boolean onPlaybackAudioFrame(ByteBuffer samples, int numOfSamples, int bytesPerSample, int channels, int samplesPerSec);

    /**
     * Callback of raw audio data decoded by the remote users
     *
     * @param uid            ID the remote user
     * @param samples        Samples in the audio frame
     * @param numOfSamples  The number of samples per channel in the audio frame
     * @param bytesPerSample  The number of bytes per audio sample, which is usually 16-bit (2-byte) for PCM.

     * @param channels       The number of audio channels; 1-Mono, 2-Stereo (the data is interleaved)
     * @param samplesPerSec  Sample rate, SamplesPerCall = (int)(SampleRate × sampleInterval), sample ≥ 0.01, unit: seconds
     * @return
     */
    boolean onPlaybackAudioFrameBeforeMixing(
            String uid, ByteBuffer samples, int numOfSamples, int bytesPerSample, int channels, int samplesPerSec);
}
