package com.thunder.livesdk;

/**
 * @brief 时间戳水印
 */
public class TranscodingTimestamp {
    public int x; // 以左上角为原点横轴坐标,默认0
    public int y; // 以左上角为原点纵轴坐标,默认0
    public String format; // 支持posix时间格式显示格式,默认空值,比如:
                          // %Y/%m/%d: 2020/01/01
                          // %Y-%m-%d: 2020-01-01
                          // %H:%M:%S: 13:00:00
                          // %Y/%m/%d %H:%M:%S: 2020/01/01 13:00:00
                          // %Y-%m-%d %H:%M:%S: 2020-01-01 13:00:00
    public String font; // 字体,目前仅支持NotoSansCJK一种字体,默认空值
    public int size; // 字体大小,默认0
    public int color; // 字体颜色,RGB定义下的Hex值,默认值黑色#000000
    public int backgroundColor; // 背景色,RGB定义下的Hex值,默认值-1表示不设置背景色
    public float alpha; // 透明度,取值范围为[0.0, 1.0],0.0完全透明,1.0完全不透明,默认1.0

    public TranscodingTimestamp() {
      this.x = 0;
      this.y = 0;
      this.format = "";
      this.font = "";
      this.size = 0;
      this.color = 0;
      this.backgroundColor = -1;
      this.alpha = 1.0f;
    }

    public String toString() {
      return "[TranscodingTimestamp: " + x + ", " + y + ", format " + format + ", font " + font
          + ", size " + size + ", color " + Integer.toHexString(color) + ", backgroundColor "
          + ((backgroundColor == -1) ? "" : Integer.toHexString(backgroundColor)) + ", alpha " + alpha + "]";
    }
}
