package com.thunder.livesdk;

/**
 * @brief 图片水印
 */
public class TranscodingImage {
  public int x; // 以左上角为原点横轴坐标,默认0
  public int y; // 以左上角为原点纵轴坐标,默认0
  public int width; // 图片宽,默认0
  public int height; // 图片高,默认0
  public String url; // 图片url地址,默认空值
  public int scale; // 缩放/裁剪模式,参考TranscodingImageScaleType,默认TRANSCODING_IMAGESCALE_RATIO_TYPE
  public float alpha; // 透明度,取值范围为[0.0, 1.0],0.0完全透明,1.0完全不透明,默认1.0

  public TranscodingImage() {
    this.x = 0;
    this.y = 0;
    this.width = 0;
    this.height = 0;
    this.url = "";
    this.scale = TranscodingImageScaleType.TRANSCODING_IMAGESCALE_RATIO_TYPE;
    this.alpha = 1.0f;
  }

  public String toString() {
    return "[TranscodingImage: x " + x + ", y " + y + ", width " + width + ", height " + height
        + ", url " + url + ", scale " + scale + ", alpha " + alpha + "]";
  }
}
