package com.thunder.livesdk;

/**
 * Created by zhangfei on 2018/06/20.
 */

import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.graphics.Bitmap;

import com.hydra.Hydra;
import com.thunder.livesdk.audio.IAudioEncodedFrameObserver;
import com.thunder.livesdk.audio.IAudioFrameObserver;
import com.thunder.livesdk.helper.ThunderHttpsRequestHandler;
//import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.system.ThunderForeBackgroundListener;
import com.thunder.livesdk.system.ThunderNetStateService;
import com.thunder.livesdk.video.IVideoCaptureObserver;
import com.thunder.livesdk.video.IVideoDecodeObserver;
import com.thunder.livesdk.video.ThunderPublishLowStreamVideoConfig;
import com.thunder.livesdk.video.ThunderVideoLogCallback;
import com.thunder.livesdk.video.VideoFrameYuvCapture;
import com.thunder.livesdk.video.CpuTool;
import com.yy.mediaframework.VideoLibAPI;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.model.Rect;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.utils.YMFLog;
import com.thunder.livesdk.video.VideoTextureFrameObserver;
import com.thunder.livesdk.video.VideoFrameTextrue;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

import static com.thunder.livesdk.ThunderConstant.ThunderCameraPosition.THUNDERCAMERA_POSITION_FRONT;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderVideoCaptureOrientation.THUNDER_VIDEO_CAPTURE_ORIENTATION_PORTRAIT;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR;

/**
 * Simple access SDK for YY audios
 * All interfaces. With respect to the int type return value, unless otherwise specified, 0 indicates succeeded, <0 indicates error
 */

public class ThunderEngine {

    private static class NotificationHandler extends Handler {

        private final WeakReference<ThunderEngine> mThunderEngine;

        public NotificationHandler(ThunderEngine rtc) {
            mThunderEngine = new WeakReference<ThunderEngine>(rtc);
        }

        public NotificationHandler(ThunderEngine rtc, Looper loop) {
            super(loop);
            mThunderEngine = new WeakReference<ThunderEngine>(rtc);
        }

        @Override
        public void handleMessage(Message msg) {

            ThunderEngine thunderEngine = mThunderEngine.get();
            if (thunderEngine == null || mRtcEventHandler == null) {
                ThunderLog.release(ThunderLog.kLogTagRtcEngine, "thunderEngine or handler is null");
                return;
            }
            try {
                switch (msg.what) {
                    // new msg
                    case ThunderNotification.kThunderNotification_FirstVideoFrameSend: {
                        ThunderNotification.ThunderFirstVideoFrameSend notify = (ThunderNotification.ThunderFirstVideoFrameSend)msg.obj;
                        mRtcEventHandler.onFirstLocalVideoFrameSent(notify.getElapsedTime());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.ThunderFirstVideoFrameSend elapsedTime %d",
                                notify.getElapsedTime());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_FirstAudioFrameSend: {
                        ThunderNotification.ThunderFirstAudioFrameSend notify = (ThunderNotification.ThunderFirstAudioFrameSend)msg.obj;
                        mRtcEventHandler.onFirstLocalAudioFrameSent(notify.getElapsedTime());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.ThunderFirstAudioFrameSend elapsedTime %d",
                                notify.getElapsedTime());
                        break;
                    }

                    case ThunderNotification.kThunderNotification_JoinRoomSuccess: {
                        ThunderNotification.ThunderJoinRoomSuccess notify = (ThunderNotification.ThunderJoinRoomSuccess)msg.obj;
                        mRtcEventHandler.onJoinRoomSuccess(notify.getmRoomName(), notify.getmUid(), notify.getmElapsedTime());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.ThunderJoinRoomSucces room %s, uid %s, elapsedTime %d",
                                notify.getmRoomName(), notify.getmUid(), notify.getmElapsedTime());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_LeaveRoom: {
                        ThunderNotification.ThunderLeaveRoom notify = (ThunderNotification.ThunderLeaveRoom)msg.obj;
                        ThunderEventHandler.RoomStats roomStats = new ThunderEventHandler.RoomStats();
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_LeaveRoom");
                        mRtcEventHandler.onLeaveRoom(roomStats);
                        break;
                    }
                    case ThunderNotification.kThunderNotification_RemoteVideoPlay: {
                        ThunderNotification.ThunderRemoteVideoPlay notify = (ThunderNotification.ThunderRemoteVideoPlay)msg.obj;
                        mRtcEventHandler.onRemoteVideoPlay(notify.getmUid(), notify.getmWith(), notify.getmHeigh(), notify.getmElapsedTime());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.kThunderNotification_RemoteVideoPlay uid %s, with %d, heigh %d, elapsedTime %d",
                                notify.getmUid(), notify.getmWith(), notify.getmHeigh(), notify.getmElapsedTime());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_BizAuthRes: {
                        ThunderNotification.ThunderBizAuthStreamRes notify = (ThunderNotification.ThunderBizAuthStreamRes)msg.obj;
                        mRtcEventHandler.onBizAuthResult(notify.isbPublish(), notify.getmResult());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.ThunderBizAuthRes bPublish %b, result %d",
                                notify.isbPublish(), notify.getmResult());

                        mRtcEventHandler.onBizAuthStreamResult(notify.isbPublish(), notify.getmStreamType(), notify.getmResult());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.ThunderBizAuthStreamRes bPublish %b, type %d, result %d",
                                notify.isbPublish(), notify.getmStreamType(), notify.getmResult());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_SdkAuthRes: {
                        ThunderNotification.ThunderSdkAuthRes notify = (ThunderNotification.ThunderSdkAuthRes)msg.obj;
                        mRtcEventHandler.onSdkAuthResult(notify.getmResult());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.ThunderSdkAuthRes result %d",
                                notify.getmResult());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_UserBanned: {
                        ThunderNotification.ThunderUserBanned notify = (ThunderNotification.ThunderUserBanned)msg.obj;
                        mRtcEventHandler.onUserBanned(notify.isbBanned());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.ThunderUserBanned bBanned %b",
                                notify.isbBanned());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_TokenRequest: {
                        ThunderNotification.ThunderTokenRequest notify = (ThunderNotification.ThunderTokenRequest)msg.obj;
                        mRtcEventHandler.onTokenRequested();
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.ThunderTokenRequest");
                        break;
                    }
                    case ThunderNotification.kThunderNotification_TokenWillExpire: {
                        ThunderNotification.ThunderTokenWillExpire notify = (ThunderNotification.ThunderTokenWillExpire)msg.obj;
                        mRtcEventHandler.onTokenWillExpire(notify.getToken().getBytes());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.ThunderTokenWillExpire %s", notify.getToken());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AudioCaptureVolume: {
                        ThunderNotification.ThunderAudioCaptureVolume notify = (ThunderNotification.ThunderAudioCaptureVolume)msg.obj;
                        mRtcEventHandler.onCaptureVolumeIndication(notify.getmVolume(), notify.getmCpt(), notify.getmMicVolume());
                        if ((s_captureVolumeNotifyCount % 200) == 0) {
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                              "ThunderNotification.ThunderAudioCaptureVolume totalVolume %d, cpt %d, micVolume %d",
                              notify.getmVolume(), notify.getmCpt(), notify.getmMicVolume());
                        }
                        ++s_captureVolumeNotifyCount;
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AudioPlayVolume:
                    {
                        ThunderNotification.ThunderAudioPlayVolume notify = (ThunderNotification.ThunderAudioPlayVolume)msg.obj;
                        HashSet<ThunderEventHandler.AudioVolumeInfo> audioPlayVolumes =  notify.getVolumes();
                        if (audioPlayVolumes != null && !audioPlayVolumes.isEmpty())
                        {
                            ThunderEventHandler.AudioVolumeInfo[] volumeInfos =
                                    audioPlayVolumes.toArray(new ThunderEventHandler.AudioVolumeInfo[audioPlayVolumes.size()]);
                            mRtcEventHandler.onPlayVolumeIndication(volumeInfos, notify.getTotalVolume());
                            if ((s_playVolumeNotifyCount % 200) == 0) {
                                ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                        "ThunderNotification.ThunderAudioPlayVolume size %d totalVolume %d",
                                        notify.getVolumes().size(), notify.getTotalVolume());
                            }
                            ++ s_playVolumeNotifyCount;

                        } else {
                            ThunderLog.error(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.ThunderAudioPlayVolume size %d totalVolume %d",
                                    0, notify.getTotalVolume());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AudioPlayData: {
                        ThunderNotification.ThunderAudioPlayData notify = (ThunderNotification.ThunderAudioPlayData)msg.obj;
                        mRtcEventHandler.onAudioPlayData(notify.getData(), notify.getCpt(), notify.getPts(), notify.getUid(), notify.getDuration());
                        if ((s_playDataNotifyCount % 500) == 0) {
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.ThunderAudioPlayData cpt %d, pts %d, uid %s, duration %d",
                                    notify.getCpt(), notify.getPts(), notify.getUid(), notify.getDuration());
                        }
                        ++ s_playDataNotifyCount;
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AudioPlaySpectrumData: {
                        ThunderNotification.ThunderAudioPlaySpectrumData notify = (ThunderNotification.ThunderAudioPlaySpectrumData)msg.obj;
                        mRtcEventHandler.onAudioPlaySpectrumData(notify.getData());
                        if ((s_audioPlaySpectrumCount % 500) == 0) {
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_AudioPlaySpectrumData");
                        }
                        ++ s_audioPlaySpectrumCount;
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AudioCapturePcmData:
                    {
                        ThunderNotification.ThunderAudioCapturePcmData notify = (ThunderNotification.ThunderAudioCapturePcmData)msg.obj;
                        mRtcEventHandler.onAudioCapturePcmData(notify.getData(), notify.getLen(), notify.getSampleRate(), notify.getChannel());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_UserAppMsgData: {
                        ThunderNotification.ThunderUserAppMsgData notify = (ThunderNotification.ThunderUserAppMsgData) msg.obj;
                        mRtcEventHandler.onRecvUserAppMsgData(notify.getMsgData().getBytes(), notify.getUid());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AppMsgDataFailStatus: {
                        ThunderNotification.ThunderAppMsgDataFailStatus notify = (ThunderNotification.ThunderAppMsgDataFailStatus) msg.obj;
                        mRtcEventHandler.onSendAppMsgDataFailedStatus(notify.getStatus());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_AppMsgDataFailStatus status %d",
                                notify.getStatus());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AudioRenderPcmData: {
                        ThunderNotification.ThunderAudioRenderPcmData notify = (ThunderNotification.ThunderAudioRenderPcmData) msg.obj;
                        mRtcEventHandler.onAudioRenderPcmData(notify.getData(), notify.getLen(), notify.getDuration(), notify.getSampleRate(), notify.getChannel());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_HttpsRequest: {
                        ThunderNotification.ThunderHttpsRequest notify = (ThunderNotification.ThunderHttpsRequest)msg.obj;
                        if (mHttpsRequestHandler != null) {
                            mHttpsRequestHandler.send(notify.getUrl(), notify.getTarget());
                        }
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_HttpsRequest, url %s, target %d",
                                notify.getUrl(), notify.getTarget());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_RemoteVideoStopped: {
                        ThunderNotification.ThunderRemoteVideoStopped notify = (ThunderNotification.ThunderRemoteVideoStopped)msg.obj;
                        mRtcEventHandler.onRemoteVideoStopped(notify.getUid(), notify.isbStop());
                        mRtcEventHandler.onRemoteVideoArrived(notify.getRoomId(), notify.getUid(), !notify.isbStop());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_RemoteVideoArrived roomId %s, uid %s, arrive %b",
                                notify.getRoomId(), notify.getUid(), !notify.isbStop());
                        break;
                    }

                    case ThunderNotification.kThunderNotification_RemoteAudioStopped: {
                        ThunderNotification.ThunderRemoteAudioStopped notify = (ThunderNotification.ThunderRemoteAudioStopped)msg.obj;
                        mRtcEventHandler.onRemoteAudioStopped(notify.getUid(), notify.isbStop());
                        mRtcEventHandler.onRemoteAudioArrived(notify.getRoomId(), notify.getUid(), !notify.isbStop());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_RemoteAudioArrived roomId %s, uid %s, arrive %b",
                                notify.getRoomId(), notify.getUid(), !notify.isbStop());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_VideoSizeChange: {
                        ThunderNotification.ThunderVideoSizeChange notify = (ThunderNotification.ThunderVideoSizeChange) msg.obj;
                        mRtcEventHandler.onVideoSizeChanged(notify.getUid(), notify.getWidth(), notify.getHeight(), 0);
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_VideoSizeChange uid %s, w %d, h %d",
                                notify.getUid(), notify.getWidth(), notify.getHeight());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_ConnectionStatus: {
                        ThunderNotification.ThunderConnectionStatus notify = (ThunderNotification.ThunderConnectionStatus) msg.obj;
                        mRtcEventHandler.onConnectionStatus(notify.getStatus());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_ConnectionLost: {
                        ThunderNotification.ThunderConnectionLost notify = (ThunderNotification.ThunderConnectionLost)msg.obj;
                        mRtcEventHandler.onConnectionLost();
                        break;
                    }
                    case ThunderNotification.kThunderNotification_RoomStats: {
                        ThunderNotification.RoomStats notify = (ThunderNotification.RoomStats)msg.obj;
                        mRtcEventHandler.onRoomStats(notify);
                        break;
                    }
                    case ThunderNotification.kThunderNotification_NetworkStateChange: {
                        ThunderNotification.ThunderNetworkStateChange notify = (ThunderNotification.ThunderNetworkStateChange)msg.obj;
                        mRtcEventHandler.onNetworkTypeChanged(notify.getStatus());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_NetworkStateChange status %d",
                                notify.getStatus());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_PublishStreamToCdnStatus: {
                        ThunderNotification.ThunderPublishStreamToCdnStatus notify = (ThunderNotification.ThunderPublishStreamToCdnStatus)msg.obj;
                        mRtcEventHandler.onPublishStreamToCDNStatus(notify.getUrl(), notify.getErrorCode());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_PublishStreamToCdnStatus url %s, errorCode %d",
                                notify.getUrl(), notify.getErrorCode());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_UserJoined: {
                        ThunderNotification.ThunderUserJoined notify = (ThunderNotification.ThunderUserJoined) msg.obj;
                        mRtcEventHandler.onUserJoined(notify.getUid(), notify.getElapsedTime());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_UserJoined uid %s", notify.getUid());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_UserOffline: {
                        ThunderNotification.ThunderUserOffline notify = (ThunderNotification.ThunderUserOffline)msg.obj;
                        mRtcEventHandler.onUserOffline(notify.getUid(), notify.getReason());
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderNotification.kThunderNotification_UserOffline uid %s reason %d",
                                notify.getUid(), notify.getReason());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_NetworkQuality: {
                        ThunderNotification.ThunderNetworkQuality notify = (ThunderNotification.ThunderNetworkQuality) msg.obj;
                        mRtcEventHandler.onNetworkQuality(notify.getUid(), notify.getTxQuality(), notify.getRxQuality());
                    }
                        break;
                    case ThunderNotification.kThunderNotification_AudioExtraInfo: {
                        ThunderNotification.ThunderAudioExtraInfo notify = (ThunderNotification.ThunderAudioExtraInfo) msg.obj;
                        if (mThunderMediaExtraInfoCallback != null) {
                            ByteBuffer extraInfo = ByteBuffer.wrap(notify.getExtraInfo());
                            mThunderMediaExtraInfoCallback.onRecvMediaExtraInfo(notify.getUid(), extraInfo, extraInfo.remaining());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AudioExtraFailStatus: {
                        ThunderNotification.ThunderAudioExtraFailStatus notify = (ThunderNotification.ThunderAudioExtraFailStatus) msg.obj;
                        if (mThunderMediaExtraInfoCallback != null) {
                            mThunderMediaExtraInfoCallback.onSendMediaExtraInfoFailedStatus(notify.getStatus());
                        }
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "kThunderNotification_AudioExtraFailStatus status %d", notify.getStatus());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_VideoExtraInfo: {
                        if (mThunderMediaExtraInfoCallback != null) {
                            ThunderNotification.ThunderVideoExtraInfo notify = (ThunderNotification.ThunderVideoExtraInfo) msg.obj;
                            ByteBuffer extraInfo = ByteBuffer.wrap(notify.getExtraInfo());
                            mThunderMediaExtraInfoCallback.onRecvMediaExtraInfo(notify.getUid(), extraInfo, extraInfo.remaining());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_MixVideoExtraInfo:
                        if (mThunderMediaExtraInfoCallback != null) {
                            ThunderNotification.ThunderMixVideoExtraInfo notify = (ThunderNotification.ThunderMixVideoExtraInfo)msg.obj;
                            mThunderMediaExtraInfoCallback.onRecvMixVideoInfo(notify.getmUid(), notify.getMixExtraInfos());
                        }
                        break;
                    case ThunderNotification.kThunderNotification_MixAudioExtraInfo:
                        if (mThunderMediaExtraInfoCallback != null) {
                            ThunderNotification.ThunderMixAudioExtraInfo notify = (ThunderNotification.ThunderMixAudioExtraInfo) msg.obj;
                            mThunderMediaExtraInfoCallback.onRecvMixAudioInfo(notify.getmUid(), notify.getMixAudioExtraInfos());
                        }
                        break;
                    case ThunderNotification.kThunderNotification_AudioCaptureStatus: {
                        ThunderNotification.ThunderAudioCaptureStatus notify = (ThunderNotification.ThunderAudioCaptureStatus)msg.obj;
                        mRtcEventHandler.onAudioCaptureStatus(notify.getStatus());
                        break;
                    }
                    case ThunderNotification.kThunderNotification_VideoCaptureStatus: {
                        ThunderNotification.ThunderVideoCaptureStatus notify = (ThunderNotification.ThunderVideoCaptureStatus) msg.obj;
                        mRtcEventHandler.onVideoCaptureStatus(notify.getStatus());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_LocalVideoStats: {
                        ThunderNotification.ThunderLocalVideoStats info = (ThunderNotification.ThunderLocalVideoStats)msg.obj;
//                        ThunderLog.info(ThunderLog.kLogTagRtcEngine, String.format("ThunderNotification.ThunderLocalVideoStats sendBitR=%d " +
//                                        "sendFrameR=%d renderOutFrameR=%d targetBit=%d targetFrameR=%d sendFrameCount=%d qualityAdap=%d " +
//                                        "encodeFrameR=%d encodeBit=%d resolution=%dx%d encodedType=%d codec=%d cfgBitrate=%d cfgFrameRate=%d" +
//                                        " cfgWidth=%d cfgHeight=%d",
//                                info.getSendBitrate(), info.getSendFrameRate(), info.getRenderOutputFrameRate(), info.getTargetBitrate(), info.getTargetFrameRate(),
//                                info.getEncodedFrameCount(), info.getQualityAdaptIndicat(), info.getEncodeFrameRate(),
//                                info.getBitrate(), info.getWidth(), info.getHeight(), info.getEncodedType(), info.getCodec(), info.getConfigBitRate(), info.getConfigFrameRate(),
//                                info.getConfigWidth(), info.getConfigHeight()));
                        if(mRtcEventHandler != null)
                        {
                            ThunderEventHandler.LocalVideoStats stats = new ThunderEventHandler.LocalVideoStats();
                            stats.sentBitrate = info.getSendBitrate();
                            stats.sentFrameRate = info.getSendFrameRate();
                            stats.renderOutputFrameRate = info.getRenderOutputFrameRate();
                            stats.targetBitRate = info.getTargetBitrate();
                            stats.targetFrameRate = info.getTargetFrameRate();
                            stats.qualityAdaptIndication = info.getQualityAdaptIndicat();
                            stats.encoderOutputFrameRate = info.getEncodeFrameRate();
                            stats.encodedBitrate = info.getBitrate();
                            stats.encodedFrameWidth = info.getWidth();
                            stats.encodedFrameHeight = info.getHeight();
                            stats.encodedFrameCount = info.getEncodedFrameCount();
                            stats.encodedType = info.getEncodedType();
                            stats.codecType = info.getCodec();
                            stats.configBitRate = info.getConfigBitRate();
                            stats.configFrameRate = info.getConfigFrameRate();
                            stats.configWidth = info.getConfigWidth();
                            stats.configHeight = info.getConfigHeight();
                            mRtcEventHandler.onLocalVideoStats(stats);
                        }
                        break;
                    }
					case ThunderNotification.kThunderAPINotification_LocalAudioStats: {
                        ThunderNotification.ThunderLocalAudioStats info = (ThunderNotification.ThunderLocalAudioStats) msg.obj;
if (ThunderLog.isInfoValid()) {
                        ThunderLog.info(ThunderLog.kLogTagRtcEngine, String.format("ThunderNotification.ThunderLocalAudioStats encodedBitrate=%d channels=%d " +
                                "sendSampleRate=%d sendBitRate=%d enableVad=%d", info.getEncodedBitrate(), info.getNumChannels(), info.getSampleRate(), info.getSendBitRate(), info.getEnableVad()));
}
                        if (mRtcEventHandler != null) {
                            ThunderEventHandler.LocalAudioStats stats = new ThunderEventHandler.LocalAudioStats();
                            stats.encodedBitrate = info.getEncodedBitrate();
                            stats.numChannels = info.getNumChannels();
                            stats.sendSampleRate = info.getSampleRate();
                            stats.sendBitrate = info.getSendBitRate();
                            stats.enableVad = info.getEnableVad();
                            mRtcEventHandler.onLocalAudioStats(stats);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_RemoteVideoStats: {
                        ThunderNotification.RemoteVideoStats info = (ThunderNotification.RemoteVideoStats)msg.obj;
                        if(mRtcEventHandler != null)
                        {
                            ThunderEventHandler.RemoteVideoStats stats = new ThunderEventHandler.RemoteVideoStats();
                            stats.delay = info.getDelay();
                            stats.width = info.getWidth();
                            stats.height = info.getHeight();
                            stats.receivedBitrate = info.getReceivedBitrate();
                            stats.decoderOutputFrameRate = info.getDecoderFrameRate();
                            stats.rendererOutputFrameRate = info.getRenderFrameRate();
                            stats.packetLossRate = info.getPacketLossRate();
                            stats.rxStreamType = info.getRxStreamType();
                            stats.totalFrozenTime = info.getFrozenTime();
                            stats.frozenRate = info.getFrozenRate();
                            stats.codecType = info.getCodecType();
                            stats.decodedType = info.getDecodedType();
                            mRtcEventHandler.onRemoteVideoStatsOfUid(info.getUid(), stats);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_RemoteAudioStats: {
                        ThunderNotification.RemoteAudioStats info = (ThunderNotification.RemoteAudioStats)msg.obj;
                        if(mRtcEventHandler != null)
                        {
                            ThunderEventHandler.RemoteAudioStats stats = new ThunderEventHandler.RemoteAudioStats();
                            stats.quality = info.getQuality();
                            stats.networkTransportDelay = info.getNetworkTransportDelay();
                            stats.jitterBufferDelay = info.getJitterBufferDelay();
                            stats.totalDelay = info.getTotalDelay();
                            stats.frameLossRate = info.getFrameLossRate();
                            stats.numChannels = info.getNumChannels();
                            stats.receivedSampleRate = info.getReceivedSampleRate();
                            stats.receivedBitrate = info.getReceivedBitrate();
                            stats.totalFrozenTime = info.getFrozenTime();
                            stats.frozenRate = info.getFrozenRate();
                            mRtcEventHandler.onRemoteAudioStatsOfUid(info.getUid(), stats);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_RemoteAudioStateChanged: {
                        ThunderNotification.ThunderRemoteAudioStateChanged info = (ThunderNotification.ThunderRemoteAudioStateChanged) msg.obj;
                        if (mRtcEventHandler != null && info != null) {
                            mRtcEventHandler.onRemoteAudioStateChangedOfUid(info.getUid(), info.getState(), info.getReason(), info.getElapsedTime());
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.kThunderNotification_RemoteAudioStateChanged uid %s, state %d, reason %d, elapsedTime %d",
                                    info.getUid(), info.getState(), info.getReason(), info.getElapsedTime());
                        }
                    }
                    break;
                    case ThunderNotification.kThunderNotification_RemoteVideoStateChanged: {
                        ThunderNotification.ThunderRemoteVideoStateChanged info = (ThunderNotification.ThunderRemoteVideoStateChanged) msg.obj;
                        if (mRtcEventHandler != null && info != null) {
                            mRtcEventHandler.onRemoteVideoStateChangedOfUid(info.getUid(), info.getState(), info.getReason(), info.getElapsedTime());
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.kThunderNotification_RemoteVideoStateChanged uid %s, state %d, reason %d, elapsedTime %d",
                                    info.getUid(), info.getState(), info.getReason(), info.getElapsedTime());
                        }
                    }
                    break;
                    case ThunderNotification.kThunderNotification_RemoteAudioPlay: {
                        ThunderNotification.ThunderRemoteAudioPlay info = (ThunderNotification.ThunderRemoteAudioPlay) msg.obj;
                        if (mRtcEventHandler != null && info != null) {
                            mRtcEventHandler.onRemoteAudioPlay(info.getUid(), info.getElapsedTime());
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.kThunderNotification_RemoteAudioStateChanged uid %s, elapsedTime %d",
                                    info.getUid(), info.getElapsedTime());
                        }
                    }
                    break;
                    case ThunderNotification.kThunderAPINotification_LocalAudioStatusChanged: {
                        ThunderNotification.LocalAudioStatusChanged info = (ThunderNotification.LocalAudioStatusChanged)msg.obj;
if (ThunderLog.isInfoValid()) {
                        ThunderLog.info(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.LocalAudioStatusChanged status=%d errorReason=%d",
                                info.getLocalAudioStreamStatus(), info.getLocalAudioStreamErrorReason());
}
                        if(mRtcEventHandler != null)
                        {
                            ThunderEventHandler.LocalAudioStatusChanged stats = new ThunderEventHandler.LocalAudioStatusChanged();
                            stats.status = info.getLocalAudioStreamStatus();
                            stats.errorReason = info.getLocalAudioStreamErrorReason();
                            mRtcEventHandler.onLocalAudioStatusChanged(stats.status, stats.errorReason);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_LocalVideoStatusChanged: {
                        ThunderNotification.LocalVideoStatusChanged info = (ThunderNotification.LocalVideoStatusChanged)msg.obj;
if (ThunderLog.isInfoValid()) {
                        ThunderLog.info(ThunderLog.kLogTagRtcEngine,
                                "ThunderNotification.LocalVideoStatusChanged status=%d errorReason=%d",
                                info.getLocalVideoStreamStatus(), info.getLocalVideoStreamError());
}
                        if (mRtcEventHandler != null) {
                            mRtcEventHandler.onLocalVideoStatusChanged(info.getLocalVideoStreamStatus(), info.getLocalVideoStreamError());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_DeviceStats: {
                        ThunderNotification.ThunderDeviceStats info = (ThunderNotification.ThunderDeviceStats)msg.obj;
                        if(mRtcEventHandler != null)
                        {
                            ThunderEventHandler.DeviceStats stats = new ThunderEventHandler.DeviceStats();
                            stats.cpuTotalUsage =  info.getCpuTotalUsage(); // 只能获取到android 8.0以下系统的cpu使用率
                            stats.cpuAppUsage = info.getCpuAppUsage();
                            stats.memoryAppUsage = info.getMemoryAppUsage();
                            stats.memoryTotalUsage = info.getMemoryTotalUsage();
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.ThunderDeviceStats cpuTotalUsage=%f cpuAppUsage=%f memoryAppUsage=%f memoryTotalUsage=%f",
                                    stats.cpuTotalUsage, stats.cpuAppUsage, stats.memoryAppUsage, stats.memoryTotalUsage);
                            mRtcEventHandler.onDeviceStats(stats);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_UserRoleChanged: {
                        ThunderNotification.ThunderUserRoleChanged info = (ThunderNotification.ThunderUserRoleChanged)msg.obj;
                        if(mRtcEventHandler != null)
                        {
                            int oldRole = info.getOldRole();
                            int newRole = info.getNewRole();
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.ThunderUserRoleChanged oldRole=%d newRole=%d",
                                    oldRole, newRole);
                            mRtcEventHandler.onUserRoleChanged(oldRole, newRole);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_AudioRouteChanged: {
                        ThunderNotification.ThunderAudioRouteChanged info = (ThunderNotification.ThunderAudioRouteChanged)msg.obj;
                        if(mRtcEventHandler != null)
                        {
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.ThunderAudioRouteChanged Routing = %d",
                                    info.getRouting());
                            mRtcEventHandler.onAudioRouteChanged(info.getRouting());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_HowlingDetectResult:{
                        ThunderNotification.ThunderHowlingDetectResult info = (ThunderNotification.ThunderHowlingDetectResult)msg.obj;
                        if(mRtcEventHandler != null)
                        {
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.ThunderHowlingDetectResult value = %b",
                                    info.getValue());
                            mRtcEventHandler.onHowlingDetectResult(info.getValue());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_EchoDetectResult:{
                        ThunderNotification.ThunderEchoDetectResult info = (ThunderNotification.ThunderEchoDetectResult)msg.obj;
                        if(mRtcEventHandler != null)
                        {
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.ThunderEchoDetectResult value = %b",
                                    info.getValue());
                            mRtcEventHandler.onEchoDetectResult(info.getValue());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AudioInputDeviceTestVolume:{
                        ThunderNotification.ThunderAudioInputDeviceTestVolume info =
                                (ThunderNotification.ThunderAudioInputDeviceTestVolume)msg.obj;
                        if(mRtcEventHandler != null)
                        {
                            mRtcEventHandler.onAudioInputDeviceTestVolume(info.getVolume());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AudioOutputDeviceTestVolume:{
                        ThunderNotification.ThunderAudioOutputDeviceTestVolume info =
                                (ThunderNotification.ThunderAudioOutputDeviceTestVolume)msg.obj;
                        if(mRtcEventHandler != null)
                        {
                            mRtcEventHandler.onAudioOutputDeviceTestVolume(info.getVolume());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_CameraExposureChanged:{
                        ThunderNotification.ThunderVideoCaptureExposureChanged info = (ThunderNotification.ThunderVideoCaptureExposureChanged)msg.obj;
                        if(mRtcEventHandler != null) {
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.ThunderVideoCaptureExposureChanged posX = %d, poxY = %d, w = %d, h = %d",
                                    info.getPosX(), info.getPosY(), info.getWidth(), info.getHeight());
                            Rect rect = new Rect((float)info.getPosX(), (float)info.getPosY(),
                                    (float)(info.getPosX() + info.getWidth()), (float)(info.getPosY() - info.getHeight()));
                            mRtcEventHandler.onCameraExposureAreaChanged(rect);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_CameraFocuseChanged: {
                        ThunderNotification.ThunderVideoCaptureFocusChanged info = (ThunderNotification.ThunderVideoCaptureFocusChanged) msg.obj;
                        if (mRtcEventHandler != null) {
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.ThunderVideoCaptureFocusChanged posX = %d, poxY = %d, w = %d, h = %d",
                                    info.getPosX(), info.getPosY(), info.getWidth(), info.getHeight());
                            Rect rect = new Rect((float) info.getPosX(), (float) info.getPosY(),
                                    (float) (info.getPosX() + info.getWidth()), (float) (info.getPosY() - info.getHeight()));
                            mRtcEventHandler.onCameraFocusAreaChanged(rect);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_PrivateCallBack:{
                        ThunderNotification.ThunderPrivateCallBack info = (ThunderNotification.ThunderPrivateCallBack)msg.obj;
                        if (mRtcEventHandler != null){
if (ThunderLog.isInfoValid()) {
                            ThunderLog.info(ThunderLog.kLogTagRtcEngine,
                                    "ThunderNotification.PrivateCallBack key:%d jsonStr:%s",
                                    info.getmKey(), info.getmJsonStr());
}
                            mRtcEventHandler.onParamsCallback(info.getmKey(), info.getmJsonStr());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderNotification_AudioRecordState:{
                        ThunderNotification.ThunderAudioRecordState info =
                                (ThunderNotification.ThunderAudioRecordState)msg.obj;
                        if(mRtcEventHandler != null)
                        {
                            mRtcEventHandler.onAudioRecordState(info.getErrorCode(), info.getDuration());
                        }
                        break;
                    }
                    // new msg end

                    default:
                        break;
                }
            } catch (Exception exc) {
                StringWriter errors = new StringWriter();
                exc.printStackTrace(new PrintWriter(errors));
                ThunderLog.error(ThunderLog.kLogTagRtcEngine, String.format("handleMessage err=%s", errors.toString()));
            }
        }
    }
    // new start of Para
    private static boolean mIsInited = false;
    private static NotificationHandler mHandler = null;
    private static ThunderNetStateService mNetStateService = null;
    private static ThunderForeBackgroundListener mForeBackgroundListener = null;
    private static ThunderNative.NotificationDispatcher mNotificationDispatcher = null;

    private static ThunderEventHandler mRtcEventHandler;

    // https request handler
    private static ThunderHttpsRequestHandler mHttpsRequestHandler;

    private static IThunderMediaExtraInfoCallback mThunderMediaExtraInfoCallback = null;

    private static int s_captureVolumeNotifyCount = 0;
    private static int s_playVolumeNotifyCount = 0;
    private static int s_playDataNotifyCount = 0;
    private static int s_audioPlaySpectrumCount = 0;

    private Set<ThunderAudioFilePlayer> mAudioFilePlayerSet = new TreeSet<ThunderAudioFilePlayer>();
    private static ThunderPublisher mPublisher = null;
    private ExternalVideoSource mExternalVideoSource = null;

    private ThunderEngine() {
        mPublisher = new ThunderPublisher();
    }

    private static class SingleonHolder {
        private static ThunderEngine INSTANCE = new ThunderEngine();
    }

    static
    {
//        try {
//            System.loadLibrary("yyservicesdk");
//        } catch (Throwable e) {
//            e.printStackTrace();
//            Log.e(ThunderLog.kLogTagRtcEngine, "load servicesdk failed!");
//        }
        if (BuildConfig.FLAVOR.equalsIgnoreCase("fullvideo")) {
            try {
                System.loadLibrary("c++_shared");
            } catch (Throwable e) {
                e.printStackTrace();
                Log.e(ThunderLog.kLogTagRtcEngine, "fullvideo flavor load c++_shared failed!");
            }
        }
        if (BuildConfig.__YY_VIDEO_SUPPORT__) {
            // Manually load ffmpeg and ittiam in the yyvideoplayer library of part of models in advance.
            try {
                System.loadLibrary("ffmpeg-neon");
                System.loadLibrary("yydec265");
            } catch (Throwable e) {
                e.printStackTrace();
                Log.e(ThunderLog.kLogTagRtcEngine, "load ffmpeg-neon & Ittiamhevcdec failed!");
            }
        }
//        if (BuildConfig.__YY_VIDEO_SUPPORT__) {
//            // Since there are faults when the Android 4.2.2 system loads JNI through dependencies, actively load is needed
//            try {
//                System.loadLibrary("yyvideoplayer");
//            } catch (Throwable e) {
//                e.printStackTrace();
//                Log.e(ThunderLog.kLogTagRtcEngine, "load yyvideoplayer failed!");
//            }
//        }
//
//        try {
//            // load argo
//            System.loadLibrary("argo");
//        } catch (Throwable e) {
//            e.printStackTrace();
//            Log.e(ThunderLog.kLogTagRtcEngine, "load argo failed!");
//        }

        try {
            System.loadLibrary("thunder");
        } catch (Throwable e) {
            e.printStackTrace();
            //The log module will crash in case of failed call of load lib
            Log.e(ThunderLog.kLogTagRtcEngine, "load thunder failed!");
        }
    }

    private static synchronized ThunderEngine createRtcEngine(Context context,
                                                              String appId,
                                                              long sceneId,
                                                              int areaType,
                                                              int serverDomain,
                                                              ThunderEventHandler handler,
                                                              Looper loop) {
        long tempAppId = 0L;
        try {
            tempAppId = Long.parseLong(appId);
        } catch(NumberFormatException e) {
            Log.e(ThunderLog.kLogTagRtcEngine, "init failed, appid is not number");
            return null;
        }

        if (SingleonHolder.INSTANCE == null) {
            SingleonHolder.INSTANCE = new ThunderEngine();
        }

        if (mHandler == null) {
            if (loop != null) {
                mHandler = new NotificationHandler(SingleonHolder.INSTANCE, loop);
            } else {
                mHandler = new NotificationHandler(SingleonHolder.INSTANCE);
            }
        }

        // X shall not be initialized any more if it has been created
        if (!mIsInited) {
            mRtcEventHandler = handler;
            mHttpsRequestHandler = new ThunderHttpsRequestHandler();

            if (BuildConfig.__YY_VIDEO_SUPPORT__) {
                YMFLog.registerLogger(ThunderVideoLogCallback.sharedInstance());
            }

            if (mNetStateService != null) {
                mNetStateService.fini();
            }
            if (mForeBackgroundListener != null) {
                mForeBackgroundListener.fini();
            }
            mNotificationDispatcher = new ThunderNative.NotificationDispatcher() {
                private final HashSet<Handler> mNotificationHandlers = new HashSet<>();
                @Override
                public void registerNotificationHandler(Handler handler) {
                    synchronized (mNotificationHandlers) {
                        mNotificationHandlers.add(handler);
                    }
                }

                @Override
                public void unregisterNotificationHandler(Handler handler) {
                    synchronized (mNotificationHandlers) {
                        mNotificationHandlers.remove(handler);
                    }
                }

                @Override
                public Object[] collectNotificationHandlers() {
                    Object[] handlers = null;
                    synchronized (mNotificationHandlers) {
                        if (mNotificationHandlers.size() > 0) {
                            handlers = mNotificationHandlers.toArray();
                        }
                    }
                    return handlers;
                }
            };

            // Perform register notification prior to the initialization of Service
            mNotificationDispatcher.registerNotificationHandler((Handler) mHandler);
            ThunderDeviceInfo info  = new ThunderDeviceInfo(context);

            if (BuildConfig.__YY_VIDEO_SUPPORT__) {
                // context
                YYVideoLibMgr.instance().init(context, "1.0", "Thunder",
                        Build.VERSION.RELEASE, Build.MODEL, null);
                // Initialize a publishing library
                VideoLibAPI.instance().initVideoLib(tempAppId, sceneId, context);
            }

            int ret = ThunderNative.init(tempAppId,
                                         sceneId,
                                         areaType,
                                         serverDomain,
                                         context,
                                         info,
                                         mNotificationDispatcher);
            if (ret < 0) {
                ThunderLog.error(ThunderLog.kLogTagRtcEngine, "init failed");
                return null;
            }


            mNetStateService = new ThunderNetStateService(context);
            mNetStateService.init();
            mForeBackgroundListener = new ThunderForeBackgroundListener(context);
            mForeBackgroundListener.init();

            mIsInited = true;

            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "createEngine, appid %s, sceneId %d, areaType %d, serverDomain %d, handler %s",
                    appId, sceneId, areaType, serverDomain, handler == null ? "" : handler.toString());
        }

        return SingleonHolder.INSTANCE;
    }

    /**
     * Create a RtcEngine object
     * <br> Only support one instance
     * <br> The system will allocate the unique appId after creation of app on sunclouds.com, and modification on appId is not allowed after initialization
     *
     * @param context Andoird APP context
     * @param appId   A unique identifier accessed to app
     * @param sceneId A scene ID, namely developer-customized scene ID for subdividing service scenarios; it is recommended to fill in 0 if the scene ID is not required
     * @param handler ThunderEventHandler is an abstract class of default implementation, and SDK reports all events during the running of SDK to app by means of this abstract class\
     * @return ThunderEngine object
     */
    public static synchronized ThunderEngine createEngine(Context context,
                                                          String appId,
                                                          long sceneId,
                                                          ThunderEventHandler handler) {

        ThunderEngine rtcEngine = createRtcEngine(context,
                                                  appId,
                                                  sceneId,
                                                  -1,
                                                  -1,
                                                  handler,
                                                  null);
        return rtcEngine;
    }

    /**
     * Create a RtcEngine object with ThunderEngineConfig
     * <br> Only support one instance
     * <br> The system will allocate the unique appId after creation of app on sunclouds.com, and modification on appId is not allowed after initialization
     *
     * @param config config of your ThunderEngine {@link ThunderEngineConfig}
     * @return ThunderEngine object
     */
    public static synchronized ThunderEngine createEngine(ThunderEngineConfig config) {
        ThunderEngine rtcEngine = createRtcEngine(config.context,
                                                  config.appId,
                                                  config.sceneId,
                                                  config.areaType,
                                                  config.serverDomain,
                                                  config.handler,
                                                  null);
        return rtcEngine;
    }

    /**
     * Create a RtcEngine object
     * <br> Only support one instance
     * <br> The system will allocate the unique appId after creation of app on yylivesdk.yy.com, and modification on appId is not allowed after initialization
     *
     * @param context Andoird APP context
     * @param appId   A unique identifier accessed to app
     * @param sceneId A scene ID, namely developer-customized scene ID for subdividing service scenarios; it is recommended to fill in 0 if the scene ID is not required
     * @param handler ThunderEventHandler is an abstract class of default implementation, and SDK reports all events during the running of SDK to app by means of this abstract class\
     * @loop Callback execution thread
     * @return ThunderEngine object
     */
    public static synchronized ThunderEngine createWithLoop(Context context,
                                                            String appId,
                                                            long sceneId,
                                                            ThunderEventHandler handler,
                                                            Looper loop) {
        ThunderEngine rtcEngine = createRtcEngine(context,
                                                  appId,
                                                  sceneId,
                                                  -1,
                                                  -1,
                                                  handler,
                                                  loop);
        return rtcEngine;
    }

    /**
     * Create a RtcEngine object
     * <br> Only support one instance
     * <br> The system will allocate the unique appId after creation of app on yylivesdk.yy.com, and modification on appId is not allowed after initialization
     *
     * @param config config of your ThunderEngine {@link ThunderEngineConfig}
     * @loop Callback execution thread
     * @return ThunderEngine object
     */
    public static synchronized ThunderEngine createWithLoop(ThunderEngineConfig config,
                                                            Looper loop) {
        ThunderEngine rtcEngine = createRtcEngine(config.context,
                                                  config.appId,
                                                  config.sceneId,
                                                  config.areaType,
                                                  config.serverDomain,
                                                  config.handler,
                                                  loop);
        return rtcEngine;
    }

    /**
     * Destroy RtcEngine object
     * To use the communication function again, createEngine must be called again to create a ThunderEngine instance.
     */
    public static synchronized void destroyEngine() {
        // Do not uninstall the object if it has been destroyed
        if (mIsInited) {
            // watermark
            SingleonHolder.INSTANCE.setVideoWatermark(null);
            // mirror
            SingleonHolder.INSTANCE.setLocalVideoMirrorMode(THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR);
            // audioFilePlayer
            SingleonHolder.INSTANCE.cleanAllAudioFilePlayer();

            SingleonHolder.INSTANCE.resetRtcEngine();
            SingleonHolder.INSTANCE = null;
            ThunderNative.fini();
			if (BuildConfig.__YY_VIDEO_SUPPORT__) {
            	YYVideoLibMgr.instance().deInit("Thunder");
			}
            mIsInited = false;

        }
    }

    /**
     * SDK version number character string
     *
     * @return sdk version number (non-null)
     */
    public static String getVersion() {
        return ThunderNative.getVersion();
    }

    /**
     * Set a log file path (switch on log-output function)
     *
     * @param filePath Log file path (Null path indicates that the log is closed)
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public static int setLogFilePath(String filePath) {
        return ThunderNative.setLogFilePath(filePath);
    }

    /**
     * Set log callback
     *
     * @param callback Log callback (callback = null indicates that the log is closed)
     * setLogFile is invalid after the log callback is set;
     */
    public static int setLogCallback(IThunderLogCallback callback) {
        return ThunderNative.setLogCallback(callback);
    }

    /**
     * Set a log level
     *
     * @param filter ThunderRtcConstant.LogLevel
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public static int setLogLevel(int filter) {
        ThunderLog.setLogLevel(filter);
        return ThunderNative.setLogLevel(filter);
    }

    /**
     * Set relevant profiles of Thunder
     * Call this function after “initialization”, and reset while performing destroyEngine. It is a non-public interface (not recommended if unnecessary)
     *
     * @param options 以JSON定义的相关配置信息，参数说明如下：
     *                1> 设置视频群组订阅："JoinWithSubscribeGroup":true,
     *                2> 设置视频群组开播："PublishAudioToGroup":true,
     *                3> 设置频道号与子频道号: "setSid":79804098,"setSubsid":79804098
     *                4> 设置自定义开播参数: "VideoPublisherConfig":[{"playType":0,"configList":[{"mode":1,"fps":15,"bitrate":200,"width":320,"height":240,"lowStream":[{"fps":5,"bitrate":50,"width":160,"height":120}]}]}]
     *                   其中lowStream为该档位下的小流参数,不需要可不写lowStream字段
     *                5> 开启开播库buffer处理模式: "enableVideoPublishBufferProcess":true,
     *                6> 开启硬解: "enableHardwareDecode":true,
     *                true:Buffer模式，设置纹理Observer无回调，不使用GL; false:纹理模式，设置纹理Observer有回调，使用GL
     *                7> 设置自定义流名称："CustomStreamName":[{"streamType":0,"streamName":"g_1022_1022_0
     *                "},{"streamType":1,"streamName":"a_1022_1022_0"},{"streamType":2,"streamName":"v_1022_1022_0"}]
	 *                8> 设置私有媒体次要信息: "sendPrivateMediaExtraData":"透传的数据"
     *                9> 开播库视频模式，与5不能同时使用: "setVideoCommonConfigMode":1
     *                0:采集：纹理，预览：纹理，美颜：开启，编码：纹理
     *                1：采集：yuv，预览：Canvas，美颜：关闭，编码：yuv
     *                2：采集：yuv，预览：纹理，美颜：开启，编码：纹理
     * @return  0:成功, 其它错误参见{@link ThunderRtcConstant.ThunderRet}
     */
    public int setParameters(String options) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setParameters argument %s", options);
        if ((null == options) || options.isEmpty()) {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        return ThunderNative.setParameters(options);
    }

    /**
     * Set scene ID
     *
     * @param sceneId Custom scene ID
     */
    public void setSceneId(long sceneId) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setSceneId %d", sceneId);
        ThunderNative.setSceneId(sceneId);
    }

    /**
     * *************This interface has been deprecated, please use setMediaMode and setRoomMode interfaces****************
     *
     * Function 1: Calling this function before joining the channel, to select audio-only channel or the audio/video channel for joining (audio/video channel by default) Function 2: Setting channel profiles;
     *
     * @param config            0 by default: audio/video mode 1: audio/video mode 2: audio-only mode
     * @param roomConfig={@link ThunderRtcConstant.RoomConfig
     *                          THUNDER_ROOMCONFIG_LIVE = live streaming mode (fluent)
     *                          THUNDER_ROOMCONFIG_COMMUNICATION = communication mode (low latency)
     *                          THUNDER_ROOMCONFIG_GAME = game (traffic saved and low latency)}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    @Deprecated
    public int setRoomConfig(int config, int roomConfig) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRoomConfig: config=%d roomConfig:%d", config, roomConfig);
        ThunderNative.setMediaMode(config);
        ThunderNative.setRoomMode(roomConfig);
        return 0;
    }

    /**
     * Set media mode
     * This mode should be called after “initialization” and before “joining room”, and is reset only if destroyEngine is performed
     *
     * @param mode Media mode: audio-only or audio/video {@link ThunderRtcConstant.ThunderRtcProfile
     *                                          THUNDER_PROFILE_DEFAULT = 0; =1 audio/video mode
     *                                          THUNDER_PROFILE_NORMAL = 1; audio/video mode
     *                                          THUNDER_PROFILE_ONLY_AUDIO = 2; audio-only mode}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setMediaMode(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setMediaMode: mode=%d ", mode);
        return ThunderNative.setMediaMode(mode);
    }

    /**
     * Set room mode
     * This function should be called after “initialization”, and is reset only if destroyEngine is performed
     *
     * @param mode Room mode {@link ThunderRtcConstant.RoomConfig
     *                          THUNDER_ROOMCONFIG_LIVE = live streaming mode (fluent)
     *                          THUNDER_ROOMCONFIG_COMMUNICATION = communication mode (low latency)
     *                          THUNDER_ROOMCONFIG_GAME = game (traffic saved and low latency)}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setRoomMode(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRoomMode: mode=%d ", mode);
        return ThunderNative.setRoomMode(mode);
    }

    /**
     * Set user’s area
     * The call takes effect before joinRoom is performed. The users abroad should call the function, whereas the domestic users may not call it
     *
     * @param area Value range {@link ThunderRtcConstant.AreaType}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setArea(int area) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setArea: area=%d", area);
        return ThunderNative.setAreaType(area);
    }

    /**
     * Get connection status
     * The call takes effect before joinRoom is performed.
     *
     * @return status of the current connection, see {@link ThunderRtcConstant.ThunderConnectionStatus}
     */
    public int getConnectionStatus() {
        return ThunderNative.getConnectionStatus();
    }

    /**
     * Open/close WebSDK compatibility
     * Since WebSDK cannot normally decode the frame B, encoding frame B is prohibited after WebSDK compatibility is enabled (which should be called before publishing regardless of whether to join or exit the channel)
     * This function should be called after “initialization” and is reset only if destroyEngine is performed
     *
     * @param enabled Whether the compatibility is enabled (disabled by default)
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int enableWebSdkCompatibility(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableWebSdkCompatibility %b", enabled);
        return ThunderNative.enableWebSdkCompatibility(enabled);
    }

    /**
     * Set whether character string UID is supported
     * Call this function after “initialization” and before performing joinRoom, and reset while performing destroyEngine. It is a non-public interface (not recommended if unnecessary)
     *
     * @param is64bitUid Default value: true
     *                   When the value is true, permutation and combination of characters including [A,Z], [a,z], [0,9], -, _ are supported and the length cannot exceed 64 bytes
     *                    When the value is false, only [0,9] is supported, and the numerical value is not greater than a 32-bit unsigned integer
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setUse64bitUid(boolean is64bitUid) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setUse64bitUid %b", is64bitUid);
        return ThunderNative.setUse64bitUid(is64bitUid);
    }

    /**
     * Join room
     * Users in this room can communicate with each other or engage in group chat. Communication cannot be performed between different appIds
     * Call this appId after “initialization”
     * Call the interface setUse64bitUid(false) if users of  SDK version 2 or earlier versions need unsigned 32-bit uid
     * Succeeded return of function only indicates that the request succeeds, and receiving the onJoinRoomSuccess notification indicates that the user joins a room successfully
     *
     * @param token    See renewToken {@link ThunderEngine##updateToken(byte[])}
     * @param roomName Room ID (unique in AppId), only supports the permutation and combination of characters including [A,Z], [a,z], [0,9], -, and with the length not exceeding 64 bytes
     * @param uid      User ID which should be unique, only supports the permutation and combination of characters including [A,Z], [a,z], [0,9], -, and with the length not exceeding 64 bytes
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */

    public int joinRoom(byte[] token, String roomName, String uid) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "joinRoom: roomName=%s, uid=%s, token=%s",
                roomName, uid, getPrintString(token));
        return ThunderNative.joinRoom(token, roomName, uid);
    }

    /**
     * Leave room
     * Call this function only after successful return of joinRoom
     *
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int leaveRoom() {
        //The unregisterNotificationHandler may result in a failure to receive a channel leaving message
        //unregister notification
        //ThunderAPI.sharedInstance().unregisterNotificationHandler(mHandler);

        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "leaveRoom");
        return ThunderNative.leaveRoom();
    }

    /**
     * Update token
     * Call this function only after “initialization”
     *
     * <br> token format
     * <br> -------------------------------------------------------------------------------------------------
     * <br> | TokenLen(uint16)    | AppId(uint32)        | uid (uint64)          | Timestamp(uint64)(ms)    |
     * <br> -------------------------------------------------------------------------------------------------
     * <br> | ValidTime(uint32)(s)| BizExtInfoLen(uint16)| BizExtInfoData(nBytes)| DigitalSignature(20Bytes)|
     * <br> -------------------------------------------------------------------------------------------------
     * <br> 1. The multi-byte integer uses the network byte order
     * <br> 2. TokenLen: total length of token, including 2 bytes in token and abstract
     * <br> 3. Expiration time = Timestamp+ValidTime*1000, indicating the number of milliseconds of the time interval between UTC time to Unix timestamp
     * <br> 4. BizExtInfoData: Pass-through extension information that may be required by service authentication
     * <br> 5. DigitalSignature: Calculate all data prior to DigitalSignature using the hmac-sha1algorithm, to obtain [TokenLen,BizExtInfoData]. During this process, the secret key is appSecret allocated for applying for appId
     * <br> 6. The whole token is subject to url-safe Base64 encoding
     *
     * @param token The token generated by the business server should be subject to url Base64 encoding
     *              <p>
     *              Monitor notifications including kThunderAPINotification_BizAuthRes and kThunderAPINotification_SdkAuthRes to get authentication results
     *              {@link ThunderNotification#kThunderNotification_BizAuthRes}
     *              {@link ThunderNotification#kThunderNotification_SdkAuthRes}
     *
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int updateToken(byte[] token) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "updateToken: %s ", getPrintString(token));
        return ThunderNative.updateToken(token);
    }

    /**
     * Publish audio
     * Call this function only after “joining room successfully”
     *
     * [This interface has been deprecated] stopLocalAudioStream(false) is recommended;
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    @Deprecated
    public int enableAudioEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableAudioEngine ");
        return ThunderNative.startPublishAudio(true);
    }

    /**
     * Disable audio capture, and stop publishing to channel
     * Call this function only after “joining room successfully”
     *
     * [This interface has been deprecated] stopLocalAudioStream(true) is recommended;
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    @Deprecated
    public int disableAudioEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "disableAudioEngine");
        return ThunderNative.startPublishAudio(false);
    }

    /**
     * Set audio mode
     *
     * @param profile      Audio type {@link ThunderRtcConstant.AudioConfig}
     * @param commutMode   Interactive mode {@link ThunderRtcConstant.CommutMode}
     * @param scenarioMode Scenario mode{@link ThunderRtcConstant.ScenarioMode}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setAudioConfig(int profile,
                              int commutMode,
                              int scenarioMode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setAudioConfig: profile=%d, commutMode=%d, scenarioMode=%d",
                profile, commutMode, scenarioMode);
        return ThunderNative.setAudioConfig(profile, commutMode, scenarioMode);
    }

    /**
     * Enable/Disable remote user voice stereo, make sure to call this method before calling the joinRoom method
     *
     * @param enable
     * @return 0:succeed, other erros see {@link ThunderRtcConstant.ThunderRet}
     */
    public int enableVoicePosition(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableVoicePosition: enable=%b", enable);
        return ThunderNative.enableVoicePosition(enable);
    }

    /**
     * Set whether to amplify
     *
     * @param enabled Whether to set loudspeaker play
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int enableLoudspeaker(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLoudspeaker: %b", enabled);
        return ThunderNative.enableLoudSpeaker(enabled);
    }

    /**
     * Whether it is the loudspeaker status
     *
     * @return true: loudspeaker play, false: non-loudspeaker play
     */
    public boolean isLoudspeakerEnabled() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isLoudspeakerEnabled");
        return ThunderNative.getLoudSpeakerEnabled();
    }

    /**
     * Enable a speaker volume prompt
     * Call this prompt after “initialization” and reset it only if the destroyEngine is performed; after enabling the prompt, you will receive the onPlayVolumeIndication notification when someone speaks in the room
     *
     * @param interval     <=0: disabling the volume prompt function; >0: returning the volume prompt interval (in millisecond) which is more than 200 milliseconds recommended
     * @param moreThanThd From <moreThanThd to >=moreThanThd, immediately perform callback once; <=0 indicates invalidity
     * @param lessThanThd From >=lessThanThd to <lessThanThd, immediately perform callback once; <=0 indicates invalidity
     * @param smooth      Smoothing coefficient (not implemented)
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setAudioVolumeIndication(int interval,
                                        int moreThanThd,
                                        int lessThanThd,
                                        int smooth) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setAudioVolumeIndication: interval=%d," +
                "moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);
        return ThunderNative.setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
    }

    /**
     * Enable callback of captured volume
     *
     * @param interval    <=0: The volume prompt is disabled, >0: Callback interval (in millisecond)
     * @param moreThanThd From <moreThanThd to >=moreThanThd, immediately perform callback once; <=0 indicates invalidity
     * @param lessThanThd From >=lessThanThd to <lessThanThd, immediately perform callback once; <=0 indicates invalidity
     * @param smooth      Not implemented
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int enableCaptureVolumeIndication(int interval,
                                             int moreThanThd,
                                             int lessThanThd,
                                             int smooth) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableCaptureVolumeIndication: interval=%d," +
                "moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);
        return ThunderNative.setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
    }

    /**
     * Save audio data with postfix of .aac.
     * @deprecated since 3.1. use {@link ThunderEngine#startAudioRecord} instead
     * @param fileName  The save path of files must be full path including file name with postfix of .aac. The directory for saving files must be created in advance, and the folder cannot be created by this interface. For example: /sdcard/helloworld.aac
     * @param saverMode =ThunderRtcConstant.AudioSaverMode.
     *                  THUNDER_AUDIO_SAVER_ONLY_CAPTURE = Only save all uplink audio data in the channel The uplink audio data means: anchor’s and accompaniment’s audio data can be saved only if they are set to be uplink data
     *                  THUNDER_AUDIO_SAVER_ONLY_RENDER = Save audio data other than anchor’s audio data in the channel, for example: accompaniment’s and audience terminal’s audio data
     *                  THUNDER_AUDIO_SAVER_BOTH = Save all audio data in the channel
     * @param fileMode  = ThunderRtcConstant.AudioSaverWfMode.
     *                  THUNDER_AUDIO_SAVER_FILE_APPEND = Append to open one text file, and write data at the end of file
     *                  THUNDER_AUDIO_SAVER_FILE_OVERRIDE = Open one text file, with the contents overridden by written-in data
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startAudioSaver: fileName=%s, " +
                "saverMode=%d, fileMode=%d", getPrintString(fileName), saverMode, fileMode);
        if (fileName.isEmpty()) {
            return false;
        }
        return ThunderNative.startAudioSaver(fileName, saverMode, fileMode);
    }

    /**
     * Stop saving audio data as a file in acc format
     * @deprecated since 3.1. use {@link ThunderEngine#stopAudioRecord} instead
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public boolean stopAudioSaver() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopAudioSaver");
        return ThunderNative.stopAudioSaver();
    }

    /**
     * @brief Save audio data with postfix of .aac or .wav
     *
     * @param fileName  The save path of files must be full path including file name with postfix of .aac or .wav. The
     *                  directory for saving files must be created in advance, and the folder cannot be created by this interface. For example: /sdcard/helloworld.aac
     * @param saverMode =ThunderRtcConstant.AudioSaverMode.
     *                  THUNDER_AUDIO_SAVER_ONLY_CAPTURE = Only save all uplink audio data in the channel. The uplink audio data means: anchor’s and accompaniment’s audio data can be saved only if they are set to be uplink data
     *                  THUNDER_AUDIO_SAVER_ONLY_RENDER = Only save all downlink audio in the channel, the downstream audio does not include the sound of local accompaniment
     *                  THUNDER_AUDIO_SAVER_BOTH = Save all uplink and downlink audio data in the channel.
     * @param sampleRate  = 16000, 32000(default), 44100, 48000
     * @param quality  = ThunderRtcConstant.AudioSaverQuality
     *                   THUNDER_AUDIO_SAVER_QUALITY_LOW = 0; // bitRate: 20kbps
     *                   THUNDER_AUDIO_SAVER_QUALITY_MEDIUM = 1; // bitRate: 32kbps
     *                   THUNDER_AUDIO_SAVER_QUALITY_HIGH = 2; // bitRate: 52kbps

     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark (1) Call this interface after "joining room successfully". If you are still recording when you call leaveChannel, the recording will stop automatically
     *         (2) To ensure the recording effect, when sampleRate is set to 44.1 kHz or 48 kHz, it is recommended to set quality to THUNDER_AUDIO_SAVER_QUALITY_MEDIUM or THUNDER_AUDIO_SAVER_QUALITY_HIGH
     */
    public int startAudioRecord(String fileName, int saverMode, int sampleRate, int quality) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startAudioRecord: fileName=%s, " +
                "saverMode=%d, sampleRate=%d, quality=%d", getPrintString(fileName), saverMode, sampleRate, quality);
        if (fileName.isEmpty()) {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        return ThunderNative.startAudioRecord(fileName, saverMode, sampleRate, quality);
    }

    /**
     * @brief Stop saving audio data as a file in acc or wav format
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark: This method stops recording. This interface needs to be called before leaveRoom, otherwise it will stop automatically when leaveRoom is called.
     */
    public int stopAudioRecord() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopAudioRecord");
        return ThunderNative.stopAudioRecord();
    }

    /**
     * Set different sound effect modes
     *
     * @param mode =ThunderRtcConstant.SoundEffectMode.
     *             THUNDER_SOUND_EFFECT_MODE_NONE               = NONE mode
     *             THUNDER_SOUND_EFFECT_MODE_VALLEY             = VALLEY mode
     *             THUNDER_SOUND_EFFECT_MODE_RANDB              = R&B mode
     *             THUNDER_SOUND_EFFECT_MODE_KTV                = KTV mode
     *             THUNDER_SOUND_EFFECT_MODE_CHARMING           = CHARMING mode
     *             THUNDER_SOUND_EFFECT_MODE_POP                = POP mode
     *             THUNDER_SOUND_EFFECT_MODE_HIPHOP             = HIPHOP mode
     *             THUNDER_SOUND_EFFECT_MODE_ROCK               = ROCK mode
     *             THUNDER_SOUND_EFFECT_MODE_CONCERT            = CONCERT mode
     *             THUNDER_SOUND_EFFECT_MODE_STUDIO             = STUDIO mode
     */
    public void setSoundEffect(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderEngine::setSoundEffect %d", mode);
        ThunderNative.setSoundEffect(mode);
    }

    /**
     * Set voice change mode
     *
     * @param mode =ThunderRtcConstant.VoiceChangerMode.
     *             THUNDER_VOICE_CHANGER_NONE                = None mode
     *             THUNDER_VOICE_CHANGER_ETHEREAL            = Ethereal
     *             THUNDER_VOICE_CHANGER_THRILLER            = Thriller
     *             THUNDER_VOICE_CHANGER_LUBAN               = Luban
     *             THUNDER_VOICE_CHANGER_LORIE               = Lorie
     *             THUNDER_VOICE_CHANGER_UNCLE               = Uncle
     *             THUNDER_VOICE_CHANGER_DIEFAT              = Die fat
     *             THUNDER_VOICE_CHANGER_BADBOY              = Bad boy
     *             THUNDER_VOICE_CHANGER_WRACRAFT            = Wracraft
     *             THUNDER_VOICE_CHANGER_HEAVYMETAL          = Heavy metal
     *             THUNDER_VOICE_CHANGER_COLD                = Cold
     *             THUNDER_VOICE_CHANGER_HEAVYMECHINERY      = Heavy machinery
     *             THUNDER_VOICE_CHANGER_TRAPPEDBEAST        = Trapped beast
     *             THUNDER_VOICE_CHANGER_POWERCURRENT        = Power current
     */
    public void setVoiceChanger(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderEngine::setVoiceChanger %d", mode);
        ThunderNative.setVoiceChanger(mode);
    }

    /**
     * Close/open local audio (including capture code and uplink of audio)
     * Call this function after “joining room successfully”
     *
     * @param stop true: Close local audio; false: open local audio
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int stopLocalAudioStream(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopLocalAudioStream: %b", stop);
        return ThunderNative.startPublishAudio(!stop);
    }

    /**
     * @brief Enable/disable local audio capture
     * @param enable true: enable local capture, false: disable local capture
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark (1) Call this interface after "initialization". Uninstalling the SDK will automatically close the audio capture.
               (2) Use enableLocalAudioCapture, enableLocalAudioEncoder, enableLocalAudioPublisher combined APIs to publish audio and stopLocalAudioStream to publish audio is equivalent.
               (3) The enableLocalAudioCapture, enableLocalAudioEncoder, enableLocalAudioPublisher combination APIs provide more advanced audio publish methods. If you just simply start publishing, use the stopLocalAudioStream method.
               (4) If you have used the enableLocalAudioCapture, enableLocalAudioEncoder, enableLocalAudioPublisher combination APIs for publishing, it is recommended not to use the stopLocalAudioStream API, so as to avoid doubts caused by function coverage, and vice versa.
               (5) If setAudioSourceType is called to set the publishing mode to THUNDER_PUBLISH_MODE_NONE, the call to this API fails.
               (6) If you call setCustomAudioSource to enable external push streaming, the call to this API fails.
     */
    public int enableLocalAudioCapture(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLocalAudioCapture: %b", enable);
        return ThunderNative.startAudioCapture(enable);
    }

    /**
     * @brief Enable/disable local audio encoder
     * @param enable true: enable local audio encoder, false: disable local audio encoder
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark (1) Call this interface after "initialization". Uninstalling the SDK will automatically close the audio encoder
               (2) Use enableLocalAudioCapture, enableLocalAudioEncoder, enableLocalAudioPublisher combined APIs to publish audio and stopLocalAudioStream to publish audio is equivalent.
               (3) The enableLocalAudioCapture, enableLocalAudioEncoder, enableLocalAudioPublisher combination APIs provide more advanced audio publish methods. If you just simply start publishing, use the stopLocalAudioStream method.
               (4) If you have used the enableLocalAudioCapture, enableLocalAudioEncoder, enableLocalAudioPublisher combination APIs for publishing, it is recommended not to use the stopLocalAudioStream API, so as to avoid doubts caused by function coverage, and vice versa.
               (5) If setAudioSourceType is called to set the publishing mode to THUNDER_PUBLISH_MODE_NONE, the call to this API fails.
               (6) If you call setCustomAudioSource to enable external push streaming, the call to this API fails.
     */
    public int enableLocalAudioEncoder(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLocalAudioEncoder: %b", enable);
        return ThunderNative.startAudioEncode(enable);
    }

    /**
     * @brief Enable/disable local audio publisher
     * @param enable true: enable local audio publisher, false: disable local audio publisher
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark (1) Call this interface after joining room and receiving onJoinRoomSuccess callback. Leaving the room will automatically disable audio publisher
               (2) Use enableLocalAudioCapture, enableLocalAudioEncoder, enableLocalAudioPublisher combined APIs to publish audio and stopLocalAudioStream to publish audio is equivalent.
               (3) The enableLocalAudioCapture, enableLocalAudioEncoder, enableLocalAudioPublisher combination APIs provide more advanced audio publish methods. If you just simply start publishing, use the stopLocalAudioStream method.
               (4) If you have used the enableLocalAudioCapture, enableLocalAudioEncoder, enableLocalAudioPublisher combination APIs for publishing, it is recommended not to use the stopLocalAudioStream API, so as to avoid doubts caused by function coverage, and vice versa.
               (5) It is recommended to use setCustomAudioSource and this interface to start external push streaming.
     */
    public int enableLocalAudioPublisher(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLocalAudioPublisher: %b", enable);
        return ThunderNative.startPushAudioStream(enable);
    }

    /**
     * @brief Whether the local audio is enabled
     * @return true: enabled; false: disabled
     * @remark This API should be called after initialization
     */
    public boolean isAudioCaptureEnabled() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isAudioCaptureEnabled");
        int iRet = ThunderNative.isAudioCaptureEnabled();
        return iRet == 1 ? true : false;
    }

    /**
     * @brief Whether the local audio encoder is enabled
     * @return true: enabled; false: disabled
     * @remark This API should be called after initialization
     */
    public boolean isAudioEncoderEnabled() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isAudioEncoderEnabled");
        int iRet = ThunderNative.isAudioEncoderEnabled();
        return iRet == 1 ? true : false;
    }

    /**
     * @brief Whether the local audio publisher is enabled
     * @return true: enabled; false: disabled
     * @remark This API should be called after initialization
     */
    public boolean isAudioPublisherEnabled() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isAudioPublisherEnabled");
        int iRet = ThunderNative.isAudioPublisherEnabled();
        return iRet == 1 ? true : false;
    }

    /**
     * Stop/receive all audio data (false by default)
     * Call this function after “initialization”, and reset it only if the destroyEngine is performed
     * Judge whether to receive or prohibit a remote user; judge whether the value set by stopRemoteAudioStream exists firstly; if not, use the value set by this function
     *
     * @param stop true: stop all remote audios false: receive all remote audios
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int stopAllRemoteAudioStreams(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopAllRemoteAudioStreams: %b", stop);
        return ThunderNative.stopAllRemoteStreams(false, stop);
    }

    /**
     * Stop/receive specified audio data
     * Call this function after “initialization”, and reset it only if the destroyEngine is performed
     * Judge whether to receive or prohibit a remote user; judge whether the value set by this function exits firstly; if not, use the value set by stopAllRemoteAudioStreams
     *
     * @param uid User ID
     * @param stop true: stop user audios false: receive user audios
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int stopRemoteAudioStream(String uid, boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopRemoteAudioStream: uid=%s, %b", uid, stop);
        return ThunderNative.stopRemoteAudioStream(uid, stop);
    }

    /**
     * This method is used to set the volume of amplifier (loudspeaker). 
     *
     * @param volume Volume value in [0-400]
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setLoudSpeakerVolume(int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setSpeakerphoneVolume: %d", volume);
        return ThunderNative.setSpeakerVolume(volume);
    }

    /**
     * Set microphone volume
     *
     * @param volume Volume value in [0-400]
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setMicVolume(int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setMicVolume: %d", volume);
        return ThunderNative.setMicVolume(volume);
    }

    /**
     * Set the playback volume of remote user
     * @param uid User ID
     * @param volume Volume value in [0-400]
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setRemoteAudioStreamsVolume(String uid, int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteAudioStreamsVolume: uid=%s, volume=%d",
                getPrintString(uid), volume);
        return ThunderNative.setRemoteAudioStreamVolume(uid, volume);
    }

    /**
     * Set spatial azimuth and volume of remote user’s voices
     *
     * @param uid     Remote uid
     * @param azimuth Set the azimuth where the remote user’s voices appear, with the value range of [-90, 90], in which 0: voices appearing right ahead (by default), -90: voices appearing at the left, and 90: voices appearing at the right
     * @param gain    Set the volume of remote user’s voices, with the value range of [0, 100], in which the default value is 100.0 and indicates the original volume of this user. The smaller the value, the lower the volume
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setRemoteUidVoicePosition(String uid, int azimuth, int gain) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteUidVoicePosition: uid=%s, azimuth=%d, gain=%d",
                getPrintString(uid), azimuth, gain);
        return ThunderNative.setRemoteUidVoicePosition(uid, azimuth, gain);
    }

    /**
     * Create a file play object
     *
     * @return Player object
     */
    public ThunderAudioFilePlayer createAudioFilePlayer() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "createAudioFilePlayer");

        ThunderAudioFilePlayer audioFilePlayer = new ThunderAudioFilePlayer();
        mAudioFilePlayerSet.add(audioFilePlayer);
        return audioFilePlayer;
    }

    /**
     * Destroy a file play object
     *
     * @param audioFilePlayer File play object
     */
    public void destroyAudioFilePlayer(ThunderAudioFilePlayer audioFilePlayer) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "destroyAudioFilePlayer: %s", getPrintString(audioFilePlayer));

        if (audioFilePlayer == null) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "destroyAudioFilePlayer null");
            return;
        }
        audioFilePlayer.destroyAudioFilePlayer();
        mAudioFilePlayerSet.remove(audioFilePlayer);
    }

    /**
     * Enable/disable a local equalizer
     *
     * @param enabled true: enable false: disable
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setEnableEqualizer(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setEnableEqualizer %b", enabled);
        return ThunderNative.enableEqualizer(enabled);
    }

    /**
     * Set equalizer parameters
     *
     * @param gains -12 <= gains[i] <= 12, in which the range of i is 0<= i <=10
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setEqGains(final int[] gains) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setEqGains");
        if (gains == null) {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }

        return ThunderNative.setGqGains(gains);
    }

    /**
     * Enable/disable reverb of local sound effect
     *
     * @param enabled true: enable false: disable
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setEnableReverb(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setEnableReverb %b", enabled);
        return ThunderNative.enableReverb(enabled);
    }

    /**
     * Set reverb parameters
     *
     * @param param {@link ThunderRtcConstant.ReverbExParameter}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setReverbExParameter(ThunderRtcConstant.ReverbExParameter param) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setReverbExParameter");
        if (param == null)
        {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        return ThunderNative.setReverbExParameter(
                param.mRoomSize,
                param.mPreDelay,
                param.mReverberance,
                param.mHfDamping,
                param.mToneLow,
                param.mToneHigh,
                param.mWetGain,
                param.mDryGain,
                param.mStereoWidth);
    }

    /**
     * @deprecated use {@link ThunderEngine#setEnableLimiter} instead
     * Enable/disable a compressor
     *
     * @param enabled true: enable false: disable
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setEnableCompressor(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setEnableCompressor %b", enabled);
        return ThunderNative.enableCompressor(enabled);
    }

    /**
     * @deprecated use {@link ThunderEngine#setLimiterParam} instead
     * Set compressor parameters
     *
     * @param param Compressor parameters {@link ThunderRtcConstant.CompressorParam}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setCompressorParam(ThunderRtcConstant.CompressorParam param) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setCompressorParam");
        if (param == null) {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        return ThunderNative.setCompressorParam(
                param.mThreshold,
                param.mMakeupGain,
                param.mRatio,
                param.mKnee,
                param.mReleaseTime,
                param.mAttackTime);
    }

    /**
     * Enable/disable a limiter
     *
     * @param enabled true: enable false: disable
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setEnableLimiter(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setEnableLimiter %b", enabled);
        return ThunderNative.enableLimiter(enabled);
    }

    /**
     * Set limiter parameters
     *
     * @param param Limiter parameters{@link ThunderRtcConstant.LimterParam}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setLimiterParam(ThunderRtcConstant.LimterParam param) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setLimiterParam");
        if (param == null) {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        return ThunderNative.setLimiterParameter(
                param.fCeiling,
                param.fThreshold,
                param.fPreGain,
                param.fRelease,
                param.fAttack,
                param.fLookahead,
                param.fLookaheadRatio,
                param.fRMS,
                param.fStLink);
    }
	
    /**
     * @brief 设置语音音调
     * @param pitch 语音音调，参数范围：[-12, 12]；默认值为0
     * @return 0:成功, 其它错误参见enum ThunderRet
     * @remark (1) 需要"初始化"后调用，仅在destroyEngine时重置
     *         (2) pitch取值越小，则音调越低
     */
    public int setVoicePitch(float pitch){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setVoicePitch %f", pitch);
        return ThunderNative.setVoicePitch(pitch);
    }
	
    /**
     * 设置外部音频处理器
     * @deprecated 建议使用 registerAudioFrameObserver
     * @param eap, eap是个C 函数指针数组，长度为6，每个函数的类型为：
     * @deprecated use {@link ThunderEngine#registerAudioFrameObserver} instead
     * Set an external audio processor
     *
     * @param eap, eap is a C function pointer array with the length of 6 bytes. The type of each function is described as below: 
     *             typedef void (*OnCaptureStartFun)(void*obj);
     *             typedef void (*OnCaptureDataFun)(void*obj, void* pData, uint32_t len, uint32_t sampleRate, uint32_t channelCount, uint32_t bitPerSample);
     *             typedef void (*OnCaptureStopFun)(void*obj);
     *             typedef void (*OnRenderStartFun)(void*obj);
     *             typedef void (*OnRenderDataFun)(void*obj, void* pData, uint32_t len, uint32_t sampleRate, uint32_t channelCount, uint32_t bitPerSample);
     *             typedef void (*OnRenderStopFun)(void*obj);
     */
    public void setExternalAudioProcessor(long eap) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setExternalAudioProcessor");
        ThunderNative.setExternalAudioProcessor(eap);
    }

    /**
     * Enable/disable callback on spectrum data of audio play
     * @param enable true: enable false: disable. You will receive a callback notification in case of enabling the callback
     * @see ThunderEventHandler#onAudioPlaySpectrumData
     */
    public void enableAudioPlaySpectrum(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableAudioPlaySpectrum %b", enable);
        ThunderNative.enableAudioPlaySpectrum(enable);
    }

    /**
     * Set callback information of spectrum data of audio play
     *
     * @param spectrumLen      Length of spectrum data in [12 - 256] (256 by default)
     * @param notifyIntervalMS Interval of spectrum callback, which should be the multiples of 10 and is 30MS by default
     */
    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setAudioPlaySpectrumInfo %d, %d", spectrumLen, notifyIntervalMS);
        ThunderNative.setAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS);
    }

    /**
     * Send a service-customized broadcast message of service
     *
     * @param msgData Custom broadcast message of service
     *                <br> Conditions for calling this interface: 
     *                1. The user has joined the channel
     *                2. Call after microphone connection succeeds (the message cannot be sent in audience-only and authentication failure conditions)
     *                3. The calling frequency of this interface should be no more than 2 times per second, and the size of msgData should be no more than 200Byte
     *                <br> All msg should be discarded if the above conditions are not met
     *                <br> Receive other pass-through messages through monitoring onRecvUserAppMsgData in ThunderEventHandler
     *                <br> Get the reason of sending failure of this msg through monitoring onSendAppMsgDataFailedStatus in ThunderEventHandler
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int sendUserAppMsgData(byte[] msgData) {
        if (msgData == null || msgData.length == 0) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine,"sendUserAppMsgData: msgData is null or length is 0");
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "sendUserAppMsgData %s", new String(msgData));
        return ThunderNative.sendUserAppMsgData(msgData);
    }

    /**
     * Send media extra information (in the case of audio/video publishing)
     * When some videos are uplinked, only use the video channel to send the information; otherwise, use the audio channel
     *
     *                <br> Conditions for calling this interface: 
     *                1. The interface can be called only if the sender joins the room and audio publishing succeeds
     *                2. Audio publishing only: The fastest frequency for calling this interface is 100ms once, and the media extra information does not exceed 200 bytes
     *                3. Video publishing: The calling frequency cannot exceed the frame rate, and the media extra information does not exceed 2,048 bytes. 
     *                    For example: The default frame rate of stream publishing is 15fps, that is, the calling frequency cannot exceed 1000/15=66.7 ms/times
     *                4. There may be packet loss situations
     *                5. SDK should perform callback of media data at the point-in-time when the corresponding frame is played
     *                <br> Receive media extra information from other users through monitoring onRecvMediaExtraInfo in IThunderMediaExtraInfoCallback
     *                <br> Get the reason of sending failure of message through monitoring onSendMediaExtraInfoFailedStatus in ThunderEventHandler
     *
     * @param data Media extra information
     * @param dataLen Length of media extra information
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int sendMediaExtraInfo(java.nio.ByteBuffer data, int dataLen) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "sendMediaExtraInfo %d", dataLen);
        if (data == null) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "sendMediaExtraInfo: data is null");
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        if (data.remaining() < dataLen) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "sendMediaExtraInfo: dataLen large than data.remaining()");
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        byte[] extraInfo = new byte[dataLen];
        data.get(extraInfo, 0, extraInfo.length);
        return ThunderNative.sendMediaExtraInfo(extraInfo);
    }

    /**
     *Set callback monitoring of media extra information
     *
     * @param callback An object instance that has implemented the {@link IThunderMediaExtraInfoCallback} interface
     * When extra information is not required, call setMediaExtraInfoCallback(null) to remove the callback monitoring
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setMediaExtraInfoCallback(IThunderMediaExtraInfoCallback callback) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setMediaExtraInfoCallback");
        mThunderMediaExtraInfoCallback = callback;
        ThunderNative.makeBehaviorEvent("sdk_api","setMediaExtraInfoCallback",
                callback == null ? "null" : "not null",2);
        return 0;
    }

    /**
     * Enable video mixing carrying media extra information, for example: layout information carried in video-mixing videos
     * After enabling, IThunderMediaExtraInfoCallback##onRecvMixVideoInfo callback can be received when this video mixing stream is played on the play terminal
     * @param enable true: enabled false: disabled (disabled by default)
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int enableMixVideoExtraInfo(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableMixVideoExtraInfo %b", enable);
        return ThunderNative.enableMixVideoExtraInfo(enable);
    }
    
    /**
     * Synchronize the play progress of external accompaniment video for video mixing synchronization. Only one of audio accompaniment and video accompaniment is supported.
     * @param currentMs Current play progress
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int syncMediaPlayingProgress(int currentMs)
    {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "syncMediaPlayingProgress %d", currentMs);
        return (int) ThunderNative.sendAudioFilePlayerInfo(0, currentMs, 0);
    }

    /**
     * Enable/disable callback of audio play data
     *
     * @param enablePlay true: enabled false: played
     */
    public void enableAudioDataIndication(boolean enablePlay) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableAudioDataIndication %b", enablePlay);
        ThunderNative.enableAudioDataIndication(enablePlay);
    }

    /**
     * @deprecated use {@link ThunderEngine#registerAudioFrameObserver} instead
     * Enable/disable callback of captured audio data
     *
     * @param enable     Enable callback of captured data
     * @param sampleRate Set the sampling rate of data for callback to be in a range of [-1,8000,16000,44100,48000]
     * @param channel    Set the number of audio tracks of data for callback to be in a range of [-1,1,2]
     *                   <br> The data for callback is original data not resampled, provided that one of parameters such as sampleRate and channel is -1
     * Use the following interface for callback after enabling
     * @see ThunderEventHandler#onAudioCapturePcmData(byte[], int, int, int)
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableCapturePcmDataCallBack %b , %d, %d", enable, sampleRate, channel);
        ThunderNative.enableCapturePcmDataCallBack(enable, sampleRate, channel);
    }

    /**
     * @deprecated use {@link ThunderEngine#registerAudioFrameObserver} instead
     * Enable/disable callback of rendered audio data
     *
     * @param enable     Enable callback of rendered audio data
     * @param sampleRate Set the sampling rate of data for callback to be in a range of [-1,8000,16000,44100,48000]
     * @param channel    Set the number of audio tracks of data for callback to be in a range of [-1,1,2]
     *                   <br> The data for callback is original data not resampled, provided that one of parameters such as sampleRate and channel is -1
     * Use the following interface for callback after enabling
     * @see ThunderEventHandler#onAudioRenderPcmData(byte[], int, long, int, int)
     * @return true: succeeded false: failed
     */
    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableRenderPcmDataCallBack %b , %d, %d", enable, sampleRate, channel);
        return ThunderNative.enableRenderPcmDataCallBack(enable, sampleRate, channel);

    }

    /**
     * Set an audio publishing mode
     *
     * @param sourceType {@link ThunderRtcConstant.SourceType }
     *                   THUNDER_PUBLISH_MODE_MIC   = 0; // Microphone
     *                   THUNDER_PUBLISH_MODE_FILE  = 1; // File
     *                   THUNDER_PUBLISH_MODE_MIX   = 2; // File + Microphone
     *                   THUNDER_PUBLISH_MODE_NONE  = 10, // Stop all uplinks of audio data
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setAudioSourceType(int sourceType) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setAudioSourceType: mode %d", sourceType);
        return ThunderNative.setAudioPublishMode(sourceType);
    }

    /**
     * @brief 调用这个接口，sdk会对支持硬件耳返的机型进行适配
     * @param enable：false: sdk不启动机型适配； true：sdk启动机型适配
     * @return 0: 成功，其它参考{@link ThunderRtcConstant.ThunderRet}
     * @remark (1)需要"初始化"后，进频道前调用，设置为true，sdk对支持系统耳返的机型做音频采集播放api的适配
     *         (2)该接口主要是为了适配用系统耳返用，如果没有使用系统耳返，建议不需要调用此接口
     */
    public int adaptToSystemKaraoke(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "adaptToSystemKaraoke: %b", enable);
        return ThunderNative.adaptToSystemKaraoke(enable);
    }

    /**
     * @brief Enable/disable an in-ear monitor
     *
     * @param enable true: enabled, false: disabled (disabled by default)
     * @return 0: succeeded. For other errors, see{@link ThunderRtcConstant.ThunderRet}
     */
    public int setEnableInEarMonitor(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setEnableInEarMonitor: %b", enable);
        return ThunderNative.enableInEarMonitor(enable);
    }

    /**
     * @brief set in-ear monitor volume
     *
     * @param volume ranges [0~100]，default 100
     * @return 0: succeeded. For other errors, see{@link ThunderRtcConstant.ThunderRet}
     */
    public int setEarMonitoringVolume(int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setEarMonitoringVolume: %d", volume);
        return ThunderNative.setEarMonitoringVolume(volume);
    }

    /**
     @brief Enable a video module
     @deprecated [This interface has been deprecated] The video module is available by default in the THUNDER_PROFILE_NORMAL mode
     @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    @Deprecated
    public int enableVideoEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableVideoEngine ");
        // This interface cannot implement this function
        return 0;
    }

    /**
     @brief Disable a video module
     @deprecated [This interface has been deprecated] If the video module is not required, set setMediaMode(THUNDER_PROFILE_ONLY_AUDIO)
     @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    @Deprecated
    public int disableVideoEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "disableVideoEngine ");
        // This interface cannot implement this function
        return 0;
    }

    /**
     * Get video publishing parameters from Argo on the basis of parameters;
     * The video takes effect in preview after being previewed;
     * The publishing parameters are updated after the video has been published; the effect generated by parameter changes can be shown in local preview and remote subscription;
     * Call this interface after “initialization”
     * @param yyVideoConfig Specific parameter configuration
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setVideoEncoderConfig(ThunderVideoEncoderConfiguration yyVideoConfig) {
        if (yyVideoConfig == null) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setVideoEncoderConfig null params");
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setVideoEncoderConfig, playType %d, publishMode %d",
                yyVideoConfig.playType, yyVideoConfig.publishMode);
        return ThunderNative.setVideoEncoderConfig(yyVideoConfig);
    }

    /**
     * Set local view
     * (1)The interface shall be called after initialization.
     * (2)The SDK will render the anchor's video to the view when startVideoPreview.
     * (3)If the user destroys the view, you need to call this API again to set "view" to "null" to unbind SDK and view.
     * Otherwise, when startVideoPreview is called again, it will access the wild pointer of the view and cause a crash.
     * @param local Specific settings for view rendering
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setLocalVideoCanvas(ThunderVideoCanvas local) {
        if (local == null) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                    "setLocalVideoCanvas null canvas");
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
          "setLocalVideoCanvas view:%s, renderMode:%d, uid:%s, seatIndex:%d",
          getPrintString(local.mView),
          local.mRenderMode,
          local.mUid,
          local.mSeatIndex);
        return ThunderNative.setLocalVideoCanvas(local.mView, local.mRenderMode);
    }

    /**
     * @deprecated 该接口已无需调用
     * Set the type of remote user view in which multi-person microphone connection is used (ordinary audience view by default)
     *
     * @param remotePlayType {@link ThunderRtcConstant.ThunderRtcRemotePlayType}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setRemotePlayType(int remotePlayType) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemotePlayType %d", remotePlayType);
        return 0;
    }

    /**
     * Set a rendered view of remote video
     * Subscription is also allowed without this window;
     * Set this window to show pictures of streams of corresponding uid in remote subscription;
     * (1)Call this interface after “initialization”
     * (2)The SDK automatically subscribes to the audio and video streams in the channel. After setting the remote anchor
     * uid and view, the SDK will save the binding relationship between uid and view and render the video to the view.
     * (3)If the user destroys the view, you need to call this API to set "view" to "null" to unbind SDK and view.
     * Otherwise, if the remote host re-publishs, the SDK will access the wild pointer of the view and cause a crash. 
     * when it subscribes automatically.
     * @param remote Specific view settings
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setRemoteVideoCanvas(ThunderVideoCanvas remote) {
        if (remote == null) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteVideoCanvas null canvas");
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
          "setRemoteVideoCanvas view:%s, renderMode:%d, uid:%s, mSeatIndex:%d",
          getPrintString(remote.mView),
          remote.mRenderMode,
          remote.mUid,
          remote.mSeatIndex);
        return ThunderNative.setRemoteVideoCanvas(remote.mView, remote.mRenderMode, remote.mUid, remote.mSeatIndex);
    }

    /**
     * Set a display mode of local view
     * Call this interface after “initialization”
     *
     * @param mode Rendering display mode {@link ThunderRtcConstant.ThunderVideoRenderMode}
     *                        THUNDER_RENDER_MODE_FILL(0): Fully fill the window. If the proportion is not fit, stretch to fully fill the window;
     *                        THUNDER_RENDER_MODE_ASPECT_FIT(1): Adapt to the window. If the proportion is not fit, black edge will be left;
     *                        THUNDER_RENDER_MODE_CLIP_TO_BOUNDS(2): Fully fill the window. If the ratio is not fitted to the window, clip the bounds;
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setLocalCanvasScaleMode(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setLocalCanvasScaleMode mode: %d", mode);
        return ThunderNative.setLocalVideoCanvasMode(mode);
    }

    /**
     * Set a display mode of remote view
     * Call this interface after “initialization”
     * @deprecated [This interface has been deprecated] setRemoteCanvasMode is recommended;
     * @param mode Rendering display mode {@link ThunderRtcConstant.ThunderVideoRenderMode}
     *                        THUNDER_RENDER_MODE_FILL(0): Fully fill the window. If the proportion is not fit, stretch to fully fill the window ;
     *                        THUNDER_RENDER_MODE_ASPECT_FIT(1): Adapt to the window. If the proportion is not fit, black edge will be left;
     *                        THUNDER_RENDER_MODE_CLIP_TO_BOUNDS(2): Fully fill the window. If the ratio is not fitted to the window, clip the bounds;
     *                        THUNDER_RENDER_MODE_ORIGINAL(3): Original render mode (only for screen capture), if window is larger than image, the image will not be scaled
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setRemoteCanvasScaleMode(String uid, int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteCanvasScaleMode uid: %s, mode: %d", uid, mode);
        return ThunderNative.setRemoteVideoCanvasMode(uid, mode, ThunderRtcConstant.ThunderRemoteMirrorMode.THUNDER_REMOTE_MIRROR_MODE_DISABLED);
    }

    /**
     * @brief Set a display mode of remote view
     * @param uid user id
     * @param renderMode Rendering display mode {@link ThunderRtcConstant.ThunderVideoRenderMode}
     *                        THUNDER_RENDER_MODE_FILL(0): Fully fill the window. If the proportion is not fit, stretch to fully fill the window ;
     *                        THUNDER_RENDER_MODE_ASPECT_FIT(1): Adapt to the window. If the proportion is not fit, black edge will be left;
     *                        THUNDER_RENDER_MODE_CLIP_TO_BOUNDS(2): Fully fill the window. If the ratio is not fitted to the window, clip the bounds;
     *                        THUNDER_RENDER_MODE_ORIGINAL(3): Original render mode (only for screen capture), if window is larger than image, the image will not be scaled
     * @param mirrorMode For mirror mode, see {@link ThunderRtcConstant.ThunderRemoteMirrorMode}
     *                        THUNDER_REMOTE_MIRROR_MODE_DISABLED(0): The remote video is not mirrored (default);
     *                        THUNDER_REMOTE_MIRROR_MODE_ENABLED(1): The remote video is mirrored
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark Call this interface after “initialization”
     */
    public int setRemoteCanvasMode(String uid, int renderMode, int mirrorMode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteCanvasMode uid: %s, renderMode: %d, mirrorMode: %d", uid, renderMode, mirrorMode);
        return ThunderNative.setRemoteVideoCanvasMode(uid, renderMode, mirrorMode);
    }

    /**
     * Enable video preview of local camera
     * Call this interface after “initialization”
     *
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int startVideoPreview() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startVideoPreview");
        return ThunderNative.startPreview(true);
    }

    /**
     * Disable video preview of local camera
     * Call this interface after “initialization”
     *
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int stopVideoPreview() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopVideoPreview");
        return ThunderNative.startPreview(false);
    }

    /**
     * Enable video preview of local camera
     * @return  0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark The interface shall be called after initialization.
     */
    public int startLocalVideoPreview() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startLocalVideoPreview");
        return ThunderNative.startLocalVideoPreview(true);
    }

    /**
     * Disable video preview of local camera
     * @return  0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark The interface shall be called after initialization.
     */
    public int stopLocalVideoPreview() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopLocalVideoPreview");
        return ThunderNative.startLocalVideoPreview(false);
    }

    /**
     * Enable/disable local video capture
     * Call this interface after “initialization”
     *
     * @param enable true: enable local capture, false: disable local capture
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int enableLocalVideoCapture(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLocalVideoCapture %b", enable);
        return ThunderNative.startVideoCapture(enable);
    }

    /**
     * Enable/disable local video sending
     * Call this function after “joining room successfully”
     *
     * @param stop true : disable local video sending, false : enable local video sending
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int stopLocalVideoStream(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,"stopLocalVideoStream: %b", stop);
        int ret = 0;
        if (stop) {
            ret = ThunderNative.startVideoEncode(false);
            ret |= ThunderNative.startPushVideoStream(false);
            return ret;
        } else {
            ret = ThunderNative.startVideoEncode(true); // Encode
            if (ret != 0) {
                return ret;
            }
            ret = ThunderNative.startPushVideoStream(true); // Stream publishing
            if (ret != 0) {
                ThunderNative.startVideoEncode(false);
            }
            return ret;
        }
    }

    /**
     * Stop/receive specified remote videos
     * Call this method after “initialization”, and reset it only if the destroyEngine is performed
     * Judge whether to receive or prohibit a remote user; judge whether the value set by this function exits firstly; if not, use the value set by stopAllRemoteVideoStreams
     *
     * @param uid User ID
     * @param stop true: prohibit remote video of specified user, false: receive  remote video of specified user
     * @return 0: succeeded. For other errors, see enum ThunderRet
     */
    public int stopRemoteVideoStream(String uid, boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,"stopRemoteVideoStream Uid: %s, stop: %b", uid, stop);
        return ThunderNative.stopRemoteVideoStream(uid, stop);
    }

    /**
     * Stop/receive all remote videos
     * Call this method after “initialization”, and reset it only if the destroyEngine is performed
     * Judge whether to receive or prohibit a remote user; judge whether the value set by stopRemoteVideoStream exists firstly; if not, use the value set by this function
     *
     * @param stop true: prohibit all remote video streams, false: receive all remote video streams (false by default)
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int stopAllRemoteVideoStreams(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopAllRemoteVideoStreams  stop: %b", stop);
        return ThunderNative.stopAllRemoteStreams(true, stop);
    }

    /**
     * @brief 开/关视频双流模式
     * @param enabled 指定双流或者单流模式 YES:双流模式 NO:单流模式(默认)
     * @return 0:成功,其它错误参见{@link ThunderRtcConstant.ThunderRet}
     * @remark (1) 在"初始化"后，且视频开播前调用,仅在destroyEngine时重置
     *         (2) 使用该方法设置单流（默认）或者双流模式。发送端开启双流模式后，接收端可以选择接收大流还是小流。
     *             其中，大流指高分辨率、高码率的视频流，小流指低分辨率、低码率的视频流。
     */
    public int enableLocalDualStreamMode(boolean enabled)
    {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLocalDualStreamMode  enbaled:%b", enabled);
        return ThunderNative.enableLocalDualStreamMode(enabled);
    }

    /**
     * @brief 设置默认订阅的视频流类型
     * @param type 设置默认接收的视频流类型,参见{@link ThunderRtcConstant.ThunderVideoStreamType}
     * @return 0:成功,其它错误参见{@link ThunderRtcConstant.ThunderRet}
     * @remark (1) 在"初始化"后，且进房间前调用，在destroyEngine会重置
     *         (2) 接收远端视频流的类型优先判断changeRemoteVideoStreamType设置的值，没有的话再使用该函数设置的值，
     *             如果这两个接口都没调用，默认订阅远端视频流都是大流
     */
    public int setDefaultRemoteVideoStreamType(int type) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setDefaultRemoteVideoStreamType  type:" + type);
        return ThunderNative.setDefaultRemoteVideoStreamType(type);
    }

    /**
     * @brief 设置订阅的视频流类型
     * @param uid 用户 UID
     * @param type 视频流类型 参见{@link ThunderRtcConstant.ThunderVideoStreamType}
     * @return 0:成功,其它错误参见{@link ThunderRtcConstant.ThunderRet}
     * @remark (1) 在"初始化"后调用，在destroyEngine和leaveRoom时会重置
     *         (2) 发送端如果调用 enableLocalDualStreamMode(true)开启双流模式，接收端可选择接收大流还是小流，
     *             如果发送端不开启双流模式，接收端默认接收大流
     *         (3) 接收远端视频流的类型优先判断该接口设置的值，没有的话再使用setDefaultRemoteVideoStreamType设置的值,
     *             如果这两个接口都没调用，默认订阅远端视频流都是大流
     */
    public int changeRemoteVideoStreamType(String uid, int type) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "changeRemoteVideoStreamType: UID:" + uid + " type:" + type);
        return ThunderNative.changeRemoteVideoStreamType(uid, type);
    }

    /**
     * @brief Set user role
     * @param role User role type, see details in {@link ThunderRtcConstant.ThunderUserRole}
     * @return 0-Success, other-Error codes, see details in {@link ThunderRtcConstant.ThunderRet}
     * @remark (1)  This API should be called after initialization, and will be reset after calling destroyEngine.
     *         (2)  All users are hosts by default, and you can only use this API to set the user role as audience.
     *              By calling this API, you can set the user as an audience or host before joining a room; and switch the user roles after joining a room.
     *         (3)  If you call this API to switch user roles after joining a room, the callback onUserRoleChanged will be triggered locally.
     *              And onUserJoined or onUserOffline will be triggered remotelly.
     *         (4)  If a host user has sent streams, when the user's role is switched to audience, the actions, incuding stream capture, preview (video), encoding and stream-pushing stop, which will be resumed when user's role is switched host again.
     *         (5)  The audience does not supported calling publishing-related APIs (stream capture, preview (video), encoding, and stream-pushing), otherwise the error code THUNDER_RET_LOCAL_USER_ROLE_ERR will be returned.
     */
    public int switchUserRole(int role) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "switchUserRole: role:" + role);
        return ThunderNative.switchUserRole(role);
    }

    /**
     * Register monitored and captured texture data for beautifying and other processing
     * {@link IGPUProcess} interface object instance; if null is passed in, cancel registration
     *
     * @param observer Instance for setting, getting and processing each frame of video rendering texture
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int registerVideoCaptureTextureObserver(IGPUProcess observer) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "registerVideoCaptureTextureObserver");
        ThunderBridgeLib.getInstance().setGPUImageProcessFilter(observer);
        return 0;
    }

    /**
     * 注册纹理回调，用于美颜和其他特效等
     * {@link VideoTextureFrameObserver} 回调对象实例; 如果传入null，取消注册
     *
     * @param observer 用于初始化/销毁美颜等相关操作，获取和处理视频渲染纹理的每一帧
     * @return 0: 成功，其他错误参看{@link ThunderRtcConstant.ThunderRet}
     */
    public int registerVideoCaptureTextureFrameObserver(VideoTextureFrameObserver observer) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "registerVideoCaptureTextureObserver");
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_NOT_IN_THUNDERBOLT;
        }
        VideoFrameTextrue.getInstance().enableVideoTextrue(observer);
        return 0;
    }


    /**
     * Register an observer object for data captured by camera
     *
     * @param observer Object instance; if observer is NULL, cancel registration. It is used to set instances for getting video camera yuv captured data and video rendering data respectively
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark The interface shall be called after initialization,it is reset when leaveRoom is called.
     */

    public int registerVideoCaptureFrameObserver(IVideoCaptureObserver observer) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "registerVideoCaptureFrameObserver");
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_NOT_IN_THUNDERBOLT;
        }
        VideoFrameYuvCapture.getInstance().enableVideoCapture(observer);
        return 0;
    }

    /**
     * Register monitored and decoded YUV(I420) video data object
     * @param uid Monitor decoded video data of current uid
     * @param observer Monitor a callback type object instance; if observer is NULL, cancel registration
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int registerVideoDecodeFrameObserver(String uid, IVideoDecodeObserver observer) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "registerVideoDecodeFrameObserver uid %s, %s", uid, observer);
        return ThunderNative.setVideoFrameObserver(uid, observer);
    }

    /**
     * Register audio frame observer
     *
     * @param observer {@link IAudioFrameObserver} interface object instance; if null is loaded, cancel registration
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "registerAudioFrameObserver " + observer);
        ThunderNative.registerAudioFrameObserver(observer);
        return 0;
    }

    /**
     * Register encoded audio frame observer
     *
     * @param observer {@link IAudioEncodedFrameObserver} interface object instance; if null is loaded, cancel registration
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int registerAudioEncodedFrameObserver(IAudioEncodedFrameObserver observer) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "registerAudioEncodedFrameObserver " + observer);
        return ThunderNative.registerAudioEncodedFrameObserver(observer);
    }

    /**
     * Set format of callback on captured data
     *
     * @param sampleRate     Specify the sampling rate of returned data in onRecordFrame, which can be set as 8,000, 16,000, 32,000, 44,100 or 48,000
     * @param channel        Specify the channel number of returned data in onRecordFrame, which can be set as 1 (single audio track) or 2 (dual audio track)
     * @param mode           Specify the use mode of onRecordFrame: {@link ThunderRtcConstant.ThunderAudioRawFrameOperationMode}
     * @param samplesPerCall Specify the sampling number of returned data in onRecordFrame, for example, the sampling number in RTMP stream publishing is 1,024 in general. 
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setRecordingAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
          "setRecordingAudioFrameParameters sampleRate %d, channel %d, mode %d, samplesPerCall %d",
          sampleRate,
          channel,
          mode,
          samplesPerCall);
        return ThunderNative.setRecordingAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
    }

    /**
     * Set format of callback on playback data
     *
     * @param sampleRate     Specify the sampling rate of returned data in onPlaybackFrame, which can be set as 8,000, 16,000, 32,000, 44,100 or 48,000
     * @param channel        Specify the channel number of returned data in onPlaybackFrame, which can be set as 1 (single audio track) or 2 (dual audio track)
     * @param mode           Specify the use mode of onPlaybackFrame: {@link ThunderRtcConstant.ThunderAudioRawFrameOperationMode}
     * @param samplesPerCall Specify the sampling number of returned data in onPlaybackFrame, for example, the sampling number in RTMP stream publishing is 1,024 in general.
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setPlaybackAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,"setPlaybackAudioFrameParameters sampleRate %d, channel %d, mode %d, samplesPerCall %d",
                sampleRate, channel, mode, samplesPerCall);
        return ThunderNative.setPlaybackAudioFrameParameters(sampleRate, channel, mode, samplesPerCall);
    }

    /**
     * Set format of callback on mixed data
     *
     * @param sampleRate     Specify the sampling rate of returned data in onMixedAudioFrame, which can be set as 8,000, 16,000, 32,000, 44,100 or 48,000
     * @param channel        Specify the channel number of returned data in onMixedAudioFrame, which can be set as 1 (single audio track) or 2 (dual audio track)
     * @param samplesPerCall Specify the sampling number of returned data in onMixedAudioFrame, for example, the sampling number in RTMP stream publishing is 1,024 in general.
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setMixedAudioFrameParameters(int sampleRate, int channel, int samplesPerCall) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,"setMixedAudioFrameParameters sampleRate %d, channel %d, samplesPerCall %d",
                sampleRate, channel, samplesPerCall);
        return ThunderNative.setMixedAudioFrameParameters(sampleRate, channel, samplesPerCall);
    }

    /**
     * Add local video watermark
     * This method is to add one PNG picture on a local video as the watermark, and the watermark will be released along with the local video
     * If the size of PNG picture to be added is inconsistent with the specified size, SDK will crop it to the specified size. 
     * Only one watermark can be added into the live video, and the watermark added later will replace the last one. 
     * The interface passes null to cancel the setting of watermark. 
     * The watermark will rotate with the rotation of screen. 
     *
     * @param watermark A watermark picture to be added into local live stream publishing. For details, see {@link ThunderBoltImage}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setVideoWatermark(ThunderBoltImage watermark) {
        if (watermark != null &&
                (watermark.height <= 0 || watermark.width <= 0
                || watermark.width > 1920 || watermark.height > 1920
                || watermark.x < 0 || watermark.y < 0))
        {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                    "setVideoWatermark invalid params, x %d, y %d, w %d, h %d ",
                    watermark.x, watermark.y, watermark.width, watermark.height);
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setVideoWatermark");
        return ThunderNative.setPubWatermark(watermark);
    }

    /**
     * Set external audio capture parameters; call this interface before audio publishing, and start publishing after external stream publishing is determined
     *
     * @param enabled    true: enable external audio capture  false: disable external audio capture (by default)
     * @param sampleRate The sampling rate of external audio source, which can be set as 8,000, 16,000, 32,000, 44,100 or 48,000
     * @param channel    The channel number of external audio source (supporting two audio tracks at maximum)
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setCustomAudioSource(boolean enabled, int sampleRate, int channel) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setCustomAudioSource enable %b, sampleRate %d, channel %d",
                enabled, sampleRate, channel);
        return ThunderNative.setCustomAudioSource(enabled, sampleRate, channel);
    }

    /**
     * Call the following interface before pushing the external audio frame
     * @see ThunderEngine#setCustomAudioSource(boolean, int, int)
     *
     * @param data PCM audio frame data
     * @param timeStamp Timestamp of external audio frame, which is synchronized with external video source
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int pushCustomAudioFrame(byte[] data, long timeStamp) {
        if (data == null || data.length == 0) {
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
        return ThunderNative.pushCustomAudioFrame(data, timeStamp);
    }

    /**
     * Set custom video source
     * @param videoSource Custom video source. The user should implement {@link ThunderCustomVideoSource} interface to monitor the corresponding method,
     *                    gets {@link ThunderVideoFrameConsumer} interface object through onInitialize, and then perform stream publishing using the consumeByteArrayFrame method
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setCustomVideoSource(ThunderCustomVideoSource videoSource) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setCustomVideoSource");
        if (ThunderNative.getUserRole() != ThunderRtcConstant.ThunderUserRole.THUNDER_USER_ROLE_ANCHOR) {
            ThunderLog.warn(ThunderLog.kLogTagRtcEngine, "setCustomVideoSource not anchor");
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_LOCAL_USER_ROLE_ERR;
        }
        if (videoSource == null || (videoSource instanceof ThunderDefaultCamera))
        {
            if (videoSource != null) {
                return ThunderNative.attachVideoCapture(videoSource,
                        ThunderRtcConstant.LiveEngineCaptureType.THUNDER_CAPTURE_TYPE_DEFAULT_CAMERA);
            } else {
                return ThunderNative.attachVideoCapture(mPublisher.getDefaluteCamera(),
                        ThunderRtcConstant.LiveEngineCaptureType.THUNDER_CAPTURE_TYPE_DEFAULT_CAMERA);
            }
        } else if (videoSource instanceof ScreenRecordSource) {
            return ThunderNative.attachVideoCapture(((ScreenRecordSource) videoSource).mScreenCapture,
                    ThunderRtcConstant.LiveEngineCaptureType.THUNDER_CAPTURE_TYPE_SCREEN_RECORD);
        } else {
            if (mExternalVideoSource == null || !mExternalVideoSource.equals(videoSource)) {
                mExternalVideoSource = new ExternalVideoSource(videoSource);
                if (videoSource instanceof ThunderExternalVideoSource) {
                    mExternalVideoSource.setVideoBufferType(((ThunderExternalVideoSource) videoSource).getThunderVideoBufferType());
                }
            }
            return ThunderNative.attachVideoCapture(mExternalVideoSource,
                    ThunderRtcConstant.LiveEngineCaptureType.THUNDER_CAPTURE_TYPE_EXTERNAL_SOURCE);
        }
    }

    /**
     * Add the source stream publishing address 
     * Only one-channel stream publishing address can be added each time by this method. If multi-channel streams need to be pushed, this method have to be called repeatedly. 
     * [5 stream publishing addresses are supported at maximum]
     * After publishing, the server will push the source stream to corresponding URL; the method can be called only after joinRoom is performed, and this configuration will be cleared after leaveRoom is performed
     *
     * @param url Stream publishing address in the format of RTMP, not supporting Chinese and other special characters
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int addPublishOriginStreamUrl(String url) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "addPublishOriginStreamUrl %s", url);
        return ThunderNative.updatePublishOriginStreamUrl(true, url);
    }

    /**
     * Remove stream publishing address of source stream
     *
     * @param url Stream publishing address to be removed
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int removePublishOriginStreamUrl(String url) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "removePublishOriginStreamUrl %s", url);
        return ThunderNative.updatePublishOriginStreamUrl(false, url);
    }

    /**
     * Add stream publishing address of transcoding stream
     * Add stream publishing address for specified transcoding task. 
     * Call this interface after setLiveTransCoding interface is called
     * [One transcoding task supports 5 stream publishing addresses at maximum]
     * The method can be called only after joinRoom is performed, and this configuration will be cleared after leaveRoom is performed
     *
     * @param taskId Transcoding task identifier, indicating that stream publishing address is added for transcoding task with this taskId
     * @param url    Stream publishing address in the format of RTMP, not supporting Chinese and other special characters
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int addPublishTranscodingStreamUrl(String taskId, String url) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "addPublishTranscodingStreamUrl taskId %s, url %s", taskId, url);
        return ThunderNative.updatePublishTranscodingStreamUrl(taskId, true, url);
    }

    /**
     * Remove transcoding stream publishing address,
     *  Only one stream publishing address can be deleted at a time. If multiple paths of streams should be removed, call this method for multiple times
     * The method can be called only after joinRoom is performed
     *
     * @param taskId Transcoding task identifier
     * @param url Stream publishing address to be removed
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int removePublishTranscodingStreamUrl(String taskId, String url) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "removePublishTranscodingStreamUrl taskId %s, url %s", taskId, url);
        return ThunderNative.updatePublishTranscodingStreamUrl(taskId, false, url);
    }

    /**
     * Add/update transcoding task [one room supports 5 transcoding tasks at maximum]
     * After publishing, the server will transcode and publish on the basis of set canvas (if any). The method can be called only after joinRoom is performed, and this configuration will be cleared after leaveRoom is performed
     * Call this method firstly, and then call addPublishTranscodingStreamUrl
     * The configuration parameters in transcodingModeOptions are enabled if transcodingMode in transcodingCfg is equal to 0; Otherwise, they are disabled.
     *
     * @param taskId      Transcoding task identifier managed by the user and unique in the room,
     *                    only supporting the permutation and combination of characters including [A,Z], [a,z], [0,9], with the length not exceeding 64 bytes
     * @param transcoding Specific transcoding layout
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setLiveTranscodingTask(String taskId, LiveTranscoding transcoding) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setLiveTranscodingTask taskId %s", taskId);
        return ThunderNative.setLiveTranscodingTask(taskId, transcoding);
    }

    /**
     * Remove transcoding task
     *
     * @param taskId Transcoding task identifier
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int removeLiveTranscodingTask(String taskId) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "removeLiveTranscodingTask taskId %s", taskId);
        return ThunderNative.removeLiveTranscodingTask(taskId);
    }

    /**
     * Subscribe [Cross-room subscription] of specified stream
     * The method can be called only after joinRoom is performed, and this configuration will be cleared after leaveRoom is performed
     *
     * @param roomId Room ID [only supporting the permutation and combination of characters including [A,Z], [a,z], [0,9], -, _, and with the length not exceeding 64 bytes]
     * @param uid    User ID
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int addSubscribe(String roomId, String uid) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "addSubscribe roomId %s, uid %s", roomId, uid);
        return ThunderNative.subscribeUser(true, roomId, uid);
    }

    /**
     * Cancel subscription of stream
     * The method can be called only after joinRoom is performed
     *
     * @param roomId Room ID [only supporting the permutation and combination of characters including [A,Z], [a,z], [0,9], -, _, and with the length not exceeding 64 bytes]
     * @param uid User ID
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int removeSubscribe(String roomId, String uid) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "removeSubscribe roomId %s, uid %s", roomId, uid);
        return ThunderNative.subscribeUser(false, roomId, uid);
    }

    /**
     * Subscription designated room [cross room subscription]
     * @param roomId Room ID [only supporting the permutation and combination of characters including [A,Z], [a,z], [0,9], -, _, and with the length not exceeding 64 bytes]
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark (1) needs to be called after "onJoinRoomSuccess", then cancel the subscription with unsubscribeRoom or leaveRoom.
     *         (2) If there is a remote called back to the published and published streams, if there are remote called back to the
     *         (3) If addsubscribe is called, this interface can be called to subscribe to the same room. At this time, the first callback will filter out the callbacks of users who called addsubscribe the previous time
     *         (4) After calling this interface, the subscription room can only be removed through unsubscriberoom. Calling removesubscribe returns the error of calling unsubscriberoom to unsubscribe
     */
    public int subscribeRoom(String roomId) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "subscribeRoom roomId %s", roomId);
        return ThunderNative.subscribeRoom(true, roomId);
    }

    /**
     * unsubscribe the specified room [cross room subscription]
     * @param roomId Room ID [only supporting the permutation and combination of characters including [A,Z], [a,z], [0,9], -, _, and with the length not exceeding 64 bytes]
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     * @remark (1) needs to be called after "onJoinRoomSuccess" and is used after calling addSubscribe or subscribeRoom.
     *         (2) Call this interface, and the callback notification is onRemoteVideoArrived and onRemoteAudioArrived
     */
    public int unsubscribeRoom(String roomId) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "unsubscribeRoom roomId %s", roomId);
        return ThunderNative.subscribeRoom(false, roomId);
    }

    /**
     * Switch to front/rear camera
     * Call this method after {@linkstartPreview} is enabled. The engine will start the front camera by default when this method is not called.
     *
     * @param bFront true: front camera , false: rear camera 
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int switchFrontCamera(boolean bFront) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "switchFrontCamera %b", bFront);
        return ThunderNative.switchFrontCamera(bFront);
    }

    /**
     * @brief 摄像头是否打开
     * @return true: 摄像头打开；false: 摄像头没打开
     */
    public boolean isCameraOpen() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isCameraOpen");
        return ThunderNative.isCameraOpen();
    }

    /**
     * @brief 是否前置摄像头
     * @return true: 是前置摄像头；false: 是后置摄像头
     * @remark 调用前需要先打开摄像头，可以通过{@link #isCameraOpen}判断摄像头是否打开。
     */
    public boolean isFrontCamera() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isFrontCamera");
        return ThunderNative.isFrontCamera();
    }

    /**
     * @brief 摄像头是否支持手动对焦
     * @return true: 摄像头支持手动对焦功能；false: 摄像头不支持手动对焦功能
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认判断前置摄像头是否支持该功能，如需判断后置摄像头请先调用{@link #switchFrontCamera}进行切换
     */
    public boolean isCameraFocusSupported() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isCameraFocusSupported");
        return ThunderNative.isCameraManualFocusPositionSupported();
    }

    /**
     * @brief 摄像头是否支持手动曝光
     * @return true: 摄像头支持手动曝光功能；false: 摄像头不支持手动曝光功能
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认判断前置摄像头是否支持该功能，如需判断后置摄像头请先调用switchFrontCamera进行切换
     */
    public boolean isCameraExposurePositionSupported() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isCameraExposurePositionSupported");
        return ThunderNative.isCameraManualExposurePositionSupported();
    }

    /**
     * @brief 摄像头是否支持缩放
     * @return true: 摄像头支持缩放；false: 摄像头不支持缩放
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认判断前置摄像头，如需判断后置摄像头请先调用{@link #switchFrontCamera}进行切换
     *         (3) 切换了摄像头(调用了{@link #switchFrontCamera})，需要重新调用
     */
    public boolean isCameraZoomSupported() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isCameraZoomSupported");
        return ThunderNative.isCameraZoomSupported();
    }

    /**
     * @brief 得到摄像头的最大缩放值
     * @return 调用成功返回最大的摄像头缩放值，失败返回<0
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认前置摄像头，如需查询后置摄像头请先调用{@link #switchFrontCamera}进行切换
     *         (3) 切换了摄像头(调用了{@link #switchFrontCamera})，需要重新调用
     */

    public float getCameraMaxZoomFactor() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "getCameraMaxZoomFactor");
        return ThunderNative.getCameraMaxZoomFactor();
    }

    /**
     * Set camera zoom factor
     * camera api to operate camera zoom
     *
     * @param zoomFactor For camera zoom, normalized factor: [1.0 - max]
     * @return actual camera supported zoom factor [1.0 - max] if success,
     *      or negative value if failed
     */
    public int setCameraZoomFactor(float zoomFactor) {
        return ThunderNative.setCameraZoomFactor(zoomFactor);
    }


    /**
     * @brief 摄像头是否支持手电筒功能
     * @return true: 摄像头支持手电筒功能；false: 摄像头不支持手电筒功能
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认判断前置摄像头，如需判断后置摄像头请先调用{@link #switchFrontCamera}进行切换
     *         (3) 切换了摄像头(调用了{@link #switchFrontCamera})，需要重新判断
     */
    public boolean isCameraTorchSupported() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isCameraTorchSupported");
        return ThunderNative.isCameraTorchSupported();
    }

    /**
     * @brief 开启/关闭摄像头手电筒功能
     * @param isOn true: 打开, false: 关闭.
     * @return 成功：0， 失败 < 0
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认判断前置摄像头，如需判断后置摄像头请先调用{@link #switchFrontCamera}进行切换
     *         (3) 切换了摄像头(调用了{@link #switchFrontCamera})，需要重新判断
     */
    public int setCameraTorchOn(boolean isOn) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setCameraTorchOn %b", isOn);
        return ThunderNative.setCameraTorchOn(isOn);
    }

    /**
     * @brief 设置摄像头对焦位置,并触发手动对焦
     * @param posX, posY 触摸点相对于视图的x,y坐标
     * @return 成功：0， 失败 < 0
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认判断前置摄像头，如需判断后置摄像头请先调用{@link #switchFrontCamera}进行切换
     *         (3) 切换了摄像头(调用了{@link #switchFrontCamera})，需要重新判断
     *         (4) 成功调用该方法后，本地会触发 onCameraFocusAreaChanged 回调
     */
    public int setCameraFocusPositionInPreview(float posX, float posY) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setCameraFocusPositionInPreview");
        return ThunderNative.setCameraFocusPosition(posX, posY);
    }

    /**
     * @brief 设置摄像头曝光位置
     * @param posX, posY 触摸点相对于视图的x,y坐标
     * @return 成功：0， 失败 < 0
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认判断前置摄像头，如需判断后置摄像头请先调用{@link #switchFrontCamera}进行切换
     *         (3) 切换了摄像头(调用了{@link #switchFrontCamera})，需要重新判断
     *         (4) 成功调用该方法后，本地会触发 onCameraExposureAreaChanged 回调
     */
    public int setCameraExposurePosition(float posX, float posY) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setCameraExposurePosition");
        return ThunderNative.setCameraExposurePosition(posX, posY);
    }

    /**
     * @brief 摄像头是否支持人脸对焦功能
     * @return true: 摄像头支持人脸对焦功能；false: 摄像头不支持人脸对焦功能
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认判断前置摄像头，如需判断后置摄像头请先调用{@link #switchFrontCamera}进行切换
     *         (3) 切换了摄像头(调用了{@link #switchFrontCamera})，需要重新判断
     */
    public boolean isCameraAutoFocusFaceModeSupported() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isCameraAutoFocusFaceModeSupported");
        return ThunderNative.isCameraAutoFocusFaceModeSupported();
    }
    /**
     * @brief 开启/关闭人脸对焦功能
     * @param enable true: 打开， false: 关闭
     * @return 成功：0， 失败 < 0
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认判断前置摄像头，如需判断后置摄像头请先调用{@link #switchFrontCamera}进行切换
     *         (3) 切换了摄像头(调用了{@link #switchFrontCamera})，需要重新判断
     */
    public int setCameraAutoFocusFaceModeEnabled(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setCameraAutoFocusFaceModeEnabled %b", enable);
        return ThunderNative.setCameraAutoFocusFaceModeEnabled(enable);
    }

    /**
     * @brief 获取摄像头方向
     * @return 成功：{@link ThunderRtcConstant.ThunderVideoCaptureOrientation}， 失败 < 0
     * @remark (1) 调用前需要先打开摄像头，可以通过{@link #isCameraOpen()}判断摄像头是否打开
     *         (2) 默认判断前置摄像头，如需判断后置摄像头请先调用{@link #switchFrontCamera}进行切换
     *         (3) 切换了摄像头(调用了{@link #switchFrontCamera})，需要重新判断
     */
    public int getVideoCaptureOrientation() {
        return ThunderNative.getOrientation();
    }
    /**
     * Set publishing orientations of camera (0/90/180/270 orientation)
     *
     * @param orientation 0: rotate 0 degrees(PORTRAIT), 1: rotate 90 degrees(LANDSCAPE), 2: rotate 180 degrees(PORTRAIT_UPSIDEDOWN), 3: rotate 270 degrees(LANDSCAPE_UPSIDEDOWN)
     *                    {@link ThunderRtcConstant.ThunderVideoCaptureOrientation}
     * 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setVideoCaptureOrientation(int orientation) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setVideoCaptureOrientation orientation %d", orientation);
        return ThunderNative.setOrientation(orientation);
    }

    /**
     * Set mirror mode of local video
     * (This API only works for the front camera. By default, mirror mode is disabled for rear cameras when previewing and streaming;
     * for front cameras, mirror mode is enabled for preview and disabled for push-stream)
     *
     * @param mode For mirror mode, see {@link ThunderRtcConstant.ThunderVideoMirrorMode}
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setLocalVideoMirrorMode(int mode) {
if (ThunderLog.isInfoValid()) {
        ThunderLog.info(ThunderLog.kLogTagRtcEngine, "setLocalVideoMirrorMode %d", mode);
}
        return ThunderNative.setLocalVideoMirrorMode(mode);
    }
    /**
     * @brief 启动/关闭啸叫检测
     * @param enabled true:启动啸叫检测；false:关闭啸叫检测；默认为false
     * @return 0:成功, 其它错误参见enum ThunderRet
     * @remark 需要"初始化"后调用，仅在destroyEngine时重置，检测结果会通过onHowlingDetectResult通知
     */
    public int enableHowlingDetector(Boolean enabled){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableHowlingDetector %b", enabled);
        return ThunderNative.enableHowlingDetector(enabled);
    }

    /**
     * @brief 启动/关闭漏回声检测
     * @param enabled true:启动漏回声检测；false:关闭漏回声检测；默认为false
     * @return 0:成功, 其它错误参见enum ThunderRet
     * @remark 需要"初始化"后调用，仅在destroyEngine时重置，检测结果会通过onEchoDetectResult通知
     */
    public int enableEchoDetector(Boolean enabled){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableEchoDetector %b", enabled);
        return ThunderNative.enableEchoDetector(enabled);
    }

    /**
     * @brief 启动采集设备检测
     * @return 0:成功, 其它错误参见enum ThunderRet
     * @remark 需要"初始化"后调用，仅在destroyEngine时重置，检测结果会通过onAudioInputDeviceTest通知
     */
    public int startInputDeviceTest(){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startInputDeviceTest");
        return ThunderNative.startInputDeviceTest();
    }

    /**
     * @brief 停止采集设备检测
     * @return 0:成功, 其它错误参见enum ThunderRet
     * @remark 需要"初始化"后调用，仅在destroyEngine时重置
     */
    public int stopInputDeviceTest(){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopInputDeviceTest");
        return ThunderNative.stopInputDeviceTest();
    }

    /**
     * @brief 启动播放设备检测
     * @param filePath 音频文件路径
     * @return 0:成功, 其它错误参见enum ThunderRet
     * @remark 需要"初始化"后调用，仅在destroyEngine时重置，检测结果会通过onAudioOutputDeviceTest通知
     */
    public int startOutputDeviceTest(String filePath){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startOutputDeviceTest");
        return ThunderNative.startOutputDeviceTest(filePath);
    }

    /**
     * @brief 停止播放设备检测
     * @return 0:成功, 其它错误参见enum ThunderRet
     * @remark 需要"初始化"后调用，仅在destroyEngine时重置
     */
    public int stopOutputDeviceTest(){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopOutputDeviceTest");
        return ThunderNative.stopOutputDeviceTest();
    }

    /**
     * @brief 启动/关闭 麦克风采集 降噪功能
     * @param enabled true:开启 降噪； false:关闭降噪
     * @return 0:成功，其它错误参见enum ThunderRet
     * @remark 需要"初始化"后调用，仅在destroyEngine时重置
     */
    public int enableMicDenoise(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableMicDenoise %b", enabled);
        return ThunderNative.enableMicDenoise(enabled);
    }

    /**
     * @brief 查询当前是否开启/关闭 麦克风采集降噪功能
     * @return true:当前已经开启降噪；false：当前已经关闭降噪。 默认返回true
     * @remark 需要"初始化"后调用，仅在destroyEngine时重置
     */
    public boolean isMicDenoiseEnabled() {
        boolean ret = ThunderNative.micDenoiseEnabled();
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "isMicDenoiseEnabled %b", ret);
        return ret;
    }

    /**
     * @brief 启动/关闭 音频自动增益功能
     * @param enabled true:开启 自动增益； false:关闭自动增益
     * @return 0:成功，其它错误参见enum ThunderRet
     * @remark 需要"初始化"后调用，仅在destroyEngine时重置
     */
    public int enableAGC(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableAGC %b", enabled);
        return ThunderNative.enableAGC(enabled);
    }

    /**
     * @brief 启动/关闭 音频AI降噪
     * @param enabled true:开启 AI降噪； false:关闭AI降噪
     * @return 0:成功，其它错误参见enum ThunderRet
     * @remark 需要"初始化"后调用，仅在destroyEngine时重置
     */
    public int enableAIDenoise(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableAIDenoise %b", enabled);
        return ThunderNative.enableAIDenoise(enabled);
    }

    /**
     * As shown below, YMFVideoPosition indicates that the outer frame is video layout
     * Video is a video layout region
     * |---------------------------------------------|
     * | (0,0)                                       |
     * |                                             |
     * |                             (mX,mY)         |
     * |                               |---width---| |
     * |                               |           | |
     * |                        height |           | |
     * |                               | Video     | |
     * |                               |           | |
     * |                               |-----------| |
     * |---------------------------------------------|
     * @param params Video layout information
     * @return 0: succeeded. For other errors, see {@link ThunderRtcConstant.ThunderRet}
     */
    public int setMultiVideoViewLayout(ThunderMultiVideoViewParam params) {
        if (params != null) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
              "setMultiVideoViewLayout mViewId:%d, view:%s, BitMap:%s, coordinate:%s",
              params.mViewId,
              getPrintString(params.mView),
              getPrintString(params.mBgBitmap),
              getPrintString(params.mBgViewPosition));
            return ThunderNative.initMultiPlayerViewLayout(params, params.mViewId, params.mView);
        } else {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setMultiVideoViewLayout null");
            return ThunderRtcConstant.ThunderRet.THUNDER_RET_INVALID_ARGUMENT;
        }
    }
    /**
     * @brief 获取远端视频截图
     * @param  uid 远端用户uid
     * @return Bitmap: 对应uid的远端用户视频截图的位图，在非正常播放渲染远端视频流时返回null
     * @remark （1）需要在"初始化"后调用
     */
    public Bitmap captureRemoteScreenShot(String uid){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "captureRemoteScreenShot uid: %b", uid);
        return ThunderNative.captureRemoteScreenShot(uid);
    }

    /**
     * @brief 设置本地固定的推流画面,只支持摄像头采集和录屏采集场景，外部推流场景不支持,镜像与后置摄像头一致
     * @param bitmap 固定推流画面位图
    1. 传入参数为null的时候恢复为替换前的采集源（摄像头或者录屏）
    2. 已设置固定推流画面，传入新的bitmap，使用新的固定推流画面替换已设置的推流画面
    3. 当传入的图片的宽高比与设置的编码宽高比不一致时，SDK负责裁剪图片与编码宽高比一致
     * @return 成功返回0， 失败返回 < 0.
     * @remark 1. 设置该接口后，bitmap会替换采集源的图像，作为固定采集输入源
    2. 该接口在"SDK初始化"后调用，可在开采集或者开编码后任意时刻设置
    3. 该设置直到卸载SDK后才重置，要恢复原来的采集源，必须传入null参数来重置
    4. SDK内部不负责位图的内存释放，业务层在关闭固定推流画面后负责位图的回收
    5. 在设置固定推流画面后，业务层回收位图（recycle()），行为未定义，业务层必须保证位图的有效性
     */
    public int setCaptureReplaceImage(Bitmap bitmap)
    {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setCaptureReplaceImage");
        return ThunderNative.setCaptureReplaceImage(bitmap);
    }

    /**
     * @brief 获取本地视频截图
     * @return Bitmap: 本地视频截图的位图，在非正常渲染本地视频流时返回null
     * @remark 需要在"开启视频预览"后调用
     */
    public Bitmap captureLocalScreenShot(){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "captureLocalScreenShot");
        return ThunderNative.captureLocalScreenShot();
    }
    /**
     * 获取编码宽、高、帧率、码率编码信息
     * remark: 在"初始化"后调用
     * @param videoConfig 编码配置档位 {@link ThunderVideoEncoderConfiguration}
     * @return 具体编码参数 {@link ThunderVideoEncodeParam}
     */
    public ThunderVideoEncodeParam getVideoEncoderParam(ThunderVideoEncoderConfiguration videoConfig) {
        if (videoConfig == null) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "getVideoEncoderParam null params");
            return null;
        }
        ThunderVideoEncodeParam param = ThunderNative.getVideoEncoderParamByGear(videoConfig.playType, videoConfig.publishMode);
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "getVideoEncoderParam playType %d, publishMode %d",
                videoConfig.playType, videoConfig.publishMode);
        return param;
    }

    public static ThunderDefaultCamera getDefaluteCamera() {
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            return null;
        }
        if (mPublisher != null) {
            return mPublisher.getDefaluteCamera();
        } else {
            return null;
        }

    }

    private void resetRtcEngine() {
        //static info
        mHandler = null;

        mRtcEventHandler = null;
        mHttpsRequestHandler = null;

        //switch
        s_captureVolumeNotifyCount = 0;
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        s_audioPlaySpectrumCount = 0;

        //video
        if (mPublisher.getDefaluteCamera() != null) {
            ThunderPreviewConfig config = (ThunderPreviewConfig) mPublisher.getDefaluteCamera().getCaptureConfig();

            config.cameraPosition = THUNDERCAMERA_POSITION_FRONT;
            config.captureOrientation = THUNDER_VIDEO_CAPTURE_ORIENTATION_PORTRAIT;
        }
        mPublisher = null;
        mThunderMediaExtraInfoCallback = null;

        // new
       if (mNetStateService != null) {
            mNetStateService.fini();
        }
        if (mForeBackgroundListener != null) {
            mForeBackgroundListener.fini();
        }
        mNetStateService = null;
        mForeBackgroundListener = null;
    }

    private void cleanAllAudioFilePlayer() {
        for (ThunderAudioFilePlayer audioFilePlayer : mAudioFilePlayerSet) {
            audioFilePlayer.destroyAudioFilePlayer();
        }
        mAudioFilePlayerSet.clear();
    }

    private String getPrintString(String str) {
        String result = "";
        if (str != null) {
            result = str;
        }

        return result;
    }

    private String getPrintString(byte[] data) {
        String result = "";
        if (data != null) {
            result = data.toString();
        }

        return result;
    }

    private String getPrintString(Object obj) {
        String result = "";
        if (obj != null) {
            result = obj.toString();
        }
        return result;
    }
}

