/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import java.lang.ref.WeakReference;
import org.webrtc.audioengine.AppBackgroundMonitorListener;
import org.webrtc.audioengine.AudioManagerAndroid;

class AppBackgroundMonitor
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "[NotifyApplicationBackground]";
    private boolean mIsBackground = false;
    private WeakReference<Activity> mCurrentActivity = null;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private Runnable mCheck = null;
    private Application mApplication = null;
    private Context mContext;
    private AppBackgroundMonitorListener mAppBackgroundMonitorListener;

    public AppBackgroundMonitor(Context context, AppBackgroundMonitorListener listener) {
        this.mContext = context;
        this.mAppBackgroundMonitorListener = listener;
    }

    public void onActivityStarted(Activity activity) {
        this.mCurrentActivity = new WeakReference<Activity>(activity);
        if (this.mCheck != null) {
            this.mHandler.removeCallbacks(this.mCheck);
        }
        if (this.mIsBackground && activity != null && !activity.isChangingConfigurations() && this.mAppBackgroundMonitorListener != null) {
            this.mIsBackground = false;
            this.mAppBackgroundMonitorListener.notifyAppBackground(false);
        }
    }

    public void onActivityPaused(Activity activity) {
        if (!activity.isChangingConfigurations()) {
            final WeakReference<Activity> ref = new WeakReference<Activity>(activity);
            this.mCheck = new Runnable(){

                @Override
                public void run() {
                    AppBackgroundMonitor.this.onActivityCeased((Activity)ref.get());
                }
            };
            this.mHandler.postDelayed(this.mCheck, 2000L);
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.mCheck != null) {
            this.mHandler.removeCallbacks(this.mCheck);
        }
        this.onActivityCeased(activity);
    }

    private void onActivityCeased(Activity activity) {
        if (!(this.mIsBackground || this.mCurrentActivity != null && activity != this.mCurrentActivity.get() || activity == null || activity.isChangingConfigurations() || this.mAppBackgroundMonitorListener == null)) {
            this.mIsBackground = true;
            this.mAppBackgroundMonitorListener.notifyAppBackground(true);
        }
    }

    public void init() {
        if (this.mContext != null && this.mContext instanceof Application) {
            this.mApplication = (Application)this.mContext;
            this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            AudioManagerAndroid.doLog("[NotifyApplicationBackground]registerNotifyApplicationBackgound");
        }
        this.mIsBackground = false;
        this.mCheck = null;
        this.mCurrentActivity = null;
    }

    public void uninit() {
        if (this.mApplication != null) {
            this.mApplication = (Application)this.mContext;
            this.mApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mApplication = null;
            AudioManagerAndroid.doLog("[NotifyApplicationBackground]unregisterNotifyApplicationBackgound");
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

