/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import com.yy.videoplayer.VideoPlayer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VideoDecodeRuntimeInfo {
    private static VideoDecodeRuntimeInfo mInstance;
    private Map<Long, DecodeRuntimeInfo> mDecodeRuntimeInfoMap = new ConcurrentHashMap<Long, DecodeRuntimeInfo>();

    public static VideoDecodeRuntimeInfo instance() {
        if (mInstance == null) {
            mInstance = new VideoDecodeRuntimeInfo();
        }
        return mInstance;
    }

    public void addVideoStream(long streamId, String strUid) {
        if (!this.mDecodeRuntimeInfoMap.containsKey(streamId)) {
            this.mDecodeRuntimeInfoMap.put(streamId, new DecodeRuntimeInfo(strUid));
        }
    }

    public void removeVideoStream(long streamId) {
        if (this.mDecodeRuntimeInfoMap.containsKey(streamId)) {
            this.mDecodeRuntimeInfoMap.remove(streamId);
        }
    }

    private String getDecodeTypeName(int decodeType) {
        String name = "UNKNOWN";
        switch (decodeType) {
            case 0: {
                name = "DEC_TYPE_H264_HW_OFFSCREEEN";
                break;
            }
            case 1: {
                name = "DEC_TYPE_H265_HW_OFFSCREEEN";
                break;
            }
            case 2: {
                name = "DEC_TYPE_H264_SW_FFMPEG";
                break;
            }
            case 3: {
                name = "DEC_TYPE_H265_SW_ITTIAM";
                break;
            }
            case 4: {
                name = "DEC_TYPE_VP8_SW_DECVP8";
            }
        }
        return name;
    }

    public String getDecodeRuntimeInfoString() {
        String res = "";
        for (Map.Entry<Long, DecodeRuntimeInfo> entry : this.mDecodeRuntimeInfoMap.entrySet()) {
            Long streamId = entry.getKey();
            DecodeRuntimeInfo info = entry.getValue();
            if (info == null) continue;
            info.fps = (int)VideoPlayer.getInstance().getPlayerInfo(streamId.longValue(), VideoPlayer.VideoPlayerInfoEnum.FRAME);
            info.bitrate = (int)VideoPlayer.getInstance().getPlayerInfo(streamId.longValue(), VideoPlayer.VideoPlayerInfoEnum.BITRATE) / 1000;
            info.decoderType = (int)VideoPlayer.getInstance().getPlayerInfo(streamId.longValue(), VideoPlayer.VideoPlayerInfoEnum.DECODERTYPE);
            info.resolution = (int)VideoPlayer.getInstance().getPlayerInfo(streamId.longValue(), VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
            info.decode_frame = (int)VideoPlayer.getInstance().getPlayerInfo(streamId.longValue(), VideoPlayer.VideoPlayerInfoEnum.DECODE_FRAME);
            if (info.fps == -1) continue;
            int width = info.resolution >> 16;
            int height = info.resolution & 0xFFFF;
            res = res + "\r\nuid: " + info.strUid + "\r\nrender fps: " + info.fps + "\r\ndecode fps: " + info.decode_frame + "\r\nbitrate: " + info.bitrate + "kb/s \r\ndecoderType: " + this.getDecodeTypeName(info.decoderType) + "\r\nresolution: " + width + "x" + height + "\r\n";
        }
        return res;
    }

    private class DecodeRuntimeInfo {
        public String strUid;
        public int fps;
        public int decode_frame;
        public int bitrate;
        public int decoderType;
        public int resolution;

        public DecodeRuntimeInfo(String strUid) {
            this.strUid = strUid;
        }
    }
}

