/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.thunder.livesdk.ThunderMultiVideoViewParam;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.video.IThunderVideoPlay;
import com.thunder.livesdk.video.IVideoDecodeObserver;
import com.thunder.livesdk.video.ThunderMultiVideoViewCoordinate;
import com.thunder.livesdk.video.ThunderPlayerMultiViewProxy;
import com.thunder.livesdk.video.ThunderPlayerView;
import com.thunder.livesdk.video.ThunderVideoConfig;
import com.thunder.livesdk.video.ThunderVideoHiidoUtil;
import com.thunder.livesdk.video.ThunderVideoPlayListener;
import com.thunder.livesdk.video.VideoDecodeRuntimeInfo;
import com.yy.videoplayer.IVideoLibInfoExt;
import com.yy.videoplayer.VideoDecodeEventNotify;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.VideoRenderNotify;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.stat.IYMFBehaviorEventListener;
import com.yy.videoplayer.stat.YMFPlayerStatisticManager;
import com.yy.videoplayer.stat.YMFPlayerUsrBehaviorStat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ThunderVideoPlayEngineImp
implements IThunderVideoPlay,
IYMFBehaviorEventListener {
    private static final String TAG = "ThunderVideoPlayEngineImp";
    private static long mCallBackPtr = 0L;
    public final int INVALID_VALUE = -1;
    private static final int VIDEO_STAT_FPS = 0;
    private static final int VIDEO_STAT_BITRATE = 1;
    private static final int VIDEO_STATE_RESOLUTION = 2;
    private static final int VIDEO_STATE_DECODER_TYPE = 3;
    private ThunderVideoHiidoUtil mVideoPlayHiidoUtil;
    private static ReentrantReadWriteLock s_observerLock = null;
    private HandlerThread mThunderVideoHandlerThread = null;
    private Handler mThunderVideoHandler = null;
    private ConcurrentHashMap<String, VideoStreamInfo> mVideoStreamInfoMap;
    private ConcurrentHashMap<Long, StrUidVideoDecodeObserver> mVideoDecodeObserverMap;
    private ConcurrentHashMap<String, Integer> mMultiVideoScaleModeMap;
    private ConcurrentHashMap<String, Integer> mMultiVideoMirrorModeMap;
    private ConcurrentHashMap<String, Long> mMultiStreamKeyIdMap;
    private ConcurrentHashMap<String, String> mStreamKeyStrUidMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, Long> mUidToVideoIdCallBackInDualStreamMap;
    private Map<Long, Long> mC2JavaUidMap = new HashMap<Long, Long>();
    private AtomicBoolean mThunderPlayerMultiViewMode = new AtomicBoolean(false);
    private ThunderVideoPlayListener mThunderVideoPlayListener = null;
    private HashMap<Integer, ThunderPlayerMultiViewProxy> mThunderPlayerMultiViewProxyMap = new HashMap(10);
    private HashMap<String, ThunderPlayerMultiViewProxy> mVideoMultiViewMap = new HashMap();
    private HashMap<String, ThunderPlayerMultiViewProxy> mVideoMultiViewRecoverMap = new HashMap();

    @Override
    public void onViewStateNotify(long streamId, int viewState) {
        if (mCallBackPtr != 0L) {
            this.onViewStateNotify(mCallBackPtr, streamId, viewState);
        }
    }

    @Override
    public void onVideoRenderNotify(ArrayList<VideoRenderNotify> notifys) {
        if (mCallBackPtr != 0L) {
            this.onVideoRenderedFrames(mCallBackPtr, notifys);
        }
    }

    @Override
    public void onVideoDecodeNotify(VideoDecodeEventNotify notifys) {
        if (mCallBackPtr != 0L) {
            this.onVideoDecodedFrames(mCallBackPtr, notifys);
        }
    }

    @Override
    public void onFirstFrameRenderNotify(long streamId, int width, int height, long pts) {
        if (mCallBackPtr != 0L) {
            this.onFirstFrameRender(mCallBackPtr, streamId, width, height, pts);
        }
    }

    public void onMultiViewSeatInfoChangedNotify(long streamId, int seatId) {
    }

    @Override
    public void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
        if (mCallBackPtr != 0L) {
            this.onHardwareDecodeError(mCallBackPtr, userGroupId, streamId, errorType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDecodedFrameData(long streamId, int w, int h, byte[] data, int dataLen, long renderTimeMs) {
        try {
            long uid;
            s_observerLock.readLock().lock();
            long javaUid = streamId >> 32;
            long l = uid = this.mC2JavaUidMap.get(javaUid) == null ? (long)((int)javaUid) : this.mC2JavaUidMap.get(javaUid);
            if (this.mVideoDecodeObserverMap == null || this.mVideoDecodeObserverMap.isEmpty()) {
                if (ThunderLog.isInfoValid()) {
                    ThunderLog.info(TAG, "onDecodedFrameData empty observer map");
                }
            } else {
                StrUidVideoDecodeObserver strUidObserver = this.mVideoDecodeObserverMap.get(uid);
                if (strUidObserver == null) {
                    if (ThunderLog.isInfoValid()) {
                        ThunderLog.info(TAG, "onVideoDecodedFrame not found decoder uid %d", uid);
                    }
                } else {
                    IVideoDecodeObserver observer = strUidObserver.getObserver();
                    if (observer == null) {
                        if (ThunderLog.isInfoValid()) {
                            ThunderLog.info(TAG, "onVideoDecodedFrame not found observer uid %d:", uid);
                        }
                    } else {
                        long dualStreamId = 0L;
                        boolean bCalllBack = true;
                        if (null != this.mUidToVideoIdCallBackInDualStreamMap.get(uid) && (dualStreamId = this.mUidToVideoIdCallBackInDualStreamMap.get(uid).longValue()) != streamId) {
                            bCalllBack = false;
                        }
                        if (bCalllBack) {
                            observer.onVideoDecodeFrame(strUidObserver.getStrUid(), w, h, data, dataLen, renderTimeMs);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ThunderLog.error(TAG, "onDecodedFrameData err=%s", e.toString());
        }
        finally {
            s_observerLock.readLock().unlock();
        }
    }

    @Override
    public void onFirstFrameDecodeNotify(long streamId, long pts, long happenTime) {
        if (mCallBackPtr != 0L) {
            this.onFirstFrameDecodeNotify(mCallBackPtr, streamId, pts, happenTime);
            if (this.mThunderVideoHandler != null) {
                final long f_streamId = streamId;
                if (Thread.currentThread().getId() == this.mThunderVideoHandler.getLooper().getThread().getId()) {
                    if (this.mThunderPlayerMultiViewMode.get()) {
                        this.relinkStreamId(streamId);
                    }
                } else {
                    this.mThunderVideoHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (ThunderVideoPlayEngineImp.this.mThunderPlayerMultiViewMode.get()) {
                                ThunderVideoPlayEngineImp.this.relinkStreamId(f_streamId);
                            }
                        }
                    });
                }
            }
        }
    }

    public void onBehaviorEvent(String name, String val, String oval, int level) {
        ThunderNative.makeBehaviorEvent(name, val, oval, level);
    }

    public void playInit() {
        this.mThunderVideoPlayListener = new ThunderVideoPlayListener(YYVideoLibMgr.instance().getAppContext(), this);
        YYVideoLibMgr.instance().setVideoInfoListener("Thunder", (IVideoLibInfoExt)this.mThunderVideoPlayListener);
        this.mVideoPlayHiidoUtil = new ThunderVideoHiidoUtil(YYVideoLibMgr.instance().getAppContext());
        this.mVideoPlayHiidoUtil.register();
        if (s_observerLock == null) {
            s_observerLock = new ReentrantReadWriteLock();
        }
        this.mVideoDecodeObserverMap = new ConcurrentHashMap();
        this.mThunderVideoHandlerThread = new HandlerThread("ThunderPlayEngine");
        this.mThunderVideoHandlerThread.setPriority(10);
        this.mThunderVideoHandlerThread.start();
        this.mThunderVideoHandler = new Handler(this.mThunderVideoHandlerThread.getLooper());
        this.mVideoStreamInfoMap = new ConcurrentHashMap();
        this.mMultiVideoScaleModeMap = new ConcurrentHashMap();
        this.mMultiVideoMirrorModeMap = new ConcurrentHashMap();
        this.mMultiStreamKeyIdMap = new ConcurrentHashMap();
        this.mUidToVideoIdCallBackInDualStreamMap = new ConcurrentHashMap();
        YMFPlayerUsrBehaviorStat.getInstance().setYMFBehaviorEventListener((IYMFBehaviorEventListener)this);
        this.setRemotePlayType(1);
        ThunderVideoConfig config = new ThunderVideoConfig();
        config.AsyncLoad();
    }

    public int startPlayVideoStream(String streamKey, Object toView, int scaleMode, int mirrorMode, int encodeType, boolean bSupportHdwDecode) {
        boolean result = false;
        if (streamKey == null || streamKey.isEmpty()) {
            ThunderLog.error(TAG, "ERROR startPlayVideoStream without right key:%s, scaleMode:%d, mirrorMode:%d, bSupportHdwDecode:%b", streamKey, scaleMode, mirrorMode, bSupportHdwDecode);
            return -1;
        }
        ThunderLog.release(TAG, "startPlayVideoStream streamKey:" + streamKey + " toView:" + toView + " scaleMode:" + scaleMode + " mirrorMode:" + mirrorMode + " encodeType:" + encodeType + " bSupportHdwDecode:" + bSupportHdwDecode);
        if (this.mThunderVideoHandler != null) {
            final String f_streamKey = streamKey;
            final Object f_toView = toView;
            final int f_scaleMode = scaleMode;
            final int f_mirrorMode = mirrorMode;
            final int f_encodeType = encodeType;
            final boolean f_bSupportHdwDecode = bSupportHdwDecode;
            if (Thread.currentThread().getId() == this.mThunderVideoHandler.getLooper().getThread().getId()) {
                if (!this.mThunderPlayerMultiViewMode.get()) {
                    this.startPlayNormalVideoStream(f_streamKey, f_toView, f_scaleMode, f_mirrorMode);
                } else {
                    this.startPlayMultiVideoStream(f_streamKey, f_toView, f_scaleMode, f_mirrorMode, f_encodeType, f_bSupportHdwDecode);
                }
            } else {
                this.mThunderVideoHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!ThunderVideoPlayEngineImp.this.mThunderPlayerMultiViewMode.get()) {
                            ThunderVideoPlayEngineImp.this.startPlayNormalVideoStream(f_streamKey, f_toView, f_scaleMode, f_mirrorMode);
                        } else {
                            ThunderVideoPlayEngineImp.this.startPlayMultiVideoStream(f_streamKey, f_toView, f_scaleMode, f_mirrorMode, f_encodeType, f_bSupportHdwDecode);
                        }
                    }
                });
            }
        }
        return 0;
    }

    public boolean switchDualVideoView(String dstStreamKey, String srcStreamKey, int dstEncodeType) {
        if (dstStreamKey == null || dstStreamKey.isEmpty() || srcStreamKey == null || srcStreamKey.isEmpty()) {
            ThunderLog.error(TAG, "ERROR switchDualVideoView without right dstkey:%s, srcKey:%s", dstStreamKey, srcStreamKey);
            return false;
        }
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "switchDualVideoView dstStreamKey:%s srcStreamKey:%s dstEncodeType:%d", dstStreamKey, srcStreamKey, dstEncodeType);
        }
        if (this.mThunderVideoHandler != null) {
            final String f_srcStreamKey = srcStreamKey;
            final String f_dstStreamKey = dstStreamKey;
            final int f_dstEncodeType = dstEncodeType;
            if (Thread.currentThread().getId() == this.mThunderVideoHandler.getLooper().getThread().getId()) {
                this.switchDualVideoViewUI(f_dstStreamKey, f_srcStreamKey, f_dstEncodeType);
            } else {
                this.mThunderVideoHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderVideoPlayEngineImp.this.switchDualVideoViewUI(f_dstStreamKey, f_srcStreamKey, f_dstEncodeType);
                    }
                });
            }
        }
        return true;
    }

    private void stopPlayMultiVideoStream(String streamKey) {
        ThunderPlayerMultiViewProxy proxy = this.mVideoMultiViewMap.get(streamKey);
        if (proxy != null) {
            proxy.unlink(streamKey);
            this.mVideoMultiViewMap.remove(streamKey);
            this.mMultiStreamKeyIdMap.remove(streamKey);
        }
    }

    public int stopPlayVideoStream(String streamKey) {
        ThunderLog.release(TAG, "stopPlayVideoStream streamKey:" + streamKey);
        final String f_streamKey = streamKey;
        if (this.mThunderVideoHandler != null) {
            if (Thread.currentThread().getId() == this.mThunderVideoHandler.getLooper().getThread().getId()) {
                if (!this.mThunderPlayerMultiViewMode.get()) {
                    this.stopPlayNormalVideoStream(f_streamKey);
                } else {
                    this.stopPlayMultiVideoStream(f_streamKey);
                }
            } else {
                this.mThunderVideoHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!ThunderVideoPlayEngineImp.this.mThunderPlayerMultiViewMode.get()) {
                            ThunderVideoPlayEngineImp.this.stopPlayNormalVideoStream(f_streamKey);
                        } else {
                            ThunderVideoPlayEngineImp.this.stopPlayMultiVideoStream(f_streamKey);
                        }
                    }
                });
            }
        }
        return 0;
    }

    public Object getPlayVideoScreenshot(String streamKey) {
        if (this.mThunderVideoHandler != null) {
            if (!this.mThunderPlayerMultiViewMode.get()) {
                if (this.mVideoStreamInfoMap.get(streamKey) != null) {
                    return this.mVideoStreamInfoMap.get(streamKey).getThunderPlayerView().getVideoScreenshot(-1);
                }
            } else if (this.mVideoMultiViewMap.get(streamKey) != null) {
                return this.mVideoMultiViewMap.get(streamKey).getVideoScreenshot(streamKey);
            }
            ThunderLog.error(TAG, "stream %s not exist, cannot get video screenshot", streamKey);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoFrameObserver(long uid, String strUid, Object observer) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "addVideoFrameObserver uid: %d, strUid: %s, observer %s", uid, strUid, observer.toString());
        }
        try {
            s_observerLock.writeLock().lock();
            if (this.mVideoDecodeObserverMap.get(uid) == null) {
                this.mVideoDecodeObserverMap.put(uid, new StrUidVideoDecodeObserver());
            }
            this.mVideoDecodeObserverMap.get(uid).setStrUid(strUid);
            this.mVideoDecodeObserverMap.get(uid).setObserver((IVideoDecodeObserver)observer);
        }
        catch (Exception e) {
            ThunderLog.error(TAG, "addVideoFrameObserver err=%s", e.toString());
        }
        finally {
            s_observerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVideoFrameObserver(long uid, String strUid) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "removeVideoFrameObserver uid: %d, strUid %s", uid, strUid);
        }
        try {
            s_observerLock.writeLock().lock();
            if (this.mVideoDecodeObserverMap.get(uid) != null) {
                this.mVideoDecodeObserverMap.get(uid).removeObserver();
            }
            if (this.mC2JavaUidMap.containsValue(uid)) {
                for (Long key : this.mC2JavaUidMap.keySet()) {
                    if (this.mC2JavaUidMap.get(key) != uid) continue;
                    this.mC2JavaUidMap.remove(key);
                    break;
                }
            }
            if (null != this.mUidToVideoIdCallBackInDualStreamMap.get(uid)) {
                this.mUidToVideoIdCallBackInDualStreamMap.remove(uid);
            }
        }
        catch (Exception e) {
            ThunderLog.error(TAG, "removeVideoFrameObserver err=%s", e.toString());
        }
        finally {
            s_observerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoFrameObserverInDualStream(long uid32, long streamId, Object observer) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "addVideoFrameObserverInDualStream uid: %d, streamId: %d", uid32, streamId);
        }
        try {
            s_observerLock.writeLock().lock();
            this.mUidToVideoIdCallBackInDualStreamMap.put(uid32, streamId);
        }
        catch (Exception e) {
            ThunderLog.error(TAG, "addVideoFrameObserverInDualStream err=%s", e.toString());
        }
        finally {
            s_observerLock.writeLock().unlock();
        }
    }

    public boolean updatePlayVideoView(String streamKey, Object toView, int scaleMode, int mirrorMode) {
        if (streamKey == null || streamKey.isEmpty()) {
            return false;
        }
        final String f_streamKey = streamKey;
        final Object f_toView = toView;
        final int f_scaleMode = scaleMode;
        final int f_mirrorMode = mirrorMode;
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "updatePlayVideoView streamKey:" + streamKey + " toView:" + toView + " scaleMode:" + scaleMode + " mirrorMode:" + mirrorMode);
        }
        if (this.mThunderVideoHandler != null) {
            if (Thread.currentThread().getId() == this.mThunderVideoHandler.getLooper().getThread().getId()) {
                if (!this.mThunderPlayerMultiViewMode.get()) {
                    this.updateNormalPlayVideoView(f_streamKey, f_toView, f_scaleMode, f_mirrorMode);
                } else {
                    if (f_toView == null) {
                        return false;
                    }
                    if (this.mVideoMultiViewMap.get(f_streamKey) == null) {
                        return false;
                    }
                    if (this.mVideoMultiViewMap.get(f_streamKey).getVideoPlayerView() != null && !((Object)((Object)this.mVideoMultiViewMap.get(f_streamKey).getVideoPlayerView())).equals(f_toView)) {
                        ThunderLog.warn(TAG, "may toView is change!");
                        return false;
                    }
                    this.mMultiVideoMirrorModeMap.put(f_streamKey, f_mirrorMode);
                    this.mMultiVideoScaleModeMap.put(f_streamKey, f_scaleMode);
                    this.mVideoMultiViewMap.get(f_streamKey).setMirrorMode(f_streamKey, f_mirrorMode);
                    this.mVideoMultiViewMap.get(f_streamKey).setScaleMode(f_streamKey, f_scaleMode);
                }
            } else {
                this.mThunderVideoHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!ThunderVideoPlayEngineImp.this.mThunderPlayerMultiViewMode.get()) {
                            ThunderVideoPlayEngineImp.this.updateNormalPlayVideoView(f_streamKey, f_toView, f_scaleMode, f_mirrorMode);
                        } else {
                            if (f_toView == null) {
                                return;
                            }
                            if (ThunderVideoPlayEngineImp.this.mVideoMultiViewMap.get(f_streamKey) == null) {
                                return;
                            }
                            if (((ThunderPlayerMultiViewProxy)ThunderVideoPlayEngineImp.this.mVideoMultiViewMap.get(f_streamKey)).getVideoPlayerView() != null && !((Object)((Object)((ThunderPlayerMultiViewProxy)ThunderVideoPlayEngineImp.this.mVideoMultiViewMap.get(f_streamKey)).getVideoPlayerView())).equals(f_toView)) {
                                ThunderLog.warn(ThunderVideoPlayEngineImp.TAG, "may toView is change!");
                                return;
                            }
                            ThunderVideoPlayEngineImp.this.mMultiVideoMirrorModeMap.put(f_streamKey, f_mirrorMode);
                            ThunderVideoPlayEngineImp.this.mMultiVideoScaleModeMap.put(f_streamKey, f_scaleMode);
                            ((ThunderPlayerMultiViewProxy)ThunderVideoPlayEngineImp.this.mVideoMultiViewMap.get(f_streamKey)).setMirrorMode(f_streamKey, f_mirrorMode);
                            ((ThunderPlayerMultiViewProxy)ThunderVideoPlayEngineImp.this.mVideoMultiViewMap.get(f_streamKey)).setScaleMode(f_streamKey, f_scaleMode);
                        }
                    }
                });
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onVideoStreamArrive(String streamKey, long streamId, String strUid) {
        VideoDecodeRuntimeInfo.instance().addVideoStream(streamId, strUid);
        ThunderLog.release(TAG, "onVideoStreamArrive:%s-%d strUid:%s", streamKey, streamId, strUid);
        if (this.mThunderVideoHandler != null) {
            final String f_streamKey = streamKey;
            final long f_streamId = streamId;
            final String f_strUid = strUid;
            if (Thread.currentThread().getId() == this.mThunderVideoHandler.getLooper().getThread().getId()) {
                if (!this.mThunderPlayerMultiViewMode.get()) {
                    this.mStreamKeyStrUidMap.put(f_streamKey, f_strUid);
                    this.updatePlayNormalVideoStream(f_streamKey, f_streamId);
                } else {
                    this.mMultiStreamKeyIdMap.put(f_streamKey, f_streamId);
                    this.mStreamKeyStrUidMap.put(f_streamKey, f_strUid);
                    this.startPlayVideoStreamArrive(f_streamKey, f_streamId);
                }
            } else {
                this.mThunderVideoHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!ThunderVideoPlayEngineImp.this.mThunderPlayerMultiViewMode.get()) {
                            ThunderVideoPlayEngineImp.this.mStreamKeyStrUidMap.put(f_streamKey, f_strUid);
                            ThunderVideoPlayEngineImp.this.updatePlayNormalVideoStream(f_streamKey, f_streamId);
                        } else {
                            ThunderVideoPlayEngineImp.this.mMultiStreamKeyIdMap.put(f_streamKey, f_streamId);
                            ThunderVideoPlayEngineImp.this.mStreamKeyStrUidMap.put(f_streamKey, f_strUid);
                            ThunderVideoPlayEngineImp.this.startPlayVideoStreamArrive(f_streamKey, f_streamId);
                        }
                    }
                });
            }
        }
        try {
            s_observerLock.writeLock().lock();
            if (this.mC2JavaUidMap.get(streamId >> 32) != null) {
                long uid32 = this.mC2JavaUidMap.get(streamId >> 32);
                if (this.mVideoDecodeObserverMap.get(uid32) == null) {
                    this.mVideoDecodeObserverMap.put(uid32, new StrUidVideoDecodeObserver());
                }
                this.mVideoDecodeObserverMap.get(uid32).setbObserverEnable(true);
            }
        }
        catch (Exception e) {
            ThunderLog.error(TAG, "onVideoStreamArrive err=%s", e.toString());
        }
        finally {
            s_observerLock.writeLock().unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onVideoStreamStop(String streamKey, long streamId) {
        ThunderLog.release(TAG, "onVideoStreamStop streamKey:" + streamKey + " streamId:" + streamId);
        try {
            s_observerLock.readLock().lock();
            if (this.mC2JavaUidMap.get(streamId >> 32) != null) {
                long uid32 = this.mC2JavaUidMap.get(streamId >> 32);
                StrUidVideoDecodeObserver observer = this.mVideoDecodeObserverMap.get(uid32);
                if (observer != null) {
                    observer.setbObserverEnable(false);
                }
                if (null != this.mUidToVideoIdCallBackInDualStreamMap.get(uid32)) {
                    this.mUidToVideoIdCallBackInDualStreamMap.remove(uid32);
                }
            }
        }
        catch (Exception e) {
            ThunderLog.error(TAG, "onVideoStreamStop err=%s", e.toString());
        }
        finally {
            s_observerLock.readLock().unlock();
        }
        VideoDecodeRuntimeInfo.instance().removeVideoStream(streamId);
        return 0;
    }

    public void setVideoPlayEngineCallBack(long ptr) {
        mCallBackPtr = ptr;
    }

    public static String getVideoPlayLibVersion() {
        return "200.3.4.100.2";
    }

    public String getAudienceHiidoStatInfo(long streamId) {
        String audienceStat = "";
        if (this.mVideoPlayHiidoUtil != null) {
            ThunderVideoPlayEngineImp thunderVideoPlayEngineImp = this;
            audienceStat = thunderVideoPlayEngineImp.mVideoPlayHiidoUtil.getAudienceStatInfo();
        }
        return audienceStat;
    }

    public long getPlayRuntimeInfo(long streamId, int type) {
        switch (type) {
            case 0: {
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.FRAME);
            }
            case 1: {
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.BITRATE);
            }
            case 2: {
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
            }
            case 3: {
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.DECODERTYPE);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryOnlyDecoded(long streamId, long uid) {
        boolean result = false;
        try {
            s_observerLock.readLock().lock();
            this.mC2JavaUidMap.put(streamId >> 32, uid);
            StrUidVideoDecodeObserver strUidObserver = null;
            IVideoDecodeObserver observer = null;
            if (this.mVideoDecodeObserverMap != null && !this.mVideoDecodeObserverMap.isEmpty() && (strUidObserver = this.mVideoDecodeObserverMap.get(uid)) != null) {
                observer = strUidObserver.getObserver();
            }
            result = strUidObserver != null && observer != null;
        }
        catch (Exception e) {
            ThunderLog.error(TAG, "queryOnlyDecoded err=%s", e.toString());
        }
        finally {
            s_observerLock.readLock().unlock();
        }
        return result;
    }

    public void initMultiPlayerViewLayout(Object params) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "initMultiPlayerViewLayout params:" + params);
        }
        if (this.mThunderVideoHandler != null && params != null) {
            final ThunderMultiVideoViewParam f_params = (ThunderMultiVideoViewParam)params;
            final ThunderVideoPlayEngineImp engine = this;
            if (Thread.currentThread().getId() == this.mThunderVideoHandler.getLooper().getThread().getId()) {
                this.initMultiLayout(f_params, engine);
            } else {
                this.mThunderVideoHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderVideoPlayEngineImp.this.initMultiLayout(f_params, engine);
                    }
                });
            }
        }
    }

    private void initMultiLayout(ThunderMultiVideoViewParam layoutParam, ThunderVideoPlayEngineImp engine) {
        if (layoutParam == null) {
            ThunderLog.error(TAG, "initMultiPlayerViewLayout params null");
            return;
        }
        if (this.mThunderPlayerMultiViewMode.get()) {
            ThunderPlayerMultiViewProxy proxy;
            int viewId = layoutParam.mViewId;
            Object multiView = layoutParam.mView;
            ThunderLog.error(TAG, "initMultiPlayerViewLayout params:" + layoutParam + "  mView:" + multiView + " viewId:" + viewId);
            if (viewId >= 0) {
                proxy = null;
                if (multiView != null && this.checkMultiViewExist(multiView, viewId)) {
                    ThunderLog.error(TAG, "repeated view, already exist\uff0c" + multiView);
                    int oldViewId = this.getMultiViewId(multiView);
                    if (oldViewId < 0 && oldViewId != -4001) {
                        this.mThunderPlayerMultiViewProxyMap.put(viewId, this.mThunderPlayerMultiViewProxyMap.remove(oldViewId));
                    }
                    if (this.mThunderPlayerMultiViewProxyMap.containsKey(viewId)) {
                        this.mThunderPlayerMultiViewProxyMap.get(viewId).initMultiPlayerViewLayout(layoutParam);
                    }
                    return;
                }
                if (this.mThunderPlayerMultiViewProxyMap.get(viewId) == null) {
                    proxy = new ThunderPlayerMultiViewProxy(YYVideoLibMgr.instance().getAppContext(), engine);
                    this.mThunderPlayerMultiViewProxyMap.put(viewId, proxy);
                }
                this.mThunderPlayerMultiViewProxyMap.get(viewId).initMultiPlayerViewLayout(layoutParam);
                this.mThunderPlayerMultiViewProxyMap.get(viewId).updateMultiPlayerView(multiView);
            }
            if (viewId < 0) {
                proxy = null;
                if (this.mThunderPlayerMultiViewProxyMap.get(viewId) == null) {
                    proxy = new ThunderPlayerMultiViewProxy(YYVideoLibMgr.instance().getAppContext(), engine);
                    this.mThunderPlayerMultiViewProxyMap.put(viewId, proxy);
                }
                this.mThunderPlayerMultiViewProxyMap.get(viewId).initMultiPlayerViewLayout(layoutParam);
            }
            if (multiView == null && viewId >= 0 && this.mThunderPlayerMultiViewProxyMap.containsKey(viewId)) {
                this.mThunderPlayerMultiViewProxyMap.remove(viewId);
            }
        }
    }

    public void onPlayEngineLeaveRoom() {
        if (Thread.currentThread().getId() == this.mThunderVideoHandler.getLooper().getThread().getId()) {
            for (Map.Entry<Integer, ThunderPlayerMultiViewProxy> entry : this.mThunderPlayerMultiViewProxyMap.entrySet()) {
                ThunderPlayerMultiViewProxy proxy = entry.getValue();
                if (proxy == null) continue;
                proxy.quitRoom();
                proxy.destroyVideoPlayerView();
            }
            this.mVideoMultiViewMap.clear();
            this.mVideoMultiViewRecoverMap.clear();
            this.mStreamKeyStrUidMap.clear();
        } else {
            this.mThunderVideoHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : ThunderVideoPlayEngineImp.this.mThunderPlayerMultiViewProxyMap.entrySet()) {
                        ThunderPlayerMultiViewProxy proxy = (ThunderPlayerMultiViewProxy)entry.getValue();
                        if (proxy == null) continue;
                        proxy.quitRoom();
                        proxy.destroyVideoPlayerView();
                    }
                    ThunderVideoPlayEngineImp.this.mVideoMultiViewMap.clear();
                    ThunderVideoPlayEngineImp.this.mVideoMultiViewRecoverMap.clear();
                    ThunderVideoPlayEngineImp.this.mStreamKeyStrUidMap.clear();
                }
            });
        }
    }

    public void setVideoPlayType(int playType) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "setVideoPlayType playType:" + playType);
        }
        final int f_playType = playType;
        if (this.mThunderVideoHandler != null) {
            if (Thread.currentThread().getId() == this.mThunderVideoHandler.getLooper().getThread().getId()) {
                this.setRemotePlayType(f_playType);
            } else {
                this.mThunderVideoHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderVideoPlayEngineImp.this.setRemotePlayType(f_playType);
                    }
                });
            }
        }
    }

    private void setRemotePlayType(int playType) {
        if (playType == 1) {
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "multiLianMai mode " + playType);
            }
            this.mThunderPlayerMultiViewMode.set(true);
        } else {
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "non-multiLianMai mode " + playType);
            }
            this.clearMultiView();
            this.mThunderPlayerMultiViewProxyMap.clear();
            this.mVideoMultiViewMap.clear();
            this.mVideoMultiViewRecoverMap.clear();
            this.mStreamKeyStrUidMap.clear();
            this.mThunderPlayerMultiViewMode.set(false);
        }
    }

    private void initDefaultMultiViewParam(int viewId) {
        ThunderMultiVideoViewParam param = new ThunderMultiVideoViewParam();
        ThunderMultiVideoViewCoordinate coordinate = new ThunderMultiVideoViewCoordinate();
        coordinate.mIndex = 0;
        coordinate.mHeight = -2;
        coordinate.mWidth = -2;
        coordinate.mX = 0;
        coordinate.mY = 0;
        param.mVideoViewPositions = new ArrayList(1);
        param.mVideoViewPositions.add(coordinate);
        param.mViewId = viewId;
        this.initMultiPlayerViewLayout(param);
    }

    private boolean updateSeat(String streamKey, Object toView, int seat) {
        boolean result = false;
        Object view = toView;
        if (view == null) {
            ThunderLog.error(TAG, "updateUserSeat toView null");
            return false;
        }
        if (this.mVideoMultiViewMap.get(streamKey) != null && this.findMultiViewProxy(view) != null) {
            int mirrorMode;
            int scaleMode;
            boolean bl = result = this.mVideoMultiViewMap.get(streamKey).updateSeat(streamKey, seat) >= 0;
            if (!result) {
                return false;
            }
            int n = scaleMode = this.mMultiVideoScaleModeMap.get(streamKey) == null ? -1 : this.mMultiVideoScaleModeMap.get(streamKey);
            if (scaleMode != -1) {
                this.mVideoMultiViewMap.get(streamKey).setScaleMode(streamKey, scaleMode);
            }
            int n2 = mirrorMode = this.mMultiVideoMirrorModeMap.get(streamKey) == null ? -1 : this.mMultiVideoMirrorModeMap.get(streamKey);
            if (mirrorMode != -1) {
                this.mVideoMultiViewMap.get(streamKey).setMirrorMode(streamKey, mirrorMode);
            }
        }
        return true;
    }

    public boolean updateUserSeat(String streamKey, Object toView, int seat) {
        ThunderLog.release(TAG, "updateUserSeat streamKey:" + streamKey + " toView:" + toView + " seat:" + seat);
        if (this.mThunderVideoHandler != null) {
            final String f_streamKey = streamKey;
            final Object f_toView = toView;
            final int f_seat = seat;
            if (Thread.currentThread().getId() == this.mThunderVideoHandler.getLooper().getThread().getId()) {
                boolean result = false;
                if (this.mThunderPlayerMultiViewMode.get()) {
                    this.updateSeat(f_streamKey, f_toView, f_seat);
                }
            } else {
                this.mThunderVideoHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThunderVideoPlayEngineImp.this.updateSeat(f_streamKey, f_toView, f_seat);
                    }
                });
            }
        }
        return true;
    }

    public ThunderPlayerMultiViewProxy findMultiViewProxy(Object view) {
        for (Map.Entry<Integer, ThunderPlayerMultiViewProxy> entry : this.mThunderPlayerMultiViewProxyMap.entrySet()) {
            ThunderPlayerMultiViewProxy proxy = entry.getValue();
            if (proxy.getVideoPlayerView() != view) continue;
            return proxy;
        }
        return null;
    }

    public boolean checkMultiViewExist(Object view, int viewId) {
        if (view == null || viewId < 0) {
            return false;
        }
        for (Map.Entry<Integer, ThunderPlayerMultiViewProxy> entry : this.mThunderPlayerMultiViewProxyMap.entrySet()) {
            ThunderPlayerMultiViewProxy proxy = entry.getValue();
            if (proxy.getVideoPlayerView() != view || entry.getKey() == viewId) continue;
            ThunderLog.error(TAG, "view " + view + "already locate in viewId:" + entry.getKey());
            return true;
        }
        return false;
    }

    private int getMultiViewId(Object view) {
        if (view == null) {
            return -4001;
        }
        for (Map.Entry<Integer, ThunderPlayerMultiViewProxy> entry : this.mThunderPlayerMultiViewProxyMap.entrySet()) {
            ThunderPlayerMultiViewProxy proxy = entry.getValue();
            if (proxy.getVideoPlayerView() != view) continue;
            return entry.getKey();
        }
        return -4001;
    }

    public void clearMultiView() {
        for (Map.Entry<Integer, ThunderPlayerMultiViewProxy> entry : this.mThunderPlayerMultiViewProxyMap.entrySet()) {
            ThunderPlayerMultiViewProxy proxy = entry.getValue();
            if (proxy == null) continue;
            proxy.destroyVideoPlayerView();
        }
    }

    public void destroyPlayEngine() {
        YMFPlayerUsrBehaviorStat.getInstance().setYMFBehaviorEventListener(null);
        if (this.mVideoPlayHiidoUtil != null) {
            this.mVideoPlayHiidoUtil.unRegister();
        }
        try {
            if (this.mThunderVideoHandler != null) {
                if (Build.VERSION.SDK_INT >= 18) {
                    this.mThunderVideoHandlerThread.quitSafely();
                } else {
                    this.mThunderVideoHandlerThread.quit();
                }
                this.mThunderVideoHandler = null;
                this.mThunderVideoHandlerThread = null;
            }
            s_observerLock.writeLock().lock();
            this.mVideoDecodeObserverMap.clear();
            this.mUidToVideoIdCallBackInDualStreamMap.clear();
            this.clearMultiView();
            this.mThunderPlayerMultiViewProxyMap.clear();
        }
        catch (Exception e) {
            ThunderLog.error(TAG, "destroyPlayEngine err=%s", e.toString());
        }
        finally {
            s_observerLock.writeLock().unlock();
        }
    }

    private boolean updateNormalPlayVideoView(String streamKey, Object toView, int scaleMode, int mirrorMode) {
        VideoStreamInfo info = this.mVideoStreamInfoMap.get(streamKey);
        if (info == null) {
            ThunderLog.error(TAG, "updatePlayVideoView unexist info key:" + streamKey);
            return false;
        }
        if (toView != null && !(toView instanceof ThunderPlayerView)) {
            ThunderLog.error(TAG, "updateNormalPlayVideoView toView error:" + toView);
            return false;
        }
        long streamId = info.getStreamId();
        ThunderPlayerView newView = (ThunderPlayerView)((Object)toView);
        ThunderPlayerView oldView = info.getThunderPlayerView();
        ThunderLog.release(TAG, "updateNormalPlayVideoView key " + streamKey + " toView " + toView + " oldView " + (Object)((Object)oldView) + " scaleMode " + scaleMode + " mirrorMode " + mirrorMode);
        if (oldView == null && null == newView) {
            return false;
        }
        if (oldView == null && null != newView) {
            info.setThunderPlayerView(newView);
            newView.unLinkFromStream();
            if (-1L != streamId) {
                newView.linkToStream(streamId);
                newView.setScaleMode(scaleMode);
                newView.setMirrorMode(-1, mirrorMode);
                info.setScaleMode(scaleMode);
                info.setMirrorMode(mirrorMode);
            }
            return true;
        }
        if (oldView != null && null == newView) {
            if (-1L != streamId) {
                oldView.unLinkFromStream();
                oldView.drawBlackScreen(true);
            }
            info.setThunderPlayerView(null);
            return true;
        }
        if (toView instanceof ThunderPlayerView && !((Object)((Object)oldView)).equals(toView)) {
            ThunderLog.warn(TAG, "may toView is change!");
            return false;
        }
        info.setScaleMode(scaleMode);
        info.setMirrorMode(mirrorMode);
        oldView.setScaleMode(scaleMode);
        oldView.setMirrorMode(-1, mirrorMode);
        return true;
    }

    private int startPlayNormalVideoStream(String streamKey, Object toView, int scaleMode, int mirrorMode) {
        ThunderPlayerView existedView = null;
        ThunderLog.release(TAG, "startPlayNormalVideoStream key:%s, scaleMode:%d, mirrorMode:%d", streamKey, scaleMode, mirrorMode);
        this.checkStartPlayDualStream(streamKey);
        VideoStreamInfo streamInfo = this.getStreamInfo(streamKey);
        existedView = streamInfo.getThunderPlayerView();
        if (toView != null && toView instanceof ThunderPlayerView) {
            ThunderPlayerView view = (ThunderPlayerView)((Object)toView);
            if (existedView != null) {
                if (!((Object)((Object)view)).equals((Object)existedView)) {
                    existedView.unLinkFromStream();
                    existedView.drawBlackScreen(true);
                    ThunderLog.release(TAG, "startPlayNormalVideoStream changed view old:" + (Object)((Object)existedView) + " new:" + (Object)((Object)view));
                } else if (ThunderLog.isInfoValid()) {
                    ThunderLog.info(TAG, "startPlayNormalVideoStream the same view old:" + (Object)((Object)existedView) + " new:" + (Object)((Object)view));
                }
            }
            view.setScaleMode(scaleMode);
            view.setMirrorMode(-1, mirrorMode);
            streamInfo.setThunderPlayerView(view);
        }
        if ((existedView = streamInfo.getThunderPlayerView()) != null) {
            if (!streamInfo.isViewPrepared()) {
                existedView.unLinkFromStream();
                if (streamInfo.getStreamId() != -1L) {
                    existedView.linkToStream(streamInfo.getStreamId());
                }
            }
            if (!streamInfo.isLinkedToStream()) {
                if (streamInfo.getStreamId() != -1L) {
                    existedView.linkToStream(streamInfo.getStreamId());
                    ThunderLog.release(TAG, "startPlayNormalVideoStream linkToStream %d", streamInfo.getStreamId());
                }
            } else {
                ThunderLog.warn(TAG, "startPlayNormalVideoStream has linkedToStream %d", streamInfo.getStreamId());
            }
        } else {
            ThunderLog.warn(TAG, "ERROR startPlayNormalVideoStream view is null");
        }
        streamInfo.setScaleMode(scaleMode);
        streamInfo.setMirrorMode(mirrorMode);
        return 0;
    }

    private int stopPlayNormalVideoStream(String streamKey) {
        VideoStreamInfo info = this.mVideoStreamInfoMap.get(streamKey);
        ThunderPlayerView view = null;
        if (info == null) {
            ThunderLog.release(TAG, "ERROR stopPlayNormalVideoStream unexsited key:%s", streamKey);
            return -1;
        }
        ThunderLog.release(TAG, "stopPlayNormalVideoStream %s", streamKey);
        view = info.getThunderPlayerView();
        if (view != null) {
            view.unLinkFromStream();
            view.drawBlackScreen(true);
        } else {
            ThunderLog.release(TAG, "ERROR stopPlayNormalVideoStream unexsited view");
        }
        this.mVideoStreamInfoMap.remove(streamKey);
        return 0;
    }

    private int onNormalVideoStreamStop(String streamKey, long streamId) {
        VideoStreamInfo info = this.mVideoStreamInfoMap.get(streamKey);
        if (info == null) {
            ThunderLog.release(TAG, "onVideoStreamStop key:%s unexisted", streamKey);
            return -1;
        }
        ThunderPlayerView view = info.getThunderPlayerView();
        if (view == null) {
            ThunderLog.warn(TAG, "onVideoStreamStop: cann't find video view for stream:%s", streamKey);
            return -1;
        }
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "unlink stream:%s-%d", streamKey, streamId);
        }
        view.unLinkFromStream(streamId);
        return 0;
    }

    private int startPlayMultiVideoStream(String streamKey, Object toView, int scaleMode, int mirrorMode, int encodeType, boolean bSupportHdwDecode) {
        Object view = toView;
        if (view != null) {
            ThunderPlayerMultiViewProxy proxy = this.findMultiViewProxy(view);
            if (proxy != null) {
                if (this.mVideoMultiViewMap.get(streamKey) != null) {
                    ThunderPlayerMultiViewProxy old = this.mVideoMultiViewMap.get(streamKey);
                    if (old != null && old != proxy) {
                        old.unlink(streamKey);
                    }
                    this.mVideoMultiViewRecoverMap.put(streamKey, old);
                }
                this.mVideoMultiViewMap.put(streamKey, proxy);
                this.checkStartPlayDualStream(streamKey);
            } else {
                ThunderLog.warn(TAG, "initMultiPlayerViewLayout not called " + toView);
                ThunderPlayerMultiViewProxy old = this.mVideoMultiViewMap.get(streamKey);
                if (old != null) {
                    old.unlink(streamKey);
                }
                int viewId = this.getDefaultViewId();
                this.initDefaultMultiViewParam(viewId);
                ThunderPlayerMultiViewProxy defaultProxy = this.mThunderPlayerMultiViewProxyMap.get(viewId);
                if (defaultProxy != null) {
                    defaultProxy.updateMultiPlayerView(view);
                }
                this.mVideoMultiViewMap.put(streamKey, defaultProxy);
                this.checkStartPlayDualStream(streamKey);
            }
        }
        if (this.mVideoMultiViewMap.get(streamKey) != null && this.mVideoMultiViewMap.get(streamKey).getVideoPlayerView() != null && view == null) {
            this.mVideoMultiViewMap.get(streamKey).unlink(streamKey);
            ThunderLog.release(TAG, "startPlayMultiVideoStream unlink key" + streamKey + " view " + view);
            return 0;
        }
        this.mMultiVideoScaleModeMap.put(streamKey, scaleMode);
        this.mMultiVideoMirrorModeMap.put(streamKey, mirrorMode);
        long streamId = this.mMultiStreamKeyIdMap.get(streamKey) == null ? -1L : this.mMultiStreamKeyIdMap.get(streamKey);
        this.updatePlayMultiVideoStream(streamKey, streamId);
        ThunderLog.release(TAG, "startPlayMultiVideoStream key:%s, streamType:%d, scaleMode:%d, mirrorMode:%d, bSupportHdwDecode:%b", streamKey, encodeType, scaleMode, mirrorMode, bSupportHdwDecode);
        return 0;
    }

    private int getDefaultViewId() {
        int viewId;
        for (viewId = -1; viewId > Integer.MIN_VALUE && this.mThunderPlayerMultiViewProxyMap.containsKey(viewId); --viewId) {
        }
        return viewId;
    }

    private VideoStreamInfo getStreamInfo(String streamKey) {
        VideoStreamInfo streamInfo = null;
        boolean isExistedKey = this.mVideoStreamInfoMap.containsKey(streamKey);
        if (!isExistedKey) {
            streamInfo = new VideoStreamInfo();
            this.mVideoStreamInfoMap.put(streamKey, streamInfo);
        } else {
            streamInfo = this.mVideoStreamInfoMap.get(streamKey);
        }
        return streamInfo;
    }

    private int updatePlayMultiVideoStream(String streamKey, long streamId) {
        ThunderLog.release(TAG, "updatePlayVideoStream streamKey:" + streamKey + " streamId " + streamId);
        if (streamKey == null) {
            ThunderLog.error(TAG, "updatePlayMultiVideoStream, streamKey null");
            return -4001;
        }
        if (this.mVideoMultiViewMap.get(streamKey) != null) {
            ThunderLog.release(TAG, "updatePlayVideoStream, bindStreamToSeat streamKey " + streamKey + " streamId " + streamId);
            this.mVideoMultiViewMap.get(streamKey).prepareStreamSeat(streamKey, streamId);
        }
        return 0;
    }

    private int startPlayVideoStreamArrive(String streamKey, long streamId) {
        ThunderLog.release(TAG, "startPlayVideoStreamArrive streamKey:" + streamKey + " streamId " + streamId);
        if (streamKey == null) {
            ThunderLog.error(TAG, "updatePlayMultiVideoStream, streamKey null");
            return -4001;
        }
        if (this.mVideoMultiViewMap.get(streamKey) != null) {
            ThunderLog.release(TAG, "startPlayVideoStreamArrive, bindStreamToSeat streamKey " + streamKey + " streamId " + streamId);
            this.mVideoMultiViewMap.get(streamKey).bindStreamToSeat(streamKey, streamId, false);
        }
        return 0;
    }

    private int relinkStreamId(long streamId) {
        ThunderLog.release(TAG, "relinkStreamId streamId " + streamId);
        for (Map.Entry<String, Long> next : this.mMultiStreamKeyIdMap.entrySet()) {
            if (0 != next.getValue().compareTo(streamId)) continue;
            String streamKey = next.getKey();
            ThunderLog.release(TAG, "relinkStreamId found streamKey" + streamKey + " streamId: " + streamId);
            if (this.mVideoMultiViewMap.get(streamKey) == null) break;
            ThunderLog.release(TAG, "relinkStreamId, bindStreamToSeat streamKey " + streamKey + " streamId " + streamId);
            this.mVideoMultiViewMap.get(streamKey).bindStreamToSeat(streamKey, streamId, true);
            break;
        }
        return 0;
    }

    private int updatePlayNormalVideoStream(String streamKey, long streamId) {
        VideoStreamInfo streamInfo = this.getStreamInfo(streamKey);
        ThunderPlayerView view = streamInfo.getThunderPlayerView();
        if (view != null) {
            long oldStreamId = streamInfo.getStreamId();
            if (oldStreamId != -1L && oldStreamId != streamId && streamInfo.isLinkedToStream()) {
                view.unLinkFromStream(oldStreamId);
            }
            if (!streamInfo.isViewPrepared()) {
                view.unLinkFromStream();
            }
            if (!streamInfo.isLinkedToStream()) {
                view.linkToStream(streamId);
            }
            view.setScaleMode(streamInfo.getScaleMode());
            view.setMirrorMode(-1, streamInfo.getMirrorMode());
            view.drawBlackScreen(false);
        } else {
            ThunderLog.warn(TAG, "updatePlayNormalVideoStream: cannot find video view for stream:%s", streamKey);
        }
        streamInfo.setStreamId(streamId);
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "updatePlayNormalVideoStream key:%s,id:%d,isPrepared:%b,isLinked:%b", streamKey, streamId, streamInfo.isViewPrepared(), streamInfo.isLinkedToStream());
        }
        return 0;
    }

    private boolean switchDualVideoViewUI(String dstStreamKey, String srcStreamKey, int dstEncodeType) {
        if (!this.mThunderPlayerMultiViewMode.get()) {
            ThunderPlayerView dstStreamView;
            VideoStreamInfo srcStreamInfo = this.getStreamInfo(srcStreamKey);
            VideoStreamInfo dstStreamInfo = this.getStreamInfo(dstStreamKey);
            dstStreamInfo.setEncodeType(dstEncodeType);
            dstStreamInfo.setScaleMode(srcStreamInfo.getScaleMode());
            dstStreamInfo.setMirrorMode(srcStreamInfo.getMirrorMode());
            ThunderPlayerView srcStreamView = srcStreamInfo.getThunderPlayerView();
            if (srcStreamView != null) {
                srcStreamView.unLinkFromStream();
                dstStreamInfo.setThunderPlayerView(srcStreamView);
            }
            if ((dstStreamView = dstStreamInfo.getThunderPlayerView()) != null) {
                if (!dstStreamView.isViewPrepared()) {
                    dstStreamView.unLinkFromStream();
                    if (dstStreamInfo.getStreamId() != -1L) {
                        dstStreamView.linkToStream(dstStreamInfo.getStreamId());
                    }
                    ThunderLog.release(TAG, "switchDualVideoViewUI dstStreamView unPrepared, dstkey:%s, streamId %d", dstStreamKey, dstStreamInfo.getStreamId());
                }
                if (!dstStreamInfo.isLinkedToStream()) {
                    if (dstStreamInfo.getStreamId() != -1L) {
                        dstStreamView.linkToStream(dstStreamInfo.getStreamId());
                        ThunderLog.release(TAG, "switchDualVideoViewUI linkToStream dstkey:%s, streamId %d", dstStreamKey, dstStreamInfo.getStreamId());
                    }
                } else {
                    ThunderLog.release(TAG, "switchDualVideoViewUI has linkToStream dstkey:%s, streamId %d", dstStreamKey, dstStreamInfo.getStreamId());
                }
                this.mVideoStreamInfoMap.remove(srcStreamKey);
            } else {
                ThunderLog.release(TAG, "switchDualVideoViewUI normal view is null dstKey:%s, srcKey:%s", dstStreamKey, srcStreamKey);
            }
        } else {
            long dstStreamId;
            ThunderPlayerMultiViewProxy srcProxy = this.mVideoMultiViewMap.get(srcStreamKey);
            long l = dstStreamId = this.mMultiStreamKeyIdMap.get(dstStreamKey) == null ? -1L : this.mMultiStreamKeyIdMap.get(dstStreamKey);
            if (srcProxy != null && srcProxy.switchDualVideoView(srcStreamKey, dstStreamKey, dstStreamId) >= 0) {
                this.mVideoMultiViewMap.remove(srcStreamKey);
                this.mVideoMultiViewMap.put(dstStreamKey, srcProxy);
            }
            ThunderLog.release(TAG, "switchDualVideoViewUI multiView linkToStream dstkey:%s, srcKey:%s dstStreamId %d", dstStreamKey, srcStreamKey, dstStreamId);
        }
        return true;
    }

    private void checkStartPlayDualStream(String curStreamKey) {
        if (curStreamKey == null) {
            return;
        }
        if (!this.mStreamKeyStrUidMap.containsKey(curStreamKey)) {
            return;
        }
        String tmpStreamKey = null;
        String curUid = this.mStreamKeyStrUidMap.get(curStreamKey);
        if (curUid != null && this.mStreamKeyStrUidMap != null && this.mStreamKeyStrUidMap.size() > 0) {
            for (Map.Entry<String, String> entry : this.mStreamKeyStrUidMap.entrySet()) {
                String strUid = entry.getValue();
                if (!curUid.equals(strUid) || curStreamKey.equals(entry.getKey())) continue;
                tmpStreamKey = entry.getKey();
                ThunderLog.warn(TAG, "find dualStream duplicate streamKey:" + tmpStreamKey + " cur:" + curStreamKey + " uid:" + strUid);
            }
        }
        if (tmpStreamKey != null && !tmpStreamKey.isEmpty()) {
            if (this.mThunderPlayerMultiViewMode.get() && this.mVideoMultiViewMap.containsKey(tmpStreamKey)) {
                this.mVideoMultiViewMap.get(tmpStreamKey).unlink(tmpStreamKey);
                this.mVideoMultiViewMap.remove(tmpStreamKey);
                ThunderLog.warn(TAG, "remove dup streamKey:" + tmpStreamKey);
            }
            if (!this.mThunderPlayerMultiViewMode.get() && this.mVideoStreamInfoMap.containsKey(tmpStreamKey)) {
                if (this.mVideoStreamInfoMap.get(tmpStreamKey).getThunderPlayerView() != null && this.mVideoStreamInfoMap.get(tmpStreamKey).isLinkedToStream()) {
                    this.mVideoStreamInfoMap.get(tmpStreamKey).getThunderPlayerView().unLinkFromStream();
                }
                this.mVideoStreamInfoMap.remove(tmpStreamKey);
                ThunderLog.warn(TAG, "remove dup streamKey:" + tmpStreamKey);
            }
        }
    }

    public String getVideoDecodeBaseStatics(int sendSeq) {
        return YMFPlayerStatisticManager.getInstance().getVideoDecodeBaseStatistics(sendSeq);
    }

    public String getVideoDecodeStatics(boolean bKeyStat, long streamId) {
        String audienceStat = "";
        if (this.mVideoPlayHiidoUtil != null) {
            ThunderVideoPlayEngineImp thunderVideoPlayEngineImp = this;
            audienceStat = thunderVideoPlayEngineImp.mVideoPlayHiidoUtil.getAudienceStatInfo();
        }
        return YMFPlayerStatisticManager.getInstance().getVideoDecodeStatistics(bKeyStat, streamId) + audienceStat;
    }

    private native void onViewStateNotify(long var1, long var3, int var5);

    private native void onHardwareDecodeError(long var1, long var3, long var5, int var7);

    private native void onFirstFrameDecodeNotify(long var1, long var3, long var5, long var7);

    private native void onVideoRenderedFrames(long var1, ArrayList<VideoRenderNotify> var3);

    private native void onVideoDecodedFrames(long var1, VideoDecodeEventNotify var3);

    private native void onFirstFrameRender(long var1, long var3, int var5, int var6, long var7);

    private native void onMultiViewSeatInfoNotify(long var1, long var3, int var5);

    private class VideoStreamInfo {
        private long mStreamId = -1L;
        private ThunderPlayerView mThunderPlayerView = null;
        private int mIsSoftDecodeFlag = -1;
        private int mEncodeType = 1;
        private int mScaleMode = -1;
        private int mMirrorMode;

        public VideoStreamInfo() {
            ThunderLog.release(ThunderVideoPlayEngineImp.TAG, "VideoStreamInfo: " + this + " construct streamId:%d", this.mStreamId);
        }

        public long getStreamId() {
            return this.mStreamId;
        }

        public void setStreamId(long streamId) {
            this.mStreamId = streamId;
            ThunderLog.release(ThunderVideoPlayEngineImp.TAG, "VideoStreamInfo setStreamId " + streamId);
        }

        public ThunderPlayerView getThunderPlayerView() {
            return this.mThunderPlayerView;
        }

        public void setThunderPlayerView(ThunderPlayerView thunderPlayerView) {
            this.mThunderPlayerView = thunderPlayerView;
            if (thunderPlayerView != null) {
                ThunderLog.release(ThunderVideoPlayEngineImp.TAG, "VideoStreamInfo setThunderPlayerView streamId:" + this.mStreamId + " view:" + (Object)((Object)thunderPlayerView));
            } else {
                ThunderLog.error(ThunderVideoPlayEngineImp.TAG, "VideoStreamInfo setThunderPlayerView null");
            }
        }

        public int getIsSoftDecodeFlag() {
            return this.mIsSoftDecodeFlag;
        }

        public void setIsSoftDecodeFlag(int isSoftDecodeFlag) {
            this.mIsSoftDecodeFlag = isSoftDecodeFlag;
            ThunderLog.release(ThunderVideoPlayEngineImp.TAG, "VideoStreamInfo streamId:" + this.mStreamId + " setIsSoftDecodeFlag " + isSoftDecodeFlag);
        }

        public int getEncodeType() {
            return this.mEncodeType;
        }

        public void setEncodeType(int encodeType) {
            this.mEncodeType = encodeType;
            ThunderLog.release(ThunderVideoPlayEngineImp.TAG, "VideoStreamInfo streamId:" + this.mStreamId + " setEncodeType " + this.mEncodeType);
        }

        public int getScaleMode() {
            return this.mScaleMode;
        }

        public void setScaleMode(int scaleMode) {
            this.mScaleMode = scaleMode;
            ThunderLog.release(ThunderVideoPlayEngineImp.TAG, "VideoStreamInfo streamId:" + this.mStreamId + " setScaleMode " + scaleMode);
        }

        public void setMirrorMode(int mirrorMode) {
            this.mMirrorMode = mirrorMode;
            ThunderLog.release(ThunderVideoPlayEngineImp.TAG, "VideoStreamInfo streamId:" + this.mStreamId + " setMirrorMode " + mirrorMode);
        }

        public int getMirrorMode() {
            return this.mMirrorMode;
        }

        public boolean isLinkedToStream() {
            boolean result = false;
            if (this.mThunderPlayerView != null) {
                result = this.mThunderPlayerView.isViewLinkedToStream();
            }
            ThunderLog.release(ThunderVideoPlayEngineImp.TAG, "VideoStreamInfo streamId:" + this.mStreamId + " isLinkedToStream " + result);
            return result;
        }

        public boolean isViewPrepared() {
            boolean result = false;
            if (this.mThunderPlayerView != null) {
                result = this.mThunderPlayerView.isViewPrepared();
            }
            ThunderLog.release(ThunderVideoPlayEngineImp.TAG, "VideoStreamInfo: " + this + "  streamId:" + this.mStreamId + " isViewPrepared " + result);
            return result;
        }
    }

    public class StrUidVideoDecodeObserver {
        private String strUid;
        private IVideoDecodeObserver observer;
        private boolean bObserverEnable = false;

        public void setStrUid(String strUid) {
            this.strUid = strUid;
        }

        public String getStrUid() {
            return this.strUid;
        }

        public void setObserver(IVideoDecodeObserver observer) {
            this.observer = observer;
        }

        public IVideoDecodeObserver getObserver() {
            return this.observer;
        }

        public void removeObserver() {
            this.observer = null;
        }

        public void setbObserverEnable(boolean bObserverEnable) {
            this.bObserverEnable = bObserverEnable;
        }

        public boolean isbObserverEnable() {
            return this.bObserverEnable;
        }
    }
}

