/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.video.VideoPlayerView;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.videoplayer.YMFPlayerAPI;
import com.yy.videoplayer.view.YMFLayoutParams;
import com.yy.videoplayer.view.YMFVideoPosition;

public class ThunderPlayerView
extends VideoPlayerView {
    private final String TAG = "ThunderPlayerView " + Integer.toHexString(((Object)((Object)this)).hashCode());
    private YMFLayoutParams mYMFLayoutParams;
    private long mStreamId = 0L;
    private YMFPlayerAPI mYMFPlayerInstance = null;
    public final int INVALID_STREAM_ID = -1;

    public ThunderPlayerView(Context context) {
        super(context);
        this.createVideoView();
    }

    public ThunderPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createVideoView();
    }

    public ThunderPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.createVideoView();
    }

    public boolean isViewLinkedToStream() {
        return this.mStreamId != 0L;
    }

    public boolean isViewPrepared() {
        return this.mPrepared;
    }

    public boolean createVideoView() {
        if (this.mYMFPlayerInstance == null) {
            this.mYMFPlayerInstance = YMFPlayerAPI.newInstance();
        }
        this.mUniformView = this.mYMFPlayerInstance.createView(this.getContext());
        if (this.mUniformView != null) {
            this.addView(this.mUniformView);
            if (this.mYMFLayoutParams != null) {
                this.mYMFPlayerInstance.setViewLayout(this.mUniformView, this.mYMFLayoutParams);
            }
            this.mYMFPlayerInstance.setScaleMode(this.mUniformView, this.mScaleMode, -1);
            this.mPrepared = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkToStream(long streamId) {
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            if (this.mYMFPlayerInstance != null && this.mUniformView != null) {
                this.drawBlackScreen(false);
                this.mYMFPlayerInstance.linkStream(this.mUniformView, streamId, -1);
            }
            this.mStreamId = streamId;
        }
        ThunderLog.release("yvideo-Java", this.TAG + " linkToStream " + streamId);
    }

    @Override
    public int linkToStream(long streamId, int videoIndex) {
        ThunderLog.release("yvideo-Java", this.TAG + " linkToStream mUniformView " + this.mUniformView + " linkToStream " + streamId + " videoIndex " + videoIndex);
        if (streamId == 0L) {
            return -1;
        }
        if (videoIndex < 0) {
            return -1;
        }
        if (this.mUniformView == null) {
            return -1;
        }
        if (this.mYMFPlayerInstance != null) {
            this.drawBlackScreen(false);
            return this.mYMFPlayerInstance.linkStream(this.mUniformView, streamId, videoIndex);
        }
        return 0;
    }

    @Override
    public int unLinkFromStream(long streamId, int videoIndex) {
        ThunderLog.release("yvideo-Java", this.TAG + " unLinkFromStream mUniformView " + this.mUniformView + " linkToStream " + streamId + " videoIndex " + videoIndex);
        if (streamId == 0L) {
            return -1;
        }
        if (videoIndex < 0) {
            return -1;
        }
        if (this.mUniformView == null) {
            return -1;
        }
        if (this.mYMFPlayerInstance != null) {
            return this.mYMFPlayerInstance.unLinkStream(this.mUniformView, streamId, videoIndex);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLinkFromStream(long streamId) {
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            if (this.mYMFPlayerInstance != null && this.mUniformView != null) {
                this.mYMFPlayerInstance.unLinkStream(this.mUniformView, streamId, -1);
            }
            this.mStreamId = 0L;
        }
        ThunderLog.release("yvideo-Java", this.TAG + " unLinkFromStream " + streamId);
    }

    public void unLinkFromStream() {
        if (this.mYMFPlayerInstance != null && this.mUniformView != null) {
            this.mYMFPlayerInstance.unLinkStream(this.mUniformView, this.mStreamId, -1);
        }
        this.mStreamId = 0L;
        ThunderLog.release("yvideo-Java", this.TAG + " unLinkFromStream() ");
    }

    public boolean setScaleMode(int scaleMode) {
        boolean result = false;
        this.mScaleMode = this.scaleModeConvert(scaleMode);
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setScaleMode(this.mUniformView, this.mScaleMode, -1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setScaleMode(int seatId, int scaleMode) {
        boolean result = false;
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            this.mScaleMode = this.scaleModeConvert(scaleMode);
            if (this.mYMFPlayerInstance != null) {
                this.mYMFPlayerInstance.setScaleMode(this.mUniformView, this.mScaleMode, seatId);
            }
        }
        return result;
    }

    @Override
    public void setMirrorMode(int seatId, int mirrorMode) {
        this.mMirrorMode = this.mirrorModeConvert(mirrorMode);
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setMirrorMode(this.mUniformView, this.mMirrorMode, seatId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getVideoScreenshot(int seatId) {
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            if (this.mYMFPlayerInstance != null) {
                return this.mYMFPlayerInstance.getVideoScreenshot(this.mUniformView, seatId);
            }
        }
        return null;
    }

    public void drawBlackScreen(boolean black) {
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setLastFrameRenderBlack(this.mUniformView, black);
        }
    }

    @Override
    public void updateMultiViewLayout(YMFLayoutParams params) {
        this.mYMFLayoutParams = params;
        this.drawBlackScreen(false);
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setViewLayout(this.mUniformView, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterMultiVideoViewMode(YMFLayoutParams multiVideoViewParams, Constant.MultiLianmaiMode lianmaiMode) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(this.TAG, "enterMultiVideoViewMode multiVideoViewParams = [" + multiVideoViewParams + "], lianmaiMode=" + lianmaiMode);
        }
        if (multiVideoViewParams == null) {
            YMFLayoutParams params = new YMFLayoutParams(1);
            YMFVideoPosition videoPosition = new YMFVideoPosition();
            videoPosition.mIndex = 0;
            videoPosition.mX = 0;
            videoPosition.mY = 0;
            videoPosition.mHeight = -2;
            videoPosition.mWidth = -2;
            params.mDrawPosition[0] = videoPosition;
            this.setUseMultiVideoView(params);
            return;
        }
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            YYVideoSDK.getInstance().setMultiVideoLianmaiMode(lianmaiMode);
            this.setUseMultiVideoView(multiVideoViewParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leaveMultiVideoViewMode() {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(this.TAG, "leaveMultiVideoViewMode ");
        }
        ThunderPlayerView thunderPlayerView = this;
        synchronized (thunderPlayerView) {
            this.setUseMultiVideoView(null);
            YYVideoSDK.getInstance().setMultiVideoLianmaiMode(Constant.MultiLianmaiMode.NormalMode);
        }
    }

    private void setUseMultiVideoView(YMFLayoutParams multiVideoViewParams) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(this.TAG, "setUseMultiVideoView");
        }
        this.mYMFLayoutParams = multiVideoViewParams;
        this.drawBlackScreen(false);
        if (this.mYMFPlayerInstance != null) {
            this.mYMFPlayerInstance.setViewLayout(this.mUniformView, this.mYMFLayoutParams);
        }
    }

    @Override
    public int switchDualVideoView(long oldStreamId, long newStreamId, int seatId) {
        if (oldStreamId == 0L || newStreamId == 0L || this.mUniformView == null) {
            return -1;
        }
        if (this.mYMFPlayerInstance != null && this.mUniformView != null) {
            return this.mYMFPlayerInstance.switchDualVideoView(this.mUniformView, oldStreamId, newStreamId, seatId);
        }
        return -1;
    }
}

