/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.SparseArray;
import com.thunder.livesdk.ThunderMultiVideoViewParam;
import com.thunder.livesdk.log.ThunderLog;
import com.thunder.livesdk.video.ThunderMultiVideoViewCoordinate;
import com.thunder.livesdk.video.ThunderPlayerMultiView;
import com.thunder.livesdk.video.ThunderPlayerSurfaceView;
import com.thunder.livesdk.video.ThunderPlayerTextureView;
import com.thunder.livesdk.video.ThunderPlayerView;
import com.thunder.livesdk.video.ThunderVideoPlayEngineImp;
import com.thunder.livesdk.video.VideoPlayerView;
import com.yy.mediaframework.Constant;
import com.yy.videoplayer.videoview.VideoPosition;
import com.yy.videoplayer.view.YMFLayoutParams;
import com.yy.videoplayer.view.YMFVideoPosition;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ThunderPlayerMultiViewProxy {
    private static final String TAG = "ThunderPlayerView";
    private YMFVideoPosition[] mVideoPositions;
    private YMFVideoPosition mBgVideoPosition;
    private int mVideoCount;
    private Context mContext;
    private ConcurrentHashMap<String, Seat> mStreamKeyToSeatMap;
    private Constant.MultiLianmaiMode lianMaiMode;
    private YMFLayoutParams mYMFLayoutParams;
    private WeakReference<ThunderVideoPlayEngineImp> engineImp;
    private Object syncLock = new Object();
    private VideoPlayerView mPlayerView;

    public ThunderPlayerMultiViewProxy(Context context) {
        this.mContext = context;
        this.mStreamKeyToSeatMap = new ConcurrentHashMap();
    }

    public ThunderPlayerMultiViewProxy(Context context, ThunderVideoPlayEngineImp engine) {
        this.mContext = context;
        this.mStreamKeyToSeatMap = new ConcurrentHashMap();
        this.engineImp = new WeakReference<ThunderVideoPlayEngineImp>(engine);
    }

    public void initMultiPlayerViewLayout(ThunderMultiVideoViewParam layoutParam) {
        if (layoutParam == null) {
            return;
        }
        if (layoutParam.mVideoPositions == null && layoutParam.mVideoViewPositions == null) {
            return;
        }
        int videoCount = 0;
        if (layoutParam.mVideoViewPositions != null) {
            int positionSize = layoutParam.mVideoViewPositions.size();
            this.mVideoPositions = new YMFVideoPosition[positionSize];
            for (int i = 0; i < positionSize; ++i) {
                if (layoutParam.mVideoViewPositions.get((int)i).mIndex >= positionSize) continue;
                this.mVideoPositions[layoutParam.mVideoViewPositions.get((int)i).mIndex] = this.convertToVideoPosition(layoutParam.mVideoViewPositions.get(i));
            }
            this.mBgVideoPosition = this.convertToVideoPosition(layoutParam.mBgViewPosition);
        } else if (layoutParam.mVideoPositions != null) {
            this.mVideoPositions = new YMFVideoPosition[layoutParam.mVideoPositions.size()];
            for (int i = 0; i < layoutParam.mVideoPositions.size(); ++i) {
                if (layoutParam.mVideoPositions.get((int)i).mIndex >= layoutParam.mVideoPositions.size()) continue;
                this.mVideoPositions[layoutParam.mVideoPositions.get((int)i).mIndex] = this.convertToVideoPosition(layoutParam.mVideoPositions.get(i));
            }
            this.mBgVideoPosition = this.convertToVideoPosition(layoutParam.mBgPosition);
        }
        videoCount = ThunderPlayerMultiViewProxy.arraySize(this.mVideoPositions);
        this.mYMFLayoutParams = new YMFLayoutParams(videoCount);
        this.mYMFLayoutParams.mDrawPosition = this.mVideoPositions;
        this.mYMFLayoutParams.backgroudPosition = this.mBgVideoPosition;
        this.mYMFLayoutParams.background = layoutParam.mBgBitmap;
        this.lianMaiMode = (Constant.MultiLianmaiMode)new SparseArray<Constant.MultiLianmaiMode>(10){
            {
                this.put(0, Constant.MultiLianmaiMode.NormalMode);
                this.put(1, Constant.MultiLianmaiMode.NormalMode);
                this.put(2, Constant.MultiLianmaiMode.TwoPersonMode);
                this.put(3, Constant.MultiLianmaiMode.ThreePersonMode);
                this.put(4, Constant.MultiLianmaiMode.FourPersonMode);
                this.put(5, Constant.MultiLianmaiMode.FivePersonMode);
                this.put(6, Constant.MultiLianmaiMode.SixPersonMode);
                this.put(7, Constant.MultiLianmaiMode.SevenPersonMode);
                this.put(8, Constant.MultiLianmaiMode.EightPersonMode);
                this.put(9, Constant.MultiLianmaiMode.NinePersonMode);
            }
        }.get(ThunderPlayerMultiViewProxy.arraySize(this.mVideoPositions));
        this.updateLayout(videoCount);
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "initMultiPlayerViewLayout:" + this.mVideoCount + " " + layoutParam.toString());
        }
    }

    private void updateLayout(int videoCount) {
        if (this.mPlayerView != null) {
            if (this.mVideoCount != 0 && this.mVideoCount != videoCount) {
                this.resetAll();
                this.mPlayerView.updateMultiViewLayout(this.mYMFLayoutParams);
                ThunderLog.release(TAG, "need redraw, update MultiPlayerViewLayout:" + this.mVideoCount);
            } else if (this.mVideoCount != 0 && this.mVideoCount == videoCount || this.mVideoCount == 0 && this.mVideoCount < videoCount) {
                this.mPlayerView.updateMultiViewLayout(this.mYMFLayoutParams);
                ThunderLog.release(TAG, "just update MultiPlayerViewLayout:" + this.mVideoCount);
            }
            this.mPlayerView.enterMultiVideoViewMode(this.mYMFLayoutParams, this.lianMaiMode);
        }
        this.mVideoCount = videoCount;
    }

    private YMFVideoPosition convertToVideoPosition(VideoPosition viewPosition) {
        if (viewPosition == null) {
            return null;
        }
        YMFVideoPosition result = new YMFVideoPosition();
        result.mX = viewPosition.mX;
        result.mY = viewPosition.mY;
        result.mHeight = viewPosition.mHeight;
        result.mWidth = viewPosition.mWidth;
        result.mIndex = viewPosition.mIndex;
        return result;
    }

    private YMFVideoPosition convertToVideoPosition(ThunderMultiVideoViewCoordinate viewPosition) {
        if (viewPosition == null) {
            return null;
        }
        YMFVideoPosition result = new YMFVideoPosition();
        result.mX = viewPosition.mX;
        result.mY = viewPosition.mY;
        result.mHeight = viewPosition.mHeight;
        result.mWidth = viewPosition.mWidth;
        result.mIndex = viewPosition.mIndex;
        return result;
    }

    public VideoPlayerView getPlayerView() {
        return this.mPlayerView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMultiPlayerView(Object view) {
        ThunderLog.release(TAG, "updateMultiPlayerView enter, mPlayerView: " + (Object)((Object)this.mPlayerView) + " targetView " + view);
        if (view == null) {
            this.unlink();
            Object object = this.syncLock;
            synchronized (object) {
                this.mPlayerView = null;
            }
        }
        if (this.mPlayerView == view) {
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "updateMultiPlayerView already exist");
            }
            return;
        }
        if (this.mPlayerView != null && this.mPlayerView != view) {
            this.unlink();
            this.mPlayerView = null;
        }
        if (view instanceof ThunderPlayerMultiView) {
            this.mPlayerView = (ThunderPlayerMultiView)((Object)view);
        }
        if (view instanceof ThunderPlayerView) {
            this.mPlayerView = (ThunderPlayerView)((Object)view);
        }
        if (view instanceof ThunderPlayerTextureView) {
            this.mPlayerView = (ThunderPlayerTextureView)((Object)view);
        }
        if (view instanceof ThunderPlayerSurfaceView) {
            this.mPlayerView = (ThunderPlayerSurfaceView)((Object)view);
        }
        if (this.mPlayerView != null) {
            this.mPlayerView.enterMultiVideoViewMode(this.mYMFLayoutParams, this.lianMaiMode);
        }
        ThunderLog.release(TAG, "updateMultiPlayerView exit");
    }

    public void destroyVideoPlayerView() {
        ThunderLog.release(TAG, "destroyVideoPlayerView");
        if (this.mStreamKeyToSeatMap != null) {
            this.unlink();
            this.mStreamKeyToSeatMap.clear();
        }
        if (this.mPlayerView != null) {
            if (this.mYMFLayoutParams != null) {
                this.mYMFLayoutParams.background = null;
                this.mPlayerView.updateMultiViewLayout(this.mYMFLayoutParams);
            }
            this.mPlayerView.leaveMultiVideoViewMode();
        }
        this.mPlayerView = null;
        this.mYMFLayoutParams = null;
    }

    public VideoPlayerView getVideoPlayerView() {
        return this.mPlayerView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int switchDualVideoView(String oldStreamKey, String newStreamKey, long newStreamId) {
        int ret = 0;
        if (oldStreamKey == null || oldStreamKey == null || newStreamId == 0L || newStreamId == -1L) {
            ThunderLog.release(TAG, "switchDualVideoView  old " + oldStreamKey + " new:" + newStreamKey + "streamId:" + newStreamId);
            return -1;
        }
        ConcurrentHashMap<String, Seat> concurrentHashMap = this.mStreamKeyToSeatMap;
        synchronized (concurrentHashMap) {
            Seat oldSeat = this.removeSeatByStreamKey(oldStreamKey);
            if (oldSeat != null) {
                if (this.mPlayerView != null) {
                    ret = this.mPlayerView.switchDualVideoView(oldSeat.streamId, newStreamId, oldSeat.seatIdx);
                }
                oldSeat.streamId = newStreamId;
                this.mStreamKeyToSeatMap.put(newStreamKey, oldSeat);
            }
        }
        return ret;
    }

    public int updateSeat(String streamKey, int seatId) {
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "innerUpdateSeat() called with: uid = [" + streamKey + "], seat = [" + seatId + "]");
        }
        if (seatId >= this.mVideoCount || streamKey == null) {
            ThunderLog.error(TAG, "updateSeat:" + seatId + "maxSeats:" + this.mVideoCount + "streamKey:" + streamKey);
            return -1;
        }
        if (this.mVideoPositions != null && this.mVideoPositions.length == 1 && this.mVideoPositions[0].mHeight == -2 && this.mVideoPositions[0].mWidth == -2 && seatId == -1) {
            seatId = 0;
        }
        return this.bindSeat(streamKey, seatId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int bindSeat(String streamKey, final int seatId) {
        ThunderLog.release(TAG, "bindSeat called with: uid = [" + streamKey + "], seatNo = [" + seatId + "]");
        ConcurrentHashMap<String, Seat> concurrentHashMap = this.mStreamKeyToSeatMap;
        synchronized (concurrentHashMap) {
            Seat seatItem = this.findSeatByStreamKey(streamKey);
            if (seatItem != null && seatItem.seatIdx >= 0 && seatItem.streamId != -1L && seatId < 0) {
                ThunderLog.release(TAG, "bindSeat unlink:" + streamKey + " seatId: " + seatId + " streamId:" + seatItem.streamId);
                this.unlink(seatItem);
                seatItem.seatIdx = -1;
                return 0;
            }
            if (seatId < 0) {
                ThunderLog.error(TAG, "updateSeat invalid, seat " + seatId + " invalid!");
                return -1;
            }
            if (seatItem == null) {
                seatItem = new Seat(){
                    {
                        this.seatIdx = seatId;
                    }
                };
            } else {
                if (seatItem.seatIdx != seatId && seatItem.status == 1) {
                    if (ThunderLog.isInfoValid()) {
                        ThunderLog.info(TAG, "bindSeat updateseat had linked:" + streamKey + ", will unlink!!");
                    }
                    this.unlink(seatItem);
                }
                seatItem.seatIdx = seatId;
                if (this.processBusySeatIfExist(streamKey, seatId) > 0) {
                    ThunderLog.error(TAG, "bindSeat busy!!");
                }
            }
            if (seatItem.seatIdx >= 0 && seatItem.status == 0 && seatItem.streamId != -1L) {
                this.link(seatItem);
            }
            this.mStreamKeyToSeatMap.put(streamKey, seatItem);
            ThunderLog.release(TAG, "bindSeat updateseat streamKey:" + streamKey + ",seat:" + seatId + " >> " + seatItem + "  streamId " + seatItem.streamId);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareStreamSeat(String streamKey, long streamId) {
        if (streamKey == null) {
            ThunderLog.error(TAG, "prepareStreamSeat streamKey null");
            return;
        }
        if (this.mStreamKeyToSeatMap == null) {
            ThunderLog.error(TAG, "prepareStreamSeat mStreamKeyToSeatMap null");
            return;
        }
        if (streamId == 0L || streamId == -1L) {
            ThunderLog.error(TAG, "prepareStreamSeat streamId," + streamId);
            return;
        }
        ConcurrentHashMap<String, Seat> concurrentHashMap = this.mStreamKeyToSeatMap;
        synchronized (concurrentHashMap) {
            Seat seatItem = this.findSeatByStreamKey(streamKey);
            if (seatItem == null) {
                seatItem = new Seat();
                seatItem.streamId = streamId;
                this.mStreamKeyToSeatMap.put(streamKey, seatItem);
                return;
            }
            if (seatItem != null && seatItem.seatIdx >= 0 && seatItem.streamId != streamId && seatItem.status == 1) {
                ThunderLog.release(TAG, "prepareStreamSeat replace and link: seatItem.streamId" + seatItem.streamId + " streamId:" + streamId);
                this.unlink(seatItem);
                seatItem.streamId = streamId;
                this.link(seatItem);
            } else if (seatItem != null && seatItem.status == 0) {
                seatItem.streamId = streamId;
                ThunderLog.release(TAG, "prepareStreamSeat update: seatItem.streamId:" + streamId + " seatId:" + seatItem.seatIdx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStreamToSeat(String streamKey, long streamId, boolean isNeedReLink) {
        if (streamKey == null) {
            ThunderLog.error(TAG, "bindStreamToSeat streamKey null");
            return;
        }
        if (this.mStreamKeyToSeatMap == null) {
            ThunderLog.error(TAG, "bindStreamToSeat mStreamKeyToSeatMap null");
            return;
        }
        if (streamId == 0L || streamId == -1L) {
            ThunderLog.error(TAG, "bindStreamToSeat streamId," + streamId);
            return;
        }
        ConcurrentHashMap<String, Seat> concurrentHashMap = this.mStreamKeyToSeatMap;
        synchronized (concurrentHashMap) {
            Seat seatItem = this.findSeatByStreamKey(streamKey);
            if (seatItem == null) {
                seatItem = new Seat();
                seatItem.streamId = streamId;
                this.mStreamKeyToSeatMap.put(streamKey, seatItem);
                return;
            }
            if (seatItem != null && seatItem.seatIdx >= 0 && seatItem.status == 1) {
                if (ThunderLog.isInfoValid()) {
                    ThunderLog.info(TAG, "bindStreamToSeat replace and link: seatItem.streamId" + seatItem.streamId + " streamId:" + streamId + " isNeedRelink:" + isNeedReLink);
                }
                if (isNeedReLink && seatItem.streamId != streamId) {
                    this.unlink(seatItem);
                    seatItem.streamId = streamId;
                    this.link(seatItem);
                }
            } else if (seatItem != null && seatItem.status == 0) {
                seatItem.streamId = streamId;
                this.link(seatItem);
                ThunderLog.release(TAG, "bindStreamToSeat update: seatItem.streamId:" + streamId + " seatId:" + seatItem.seatIdx);
            }
        }
    }

    private int processBusySeatIfExist(String streamKey, int seatId) {
        if (seatId >= 0) {
            Seat curSeat = this.findSeatByStreamKey(streamKey);
            ArrayList<Seat> seatItemList = this.findSeatBySeatId(seatId);
            if (seatItemList != null && seatItemList.size() > 0) {
                for (Seat seatItem : seatItemList) {
                    if (seatItem == null || seatItem == curSeat || seatItem.streamId == 0L || curSeat.streamId == 0L || seatItem.streamId >> 32 == curSeat.streamId >> 32) continue;
                    ThunderLog.error(TAG, "processBusySeat, process streamKey" + streamKey + " busyStreamId " + seatItem.streamId + " seat " + seatId + " busy!");
                    this.unlink(seatItem);
                    seatItem.seatIdx = -1;
                    if (this.engineImp != null && this.engineImp.get() != null) {
                        ((ThunderVideoPlayEngineImp)this.engineImp.get()).onMultiViewSeatInfoChangedNotify(seatItem.streamId, seatItem.seatIdx);
                    }
                    return 1;
                }
            }
        }
        return 0;
    }

    public Seat findSeatByStreamKey(String streamKey) {
        if (this.mStreamKeyToSeatMap == null) {
            ThunderLog.error(TAG, "mStreamKeyToSeatMap null");
            return null;
        }
        Seat seatItem = this.mStreamKeyToSeatMap.get(streamKey);
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "findSeatByStreamKey:" + streamKey + ",caches:" + this.mStreamKeyToSeatMap);
        }
        return seatItem;
    }

    public Seat removeSeatByStreamKey(String streamKey) {
        return this.mStreamKeyToSeatMap.remove(streamKey);
    }

    public ArrayList<Seat> findSeatBySeatId(int seatIdx) {
        ArrayList<Seat> seatArrayList = new ArrayList<Seat>(0);
        if (this.mStreamKeyToSeatMap != null && seatIdx >= 0) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem.seatIdx != seatIdx) continue;
                seatArrayList.add(seatItem);
            }
        }
        return seatArrayList;
    }

    public ArrayList<String> findStreamKeyBySeatId(int seatIdx) {
        ArrayList<String> streamKeyList = new ArrayList<String>(0);
        if (this.mStreamKeyToSeatMap != null && seatIdx >= 0) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem.seatIdx != seatIdx) continue;
                streamKeyList.add(entry.getKey());
            }
        }
        return streamKeyList;
    }

    public Seat findSeatByStreamId(long streamId) {
        if (this.mStreamKeyToSeatMap != null) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem.streamId != streamId) continue;
                return seatItem;
            }
        }
        return null;
    }

    private int link(Seat seatItem) {
        int result = -1;
        if (seatItem != null) {
            if (this.mPlayerView != null && seatItem.seatIdx >= 0 && seatItem.streamId != 0L && seatItem.status == 0) {
                result = this.mPlayerView.linkToStream(seatItem.streamId, seatItem.seatIdx);
            }
            if (result >= 0) {
                seatItem.status = 1;
            }
            ThunderLog.release(TAG, "link- Seat: streamId " + seatItem.streamId + " seatIdx " + seatItem.seatIdx + " mPlayerView " + (Object)((Object)this.mPlayerView) + ",ret:" + result);
        } else {
            ThunderLog.error(TAG, "link- Seat:" + seatItem + ",ret:" + result);
        }
        return result;
    }

    private int unlink(Seat seatItem) {
        int result = -1;
        if (seatItem != null) {
            if (this.mPlayerView != null && seatItem.seatIdx >= 0 && seatItem.streamId != 0L && seatItem.status == 1) {
                result = this.mPlayerView.unLinkFromStream(seatItem.streamId, seatItem.seatIdx);
            }
            if (result >= 0) {
                seatItem.status = 0;
            }
            ThunderLog.release(TAG, "unlink- Seat: streamId " + seatItem.streamId + " seatIdx " + seatItem.seatIdx + " mPlayerView " + (Object)((Object)this.mPlayerView) + ",ret:" + result);
        }
        return result;
    }

    public int link(String streamKey) {
        Seat seatItem = this.findSeatByStreamKey(streamKey);
        return this.link(seatItem);
    }

    public int unlink(String streamKey) {
        Seat seatItem = this.findSeatByStreamKey(streamKey);
        int ret = this.unlink(seatItem);
        if (seatItem != null) {
            seatItem.streamId = -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSeatByStreamKey(String streamKey) {
        ConcurrentHashMap<String, Seat> concurrentHashMap = this.mStreamKeyToSeatMap;
        synchronized (concurrentHashMap) {
            this.mStreamKeyToSeatMap.remove(streamKey);
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "releaseSeatByStreamKey- Seat:" + streamKey);
            }
        }
    }

    public int unlink() {
        if (this.mStreamKeyToSeatMap != null) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem == null) continue;
                this.unlink(seatItem);
            }
        }
        return 0;
    }

    public int link() {
        if (this.mStreamKeyToSeatMap != null) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem == null) continue;
                this.link(seatItem);
            }
        }
        return 0;
    }

    public void resetAll() {
        if (this.mStreamKeyToSeatMap != null) {
            this.unlinkAndReset();
            ThunderLog.release(TAG, "resetAll");
        }
    }

    public void quitRoom() {
        ThunderLog.release(TAG, "quitRoom");
        this.resetAll();
        this.mStreamKeyToSeatMap.clear();
    }

    public int unlinkAndReset() {
        if (this.mStreamKeyToSeatMap != null) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem == null) continue;
                this.unlink(seatItem);
                seatItem.seatIdx = -1;
                if (this.engineImp == null || this.engineImp.get() == null) continue;
                ((ThunderVideoPlayEngineImp)this.engineImp.get()).onMultiViewSeatInfoChangedNotify(seatItem.streamId, seatItem.seatIdx);
            }
        }
        return 0;
    }

    public boolean setScaleMode(int scaleMode) {
        ThunderLog.release(TAG, "setScaleMode:" + scaleMode);
        boolean result = true;
        if (this.mStreamKeyToSeatMap != null && this.mPlayerView != null) {
            for (Map.Entry<String, Seat> entry : this.mStreamKeyToSeatMap.entrySet()) {
                Seat seatItem = entry.getValue();
                if (seatItem == null || seatItem.seatIdx < 0) continue;
                result &= this.mPlayerView.setScaleMode(seatItem.seatIdx, scaleMode);
            }
        }
        return result;
    }

    public boolean setScaleMode(String streamKey, int scaleMode) {
        Seat seat;
        ThunderLog.release(TAG, "setScaleMode: " + streamKey + " " + scaleMode);
        boolean result = true;
        if (this.mStreamKeyToSeatMap != null && this.mPlayerView != null && scaleMode >= 0 && (seat = this.findSeatByStreamKey(streamKey)) != null) {
            result = this.mPlayerView.setScaleMode(seat.seatIdx, scaleMode);
        }
        return result;
    }

    public void setMirrorMode(String streamKey, int mirrorMode) {
        Seat seat;
        ThunderLog.release(TAG, "setMirrorMode: " + streamKey + " " + mirrorMode);
        if (this.mStreamKeyToSeatMap != null && this.mPlayerView != null && (seat = this.findSeatByStreamKey(streamKey)) != null) {
            this.mPlayerView.setMirrorMode(seat.seatIdx, mirrorMode);
        }
    }

    public Bitmap getVideoScreenshot(String streamKey) {
        Seat seat;
        if (ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "getVideoScreenshot: " + streamKey);
        }
        if (this.mStreamKeyToSeatMap != null && this.mPlayerView != null && (seat = this.findSeatByStreamKey(streamKey)) != null) {
            return this.mPlayerView.getVideoScreenshot(seat.seatIdx);
        }
        return null;
    }

    public static <T> int arraySize(T[] xs) {
        return xs == null ? 0 : xs.length;
    }

    public static class Seat {
        private static final int STATUS_IDEL = 0;
        private static final int STATUS_LINK = 1;
        public int seatIdx = -1;
        public long streamId = 0L;
        public int status = 0;

        public String toString() {
            return "Seat{, seatIdx=" + this.seatIdx + ", status=" + this.status + '}';
        }
    }
}

