/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.os.Build;
import com.thunder.livesdk.log.ThunderLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class CpuTool {
    private static final String kCpuInfoMaxFreqFilePath = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq";
    private static final String TAG = "CPUTool";
    public static final String OS_VERSION = Build.VERSION.RELEASE;
    private static final String[] TOP = new String[]{"/system/bin/top", "-d", "1", "-m", "6"};
    private static int mTopPeriod = 9;
    private static int count = 0;
    private static int mRefDeviceJiffies = 0;
    private static int mAppCpuRate = 0;
    private static int mDeviceCpuRate = 0;
    private static int selfProcessPid = android.os.Process.myPid();
    private static int maxCpuFreq = 0;
    private static int minCpuFreq = 0;
    private static int mHiidoAppCpuRate = -1;
    private static List<Integer> mHiidoAppCpuRateList = new ArrayList<Integer>();
    private static CpuUpTimeInfo mCpuUpTimeInfo = new CpuUpTimeInfo();
    private static JiffiesCount mJiffiesCount = new JiffiesCount();
    private static JiffiesCount mJiffiesTopCount = new JiffiesCount();
    private static int mCpuCores = CpuTool.getCpuCores();
    private static final String kCpuInfoMinFreqFilePath = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq";
    private static final String kCpuInfoCurFreqFilePath = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq";

    private static String getKernelVersion() {
        return System.getProperty("os.version");
    }

    private static int getCpuCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static synchronized int getHiidoAppCpuRate() {
        return mHiidoAppCpuRate;
    }

    public static synchronized double getAppCpuRateAverage() {
        double AppCpuRateAverage = 0.0;
        int rate = CpuTool.getAppCpuRate(15);
        if (rate <= 0) {
            mHiidoAppCpuRateList.add(rate);
            if (mHiidoAppCpuRateList.size() > 10) {
                int sum = 0;
                for (int value : mHiidoAppCpuRateList) {
                    sum += value;
                }
                mHiidoAppCpuRate = sum / mHiidoAppCpuRateList.size();
                mHiidoAppCpuRateList.clear();
            }
        } else {
            mHiidoAppCpuRate = rate > 100 ? 100 : rate;
        }
        AppCpuRateAverage = rate < 0 ? 0.0 : (double)rate / (double)mCpuCores;
        return AppCpuRateAverage;
    }

    public static synchronized int getAppCpuRate(int topPeriod) {
        if (topPeriod > 0 && topPeriod != mTopPeriod) {
            mTopPeriod = topPeriod;
        }
        long deltaJiffiesPerSecond = 0L;
        if (mJiffiesCount.isInit()) {
            CpuTool.mJiffiesCount.lastJiffies = CpuTool.getCurrentCpuJiffies();
            CpuTool.mJiffiesCount.lastTimeCount = System.currentTimeMillis();
            return 0;
        }
        CpuTool.mJiffiesCount.curJiffies = CpuTool.getCurrentCpuJiffies();
        CpuTool.mJiffiesCount.deltaJiffies = CpuTool.mJiffiesCount.curJiffies - CpuTool.mJiffiesCount.lastJiffies;
        CpuTool.mJiffiesCount.lastJiffies = CpuTool.mJiffiesCount.curJiffies;
        if (CpuTool.mJiffiesCount.deltaJiffies == 0L && ThunderLog.isInfoValid()) {
            ThunderLog.info(TAG, "appCpu deltaJiffiesPerSecond: " + deltaJiffiesPerSecond + " mJiffiesCount.curJiffies: " + CpuTool.mJiffiesCount.curJiffies + " lastJiffies: " + CpuTool.mJiffiesCount.lastJiffies);
        }
        CpuTool.mJiffiesCount.curTimeCount = System.currentTimeMillis();
        CpuTool.mJiffiesCount.deltaTimeCount = CpuTool.mJiffiesCount.curTimeCount - CpuTool.mJiffiesCount.lastTimeCount;
        CpuTool.mJiffiesCount.lastTimeCount = CpuTool.mJiffiesCount.curTimeCount;
        if (CpuTool.mJiffiesCount.deltaTimeCount != 0L) {
            long referJiffies;
            deltaJiffiesPerSecond = CpuTool.mJiffiesCount.deltaJiffies * 1000L / CpuTool.mJiffiesCount.deltaTimeCount;
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "appCpu deltaJiffiesPerSecond: " + deltaJiffiesPerSecond);
            }
            if ((referJiffies = CpuTool.getReferDeviceJiffies()) != 0L) {
                int cpuRate = (int)(deltaJiffiesPerSecond * 100L * CpuTool.mJiffiesTopCount.deltaTimeCount / referJiffies / 1000L);
                if (ThunderLog.isInfoValid()) {
                    ThunderLog.info(TAG, "refJiffies by top:" + referJiffies + " cpuRate " + cpuRate);
                }
                return cpuRate;
            }
            return (int)(-deltaJiffiesPerSecond);
        }
        return 0;
    }

    public static int getDeviceCpuRate() {
        return mDeviceCpuRate;
    }

    public static int getDeviceCpuRateByUptime() {
        double deltaCpuUptimeRate = 0.0;
        if (!mCpuUpTimeInfo.isInit()) {
            float[] cpuUptime = CpuTool.getCpuUpTimeInfo();
            if (cpuUptime != null) {
                CpuTool.mCpuUpTimeInfo.lastActiveTime = cpuUptime[0];
                CpuTool.mCpuUpTimeInfo.lastIdleTime = cpuUptime[1];
                CpuTool.mCpuUpTimeInfo.lastTimeCount = System.currentTimeMillis();
            }
            return 0;
        }
        float[] cpuUptime = CpuTool.getCpuUpTimeInfo();
        if (cpuUptime != null && cpuUptime.length == 2) {
            CpuTool.mCpuUpTimeInfo.curActiveTime = cpuUptime[0];
            CpuTool.mCpuUpTimeInfo.deltaActiveTime = CpuTool.mCpuUpTimeInfo.curActiveTime - CpuTool.mCpuUpTimeInfo.lastActiveTime;
            CpuTool.mCpuUpTimeInfo.lastActiveTime = CpuTool.mCpuUpTimeInfo.curActiveTime;
            CpuTool.mCpuUpTimeInfo.curIdleTime = cpuUptime[1];
            CpuTool.mCpuUpTimeInfo.deltaIdleTime = CpuTool.mCpuUpTimeInfo.curIdleTime - CpuTool.mCpuUpTimeInfo.lastIdleTime;
            CpuTool.mCpuUpTimeInfo.lastIdleTime = CpuTool.mCpuUpTimeInfo.curIdleTime;
        }
        if (cpuUptime != null && CpuTool.mCpuUpTimeInfo.deltaActiveTime != 0.0 && mCpuCores != 0) {
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "deltaIdleTime:" + CpuTool.mCpuUpTimeInfo.deltaIdleTime + " deltaActiveTime " + CpuTool.mCpuUpTimeInfo.deltaActiveTime + " mCpuCores " + mCpuCores);
            }
            deltaCpuUptimeRate = 1.0 - CpuTool.mCpuUpTimeInfo.deltaIdleTime / (CpuTool.mCpuUpTimeInfo.deltaActiveTime * (double)mCpuCores);
            ThunderLog.release(TAG, "deviceCpuRate:" + 100.0 * deltaCpuUptimeRate);
            return (int)(100.0 * deltaCpuUptimeRate);
        }
        return 0;
    }

    private static long getReferDeviceJiffies() {
        CpuTool.mJiffiesTopCount.lastJiffies = CpuTool.getCurrentCpuJiffies();
        CpuTool.mJiffiesTopCount.lastTimeCount = System.currentTimeMillis();
        int[] cpuRate = CpuTool.getCpuRateByTop();
        if (cpuRate != null && cpuRate[0] != 0) {
            CpuTool.mJiffiesTopCount.curJiffies = CpuTool.getCurrentCpuJiffies();
            CpuTool.mJiffiesTopCount.curTimeCount = System.currentTimeMillis();
            CpuTool.mJiffiesTopCount.deltaJiffies = CpuTool.mJiffiesTopCount.curJiffies - CpuTool.mJiffiesTopCount.lastJiffies;
            CpuTool.mJiffiesTopCount.deltaTimeCount = CpuTool.mJiffiesTopCount.curTimeCount - CpuTool.mJiffiesTopCount.lastTimeCount;
            mRefDeviceJiffies = (int)(100L * CpuTool.mJiffiesTopCount.deltaJiffies / (long)cpuRate[0]);
            if (ThunderLog.isInfoValid()) {
                ThunderLog.info(TAG, "top cpu device jiffies:" + mRefDeviceJiffies + " mJiffiesTopCount.deltaJiffies:" + CpuTool.mJiffiesTopCount.deltaJiffies + " top:" + cpuRate);
            }
            return mRefDeviceJiffies;
        }
        return mRefDeviceJiffies;
    }

    private static int[] getCpuRateByTop() {
        String[] cpuRate = null;
        int[] cpuRateData = new int[2];
        boolean deviceCpu = false;
        if (OS_VERSION.compareTo("8.0") >= 0) {
            if (count == 0) {
                cpuRate = CpuTool.getCpuRateByRunTop(selfProcessPid);
                if (ThunderLog.isInfoValid()) {
                    ThunderLog.info(TAG, "appCpuRate:" + cpuRate[0] + "deviceCpuRate" + cpuRate[1]);
                }
                if (cpuRate != null) {
                    try {
                        cpuRateData[0] = (int)Float.parseFloat(cpuRate[0]);
                        mAppCpuRate = cpuRateData[0];
                        cpuRateData[1] = (int)Float.parseFloat(cpuRate[1]);
                        mDeviceCpuRate = cpuRateData[1];
                    }
                    catch (Exception e) {
                        ThunderLog.error(TAG, "Exception " + e);
                    }
                    ThunderLog.error(TAG, "getAppRateByTop appCpuRate:" + mAppCpuRate + " deviceCpuRate " + mDeviceCpuRate);
                }
            }
            count = count == mTopPeriod - 1 ? 0 : ++count;
        }
        return cpuRateData;
    }

    private static long getCurrentCpuJiffies() {
        FileReader fr = null;
        BufferedReader localBufferReader = null;
        File file = null;
        int pid = android.os.Process.myPid();
        String cpuPath = "/proc/" + pid + "/stat";
        String cpuProcessInfo = "";
        String[] result = new String[3];
        long curJiffies = 0L;
        file = new File(cpuPath);
        if (!file.exists() || !file.canRead()) {
            ThunderLog.error(TAG, "file not exist or have not permission:" + cpuPath);
            return 0L;
        }
        try {
            String[] cpuSpilt;
            fr = new FileReader(file);
            localBufferReader = new BufferedReader(fr);
            cpuProcessInfo = localBufferReader.readLine();
            if (cpuProcessInfo != null && (cpuSpilt = cpuProcessInfo.split(" ")) != null) {
                result[0] = cpuSpilt[1];
                result[1] = cpuSpilt[13];
                result[2] = cpuSpilt[14];
                long userSpaceTime = Long.parseLong(result[1]);
                long kernelSpaceTime = Long.parseLong(result[2]);
                curJiffies = userSpaceTime + kernelSpaceTime;
            }
        }
        catch (IOException e) {
            ThunderLog.error(TAG, "exception: " + e);
        }
        if (localBufferReader != null) {
            try {
                localBufferReader.close();
            }
            catch (IOException e) {
                ThunderLog.error(TAG, "exception: " + e);
            }
        }
        return curJiffies;
    }

    private static float[] getCpuUpTimeInfo() {
        FileReader fr = null;
        BufferedReader localBufferReader = null;
        File file = null;
        String cpuPath = "/proc/uptime";
        String cpuProcessInfo = "";
        float[] result = new float[2];
        long curJiffies = 0L;
        file = new File(cpuPath);
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        try {
            String[] cpuSpilt;
            fr = new FileReader(file);
            localBufferReader = new BufferedReader(fr);
            cpuProcessInfo = localBufferReader.readLine();
            if (cpuProcessInfo != null && (cpuSpilt = cpuProcessInfo.split(" ")) != null) {
                result[0] = Float.parseFloat(cpuSpilt[0]);
                result[1] = Float.parseFloat(cpuSpilt[1]);
            }
        }
        catch (IOException e) {
            ThunderLog.error(TAG, "exception: " + e);
        }
        if (localBufferReader != null) {
            try {
                localBufferReader.close();
            }
            catch (IOException e) {
                ThunderLog.error(TAG, "exception: " + e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxCpuFreqInfo() {
        int result = 0;
        File file = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            String text;
            file = new File(kCpuInfoMaxFreqFilePath);
            if (file != null && file.exists() && (text = (br = new BufferedReader(fr = new FileReader(kCpuInfoMaxFreqFilePath))).readLine()) != null && !text.isEmpty()) {
                result = Integer.parseInt(text.trim());
            }
        }
        catch (FileNotFoundException e) {
            ThunderLog.error(TAG, "Exception: " + e.toString());
        }
        catch (IOException e) {
            ThunderLog.error(TAG, "Exception: " + e.toString());
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    ThunderLog.error(TAG, "Exception: " + e.toString());
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    ThunderLog.error(TAG, "Exception: " + e.toString());
                }
            }
        }
        return result;
    }

    public static String getCurrentProcessCpuAffinity() {
        FileReader fr = null;
        BufferedReader localBufferReader = null;
        File file = null;
        int pid = android.os.Process.myPid();
        String cpuPath = "/proc/" + pid + "/stat";
        String cpuProcessInfo = "";
        String result = null;
        file = new File(cpuPath);
        if (!file.exists() || !file.canRead()) {
            ThunderLog.error(TAG, "file not exist or have not permission");
            return result;
        }
        try {
            fr = new FileReader(file);
            localBufferReader = new BufferedReader(fr);
            cpuProcessInfo = localBufferReader.readLine();
            if (cpuProcessInfo != null) {
                String[] cpuSpilt = cpuProcessInfo.split(" ");
                if (CpuTool.getKernelVersion().compareTo("2.8.8") <= 0) {
                    if (cpuSpilt.length < 3) {
                        return result;
                    }
                    result = cpuSpilt[cpuSpilt.length - 3];
                } else {
                    if (cpuSpilt.length < 14) {
                        return result;
                    }
                    result = cpuSpilt[cpuSpilt.length - 15];
                }
            }
        }
        catch (IOException e) {
            ThunderLog.error(TAG, "exception: " + e);
        }
        if (localBufferReader != null) {
            try {
                localBufferReader.close();
            }
            catch (IOException e) {
                ThunderLog.error(TAG, "exception: " + e);
            }
        }
        return result;
    }

    public static int getMinCpuFreq() {
        if (minCpuFreq == 0) {
            minCpuFreq = CpuTool.getMinCpuFreqInfo();
        }
        return minCpuFreq;
    }

    public static int getMaxCpuFreq() {
        if (maxCpuFreq == 0) {
            maxCpuFreq = CpuTool.getMaxCpuFreqInfo();
        }
        return maxCpuFreq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getMinCpuFreqInfo() {
        int result = 0;
        File file = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            String text;
            file = new File(kCpuInfoMaxFreqFilePath);
            if (file != null && file.exists() && (text = (br = new BufferedReader(fr = new FileReader(kCpuInfoMinFreqFilePath))).readLine()) != null && !text.isEmpty()) {
                result = Integer.parseInt(text.trim());
            }
        }
        catch (FileNotFoundException e) {
            ThunderLog.error(TAG, "Exception: " + e.toString());
        }
        catch (IOException e) {
            ThunderLog.error(TAG, "Exception: " + e.toString());
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    ThunderLog.error(TAG, "Exception: " + e.toString());
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    ThunderLog.error(TAG, "Exception: " + e.toString());
                }
            }
        }
        return result;
    }

    public static String getCpuInfo() {
        String cpuName = CpuTool.getCpuInfoBySystemProperties();
        if (cpuName != null) {
            return cpuName;
        }
        cpuName = CpuTool.getCpuInfoByProcNode();
        if (cpuName != null) {
            return cpuName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCpuInfoByProcNode() {
        String strInfo = "/proc/cpuinfo";
        String cpuName = "unknown";
        String tmpName = "";
        BufferedReader localBufferedReader = null;
        FileReader fr = null;
        try {
            fr = new FileReader(strInfo);
            localBufferedReader = new BufferedReader(fr);
            while ((cpuName = localBufferedReader.readLine()) != null) {
                if (!cpuName.contains("Hardware")) continue;
                String[] array = cpuName.split(":");
                if (array.length == 2) {
                    tmpName = array[1];
                } else if (array.length == 1) {
                    tmpName = array[0];
                }
                if (tmpName == null) continue;
                String[] arrayCpuName = tmpName.split(" ");
                if (arrayCpuName.length > 1) {
                    String string = arrayCpuName[arrayCpuName.length - 1];
                    return string;
                }
                String string = arrayCpuName[0];
                return string;
            }
            localBufferedReader.close();
            fr.close();
        }
        catch (IOException e) {
            ThunderLog.error(TAG, "Exception: " + e.toString());
        }
        finally {
            try {
                if (localBufferedReader != null) {
                    localBufferedReader.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException e) {
                ThunderLog.error(TAG, "Exception: " + e.toString());
            }
        }
        return cpuName;
    }

    public static String getCpuInfoBySystemProperties() {
        ThunderLog.release(TAG, "getCpuInfo 11");
        try {
            Class<?> classtype = Class.forName("android.os.SystemProperties");
            Method method = classtype.getDeclaredMethod("get", String.class);
            String value = (String)method.invoke(classtype, "ro.board.platform");
            return value;
        }
        catch (ClassNotFoundException e) {
            ThunderLog.release(TAG, "getCpuInfo exception:" + e);
        }
        catch (NoSuchMethodException e) {
            ThunderLog.release(TAG, "getCpuInfo exception:" + e);
        }
        catch (InvocationTargetException e) {
            ThunderLog.release(TAG, "getCpuInfo exception:" + e);
        }
        catch (IllegalAccessException e) {
            ThunderLog.release(TAG, "getCpuInfo exception:" + e);
        }
        return null;
    }

    public static String[] getCpuRateByRunTop(int process) {
        String[] parseResult = new String[]{"0", "0"};
        long start = System.currentTimeMillis();
        String topResult = CpuTool.run(process);
        long exhaustTime = System.currentTimeMillis() - start;
        if (topResult != null) {
            CpuTool.parseTopCpuInfo(topResult, parseResult);
            return parseResult;
        }
        return null;
    }

    private static String run(int pid) {
        String line = null;
        String result = null;
        StringBuilder resultBuilder = new StringBuilder();
        InputStream inputStream = null;
        int limit = 10;
        BufferedReader bufReader = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec(TOP);
            inputStream = proc.getInputStream();
            bufReader = new BufferedReader(new InputStreamReader(inputStream));
            do {
                if (null == (line = bufReader.readLine())) {
                    ThunderLog.error(TAG, "return null");
                    break;
                }
                if (line == null || pid == 0 || !line.contains(String.valueOf(pid))) continue;
                resultBuilder.append(line);
                break;
            } while (--limit > 0);
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufReader != null) {
                bufReader.close();
            }
        }
        catch (IOException e) {
            ThunderLog.error(TAG, "top Exception:" + e);
        }
        result = resultBuilder.toString();
        return result;
    }

    public static int parseTopCpuInfo(String line, String[] parseResult) {
        String cpuAppRate = null;
        String deviceRate = null;
        boolean index = false;
        String[] cpuInfo = line.split(" ");
        if (parseResult != null && parseResult.length == 2 && cpuInfo != null) {
            for (int i = 0; i < cpuInfo.length; ++i) {
                String[] cpuData;
                if (cpuInfo[i].toUpperCase().equals("R") || cpuInfo[i].toUpperCase().equals("S")) {
                    cpuAppRate = cpuInfo[i + 1];
                    if (cpuAppRate == " ") {
                        cpuAppRate = cpuInfo[i + 2];
                    }
                    parseResult[0] = cpuAppRate;
                }
                if (!cpuInfo[i].toLowerCase().contains("%idle") || i <= 0 || (cpuData = cpuInfo[i].split("%")) == null || cpuData.length <= 0) continue;
                float cpuIdle = Float.parseFloat(cpuData[0]);
                float cpuDeviceRate = (float)(mCpuCores * 100) - cpuIdle;
                parseResult[1] = deviceRate = String.valueOf(cpuDeviceRate);
            }
            return 0;
        }
        return -1;
    }

    private static class JiffiesCount {
        public long lastJiffies = 0L;
        public long curJiffies = 0L;
        public long deltaJiffies = 0L;
        public long lastTimeCount = 0L;
        public long curTimeCount = 0L;
        public long deltaTimeCount = 0L;

        public JiffiesCount() {
            this.reset();
        }

        public void reset() {
            this.lastJiffies = 0L;
            this.curJiffies = 0L;
            this.deltaJiffies = 0L;
        }

        public boolean isInit() {
            return this.lastJiffies == 0L;
        }
    }

    private static class CpuUpTimeInfo {
        public double lastActiveTime = 0.0;
        public double curActiveTime = 0.0;
        public double deltaActiveTime = 0.0;
        public double lastIdleTime = 0.0;
        public double curIdleTime = 0.0;
        public double deltaIdleTime = 0.0;
        public long lastTimeCount = 0L;
        public long curTimeCount = 0L;
        public long deltaTimeCount = 0L;

        public CpuUpTimeInfo() {
            this.reset();
        }

        public void reset() {
            this.lastActiveTime = 0.0;
            this.curActiveTime = 0.0;
            this.deltaActiveTime = 0.0;
            this.lastIdleTime = 0.0;
            this.curIdleTime = 0.0;
            this.deltaIdleTime = 0.0;
            mHiidoAppCpuRate = -1;
            mHiidoAppCpuRateList.clear();
        }

        public boolean isInit() {
            return this.lastActiveTime != 0.0;
        }
    }
}

