/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.system;

import com.thunder.livesdk.system.ILifecycleCallbacks;
import com.thunder.livesdk.system.LcLogger;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class LifecycleEventDispatcher {
    private static final HashSet<WeakReference<ILifecycleCallbacks>> observers = new HashSet();
    private static AtomicInteger foregroundCounter = new AtomicInteger(0);
    private static int counter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCallback(ILifecycleCallbacks callback) {
        HashSet<WeakReference<ILifecycleCallbacks>> hashSet = observers;
        synchronized (hashSet) {
            observers.add(new WeakReference<ILifecycleCallbacks>(callback));
            if (foregroundCounter.get() > 0) {
                callback.onForeground();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCallback(ILifecycleCallbacks callback) {
        HashSet<WeakReference<ILifecycleCallbacks>> hashSet = observers;
        synchronized (hashSet) {
            WeakReference<ILifecycleCallbacks> rm = null;
            for (WeakReference<ILifecycleCallbacks> cb : observers) {
                if (callback != cb.get()) continue;
                rm = cb;
            }
            if (null != rm) {
                observers.remove(rm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatchEvent(boolean isForeground) {
        int oldCount = counter;
        LcLogger.d("count:" + (counter += isForeground ? 1 : -1));
        HashSet<WeakReference<ILifecycleCallbacks>> hashSet = observers;
        synchronized (hashSet) {
            if (counter == 1 && oldCount == 0) {
                LcLogger.d("onForeground");
                if (observers.isEmpty()) {
                    foregroundCounter.incrementAndGet();
                }
                for (WeakReference<ILifecycleCallbacks> cb : observers) {
                    if (null != cb.get()) {
                        ((ILifecycleCallbacks)cb.get()).onForeground();
                        continue;
                    }
                    LcLogger.d("onForeground null ref");
                }
            } else if (counter == 0 && oldCount == 1) {
                LcLogger.d("onBackground");
                if (observers.isEmpty()) {
                    foregroundCounter.decrementAndGet();
                }
                for (WeakReference<ILifecycleCallbacks> cb : observers) {
                    if (null != cb.get()) {
                        ((ILifecycleCallbacks)cb.get()).onBackground();
                        continue;
                    }
                    LcLogger.d("onBackground null ref");
                }
            }
        }
    }
}

