/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.helper;

import com.thunder.livesdk.log.ThunderLog;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UidMap {
    private static final String TAG = "UidMap";
    private static Map<Long, String> mUidToStringMap = new HashMap<Long, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUid2String(long iUid, String strUid) {
        ThunderLog.release(TAG, String.format("addUid2String %d,%s", iUid, strUid));
        UidMap.removeUid2String(strUid);
        UidMap.removeUid2String(iUid);
        Class<UidMap> clazz = UidMap.class;
        synchronized (UidMap.class) {
            mUidToStringMap.put(iUid, strUid);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringUid(long iUid) {
        Class<UidMap> clazz = UidMap.class;
        synchronized (UidMap.class) {
            String strUid = mUidToStringMap.get(iUid);
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (strUid == null || strUid.isEmpty()) {
                strUid = Long.toString(iUid);
            }
            return strUid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringUidFromMap(long iUid) {
        Class<UidMap> clazz = UidMap.class;
        synchronized (UidMap.class) {
            String strUid = mUidToStringMap.get(iUid);
            // ** MonitorExit[var3_1] (shouldn't be in output)
            return strUid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLongUid(String strUid) {
        long iUid = 0L;
        Class<UidMap> clazz = UidMap.class;
        synchronized (UidMap.class) {
            if (strUid != null && strUid.length() != 0) {
                for (Long key : mUidToStringMap.keySet()) {
                    if (!strUid.equals(mUidToStringMap.get(key))) continue;
                    iUid = key;
                    break;
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (iUid == 0L && UidMap.isNumeric(strUid)) {
                try {
                    iUid = Long.parseLong(strUid, 10);
                }
                catch (NumberFormatException exception) {
                    iUid = 0L;
                }
            }
            return iUid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUid2String(long iUid) {
        Class<UidMap> clazz = UidMap.class;
        synchronized (UidMap.class) {
            mUidToStringMap.remove(iUid);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUid2String(String strUid) {
        Class<UidMap> clazz = UidMap.class;
        synchronized (UidMap.class) {
            if (strUid != null && strUid.length() != 0) {
                for (Long key : mUidToStringMap.keySet()) {
                    if (!strUid.equals(mUidToStringMap.get(key))) continue;
                    mUidToStringMap.remove(key);
                    break;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllUid2String() {
        Class<UidMap> clazz = UidMap.class;
        synchronized (UidMap.class) {
            mUidToStringMap.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isNumeric(String strNum) {
        String bigStr;
        Pattern pattern = Pattern.compile("^\\d+$");
        try {
            bigStr = new BigDecimal(strNum).toString();
        }
        catch (Exception e) {
            return false;
        }
        Matcher isNum = pattern.matcher(bigStr);
        return isNum.matches();
    }
}

